/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Direction;
import com.zarkonnen.airships.Foot;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.SoundEffect;
import com.zarkonnen.airships.Spring;
import com.zarkonnen.catengine.Img;
import java.util.ArrayList;

public strictfp class Leg {
    public Airship ship;
    public Module module;
    public final Spec spec;
    public double upperRotation;
    public double lowerRotation;
    public Foot foot;
    public double targetFootX = 0.0;
    public double targetFootY = -1.0E8;
    public double sourceFootX;
    public double sourceFootY;
    public double footLerpAmt = 0.0;
    public double prevStepShipX = -1.0E7;
    public transient boolean isDown;

    public Leg(Spec spec, Airship ship, Module module) {
        this.spec = spec;
        this.ship = ship;
        this.module = module;
        this.foot = new Foot(ship, this, 0.0, 0.0, spec.footWidth, spec.footHeight);
        this.upperRotation = 1.5707963267948966 + (spec.bendForwards ? -0.7853981633974483 : 0.7853981633974483);
        this.lowerRotation = 1.5707963267948966 - (spec.bendForwards ? -1.0471975511965976 : 1.0471975511965976);
    }

    public double hipX() {
        double mx = this.ship.getX() + (double)(this.ship.gridXToWorldX(this.module.x, this.module.type.getW()) * 16);
        return this.ship.flipped ? mx + ((double)this.module.type.getW() - this.spec.xOffset) * 16.0 : mx + this.spec.xOffset * 16.0;
    }

    public double hipY() {
        double my = this.ship.getY() + (double)(this.module.y * 16) + (double)(this.module.type.getH() * 16);
        return my + this.spec.yOffset * 16.0;
    }

    public double footX() {
        return this.hipX() + StrictMath.cos(this.upperRotation) * this.spec.upperLimbLength + (double)(this.ship.flipped ^ this.spec.bendForwards ? 1 : -1) * this.spec.middleLimbLength + StrictMath.cos(this.lowerRotation) * this.spec.lowerLimbLength;
    }

    public double footY() {
        return this.hipY() + StrictMath.sin(this.upperRotation) * this.spec.upperLimbLength + StrictMath.sin(this.lowerRotation) * this.spec.lowerLimbLength + this.spec.footHeight;
    }

    public double getGroundY(LandFormation ground, ArrayList<LandFormation> lfs, double x) {
        double y = -1600.0;
        if (ground != null) {
            y = StrictMath.max(y, ground.yBoundaryAt(x));
        }
        if (lfs != null) {
            for (LandFormation lf : lfs) {
                y = StrictMath.max(y, lf.yBoundaryAt(x));
            }
        }
        return y;
    }

    public boolean legRotation(double footX, double footY, boolean set) {
        footX -= this.hipX() + (double)(this.ship.flipped ^ this.spec.bendForwards ? 1 : -1) * this.spec.middleLimbLength;
        if ((footY -= this.spec.footHeight + this.hipY()) < this.spec.minFootY) {
            return false;
        }
        double d = StrictMath.sqrt(footX * footX + footY * footY);
        double baseAngle = Direction.radiansFromTo(0.0, 0.0, footX, footY);
        double ur = Direction.normalizeRadians(baseAngle + (double)(this.spec.bendForwards ^ this.ship.flipped ? -1 : 1) * StrictMath.acos((d * d + this.spec.upperLimbLength * this.spec.upperLimbLength - this.spec.lowerLimbLength * this.spec.lowerLimbLength) / (2.0 * d * this.spec.upperLimbLength)));
        double lr = Direction.normalizeRadians(ur - Math.PI + (double)(this.spec.bendForwards ^ this.ship.flipped ? -1 : 1) * StrictMath.acos((this.spec.upperLimbLength * this.spec.upperLimbLength + this.spec.lowerLimbLength * this.spec.lowerLimbLength - d * d) / (2.0 * this.spec.upperLimbLength * this.spec.lowerLimbLength)));
        if (!Double.isNaN(ur) && !Double.isNaN(lr)) {
            if (set) {
                this.upperRotation = ur;
                this.lowerRotation = lr;
            }
            this.foot.setX(this.footX() - this.spec.footWidth / 2.0);
            this.foot.setY(this.footY() - this.spec.footHeight);
            return true;
        }
        this.foot.setX(this.footX() - this.spec.footWidth / 2.0);
        this.foot.setY(this.footY() - this.spec.footHeight);
        return false;
    }

    public boolean lerpFoot(int ms, Combat c, boolean onViewingSide) {
        double footY;
        double footX;
        double prevFLA = this.footLerpAmt;
        double totalLerpMs = StrictMath.max(100.0, StrictMath.min(StrictMath.abs(this.sourceFootX - this.targetFootX) / (StrictMath.abs(this.ship.getxSpeed()) + 0.001) / (double)this.module.legs.size(), (double)this.spec.maxStepTime));
        double lerpTime = (double)ms / totalLerpMs;
        this.footLerpAmt = StrictMath.min(1.0, this.footLerpAmt + lerpTime);
        double prevFootX = this.footX();
        double prevFootY = this.footY();
        double apexY = StrictMath.min(this.sourceFootY, this.targetFootY) - this.spec.upperLimbLength / 12.0 - this.spec.lowerLimbLength / 12.0;
        if (this.footLerpAmt < 0.3) {
            footX = this.sourceFootX;
            footY = this.sourceFootY * (1.0 - this.footLerpAmt / 0.3) + apexY * this.footLerpAmt / 0.3;
        } else if (this.footLerpAmt < 0.8) {
            footX = this.sourceFootX * (1.0 - (this.footLerpAmt - 0.3) / 0.5) + this.targetFootX * (this.footLerpAmt - 0.3) / 0.5;
            footY = apexY;
        } else {
            footX = this.targetFootX;
            footY = apexY * (1.0 - (this.footLerpAmt - 0.8) / 0.2) + this.targetFootY * (this.footLerpAmt - 0.8) / 0.2;
        }
        boolean legRotationSuccess = this.legRotation(footX, footY, true);
        if (!legRotationSuccess && !(legRotationSuccess = this.legRotation(footX, footY = this.sourceFootY * (1.0 - this.footLerpAmt) + this.targetFootY * this.footLerpAmt, true))) {
            footY = StrictMath.min(this.sourceFootY, this.targetFootY);
            legRotationSuccess = this.legRotation(footX, footY, true);
        }
        this.foot.setxSpeed((footX - prevFootX) / (double)ms / 20.0);
        this.foot.setySpeed((footY - prevFootY) / (double)ms / 20.0 + (this.footLerpAmt == 1.0 ? 0.001 * (double)ms : 0.0));
        this.foot.isDown = this.footLerpAmt >= 0.8 && legRotationSuccess;
        int n = this.foot.hasStomped = this.footLerpAmt == 1.0 && legRotationSuccess && prevFLA != this.footLerpAmt ? 3 : 0;
        if (this.foot.hasStomped == 3 && c != null && this.spec.footDownSound != null) {
            c.play(this.spec.footDownSound, footX, footY, 0.0, 0.0, onViewingSide);
        }
        return this.footLerpAmt == 1.0;
    }

    /*
     * Unable to fully structure code
     */
    public boolean findStepTarget(LandFormation ground, ArrayList<LandFormation> lfs) {
        if (this.ship.getxSpeed() > 0.0) {
            newX = StrictMath.max(this.hipX() + (double)((this.ship.flipped ^ this.spec.bendForwards) != false ? 1 : -1) * this.spec.middleLimbLength, this.targetFootX) + (double)(this.spec.stepLength * 2);
            while (true) {
                v0 = this.hipX();
                v1 = (this.ship.flipped ^ this.spec.bendForwards) != false ? 1 : -1;
                if (newX > v0 + (double)v1 * this.spec.middleLimbLength) {
                    if (this.ship.moveTo == null || !(newX > this.hipX() - this.ship.getX() + this.ship.moveTo.x)) {
                        newY = this.getGroundY(ground, lfs, newX);
                        if (this.module.legs.size() == 2) {
                            other = this.module.legs.get((this.module.legs.indexOf(this) + 1) % 2);
                            if (!(StrictMath.abs(other.footX() - newX) > (double)(this.spec.stepLength * 2) && StrictMath.abs(other.footX() - newX) <= (double)(this.spec.stepLength * 2) || other.footX() < other.hipX() - (double)(this.spec.stepLength * 2) && newX > this.hipX() - (double)this.spec.stepLength)) {
                                if (other.footX() < other.hipX() - (double)(this.spec.stepLength * 2) && this.footX() > this.hipX() - (double)this.spec.stepLength * 1.9) {
                                    return false;
                                } else {
                                    ** GOTO lbl-1000
                                }
                            }
                        } else if (this.legRotation(newX, newY, false)) {
                            this.sourceFootX = this.footX();
                            this.sourceFootY = this.footY();
                            this.targetFootX = newX;
                            this.targetFootY = newY;
                            this.footLerpAmt = 0.0;
                            this.prevStepShipX = this.ship.getX();
                            return true;
                        }
                    }
                    newX -= 4.0;
                    continue;
                }
                break;
            }
        } else if (this.ship.getxSpeed() < 0.0) {
            newX = StrictMath.min(this.hipX() + (double)((this.ship.flipped ^ this.spec.bendForwards) != false ? 1 : -1) * this.spec.middleLimbLength, this.targetFootX) - (double)(this.spec.stepLength * 2);
            while (true) {
                v2 = this.hipX();
                v3 = (this.ship.flipped ^ this.spec.bendForwards) != false ? 1 : -1;
                if (!(newX < v2 + (double)v3 * this.spec.middleLimbLength)) break;
                if (this.ship.moveTo == null || !(newX < this.hipX() - this.ship.getX() + this.ship.moveTo.x)) {
                    newY = this.getGroundY(ground, lfs, newX);
                    if (this.module.legs.size() == 2) {
                        other = this.module.legs.get((this.module.legs.indexOf(this) + 1) % 2);
                        if (!(StrictMath.abs(other.footX() - newX) > (double)(this.spec.stepLength * 2) && StrictMath.abs(other.footX() - newX) <= (double)(this.spec.stepLength * 2) || other.footX() > other.hipX() + (double)(this.spec.stepLength * 2) && newX < this.hipX() + (double)this.spec.stepLength)) {
                            if (other.footX() > other.hipX() + (double)(this.spec.stepLength * 2) && this.footX() < this.hipX() + (double)this.spec.stepLength * 1.9) {
                                return false;
                            } else {
                                ** GOTO lbl-1000
                            }
                        }
                    } else if (this.legRotation(newX, newY, false)) {
                        this.sourceFootX = this.footX();
                        this.sourceFootY = this.footY();
                        this.targetFootX = newX;
                        this.targetFootY = newY;
                        this.footLerpAmt = 0.0;
                        this.prevStepShipX = this.ship.getX();
                        return true;
                    }
                }
                newX += 4.0;
            }
        }
        return false;
    }

    public void findFootTarget(LandFormation ground, ArrayList<LandFormation> lfs) {
        block5: {
            block6: {
                if (this.module.legs.size() <= 2) break block6;
                ArrayList<Double> availableXs = new ArrayList<Double>();
                double searchStart = this.spec.bendForwards ^ this.ship.flipped ? this.hipX() + this.spec.middleLimbLength : this.hipX() - this.spec.upperLimbLength - this.spec.lowerLimbLength - this.spec.middleLimbLength;
                double searchEnd = this.spec.bendForwards ^ this.ship.flipped ? this.hipX() + this.spec.upperLimbLength + this.spec.lowerLimbLength + this.spec.middleLimbLength : this.hipX() - this.spec.middleLimbLength;
                for (double newX = searchStart; newX < searchEnd; newX += 4.0) {
                    double newY = this.getGroundY(ground, lfs, newX);
                    if (!this.legRotation(newX, newY, false)) continue;
                    availableXs.add(newX);
                }
                if (availableXs.isEmpty()) break block5;
                this.sourceFootX = this.footX();
                this.sourceFootY = this.footY();
                this.targetFootX = (Double)availableXs.get(availableXs.size() / 2);
                this.targetFootY = this.getGroundY(ground, lfs, this.targetFootX);
                this.footLerpAmt = 0.0;
                break block5;
            }
            if (this.spec.bendForwards ^ this.ship.flipped) {
                for (double newX = this.hipX() + this.spec.middleLimbLength; newX < this.hipX() + this.spec.upperLimbLength + this.spec.lowerLimbLength + this.spec.middleLimbLength; newX += 4.0) {
                    double newY = this.getGroundY(ground, lfs, newX);
                    if (!this.legRotation(newX, newY, false)) continue;
                    this.sourceFootX = this.footX();
                    this.sourceFootY = this.footY();
                    this.targetFootX = newX;
                    this.targetFootY = newY;
                    this.footLerpAmt = 0.0;
                    break;
                }
            } else {
                for (double newX = this.hipX() - this.spec.middleLimbLength; newX > this.hipX() - this.spec.upperLimbLength - this.spec.lowerLimbLength - this.spec.middleLimbLength; newX -= 4.0) {
                    double newY = this.getGroundY(ground, lfs, newX);
                    if (!this.legRotation(newX, newY, false)) continue;
                    this.sourceFootX = this.footX();
                    this.sourceFootY = this.footY();
                    this.targetFootX = newX;
                    this.targetFootY = newY;
                    this.footLerpAmt = 0.0;
                    break;
                }
            }
        }
    }

    public void reset(LandFormation ground, ArrayList<LandFormation> lfs) {
        this.findFootTarget(ground, lfs);
        this.sourceFootX = this.targetFootX;
        this.sourceFootY = this.targetFootY;
        this.footLerpAmt = 1.0;
        this.legRotation(this.targetFootX, this.targetFootY, true);
    }

    public boolean tick(int ms, LandFormation ground, ArrayList<LandFormation> lfs, boolean doStep, Combat c, boolean powered, boolean onViewingSide) {
        double yForTargetFootX = this.getGroundY(ground, lfs, this.targetFootX);
        if (doStep && this.footLerpAmt == 1.0 && StrictMath.abs(this.prevStepShipX - this.ship.getX()) > 8.0) {
            if (this.findStepTarget(ground, lfs) && c != null && this.spec.beginStepSound != null) {
                c.play(this.spec.beginStepSound, this.hipX(), this.hipY(), 0.0, 0.0, onViewingSide);
            }
        } else if (StrictMath.abs(yForTargetFootX - this.targetFootY) > 1.0 || !this.legRotation(this.targetFootX, this.targetFootY, false)) {
            this.findFootTarget(ground, lfs);
        }
        if (this.isDown = this.lerpFoot(ms, c, onViewingSide)) {
            double hDist;
            double springDist = this.getGroundY(ground, lfs, this.targetFootX) - this.hipY();
            double totalDist = StrictMath.sqrt(springDist * springDist + (hDist = StrictMath.max(0.0, StrictMath.abs(this.footX() - this.hipX()) - this.spec.middleLimbLength * 1.5)) * hDist);
            if (totalDist <= (double)this.spec.spring.baseLength) {
                double springForce = StrictMath.max(0.0, this.spec.spring.getForce(springDist) * this.ship.legBalanceFactor);
                if (this.ship.legBalanceFactor < 0.65) {
                    this.ship.reportFootingLoss = true;
                }
                if (!powered) {
                    springForce *= 0.25;
                }
                this.ship.setyForce(this.ship.getyForce() - springForce);
                double fMult = this.ship.hasHadSpringFriction ? 0.1 : 1.0;
                this.ship.hasHadSpringFriction = true;
                double xFriction = StrictMath.pow(1.0 - this.spec.spring.xFriction * fMult, ms);
                this.ship.setxSpeed(this.ship.getxSpeed() * xFriction);
                double yFriction = StrictMath.pow(1.0 - this.spec.spring.yFriction * fMult, ms);
                this.ship.setySpeed(this.ship.getySpeed() * yFriction);
            }
            return doStep;
        }
        return false;
    }

    public strictfp static class Spec {
        public final boolean back;
        public final double xOffset;
        public final double yOffset;
        public final double upperLimbLength;
        public final double middleLimbLength;
        public final double lowerLimbLength;
        public final double footWidth;
        public final double footHeight;
        public final int stepLength;
        public final int maxStepTime;
        public final boolean bendForwards;
        public final Spring spring;
        public final Img upperLeg;
        public final Img middleLeg;
        public final Img lowerLeg;
        public final Img foot;
        public final SoundEffect beginStepSound;
        public final SoundEffect footDownSound;
        public final double minFootY;
        public ArrayList<ModuleType.FragmentImg> upperLegFrag = new ArrayList();
        public ArrayList<ModuleType.FragmentImg> middleLegFrag = new ArrayList();
        public ArrayList<ModuleType.FragmentImg> lowerLegFrag = new ArrayList();
        public ArrayList<ModuleType.FragmentImg> footFrag = new ArrayList();

        public Spec(boolean back, double xOffset, double yOffset, double upperLimbLength, double middleLimbLength, double lowerLimbLength, double footWidth, double footHeight, int stepLength, int maxStepTime, boolean bendForwards, Spring spring, Img upperLeg, Img middleLeg, Img lowerLeg, Img foot, SoundEffect beginStepSound, SoundEffect footDownSound, double minFootY) {
            this.back = back;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.upperLimbLength = upperLimbLength;
            this.middleLimbLength = middleLimbLength;
            this.lowerLimbLength = lowerLimbLength;
            this.footWidth = footWidth;
            this.footHeight = footHeight;
            this.stepLength = stepLength;
            this.maxStepTime = maxStepTime;
            this.bendForwards = bendForwards;
            this.spring = spring;
            this.upperLeg = upperLeg;
            this.middleLeg = middleLeg;
            this.lowerLeg = lowerLeg;
            this.foot = foot;
            this.beginStepSound = beginStepSound;
            this.footDownSound = footDownSound;
            this.minFootY = minFootY;
        }
    }
}

