/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.json.JSONObject;
import org.json.JSONTokener;

public strictfp class LaunchSettings {
    public static boolean forceSystemCursor;
    public static boolean useCustomWindow;
    public static boolean customWindowFullscreen;
    public static boolean customWindowBorderless;
    public static int customWindowX;
    public static int customWindowY;
    public static int customWindowW;
    public static int customWindowH;
    public static boolean customWindowUseSimpleGraphics;
    public static String customMultiplayerServerAddress;
    public static String customDataDirectoryLocation;
    public static int maxGIFSizeMB;
    public static String customGIFSaveDirectoryLocation;
    public static int maxNetworkSendBytes;
    public static int measureNetworkDelayEveryMilliseconds;
    public static int minimumLagReconnectInterval;
    public static int tooMuchNetworkDelayMilliseconds;
    public static int tooMuchNetworkDelayMillisecondsOnReconnect;
    public static int reconnectAttemptIntervalMilliseconds;
    public static int maxReconnectAttempts;
    public static boolean allowMacSteamIntegration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        customWindowW = 800;
        customWindowH = 600;
        maxGIFSizeMB = 15;
        maxNetworkSendBytes = 50000;
        measureNetworkDelayEveryMilliseconds = 3000;
        minimumLagReconnectInterval = 7000;
        tooMuchNetworkDelayMilliseconds = 3000;
        tooMuchNetworkDelayMillisecondsOnReconnect = 6000;
        reconnectAttemptIntervalMilliseconds = 5000;
        maxReconnectAttempts = 10;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(AGame.getStaticGameDirectory(), "launch_settings.json")), "UTF-8"));
            JSONObject cfg = new JSONObject(new JSONTokener(br));
            forceSystemCursor = cfg.optBoolean("forceSystemCursor", false);
            useCustomWindow = cfg.optBoolean("useCustomWindow", false);
            customWindowFullscreen = cfg.optBoolean("customWindowFullscreen", false);
            customWindowBorderless = cfg.optBoolean("customWindowBorderless", false);
            customWindowX = cfg.optInt("customWindowX", 0);
            customWindowY = cfg.optInt("customWindowY", 0);
            customWindowW = cfg.optInt("customWindowW", 800);
            customWindowH = cfg.optInt("customWindowH", 600);
            customWindowUseSimpleGraphics = cfg.optBoolean("customWindowUseSimpleGraphics", false);
            customMultiplayerServerAddress = cfg.optString("customMultiplayerServerAddress", null);
            customDataDirectoryLocation = cfg.optString("customDataDirectoryLocation", null);
            maxGIFSizeMB = StrictMath.max(2, cfg.optInt("maxGIFSizeMB", 15));
            customGIFSaveDirectoryLocation = cfg.optString("customGIFSaveDirectoryLocation", null);
            maxNetworkSendBytes = cfg.optInt("maxNetworkSendBytes", 50000);
            measureNetworkDelayEveryMilliseconds = cfg.optInt("measureNetworkDelayEveryMilliseconds", 3000);
            tooMuchNetworkDelayMilliseconds = Math.max(500, cfg.optInt("tooMuchNetworkDelayMilliseconds", 3000));
            tooMuchNetworkDelayMillisecondsOnReconnect = Math.max(500, cfg.optInt("tooMuchNetworkDelayMillisecondsOnReconnect", 3000));
            allowMacSteamIntegration = cfg.optBoolean("allowMacSteamIntegration", false);
            reconnectAttemptIntervalMilliseconds = cfg.optInt("reconnectAttemptIntervalMilliseconds", 5000);
            maxReconnectAttempts = cfg.optInt("maxReconnectAttempts", 10);
            minimumLagReconnectInterval = cfg.optInt("minimumLagReconnectInterval", 7000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }
}

