/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.MultiResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.PropertyResourceBundle;

public strictfp class Lang {
    public static Locale currentLocale = Lang.getBestLocalLocale();
    public static MultiResourceBundle bundle = null;
    public static MultiResourceBundle enBundle = null;
    public static Locale currentAltLocale = null;
    public static MultiResourceBundle currentAltBundle = null;

    public static void setCurrentLocale(Locale l) {
        if (Lang.availableLocales().contains(l)) {
            currentLocale = l;
            bundle = null;
            currentAltLocale = null;
            currentAltBundle = null;
            Airship.nt = "[bb421d]" + Lang._t("No_target_available", new Object[0]);
        }
    }

    private static String getString(String key) {
        if (bundle == null) {
            bundle = Lang.loadBundle(currentLocale.toLanguageTag());
        }
        if (enBundle == null) {
            enBundle = Lang.loadBundle("en");
        }
        return bundle.containsKey(key) ? bundle.getString(key) : (enBundle.containsKey(key) ? enBundle.getString(key) : null);
    }

    private static String getLocaleString(Locale l, String key) {
        if (currentAltLocale == null || !currentAltLocale.equals(l)) {
            currentAltLocale = l;
            currentAltBundle = Lang.loadBundle(l.toLanguageTag());
        }
        return currentAltBundle.containsKey(key) ? currentAltBundle.getString(key) : (enBundle.containsKey(key) ? enBundle.getString(key) : null);
    }

    public static void reloadBundle() {
        bundle = Lang.loadBundle(currentLocale.toLanguageTag());
        enBundle = Lang.loadBundle("en");
        currentAltLocale = null;
        currentAltBundle = null;
    }

    private static MultiResourceBundle loadBundle(String lang) {
        MultiResourceBundle mrb = Lang.loadBaseBundle(lang);
        if (mrb == null) {
            return null;
        }
        for (Mod m : Mod.getEnabledMods()) {
            File bundleF;
            if (m.loadFailed || !(bundleF = new File(new File(m.dir, "strings"), lang + ".properties")).exists()) continue;
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(bundleF), "UTF-8"));
                mrb.add(new PropertyResourceBundle(r));
                r.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mrb;
    }

    private static MultiResourceBundle loadBaseBundle(String lang) {
        MultiResourceBundle mrb = null;
        File bundleF = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "lang"), lang + ".properties");
        if (!bundleF.exists()) {
            for (Mod m : Mod.getEnabledMods()) {
                if (m.loadFailed || !(bundleF = new File(new File(m.dir, "translations"), currentLocale.toLanguageTag() + ".properties")).exists()) continue;
                break;
            }
        }
        if (!bundleF.exists()) {
            return null;
        }
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(bundleF), "UTF-8"));
            mrb = new MultiResourceBundle(new PropertyResourceBundle(r));
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mrb;
    }

    public static String _t(String key, Object ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            if (!(arguments[i] instanceof Integer)) continue;
            arguments[i] = ((Integer)arguments[i]).toString();
        }
        String value = Lang.getString(key);
        if (value == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[RED]? ");
            sb.append(key);
            sb.append(": ");
            for (Object o : arguments) {
                sb.append(o.toString().replaceAll("\\[|\\]|\\{\\}", ""));
                sb.append(", ");
            }
            sb.append("[]");
            return sb.toString();
        }
        try {
            return new MessageFormat(Lang.getString(key), currentLocale).format(arguments).replace("QUOTE", "'");
        }
        catch (Exception e) {
            return key + " (ERROR: BAD FORMAT)";
        }
    }

    public static String _tWithFallback(String key, String altKey, Object ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            if (!(arguments[i] instanceof Integer)) continue;
            arguments[i] = ((Integer)arguments[i]).toString();
        }
        String value = Lang.getString(key);
        if (value == null) {
            return Lang._t(altKey, arguments);
        }
        try {
            return new MessageFormat(Lang.getString(key), currentLocale).format(arguments).replace("QUOTE", "'");
        }
        catch (Exception e) {
            return key + " (ERROR: BAD FORMAT)";
        }
    }

    public static String localeT(Locale l, String key, Object ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            if (!(arguments[i] instanceof Integer)) continue;
            arguments[i] = ((Integer)arguments[i]).toString();
        }
        String value = Lang.getLocaleString(l, key);
        if (value == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[RED]? ");
            sb.append(key);
            sb.append(": ");
            for (Object o : arguments) {
                sb.append(o.toString().replaceAll("\\[|\\]|\\{\\}", ""));
                sb.append(", ");
            }
            sb.append("[]");
            return sb.toString();
        }
        try {
            String s = Lang.getLocaleString(l, key);
            return new MessageFormat(s, currentAltLocale).format(arguments).replace("QUOTE", "'");
        }
        catch (Exception e) {
            AirshipGame.instance.reportError("Alt locale translation fail", e, key, false, true);
            return key;
        }
    }

    public static ArrayList<Locale> availableLocales() {
        ArrayList<Locale> ls = new ArrayList<Locale>();
        File langDir = new File(new File(AGame.getStaticGameDirectory(), "data"), "lang");
        File[] fs = langDir.listFiles();
        if (fs == null) {
            throw new RuntimeException("Cannot load languages from " + langDir.getAbsolutePath());
        }
        for (File f : fs) {
            Locale l;
            if (!f.getName().endsWith(".properties") || (l = Locale.forLanguageTag(f.getName().substring(0, f.getName().length() - ".properties".length()))) == null) continue;
            ls.add(l);
        }
        for (Mod m : Mod.getEnabledMods()) {
            if (m.loadFailed || !new File(m.dir, "translations").exists()) continue;
            for (File f : new File(m.dir, "translations").listFiles()) {
                Locale l;
                if (!f.getName().endsWith(".properties") || (l = Locale.forLanguageTag(f.getName().substring(0, f.getName().length() - ".properties".length()))) == null) continue;
                ls.add(l);
            }
        }
        return ls;
    }

    public static Locale getBestLocalLocale() {
        Locale loc = Locale.getDefault();
        ArrayList<Locale> ls = Lang.availableLocales();
        if (ls.contains(loc)) {
            return loc;
        }
        if (ls.contains(loc = new Locale(loc.getLanguage()))) {
            return loc;
        }
        return Locale.ENGLISH;
    }
}

