/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.ExternalApp;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.SoundEffect;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class LandBlockType
extends Loadable {
    public final boolean landFormationRemoveStopper;
    public final boolean canPlace;
    public final boolean canPlaceInMissionEditor;
    public final boolean canOverhang;
    public final int addCost;
    public final int removeCost;
    public final boolean solid;
    public final boolean opaque;
    public final double damageMultiplier;
    public final int hp;
    public final int armour;
    public final int weight;
    public final int liftGenerated;
    public final ParticleType destroyparticle;
    public final SoundEffect destroySound;
    public final Appearance app;
    public final Appearance topSnowApp;
    public final Appearance snowApp;
    public final ExternalApp externalApp;
    public final ExternalApp externalSnowApp;
    public final boolean externalDrawPriority;
    public final Particle.Emitter particleEmitter;
    public final Particle.Emitter snowParticleEmitter;
    public static final HashMap<Integer, LandBlockType> OLD_MAPPING = new HashMap();
    public static final HashMap<Integer, LandBlockType> V_1_0_10_MAPPING = new HashMap();
    public static final HashMap<Integer, LandBlockType> CURRENT_MAPPING = new HashMap();

    public LandBlockType(JSONObject o) {
        super(o.getString("name"), o.optInt("sort", 0));
        JSONObject ea;
        String sound;
        SoundEffect ef;
        JSONObject pe;
        this.landFormationRemoveStopper = o.optBoolean("landFormationRemoveStopper");
        this.canPlace = o.optBoolean("canPlace", false);
        this.canPlaceInMissionEditor = o.optBoolean("canPlaceInMissionEditor", false);
        this.canOverhang = o.optBoolean("canOverhang", false);
        this.removeCost = o.getInt("removeCost");
        this.addCost = o.getInt("addCost");
        this.solid = o.optBoolean("solid", true);
        this.opaque = o.optBoolean("opaque", true);
        this.damageMultiplier = o.getDouble("damageMultiplier");
        this.hp = StrictMath.max(0, StrictMath.min(35, o.getInt("hp")));
        this.armour = o.getInt("armour");
        this.weight = o.getInt("weight");
        this.liftGenerated = o.optInt("liftGenerated", 0);
        this.destroyparticle = o.has("destroyParticle") ? ParticleType.ofName(o.getString("destroyParticle")) : null;
        SoundEffect ds = null;
        if (o.has("destroySound")) {
            try {
                ds = new SoundEffect(o.getString("destroySound"), o.optInt("numDestroySounds", 1));
            }
            catch (Exception e) {
                ds = new SoundEffect(o.getJSONObject("destroySound"));
            }
        }
        this.destroySound = ds;
        this.app = o.has("appearance") ? new Appearance(o.getJSONObject("appearance")) : null;
        this.topSnowApp = o.has("topSnowAppearance") ? new Appearance(o.getJSONObject("topSnowAppearance")) : null;
        this.snowApp = o.has("snowAppearance") ? new Appearance(o.getJSONObject("snowAppearance")) : null;
        if (o.has("particleEmitter")) {
            pe = o.getJSONObject("particleEmitter");
            ef = null;
            if (pe.has("sound")) {
                try {
                    sound = pe.getString("sound");
                    ef = new SoundEffect(sound, pe.optDouble("volume"));
                }
                catch (Exception e) {
                    ef = new SoundEffect(pe.getJSONObject("sound"));
                }
            }
            this.particleEmitter = new Particle.Emitter(ParticleType.ofName(pe.getString("type")), pe.getDouble("emitProbability"), pe.optInt("numParticles", 1), ef);
        } else {
            this.particleEmitter = null;
        }
        if (o.has("snowParticleEmitter")) {
            pe = o.getJSONObject("snowParticleEmitter");
            ef = null;
            if (pe.has("sound")) {
                try {
                    sound = pe.getString("sound");
                    ef = new SoundEffect(sound, pe.optDouble("volume"));
                }
                catch (Exception e) {
                    ef = new SoundEffect(pe.getJSONObject("sound"));
                }
            }
            this.snowParticleEmitter = new Particle.Emitter(ParticleType.ofName(pe.getString("type")), pe.getDouble("emitProbability"), pe.optInt("numParticles", 1), ef);
        } else {
            this.snowParticleEmitter = null;
        }
        if (o.has("externalApp")) {
            ea = o.getJSONObject("externalApp");
            this.externalApp = new ExternalApp(new Appearance(ea.getJSONObject("appearance")), ea.optInt("x"), ea.optInt("y"));
        } else {
            this.externalApp = null;
        }
        if (o.has("externalSnowApp")) {
            ea = o.getJSONObject("externalSnowApp");
            this.externalSnowApp = new ExternalApp(new Appearance(ea.getJSONObject("appearance")), ea.optInt("x"), ea.optInt("y"));
        } else {
            this.externalSnowApp = this.externalApp;
        }
        this.externalDrawPriority = o.optBoolean("externalDrawPriority", false);
    }

    public String getName() {
        return Lang._t(this.name, new Object[0]);
    }

    public static LandBlockType ofName(String name) {
        return Loadable.ofName(LandBlockType.class, name);
    }

    public static HashMap<Integer, LandBlockType> getMapping(JSONObject o) {
        if (o.has("landBlockMapping")) {
            System.err.println("Load mapping.");
            HashMap<Integer, LandBlockType> mapping = new HashMap<Integer, LandBlockType>();
            JSONArray ma = o.getJSONArray("landBlockMapping");
            for (int i = 0; i < ma.length(); i += 2) {
                mapping.put(ma.getInt(i), LandBlockType.ofName(ma.getString(i + 1)));
            }
            return mapping;
        }
        return null;
    }

    public static void writeMapping(JSONObject o) {
        JSONArray ma = new JSONArray();
        o.put("landBlockMapping", ma);
        ArrayList<LandBlockType> lbts = Loadable.all(LandBlockType.class);
        for (int i = 0; i < lbts.size(); ++i) {
            ma.put(i);
            ma.put(lbts.get((int)i).name);
        }
    }

    public static void postLoad() {
        OLD_MAPPING.clear();
        OLD_MAPPING.put(0, LandBlockType.ofName("AIR"));
        OLD_MAPPING.put(1, LandBlockType.ofName("BEDROCK"));
        OLD_MAPPING.put(2, LandBlockType.ofName("BRANCH"));
        OLD_MAPPING.put(3, LandBlockType.ofName("BUSH"));
        OLD_MAPPING.put(4, LandBlockType.ofName("GRASS"));
        OLD_MAPPING.put(5, LandBlockType.ofName("LEAF"));
        OLD_MAPPING.put(6, LandBlockType.ofName("ROCK"));
        OLD_MAPPING.put(7, LandBlockType.ofName("SOIL"));
        OLD_MAPPING.put(8, LandBlockType.ofName("SUSPENDIUM_ORE"));
        OLD_MAPPING.put(9, LandBlockType.ofName("TRUNK"));
        OLD_MAPPING.put(10, LandBlockType.ofName("TRUNKBRANCH"));
        OLD_MAPPING.put(11, LandBlockType.ofName("CROWN"));
        OLD_MAPPING.put(12, LandBlockType.ofName("FLOATER_BOTTOM"));
        OLD_MAPPING.put(13, LandBlockType.ofName("FLOATER_DOWN"));
        OLD_MAPPING.put(14, LandBlockType.ofName("FLOATER_DOWNER"));
        OLD_MAPPING.put(15, LandBlockType.ofName("FLOATER_DOWNER_ROCK"));
        OLD_MAPPING.put(16, LandBlockType.ofName("FLOATER_DOWNER_SUSPENDIUM"));
        OLD_MAPPING.put(17, LandBlockType.ofName("FLOATER_MIDDLE"));
        OLD_MAPPING.put(18, LandBlockType.ofName("FLOATER_TOP"));
        OLD_MAPPING.put(19, LandBlockType.ofName("FLOATER_TOP_POPPIES"));
        OLD_MAPPING.put(20, LandBlockType.ofName("FLOATER_TOP_SUSPENDIUM"));
        OLD_MAPPING.put(21, LandBlockType.ofName("FLOATER_TOP_VINE"));
        OLD_MAPPING.put(22, LandBlockType.ofName("FLOATER_UP"));
        OLD_MAPPING.put(23, LandBlockType.ofName("GRASS_FENCES"));
        OLD_MAPPING.put(24, LandBlockType.ofName("GRASS_FLOATPLANT"));
        OLD_MAPPING.put(25, LandBlockType.ofName("GRASS_GRAVESTONE"));
        OLD_MAPPING.put(26, LandBlockType.ofName("GRASS_POPPIES"));
        OLD_MAPPING.put(27, LandBlockType.ofName("GRASS_ROCK"));
        OLD_MAPPING.put(28, LandBlockType.ofName("GRASS_RUIN"));
        OLD_MAPPING.put(29, LandBlockType.ofName("GRASS_SIGNPOST"));
        OLD_MAPPING.put(30, LandBlockType.ofName("GRASS_SUSPENDIUM"));
        OLD_MAPPING.put(31, LandBlockType.ofName("GRASS_TROUGH"));
        OLD_MAPPING.put(32, LandBlockType.ofName("GRASS_WOOD_PILE"));
        OLD_MAPPING.put(33, LandBlockType.ofName("ROOTS"));
        OLD_MAPPING.put(34, LandBlockType.ofName("SMALL_CROWN"));
        OLD_MAPPING.put(35, LandBlockType.ofName("THIN_TRUNK"));
        V_1_0_10_MAPPING.clear();
        V_1_0_10_MAPPING.put(0, LandBlockType.ofName("AIR"));
        V_1_0_10_MAPPING.put(1, LandBlockType.ofName("GRASS"));
        V_1_0_10_MAPPING.put(2, LandBlockType.ofName("STONE_TOP"));
        V_1_0_10_MAPPING.put(3, LandBlockType.ofName("STONE_MIDDLE"));
        V_1_0_10_MAPPING.put(4, LandBlockType.ofName("SOIL"));
        V_1_0_10_MAPPING.put(5, LandBlockType.ofName("ROCK"));
        V_1_0_10_MAPPING.put(6, LandBlockType.ofName("SUSPENDIUM_ORE"));
        V_1_0_10_MAPPING.put(7, LandBlockType.ofName("BEDROCK"));
        V_1_0_10_MAPPING.put(8, LandBlockType.ofName("BUSH"));
        V_1_0_10_MAPPING.put(9, LandBlockType.ofName("ROOTS"));
        V_1_0_10_MAPPING.put(10, LandBlockType.ofName("TRUNK"));
        V_1_0_10_MAPPING.put(11, LandBlockType.ofName("CROWN"));
        V_1_0_10_MAPPING.put(12, LandBlockType.ofName("THIN_TRUNK"));
        V_1_0_10_MAPPING.put(13, LandBlockType.ofName("SMALL_CROWN"));
        V_1_0_10_MAPPING.put(14, LandBlockType.ofName("TRUNK_BLOCK"));
        V_1_0_10_MAPPING.put(15, LandBlockType.ofName("TRUNKBRANCH"));
        V_1_0_10_MAPPING.put(16, LandBlockType.ofName("BRANCH"));
        V_1_0_10_MAPPING.put(17, LandBlockType.ofName("LEAF"));
        V_1_0_10_MAPPING.put(18, LandBlockType.ofName("FLOATER_TOP"));
        V_1_0_10_MAPPING.put(19, LandBlockType.ofName("FLOATER_TOP_VINE"));
        V_1_0_10_MAPPING.put(20, LandBlockType.ofName("FLOATER_TOP_POPPIES"));
        V_1_0_10_MAPPING.put(21, LandBlockType.ofName("FLOATER_TOP_SUSPENDIUM"));
        V_1_0_10_MAPPING.put(22, LandBlockType.ofName("FLOATER_UP"));
        V_1_0_10_MAPPING.put(23, LandBlockType.ofName("FLOATER_MIDDLE"));
        V_1_0_10_MAPPING.put(24, LandBlockType.ofName("FLOATER_DOWN"));
        V_1_0_10_MAPPING.put(25, LandBlockType.ofName("FLOATER_DOWNER"));
        V_1_0_10_MAPPING.put(26, LandBlockType.ofName("FLOATER_DOWNER_SUSPENDIUM"));
        V_1_0_10_MAPPING.put(27, LandBlockType.ofName("FLOATER_DOWNER_ROCK"));
        V_1_0_10_MAPPING.put(28, LandBlockType.ofName("FLOATER_BOTTOM"));
        V_1_0_10_MAPPING.put(29, LandBlockType.ofName("GRASS_FENCES"));
        V_1_0_10_MAPPING.put(30, LandBlockType.ofName("GRASS_FLOATPLANT"));
        V_1_0_10_MAPPING.put(31, LandBlockType.ofName("GRASS_GRAVESTONE"));
        V_1_0_10_MAPPING.put(32, LandBlockType.ofName("GRASS_POPPIES"));
        V_1_0_10_MAPPING.put(33, LandBlockType.ofName("GRASS_ROCK"));
        V_1_0_10_MAPPING.put(34, LandBlockType.ofName("GRASS_RUIN"));
        V_1_0_10_MAPPING.put(35, LandBlockType.ofName("GRASS_SIGNPOST"));
        V_1_0_10_MAPPING.put(36, LandBlockType.ofName("GRASS_SUSPENDIUM"));
        V_1_0_10_MAPPING.put(37, LandBlockType.ofName("GRASS_TROUGH"));
        V_1_0_10_MAPPING.put(38, LandBlockType.ofName("GRASS_WOOD_PILE"));
        V_1_0_10_MAPPING.put(39, LandBlockType.ofName("STELE_TOP"));
        V_1_0_10_MAPPING.put(40, LandBlockType.ofName("STELE_BODY"));
        ArrayList<LandBlockType> lbts = Loadable.all(LandBlockType.class);
        CURRENT_MAPPING.clear();
        for (int i = 0; i < lbts.size(); ++i) {
            CURRENT_MAPPING.put(i, lbts.get(i));
        }
    }
}

