/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public strictfp class KeyConfigScreen
implements Screen,
ScrollBar.ScrollElementAdapter<Object> {
    public static final String[] AVAILABLE_KEYS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "ADD", "APOSTROPHE", "APPS", "AT", "AX", "B", "BACK", "BACKSLASH", "C", "CAPITAL", "CIRCUMFLEX", "COLON", "COMMA", "CONVERT", "D", "DECIMAL", "DELETE", "DIVIDE", "E", "END", "ENTER", "EQUALS", "F", "F1", "F10", "F11", "F12", "F13", "F14", "F15", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "G", "GRAVE", "H", "HOME", "I", "INSERT", "J", "K", "KANA", "KANJI", "L", "LBRACKET", "LCONTROL", "LMENU", "LSHIFT", "LWIN", "M", "MINUS", "MULTIPLY", "N", "NEXT", "NOCONVERT", "NUMLOCK", "NUMPAD0", "NUMPAD1", "NUMPAD2", "NUMPAD3", "NUMPAD4", "NUMPAD5", "NUMPAD6", "NUMPAD7", "NUMPAD8", "NUMPAD9", "NUMPADCOMMA", "NUMPADENTER", "NUMPADEQUALS", "O", "P", "PAUSE", "PERIOD", "POWER", "PRIOR", "Q", "R", "RBRACKET", "RCONTROL", "RMENU", "RSHIFT", "RWIN", "S", "SCROLL", "SEMICOLON", "SLASH", "SLEEP", "SPACE", "STOP", "SUBTRACT", "SYSRQ", "T", "TAB", "U", "UNDERLINE", "UNLABELED", "V", "W", "X", "Y", "YEN", "Z"};
    public final AirshipGame g;
    private final ScrollBar listSB = new ScrollBar();
    private Keys.KeyInfo setting;
    private Keys.KeyInfo conflict;
    private String lastKey;
    private int widestText;
    private int widestButton;
    private int numColumns;
    private int columnWidth;

    public KeyConfigScreen(AirshipGame g) {
        this.g = g;
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        ScreenMode sm = in.mode();
        this.listSB.tick(in, 0, 0, sm.width, sm.height);
        if (this.setting != null) {
            if (in.keyPressed("ESCAPE")) {
                this.setting = null;
                this.conflict = null;
                this.lastKey = null;
            } else {
                for (String k : AVAILABLE_KEYS) {
                    if (!in.keyPressed(k)) continue;
                    this.lastKey = k;
                    this.conflict = this.setting.setCollidesWith(k);
                    if (this.conflict == null) {
                        this.setting.set(k);
                        this.setting = null;
                    }
                    return;
                }
            }
        } else if (in.keyPressed("ESCAPE") || in.keyPressed(Keys.get("leave", "L"))) {
            this.g.s = new MainMenu(this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawBG(MyDraw.SCREEN_BG, sm);
        d.drawTopBar(sm);
        int x = sm.width - MyDraw.SIDE_CLEARANCE;
        int bw = d.bw(Lang._t("Leave", new Object[0]));
        d.button(x - bw, MyDraw.TOP_BAR_INSET, bw, Lang._t("Leave", new Object[0]), Keys.get("leave", "L"), new Runnable(){

            @Override
            public void run() {
                Keys.saveKeyPrefs();
                KeyConfigScreen.this.g.s = new MainMenu(KeyConfigScreen.this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
            }
        });
        x -= bw + MyDraw.BUTTON_SPACING;
        bw = d.bw(Lang._t("Reset", new Object[0]));
        d.button(x - bw, MyDraw.TOP_BAR_INSET, bw, Lang._t("Reset", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                Keys.reset();
            }
        });
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        d.text(Lang._t("Key_Configuration", new Object[0]), AGame.BIG_FOUNT, MyDraw.SIDE_CLEARANCE, MyDraw.TOP_BAR_INSET);
        if (this.widestText == 0) {
            for (Keys.KeyGroup kg : Keys.groups) {
                for (Keys.KeyInfo ki : kg.items) {
                    this.widestText = StrictMath.max((int)d.textSize((String)Lang._t((String)ki.name, (Object[])new Object[0]), (Fount)AGame.FOUNT).x, this.widestText);
                    bw = d.bw(ki.value);
                    this.widestButton = StrictMath.max(bw, this.widestButton);
                }
            }
            this.columnWidth = this.widestText + this.widestButton + MyDraw.UI_SPACING * 3;
            this.numColumns = (sm.width - MyDraw.SIDE_CLEARANCE * 2 - ScrollBar.SCROLL_BAR_W - MyDraw.PANEL_INSET * 2) / this.columnWidth;
            if (this.numColumns == 0) {
                this.numColumns = 1;
            }
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (Keys.KeyGroup kg : Keys.groups) {
            l.add(kg);
            ArrayList<Keys.KeyInfo> row = null;
            for (Keys.KeyInfo ki : kg.items) {
                if (row == null) {
                    row = new ArrayList<Keys.KeyInfo>();
                }
                row.add(ki);
                if (row.size() != this.numColumns) continue;
                l.add(row);
                row = null;
            }
            if (row != null) {
                l.add(row);
            }
            if (kg == Keys.groups.get(Keys.groups.size() - 1)) continue;
            l.add(null);
        }
        int w = this.columnWidth * this.numColumns + ScrollBar.SCROLL_BAR_W + MyDraw.PANEL_INSET * 2 - MyDraw.UI_SPACING * 2;
        this.listSB.draw(d, sm.width / 2 - w / 2, y, w, sm.height - MyDraw.TOP_BAR_H - MyDraw.UI_SPACING - MyDraw.SIDE_CLEARANCE, l, this);
        if (this.setting != null) {
            String msg = Lang._t("press_key_to_set_x", Lang._t(this.setting.name, new Object[0]));
            if (this.conflict != null) {
                msg = msg + "\n" + Lang._t("key_conflict", this.lastKey, Lang._t(this.conflict.name, new Object[0]), Lang._t(this.conflict.groupName, new Object[0]));
            }
            Pt sz = d.textSize(msg, AGame.FOUNT);
            w = (int)sz.x + MyDraw.PANEL_INSET * 2;
            int h = (int)sz.y + MyDraw.PANEL_INSET * 2 + MyDraw.UI_SPACING + MyDraw.BUTTON_H;
            x = sm.width / 2 - w / 2;
            y = sm.height / 2 - h / 2;
            d.drawPanel(x, y, w, h);
            d.text(msg, AGame.FOUNT, x += MyDraw.PANEL_INSET, y += MyDraw.PANEL_INSET);
            y = (int)((double)y + (sz.y + (double)MyDraw.UI_SPACING));
            bw = d.bw(Lang._t("Cancel", new Object[0]));
            d.button(sm.width / 2 - bw / 2, y, bw, Lang._t("Cancel", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    KeyConfigScreen.this.setting = null;
                    KeyConfigScreen.this.conflict = null;
                    KeyConfigScreen.this.lastKey = null;
                }
            });
        }
    }

    @Override
    public ArrayList<String> music() {
        return AGame.NO_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return "DAY";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    @Override
    public int getHeight(Object t, MyDraw d, int availableWidth) {
        if (t instanceof Keys.KeyGroup) {
            return AGame.BIGGER_FOUNT.lineHeight + MyDraw.SCROLL_EL_SPACING;
        }
        if (t instanceof ArrayList) {
            return MyDraw.BUTTON_H + MyDraw.SCROLL_EL_SPACING;
        }
        return MyDraw.UI_SPACING;
    }

    @Override
    public void draw(Object t, MyDraw d, int x, int y, int width) {
        if (t instanceof Keys.KeyGroup) {
            Keys.KeyGroup kg = (Keys.KeyGroup)t;
            d.text(Lang._t(kg.name, new Object[0]), AGame.BIGGER_FOUNT, x, y);
        }
        if (t instanceof ArrayList) {
            ArrayList l = (ArrayList)t;
            for (final Keys.KeyInfo ki : l) {
                if (ki == this.conflict) {
                    d.text(MyDraw.ERROR_C + Lang._t(ki.name, new Object[0]), AGame.FOUNT, x + this.widestButton + MyDraw.UI_SPACING, y + MyDraw.BUTTON_H / 2 - AGame.FOUNT.lineHeight / 2);
                } else {
                    d.text(Lang._t(ki.name, new Object[0]), AGame.FOUNT, x + this.widestButton + MyDraw.UI_SPACING, y + MyDraw.BUTTON_H / 2 - AGame.FOUNT.lineHeight / 2);
                }
                d.button(x, y, this.widestButton, ki.value, new Runnable(){

                    @Override
                    public void run() {
                        KeyConfigScreen.this.setting = ki;
                    }
                });
                x += this.columnWidth;
            }
        }
    }
}

