/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Job;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.Collections;

public strictfp class JobBoard
implements UniScreen.ShipChrome {
    public static String indent(String s, int amt) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() < amt) {
            sb.append(" ");
        }
        return sb.toString();
    }

    @Override
    public void draw(MyDraw d, Pt cursor, Airship ship, Combat.Side side, int x, int y, int w, int h, ScreenMode sm, UniScreen us) {
        if (us.selectedShip != ship) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[bg=000000]\n");
        int busyCrew = 0;
        int activeCrew = 0;
        for (Crewman cm : ship.crew) {
            if (cm.job != null) {
                ++busyCrew;
            }
            if (!cm.active()) continue;
            ++activeCrew;
        }
        sb.append("Busy: ").append(busyCrew).append(" Active: ").append(activeCrew).append("\n");
        sb.append(JobBoard.indent("Name", 20));
        sb.append(JobBoard.indent("Module", 30));
        sb.append(JobBoard.indent("P", 5));
        sb.append(JobBoard.indent("C", 2));
        sb.append("\n");
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (Module m : ship.modules) {
            if (!m.type.isWeapon()) continue;
            for (Job j : m.jobs()) {
                if (!j.active()) continue;
                jobs.add(j);
            }
        }
        Collections.sort(jobs, ship);
        for (Job j : jobs) {
            boolean hasCrew = false;
            boolean crewIsInactive = false;
            Crewman crew = null;
            for (Crewman cm : ship.crew) {
                if (cm.job != j) continue;
                hasCrew = true;
                if (!cm.active()) {
                    crewIsInactive = true;
                }
                crew = cm;
                break;
            }
            sb.append(hasCrew && !crewIsInactive ? "[ffffff]" : MyDraw.ERROR_C);
            sb.append(JobBoard.indent(j.getClass().getSimpleName(), 20));
            sb.append(JobBoard.indent(j.module().type.getName(), 30));
            sb.append(JobBoard.indent("" + (int)(j.priority() * 10.0), 5));
            sb.append(JobBoard.indent(hasCrew ? (crewIsInactive ? "I" : "Y") : "N", 2));
            if (crew != null) {
                sb.append("\n");
                sb.append("@").append(crew.currentTile.module.type.getName());
                if (crew.target == crew.currentTile.module) {
                    sb.append(" @m");
                }
                if (crew.targetTile == crew.currentTile) {
                    sb.append(" @t");
                } else {
                    if (crew.targetTile != null) {
                        sb.append(" tt=").append(crew.targetTile.x).append(" ").append(crew.targetTile.y);
                    } else {
                        sb.append(" tt=null");
                    }
                    sb.append(" ct=").append(crew.currentTile.x).append(" ").append(crew.currentTile.y);
                }
                sb.append("\nm=").append(crew.msSinceMoved);
                sb.append(" c=").append((Object)crew.carrying);
                if (crew.movingTowards != null) {
                    sb.append(" ->").append(crew.movingTowards.module.type.getName());
                }
                if (crew.target != null) {
                    sb.append(" =>").append(crew.target.type.getName());
                }
            }
            sb.append("\n");
        }
        d.text(sb.toString(), AGame.FOUNT, 10.0, 50.0);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public boolean textInputOccurring(UniScreen us) {
        return false;
    }
}

