/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.IntegrationBackend;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.catengine.Img;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.json.JSONObject;
import org.newdawn.slick.Image;
import org.newdawn.slick.opengl.ImageData;
import org.newdawn.slick.opengl.PNGImageData;

public strictfp class Integration
implements IntegrationBackend.Receiver {
    public IntegrationBackend backend;
    public String username;
    public String password;
    private JSONObject registeredCoatOfArmsJSON;
    public boolean steamUnlinked;
    public boolean linkingUser;
    public List<String> features = new ArrayList<String>();
    public String specialCharge;
    public HashSet<String> loadingChargePictures = new HashSet();
    public HashMap<String, Img> chargePictures = new HashMap();
    public HashMap<String, Img> chargePicturesLeft = new HashMap();
    public HashMap<String, Img> chargePicturesRight = new HashMap();
    public String errorMessage;
    public int ticksSinceErrorMessage;
    private State state = State.LOGGED_OUT;
    private final ArrayList<Object> callbacks = new ArrayList();
    private boolean inited = false;
    public boolean hasNews;
    public String newsTitle;
    public String newsText;
    public String newsLink;
    public PNGImageData newsImage;
    public Image newsImageImg;

    public Integration(IntegrationBackend backend) {
        this.backend = backend;
    }

    private void savePrefs() {
        if (!SteamBackend.isEnabled()) {
            try {
                AirshipGame.PREFS.put("username", this.username);
                AirshipGame.PREFS.put("password", this.password);
                AirshipGame.PREFS.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadPrefsAndLogin() {
        if (!SteamBackend.isEnabled()) {
            try {
                this.username = AirshipGame.PREFS.get("username", null);
                this.password = AirshipGame.PREFS.get("password", null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.username != null && this.password != null) {
                this.login(this.username, this.password);
            }
        } else {
            this.state = State.STEAM;
            this.backend.steamGetInfo("" + SteamBackend.getUserID(), this);
        }
    }

    public synchronized void logout() {
        this.username = null;
        this.password = null;
        this.registeredCoatOfArmsJSON = null;
        this.features = new ArrayList<String>();
        this.specialCharge = null;
        this.state = State.LOGGED_OUT;
    }

    public synchronized void login(String username, String password) {
        this.state = State.LOGGING_IN;
        this.errorMessage = null;
        this.backend.authenticate(username, password, this);
    }

    public synchronized void register(String username, String password, String email) {
        final Integration in = this;
        this.state = State.REGISTERING;
        this.errorMessage = null;
        this.backend.register(username, password, email, new IntegrationBackend.Receiver<IntegrationBackend.RegisterCallback>(){

            @Override
            public void receive(IntegrationBackend.RegisterCallback callback) {
                in.receive(callback);
            }
        });
    }

    public synchronized void steamLinkUser(String username, String password) {
        this.linkingUser = true;
        this.errorMessage = null;
        this.backend.steamLinkUser("" + SteamBackend.getUserID(), "none", username, password, this);
    }

    public synchronized void checkForNews() {
        this.backend.checkForNews(this);
    }

    public synchronized void receive(Object callback) {
        this.callbacks.add(callback);
    }

    public synchronized CoatOfArms getRegisteredCOAIfAvailable() {
        return this.registeredCoatOfArmsJSON == null ? null : new CoatOfArms(this.registeredCoatOfArmsJSON);
    }

    public synchronized void setRegisteredCOA(CoatOfArms coa) {
        this.registeredCoatOfArmsJSON = coa == null ? null : coa.toJSON();
    }

    public synchronized void tick() {
        if (!this.inited) {
            this.loadPrefsAndLogin();
            this.inited = true;
        }
        ++this.ticksSinceErrorMessage;
        for (Object o : this.callbacks) {
            if (o instanceof IntegrationBackend.AuthCallback) {
                IntegrationBackend.AuthCallback acb = (IntegrationBackend.AuthCallback)o;
                if (acb.success) {
                    this.username = acb.username;
                    this.password = acb.password;
                    this.registeredCoatOfArmsJSON = acb.arms == null ? null : acb.arms.toJSON();
                    this.specialCharge = acb.specialCharge;
                    this.features = acb.features;
                    this.state = State.LOGGED_IN;
                    this.savePrefs();
                } else {
                    this.errorMessage = acb.errorMessage;
                    this.ticksSinceErrorMessage = 0;
                    this.logout();
                }
            }
            if (o instanceof IntegrationBackend.RegisterCallback) {
                IntegrationBackend.RegisterCallback rcb = (IntegrationBackend.RegisterCallback)o;
                if (rcb.success) {
                    this.username = rcb.username;
                    this.password = rcb.password;
                    this.savePrefs();
                    this.state = State.LOGGED_IN;
                } else {
                    this.errorMessage = rcb.errorMessage;
                    this.ticksSinceErrorMessage = 0;
                    this.logout();
                }
            }
            if (o instanceof IntegrationBackend.GetChargeCallback) {
                IntegrationBackend.GetChargeCallback gccb = (IntegrationBackend.GetChargeCallback)o;
                if (gccb.success) {
                    Img img = new Img("ui", 0, 0, 16, 16, false);
                    Image image = new Image((ImageData)gccb.imgData);
                    image.setFilter(9728);
                    img.machineImgCache = image;
                    img.machineWCache = 16;
                    img.machineHCache = 16;
                    this.chargePictures.put(gccb.chargeName, img);
                } else {
                    this.chargePictures.put(gccb.chargeName, null);
                }
            }
            if (o instanceof IntegrationBackend.FeedbackCallback) {
                IntegrationBackend.FeedbackCallback fbc = (IntegrationBackend.FeedbackCallback)o;
                if (!fbc.success) {
                    this.errorMessage = fbc.errorMessage;
                    this.ticksSinceErrorMessage = 0;
                }
            }
            if (o instanceof IntegrationBackend.NewsCallback) {
                IntegrationBackend.NewsCallback nc = (IntegrationBackend.NewsCallback)o;
                if (nc.success) {
                    this.hasNews = nc.hasNews;
                    if (nc.hasNews) {
                        this.newsTitle = nc.title;
                        this.newsText = nc.text;
                        this.newsLink = nc.link;
                        this.newsImage = nc.img;
                    } else {
                        this.newsTitle = null;
                        this.newsText = null;
                        this.newsLink = null;
                        this.newsImage = null;
                    }
                }
            }
            if (o instanceof IntegrationBackend.SteamGetInfoCallback) {
                IntegrationBackend.SteamGetInfoCallback sgic = (IntegrationBackend.SteamGetInfoCallback)o;
                if (sgic.success) {
                    this.registeredCoatOfArmsJSON = sgic.arms == null ? null : sgic.arms.toJSON();
                    this.specialCharge = sgic.specialCharge;
                    this.steamUnlinked = sgic.unlinked;
                    this.linkingUser = false;
                }
            }
            if (!(o instanceof IntegrationBackend.SteamLinkUserCallback)) continue;
            IntegrationBackend.SteamLinkUserCallback sluc = (IntegrationBackend.SteamLinkUserCallback)o;
            if (sluc.success) {
                this.steamUnlinked = false;
                this.backend.steamGetInfo("" + SteamBackend.getUserID(), this);
                continue;
            }
            this.linkingUser = false;
            this.errorMessage = sluc.errorMessage;
            this.ticksSinceErrorMessage = 0;
        }
        this.callbacks.clear();
    }

    public String nextMultiplayerHour() {
        String[] mpHours = this.backend.getMultiplayerHours().split(",");
        if (mpHours.length < 2) {
            return null;
        }
        int[][] hours = new int[mpHours.length / 2][2];
        for (int i = 0; i < hours.length; ++i) {
            hours[i][0] = Integer.parseInt(mpHours[i * 2]);
            hours[i][1] = Integer.parseInt(mpHours[i * 2 + 1]);
        }
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        DateTime nextHr = null;
        for (int i = 0; i < hours.length; ++i) {
            LocalDate mpHD = DateTime.now((DateTimeZone)DateTimeZone.UTC).toLocalDate();
            int mpHDOW = hours[i][0];
            int mpHHr = hours[i][1];
            if (now.dayOfWeek().get() < mpHDOW) {
                mpHD = mpHD.plusDays(mpHDOW - now.dayOfWeek().get());
            } else if (now.dayOfWeek().get() > mpHDOW) {
                mpHD = mpHD.plusDays(mpHDOW - now.dayOfWeek().get() + 7);
            } else if (now.hourOfDay().get() > mpHHr) {
                mpHD = mpHD.plusDays(7);
            } else if (now.hourOfDay().get() == mpHHr) {
                return Lang._t("mp_hr_is_now", new Object[0]);
            }
            DateTime mpH = mpHD.toDateTime(new LocalTime(mpHHr, 0, 0), DateTimeZone.UTC).toDateTime(DateTimeZone.getDefault());
            if (nextHr != null && !mpH.isBefore((ReadableInstant)nextHr)) continue;
            nextHr = mpH;
        }
        if (nextHr == null) {
            return null;
        }
        Duration until = new Interval((ReadableInstant)DateTime.now(), nextHr).toDuration();
        if (until.getStandardHours() < 4L) {
            if (until.getStandardHours() > 0L) {
                return Lang._t("next_mp_hr_hrs", until.getStandardHours(), until.getStandardMinutes() - until.getStandardHours() * 60L);
            }
            if (until.getStandardMinutes() > 0L) {
                return Lang._t("next_mp_hr_mins", until.getStandardMinutes());
            }
            if (until.getStandardSeconds() > 0L) {
                return Lang._t("next_mp_hr_secs", until.getStandardSeconds());
            }
        }
        return Lang._t("next_mp_hr", nextHr.toString(DateTimeFormat.patternForStyle((String)"MS", (Locale)Lang.currentLocale)));
    }

    public Img getSpecialCharge(String name) {
        if (this.chargePictures.containsKey(name)) {
            return this.chargePictures.get(name);
        }
        if (!this.loadingChargePictures.contains(name)) {
            this.loadingChargePictures.add(name);
            this.loadCharge(name);
        }
        return null;
    }

    public Img getSpecialChargeLeftHalf(String name) {
        if (this.chargePicturesLeft.containsKey(name)) {
            return this.chargePicturesLeft.get(name);
        }
        Img ch = this.getSpecialCharge(name);
        if (ch == null) {
            return null;
        }
        Image image = (Image)ch.machineImgCache;
        Img img = new Img("ui", 0, 0, 8, 16, false);
        img.machineImgCache = image.getSubImage(0, 0, 8, 16);
        img.machineWCache = 8;
        img.machineHCache = 16;
        this.chargePicturesLeft.put(name, img);
        return img;
    }

    public Img getSpecialChargeRightHalf(String name) {
        if (this.chargePicturesRight.containsKey(name)) {
            return this.chargePicturesRight.get(name);
        }
        Img ch = this.getSpecialCharge(name);
        if (ch == null) {
            return null;
        }
        Image image = (Image)ch.machineImgCache;
        Img img = new Img("ui", 8, 0, 8, 16, false);
        img.machineImgCache = image.getSubImage(8, 0, 8, 16);
        img.machineWCache = 8;
        img.machineHCache = 16;
        this.chargePicturesRight.put(name, img);
        return img;
    }

    private void loadCharge(String name) {
        this.backend.getCharge(name, this);
    }

    public void sendFeedback(String text) {
        String name = this.username == null ? "<~NO ONE~>" : this.username;
        String prefix = "";
        if (SteamBackend.isEnabled()) {
            prefix = "\n" + SteamBackend.getSteamNickname() + "\n" + SteamBackend.getUserID() + "\n";
        }
        StringBuilder mods = new StringBuilder();
        mods.append("Mods: ");
        for (Mod m : Mod.getEnabledMods()) {
            mods.append(m.getIdeallyEnglishName()).append(" / ").append(m.id).append(", ");
        }
        mods.append("\nOS: ").append(System.getProperty("os.name"));
        this.backend.sendFeedback(name, prefix + "1.0.13.1" + "\n" + mods.toString() + "\n\n" + text, this);
    }

    public void sendFeedbackMessage(String text) {
        String name = this.username == null ? "<~NO ONE~>" : this.username;
        String prefix = "";
        if (SteamBackend.isEnabled()) {
            prefix = "\n" + SteamBackend.getSteamNickname() + "\n" + SteamBackend.getUserID() + "\n";
        }
        StringBuilder mods = new StringBuilder();
        mods.append("Mods: ");
        for (Mod m : Mod.getEnabledMods()) {
            mods.append(m.getIdeallyEnglishName()).append(" / ").append(m.id).append(", ");
        }
        mods.append("\nOS: ").append(System.getProperty("os.name"));
        this.backend.sendFeedbackMessage(name, text + "\n\n" + prefix + "1.0.13.1" + "\n" + mods.toString(), this);
    }

    public void gotoForums() {
        if (this.state == State.LOGGED_IN) {
            this.backend.gotoForums(this.username, this.password);
        } else {
            this.backend.gotoForums(null, null);
        }
    }

    public void gotoCalendar() {
        if (this.state == State.LOGGED_IN) {
            this.backend.gotoCalendar(this.username, this.password);
        }
    }

    public State getState() {
        return this.state;
    }

    public strictfp static enum State {
        LOGGED_OUT,
        LOGGING_IN,
        LOGGED_IN,
        REGISTERING,
        STEAM;

    }
}

