/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.ModReloadProgressDialog;
import com.zarkonnen.airships.ModsAdapter;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.Server;
import com.zarkonnen.airships.StrategicLobbyScreen;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class HostOrJoinStrategicScreen
implements Screen {
    private TextField nameField;
    private TextField hostField;
    private final boolean doHost;
    private final AirshipGame g;
    private String yourIP = "";
    private static final ArrayList<Mod> gameEnabledMods = new ArrayList();
    private final ArrayList<Mod> availableMods;
    private final ScrollBar modsSB = new ScrollBar();
    private final ModsAdapter modsAdapter;
    private Rect2D modsSBRect;
    private ModReloadProgressDialog mrpd;
    private boolean unableToLoadCorrectMods;
    private JSONObject loadGameData;
    private ArrayList<Mod> loadGameMods;

    private String getMyIP() {
        try {
            for (NetworkInterface ni : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress ia : Collections.list(ni.getInetAddresses())) {
                    if (ia.isLoopbackAddress() || !ia.toString().matches("/[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+")) continue;
                    return ia.toString().substring(1);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "?";
    }

    public HostOrJoinStrategicScreen(boolean doHost, final AirshipGame g, JSONObject loadGameData) {
        this.doHost = doHost;
        this.g = g;
        try {
            this.yourIP = Lang._t("Your_IP_address", new Object[0]) + ": " + this.getMyIP() + " port " + 29142 + " & " + 29143;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadGameData = loadGameData;
        this.availableMods = Mod.getAvailableMods();
        Iterator<Mod> it = gameEnabledMods.iterator();
        while (it.hasNext()) {
            if (this.availableMods.contains(it.next())) continue;
            it.remove();
        }
        this.modsAdapter = new ModsAdapter(gameEnabledMods);
        if (loadGameData != null) {
            boolean modsFailed = false;
            this.loadGameMods = new ArrayList();
            if (loadGameData.has("mods")) {
                JSONArray mods = loadGameData.getJSONArray("mods");
                for (int i = 0; i < mods.length(); ++i) {
                    Mod m = Mod.getById(mods.getJSONObject(i).getString("id"));
                    if (m == null) {
                        modsFailed = true;
                        break;
                    }
                    this.loadGameMods.add(m);
                }
            }
            final StringBuilder modsList = new StringBuilder();
            JSONArray mods = loadGameData.getJSONArray("mods");
            for (int i = 0; i < mods.length(); ++i) {
                modsList.append(mods.getJSONObject(i).getString("id"));
                if (i == mods.length() - 1) continue;
                modsList.append(", ");
            }
            if (modsFailed) {
                g.showError(Lang._t("unable_to_load_mp_mods", new Object[0]) + "\n" + modsList.toString());
                g.s = new MainMenu(g, MainMenu.Submenu.MULTIPLAYER);
                return;
            }
            boolean modsCongruent = true;
            for (Mod m : Mod.getAvailableMods()) {
                if (m.isCurrentlyEnabled() == this.loadGameMods.contains(m)) continue;
                modsCongruent = false;
            }
            if (!modsCongruent) {
                Mod.overriddenEnabledModIds = new ArrayList();
                for (Mod m : this.loadGameMods) {
                    Mod.overriddenEnabledModIds.add(m.id);
                }
                this.mrpd = new ModReloadProgressDialog(new Runnable(){

                    @Override
                    public void run() {
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        g.showError(Lang._t("unable_to_load_mp_mods", new Object[0]) + "\n" + modsList.toString());
                        g.s = new MainMenu(g, MainMenu.Submenu.MULTIPLAYER);
                    }
                });
            }
        }
    }

    private void resetMods() {
        Mod.overriddenEnabledModIds = null;
        this.mrpd = new ModReloadProgressDialog(null, new Runnable(){

            @Override
            public void run() {
                ((HostOrJoinStrategicScreen)HostOrJoinStrategicScreen.this).g.s = new MainMenu(HostOrJoinStrategicScreen.this.g, AGame.isDemo() ? MainMenu.Submenu.MAIN : MainMenu.Submenu.MULTIPLAYER);
                HostOrJoinStrategicScreen.this.g.showError(Lang._t("Unable_to_reset_mods", new Object[0]));
            }
        });
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.mrpd != null) {
            ModReloadProgressDialog myMrpd = this.mrpd;
            if (this.mrpd.tick(in) && myMrpd == this.mrpd) {
                this.mrpd = null;
            }
            return;
        }
        if (this.unableToLoadCorrectMods) {
            if (in.keyPressed("ENTER") || in.keyPressed("ESCAPE")) {
                this.unableToLoadCorrectMods = false;
                this.resetMods();
            }
            return;
        }
        if (this.modsSBRect != null) {
            this.modsSB.tick(in, (int)this.modsSBRect.x, (int)this.modsSBRect.y, (int)this.modsSBRect.w, (int)this.modsSBRect.h);
        }
        if (this.nameField == null) {
            this.nameField = new TextField(false, " qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890-=+_!,'@\u00a3$%^&()\u00b1\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00c9\u00ca\u00c8\u00e9\u00ea\u00e8\u00eb\u00c7\u00e7\u00c0\u00e0\u00e2\u00fb\u0105\u0107\u0119\u0142\u0144\u00f3\u015b\u017c\u017a\u0104\u0106\u0118\u0141\u0143\u00d3\u015a\u017b\u0179\u0410\u0430\u0411\u0431\u0412\u0432\u0413\u0433\u0414\u0434\u0415\u0435\u0416\u0436\u0417\u0437\u0418\u0438\u0419\u0439\u041a\u043a\u041b\u043b\u041c\u043c\u041d\u043d\u041e\u043e\u041f\u043f\u0420\u0440\u0421\u0441\u0422\u0442\u0423\u0443\u0424\u0444\u0425\u0445\u0426\u0446\u0427\u0447\u0428\u0448\u0429\u0449\u042c\u044c\u042e\u044e\u042f\u044f\u042b\u044b\u042d\u044d\u042a\u044a`\u00a1\u00bf\u00c1\u00e1\u00ed\u00f1\u00fa\u201d\u2026\u3000\u3001\u3002\u3005\u3042\u3044\u3046\u3048\u304a\u304b\u304c\u304d\u304e\u304f\u3050\u3051\u3052\u3053\u3054\u3055\u3057\u3058\u3059\u305a\u305b\u305c\u305d\u305e\u305f\u3060\u3061\u3063\u3064\u3065\u3066\u3067\u3068\u3069\u306a\u306b\u306c\u306d\u306e\u306f\u3070\u3072\u3073\u3076\u3078\u3079\u307b\u307c\u307d\u307e\u307f\u3080\u3081\u3082\u3083\u3084\u3085\u3086\u3087\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3092\u3093\u30a1\u30a2\u30a3\u30a4\u30a6\u30a7\u30a8\u30a9\u30aa\u30ab\u30ac\u30ad\u30ae\u30af\u30b0\u30b1\u30b2\u30b3\u30b4\u30b5\u30b6\u30b7\u30b8\u30b9\u30ba\u30bb\u30bc\u30bd\u30be\u30bf\u30c0\u30c1\u30c3\u30c4\u30c6\u30c7\u30c8\u30c9\u30ca\u30cb\u30cd\u30ce\u30cf\u30d0\u30d1\u30d2\u30d3\u30d4\u30d5\u30d6\u30d7\u30d8\u30d9\u30da\u30db\u30dc\u30dd\u30de\u30df\u30e0\u30e1\u30e2\u30e3\u30e4\u30e5\u30e6\u30e7\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f3\u30f4\u30fb\u30fc\u4e00\u4e07\u4e08\u4e09\u4e0a\u4e0b\u4e0d\u4e0e\u4e16\u4e21\u4e26\u4e2d\u4e38\u4e3b\u4e45\u4e57\u4e71\u4e7e\u4e86\u4e88\u4e89\u4e8b\u4e8c\u4e92\u4ea1\u4ea4\u4eba\u4eca\u4ecb\u4ed5\u4ed6\u4ed8\u4ee3\u4ee4\u4ee5\u4ef2\u4ef6\u4efb\u4f0f\u4f1d\u4f34\u4f38\u4f3c\u4f4d\u4f4e\u4f4f\u4f53\u4f55\u4f5c\u4f7f\u4f9b\u4f9d\u4fa1\u4fb5\u4fc2\u4fdd\u4fe1\u4fee\u5009\u500b\u500d\u5012\u5024\u505c\u5074\u5075\u5099\u50ac\u50b5\u50b7\u50cd\u50cf\u5100\u511f\u512a\u5143\u5145\u5148\u5149\u515a\u5165\u5168\u516c\u5171\u5175\u5177\u5185\u5186\u518d\u5199\u51a0\u51b6\u51e6\u51f9\u51fa\u5203\u5206\u5207\u5211\u521d\u5224\u5225\u5229\u5230\u5236\u523b\u524a\u524d\u5256\u526f\u5275\u529b\u529f\u52a0\u52a3\u52a9\u52aa\u52b4\u52b9\u52c7\u52d5\u52d9\u52dd\u52e2\u5305\u5316\u5317\u5339\u533a\u533b\u533f\u5341\u534a\u5352\u5354\u5357\u5358\u5360\u5370\u5371\u5373\u5375\u539a\u53b3\u53bb\u53c2\u53ca\u53cd\u53ce\u53d6\u53d7\u53e3\u53e4\u53e5\u53e9\u53ef\u53f0\u53f3\u53f8\u5404\u5408\u540c\u540d\u5411\u541b\u5426\u542b\u5438\u5439\u544a\u5468\u5473\u547c\u547d\u548c\u54c1\u54e1\u54e8\u54f2\u5506\u5531\u553e\u5546\u554f\u5584\u559c\u55b0\u55b6\u5642\u5668\u56db\u56de\u56e3\u56f0\u56f2\u56f3\u56fa\u56fd\u571f\u5727\u5728\u5730\u5782\u578b\u57ce\u57df\u57fa\u5831\u5834\u5854\u5857\u585e\u5869\u586b\u5883\u5897\u589c\u58c1\u58ca\u58cc\u58eb\u58ee\u58f2\u5909\u5915\u5916\u591a\u591c\u5927\u592a\u592b\u592e\u5931\u5947\u5951\u5968\u596a\u5974\u597d\u5982\u5999\u59a8\u59cb\u5a01\u5b50\u5b57\u5b58\u5b66\u5b75\u5b88\u5b89\u5b8c\u5b97\u5b98\u5b9a\u5b9d\u5b9f\u5ba2\u5ba3\u5ba4\u5bb3\u5bb6\u5bb9\u5bbf\u5bc4\u5bc6\u5bcc\u5bdd\u5bdf\u5bf8\u5bfa\u5bfe\u5c02\u5c04\u5c06\u5c0b\u5c0e\u5c0f\u5c11\u5c16\u5c3d\u5c3e\u5c40\u5c45\u5c48\u5c4b\u5c55\u5c5e\u5c64\u5c6f\u5c71\u5ca9\u5cd9\u5cf6\u5d07\u5d29\u5d50\u5de3\u5de5\u5de6\u5de7\u5de8\u5e02\u5e06\u5e0c\u5e1d\u5e2f\u5e30\u5e38\u5e45\u5e72\u5e73\u5e74\u5e78\u5e79\u5e83\u5e95\u5e97\u5ea6\u5ea7\u5eab\u5ef6\u5efa\u5f0f\u5f15\u5f31\u5f35\u5f37\u5f3e\u5f53\u5f62\u5f6b\u5f71\u5f79\u5f7c\u5f81\u5f84\u5f85\u5f8c\u5f90\u5f93\u5f97\u5fa1\u5fa9\u5fb9\u5fc3\u5fc5\u5fd8\u5fdc\u5feb\u5ff5\u6016\u601d\u6025\u6027\u602a\u6050\u609f\u60aa\u60c5\u60e8\u610f\u611f\u614b\u614e\u61b6\u61c7\u61f8\u6210\u6211\u6212\u6226\u623b\u6240\u6247\u6249\u624b\u6253\u6255\u6271\u6280\u6291\u6295\u6297\u6298\u629c\u629e\u62b5\u62bc\u62bd\u62c5\u62d2\u62e0\u62e1\u62ff\u6301\u6307\u6311\u632f\u633a\u6349\u6355\u635c\u6368\u637b\u6388\u6392\u6398\u639b\u63a1\u63a2\u63a5\u63a8\u63b2\u63b4\u63c3\u63cf\u63d0\u63da\u63db\u63ee\u63f4\u63fa\u640d\u642c\u642d\u643e\u6483\u64a4\u64cd\u652f\u6539\u653b\u653e\u653f\u6545\u6551\u6557\u6559\u6562\u6563\u6570\u6574\u6575\u6577\u6587\u6599\u659c\u65ad\u65b0\u65b9\u65bd\u65c5\u65cb\u65d7\u65e2\u65e5\u65e7\u65e9\u6606\u6607\u660e\u6613\u661f\u663c\u6642\u6674\u6676\u66ae\u66b4\u66f2\u66f4\u66f8\u66ff\u6700\u6709\u670d\u671b\u671f\u6728\u672a\u672b\u672c\u6750\u6751\u6756\u6761\u6765\u6771\u677f\u6790\u6797\u679c\u679d\u67a0\u67af\u67d4\u67fb\u6804\u6839\u683c\u6848\u68af\u68b0\u68c4\u68da\u68ee\u691c\u696d\u6975\u697d\u69cb\u69d8\u69fd\u6a19\u6a21\u6a29\u6a2b\u6a3d\u6a5f\u6b20\u6b21\u6b32\u6b53\u6b62\u6b63\u6b66\u6b69\u6b7b\u6b8b\u6bb4\u6bb5\u6bba\u6bbb\u6bbf\u6bce\u6bd2\u6bd4\u6c11\u6c17\u6c34\u6c38\u6c42\u6c60\u6c7a\u6cbb\u6cc1\u6cca\u6cd5\u6ce8\u6d0b\u6d17\u6d3b\u6d3e\u6d41\u6d45\u6d6a\u6d6e\u6d77\u6d88\u6df1\u6e07\u6e08\u6e1b\u6e2c\u6e80\u6e90\u6e96\u6eb6\u6ec5\u6ef4\u6f0f\u6f14\u6f2c\u6f5c\u706b\u7070\u707d\u7089\u708e\u70ad\u70b8\u70b9\u70ba\u70c8\u7121\u7126\u7136\u713c\u7149\u7159\u7167\u717d\u719f\u71b1\u71c3\u71e5\u7206\u7247\u725b\u7269\u7272\u7279\u72a0\u72af\u72b6\u72c2\u72d9\u72e9\u72ec\u731b\u732e\u7372\u7387\u738b\u73cd\u73fe\u7403\u7406\u74a7\u74b0\u74e6\u751f\u7523\u7528\u7530\u7531\u7532\u7533\u753b\u754c\u7559\u755c\u7565\u756a\u7570\u7591\u7642\u767a\u767b\u767d\u7684\u7686\u76ae\u76bf\u76ca\u76d7\u76df\u76e3\u76e4\u76ee\u76f4\u76f8\u771f\u7720\u7740\u77ac\u77e2\u77e5\u77ed\u77f3\u7814\u7815\u7832\u7834\u786c\u78ba\u78e8\u790e\u793a\u7948\u795e\u7981\u79c0\u79c1\u79d1\u79d2\u79d8\u79fb\u7a0b\u7a0e\u7a2e\u7a3c\u7a4d\u7a4f\u7a74\u7a76\u7a7a\u7a81\u7a93\u7aae\u7acb\u7adc\u7ae0\u7aef\u7b0f\u7b11\u7b1b\u7b2c\u7b52\u7b56\u7b94\u7b97\u7ba1\u7bc0\u7bc4\u7bc9\u7c21\u7c89\u7c92\u7c97\u7cbe\u7d04\u7d05\u7d0b\u7d0d\u7d14\u7d1a\u7d20\u7d22\u7d30\u7d39\u7d42\u7d44\u7d46\u7d4c\u7d50\u7d5e\u7d66\u7d71\u7d76\u7d99\u7d9a\u7dad\u7db2\u7dbb\u7dd1\u7dda\u7de8\u7de9\u7df4\u7e26\u7e2e\u7e3e\u7e41\u7e4b\u7e54\u7e70\u7f6a\u7f6e\u7f85\u7f8e\u7fa4\u7fa9\u7ffb\u7ffc\u8003\u8005\u8010\u8089\u80a2\u80b2\u80c6\u80cc\u80fd\u8105\u8106\u811a\u8131\u8150\u8179\u81a0\u81e8\u81ea\u81ed\u81f3\u81f4\u820e\u822a\u8237\u8239\u8247\u8258\u8266\u826f\u8272\u82b8\u82e6\u8302\u8349\u8352\u8377\u83ab\u843d\u8449\u8457\u84b8\u84c4\u8535\u8584\u85ac\u8607\u8650\u866b\u878d\u8840\u884c\u8853\u8857\u885b\u885d\u8861\u8868\u88ab\u88c1\u88c2\u88c5\u88cf\u88dc\u88fd\u8907\u8972\u897f\u8981\u8987\u898b\u898f\u8996\u899a\u89a7\u89b3\u89d2\u89e3\u89e6\u8a00\u8a08\u8a13\u8a18\u8a23\u8a2a\u8a2d\u8a31\u8a33\u8a3c\u8a60\u8a66\u8a70\u8a71\u8a73\u8a87\u8a8d\u8a9e\u8aac\u8aad\u8ab0\u8abf\u8adc\u8b1d\u8b58\u8b66\u8b70\u8b77\u8c4a\u8c61\u8ca0\u8ca1\u8ca2\u8ca8\u8ca9\u8caa\u8cab\u8caf\u8cb7\u8cbb\u8cbc\u8cc2\u8cc4\u8cc7\u8cca\u8cea\u8cfc\u8d08\u8d64\u8d70\u8d77\u8d85\u8db3\u8ddd\u8de1\u8def\u8df3\u8eab\u8eca\u8ecc\u8ecd\u8edf\u8ee2\u8efd\u8f03\u8f09\u8f1d\u8f2a\u8f38\u8fba\u8fbc\u8fbf\u8fce\u8fd1\u8fd4\u8feb\u8ffd\u9000\u9001\u9003\u9006\u900f\u9010\u9014\u901a\u901f\u9020\u9023\u9031\u9032\u9045\u9047\u904a\u904b\u904e\u9053\u9054\u9059\u9060\u9063\u9069\u906d\u9078\u907f\u90aa\u90e8\u90fd\u914d\u916c\u9177\u9178\u91b8\u91cd\u91ce\u91cf\u91d1\u9244\u9271\u9280\u9283\u9285\u92ed\u92fc\u9306\u932c\u9332\u936e\u9396\u93ae\u93e1\u9577\u9580\u9589\u958b\u9593\u95a2\u95c7\u95d8\u9632\u963b\u964d\u9650\u9662\u9664\u9665\u9678\u967a\u967d\u968a\u968e\u969b\u969c\u96a0\u96a3\u96c6\u96c7\u96e2\u96e3\u96e8\u96ea\u96f7\u96fb\u9707\u9727\u9732\u9752\u975e\u9762\u9769\u9784\u97f3\u97ff\u9803\u9805\u9806\u9811\u9813\u9818\u982d\u983b\u983c\u984c\u9858\u985e\u98db\u98df\u98fe\u990a\u990c\u9996\u99c4\u99c6\u99d0\u9a0e\u9a12\u9a13\u9a5a\u9aa8\u9ab8\u9ad8\u9b54\u9b5a\u9ec4\u9ed2\uff01\uff05\uff06\uff08\uff09\uff0b\uff0d\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff1a\uff1f\uff53\uff5e\uff7d\uff83\uff85\uff92\uff9d\u2014\u201c\u201d\u2026\u3001\u3002\u300a\u300b\u3918\u39d0\u39df\u3e06\u4056\u43dd\u497d\u4983\u4e00\u4e01\u4e03\u4e07\u4e08\u4e09\u4e0a\u4e0b\u4e0d\u4e0e\u4e0f\u4e10\u4e11\u4e13\u4e14\u4e15\u4e16\u4e18\u4e19\u4e1a\u4e1b\u4e1c\u4e1d\u4e1e\u4e22\u4e24\u4e25\u4e27\u4e2a\u4e2b\u4e2d\u4e30\u4e32\u4e34\u4e38\u4e39\u4e3a\u4e3b\u4e3d\u4e3e\u4e42\u4e43\u4e45\u4e48\u4e49\u4e4b\u4e4c\u4e4d\u4e4e\u4e4f\u4e50\u4e52\u4e53\u4e54\u4e56\u4e58\u4e59\u4e5c\u4e5d\u4e5e\u4e5f\u4e60\u4e61\u4e66\u4e69\u4e70\u4e71\u4e73\u4e7e\u4e86\u4e88\u4e89\u4e8b\u4e8c\u4e8e\u4e8f\u4e91\u4e92\u4e93\u4e94\u4e95\u4e98\u4e9a\u4e9b\u4e9f\u4ea1\u4ea2\u4ea4\u4ea5\u4ea6\u4ea7\u4ea8\u4ea9\u4eab\u4eac\u4ead\u4eae\u4eb2\u4eb3\u4eb5\u4eb6\u4eba\u4ebf\u4ec0\u4ec1\u4ec2\u4ec3\u4ec4\u4ec5\u4ec6\u4ec7\u4ec9\u4eca\u4ecb\u4ecd\u4ece\u4ed1\u4ed3\u4ed4\u4ed5\u4ed6\u4ed7\u4ed8\u4ed9\u4ede\u4edf\u4ee1\u4ee3\u4ee4\u4ee5\u4ee8\u4eea\u4eeb\u4eec\u4ef0\u4ef2\u4ef5\u4ef6\u4ef7\u4efb\u4efd\u4eff\u4f01\u4f09\u4f0a\u4f0d\u4f0e\u4f0f\u4f10\u4f11\u4f17\u4f18\u4f19\u4f1a\u4f1b\u4f1e\u4f1f\u4f20\u4f22\u4f24\u4f25\u4f26\u4f27\u4f2a\u4f2b\u4f2f\u4f30\u4f34\u4f36\u4f38\u4f3a\u4f3c\u4f3d\u4f43\u4f46\u4f4d\u4f4e\u4f4f\u4f50\u4f51\u4f53\u4f55\u4f57\u4f58\u4f59\u4f5a\u4f5b\u4f5c\u4f5d\u4f5e\u4f5f\u4f60\u4f63\u4f64\u4f65\u4f69\u4f6c\u4f6f\u4f70\u4f73\u4f76\u4f7b\u4f7c\u4f7e\u4f7f\u4f83\u4f84\u4f88\u4f89\u4f8b\u4f8d\u4f8f\u4f91\u4f94\u4f97\u4f9b\u4f9d\u4fa0\u4fa3\u4fa5\u4fa6\u4fa7\u4fa8\u4fa9\u4faa\u4fac\u4fae\u4faf\u4fb5\u4fbf\u4fc3\u4fc4\u4fc5\u4fca\u4fce\u4fcf\u4fd0\u4fd1\u4fd7\u4fd8\u4fda\u4fdd\u4fde\u4fdf\u4fe1\u4fe3\u4fe6\u4fe8\u4fe9\u4fea\u4fed\u4fee\u4fef\u4ff1\u4ff3\u4ff5\u4ff6\u4ff8\u4ffa\u4ffe\u500c\u500d\u500f\u5012\u5014\u5018\u5019\u501a\u501c\u501f\u5021\u5025\u5026\u5028\u5029\u502a\u502c\u502d\u503a\u503c\u503e\u5043\u5047\u5048\u504c\u504e\u504f\u5055\u505a\u505c\u5065\u506c\u5076\u5077\u507b\u507e\u507f\u5080\u5085\u5088\u508d\u50a3\u50a5\u50a7\u50a8\u50a9\u50ac\u50b2\u50bb\u50cf\u50d6\u50da\u50e7\u50ed\u50ee\u50f0\u50f3\u50f5\u50fb\u5106\u510b\u5112\u5121\u513f\u5140\u5141\u5143\u5144\u5145\u5146\u5148\u5149\u514b\u514d\u5151\u5154\u5155\u5156\u515a\u515c\u5162\u5165\u5168\u516b\u516c\u516d\u516e\u5170\u5171\u5173\u5174\u5175\u5176\u5177\u5178\u5179\u517b\u517c\u517d\u5180\u5185\u5188\u5189\u518c\u518d\u5192\u5195\u5197\u5199\u519b\u519c\u51a0\u51a2\u51a4\u51a5\u51ac\u51af\u51b0\u51b2\u51b3\u51b5\u51b6\u51b7\u51bb\u51bc\u51bd\u51c0\u51c4\u51c6\u51c7\u51c9\u51cb\u51cc\u51cf\u51d1\u51db\u51dd\u51e0\u51e1\u51e4\u51eb\u51ed\u51ef\u51f0\u51f3\u51f6\u51f8\u51f9\u51fa\u51fb\u51fc\u51fd\u51ff\u5200\u5201\u5203\u5206\u5207\u5208\u520a\u520d\u520e\u5211\u5212\u5216\u5217\u5218\u5219\u521a\u521b\u521d\u5220\u5224\u5228\u5229\u522b\u522d\u522e\u5230\u5233\u5236\u5237\u5238\u5239\u523a\u523b\u523d\u523f\u5240\u5241\u5242\u5243\u524a\u524b\u524c\u524d\u5250\u5251\u5254\u5256\u525c\u525e\u5261\u5265\u5267\u5269\u526a\u526f\u5272\u527d\u527f\u5281\u5288\u5293\u529b\u529d\u529e\u529f\u52a0\u52a1\u52a2\u52a3\u52a8\u52a9\u52aa\u52ab\u52ac\u52ad\u52b1\u52b2\u52b3\u52bc\u52be\u52bf\u52c3\u52c7\u52c9\u52cb\u52d0\u52d2\u52d6\u52d8\u52df\u52e4\u52f0\u52fa\u52fe\u52ff\u5300\u5305\u5306\u5308\u530d\u530f\u5310\u5315\u5316\u5317\u5319\u531c\u531d\u5320\u5321\u5323\u5326\u532a\u532e\u5339\u533a\u533b\u533e\u533f\u5341\u5343\u5345\u5347\u5348\u5349\u534a\u534e\u534f\u5351\u5352\u5353\u5355\u5356\u5357\u535a\u535c\u535e\u535f\u5360\u5361\u5362\u5363\u5364\u5366\u5367\u536b\u536e\u536f\u5370\u5371\u5373\u5374\u5375\u5377\u5378\u537f\u5382\u5384\u5385\u5386\u5389\u538b\u538c\u538d\u5395\u5398\u539a\u539d\u539f\u53a2\u53a5\u53a6\u53a8\u53a9\u53ae\u53bb\u53be\u53bf\u53c1\u53c2\u53c6\u53c8\u53c9\u53ca\u53cb\u53cc\u53cd\u53d1\u53d4\u53d6\u53d7\u53d8\u53d9\u53db\u53df\u53e0\u53e3\u53e4\u53e5\u53e6\u53e8\u53e9\u53ea\u53eb\u53ec\u53ed\u53ee\u53ef\u53f0\u53f1\u53f2\u53f3\u53f5\u53f6\u53f7\u53f8\u53f9\u53fb\u53fc\u53fd\u5401\u5403\u5404\u5406\u5408\u5409\u540a\u540c\u540d\u540e\u540f\u5410\u5411\u5413\u5415\u5417\u541b\u541d\u541e\u541f\u5420\u5421\u5423\u5426\u5427\u5428\u5429\u542b\u542c\u542d\u542e\u542f\u5431\u5432\u5434\u5435\u5438\u5439\u543b\u543c\u543d\u543e\u5440\u5443\u5446\u5448\u544a\u544b\u5450\u5452\u5453\u5454\u5455\u5456\u5457\u5458\u545b\u545c\u5462\u5463\u5464\u5466\u5468\u5471\u5472\u5473\u5475\u5476\u5477\u5478\u547b\u547c\u547d\u5480\u5482\u5484\u5486\u548b\u548c\u548e\u548f\u5490\u5492\u5494\u5495\u5496\u5499\u549a\u549b\u549d\u54a3\u54a4\u54a6\u54a7\u54a8\u54a9\u54aa\u54ab\u54ac\u54af\u54b1\u54b3\u54b4\u54b8\u54bb\u54bd\u54bf\u54c0\u54c1\u54c2\u54c4\u54c6\u54c7\u54c8\u54c9\u54cc\u54cd\u54ce\u54cf\u54d0\u54d1\u54d3\u54d4\u54d5\u54d7\u54d9\u54da\u54dd\u54de\u54df\u54e5\u54e6\u54e7\u54e8\u54e9\u54ea\u54ed\u54ee\u54f2\u54fa\u54fc\u54fd\u5501\u5506\u5507\u5509\u550f\u5510\u5511\u5514\u551b\u5520\u5522\u5523\u5524\u5527\u552c\u552e\u552f\u5530\u5531\u5533\u5535\u5537\u553c\u553e\u553f\u5541\u5543\u5544\u5546\u5549\u554a\u5550\u5555\u5556\u555c\u5561\u5564\u5565\u5566\u5567\u556a\u556c\u556d\u556e\u5570\u5575\u5576\u5577\u5578\u557b\u557c\u557e\u5580\u5581\u5582\u5583\u5584\u5587\u5588\u5589\u558a\u558b\u558f\u5591\u5594\u5598\u5599\u559c\u559d\u559f\u55a7\u55b1\u55b3\u55b5\u55b7\u55b9\u55bb\u55bd\u55be\u55c4\u55c5\u55c9\u55cc\u55cd\u55d0\u55d1\u55d2\u55d3\u55d4\u55d6\u55dc\u55dd\u55de\u55df\u55e1\u55e3\u55e4\u55e5\u55e6\u55e8\u55ea\u55eb\u55ec\u55ef\u55f2\u55f3\u55f5\u55f7\u55fd\u55fe\u5600\u5601\u5608\u5609\u560c\u560e\u5618\u561a\u561b\u561e\u561f\u5621\u5623\u5624\u5627\u562c\u562d\u5631\u5632\u5634\u5636\u5639\u563b\u563f\u564c\u564d\u564e\u5654\u5657\u5658\u5659\u565c\u5662\u5664\u5668\u5669\u566a\u566b\u566c\u5671\u5676\u567b\u567c\u5684\u5685\u5686\u568e\u568f\u5693\u56a3\u56af\u56b7\u56bc\u56ca\u56d4\u56da\u56db\u56de\u56df\u56e0\u56e1\u56e2\u56e4\u56eb\u56ed\u56f0\u56f1\u56f4\u56f5\u56f9\u56fa\u56fd\u56fe\u56ff\u5703\u5704\u5706\u5708\u5709\u570a\u571c\u571f\u5723\u5728\u5729\u572a\u572c\u572d\u572e\u572f\u5730\u5733\u5739\u573a\u573b\u573e\u5740\u5742\u5747\u574a\u574c\u574d\u574e\u574f\u5750\u5751\u5757\u575a\u575b\u575d\u575e\u575f\u5760\u5761\u5764\u5766\u5768\u5769\u576a\u576b\u576d\u576f\u5773\u5777\u577b\u577c\u5782\u5783\u5784\u5786\u578b\u578c\u5792\u5793\u579b\u57a0\u57a1\u57a2\u57a3\u57a4\u57a6\u57a7\u57a9\u57ab\u57ad\u57ae\u57b1\u57b8\u57c2\u57c3\u57cb\u57ce\u57d2\u57d4\u57d5\u57d8\u57d9\u57da\u57dd\u57df\u57e0\u57e4\u57ed\u57ef\u57f4\u57f5\u57f8\u57f9\u57fa\u57fd\u5802\u5806\u5807\u5809\u580b\u580d\u5811\u5815\u5819\u581e\u5821\u5824\u582a\u5830\u5835\u5844\u5846\u584c\u584d\u5851\u5854\u5858\u585e\u586b\u586c\u587e\u5880\u5881\u5883\u5885\u5889\u5892\u5893\u5899\u589e\u589f\u58a8\u58a9\u58bc\u58c1\u58c5\u58d1\u58d5\u58e4\u58eb\u58ec\u58ee\u58f0\u58f3\u58f6\u58f9\u5904\u5907\u590d\u590f\u5914\u5915\u5916\u5919\u591a\u591c\u591f\u5924\u5927\u5929\u592a\u592b\u592c\u592d\u592e\u592f\u5931\u5934\u5937\u5938\u5939\u593a\u593c\u5941\u5942\u5944\u5947\u5948\u5949\u594b\u594e\u594f\u5951\u5954\u5955\u5956\u5957\u5958\u595a\u5960\u5962\u5965\u596d\u5973\u5974\u5976\u5978\u5979\u597d\u5981\u5982\u5983\u5984\u5986\u5987\u5988\u598a\u598d\u5992\u5993\u5996\u5997\u5999\u599e\u59a3\u59a4\u59a5\u59a8\u59a9\u59aa\u59ab\u59ae\u59af\u59b2\u59b9\u59bb\u59be\u59c6\u59ca\u59cb\u59d0\u59d1\u59d2\u59d3\u59d4\u59d7\u59d8\u59da\u59dc\u59dd\u59e3\u59e5\u59e8\u59ec\u59ee\u59f9\u59fb\u59ff\u5a01\u5a03\u5a04\u5a05\u5a06\u5a07\u5a08\u5a09\u5a0c\u5a11\u5a13\u5a18\u5a1c\u5a1f\u5a20\u5a23\u5a25\u5a29\u5a31\u5a32\u5a34\u5a36\u5a3c\u5a40\u5a46\u5a49\u5a4a\u5a55\u5a5a\u5a62\u5a67\u5a6a\u5a74\u5a75\u5a76\u5a77\u5a7a\u5a7f\u5a92\u5a9a\u5a9b\u5aaa\u5aad\u5ab2\u5ab3\u5ab5\u5ab8\u5abe\u5ac1\u5ac2\u5ac9\u5acc\u5ad2\u5ad4\u5ad6\u5ad8\u5ada\u5ae0\u5ae1\u5ae3\u5ae6\u5ae9\u5aeb\u5af1\u5b09\u5b16\u5b17\u5b34\u5b37\u5b40\u5b50\u5b51\u5b53\u5b54\u5b55\u5b57\u5b58\u5b59\u5b5a\u5b5b\u5b5c\u5b5d\u5b5f\u5b62\u5b63\u5b64\u5b65\u5b66\u5b69\u5b6a\u5b6c\u5b70\u5b71\u5b73\u5b75\u5b7a\u5b7d\u5b81\u5b83\u5b85\u5b87\u5b88\u5b89\u5b8b\u5b8c\u5b8f\u5b93\u5b95\u5b97\u5b98\u5b99\u5b9a\u5b9b\u5b9c\u5b9d\u5b9e\u5ba0\u5ba1\u5ba2\u5ba3\u5ba4\u5ba5\u5ba6\u5baa\u5bab\u5bb0\u5bb3\u5bb4\u5bb5\u5bb6\u5bb8\u5bb9\u5bbd\u5bbe\u5bbf\u5bc2\u5bc4\u5bc5\u5bc6\u5bc7\u5bcc\u5bd0\u5bd2\u5bd3\u5bdd\u5bde\u5bdf\u5be1\u5be4\u5be5\u5be8\u5bee\u5bf0\u5bf8\u5bf9\u5bfa\u5bfb\u5bfc\u5bff\u5c01\u5c04\u5c06\u5c09\u5c0a\u5c0f\u5c11\u5c14\u5c15\u5c16\u5c18\u5c1a\u5c1c\u5c1d\u5c24\u5c25\u5c27\u5c2c\u5c31\u5c34\u5c38\u5c39\u5c3a\u5c3b\u5c3c\u5c3d\u5c3e\u5c3f\u5c40\u5c41\u5c42\u5c45\u5c48\u5c49\u5c4a\u5c4b\u5c4e\u5c4f\u5c50\u5c51\u5c55\u5c59\u5c5e\u5c60\u5c61\u5c63\u5c65\u5c66\u5c6f\u5c71\u5c79\u5c7a\u5c7f\u5c81\u5c82\u5c88\u5c8c\u5c90\u5c91\u5c94\u5c96\u5c97\u5c98\u5c9a\u5c9b\u5ca2\u5ca3\u5ca9\u5cab\u5cac\u5cad\u5cb1\u5cb3\u5cb7\u5cb8\u5cbf\u5cc1\u5cc4\u5ccb\u5cd2\u5cd9\u5ce1\u5ce3\u5ce4\u5ce5\u5ce6\u5ce8\u5cea\u5ced\u5cf0\u5cfb\u5d02\u5d03\u5d06\u5d07\u5d0e\u5d14\u5d16\u5d1a\u5d1b\u5d24\u5d26\u5d29\u5d2d\u5d2e\u5d34\u5d3d\u5d47\u5d4a\u5d4b\u5d4c\u5d4e\u5d56\u5d58\u5d5b\u5d5d\u5d69\u5d6b\u5d6c\u5d6f\u5d74\u5d82\u5d99\u5d9d\u5db7\u5dc5\u5dc9\u5dcd\u5ddd\u5dde\u5de1\u5de2\u5de5\u5de6\u5de7\u5de8\u5de9\u5deb\u5dee\u5def\u5df1\u5df2\u5df3\u5df4\u5df7\u5dfd\u5dfe\u5e01\u5e02\u5e03\u5e05\u5e06\u5e08\u5e0c\u5e0f\u5e10\u5e11\u5e14\u5e15\u5e16\u5e18\u5e19\u5e1a\u5e1b\u5e1c\u5e1d\u5e26\u5e27\u5e2d\u5e2e\u5e37\u5e38\u5e3b\u5e3c\u5e3d\u5e42\u5e44\u5e45\u5e4c\u5e54\u5e55\u5e5b\u5e5e\u5e61\u5e62\u5e72\u5e73\u5e74\u5e76\u5e78\u5e7a\u5e7b\u5e7c\u5e7d\u5e7f\u5e84\u5e86\u5e87\u5e8a\u5e8b\u5e8f\u5e90\u5e91\u5e93\u5e94\u5e95\u5e96\u5e97\u5e99\u5e9a\u5e9c\u5e9e\u5e9f\u5ea0\u5ea5\u5ea6\u5ea7\u5ead\u5eb5\u5eb6\u5eb7\u5eb8\u5eb9\u5ebe\u5ec9\u5eca\u5ed3\u5ed6\u5edb\u5ee8\u5eea\u5ef6\u5ef7\u5efa\u5eff\u5f00\u5f01\u5f02\u5f03\u5f04\u5f08\u5f0a\u5f0b\u5f0f\u5f11\u5f13\u5f15\u5f17\u5f18\u5f1b\u5f1f\u5f20\u5f25\u5f26\u5f27\u5f29\u5f2d\u5f2f\u5f31\u5f39\u5f3a\u5f3c\u5f40\u5f52\u5f53\u5f55\u5f57\u5f58\u5f5d\u5f62\u5f64\u5f66\u5f67\u5f69\u5f6a\u5f6c\u5f6d\u5f70\u5f71\u5f77\u5f79\u5f7b\u5f7c\u5f80\u5f81\u5f82\u5f84\u5f85\u5f87\u5f88\u5f89\u5f8a\u5f8b\u5f8c\u5f90\u5f92\u5f95\u5f97\u5f98\u5f99\u5f9c\u5fa1\u5fa8\u5faa\u5fad\u5fae\u5fb5\u5fb7\u5fbc\u5fbd\u5fc3\u5fc5\u5fc6\u5fcc\u5fcd\u5fcf\u5fd0\u5fd1\u5fd2\u5fd6\u5fd7\u5fd8\u5fd9\u5fdd\u5fe0\u5fe1\u5fe4\u5fe7\u5fea\u5feb\u5fed\u5ff1\u5ff5\u5ff8\u5ffb\u5ffd\u5ffe\u5fff\u6000\u6001\u6002\u6003\u6004\u6005\u6006\u600d\u600e\u600f\u6012\u6014\u6015\u6016\u6019\u601b\u601c\u601d\u6020\u6021\u6025\u6026\u6027\u6028\u6029\u602a\u602b\u602f\u6035\u603b\u603c\u603f\u6041\u6042\u6043\u604b\u604d\u6050\u6052\u6053\u6055\u6059\u605a\u6062\u6063\u6064\u6068\u6069\u606a\u606b\u606c\u606d\u606f\u6070\u6073\u6076\u6078\u6079\u607a\u607b\u607c\u607d\u607f\u6084\u6089\u608c\u608d\u6092\u6094\u6096\u609a\u609b\u609d\u609f\u60a0\u60a3\u60a6\u60a8\u60ab\u60ac\u60ad\u60af\u60b1\u60b2\u60b4\u60b8\u60bb\u60bc\u60c5\u60c6\u60c7\u60ca\u60cb\u60d1\u60d5\u60d8\u60da\u60dc\u60dd\u60df\u60e0\u60e6\u60e7\u60e8\u60e9\u60eb\u60ec\u60ed\u60ee\u60ef\u60f0\u60f3\u60f4\u60f6\u60f9\u60fa\u6100\u6101\u6106\u6108\u6109\u610e\u610f\u6114\u6115\u611a\u611f\u6120\u6123\u6124\u6126\u6127\u612b\u613f\u6148\u614a\u614c\u614e\u6151\u6155\u615d\u6162\u6167\u6168\u6170\u6175\u6177\u618b\u618e\u6194\u61a7\u61a8\u61a9\u61ac\u61be\u61c2\u61c8\u61ca\u61cb\u61d1\u61d2\u61e6\u61f5\u61ff\u6206\u6208\u620a\u620c\u620d\u620e\u620f\u6210\u6211\u6212\u6215\u6216\u6217\u6218\u621a\u621b\u621f\u6221\u6222\u6225\u622a\u622c\u622e\u6233\u6234\u6237\u623d\u623e\u623f\u6240\u6241\u6243\u6247\u6248\u6249\u624b\u624d\u624e\u6251\u6252\u6253\u6254\u6258\u625b\u6263\u6266\u6267\u6269\u626a\u626b\u626c\u626d\u626e\u626f\u6270\u6273\u6276\u6279\u627c\u627e\u627f\u6280\u6283\u6284\u6289\u628a\u6291\u6292\u6293\u6294\u6295\u6296\u6297\u6298\u629a\u629b\u629f\u62a0\u62a1\u62a2\u62a4\u62a5\u62a8\u62ab\u62ac\u62b1\u62b5\u62b9\u62bb\u62bc\u62bd\u62bf\u62c2\u62c3\u62c4\u62c5\u62c6\u62c7\u62c8\u62c9\u62ca\u62cc\u62cd\u62ce\u62d0\u62d2\u62d3\u62d4\u62d6\u62d7\u62d8\u62d9\u62da\u62db\u62dc\u62df\u62e2\u62e3\u62e4\u62e5\u62e6\u62e7\u62e8\u62e9\u62ec\u62ed\u62ee\u62ef\u62f1\u62f3\u62f4\u62f7\u62fc\u62fd\u62fe\u62ff\u6301\u6302\u6307\u6308\u6309\u630e\u6311\u6316\u631a\u631b\u631d\u631e\u631f\u6320\u6321\u6323\u6324\u6325\u6326\u6328\u632a\u632b\u632f\u6332\u6339\u633a\u633d\u6342\u6343\u6345\u6346\u6349\u634b\u634c\u634d\u634e\u634f\u6350\u6355\u635e\u635f\u6361\u6362\u6363\u6367\u6369\u636d\u636e\u636f\u6376\u6377\u637a\u637b\u637d\u6380\u6382\u6387\u6388\u6389\u638a\u638c\u638f\u6390\u6392\u6396\u6398\u63a0\u63a2\u63a3\u63a5\u63a7\u63a8\u63a9\u63aa\u63ac\u63ae\u63b0\u63b3\u63b4\u63b7\u63b8\u63ba\u63bc\u63be\u63c4\u63c6\u63c9\u63cd\u63cf\u63d0\u63d2\u63d6\u63e0\u63e1\u63e3\u63e9\u63ea\u63ed\u63f3\u63f4\u63f6\u63f8\u63fd\u63ff\u6400\u6401\u6402\u6405\u640b\u640f\u6410\u6413\u6414\u641b\u641c\u641e\u6420\u6421\u6426\u642a\u642c\u642d\u6434\u643a\u643d\u6441\u6444\u6445\u6446\u6447\u6448\u644a\u6452\u6454\u6458\u645e\u6467\u6469\u646d\u6478\u6479\u647d\u6482\u6484\u6485\u6487\u6491\u6492\u6495\u6499\u649e\u64a4\u64a9\u64ac\u64ad\u64ae\u64b0\u64b5\u64b7\u64b8\u64ba\u64bc\u64c0\u64c2\u64c5\u64cd\u64ce\u64d2\u64d8\u64de\u64e2\u64e4\u64e6\u6500\u6509\u6512\u6518\u6525\u652b\u652e\u652f\u6536\u6538\u6539\u653b\u653e\u653f\u6545\u6548\u654c\u654f\u6551\u6555\u6556\u6559\u655b\u655d\u655e\u6562\u6563\u6566\u656b\u656c\u6570\u6572\u6574\u6577\u6587\u658b\u658c\u6590\u6591\u6593\u6597\u6599\u659b\u659c\u659f\u65a1\u65a4\u65a5\u65a7\u65a9\u65ab\u65ad\u65af\u65b0\u65b9\u65bc\u65bd\u65c1\u65c3\u65c4\u65c5\u65c6\u65cb\u65cc\u65ce\u65cf\u65d2\u65d6\u65d7\u65e0\u65e2\u65e5\u65e6\u65e7\u65e8\u65e9\u65ec\u65ed\u65ee\u65ef\u65f0\u65f1\u65f6\u65f7\u65f8\u65fa\u65fb\u6600\u6602\u6603\u6606\u6609\u660a\u660c\u660e\u660f\u6613\u6614\u6615\u6619\u661d\u661f\u6620\u6625\u6627\u6628\u662d\u662f\u6631\u6634\u6635\u6636\u663c\u663e\u6641\u6643\u664b\u664c\u664f\u6652\u6653\u6655\u6657\u665a\u665e\u665f\u6661\u6664\u6666\u6668\u666e\u666f\u6670\u6674\u6676\u6677\u667a\u667e\u6682\u6684\u6687\u668c\u6691\u6696\u6697\u669d\u66a7\u66a8\u66ae\u66b4\u66b9\u66be\u66d9\u66db\u66dc\u66dd\u66e6\u66e9\u66f0\u66f2\u66f3\u66f4\u66f7\u66f9\u66fc\u66fe\u66ff\u6700\u6708\u6709\u670b\u670d\u6710\u6714\u6715\u6717\u671b\u671d\u671f\u6726\u6728\u672a\u672b\u672c\u672d\u672f\u6731\u6734\u6735\u673a\u673d\u6740\u6742\u6743\u6746\u6748\u6749\u674c\u674e\u674f\u6750\u6751\u6753\u6756\u675c\u675e\u675f\u6760\u6761\u6765\u6768\u676a\u676d\u676f\u6770\u6772\u6773\u6775\u6777\u677b\u677c\u677e\u677f\u6781\u6784\u6787\u6789\u678b\u6790\u6795\u6797\u679a\u679c\u679d\u679e\u67a2\u67a3\u67a5\u67a7\u67a8\u67aa\u67ab\u67ad\u67af\u67b0\u67b3\u67b5\u67b6\u67b7\u67b8\u67c1\u67c4\u67c8\u67cf\u67d0\u67d1\u67d2\u67d3\u67d4\u67d8\u67d9\u67da\u67dc\u67dd\u67de\u67e0\u67e2\u67e5\u67e9\u67ec\u67ef\u67f0\u67f1\u67f3\u67f4\u67fd\u67ff\u6800\u6805\u6807\u6808\u6809\u680a\u680b\u680c\u680e\u680f\u6811\u6813\u6816\u6817\u681d\u681f\u6821\u6829\u682a\u6832\u6833\u6837\u6838\u6839\u683c\u683d\u683e\u6840\u6841\u6842\u6843\u6845\u6846\u6848\u6849\u684c\u684e\u6850\u6851\u6853\u6854\u6855\u6861\u6862\u6863\u6864\u6865\u6866\u6867\u6868\u6869\u686b\u6874\u6876\u6877\u6881\u6883\u6885\u6886\u688f\u6893\u6897\u68a2\u68a6\u68a7\u68a8\u68ad\u68af\u68b0\u68b3\u68b5\u68bf\u68c0\u68c1\u68c2\u68c9\u68cb\u68cd\u68d2\u68d5\u68d8\u68da\u68e0\u68e3\u68ee\u68f0\u68f1\u68f5\u68f9\u68fa\u68fb\u68fc\u6901\u6905\u690b\u690d\u690e\u6910\u6912\u691f\u6920\u6924\u692a\u692d\u6930\u6934\u693d\u693f\u6942\u6954\u695a\u695d\u6960\u6963\u6966\u696b\u696e\u696f\u6977\u6978\u6979\u697c\u6982\u6984\u6986\u6988\u6989\u6994\u6995\u6996\u699b\u699c\u69a7\u69a8\u69ab\u69ad\u69b1\u69b4\u69b7\u69bb\u69c1\u69ca\u69cc\u69ce\u69d0\u69d4\u69db\u69df\u69e0\u69ed\u69f2\u69fd\u69ff\u6a0a\u6a17\u6a18\u6a1f\u6a21\u6a28\u6a2a\u6a2f\u6a31\u6a35\u6a3d\u6a3e\u6a44\u6a47\u6a50\u6a58\u6a59\u6a5b\u6a61\u6a71\u6a79\u6a7c\u6a80\u6a84\u6a8e\u6a90\u6a97\u6aa0\u6aa9\u6aac\u6b20\u6b21\u6b22\u6b23\u6b24\u6b27\u6b32\u6b38\u6b3a\u6b3e\u6b43\u6b46\u6b47\u6b49\u6b4c\u6b59\u6b62\u6b63\u6b64\u6b65\u6b66\u6b67\u6b6a\u6b79\u6b7b\u6b7c\u6b81\u6b82\u6b83\u6b84\u6b86\u6b87\u6b89\u6b8a\u6b8b\u6b8d\u6b92\u6b93\u6b96\u6b9a\u6b9b\u6ba1\u6baa\u6bb4\u6bb5\u6bb7\u6bbf\u6bc1\u6bc2\u6bc5\u6bcb\u6bcd\u6bcf\u6bd2\u6bd3\u6bd4\u6bd5\u6bd6\u6bd7\u6bd9\u6bdb\u6be1\u6bea\u6beb\u6bef\u6bf3\u6bf9\u6bfd\u6c05\u6c06\u6c07\u6c0d\u6c0f\u6c10\u6c11\u6c13\u6c14\u6c16\u6c18\u6c19\u6c1a\u6c1b\u6c1f\u6c21\u6c22\u6c24\u6c26\u6c27\u6c28\u6c29\u6c2a\u6c2e\u6c2f\u6c30\u6c32\u6c34\u6c38\u6c40\u6c41\u6c42\u6c46\u6c47\u6c49\u6c4a\u6c50\u6c54\u6c55\u6c57\u6c5b\u6c5c\u6c5d\u6c5e\u6c5f\u6c60\u6c61\u6c64\u6c68\u6c69\u6c6a\u6c70\u6c72\u6c74\u6c76\u6c79\u6c7d\u6c7e\u6c81\u6c82\u6c83\u6c85\u6c86\u6c88\u6c89\u6c8c\u6c8f\u6c90\u6c93\u6c94\u6c99\u6c9a\u6c9b\u6c9f\u6ca1\u6ca3\u6ca4\u6ca5\u6ca6\u6ca7\u6ca8\u6ca9\u6caa\u6cab\u6cad\u6cae\u6cb1\u6cb3\u6cb8\u6cb9\u6cbb\u6cbc\u6cbd\u6cbe\u6cbf\u6cc4\u6cc5\u6cc9\u6cca\u6ccc\u6cd0\u6cd3\u6cd4\u6cd5\u6cd6\u6cd7\u6cdb\u6cde\u6ce0\u6ce1\u6ce2\u6ce3\u6ce5\u6ce8\u6cea\u6ceb\u6cee\u6cef\u6cf0\u6cf1\u6cf3\u6cf5\u6cf7\u6cf8\u6cfa\u6cfb\u6cfc\u6cfd\u6cfe\u6d01\u6d04\u6d07\u6d0b\u6d0c\u6d0e\u6d12\u6d17\u6d19\u6d1b\u6d1e\u6d25\u6d27\u6d2a\u6d2b\u6d2e\u6d31\u6d32\u6d33\u6d35\u6d39\u6d3b\u6d3c\u6d3d\u6d3e\u6d41\u6d43\u6d45\u6d46\u6d47\u6d4a\u6d4b\u6d4d\u6d4e\u6d4f\u6d51\u6d52\u6d53\u6d54\u6d55\u6d59\u6d5a\u6d5c\u6d5e\u6d60\u6d63\u6d65\u6d66\u6d69\u6d6a\u6d6e\u6d6f\u6d74\u6d77\u6d78\u6d82\u6d85\u6d88\u6d89\u6d8c\u6d8e\u6d91\u6d93\u6d94\u6d95\u6d9b\u6d9d\u6d9e\u6d9f\u6da0\u6da1\u6da3\u6da4\u6da6\u6da7\u6da8\u6da9\u6daa\u6dab\u6dae\u6daf\u6db2\u6db5\u6db8\u6dbf\u6dc0\u6dc4\u6dc5\u6dc6\u6dc7\u6dcb\u6dcc\u6dd1\u6dd6\u6dd8\u6dd9\u6ddd\u6dde\u6de0\u6de1\u6de4\u6de6\u6deb\u6dec\u6dee\u6df1\u6df3\u6df7\u6df9\u6dfb\u6e05\u6e0a\u6e0c\u6e0d\u6e0e\u6e10\u6e11\u6e14\u6e17\u6e1a\u6e1d\u6e20\u6e21\u6e23\u6e24\u6e25\u6e29\u6e2b\u6e2d\u6e2f\u6e32\u6e34\u6e38\u6e3a\u6e43\u6e44\u6e49\u6e4d\u6e4e\u6e54\u6e56\u6e58\u6e5b\u6e5c\u6e5f\u6e6b\u6e6e\u6e72\u6e7e\u6e7f\u6e83\u6e85\u6e86\u6e89\u6e8f\u6e90\u6e98\u6e9c\u6e9f\u6ea2\u6ea5\u6ea7\u6eaa\u6eaf\u6eb1\u6eb2\u6eb4\u6eb6\u6eb7\u6eba\u6ebb\u6ebd\u6ec1\u6ec2\u6ec3\u6ec7\u6ecb\u6ecf\u6ed1\u6ed3\u6ed4\u6ed5\u6ed7\u6eda\u6ede\u6edf\u6ee1\u6ee2\u6ee4\u6ee5\u6ee6\u6ee8\u6ee9\u6eea\u6eeb\u6ef4\u6ef9\u6f02\u6f06\u6f09\u6f0f\u6f13\u6f14\u6f15\u6f20\u6f29\u6f2a\u6f2b\u6f2d\u6f2f\u6f31\u6f33\u6f36\u6f3e\u6f47\u6f4b\u6f4d\u6f58\u6f5c\u6f5e\u6f5f\u6f62\u6f66\u6f6d\u6f6e\u6f72\u6f74\u6f78\u6f7a\u6f7c\u6f84\u6f88\u6f89\u6f8c\u6f8d\u6f8e\u6f9c\u6fa1\u6fa5\u6fa7\u6fb3\u6fb6\u6fb9\u6fc0\u6fc2\u6fc9\u6fd1\u6fd2\u6fde\u6fe0\u6fe1\u6fee\u6fef\u7011\u701a\u701b\u7023\u704c\u704f\u705e\u706b\u706d\u706f\u7070\u7075\u7076\u7078\u707c\u707e\u707f\u7080\u7085\u7089\u708a\u708e\u7092\u7094\u7095\u7096\u7098\u7099\u709c\u709d\u70ab\u70ac\u70ad\u70ae\u70af\u70b1\u70b3\u70b7\u70b8\u70b9\u70bb\u70bc\u70bd\u70c0\u70c1\u70c2\u70c3\u70c8\u70ca\u70d8\u70d9\u70db\u70dc\u70df\u70e4\u70e6\u70e7\u70e8\u70e9\u70eb\u70ec\u70ed\u70ef\u70f7\u70f9\u70fd\u7109\u710a\u7110\u7113\u7115\u7116\u7117\u7118\u7119\u711a\u711c\u7126\u712f\u7130\u7131\u7136\u7145\u714a\u714c\u714e\u715c\u715e\u7164\u7166\u7167\u7168\u716e\u7172\u7173\u7178\u717a\u717d\u7184\u718a\u718f\u7194\u7198\u7199\u719c\u719f\u71a0\u71a5\u71a8\u71ac\u71b5\u71b9\u71c3\u71ce\u71d4\u71d5\u71e0\u71e5\u71e7\u71ee\u71f9\u7206\u721d\u7228\u722a\u722c\u7230\u7231\u7235\u7236\u7237\u7238\u7239\u723b\u723d\u723f\u7241\u7242\u7247\u7248\u724c\u724d\u7252\u7256\u7259\u725b\u725d\u725f\u7261\u7262\u7264\u7266\u7267\u7269\u726e\u726f\u7272\u7275\u7279\u727a\u727e\u7280\u7281\u7284\u728a\u728b\u728d\u728f\u7292\u729f\u72ac\u72af\u72b0\u72b6\u72b7\u72b8\u72b9\u72c1\u72c2\u72c4\u72c8\u72cd\u72ce\u72d0\u72d2\u72d7\u72d9\u72de\u72e0\u72e1\u72e8\u72e9\u72ec\u72ed\u72ee\u72ef\u72f0\u72f1\u72f2\u72f3\u72f7\u72f8\u72fa\u72fc\u7301\u7303\u730e\u7315\u7316\u7317\u731b\u731c\u731d\u731e\u7321\u7322\u7325\u7329\u732a\u732b\u732c\u732e\u7331\u7334\u7337\u7339\u733e\u733f\u7350\u7352\u7357\u7360\u736c\u736d\u7374\u737e\u7384\u7387\u7389\u738b\u738e\u7391\u7395\u7396\u7399\u739b\u73a0\u73a1\u73a2\u73a5\u73a6\u73a9\u73ab\u73ad\u73ae\u73af\u73b0\u73b2\u73b3\u73b7\u73ba\u73bb\u73c0\u73c2\u73c8\u73c9\u73ca\u73cd\u73cf\u73d0\u73d1\u73d9\u73de\u73e0\u73e3\u73e5\u73e7\u73e9\u73ed\u73f0\u73f2\u7403\u7405\u7406\u7407\u7409\u740f\u7410\u741a\u741b\u7422\u7424\u7425\u7426\u7428\u742a\u742b\u742c\u742e\u742f\u7430\u7433\u7434\u7435\u7436\u743c\u7441\u7444\u7455\u7457\u7459\u745a\u745b\u745c\u745e\u745f\u746d\u7470\u7476\u747e\u7480\u7481\u7483\u7487\u7488\u748b\u748e\u7490\u7498\u749c\u749e\u749f\u74a0\u74a7\u74a8\u74a9\u74aa\u74ba\u74d2\u74d8\u74dc\u74e0\u74e2\u74e3\u74e4\u74e6\u74ee\u74ef\u74f4\u74f6\u74f7\u74ff\u7504\u750d\u750f\u7511\u7518\u751a\u751c\u751f\u7525\u7528\u7529\u752b\u752c\u752d\u7530\u7531\u7532\u7533\u7535\u7537\u7538\u753a\u753b\u753e\u7540\u7545\u7548\u754b\u754c\u754e\u754f\u7554\u7559\u755a\u755b\u755c\u7565\u7566\u756a\u7572\u7574\u7578\u7579\u757f\u7583\u7586\u758f\u7591\u7594\u7596\u7597\u7599\u759a\u759d\u759f\u75a0\u75a1\u75a3\u75a4\u75a5\u75ab\u75ac\u75ad\u75ae\u75af\u75b1\u75b2\u75b3\u75b4\u75b5\u75b8\u75b9\u75bc\u75bd\u75be\u75c2\u75c5\u75c7\u75c8\u75c9\u75ca\u75cd\u75d2\u75d4\u75d5\u75d8\u75db\u75de\u75e2\u75e3\u75e4\u75e6\u75e7\u75e8\u75ea\u75eb\u75f0\u75f1\u75f4\u75f9\u75fc\u75ff\u7601\u7603\u7606\u760a\u760c\u7610\u7618\u7619\u761b\u761f\u7620\u7622\u7624\u7626\u7629\u762a\u762b\u7630\u7633\u7634\u7635\u7638\u763c\u763e\u763f\u7643\u764c\u764d\u7654\u7656\u765c\u765e\u7663\u766b\u766f\u7678\u767b\u767d\u767e\u7682\u7684\u7686\u7687\u7688\u768b\u768e\u7691\u7693\u7696\u7699\u76a4\u76ae\u76b1\u76b2\u76b4\u76bf\u76c2\u76c5\u76c6\u76c8\u76c9\u76ca\u76cd\u76ce\u76cf\u76d0\u76d1\u76d2\u76d4\u76d6\u76d7\u76d8\u76db\u76df\u76e5\u76ee\u76ef\u76f1\u76f2\u76f4\u76f8\u76f9\u76fc\u76fe\u7701\u7704\u7707\u7708\u7709\u770a\u770b\u770d\u7719\u771f\u7720\u7726\u7728\u7729\u772c\u772d\u772f\u7735\u7736\u7737\u7738\u773a\u773c\u7740\u7741\u7743\u7744\u7747\u7750\u7751\u775a\u775b\u7761\u7762\u7763\u7765\u7766\u7768\u776b\u776c\u7779\u777d\u777e\u777f\u7780\u7784\u7785\u778b\u778c\u778e\u7791\u7792\u779f\u77a0\u77a2\u77a5\u77a7\u77a9\u77aa\u77ac\u77ad\u77b0\u77b3\u77bb\u77bd\u77bf\u77cd\u77d7\u77db\u77dc\u77e2\u77e3\u77e5\u77e9\u77eb\u77ec\u77ed\u77ee\u77f3\u77f6\u77f8\u77fe\u77ff\u7800\u7801\u7802\u780c\u780d\u7812\u7814\u7816\u7817\u7818\u781a\u781c\u781d\u781f\u7823\u7825\u7827\u782d\u7830\u7834\u7837\u7838\u7839\u783a\u783b\u783c\u783e\u7840\u7845\u7847\u784c\u784e\u7850\u7852\u7855\u7856\u7857\u785d\u786b\u786c\u786d\u786e\u787c\u7887\u7889\u788c\u788d\u788e\u7891\u7893\u7897\u7898\u789a\u789b\u789c\u789f\u78a1\u78a3\u78a7\u78b0\u78b1\u78b2\u78b3\u78b4\u78be\u78c1\u78c5\u78ca\u78cb\u78d0\u78d4\u78d5\u78d9\u78e8\u78ec\u78f2\u78f4\u78f7\u7901\u7905\u7913\u7934\u793a\u793c\u793e\u7940\u7941\u7946\u7947\u7948\u7949\u794e\u7953\u7956\u7957\u795a\u795b\u795c\u795d\u795e\u795f\u7960\u7962\u7965\u7968\u796d\u796f\u7977\u7978\u797a\u797e\u7980\u7981\u7984\u7985\u798a\u798f\u79a7\u79b3\u79b9\u79ba\u79bb\u79bd\u79be\u79c0\u79c1\u79c3\u79c6\u79c9\u79cb\u79cd\u79d1\u79d2\u79d5\u79d8\u79df\u79e3\u79e4\u79e6\u79e7\u79e9\u79eb\u79ed\u79ef\u79f0\u79f8\u79fb\u79fd\u79fe\u7a00\u7a02\u7a03\u7a0b\u7a0d\u7a0e\u7a14\u7a17\u7a1a\u7a1e\u7a20\u7a23\u7a33\u7a37\u7a3b\u7a3c\u7a3d\u7a3f\u7a46\u7a51\u7a57\u7a70\u7a74\u7a76\u7a77\u7a79\u7a7a\u7a7f\u7a81\u7a83\u7a84\u7a88\u7a8d\u7a91\u7a92\u7a95\u7a96\u7a97\u7a98\u7a9c\u7a9d\u7a9f\u7aa0\u7aa3\u7aa5\u7aa6\u7aa8\u7ab3\u7ab8\u7abf\u7acb\u7ad1\u7ad6\u7ad9\u7ade\u7adf\u7ae0\u7ae3\u7ae5\u7ae6\u7aed\u7aef\u7af9\u7afa\u7afd\u7aff\u7b03\u7b04\u7b06\u7b08\u7b0a\u7b0b\u7b0f\u7b11\u7b14\u7b15\u7b19\u7b1b\u7b1e\u7b20\u7b24\u7b25\u7b26\u7b28\u7b2a\u7b2c\u7b2e\u7b33\u7b38\u7b3a\u7b3c\u7b3e\u7b47\u7b49\u7b4b\u7b4c\u7b4f\u7b50\u7b51\u7b52\u7b54\u7b56\u7b5a\u7b5b\u7b5d\u7b60\u7b62\u7b6e\u7b71\u7b72\u7b75\u7b77\u7b79\u7b7e\u7b80\u7b85\u7b8d\u7b90\u7b93\u7b94\u7b95\u7b97\u7b9c\u7ba1\u7ba2\u7ba6\u7ba7\u7ba9\u7baa\u7bab\u7bac\u7bad\u7bb1\u7bb4\u7bb8\u7bc1\u7bc6\u7bc7\u7bcc\u7bd1\u7bd3\u7bd9\u7bdd\u7be1\u7be5\u7be6\u7bea\u7bee\u7bf1\u7bf7\u7bfc\u7bfe\u7c07\u7c0b\u7c0c\u7c16\u7c1f\u7c27\u7c2a\u7c38\u7c3f\u7c40\u7c41\u7c4d\u7c73\u7c74\u7c7b\u7c7c\u7c7d\u7c89\u7c91\u7c92\u7c95\u7c97\u7c98\u7c9c\u7c9d\u7c9e\u7c9f\u7ca4\u7ca5\u7caa\u7cae\u7cb1\u7cb2\u7cb3\u7cb9\u7cbc\u7cbd\u7cbe\u7cbf\u7cc1\u7cc5\u7cca\u7ccc\u7ccd\u7cd5\u7cd6\u7cd7\u7cd9\u7cdc\u7cdf\u7ce0\u7ce8\u7cef\u7cfb\u7d0a\u7d20\u7d22\u7d27\u7d2b\u7d2f\u7d6e\u7da6\u7dae\u7e20\u7e3b\u7e41\u7e47\u7e82\u7e9b\u7ea0\u7ea1\u7ea2\u7ea3\u7ea4\u7ea5\u7ea6\u7ea7\u7ea8\u7eaa\u7eab\u7eac\u7ead\u7eaf\u7eb0\u7eb1\u7eb2\u7eb3\u7eb4\u7eb5\u7eb6\u7eb7\u7eb8\u7eb9\u7eba\u7ebd\u7ebe\u7ebf\u7ec0\u7ec1\u7ec2\u7ec3\u7ec4\u7ec5\u7ec6\u7ec7\u7ec8\u7ec9\u7eca\u7ecc\u7ecd\u7ece\u7ecf\u7ed1\u7ed2\u7ed3\u7ed4\u7ed5\u7ed7\u7ed8\u7ed9\u7eda\u7edb\u7edc\u7edd\u7ede\u7edf\u7ee0\u7ee1\u7ee2\u7ee3\u7ee5\u7ee6\u7ee7\u7ee8\u7ee9\u7eea\u7eeb\u7eed\u7eee\u7eef\u7ef0\u7ef1\u7ef2\u7ef3\u7ef4\u7ef5\u7ef6\u7ef7\u7ef8\u7efa\u7efb\u7efc\u7efd\u7efe\u7eff\u7f00\u7f01\u7f02\u7f03\u7f04\u7f05\u7f06\u7f07\u7f08\u7f09\u7f0c\u7f0e\u7f11\u7f12\u7f13\u7f14\u7f15\u7f16\u7f17\u7f18\u7f19\u7f1a\u7f1b\u7f1c\u7f1d\u7f1f\u7f20\u7f21\u7f22\u7f23\u7f24\u7f25\u7f26\u7f27\u7f28\u7f29\u7f2a\u7f2b\u7f2c\u7f2d\u7f2e\u7f2f\u7f30\u7f31\u7f32\u7f33\u7f34\u7f35\u7f36\u7f38\u7f3a\u7f42\u7f44\u7f45\u7f50\u7f51\u7f54\u7f55\u7f57\u7f58\u7f5a\u7f5f\u7f61\u7f62\u7f68\u7f69\u7f6a\u7f6e\u7f71\u7f72\u7f74\u7f79\u7f7d\u7f7e\u7f81\u7f8a\u7f8c\u7f8e\u7f91\u7f94\u7f9a\u7f9e\u7f9f\u7fa1\u7fa4\u7fa7\u7faf\u7fb0\u7fb2\u7fb8\u7fb9\u7fbc\u7fbd\u7fbf\u7fc1\u7fc5\u7fca\u7fcc\u7fce\u7fd4\u7fd5\u7fd8\u7fda\u7fdf\u7fe0\u7fe1\u7fe5\u7fe9\u7fee\u7ff0\u7ff1\u7ff3\u7ffb\u7ffc\u8000\u8001\u8003\u8004\u8005\u8006\u800b\u800c\u800d\u8010\u8012\u8015\u8016\u8017\u8018\u8019\u801c\u8020\u8022\u8025\u8026\u8027\u8028\u8029\u802a\u8031\u8033\u8036\u8037\u8038\u803b\u803d\u803f\u8042\u8043\u8046\u804a\u804b\u804c\u8052\u8054\u8058\u805a\u8069\u806a\u8071\u807f\u8083\u8084\u8086\u8087\u8089\u808b\u808c\u8093\u8096\u8098\u809a\u809b\u809d\u809f\u80a0\u80a1\u80a2\u80a4\u80a5\u80a9\u80aa\u80ab\u80ae\u80af\u80b1\u80b2\u80b4\u80ba\u80bc\u80bd\u80be\u80bf\u80c0\u80c1\u80c2\u80c3\u80c4\u80c6\u80cc\u80cd\u80ce\u80d6\u80d7\u80d9\u80da\u80db\u80dc\u80dd\u80de\u80e1\u80e4\u80e5\u80e7\u80e8\u80ea\u80eb\u80ec\u80ed\u80ef\u80f0\u80f1\u80f3\u80f4\u80f6\u80f8\u80fa\u80fc\u80fd\u8102\u8106\u8109\u810a\u810d\u810f\u8110\u8111\u8112\u8113\u8114\u8116\u8118\u811a\u812c\u812f\u8131\u8132\u8138\u813e\u8146\u8148\u814a\u814b\u814c\u8150\u8151\u8153\u8154\u8155\u815a\u8160\u8165\u8167\u8169\u816d\u816e\u8170\u8171\u8174\u8179\u817a\u817b\u817c\u817e\u817f\u8180\u8182\u8188\u818a\u818f\u8191\u8198\u8199\u819b\u819c\u819d\u81a6\u81a8\u81b3\u81ba\u81bb\u81c0\u81c2\u81c3\u81c6\u81ca\u81cc\u81dc\u81e3\u81e7\u81ea\u81ec\u81ed\u81f3\u81f4\u81fb\u81fc\u81fe\u8200\u8202\u8204\u8205\u8206\u820c\u820d\u8210\u8212\u8214\u821b\u821c\u821e\u821f\u8222\u822a\u822b\u822c\u8230\u8231\u8234\u8235\u8236\u8237\u8238\u8239\u823b\u8244\u8247\u824b\u824f\u8258\u825f\u8268\u826e\u826f\u8270\u8272\u8273\u827a\u827d\u827e\u827f\u8282\u8284\u828a\u828b\u828d\u828e\u8291\u8292\u8297\u8299\u829c\u829d\u829f\u82a1\u82a5\u82a6\u82a8\u82a9\u82aa\u82ab\u82ac\u82ad\u82ae\u82af\u82b1\u82b3\u82b7\u82b8\u82b9\u82bc\u82bd\u82be\u82c1\u82c4\u82c7\u82c8\u82cb\u82cc\u82cd\u82ce\u82cf\u82d1\u82d2\u82d3\u82d4\u82d5\u82d7\u82d8\u82db\u82dc\u82de\u82df\u82e1\u82e3\u82e4\u82e5\u82e6\u82eb\u82ef\u82f1\u82f4\u82f7\u82f9\u82fb\u8300\u8301\u8302\u8303\u8304\u8305\u8306\u8309\u830c\u830e\u830f\u8311\u8313\u8314\u8315\u8317\u831a\u831c\u8327\u8328\u832b\u832c\u832d\u832f\u8331\u8334\u8335\u8336\u8338\u8339\u833c\u8340\u8343\u8346\u8347\u8349\u834f\u8350\u8351\u8352\u8354\u835a\u835c\u835e\u835f\u8360\u8361\u8363\u8364\u8365\u8366\u8367\u8368\u8369\u836a\u836b\u836c\u836e\u836f\u8377\u8378\u837b\u837c\u837d\u8385\u8386\u8389\u838e\u8392\u8393\u8398\u839b\u839c\u839e\u83a0\u83a8\u83a9\u83aa\u83ab\u83b1\u83b2\u83b3\u83b4\u83b7\u83b8\u83b9\u83ba\u83bc\u83bd\u83c0\u83c1\u83c5\u83c7\u83ca\u83cc\u83cf\u83d4\u83d6\u83d8\u83dc\u83df\u83e0\u83e1\u83e9\u83ea\u83f0\u83f1\u83f2\u83f9\u83fd\u8401\u8403\u8404\u840b\u840c\u840d\u840e\u840f\u8411\u8418\u841c\u841d\u8424\u8425\u8426\u8427\u8428\u8431\u8438\u843c\u843d\u8446\u8451\u8457\u845a\u845b\u8461\u8463\u8469\u846b\u846c\u846d\u8471\u8473\u8475\u8476\u8478\u847a\u8482\u848b\u848c\u8497\u8499\u849c\u849f\u84a1\u84af\u84b2\u84b4\u84b8\u84b9\u84ba\u84bd\u84bf\u84c1\u84c4\u84c9\u84ca\u84cd\u84d0\u84d1\u84d3\u84d6\u84dd\u84df\u84e0\u84e5\u84e6\u84ec\u84fc\u84ff\u8511\u8513\u8517\u851a\u851f\u8521\u852b\u852c\u8537\u8538\u853a\u853b\u853c\u853d\u8543\u8548\u8549\u854a\u8556\u8559\u855e\u8564\u8568\u8572\u8574\u857a\u857b\u857e\u8584\u8585\u8587\u858f\u859b\u859c\u85a4\u85a8\u85aa\u85ae\u85af\u85b0\u85b7\u85b9\u85c1\u85c9\u85cf\u85d0\u85d3\u85d5\u85dc\u85e0\u85e4\u85e9\u85fb\u85ff\u8605\u8611\u8616\u8627\u8629\u8638\u864e\u864f\u8650\u8651\u8654\u865a\u865e\u8662\u866b\u866c\u866e\u8671\u8679\u867a\u867b\u867c\u867d\u867e\u867f\u8680\u8681\u8682\u868a\u868b\u868c\u868d\u8693\u8695\u869c\u869d\u86a3\u86a4\u86a7\u86a8\u86a9\u86aa\u86ac\u86af\u86b0\u86b1\u86b4\u86b6\u86c0\u86c4\u86c6\u86c7\u86c9\u86ca\u86cb\u86ce\u86cf\u86d0\u86d4\u86d8\u86d9\u86db\u86de\u86df\u86e4\u86e9\u86ed\u86ee\u86f0\u86f1\u86f2\u86f3\u86f4\u86f8\u86f9\u86fe\u8700\u8702\u8703\u8707\u8708\u8709\u870a\u870d\u8712\u8713\u8715\u8717\u8718\u871a\u871c\u871e\u8721\u8722\u8723\u8725\u8729\u872e\u8731\u8734\u8737\u873b\u873f\u8747\u8748\u8749\u874c\u874e\u8753\u8757\u8759\u8760\u8763\u8765\u876e\u8770\u8774\u8776\u877b\u877c\u877d\u877e\u8782\u8783\u8785\u8788\u878b\u878d\u879f\u87a0\u87a8\u87ab\u87ac\u87ad\u87af\u87b3\u87b5\u87ba\u87bd\u87c0\u87c6\u87ca\u87cb\u87d1\u87d2\u87db\u87e0\u87e5\u87ea\u87ee\u87f9\u87fe\u880a\u8813\u8815\u8816\u8821\u8822\u8832\u8839\u8840\u8844\u8845\u884c\u884d\u8854\u8857\u8859\u8861\u8862\u8863\u8865\u8868\u8869\u886b\u886c\u886e\u8870\u8872\u8877\u887d\u887e\u887f\u8881\u8882\u8884\u8885\u8888\u888b\u888d\u8892\u8896\u889c\u88a2\u88a4\u88ab\u88ad\u88b1\u88b7\u88c1\u88c2\u88c5\u88c6\u88c9\u88ce\u88d2\u88d4\u88d5\u88d8\u88d9\u88df\u88e2\u88e4\u88e5\u88e8\u88f0\u88f1\u88f3\u88f4\u88f8\u88f9\u88fe\u8902\u890a\u8910\u8912\u8913\u8919\u891a\u891b\u891f\u8921\u8925\u892a\u892b\u8930\u8934\u8936\u8941\u8944\u895e\u895f\u8966\u897b\u897f\u8981\u8983\u8986\u89c1\u89c2\u89c4\u89c5\u89c6\u89c7\u89c8\u89c9\u89ca\u89cb\u89ce\u89cf\u89d0\u89d1\u89d2\u89da\u89de\u89e3\u89e5\u89e6\u89eb\u89ef\u89f3\u8a00\u8a07\u8a1a\u8a3e\u8a48\u8a79\u8a89\u8a8a\u8a93\u8b07\u8b66\u8b6c\u8ba1\u8ba2\u8ba3\u8ba4\u8ba5\u8ba6\u8ba7\u8ba8\u8ba9\u8baa\u8bab\u8bad\u8bae\u8baf\u8bb0\u8bb2\u8bb3\u8bb4\u8bb5\u8bb6\u8bb7\u8bb8\u8bb9\u8bba\u8bbc\u8bbd\u8bbe\u8bbf\u8bc0\u8bc1\u8bc2\u8bc3\u8bc4\u8bc5\u8bc6\u8bc8\u8bc9\u8bca\u8bcb\u8bcc\u8bcd\u8bcf\u8bd1\u8bd2\u8bd3\u8bd4\u8bd5\u8bd6\u8bd7\u8bd8\u8bd9\u8bda\u8bdb\u8bdc\u8bdd\u8bde\u8bdf\u8be0\u8be1\u8be2\u8be3\u8be4\u8be5\u8be6\u8be7\u8be8\u8be9\u8beb\u8bec\u8bed\u8bee\u8bef\u8bf0\u8bf1\u8bf2\u8bf3\u8bf4\u8bf5\u8bf7\u8bf8\u8bf9\u8bfa\u8bfb\u8bfc\u8bfd\u8bfe\u8bff\u8c00\u8c01\u8c02\u8c03\u8c04\u8c05\u8c06\u8c07\u8c08\u8c0a\u8c0b\u8c0c\u8c0d\u8c0e\u8c0f\u8c10\u8c11\u8c12\u8c13\u8c14\u8c15\u8c16\u8c17\u8c19\u8c1a\u8c1b\u8c1c\u8c1d\u8c1f\u8c20\u8c21\u8c22\u8c23\u8c24\u8c25\u8c26\u8c27\u8c28\u8c29\u8c2a\u8c2c\u8c2d\u8c2e\u8c2f\u8c30\u8c31\u8c32\u8c33\u8c34\u8c35\u8c36\u8c37\u8c41\u8c46\u8c47\u8c49\u8c4c\u8c55\u8c5a\u8c61\u8c62\u8c68\u8c6a\u8c6b\u8c73\u8c78\u8c79\u8c7a\u8c82\u8c85\u8c89\u8c8a\u8c8c\u8c94\u8c98\u8d1d\u8d1e\u8d1f\u8d21\u8d22\u8d23\u8d24\u8d25\u8d26\u8d27\u8d28\u8d29\u8d2a\u8d2b\u8d2c\u8d2d\u8d2e\u8d2f\u8d30\u8d31\u8d32\u8d33\u8d34\u8d35\u8d36\u8d37\u8d38\u8d39\u8d3a\u8d3b\u8d3c\u8d3d\u8d3e\u8d3f\u8d41\u8d42\u8d43\u8d44\u8d45\u8d47\u8d48\u8d49\u8d4a\u8d4b\u8d4c\u8d4d\u8d4e\u8d4f\u8d50\u8d53\u8d54\u8d55\u8d56\u8d58\u8d59\u8d5a\u8d5b\u8d5c\u8d5d\u8d5e\u8d5f\u8d60\u8d61\u8d62\u8d63\u8d64\u8d66\u8d67\u8d6b\u8d6d\u8d70\u8d73\u8d74\u8d75\u8d76\u8d77\u8d81\u8d84\u8d85\u8d8a\u8d8b\u8d91\u8d94\u8d9f\u8da3\u8db1\u8db3\u8db4\u8db5\u8db8\u8dba\u8dbe\u8dbf\u8dc3\u8dc4\u8dc6\u8dcb\u8dcc\u8dce\u8dcf\u8dd0\u8dd1\u8dd6\u8dd7\u8dda\u8ddb\u8ddd\u8dde\u8ddf\u8de3\u8de4\u8de8\u8dea\u8dec\u8def\u8df3\u8df5\u8df6\u8df7\u8df8\u8df9\u8dfa\u8dfb\u8e05\u8e09\u8e0a\u8e0c\u8e0f\u8e12\u8e14\u8e1d\u8e1e\u8e1f\u8e22\u8e29\u8e2a\u8e2c\u8e2e\u8e2f\u8e31\u8e35\u8e39\u8e3a\u8e3d\u8e40\u8e41\u8e42\u8e44\u8e47\u8e48\u8e49\u8e4a\u8e4b\u8e51\u8e52\u8e59\u8e5a\u8e66\u8e69\u8e6c\u8e6d\u8e70\u8e72\u8e74\u8e76\u8e7c\u8e7d\u8e7e\u8e7f\u8e81\u8e85\u8e87\u8e8f\u8e90\u8e9c\u8e9e\u8eab\u8eac\u8eaf\u8eb2\u8eba\u8f66\u8f67\u8f68\u8f69\u8f6b\u8f6c\u8f6d\u8f6e\u8f6f\u8f70\u8f71\u8f72\u8f73\u8f74\u8f76\u8f78\u8f7b\u8f7c\u8f7d\u8f7e\u8f7f\u8f82\u8f83\u8f84\u8f85\u8f86\u8f87\u8f88\u8f89\u8f8a\u8f8b\u8f8d\u8f8e\u8f8f\u8f90\u8f91\u8f93\u8f94\u8f95\u8f96\u8f97\u8f98\u8f99\u8f9a\u8f9b\u8f9c\u8f9e\u8f9f\u8fa3\u8fa8\u8fa9\u8fab\u8fb0\u8fb1\u8fb9\u8fbd\u8fbe\u8fc1\u8fc2\u8fc4\u8fc5\u8fc7\u8fc8\u8fce\u8fd0\u8fd1\u8fd3\u8fd4\u8fd5\u8fd8\u8fd9\u8fdb\u8fdc\u8fdd\u8fde\u8fdf\u8fe2\u8fe4\u8fe5\u8fe6\u8fe8\u8fe9\u8fea\u8feb\u8fed\u8fee\u8ff0\u8ff7\u8ff8\u8ff9\u8ffd\u9000\u9001\u9002\u9003\u9004\u9005\u9006\u9009\u900a\u900b\u900d\u900f\u9010\u9011\u9012\u9014\u9016\u9017\u901a\u901b\u901d\u901e\u901f\u9020\u9021\u9022\u9026\u902e\u902f\u9035\u9036\u9038\u903b\u903c\u903e\u9041\u9042\u9044\u9047\u904d\u904f\u9050\u9051\u9052\u9053\u9057\u905b\u9062\u9063\u9065\u9068\u906d\u906e\u9074\u9075\u907d\u907f\u9080\u9082\u9083\u9088\u908b\u9091\u9093\u9095\u9097\u9099\u909b\u909d\u90a2\u90a3\u90a6\u90aa\u90ac\u90ae\u90af\u90b0\u90b1\u90b3\u90b4\u90b5\u90b6\u90b8\u90b9\u90ba\u90bb\u90be\u90c1\u90c4\u90c5\u90c7\u90ca\u90ce\u90cf\u90d1\u90d3\u90d7\u90db\u90dc\u90dd\u90e1\u90e2\u90e4\u90e6\u90e7\u90e8\u90eb\u90ed\u90ef\u90f4\u90f8\u90fd\u90fe\u90ff\u9102\u9104\u9119\u911e\u9122\u912f\u9131\u9143\u9146\u9149\u914a\u914b\u914c\u914d\u9150\u9152\u9157\u915a\u915d\u915e\u9161\u9162\u9163\u9164\u9165\u9169\u916a\u916c\u916e\u916f\u9170\u9171\u9175\u9176\u9177\u9178\u9179\u917d\u917f\u9185\u9187\u9189\u918b\u918c\u918d\u9190\u9192\u919a\u919b\u91a2\u91aa\u91ae\u91af\u91b4\u91ba\u91c7\u91c9\u91ca\u91cc\u91cd\u91ce\u91cf\u91d1\u91dc\u9274\u92ae\u92c6\u92c8\u933e\u936a\u938f\u93ca\u93d6\u943e\u946b\u9487\u9488\u9489\u948a\u948b\u948c\u948d\u948e\u948f\u9492\u9493\u9495\u9497\u9499\u949a\u949b\u949d\u949e\u949f\u94a0\u94a1\u94a2\u94a3\u94a4\u94a5\u94a6\u94a7\u94a8\u94a9\u94ab\u94ae\u94af\u94b0\u94b1\u94b2\u94b3\u94b4\u94b5\u94b9\u94ba\u94bb\u94bc\u94bd\u94be\u94bf\u94c0\u94c1\u94c2\u94c3\u94c4\u94c5\u94c6\u94c8\u94c9\u94ca\u94cb\u94cc\u94cd\u94ce\u94d0\u94d1\u94d2\u94d7\u94d9\u94db\u94dc\u94dd\u94df\u94e0\u94e1\u94e2\u94e3\u94e4\u94e7\u94e8\u94e9\u94ea\u94eb\u94ec\u94ed\u94ee\u94ef\u94f0\u94f1\u94f2\u94f3\u94f5\u94f6\u94f7\u94f8\u94fa\u94fb\u94fc\u94fe\u94ff\u9500\u9501\u9502\u9503\u9504\u9505\u9506\u9507\u9508\u9509\u950b\u950c\u950f\u9510\u9511\u9512\u9514\u9515\u9517\u9519\u951a\u951b\u951c\u951d\u951e\u951f\u9521\u9522\u9523\u9524\u9525\u9526\u9528\u9529\u952d\u952e\u952f\u9530\u9531\u9532\u9534\u9535\u9536\u9537\u9538\u9539\u953b\u9540\u9541\u9542\u9547\u9549\u954a\u954c\u954d\u954f\u9550\u9551\u9552\u9553\u9554\u9556\u9557\u9558\u955a\u955b\u955c\u955d\u955e\u9560\u9561\u9562\u9563\u9566\u9567\u9569\u956a\u956b\u956c\u956d\u956f\u9570\u9572\u9573\u9574\u9575\u9576\u957f\u95e8\u95e9\u95ea\u95ed\u95ee\u95ef\u95f0\u95f1\u95f2\u95f3\u95f4\u95f5\u95f7\u95f8\u95f9\u95fa\u95fb\u95fc\u95fd\u95fe\u95ff\u9600\u9601\u9602\u9603\u9604\u9605\u9606\u9607\u9608\u9609\u960a\u960b\u960d\u960e\u960f\u9610\u9611\u9612\u9614\u9615\u9616\u9617\u9619\u961a\u961c\u961f\u9621\u962a\u962e\u9631\u9632\u9633\u9634\u9635\u9636\u963b\u963f\u9640\u9642\u9644\u9645\u9646\u9647\u9648\u9649\u964b\u964c\u964d\u9650\u9654\u9655\u965b\u965f\u9661\u9662\u9664\u9668\u9669\u966a\u966c\u9672\u9675\u9676\u9677\u9685\u9686\u9688\u968b\u968d\u968f\u9690\u9694\u9697\u9698\u9699\u969c\u96a7\u96b0\u96b3\u96b6\u96bc\u96bd\u96be\u96c0\u96c1\u96c4\u96c5\u96c6\u96c7\u96c9\u96cc\u96cd\u96ce\u96cf\u96d2\u96d5\u96e0\u96e8\u96e9\u96ea\u96ef\u96f1\u96f3\u96f6\u96f7\u96f9\u96fe\u9700\u9701\u9704\u9706\u9707\u9708\u9709\u970d\u970e\u970f\u9713\u9716\u971c\u971e\u9728\u972a\u972d\u9730\u9732\u9738\u9739\u973e\u9752\u9753\u9756\u9759\u975b\u975e\u9760\u9761\u9762\u9765\u9769\u9770\u9773\u9774\u9776\u9778\u977a\u977c\u977f\u9785\u978b\u978d\u9791\u9792\u9798\u97a0\u97a1\u97a3\u97a7\u97a8\u97ab\u97ac\u97ad\u97af\u97b2\u97b4\u97e6\u97e7\u97e9\u97ea\u97eb\u97ec\u97ed\u97f3\u97f5\u97f6\u9875\u9876\u9877\u9878\u9879\u987a\u987b\u987c\u987d\u987e\u987f\u9880\u9881\u9882\u9883\u9884\u9885\u9886\u9887\u9888\u9889\u988a\u988c\u988d\u988e\u988f\u9890\u9891\u9893\u9894\u9896\u9897\u9898\u9899\u989a\u989b\u989c\u989d\u989e\u989f\u98a0\u98a1\u98a2\u98a4\u98a6\u98a7\u98ce\u98d1\u98d2\u98d3\u98d5\u98d8\u98d9\u98de\u98df\u98e7\u98e8\u990d\u9910\u992e\u9954\u9955\u9965\u9967\u9968\u9969\u996a\u996b\u996c\u996d\u996e\u996f\u9970\u9971\u9972\u9974\u9975\u9976\u9977\u9978\u9979\u997a\u997c\u997d\u997f\u9981\u9983\u9984\u9985\u9986\u9987\u9988\u998a\u998b\u998d\u998f\u9990\u9991\u9992\u9993\u9994\u9995\u9996\u9997\u9999\u99a5\u99a8\u9a6c\u9a6d\u9a6e\u9a6f\u9a70\u9a71\u9a73\u9a74\u9a76\u9a77\u9a78\u9a79\u9a7b\u9a7c\u9a7d\u9a7e\u9a7f\u9a80\u9a81\u9a82\u9a84\u9a85\u9a86\u9a87\u9a88\u9a8a\u9a8b\u9a8c\u9a8e\u9a8f\u9a90\u9a91\u9a92\u9a93\u9a96\u9a97\u9a98\u9a9a\u9a9b\u9a9c\u9a9d\u9a9e\u9a9f\u9aa0\u9aa1\u9aa2\u9aa3\u9aa4\u9aa5\u9aa7\u9aa8\u9ab0\u9ab6\u9ab7\u9ab8\u9aba\u9abc\u9ac0\u9ac1\u9ac2\u9ac5\u9acb\u9acc\u9ad1\u9ad3\u9ad8\u9ae1\u9ae6\u9aeb\u9aed\u9aef\u9af9\u9afb\u9b03\u9b08\u9b0f\u9b13\u9b1f\u9b23\u9b32\u9b3b\u9b3c\u9b41\u9b42\u9b43\u9b44\u9b45\u9b46\u9b47\u9b48\u9b49\u9b4d\u9b4f\u9b51\u9b54\u9c7c\u9c7f\u9c80\u9c81\u9c82\u9c85\u9c86\u9c87\u9c88\u9c8b\u9c8d\u9c8e\u9c90\u9c91\u9c94\u9c9a\u9c9b\u9c9c\u9c9e\u9c9f\u9ca0\u9ca1\u9ca2\u9ca3\u9ca4\u9ca5\u9ca7\u9ca8\u9ca9\u9cab\u9cae\u9cb1\u9cb2\u9cb3\u9cb4\u9cb5\u9cb7\u9cb8\u9cbb\u9cbc\u9cbd\u9cc0\u9cc3\u9cc4\u9cc5\u9cc7\u9cca\u9ccc\u9ccd\u9cce\u9ccf\u9cd0\u9cd3\u9cd4\u9cd5\u9cd6\u9cd7\u9cd9\u9cdc\u9cdd\u9cde\u9cdf\u9ce2\u9e1f\u9e20\u9e21\u9e22\u9e23\u9e25\u9e26\u9e28\u9e29\u9e2a\u9e2b\u9e2c\u9e2d\u9e2e\u9e2f\u9e31\u9e32\u9e33\u9e35\u9e36\u9e37\u9e38\u9e39\u9e3b\u9e3d\u9e3e\u9e3f\u9e41\u9e42\u9e43\u9e44\u9e45\u9e46\u9e47\u9e48\u9e49\u9e4a\u9e4b\u9e4c\u9e4f\u9e50\u9e51\u9e55\u9e57\u9e58\u9e5a\u9e5b\u9e5c\u9e5e\u9e64\u9e66\u9e67\u9e69\u9e6a\u9e6b\u9e6c\u9e6d\u9e6e\u9e70\u9e73\u9e7f\u9e82\u9e87\u9e88\u9e8b\u9e92\u9e93\u9e9d\u9e9f\u9ea6\u9eb8\u9ebb\u9ebd\u9ebe\u9ec4\u9ecd\u9ece\u9ecf\u9ed1\u9ed4\u9ed8\u9edb\u9edc\u9edd\u9edf\u9ee0\u9ee2\u9ee5\u9ee7\u9ee9\u9eea\u9eef\u9efb\u9efc\u9efe\u9f0b\u9f0d\u9f0e\u9f10\u9f13\u9f19\u9f20\u9f22\u9f2c\u9f2f\u9f39\u9f3b\u9f3e\u9f41\u9f49\u9f50\u9f51\u9f7f\u9f80\u9f83\u9f84\u9f85\u9f87\u9f88\u9f89\u9f8a\u9f8b\u9f8c\u9f99\u9f9a\u9f9b\u9f9f\u9fa0\uff01\uff08\uff09\uff0c\uff1a\uff1f\ud843\udcd0\ud857\uded7\ud870\ude7c\uac00\uac01\uac04\uac07\uac08\uac10\uac11\uac12\uac13\uac14\uac15\uac16\uac19\uac1a\uac1b\uac1c\uac1d\uac24\uac31\uac40\uac54\uac70\uac71\uac74\uac77\uac78\uac80\uac81\uac83\uac89\uac8c\uac9f\uaca0\uaca8\uaca9\uacaa\uacac\uacb0\uacb9\uacbc\uacbd\uacc1\uacc4\uace0\uace1\uace4\uace7\uace8\uacf0\uacf1\uacf3\uacf5\uacfc\uacfd\uad00\uad11\uad1c\uad34\uad49\uad50\uad6c\uad6d\uad70\uad73\uad74\uad75\uad76\uad7d\uad81\uad8c\uada4\uadc0\uadd3\uaddc\uade0\uade4\uadf8\uadf9\uadfc\uae00\uae01\uae08\uae09\uae0b\uae0d\uae30\uae34\uae38\uae40\uae43\uae45\uae4a\uae4c\uae4d\uae4e\uae50\uae54\uae5c\uae5d\uae61\uae65\uae68\uae85\uaebc\uaebe\uaecc\uaecd\uaecf\uaed8\uaef4\uaf2c\uaf2d\uaf34\uaf3c\uaf3d\uaf42\uaf43\uaf49\uaf5d\uaf64\uaf80\uafb8\uafbc\uafc0\uafc8\ub00c\ub044\ub048\ub04a\ub04c\ub053\ub054\ub057\ub05d\ub07c\ub084\ub08c\ub098\ub099\ub09a\ub09c\ub0a0\ub0a1\ub0a8\ub0a9\ub0ab\ub0ac\ub0ad\ub0ae\ub0af\ub0b1\ub0b3\ub0b4\ub0bc\ub0c4\ub0c5\ub0c7\ub0c8\ub0c9\ub0d0\ub0e5\ub108\ub109\ub10c\ub110\ub113\ub118\ub123\ub124\ub125\ub137\ub140\ub141\ub144\ub150\ub155\ub158\ub178\ub179\ub17c\ub180\ub188\ub18d\ub192\ub193\ub194\ub1cc\ub1e8\ub204\ub208\ub20c\ub215\ub258\ub274\ub284\ub290\ub291\ub294\ub298\ub299\ub2a5\ub2a6\ub2ac\ub2c8\ub2c9\ub2cc\ub2d0\ub2d8\ub2d9\ub2db\ub2dd\ub2e4\ub2e5\ub2e6\ub2e8\ub2eb\ub2ec\ub2ed\ub2ee\ub2f4\ub2f5\ub2f7\ub2f9\ub2ff\ub300\ub301\ub310\ub313\ub354\ub355\ub358\ub35c\ub35f\ub364\ub365\ub367\ub369\ub36e\ub370\ub378\ub3c4\ub3c5\ub3c8\ub3cc\ub3d4\ub3d5\ub3d7\ub3d9\ub3db\ub3fc\ub410\ub418\ub41c\ub420\ub428\ub429\ub450\ub451\ub454\ub458\ub460\ub461\ub465\ub4a4\ub4b7\ub4c0\ub4c8\ub4dc\ub4dd\ub4e0\ub4e3\ub4e4\ub4ec\ub4ed\ub4ef\ub4f1\ub514\ub515\ub51c\ub527\ub528\ub529\ub52a\ub530\ub538\ub540\ub545\ub54c\ub5a0\ub5a1\ub5a4\ub5a8\ub5b1\ub5b4\ub5bb\ub5bc\ub610\ub611\ub69d\ub6ab\ub6b1\ub6f0\ub728\ub729\ub739\ub73b\ub77c\ub77d\ub780\ub78c\ub78d\ub791\ub797\ub798\ub799\ub79c\ub7a8\ub7ab\ub7b5\ub7c9\ub7ec\ub7ed\ub7f0\ub7f4\ub7fc\ub7fd\ub7ff\ub801\ub807\ub808\ub809\ub80c\ub818\ub81b\ub824\ub825\ub828\ub82c\ub834\ub835\ub838\ub839\ub840\ub85c\ub85d\ub860\ub864\ub86c\ub86d\ub86f\ub8b0\ub8cc\ub8e8\ub8e9\ub8f9\ub8fb\ub904\ub958\ub959\ub960\ub968\ub96d\ub974\ub978\ub97c\ub984\ub985\ub987\ub98e\ub9ac\ub9ad\ub9b0\ub9b4\ub9bc\ub9bd\ub9bf\ub9c1\ub9c8\ub9c9\ub9cc\ub9ce\ub9d0\ub9d1\ub9d8\ub9d9\ub9db\ub9dd\ub9de\ub9e1\ub9e3\ub9e4\ub9e5\ub9e8\ub9ec\ub9f5\ub9f9\ub9fa\uba38\uba39\uba3c\uba40\uba48\uba4b\uba4d\uba4e\uba54\uba58\uba70\uba74\uba78\uba85\uba87\ubaa8\ubaa9\ubaac\ubab0\ubab8\ubab9\ubabb\ubabd\ubb18\ubb34\ubb35\ubb36\ubb38\ubb3b\ubb3c\ubb44\ubb47\ubb50\ubb54\ubb58\ubb63\ubba4\ubbc0\ubbf8\ubbfc\ubbff\ubc00\ubc09\ubc0c\ubc0f\ubc11\ubc14\ubc15\ubc16\ubc18\ubc1b\ubc1c\ubc1d\ubc1f\ubc24\ubc25\ubc27\ubc29\ubc2d\ubc30\ubc31\ubc34\ubc38\ubc40\ubc43\ubc45\ubc49\ubc84\ubc88\ubc8c\ubc94\ubc95\ubc97\ubca0\ubca4\ubca8\ubcbc\ubcbd\ubcc0\ubcc4\ubccd\ubcd1\ubcd5\ubcf4\ubcf5\ubcf6\ubcf8\ubcfc\ubd04\ubd05\ubd07\ubd09\ubd10\ubd48\ubd59\ubd80\ubd81\ubd84\ubd88\ubd89\ubd90\ubd91\ubd93\ubd95\ubd99\ubdf0\ube0c\ube10\ube14\ube44\ube45\ube48\ube4c\ube54\ube55\ube57\ube59\ube5a\ube5b\ube60\ube61\ube68\ube75\ube7c\ube8f\ubea8\ubed0\ubed4\ubed7\ubf08\ubf09\ubf51\ubfb0\ubfcc\ubfd0\ubfd4\ubfdc\uc058\uc068\uc0ac\uc0ad\uc0b0\uc0b4\uc0b6\uc0bc\uc0bf\uc0c1\uc0c8\uc0c9\uc0cc\uc0d8\uc0dd\uc0e4\uc0f5\uc0f7\uc11c\uc11d\uc11e\uc120\uc124\uc12c\uc12d\uc12f\uc131\uc138\uc139\uc13c\uc140\uc148\uc149\uc14b\uc154\uc158\uc168\uc18c\uc18d\uc190\uc194\uc19c\uc19f\uc1a1\uc1a5\uc1c4\uc1e0\uc1fc\uc218\uc219\uc21c\uc21f\uc220\uc228\uc22b\uc22d\uc232\uc258\uc26c\uc270\uc27d\uc288\uc290\uc2a4\uc2a8\uc2ac\uc2b4\uc2b5\uc2b7\uc2b9\uc2dc\uc2dd\uc2e0\uc2e3\uc2e4\uc2eb\uc2ec\uc2ed\uc2ef\uc2f1\uc2f6\uc2f8\uc2f9\uc2fc\uc300\uc30d\uc313\uc368\uc369\uc370\uc379\uc384\uc3d8\uc3df\uc3e9\uc3f4\uc464\uc465\uc4f0\uc4f4\uc4f8\uc500\uc50c\uc528\uc529\uc52c\uc539\uc53b\uc544\uc545\uc548\uc549\uc54a\uc54c\uc553\uc554\uc555\uc557\uc558\uc559\uc55e\uc560\uc561\uc564\uc568\uc571\uc575\uc57c\uc57d\uc580\uc584\uc587\uc58c\uc591\uc595\uc597\uc598\uc5b4\uc5b5\uc5b8\uc5b9\uc5bb\uc5bc\uc5c4\uc5c5\uc5c6\uc5c7\uc5c8\uc5c9\uc5ca\uc5cc\uc5ce\uc5d0\uc5d1\uc5d4\uc5d8\uc5ec\uc5ed\uc5f0\uc5f4\uc5f7\uc5fc\uc5fd\uc5ff\uc600\uc601\uc606\uc608\uc61b\uc624\uc625\uc628\uc62c\uc62e\uc633\uc635\uc637\uc639\uc640\uc644\uc653\uc654\uc655\uc65c\uc660\uc678\uc67c\uc694\uc695\uc6a9\uc6b0\uc6b1\uc6b4\uc6b8\uc6c0\uc6c3\uc6c5\uc6cc\uc6d0\uc6d4\uc6e0\uc6e8\uc6ec\uc6f0\uc6f8\uc704\uc708\uc70c\uc717\uc720\uc721\uc724\uc728\uc73c\uc73d\uc740\uc744\uc74c\uc751\uc758\uc774\uc775\uc778\uc77c\uc77d\uc783\uc784\uc785\uc787\uc788\uc789\uc78a\uc78e\uc790\uc791\uc794\uc796\uc798\uc7a0\uc7a1\uc7a3\uc7a5\uc7a6\uc7ac\uc7bf\uc7c1\uc7e4\uc800\uc801\uc804\uc808\uc80a\uc810\uc811\uc813\uc815\uc816\uc81c\uc820\uc824\uc82f\uc838\uc84c\uc870\uc871\uc874\uc878\uc880\uc881\uc885\uc88b\uc88c\uc8c4\uc8fc\uc8fd\uc900\uc904\uc90c\uc90d\uc911\uc918\uc950\uc988\uc989\uc98c\uc990\uc998\uc99d\uc9c0\uc9c1\uc9c4\uc9c8\uc9d0\uc9d1\uc9d3\uc9d5\uc9d9\uc9da\uc9dc\uc9dd\uc9e7\uc9f8\uca0c\uca4c\uca4d\uca50\uca54\uca5c\ucabd\ucad3\ucb48\ucb49\ucbe4\ucc0c\ucc0d\ucc22\ucc28\ucc29\ucc2c\ucc2e\ucc30\ucc38\ucc3b\ucc3c\ucc3d\ucc3e\ucc44\ucc45\ucc48\ucc4c\ucc54\ucc59\ucc98\ucc99\ucc9c\ucca0\ucca8\ucca9\uccab\uccad\uccb4\uccd0\ucce4\ucd08\ucd09\ucd0c\ucd1b\ucd1d\ucd2c\ucd5c\ucd94\ucd95\ucd98\ucd9c\ucda4\ucda5\ucda7\ucda9\ucdb0\ucde8\uce20\uce21\uce30\uce35\uce58\uce59\uce5c\uce60\uce68\uce6b\uce6d\uce74\uce78\uce7c\uce84\uce90\ucea0\ucea1\ucee4\ucee8\uceec\ucef4\ucef5\ucef7\ucf00\ucf04\ucf13\ucf1c\ucf30\ucf54\ucf58\ucf5c\ucf64\ucf69\ucf8c\ucfc4\ucfe0\ucff0\ucffc\ud004\ud018\ud034\ud035\ud050\ud06c\ud070\ud074\ud07c\ud07d\ud0a4\ud0ac\ud0b5\ud0b7\ud0c0\ud0c1\ud0c4\ud0c8\ud0d0\ud0d1\ud0d3\ud0d5\ud0dc\ud0dd\ud0e0\ud0e4\ud0ec\ud0ed\ud0f1\ud130\ud131\ud134\ud138\ud140\ud145\ud14c\ud14d\ud150\ud154\ud15c\ud1a0\ud1a4\ud1a8\ud1b0\ud1b1\ud1b5\ud1f4\ud22c\ud234\ud23c\ud241\ud280\ud295\ud29c\ud2b8\ud2b9\ud2bc\ud2bf\ud2c0\ud2c8\ud2f0\ud2f1\ud2f8\ud300\ud305\ud30c\ud30e\ud310\ud314\ud31d\ud328\ud329\ud32c\ud37c\ud37d\ud380\ud384\ud391\ud398\ud39c\ud3a0\ud3b4\ud3b8\ud3bc\ud3c9\ud3d0\ud3ec\ud3ed\ud3f0\ud3f4\ud3fc\ud45c\ud478\ud479\ud480\ud488\ud48d\ud4e8\ud504\ud50c\ud514\ud53c\ud53d\ud540\ud544\ud54f\ud551\ud558\ud559\ud55c\ud560\ud568\ud569\ud56d\ud574\ud575\ud578\ud584\ud587\ud588\ud589\ud5a5\ud5c8\ud5cc\ud5d8\ud5e4\ud5ec\ud600\ud601\ud604\ud608\ud611\ud614\ud615\ud61c\ud638\ud639\ud63c\ud640\ud648\ud649\ud64d\ud654\ud655\ud658\ud65c\ud669\ud68c\ud68d\ud69f\ud6a1\ud6a8\ud6c4\ud6c8\ud6cc\ud6d4\ud6e8\ud718\ud734\ud749\ud750\ud751\ud754\ud758\ud759\ud761\ud765\ud769\ud76c\ud770\ud788\ud78c\ud798\ud799");
            this.nameField.help = Lang._t("Name", new Object[0]);
            this.hostField = new TextField();
            this.hostField.help = Lang._t("Host_IP", new Object[0]);
            this.hostField.focus = false;
            try {
                this.nameField.setText(AGame.makeFileSafe(AirshipGame.PREFS.get("mpName", System.getProperty("user.name", ""))));
                this.hostField.setText(AirshipGame.PREFS.get("mpHost", ""));
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_load_prefs", new Object[0]), e, null, false);
            }
        }
        this.nameField.input(in, drawState, cursor, click, ms);
        this.hostField.input(in, drawState, cursor, click, ms);
        if (in.keyDown("TAB") && !this.doHost && drawState.canClick()) {
            if (this.nameField.focus) {
                this.hostField.focus = true;
                this.nameField.focus = false;
            } else {
                this.hostField.focus = false;
                this.nameField.focus = true;
            }
            drawState.hasClicked();
        }
        if (in.keyDown("ENTER") && drawState.canClick() && !this.nameField.getText().isEmpty() && (this.doHost || !this.hostField.getText().isEmpty())) {
            drawState.hasClicked();
            this.hostOrJoin();
        } else if (in.keyDown("ESCAPE") && drawState.canClick()) {
            this.g.s = new MainMenu(this.g, AGame.isDemo() ? MainMenu.Submenu.MAIN : MainMenu.Submenu.MULTIPLAYER);
            drawState.hasClicked();
        }
    }

    private void doHost() {
        JSONArray mods = new JSONArray();
        if (this.loadGameData == null) {
            for (Mod m : gameEnabledMods) {
                if (m.isCurrentlyEnabled()) continue;
                this.unableToLoadCorrectMods = true;
                return;
            }
            for (Mod m : gameEnabledMods) {
                mods.put(new JSONObject().put("id", m.id).put("checksum", m.getCachedChecksum()));
            }
        } else {
            for (Mod m : this.loadGameMods) {
                mods.put(new JSONObject().put("id", m.id).put("checksum", m.getCachedChecksum()));
            }
        }
        this.g.lanServer = new Server(new JSONObject().put("mods", mods).put("mode", "conquest").put("initiatorID", -1).put("lang", Lang.currentLocale).put("isResumeFromLoaded", this.loadGameData != null), 0);
        if (!this.g.lanServer.start()) {
            this.g.showError(Lang._t("unable_to_start_mp_server", new Object[0]));
            this.g.lanServer.close();
            this.g.lanServer = null;
            return;
        }
        this.g.lanName = this.nameField.getText();
        this.g.lanArmsJSON = this.g.getBestCOA().toJSON();
        this.g.lanClient = new Client("127.0.0.1", this.g);
        this.g.lanClient.tick();
        this.g.s = new StrategicLobbyScreen(this.g, this.g.lanClient, this.g.lanServer, this.loadGameData);
    }

    private void hostOrJoin() {
        try {
            AirshipGame.PREFS.put("mpName", this.nameField.getText());
        }
        catch (Exception e) {
            this.g.reportError(Lang._t("Unable_to_store_prefs", new Object[0]), e, null, false);
        }
        if (this.doHost) {
            if (this.loadGameData == null) {
                Mod.overriddenEnabledModIds = new ArrayList();
                for (Mod m : gameEnabledMods) {
                    Mod.overriddenEnabledModIds.add(m.id);
                }
                this.mrpd = new ModReloadProgressDialog(new Runnable(){

                    @Override
                    public void run() {
                        HostOrJoinStrategicScreen.this.doHost();
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        HostOrJoinStrategicScreen.this.resetMods();
                    }
                });
            } else {
                this.doHost();
            }
        } else {
            try {
                AirshipGame.PREFS.put("mpHost", this.hostField.getText());
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_store_prefs", new Object[0]), e, null, false);
            }
            this.g.lanName = this.nameField.getText();
            this.g.lanArmsJSON = this.g.getBestCOA().toJSON();
            this.g.lanClient = new Client(this.hostField.getText(), this.g);
            this.g.lanClient.tick();
            this.g.s = new StrategicLobbyScreen(this.g, this.g.lanClient, null, null);
        }
        try {
            AirshipGame.PREFS.flush();
        }
        catch (Exception e) {
            this.g.reportError(Lang._t("Unable_to_store_prefs", new Object[0]), e, null, false);
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        int w;
        d.drawBG(MyDraw.SCREEN_BG, sm);
        if (this.nameField == null) {
            return;
        }
        if (this.mrpd != null) {
            d.getHooks().list.clear();
            this.mrpd.render(d, sm, hs, cursor);
            return;
        }
        int n = w = this.doHost && this.loadGameData == null ? sm.width * 3 / 4 : sm.width / 2;
        int h = this.doHost ? (this.loadGameData == null ? sm.height / 2 : MyDraw.WINDOW_INSET * 2 + MyDraw.textFieldH() + MyDraw.BUTTON_H + MyDraw.UI_SPACING) : MyDraw.WINDOW_INSET * 2 + MyDraw.textFieldH() * 2 + MyDraw.BUTTON_H + MyDraw.UI_SPACING * 2;
        int x = sm.width / 2 - w / 2;
        int y = StrictMath.max(sm.height / 2 - h / 2, MyDraw.SIDE_CLEARANCE + AGame.HUGE_FOUNT.height + MyDraw.UI_SPACING);
        d.drawWindow(x, y, w, h);
        String title = this.doHost ? (this.loadGameData == null ? Lang._t("Host_Strategic_LAN_Game", new Object[0]) : Lang._t("Continue_LAN_Game", new Object[0])) : Lang._t("Join_Strategic_LAN_Game", new Object[0]);
        int titleW = (int)d.textSize((String)title, (Fount)AGame.HUGE_FOUNT).x;
        d.text(MyDraw.TITLE_C + title, AGame.HUGE_FOUNT, sm.width / 2 - titleW / 2, y - AGame.HUGE_FOUNT.height - MyDraw.UI_SPACING);
        h -= MyDraw.WINDOW_INSET * 2;
        this.nameField.render(x += MyDraw.WINDOW_INSET, y += MyDraw.WINDOW_INSET, w -= MyDraw.WINDOW_INSET * 2, d, sm, hs, cursor);
        d.hook(x, y, w, MyDraw.textFieldH(), new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

            public void run(Input in, Pt p, Hook.Type type) {
                ((HostOrJoinStrategicScreen)HostOrJoinStrategicScreen.this).nameField.focus = true;
                ((HostOrJoinStrategicScreen)HostOrJoinStrategicScreen.this).hostField.focus = false;
            }
        });
        y += MyDraw.textFieldH() + MyDraw.UI_SPACING;
        if (!this.doHost) {
            this.hostField.render(x, y, w, d, sm, hs, cursor);
            d.hook(x, y, w, MyDraw.textFieldH(), new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    ((HostOrJoinStrategicScreen)HostOrJoinStrategicScreen.this).nameField.focus = false;
                    ((HostOrJoinStrategicScreen)HostOrJoinStrategicScreen.this).hostField.focus = true;
                }
            });
            y += MyDraw.textFieldH() + MyDraw.UI_SPACING;
        }
        if (this.doHost && this.loadGameData == null) {
            int remainingH = h - MyDraw.textFieldH() - MyDraw.UI_SPACING - MyDraw.BUTTON_H - MyDraw.UI_SPACING;
            d.text(this.yourIP, AGame.FOUNT, x, y);
            this.modsSB.draw(d, x, y += AGame.FOUNT.lineHeight + MyDraw.UI_SPACING, w, remainingH -= AGame.FOUNT.lineHeight + MyDraw.UI_SPACING, this.availableMods, this.modsAdapter);
            this.modsSBRect = new Rect2D(x, y, w, remainingH);
            y += remainingH + MyDraw.UI_SPACING;
        }
        int bw = d.bw(Lang._t("Cancel", new Object[0]));
        d.button(x, y, bw, Lang._t("Cancel", new Object[0]), new Runnable(){

            @Override
            public void run() {
                ((HostOrJoinStrategicScreen)HostOrJoinStrategicScreen.this).g.s = new MainMenu(HostOrJoinStrategicScreen.this.g, AGame.isDemo() ? MainMenu.Submenu.MAIN : MainMenu.Submenu.MULTIPLAYER);
            }
        });
        d.button(x + bw + MyDraw.UI_SPACING, y, d.bw(this.doHost ? Lang._t("Host", new Object[0]) : Lang._t("Join", new Object[0])), this.doHost ? Lang._t("Host", new Object[0]) : Lang._t("Join", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                HostOrJoinStrategicScreen.this.hostOrJoin();
            }
        }, !this.nameField.getText().isEmpty() && (this.doHost || !this.hostField.getText().isEmpty()));
        if (this.unableToLoadCorrectMods) {
            d.getHooks().list.clear();
            int dialogW = StrictMath.max(400, sm.width / 2);
            d.messageDialog(sm.width / 2 - dialogW / 2, sm.height / 2 - 200, dialogW, Lang._t("unable_to_load_mp_mods", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    HostOrJoinStrategicScreen.this.unableToLoadCorrectMods = false;
                    HostOrJoinStrategicScreen.this.resetMods();
                }
            });
        }
    }

    @Override
    public ArrayList<String> music() {
        return AGame.MENU_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return "DAY";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }
}

