/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.ExternalApp;
import com.zarkonnen.airships.Leg;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.SpriteUtils;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.Wheel;
import com.zarkonnen.catengine.Img;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public strictfp class FragmentGen {
    static ArrayList<EmitEntry> emitEntries = new ArrayList();

    public static FragmentInfo generate(SpritesheetBundle ssb) {
        Random r = new Random(223098L);
        BufferedImage fragMap = SpriteUtils.loadBufferedImage(ssb.fragments);
        BufferedImage spritesheet = SpriteUtils.loadBufferedImage(ssb.name);
        BufferedImage bump = SpriteUtils.loadBufferedImage(ssb.bump);
        if (spritesheet == null) {
            if (ssb.sourceMod != null) {
                File ssFile = new File(new File(ssb.sourceMod.dir, "images"), ssb.name + ".png");
                throw new RuntimeException("Spritesheet image \"" + ssb.name + "\" not found. Expected location is " + ssFile.getAbsolutePath() + ".");
            }
            throw new RuntimeException("Spritesheet image \"" + ssb.name + "\" not found.");
        }
        if (bump == null) {
            if (ssb.sourceMod != null) {
                File bFile = new File(new File(ssb.sourceMod.dir, "images"), ssb.bump + ".png");
                throw new RuntimeException("Bump image \"" + ssb.bump + "\" not found. Expected location is " + bFile.getAbsolutePath() + ".");
            }
            throw new RuntimeException("Bump image \"" + ssb.bump + "\" not found.");
        }
        if (fragMap == null) {
            if (ssb.sourceMod != null) {
                File fFile = new File(new File(ssb.sourceMod.dir, "images"), ssb.fragments + ".png");
                throw new RuntimeException("Fragments image \"" + ssb.fragments + "\" not found. Expected location is " + fFile.getAbsolutePath() + ".");
            }
            throw new RuntimeException("Fragments image \"" + ssb.fragments + "\" not found.");
        }
        BufferedImage fragSheet = new BufferedImage(1024, 1024, 2);
        BufferedImage fragBump = new BufferedImage(1024, 1024, 2);
        StringWriter outSW = new StringWriter();
        PrintWriter out = new PrintWriter(outSW);
        for (ModuleType mt : Loadable.all(ModuleType.class)) {
            if (mt.getApp((BonusSet)BonusSet.empty()).spritesheetBundle == ssb) {
                FragmentGen.process(mt.getApp(BonusSet.empty()), fragMap, spritesheet, bump, fragSheet, fragBump, mt.name, out, 100, 20, BonusSet.empty(), r);
            }
            for (BonusSet bs : mt.getAppBonuses()) {
                if (mt.getApp((BonusSet)bs).spritesheetBundle != ssb) continue;
                FragmentGen.process(mt.getApp(bs), fragMap, spritesheet, bump, fragSheet, fragBump, mt.name, out, 100, 20, bs, r);
            }
            for (ExternalApp ea : mt.getExternalApps(BonusSet.empty(), false, false)) {
                if (ea.app.spritesheetBundle != ssb) continue;
                FragmentGen.process(ea.app, fragMap, spritesheet, bump, fragSheet, fragBump, mt.name + " ex " + mt.getExternalApps(BonusSet.empty(), false, false).indexOf(ea), out, 100, 20, BonusSet.empty(), r);
            }
            for (BonusSet bs : mt.getExternalAppBonuses(false, false)) {
                for (ExternalApp ea : mt.getExternalApps(bs, false, false)) {
                    if (ea.app.spritesheetBundle != ssb) continue;
                    FragmentGen.process(ea.app, fragMap, spritesheet, bump, fragSheet, fragBump, mt.name + " ex " + mt.getExternalApps(bs, false, false).indexOf(ea), out, 100, 20, bs, r);
                }
            }
        }
        for (ArmourType at : Loadable.all(ArmourType.class)) {
            if (!at.damagedApps.get(BonusSet.empty()).isEmpty() && at.damagedApps.get((BonusSet)BonusSet.empty()).get((int)0).spritesheetBundle == ssb) {
                for (int before = 0; before < at.damagedApps.get(BonusSet.empty()).size() - 1; ++before) {
                    for (int after = before + 1; after < at.damagedApps.get(BonusSet.empty()).size(); ++after) {
                        FragmentGen.processArmourDelta((List<Appearance>)at.damagedApps.get(BonusSet.empty()), before, after, spritesheet, bump, fragSheet, fragBump, "arm " + at.name + " " + before + " " + after, BonusSet.empty(), out, 8, 35, r);
                    }
                }
            }
            for (BonusSet bs : at.getAppBonuses()) {
                if (at.damagedApps.get(bs).isEmpty() || at.damagedApps.get((BonusSet)bs).get((int)0).spritesheetBundle != ssb) continue;
                for (int before = 0; before < at.damagedApps.get(bs).size() - 1; ++before) {
                    for (int after = before + 1; after < at.damagedApps.get(bs).size(); ++after) {
                        FragmentGen.processArmourDelta((List<Appearance>)at.damagedApps.get(bs), before, after, spritesheet, bump, fragSheet, fragBump, "arm " + at.name + " " + before + " " + after, bs, out, 8, 35, r);
                    }
                }
            }
        }
        for (ModuleType mt : Loadable.all(ModuleType.class)) {
            if (!mt.getLegSpecs().isEmpty()) {
                Leg.Spec ls = mt.getLegSpecs().get(0);
                if (SpritesheetBundle.ofName(ls.foot.src) == ssb) {
                    FragmentGen.process(ls.foot, fragMap, spritesheet, bump, fragSheet, fragBump, "foot " + mt.name, out, 8, 5000, BonusSet.empty(), r);
                }
                if (SpritesheetBundle.ofName(ls.upperLeg.src) == ssb) {
                    FragmentGen.process(ls.upperLeg, fragMap, spritesheet, bump, fragSheet, fragBump, "upperLeg " + mt.name, out, 8, 5000, BonusSet.empty(), r);
                }
                if (SpritesheetBundle.ofName(ls.lowerLeg.src) == ssb) {
                    FragmentGen.process(ls.lowerLeg, fragMap, spritesheet, bump, fragSheet, fragBump, "lowerLeg " + mt.name, out, 8, 5000, BonusSet.empty(), r);
                }
            }
            if (mt.getWheelSpecs().isEmpty()) continue;
            Wheel.Spec ws = mt.getWheelSpecs().get(0);
            if (SpritesheetBundle.ofName(ws.wheel.src) == ssb) {
                FragmentGen.process(ws.wheel, fragMap, spritesheet, bump, fragSheet, fragBump, "wheel " + mt.name, out, 8, 5000, BonusSet.empty(), r);
            }
            if (SpritesheetBundle.ofName(ws.lowerLink.src) == ssb) {
                FragmentGen.process(ws.lowerLink, fragMap, spritesheet, bump, fragSheet, fragBump, "lowerLink " + mt.name, out, 8, 5000, BonusSet.empty(), r);
            }
            if (SpritesheetBundle.ofName(ws.upperLink.src) != ssb) continue;
            FragmentGen.process(ws.upperLink, fragMap, spritesheet, bump, fragSheet, fragBump, "upperLink " + mt.name, out, 8, 5000, BonusSet.empty(), r);
        }
        FragmentGen.doEmit(spritesheet, bump, fragSheet, fragBump, out);
        out.flush();
        return new FragmentInfo(outSW.toString(), fragSheet, fragBump);
    }

    private static void processArmourDelta(List<Appearance> apps, int beforeIndex, int afterIndex, BufferedImage spritesheet, BufferedImage bump, BufferedImage fragSheet, BufferedImage fragBump, String key, BonusSet bonuses, PrintWriter out, int minSize, int maxSize, Random r) {
        Img before = apps.get((int)beforeIndex).frames.get(0);
        Img after = apps.get((int)afterIndex).frames.get(0);
        boolean[][] taken = new boolean[before.srcHeight][before.srcWidth];
        for (int ry = 0; ry < before.srcHeight; ++ry) {
            for (int rx = 0; rx < before.srcWidth; ++rx) {
                if (taken[ry][rx] || !FragmentGen.different(rx, ry, before, after, spritesheet)) continue;
                ArrayList<PxPos> frag = FragmentGen.armourFloodFill(rx, ry, before, after, spritesheet, taken);
                ArrayList<ArrayList<PxPos>> frags = new ArrayList<ArrayList<PxPos>>();
                if (frag.size() < minSize) continue;
                if (frag.size() > maxSize) {
                    FragmentGen.shatter(frag, frags, minSize, maxSize, r);
                } else {
                    frags.add(frag);
                }
                for (ArrayList<PxPos> f : frags) {
                    FragmentGen.emit(f, before, spritesheet, bump, fragSheet, fragBump, key, bonuses, out);
                }
            }
        }
    }

    private static void shatter(ArrayList<PxPos> frag, ArrayList<ArrayList<PxPos>> frags, int minSize, int maxSize, Random r) {
        int numPieces = frag.size() * 3 / 2 / maxSize + 2;
        int minX = 10000;
        int minY = 10000;
        int maxX = 0;
        int maxY = 0;
        for (PxPos pp : frag) {
            minX = StrictMath.min(minX, pp.x);
            minY = StrictMath.min(minY, pp.y);
            maxX = StrictMath.max(maxX, pp.x);
            maxY = StrictMath.max(maxY, pp.y);
        }
        int centerX = minX + (maxX - minX) / 2;
        int centerY = minY + (maxY - minY) / 2;
        double centerOffsetH = StrictMath.max(1.5, (double)(maxX - minX) / 5.0);
        double centerOffsetV = StrictMath.max(1.5, (double)(maxY - minY) / 5.0);
        ArrayList<PxPos> fragCentres = new ArrayList<PxPos>();
        double phase = r.nextDouble() * Math.PI * 2.0;
        for (int i = 0; i < numPieces; ++i) {
            double angle = Math.PI * 2 / (double)numPieces * (double)i + phase;
            PxPos pp = new PxPos((int)((double)centerX + StrictMath.cos(angle) * centerOffsetH), (int)((double)centerY + StrictMath.sin(angle) * centerOffsetV));
            if (fragCentres.contains(pp)) continue;
            fragCentres.add(pp);
            frags.add(new ArrayList());
        }
        for (PxPos pp : frag) {
            int closestIndex = -1;
            int closestDistSq = 0;
            for (int i = 0; i < fragCentres.size(); ++i) {
                int distSq = (pp.x - ((PxPos)fragCentres.get((int)i)).x) * (pp.x - ((PxPos)fragCentres.get((int)i)).x) + (pp.y - ((PxPos)fragCentres.get((int)i)).y) * (pp.y - ((PxPos)fragCentres.get((int)i)).y);
                if (closestIndex != -1 && distSq >= closestDistSq) continue;
                closestIndex = i;
                closestDistSq = distSq;
            }
            frags.get(closestIndex).add(pp);
        }
        Iterator<ArrayList<PxPos>> it = frags.iterator();
        while (it.hasNext()) {
            if (it.next().size() >= minSize) continue;
            it.remove();
        }
    }

    private static void process(Appearance app, BufferedImage fragMap, BufferedImage spritesheet, BufferedImage bump, BufferedImage fragSheet, BufferedImage fragBump, String key, PrintWriter out, int optSize, int minSize, BonusSet bonuses, Random r) {
        for (Img img : app.frames) {
            FragmentGen.process(img, fragMap, spritesheet, bump, fragSheet, fragBump, key + " " + app.frames.indexOf(img), out, optSize, minSize, bonuses, r);
        }
    }

    private static String bonusList(BonusSet bonuses) {
        if (bonuses.list().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Bonus b : bonuses.list()) {
            sb.append(first ? " " : ",");
            sb.append(b.name);
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void process(Img img, BufferedImage fragMap, BufferedImage spritesheet, BufferedImage bump, BufferedImage fragSheet, BufferedImage fragBump, String key, PrintWriter out, int optSize, int minSize, BonusSet bonuses, Random r) {
        void var17_22;
        ArrayList<ArrayList> emittedRegions = new ArrayList<ArrayList>();
        ArrayList<ArrayList<PxPos>> smallRegions = new ArrayList<ArrayList<PxPos>>();
        int white = Color.WHITE.getRGB();
        boolean[][] taken = new boolean[img.srcHeight][img.srcWidth];
        for (int beginY = img.srcY; beginY < img.srcY + img.srcHeight; ++beginY) {
            for (int i = img.srcX; i < img.srcX + img.srcWidth; ++i) {
                int regionClr;
                if (taken[beginY - img.srcY][i - img.srcX] || (regionClr = fragMap.getRGB(i, beginY)) == white) continue;
                ArrayList<PxPos> currentRegion = FragmentGen.floodFill(regionClr, i, beginY, img, fragMap, taken);
                if (currentRegion.size() >= optSize) {
                    FragmentGen.emit(currentRegion, img, spritesheet, bump, fragSheet, fragBump, key, bonuses, out);
                    emittedRegions.add(currentRegion);
                    continue;
                }
                boolean bl = false;
                Iterator it = smallRegions.iterator();
                while (it.hasNext()) {
                    ArrayList reg = (ArrayList)it.next();
                    if (!FragmentGen.touching(reg, currentRegion)) continue;
                    reg.addAll(currentRegion);
                    if (reg.size() >= optSize) {
                        FragmentGen.emit(reg, img, spritesheet, bump, fragSheet, fragBump, key, bonuses, out);
                        emittedRegions.add(reg);
                        it.remove();
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                smallRegions.add(currentRegion);
            }
        }
        for (ArrayList arrayList : smallRegions) {
            if (arrayList.size() < minSize) continue;
            FragmentGen.emit(arrayList, img, spritesheet, bump, fragSheet, fragBump, key, bonuses, out);
        }
        ArrayList<PxPos> wr = new ArrayList<PxPos>();
        int n = img.srcX;
        while (var17_22 < img.srcX + img.srcWidth) {
            int h = 3 + r.nextInt(4);
            for (int i = 0; i < h; ++i) {
                if (img.srcY + img.srcHeight - i - 1 < 0) continue;
                wr.add(new PxPos((int)var17_22, img.srcY + img.srcHeight - i - 1));
            }
            ++var17_22;
        }
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        for (ArrayList reg : emittedRegions) {
            if (!FragmentGen.touching(wr, reg)) continue;
            arrayList.add(reg);
        }
        ArrayList<ArrayList<PxPos>> wrecks = new ArrayList<ArrayList<PxPos>>();
        if (arrayList.size() > 3) {
            void var20_32;
            Collections.shuffle(arrayList, r);
            ArrayList<PxPos> wr2 = new ArrayList<PxPos>(wr);
            boolean bl = false;
            while (var20_32 < arrayList.size()) {
                (var20_32 < arrayList.size() / 2 ? wr : wr2).addAll((Collection)arrayList.get((int)var20_32));
                ++var20_32;
            }
            wrecks.addAll(FragmentGen.trimDisconnectedsFrom(img.srcX, img.srcY + img.srcHeight - 1, wr, spritesheet));
            wrecks.addAll(FragmentGen.trimDisconnectedsFrom(img.srcX, img.srcY + img.srcHeight - 1, wr2, spritesheet));
        } else {
            for (ArrayList arrayList2 : arrayList) {
                wr.addAll(arrayList2);
            }
            wrecks.addAll(FragmentGen.trimDisconnectedsFrom(img.srcX, img.srcY + img.srcHeight - 1, wr, spritesheet));
        }
        for (ArrayList arrayList3 : wrecks) {
            FragmentGen.emit(arrayList3, img, spritesheet, bump, fragSheet, fragBump, key + " wreckage", bonuses, out);
        }
    }

    static ArrayList<ArrayList<PxPos>> trimDisconnectedsFrom(int x, int y, ArrayList<PxPos> frag, BufferedImage spritesheet) {
        WritableRaster alpha = spritesheet.getAlphaRaster();
        int minX = 10000;
        int minY = 10000;
        int maxX = 0;
        int maxY = 0;
        for (PxPos pp : frag) {
            minX = StrictMath.min(minX, pp.x);
            minY = StrictMath.min(minY, pp.y);
            maxX = StrictMath.max(maxX, pp.x);
            maxY = StrictMath.max(maxY, pp.y);
        }
        int h = maxY - minY + 1;
        int w = maxX - minX + 1;
        boolean[][] map = new boolean[h][w];
        for (PxPos pp : frag) {
            try {
                map[pp.y - minY][pp.x - minX] = alpha.getSample(pp.x, pp.y, 0) > 0;
            }
            catch (Exception e) {
                System.out.println(pp.x + " " + pp.y);
                System.exit(1);
            }
        }
        boolean[][] connected = new boolean[h][w];
        connected[y - minY][x - minX] = true;
        LinkedList<PxPos> q = new LinkedList<PxPos>();
        q.add(new PxPos(x, y));
        while (!q.isEmpty()) {
            PxPos pp = (PxPos)q.pop();
            for (int dy = -1; dy < 2; ++dy) {
                for (int dx = -1; dx < 2; ++dx) {
                    if (dx != 0 && dy != 0) continue;
                    int relX = pp.x - minX + dx;
                    int relY = pp.y - minY + dy;
                    if (relX < 0 || relX >= map[0].length || relY < 0 || relY >= map.length || !map[relY][relX] || connected[relY][relX]) continue;
                    connected[relY][relX] = true;
                    q.add(new PxPos(pp.x + dx, pp.y + dy));
                }
            }
        }
        ArrayList<ArrayList<PxPos>> wrecks = new ArrayList<ArrayList<PxPos>>();
        ArrayList<PxPos> l = new ArrayList<PxPos>();
        for (int xx = 0; xx < connected[0].length; ++xx) {
            int yy;
            int count = 0;
            for (yy = 0; yy < connected.length; ++yy) {
                if (!connected[yy][xx]) continue;
                ++count;
            }
            if (count < 2) {
                if (l.isEmpty()) continue;
                if (l.size() > 10) {
                    wrecks.add(l);
                }
                l = new ArrayList();
                continue;
            }
            for (yy = 0; yy < connected.length; ++yy) {
                if (!connected[yy][xx]) continue;
                l.add(new PxPos(xx + minX, yy + minY));
            }
        }
        if (l.size() > 10) {
            wrecks.add(l);
        }
        return wrecks;
    }

    static boolean touching(ArrayList<PxPos> a, ArrayList<PxPos> b) {
        int aXMin = 1024;
        int aXMax = 0;
        int aYMin = 1024;
        int aYMax = 0;
        int bXMin = 1024;
        int bXMax = 0;
        int bYMin = 1024;
        int bYMax = 0;
        for (PxPos pa : a) {
            aXMin = StrictMath.min(aXMin, pa.x);
            aXMax = StrictMath.max(aXMax, pa.x);
            aYMin = StrictMath.min(aYMin, pa.y);
            aYMax = StrictMath.max(aYMax, pa.y);
        }
        for (PxPos pb : b) {
            bXMin = StrictMath.min(bXMin, pb.x);
            bXMax = StrictMath.max(bXMax, pb.x);
            bYMin = StrictMath.min(bYMin, pb.y);
            bYMax = StrictMath.max(bYMax, pb.y);
        }
        if (aXMax < bXMin - 2) {
            return false;
        }
        if (bXMax < aXMin - 2) {
            return false;
        }
        if (aYMax < bYMin - 2) {
            return false;
        }
        if (bYMax < aYMin - 2) {
            return false;
        }
        for (PxPos pa : a) {
            for (PxPos pb : b) {
                if (StrictMath.abs(pa.x - pb.x) + StrictMath.abs(pa.y - pb.y) != 1) continue;
                return true;
            }
        }
        return false;
    }

    static void doEmit(BufferedImage spriteSheet, BufferedImage bump, BufferedImage fragSheet, BufferedImage fragBump, PrintWriter out) {
        int currentPlacementY = 0;
        int currentPlacementHeight = 0;
        int currentPlacementX = 0;
        Collections.sort(emitEntries);
        for (EmitEntry ee : emitEntries) {
            int placementWidth = ee.regionRight - ee.regionLeft + 3;
            int placementHeight = ee.regionBottom - ee.regionTop + 3;
            if (currentPlacementX + placementWidth >= 1024) {
                currentPlacementX = 0;
                currentPlacementY += currentPlacementHeight;
                currentPlacementHeight = 0;
            }
            int placementX = currentPlacementX;
            int placementY = currentPlacementY;
            currentPlacementX += placementWidth;
            currentPlacementHeight = StrictMath.max(currentPlacementHeight, placementHeight);
            if (placementY + placementHeight > 1024) {
                System.out.println("TILT");
            }
            int xShift = placementX + 1 - ee.regionLeft;
            int yShift = placementY + 1 - ee.regionTop;
            Graphics2D fg = fragSheet.createGraphics();
            Graphics2D bg = fragBump.createGraphics();
            for (PxPos pxp : ee.region) {
                int x = pxp.x;
                int y = pxp.y;
                fg.drawImage(spriteSheet, x + xShift, y + yShift, x + xShift + 1, y + yShift + 1, x, y, x + 1, y + 1, null);
                bg.drawImage(bump, x + xShift, y + yShift, x + xShift + 1, y + yShift + 1, x, y, x + 1, y + 1, null);
            }
            int xOffset = ee.regionLeft - ee.img.srcX;
            int yOffset = ee.regionTop - ee.img.srcY;
            out.println(ee.key + FragmentGen.bonusList(ee.bonuses));
            out.println(ee.img.src + "FRAGMENTS");
            out.println(placementX + " " + placementY + " " + placementWidth + " " + placementHeight + " " + xOffset + " " + yOffset);
        }
        emitEntries.clear();
    }

    static void emit(ArrayList<PxPos> region, Img img, BufferedImage spriteSheet, BufferedImage bump, BufferedImage fragSheet, BufferedImage fragBump, String key, BonusSet bonuses, PrintWriter out) {
        EmitEntry ee = new EmitEntry(region, img, key, bonuses);
        ee.regionLeft = 1024;
        ee.regionRight = 0;
        ee.regionTop = 1024;
        ee.regionBottom = 0;
        for (PxPos pxp : region) {
            ee.regionLeft = StrictMath.min(ee.regionLeft, pxp.x);
            ee.regionRight = StrictMath.max(ee.regionRight, pxp.x);
            ee.regionTop = StrictMath.min(ee.regionTop, pxp.y);
            ee.regionBottom = StrictMath.max(ee.regionBottom, pxp.y);
        }
        emitEntries.add(ee);
    }

    static ArrayList<PxPos> floodFill(int regionClr, int beginX, int beginY, Img img, BufferedImage fragMap, boolean[][] taken) {
        LinkedList<PxPos> queue = new LinkedList<PxPos>();
        ArrayList<PxPos> l = new ArrayList<PxPos>();
        queue.add(new PxPos(beginX, beginY));
        taken[beginY - img.srcY][beginX - img.srcX] = true;
        while (!queue.isEmpty()) {
            PxPos pxp = (PxPos)queue.pollFirst();
            l.add(pxp);
            for (int dy = -1; dy < 2; ++dy) {
                for (int dx = -1; dx < 2; ++dx) {
                    int localClr;
                    int ny = pxp.y + dy;
                    int nx = pxp.x + dx;
                    if (ny < img.srcY || ny >= img.srcY + img.srcHeight || nx < img.srcX || nx >= img.srcX + img.srcWidth || taken[ny - img.srcY][nx - img.srcX] || (localClr = fragMap.getRGB(nx, ny)) != regionClr) continue;
                    taken[ny - img.srcY][nx - img.srcX] = true;
                    queue.add(new PxPos(nx, ny));
                }
            }
        }
        return l;
    }

    static boolean different(int x, int y, Img a, Img b, BufferedImage img) {
        return img.getRGB(a.srcX + x, a.srcY + y) != img.getRGB(b.srcX + x, b.srcY + y);
    }

    static ArrayList<PxPos> armourFloodFill(int beginX, int beginY, Img beforeImg, Img afterImg, BufferedImage spritesheet, boolean[][] taken) {
        LinkedList<PxPos> queue = new LinkedList<PxPos>();
        ArrayList<PxPos> l = new ArrayList<PxPos>();
        queue.add(new PxPos(beforeImg.srcX + beginX, beforeImg.srcY + beginY));
        taken[beginY][beginX] = true;
        while (!queue.isEmpty()) {
            PxPos pxp = (PxPos)queue.pollFirst();
            l.add(pxp);
            for (int dy = -1; dy < 2; ++dy) {
                for (int dx = -1; dx < 2; ++dx) {
                    if (dx != 0 && dy != 0) continue;
                    int nx = pxp.x + dx;
                    int ny = pxp.y + dy;
                    int relNx = nx - beforeImg.srcX;
                    int relNy = ny - beforeImg.srcY;
                    if (relNx < 0 || relNy < 0 || relNx >= beforeImg.srcWidth || relNy >= beforeImg.srcHeight || !FragmentGen.different(relNx, relNy, beforeImg, afterImg, spritesheet) || taken[relNy][relNx]) continue;
                    queue.add(new PxPos(nx, ny));
                    taken[relNy][relNx] = true;
                }
            }
        }
        return l;
    }

    strictfp static class EmitEntry
    implements Comparable<EmitEntry> {
        ArrayList<PxPos> region;
        Img img;
        String key;
        BonusSet bonuses;
        int regionLeft = 1024;
        int regionRight = 0;
        int regionTop = 1024;
        int regionBottom = 0;

        public EmitEntry(ArrayList<PxPos> region, Img img, String key, BonusSet bonuses) {
            this.region = region;
            this.img = img;
            this.key = key;
            this.bonuses = bonuses;
        }

        @Override
        public int compareTo(EmitEntry o) {
            int h = this.regionBottom - this.regionTop;
            int h2 = o.regionBottom - o.regionTop;
            return h - h2;
        }
    }

    strictfp static class PxPos {
        final int x;
        final int y;

        public PxPos(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof PxPos)) {
                return false;
            }
            PxPos pp2 = (PxPos)o2;
            return pp2.x == this.x && pp2.y == this.y;
        }

        public int hashCode() {
            return this.x * 1024 + this.y;
        }
    }

    public strictfp static class FragmentInfo {
        public final String mapping;
        public final BufferedImage sheet;
        public final BufferedImage bump;

        public FragmentInfo(String mapping, BufferedImage sheet, BufferedImage bump) {
            this.mapping = mapping;
            this.sheet = sheet;
            this.bump = bump;
        }
    }
}

