/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Leg;
import com.zarkonnen.airships.PhysicsRect;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.WheelBody;

public strictfp class Foot
extends Body {
    public Leg leg;
    public Airship ship;
    public double w;
    public double h;
    public boolean removeMe;
    public boolean isDown;
    public int hasStomped;

    public Foot(Airship ship, Leg leg, double x, double y, double w, double h) {
        this.ship = ship;
        this.leg = leg;
        this.setX(x);
        this.setY(y);
        this.w = w;
        this.h = h;
    }

    @Override
    public int getCollisionMass() {
        return StrictMath.max(this.ship.getCollisionMass() / 8, 10);
    }

    @Override
    public int getMass() {
        return StrictMath.max(this.ship.getMass() / 8, 10);
    }

    @Override
    public boolean isImmobile() {
        return false;
    }

    @Override
    public boolean removeMe() {
        return this.removeMe;
    }

    @Override
    public double elasticity() {
        return this.ship.elasticity();
    }

    @Override
    public double horizontalAirFriction() {
        return 0.0;
    }

    @Override
    public double verticalAirFriction() {
        return 0.0;
    }

    @Override
    public boolean collidesWith(PhysicsRect b2) {
        if (!this.isDown || b2 == this.ship) {
            return false;
        }
        if (b2 instanceof Airship) {
            return ((Airship)b2).collidesWith(this);
        }
        if (b2 instanceof LandFormation) {
            return ((LandFormation)b2).collidesWith(this);
        }
        if (b2 instanceof WheelBody || b2 instanceof Foot) {
            return false;
        }
        return Rect2D.intersects(this.getX(), this.getY(), this.w, this.h, b2.getX(), b2.getY(), b2.getBBWidth(), b2.getBBHeight());
    }

    @Override
    public void doCollision(Body b2, double hitEnergy, Combat combat, boolean atSpeed) {
    }

    @Override
    public double getBBWidth() {
        return this.w;
    }

    @Override
    public double getBBHeight() {
        return this.h;
    }

    @Override
    public boolean canParticleStick(double px, double py) {
        return Rect2D.contains(this.getX(), this.getY() + this.getBBHeight() - StrictMath.max(this.getBBHeight(), (double)this.leg.spec.foot.srcHeight * 0.4), this.w, StrictMath.max(this.getBBHeight(), (double)this.leg.spec.foot.srcHeight * 0.4), px, py);
    }

    @Override
    public boolean isAtSpeed() {
        return this.isDown && this.hasStomped > 0;
    }
}

