/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.FleetOwner;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.SelectionVisualLayer;
import com.zarkonnen.airships.ShipNameDialog;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Rectangle;

public strictfp class FleetElementAdapter
implements ScrollBar.ScrollElementAdapter<Airship> {
    private final StrategicScreen ss;

    public FleetElementAdapter(StrategicScreen ss) {
        this.ss = ss;
    }

    @Override
    public int getHeight(Airship t, MyDraw d, int availableWidth) {
        int shipH = (t.getHeight() >= t.getWidth() ? availableWidth : (availableWidth -= MyDraw.UI_SPACING) * t.getHeight() / t.getWidth()) + MyDraw.UI_SPACING;
        return shipH + MyDraw.BUTTON_SPACING + AGame.FOUNT.lineHeight + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING + MyDraw.UI_SPACING * 2;
    }

    @Override
    public void draw(final Airship ship, MyDraw d, int x, int y, int width) {
        FleetOwner owner = this.ss.w.map.owner(this.ss.selectedFleet);
        if (owner == null) {
            this.ss.selectedFleet = null;
            return;
        }
        int shipH = ship.getHeight() >= ship.getWidth() ? width : (width -= MyDraw.UI_SPACING) * ship.getHeight() / ship.getWidth();
        d.tooltip(x, y, width, shipH, x - MyDraw.UI_SPACING - MyDraw.WINDOW_INSET, StrategicScreen.getShipTooltip(ship));
        boolean showOutside = this.ss.currentCursor == null || !Rect2D.contains(x, y, width, shipH, this.ss.currentCursor.x, this.ss.currentCursor.y);
        double scale = StrictMath.min((double)width * 1.0 / (double)ship.getWidth() / 16.0, (double)width * 1.0 / (double)ship.getHeight() / 16.0) * 0.9;
        Graphics g = (Graphics)d.frame().nativeRenderer();
        int shipY = y;
        d.text((this.ss.w.player == owner && this.ss.fleetSelection.contains(ship) ? MyDraw.SELECTED_C : "") + ship.getName(), AGame.FOUNT, x, (y += shipH + MyDraw.BUTTON_SPACING) + (MyDraw.BUTTON_H - AGame.FOUNT.height) / 2);
        y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        int bx = x;
        if (this.ss.w.player == owner) {
            boolean canRebuild = this.ss.selectedFleet.location != null && this.ss.w.player.cities.contains(this.ss.selectedFleet.location) && ((City)this.ss.selectedFleet.location).canBuild(ship.type);
            boolean canRepair = canRebuild && ship.getOriginalDesign() != null && ship.getOriginalDesign().modules.size() != ship.modules.size();
            d.iconButton(bx, y, this.ss.edit, new Runnable(){

                @Override
                public void run() {
                    ((FleetElementAdapter)FleetElementAdapter.this).ss.shipNameDialog = new ShipNameDialog(((FleetElementAdapter)FleetElementAdapter.this).ss.w, ship, ((FleetElementAdapter)FleetElementAdapter.this).ss.w.player, new ShipNameDialog.ShipNameCallback(){

                        @Override
                        public void run(String newName, int n) {
                            ((FleetElementAdapter)FleetElementAdapter.this).ss.w.giveCommand(((FleetElementAdapter)FleetElementAdapter.this).ss.w.shipMsg("renameShip", ship).put("newName", newName));
                            ((FleetElementAdapter)FleetElementAdapter.this).ss.shipNameDialog = null;
                        }

                        @Override
                        public boolean canHaveMultiple() {
                            return false;
                        }

                        @Override
                        public boolean multipleAllowed(int n) {
                            return n == 1;
                        }
                    }, new Runnable(){

                        @Override
                        public void run() {
                            ((FleetElementAdapter)FleetElementAdapter.this).ss.shipNameDialog = null;
                        }
                    });
                }
            }, true);
            d.tooltip((double)bx, (double)y, (double)MyDraw.BUTTON_H, (double)MyDraw.BUTTON_H, Lang._t("Rename", new Object[0]));
            bx += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            if (canRebuild) {
                d.iconButton(bx, y, this.ss.refit, new Runnable(){

                    @Override
                    public void run() {
                        FleetElementAdapter.this.ss.refitShip((City)((FleetElementAdapter)FleetElementAdapter.this).ss.selectedFleet.location, ship);
                    }
                }, true);
                d.tooltip((double)bx, (double)y, (double)MyDraw.BUTTON_H, (double)MyDraw.BUTTON_H, Lang._t("Refit", new Object[0]));
                bx += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
                if (canRepair) {
                    d.iconButton(bx, y, this.ss.repair, new Runnable(){

                        @Override
                        public void run() {
                            FleetElementAdapter.this.ss.repairShip((City)((FleetElementAdapter)FleetElementAdapter.this).ss.selectedFleet.location, ship);
                        }
                    }, ship.getOriginalDesign().getRefitCostFrom(ship) <= this.ss.w.player.money);
                    d.tooltip((double)bx, (double)y, (double)MyDraw.BUTTON_H, (double)MyDraw.BUTTON_H, Lang._t("Repair_Sx", ship.getOriginalDesign().getRefitCostFrom(ship)));
                    bx += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
                }
                d.iconButton(bx, y, this.ss.scrap, new Runnable(){

                    @Override
                    public void run() {
                        ((FleetElementAdapter)FleetElementAdapter.this).ss.askForScrap = ship;
                    }
                }, true);
                d.tooltip((double)bx, (double)y, (double)MyDraw.BUTTON_H, (double)MyDraw.BUTTON_H, Lang._t("Scrap_Sx", ship.getCost() / 8));
                bx += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            } else {
                d.iconButton(bx, y, this.ss.scuttle, new Runnable(){

                    @Override
                    public void run() {
                        ((FleetElementAdapter)FleetElementAdapter.this).ss.askForScuttle = ship;
                    }
                }, true);
                d.tooltip((double)bx, (double)y, (double)MyDraw.BUTTON_H, (double)MyDraw.BUTTON_H, Lang._t("Discard", new Object[0]));
                bx += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            }
        }
        y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        y = shipY;
        Rectangle clipR = g.getClip();
        g.setClip(x - 1, StrictMath.max((int)clipR.getY(), y) - 1, width + 2, StrictMath.min((int)clipR.getY() + (int)clipR.getHeight() - y - MyDraw.PANEL_INSET, shipH) + 10);
        d.shift(x, y + width / 20);
        d.scale(scale, scale);
        if (this.ss.w.player == owner && this.ss.fleetSelection.contains(ship)) {
            double offX = (double)width / scale / 2.0 - (double)(ship.getWidth() * 16 / 2);
            double offY = 0.0;
            SelectionVisualLayer.drawGridBodyOutline(d, scale, ship, offX, offY, SelectionVisualLayer.SHIP_SELECT, SelectionVisualLayer.SHIP_SELECT2);
        }
        CoatOfArms arms = owner == null ? CoatOfArms.spectatorArms() : owner.getArms();
        ship.draw(d, (double)width / scale / 2.0 - (double)(ship.getWidth() * 16 / 2), 0.0, 0, showOutside, false, true, arms, true, null, 1.0f, Color.white, 1.0f, Clr.WHITE);
        d.resetTransforms();
        d.hook(x, y, width, shipH, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

            public void run(Input in, Pt p, Hook.Type type) {
                if (((FleetElementAdapter)FleetElementAdapter.this).ss.fleetSelection.contains(ship)) {
                    ((FleetElementAdapter)FleetElementAdapter.this).ss.fleetSelection.remove(ship);
                } else {
                    ((FleetElementAdapter)FleetElementAdapter.this).ss.fleetSelection.add(ship);
                }
            }
        });
    }
}

