/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import java.util.HashMap;
import org.lwjgl.opengl.GLContext;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.pbuffer.FBOGraphics;
import org.newdawn.slick.util.Log;

public strictfp class FBOGraphicsFactory {
    private static HashMap graphics = new HashMap();
    private static boolean fbo = true;
    private static boolean init = false;

    public static boolean init() {
        if (init) {
            return fbo;
        }
        init = true;
        if (fbo) {
            fbo = GLContext.getCapabilities().GL_EXT_framebuffer_object;
        }
        Log.info((String)("Offscreen Buffers FBO=" + fbo + " PBUFFER=disabled PBUFFERRT=disabled"));
        return fbo;
    }

    public static void setUseFBO(boolean useFBO) {
        fbo = useFBO;
    }

    public static boolean usingFBO() {
        return fbo;
    }

    public static boolean usingPBuffer() {
        return false;
    }

    public static Graphics getGraphicsForImage(Image image) throws SlickException {
        Graphics g = (Graphics)graphics.get(image.getTexture());
        if (g == null) {
            g = FBOGraphicsFactory.createGraphics(image);
            graphics.put(image.getTexture(), g);
        }
        return g;
    }

    public static void releaseGraphicsForImage(Image image) throws SlickException {
        Graphics g = (Graphics)graphics.remove(image.getTexture());
        if (g != null) {
            g.destroy();
        }
    }

    private static Graphics createGraphics(Image image) throws SlickException {
        FBOGraphicsFactory.init();
        if (fbo) {
            try {
                return new FBOGraphics(image);
            }
            catch (Exception e) {
                fbo = false;
                Log.warn((String)"FBO failed in use.");
            }
        }
        throw new SlickException("Failed to create offscreen buffer.");
    }
}

