/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.EditorOverlayType;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.catengine.util.Clr;

public strictfp class ExplosionDamageOverlay
implements EditorOverlayType {
    private Airship ship;

    @Override
    public String name() {
        return Lang._t("Explosion_damage", new Object[0]);
    }

    @Override
    public String explanation() {
        return Lang._t("Explosion_damage_explanation", new Object[0]);
    }

    @Override
    public void update(Airship ship, boolean forced) {
        this.ship = ship;
    }

    public int explosionDamageAt(Tile t) {
        int dmg = 0;
        Module me = t.module;
        int msz = this.ship.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.ship.modules.get(mi);
            if (m.type.getExplodeDmg(this.ship.currentBonuses) == 0 || m.type.getExplodeRadius(this.ship.currentBonuses) <= 0 || m == me) continue;
            int damageFromM = 0;
            int centerX = m.x * 16 + m.type.getW() * 16 / 2;
            int centerY = m.y * 16 + m.type.getH() * 16 / 2;
            for (int ty = me.y; ty < me.y + me.type.getH(); ++ty) {
                for (int tx = me.x; tx < me.x + me.type.getW(); ++tx) {
                    int dSq = (tx * 16 + 8 - centerX) * (tx * 16 + 8 - centerX) + (ty * 16 + 8 - centerY) * (ty * 16 + 8 - centerY);
                    double d = StrictMath.sqrt(dSq);
                    int actualDamage = (int)((double)m.type.getExplodeDmg(this.ship.currentBonuses) * ((double)m.type.getExplodeRadius(this.ship.currentBonuses) - d) / (double)m.type.getExplodeRadius(this.ship.currentBonuses));
                    if (actualDamage <= 0) continue;
                    damageFromM += actualDamage;
                }
            }
            dmg = StrictMath.max(damageFromM, dmg);
        }
        return dmg;
    }

    @Override
    public Clr overlayColor(Tile t) {
        if (t.module.type.getExplodeDmg(this.ship.currentBonuses) > 0) {
            return new Clr(200, 184, 79, 180);
        }
        int dmg = this.explosionDamageAt(t);
        if (dmg >= t.module.getMaxHP()) {
            return new Clr(255, 0, 0, 180);
        }
        if (dmg * 100 / t.module.getMaxHP() < 1) {
            return new Clr(0, 0, 0, 150);
        }
        int transparency = dmg * 150 / t.module.getMaxHP() + 70;
        return new Clr(transparency, 0, 0, 150);
    }

    @Override
    public String tooltip(Tile t) {
        if (t.module.x != t.x || t.module.y != t.y) {
            return "";
        }
        int percent = this.explosionDamageAt(t) * 100 / t.module.getMaxHP();
        return percent < 1 ? "" : percent + "%";
    }

    @Override
    public void draw(MyDraw d, Tile t, Airship ship, int tx, int ty, double zoom, int pass) {
    }
}

