/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AIQuality;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.Charge;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.ConstructionStrategy;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.FleetOwner;
import com.zarkonnen.airships.HeraldicStyle;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MapLocation;
import com.zarkonnen.airships.MapLocationCmp;
import com.zarkonnen.airships.MonsterNestType;
import com.zarkonnen.airships.ResearchSpeed;
import com.zarkonnen.airships.SecretPoliceLevel;
import com.zarkonnen.airships.Spy;
import com.zarkonnen.airships.SpyActionResult;
import com.zarkonnen.airships.TakeoverMethod;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.Tincture;
import com.zarkonnen.airships.WorldMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class Empire
implements FleetOwner {
    public static final int MS_PER_INCOME = 5000;
    public final int id;
    public int shipIDCounter = 1;
    public int smartAccum = 0;
    public String name;
    public String playerName;
    public CoatOfArms arms;
    public BonusSet bonuses = new BonusSet();
    public int money;
    public SecretPoliceLevel policeLevel = SecretPoliceLevel.LAX;
    public ArrayList<City> cities = new ArrayList();
    private ArrayList<Fleet> fleets = new ArrayList();
    public ArrayList<Spy> spies = new ArrayList();
    public ArrayList<Message> messages = new ArrayList();
    public transient ArrayList<SpyActionResult> spyActionResults = new ArrayList();
    public int moneyMs;
    public int warConsiderDelay;
    public HashMap<MapLocation, Double> locAggressiveness = new HashMap();
    public double aggressiveness;
    public TakeoverMethod takeoverMethod;
    public int spyActionsDone = 0;
    public int numAllianceMembers = 1;
    public transient MonsterNestType.Reward rewardGiven = null;
    public int timeSinceRaided = 120000;
    public int timeSinceSpiedUpon = 120000;
    public boolean playerControlled;
    public ArrayList<MapLocation> aiTargets;
    public ArrayList<City> citiesForAITargets;
    public ArrayList<Tech.Choice> techs = new ArrayList();
    public Tech.Choice research;
    public ResearchSpeed researchSpeed = ResearchSpeed.getDefault();
    public int researchPoints;
    public final ConstructionStrategy constructionStrategy;
    public transient Tech.Choice researchedTech;
    public transient ArrayList<Airship> aiAvailableShips;
    public transient BonusSet aiAvailableShipsBonuses;
    public transient ArrayList<Airship> aiAvailableLandships;
    public transient BonusSet aiAvailableLandshipsBonuses;
    public transient ArrayList<Airship> aiAvailableBuildings;
    public transient BonusSet aiAvailableBuildingsBonuses;
    public transient int aiMostExpensiveConstructionCost;

    public String getNextShipID() {
        return "e" + this.id + "#" + this.shipIDCounter++;
    }

    public int getStrength(WorldMap wm) {
        int str = this.money;
        for (Fleet f : this.fleets) {
            str += WorldMap.cost(f);
        }
        for (City c : this.cities) {
            str += WorldMap.cost(c.defences);
        }
        return str += StrictMath.max(0, this.incomeBalance(wm) * 25);
    }

    public String mergedNames(Empire e2, WorldMap m) {
        if (this.numAllianceMembers > 1 && e2.numAllianceMembers <= 1) {
            return this.name;
        }
        if (e2.numAllianceMembers > 1) {
            return e2.name;
        }
        ArrayList<String> cands = new ArrayList<String>();
        for (Tincture t : new Tincture[]{Tincture.valueOf("ARGENT"), Tincture.valueOf("OR"), Tincture.valueOf("SABLE"), Tincture.valueOf("GULES"), Tincture.valueOf("SANGUINE"), Tincture.valueOf("CENDREE")}) {
            if (this.arms.layout.charges > 0 && e2.arms.layout.charges > 0 && this.arms.getTincture(CoatOfArms.TinctureSlot.CHARGE0) == e2.arms.getTincture(CoatOfArms.TinctureSlot.CHARGE0) && this.arms.getTincture(CoatOfArms.TinctureSlot.CHARGE0) == t) {
                cands.add(Lang.localeT(m.lang, "alliance_" + t.name(), new Object[0]));
            }
            if (this.arms.getTincture(CoatOfArms.TinctureSlot.TINCTURE0) != e2.arms.getTincture(CoatOfArms.TinctureSlot.TINCTURE0) || this.arms.getTincture(CoatOfArms.TinctureSlot.TINCTURE0) != t) continue;
            cands.add(Lang.localeT(m.lang, "alliance_" + t.name(), new Object[0]));
        }
        int mapW = m.water[0].length;
        int mapH = m.water.length;
        boolean allNorth = true;
        for (City c : this.cities) {
            allNorth &= c.y < mapH / 3;
        }
        for (City c : e2.cities) {
            allNorth &= c.y < mapH / 3;
        }
        if (allNorth) {
            cands.add(Lang.localeT(m.lang, "alliance_N", new Object[0]));
        }
        boolean allSouth = true;
        for (City c : this.cities) {
            allSouth &= c.y > mapH * 2 / 3;
        }
        for (City c : e2.cities) {
            allSouth &= c.y > mapH * 2 / 3;
        }
        if (allSouth) {
            cands.add(Lang.localeT(m.lang, "alliance_S", new Object[0]));
        }
        boolean allWest = true;
        for (City c : this.cities) {
            allWest &= c.x < mapW / 3;
        }
        for (City c : e2.cities) {
            allWest &= c.x < mapW / 3;
        }
        if (allWest) {
            cands.add(Lang.localeT(m.lang, "alliance_W", new Object[0]));
        }
        boolean allEast = true;
        for (City c : this.cities) {
            allEast &= c.x > mapW * 2 / 3;
        }
        for (City c : e2.cities) {
            allEast &= c.x > mapW * 2 / 3;
        }
        if (allEast) {
            cands.add(Lang.localeT(m.lang, "alliance_E", new Object[0]));
        }
        boolean allCenter = true;
        for (City city : this.cities) {
            allCenter &= city.x > mapW / 3 && city.x < mapW * 2 / 3 && city.y > mapH / 3 && city.y < mapH * 2 / 3;
        }
        for (City city : e2.cities) {
            allCenter &= city.x > mapW / 3 && city.x < mapW * 2 / 3 && city.y > mapH / 3 && city.y < mapH * 2 / 3;
        }
        if (allCenter) {
            cands.add(Lang.localeT(m.lang, "alliance_C", new Object[0]));
        }
        block11: for (String string : cands) {
            for (Empire e : m.empires) {
                if (!e.name.equals(string)) continue;
                continue block11;
            }
            return string;
        }
        return Lang.localeT(m.lang, "alliance_x", this.name);
    }

    public CoatOfArms mergedArms(Empire e2, WorldMap wm) {
        return Empire.mergedArms(this.arms, this.numAllianceMembers, e2.arms, e2.numAllianceMembers, wm.r);
    }

    public static CoatOfArms mergedArms(CoatOfArms coa1, int members1, CoatOfArms coa2, int members2, Random r) {
        if (members1 > 4) {
            return coa1;
        }
        if (members2 > 4) {
            return coa2;
        }
        if (members1 + members2 > 4) {
            return CoatOfArms.getRandom(r, HeraldicStyle.ofName("alliance"));
        }
        if (coa1.layout.charges == 0) {
            if (coa2.layout.charges == 0) {
                CoatOfArms coa = new CoatOfArms();
                if (coa1.layout == coa2.layout) {
                    coa.setLayout(coa1.layout);
                } else {
                    ArrayList<CoatOfArms.Layout> ls = new ArrayList<CoatOfArms.Layout>();
                    ls.add(CoatOfArms.Layout.BARRY);
                    ls.add(CoatOfArms.Layout.PALY);
                    ls.add(CoatOfArms.Layout.SALTIRE);
                    ls.remove((Object)coa1.layout);
                    ls.remove((Object)coa2.layout);
                    coa.setLayout((CoatOfArms.Layout)((Object)ls.get(0)));
                }
                coa.setTincture(coa1.getTincture(CoatOfArms.TinctureSlot.TINCTURE0), CoatOfArms.TinctureSlot.TINCTURE0);
                coa.setTincture(coa1.getTincture((CoatOfArms.TinctureSlot)CoatOfArms.TinctureSlot.TINCTURE0).metal == coa2.getTincture((CoatOfArms.TinctureSlot)CoatOfArms.TinctureSlot.TINCTURE0).metal ? coa2.getTincture(CoatOfArms.TinctureSlot.TINCTURE1) : coa2.getTincture(CoatOfArms.TinctureSlot.TINCTURE0), CoatOfArms.TinctureSlot.TINCTURE1);
                return coa;
            }
            CoatOfArms coa = new CoatOfArms();
            coa.setLayout(CoatOfArms.Layout.CHARGE);
            coa.setCharge(coa2.charge[0], 0);
            coa.setTincture(coa1.getTincture(CoatOfArms.TinctureSlot.TINCTURE0), CoatOfArms.TinctureSlot.CHARGE0);
            coa.setTincture(coa1.getTincture(CoatOfArms.TinctureSlot.TINCTURE1), CoatOfArms.TinctureSlot.TINCTURE0);
            return coa;
        }
        if (coa2.layout.charges == 0) {
            CoatOfArms coa = new CoatOfArms();
            coa.setLayout(CoatOfArms.Layout.CHARGE);
            coa.setCharge(coa1.charge[0], 0);
            coa.setTincture(coa2.getTincture(CoatOfArms.TinctureSlot.TINCTURE0), CoatOfArms.TinctureSlot.CHARGE0);
            coa.setTincture(coa2.getTincture(CoatOfArms.TinctureSlot.TINCTURE1), CoatOfArms.TinctureSlot.TINCTURE0);
            return coa;
        }
        ArrayList<SimpleArms> parts = new ArrayList<SimpleArms>();
        Empire.extractArmsParts(parts, coa1, members1);
        Empire.extractArmsParts(parts, coa2, members2);
        switch (parts.size()) {
            case 2: {
                switch (r.nextInt(4)) {
                    case 0: {
                        CoatOfArms dimidiated = new CoatOfArms();
                        dimidiated.setLayout(CoatOfArms.Layout.DIMIDIATED);
                        dimidiated.setCharge(parts.get((int)0).charge, 0);
                        dimidiated.setCharge(parts.get((int)1).charge, 1);
                        dimidiated.setTincture(parts.get((int)0).chargeT, CoatOfArms.TinctureSlot.CHARGE0);
                        dimidiated.setTincture(parts.get((int)1).chargeT, CoatOfArms.TinctureSlot.CHARGE1);
                        dimidiated.setTincture(parts.get((int)0).bgT, CoatOfArms.TinctureSlot.TINCTURE0);
                        dimidiated.setTincture(parts.get((int)1).bgT, CoatOfArms.TinctureSlot.TINCTURE1);
                        return dimidiated;
                    }
                    case 1: {
                        CoatOfArms pale = new CoatOfArms();
                        pale.setLayout(CoatOfArms.Layout.PARTY_PER_PALE);
                        pale.setCharge(parts.get((int)0).charge, 0);
                        pale.setCharge(parts.get((int)1).charge, 1);
                        pale.setTincture(parts.get((int)0).chargeT, CoatOfArms.TinctureSlot.CHARGE0);
                        pale.setTincture(parts.get((int)0).chargeT.metal == parts.get((int)1).chargeT.metal ? parts.get((int)1).bgT : parts.get((int)1).chargeT, CoatOfArms.TinctureSlot.CHARGE1);
                        pale.setTincture(parts.get((int)0).bgT, CoatOfArms.TinctureSlot.TINCTURE0);
                        pale.setTincture(parts.get((int)0).chargeT.metal == parts.get((int)1).chargeT.metal ? parts.get((int)1).chargeT : parts.get((int)1).bgT, CoatOfArms.TinctureSlot.TINCTURE1);
                        return pale;
                    }
                    case 2: {
                        CoatOfArms bend = new CoatOfArms();
                        bend.setLayout(CoatOfArms.Layout.PARTY_PER_BEND_SINISTER);
                        bend.setCharge(parts.get((int)0).charge, 0);
                        bend.setCharge(parts.get((int)1).charge, 1);
                        bend.setTincture(parts.get((int)0).chargeT, CoatOfArms.TinctureSlot.CHARGE0);
                        bend.setTincture(parts.get((int)0).chargeT.metal == parts.get((int)1).chargeT.metal ? parts.get((int)1).bgT : parts.get((int)1).chargeT, CoatOfArms.TinctureSlot.CHARGE1);
                        bend.setTincture(parts.get((int)0).bgT, CoatOfArms.TinctureSlot.TINCTURE0);
                        bend.setTincture(parts.get((int)0).chargeT.metal == parts.get((int)1).chargeT.metal ? parts.get((int)1).chargeT : parts.get((int)1).bgT, CoatOfArms.TinctureSlot.TINCTURE1);
                        return bend;
                    }
                    case 3: {
                        CoatOfArms quartered2 = new CoatOfArms();
                        quartered2.setLayout(CoatOfArms.Layout.QUARTERLY);
                        quartered2.setCharge(parts.get((int)0).charge, 0);
                        quartered2.setCharge(parts.get((int)1).charge, 1);
                        quartered2.setCharge(parts.get((int)1).charge, 2);
                        quartered2.setCharge(parts.get((int)0).charge, 3);
                        quartered2.setTincture(parts.get((int)0).chargeT, CoatOfArms.TinctureSlot.CHARGE0);
                        quartered2.setTincture(parts.get((int)1).chargeT, CoatOfArms.TinctureSlot.CHARGE1);
                        quartered2.setTincture(parts.get((int)1).chargeT, CoatOfArms.TinctureSlot.CHARGE2);
                        quartered2.setTincture(parts.get((int)0).chargeT, CoatOfArms.TinctureSlot.CHARGE3);
                        quartered2.setTincture(parts.get((int)0).bgT, CoatOfArms.TinctureSlot.TINCTURE0);
                        quartered2.setTincture(parts.get((int)1).bgT, CoatOfArms.TinctureSlot.TINCTURE1);
                        quartered2.setTincture(parts.get((int)1).bgT, CoatOfArms.TinctureSlot.TINCTURE2);
                        quartered2.setTincture(parts.get((int)0).bgT, CoatOfArms.TinctureSlot.TINCTURE3);
                        return quartered2;
                    }
                }
            }
            case 3: {
                CoatOfArms quartered3 = new CoatOfArms();
                quartered3.setLayout(CoatOfArms.Layout.QUARTERLY);
                quartered3.setCharge(parts.get((int)0).charge, 0);
                quartered3.setCharge(parts.get((int)1).charge, 1);
                quartered3.setCharge(parts.get((int)2).charge, 2);
                quartered3.setCharge(parts.get((int)0).charge, 3);
                quartered3.setTincture(parts.get((int)0).chargeT, CoatOfArms.TinctureSlot.CHARGE0);
                quartered3.setTincture(parts.get((int)1).chargeT, CoatOfArms.TinctureSlot.CHARGE1);
                quartered3.setTincture(parts.get((int)2).chargeT, CoatOfArms.TinctureSlot.CHARGE2);
                quartered3.setTincture(parts.get((int)0).chargeT, CoatOfArms.TinctureSlot.CHARGE3);
                quartered3.setTincture(parts.get((int)0).bgT, CoatOfArms.TinctureSlot.TINCTURE0);
                quartered3.setTincture(parts.get((int)1).bgT, CoatOfArms.TinctureSlot.TINCTURE1);
                quartered3.setTincture(parts.get((int)2).bgT, CoatOfArms.TinctureSlot.TINCTURE2);
                quartered3.setTincture(parts.get((int)0).bgT, CoatOfArms.TinctureSlot.TINCTURE3);
                return quartered3;
            }
            case 4: {
                CoatOfArms quartered4 = new CoatOfArms();
                quartered4.setLayout(CoatOfArms.Layout.QUARTERLY);
                quartered4.setCharge(parts.get((int)0).charge, 0);
                quartered4.setCharge(parts.get((int)1).charge, 1);
                quartered4.setCharge(parts.get((int)2).charge, 2);
                quartered4.setCharge(parts.get((int)3).charge, 3);
                quartered4.setTincture(parts.get((int)0).chargeT, CoatOfArms.TinctureSlot.CHARGE0);
                quartered4.setTincture(parts.get((int)1).chargeT, CoatOfArms.TinctureSlot.CHARGE1);
                quartered4.setTincture(parts.get((int)2).chargeT, CoatOfArms.TinctureSlot.CHARGE2);
                quartered4.setTincture(parts.get((int)3).chargeT, CoatOfArms.TinctureSlot.CHARGE3);
                quartered4.setTincture(parts.get((int)0).bgT, CoatOfArms.TinctureSlot.TINCTURE0);
                quartered4.setTincture(parts.get((int)1).bgT, CoatOfArms.TinctureSlot.TINCTURE1);
                quartered4.setTincture(parts.get((int)2).bgT, CoatOfArms.TinctureSlot.TINCTURE2);
                quartered4.setTincture(parts.get((int)3).bgT, CoatOfArms.TinctureSlot.TINCTURE3);
                return quartered4;
            }
        }
        System.out.println("This is confusing, we have " + parts.size() + " parts but already checked alliance members. Oh well, let's make something up.");
        return CoatOfArms.getRandom(r, HeraldicStyle.ofName("alliance"));
    }

    private static void extractArmsParts(ArrayList<SimpleArms> parts, CoatOfArms arms, int members) {
        for (int i = 0; i < members && arms.layout.charges > i; ++i) {
            Charge c = arms.charge[i];
            Tincture ct = arms.chargeT[i];
            Tincture bt = arms.tincture[i % arms.layout.tinctures].metal == ct.metal ? arms.tincture[(i + 1) % arms.layout.tinctures] : arms.tincture[i % arms.layout.tinctures];
            parts.add(new SimpleArms(c, ct, bt));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameOrTranslationKey() {
        return this.name;
    }

    public int numFullCities() {
        int n = 0;
        int csz = this.cities.size();
        for (int i = 0; i < csz; ++i) {
            if (this.cities.get((int)i).isTown) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean nameIsTranslationKey() {
        return false;
    }

    @Override
    public CoatOfArms getArms() {
        return this.arms;
    }

    @Override
    public ArrayList<Fleet> getFleets() {
        return this.fleets;
    }

    public Tincture getMainTincture() {
        int ti;
        Tincture[] ts = this.arms.getRoundelTinctures();
        for (ti = 0; ti < ts.length - 1 && ts[ti].metal; ++ti) {
        }
        return ts[ti];
    }

    public Tincture getSecondaryTincture() {
        int ti;
        Tincture[] ts = this.arms.getRoundelTinctures();
        for (ti = 0; ti < ts.length - 1 && !ts[ti].metal; ++ti) {
        }
        return ts[ti];
    }

    public Spy getSpyFor(City c) {
        int ssz = this.spies.size();
        for (int si = 0; si < ssz; ++si) {
            Spy s = this.spies.get(si);
            if (s.location != c) continue;
            return s;
        }
        return null;
    }

    public Empire(int id, String name, CoatOfArms arms, String playerName, Bonus bonus, int money, double aggressiveness, TakeoverMethod takeoverMethod, ConstructionStrategy constructionStrategy) {
        this.id = id;
        this.name = name;
        this.arms = arms;
        this.playerName = playerName;
        this.playerControlled = playerName != null;
        this.bonuses.add(bonus);
        this.bonuses.add(Bonus.ofName("CONQUEST"));
        this.money = money;
        this.aggressiveness = aggressiveness;
        this.takeoverMethod = takeoverMethod;
        this.warConsiderDelay = 30000;
        this.constructionStrategy = constructionStrategy;
    }

    @Override
    public AIQuality getAIQuality(WorldMap m) {
        return m.difficulty.enemyAI;
    }

    public void scrap(Airship askForScrap, WorldMap wm) {
        for (Fleet f : this.getFleets()) {
            if (f.actives.contains(askForScrap)) {
                f.actives.remove(askForScrap);
                this.money += askForScrap.getCost() / 8;
                if (f.actives.isEmpty() && f.reserve.isEmpty()) {
                    this.getFleets().remove(f);
                    f.broadcastDestroyed(wm);
                }
                return;
            }
            if (!f.reserve.contains(askForScrap)) continue;
            f.reserve.remove(askForScrap);
            this.money += askForScrap.getCost() / 8;
            if (f.actives.isEmpty() && f.reserve.isEmpty()) {
                this.getFleets().remove(f);
                f.broadcastDestroyed(wm);
            }
            return;
        }
        for (City c : this.cities) {
            if (!c.hasDefence(askForScrap)) continue;
            c.removeDefence(askForScrap);
            this.money += askForScrap.getCost() / 8;
            return;
        }
    }

    public void remove(Airship remove, WorldMap wm) {
        for (Fleet f : this.getFleets()) {
            if (f.actives.contains(remove)) {
                f.actives.remove(remove);
                if (f.actives.isEmpty() && f.reserve.isEmpty()) {
                    this.getFleets().remove(f);
                    f.broadcastDestroyed(wm);
                }
                return;
            }
            if (!f.reserve.contains(remove)) continue;
            f.reserve.remove(remove);
            if (f.actives.isEmpty() && f.reserve.isEmpty()) {
                this.getFleets().remove(f);
                f.broadcastDestroyed(wm);
            }
            return;
        }
        for (City c : this.cities) {
            if (!c.hasDefence(remove)) continue;
            c.removeDefence(remove);
            return;
        }
    }

    public void replace(Airship a, Airship b, WorldMap wm) {
        if (b == null) {
            this.remove(a, wm);
            return;
        }
        for (Fleet f : this.getFleets()) {
            if (f.actives.contains(a)) {
                f.actives.set(f.actives.indexOf(a), b);
                return;
            }
            if (!f.reserve.contains(a)) continue;
            f.reserve.set(f.reserve.indexOf(a), b);
            return;
        }
        for (City c : this.cities) {
            if (!c.hasDefence(a)) continue;
            c.replaceDefence(a, b);
            return;
        }
    }

    public Empire(JSONObject o, WorldMap wm, HashMap<Integer, LandBlockType>[] mappingRef) {
        int i;
        this.id = o.getInt("id");
        this.name = o.getString("name");
        this.smartAccum = o.optInt("smartAccum", 0);
        this.playerName = o.optString("playerName", null);
        this.arms = new CoatOfArms(o.getJSONObject("arms"));
        this.money = o.getInt("money");
        this.moneyMs = o.getInt("moneyMs");
        this.warConsiderDelay = o.optInt("warConsiderDelay", 30000);
        this.aggressiveness = o.optDouble("aggressiveness", 1.0);
        this.takeoverMethod = TakeoverMethod.valueOf(o.optString("takeoverMethod", TakeoverMethod.GENTLE.name()));
        this.policeLevel = SecretPoliceLevel.valueOf(o.optString("policeLevel", SecretPoliceLevel.LAX.name()));
        this.numAllianceMembers = o.optInt("numAllianceMembers", 1);
        this.timeSinceRaided = o.optInt("timeSinceRaided", 120000);
        this.timeSinceSpiedUpon = o.optInt("timeSinceSpiedUpon", 120000);
        this.shipIDCounter = o.optInt("shipIDCounter", 1);
        this.playerControlled = o.getBoolean("playerControlled");
        this.researchSpeed = o.has("researchSpeed") ? ResearchSpeed.ofName(o.getString("researchSpeed")) : ResearchSpeed.getDefault();
        this.research = o.has("researchTech") ? Tech.ofName(o.getString("researchTech")).getChoice(o.getString("researchChoice")) : null;
        this.researchPoints = o.optInt("researchPoints", 0);
        this.constructionStrategy = ConstructionStrategy.ofName(o.getString("constructionStrategy"));
        JSONArray a = o.getJSONArray("cities");
        for (i = 0; i < a.length(); ++i) {
            this.cities.add(new City(a.getJSONObject(i), mappingRef));
        }
        a = o.getJSONArray("fleets");
        for (i = 0; i < a.length(); ++i) {
            this.fleets.add(new Fleet(a.getJSONObject(i), wm));
        }
        if (o.has("techs")) {
            a = o.getJSONArray("techs");
            for (i = 0; i < a.length(); ++i) {
                JSONArray el = a.getJSONArray(i);
                this.techs.add(Tech.ofName(el.getString(0)).getChoice(el.getString(1)));
            }
        }
        if (o.has("additionalBoni")) {
            a = o.getJSONArray("additionalBoni");
            for (i = 0; i < a.length(); ++i) {
                this.bonuses.add(Bonus.ofNameOrNone(a.getString(i)));
            }
        }
        this.bonuses.add(Bonus.ofName("CONQUEST"));
    }

    public void finish(JSONObject o, WorldMap m) {
        int i;
        JSONArray a = o.getJSONArray("cities");
        for (i = 0; i < a.length(); ++i) {
            this.cities.get(i).finish(a.getJSONObject(i), m);
        }
        a = o.optJSONArray("spies");
        if (a != null) {
            for (i = 0; i < a.length(); ++i) {
                Spy spy = new Spy(a.getJSONObject(i));
                spy.finish(a.getJSONObject(i), m);
                this.spies.add(spy);
            }
        }
        if ((a = o.optJSONArray("messages")) != null) {
            for (i = 0; i < a.length(); ++i) {
                if (a.getJSONObject(i).getInt("city") == -1) continue;
                this.messages.add(new Message(a.getJSONObject(i), this));
            }
        }
        if ((a = o.optJSONArray("cityAggressiveness")) != null) {
            for (i = 0; i < a.length(); ++i) {
                JSONObject entry = a.getJSONObject(i);
                MapLocation ml = m.getMapLocation(entry.getInt("city"));
                if (ml == null) {
                    AirshipGame.report("null MapLocation while loading, id was " + entry.getInt("city"));
                    continue;
                }
                this.locAggressiveness.put(ml, entry.getDouble("multiplier"));
            }
        }
        if (o.has("aiTargets")) {
            a = o.getJSONArray("aiTargets");
            this.aiTargets = new ArrayList();
            for (i = 0; i < a.length(); ++i) {
                this.aiTargets.add(m.getMapLocation(a.getInt(i)));
            }
            a = o.getJSONArray("citiesForAITargets");
            this.citiesForAITargets = new ArrayList();
            for (i = 0; i < a.length(); ++i) {
                this.citiesForAITargets.add(m.getCity(a.getInt(i)));
            }
        }
    }

    public void finishFleets(JSONObject o, WorldMap m) {
        JSONArray a = o.getJSONArray("fleets");
        for (int i = 0; i < a.length(); ++i) {
            this.getFleets().get(i).finish(a.getJSONObject(i), m, this.bonuses());
        }
    }

    public JSONObject toJSON(WorldMap m) {
        JSONObject o = new JSONObject().put("id", this.id).put("name", this.name).put("smartAccum", this.smartAccum).put("arms", this.arms.toJSON()).put("money", this.money).put("moneyMs", this.moneyMs).put("aggressiveness", this.aggressiveness).put("takeoverMethod", this.takeoverMethod.name()).put("policeLevel", this.policeLevel.name()).put("warConsiderDelay", this.warConsiderDelay).put("constructionStrategy", this.constructionStrategy.name).put("numAllianceMembers", this.numAllianceMembers).put("timeSinceRaided", this.timeSinceRaided).put("timeSinceSpiedUpon", this.timeSinceSpiedUpon).put("shipIDCounter", this.shipIDCounter).put("playerControlled", this.playerControlled).put("researchSpeed", this.researchSpeed.name).put("researchPoints", this.researchPoints);
        if (this.playerName != null) {
            o.put("playerName", this.playerName);
        }
        if (this.research != null) {
            o.put("researchTech", this.research.tech.name);
            o.put("researchChoice", this.research.name);
        }
        JSONArray a = new JSONArray();
        o.put("cities", a);
        for (City c : this.cities) {
            a.put(c.toJSON(m));
        }
        a = new JSONArray();
        o.put("fleets", a);
        for (Fleet f : this.getFleets()) {
            a.put(f.toJSON(m));
        }
        a = new JSONArray();
        o.put("techs", a);
        for (Tech.Choice t : this.techs) {
            JSONArray jSONArray = new JSONArray();
            jSONArray.put(t.tech.name);
            jSONArray.put(t.name);
            a.put(jSONArray);
        }
        a = new JSONArray();
        o.put("spies", a);
        for (Spy s : this.spies) {
            a.put(s.toJSON(m));
        }
        a = new JSONArray();
        o.put("messages", a);
        for (Message msg : this.messages) {
            if (!this.cities.contains(msg.c)) continue;
            a.put(msg.toJSON(this));
        }
        a = new JSONArray();
        o.put("cityAggressiveness", a);
        ArrayList<MapLocation> aggL = new ArrayList<MapLocation>(this.locAggressiveness.keySet());
        Collections.sort(aggL, new MapLocationCmp());
        for (MapLocation mapLocation : aggL) {
            a.put(new JSONObject().put("city", mapLocation.id).put("multiplier", this.locAggressiveness.get(mapLocation)));
        }
        a = new JSONArray();
        o.put("additionalBoni", a);
        for (Bonus bonus : this.bonuses.list()) {
            a.put(bonus.name());
        }
        if (this.aiTargets != null) {
            a = new JSONArray();
            o.put("aiTargets", a);
            for (MapLocation mapLocation : this.aiTargets) {
                a.put(mapLocation.id);
            }
            a = new JSONArray();
            o.put("citiesForAITargets", a);
            for (City city : this.citiesForAITargets) {
                a.put(city.id);
            }
        }
        return o;
    }

    @Override
    public BonusSet bonuses() {
        return this.bonuses.clone();
    }

    public boolean hasBonus(Bonus b) {
        return this.bonuses.contains[b.ordinal()];
    }

    public int incomeBalance(WorldMap wm) {
        return this.totalIncome(wm) - this.totalFleetCosts() - this.totalDefencesCost() - this.totalSpiesCost() - this.totalPoliceCosts() - this.researchCost(this.researchSpeed, wm);
    }

    public int nonConstructionIncomeBalance(WorldMap wm) {
        return this.totalIncome(wm) - this.totalSpiesCost() - this.totalPoliceCosts() - this.researchCost(this.researchSpeed, wm);
    }

    public int researchCost(ResearchSpeed speed, WorldMap wm) {
        if (this.research == null || wm.techSpeed.speedMultiplier == 0.0) {
            return 0;
        }
        int nCities = 0;
        int csz = this.cities.size();
        for (int ci = 0; ci < csz; ++ci) {
            nCities += this.cities.get((int)ci).isTown ? 0 : 1;
        }
        return speed.baseCost + speed.cityCost * nCities;
    }

    public int researchOutput(ResearchSpeed speed, WorldMap wm) {
        int nCities = 0;
        int csz = this.cities.size();
        for (int ci = 0; ci < csz; ++ci) {
            nCities += this.cities.get((int)ci).isTown ? 0 : 1;
        }
        return (int)((double)(speed.baseResearch + speed.cityResearch * nCities) * wm.techSpeed.speedMultiplier);
    }

    public int totalPoliceCosts() {
        return this.totalPoliceCosts(this.policeLevel);
    }

    public int totalPoliceCosts(SecretPoliceLevel spl) {
        double cityScore = 0.0;
        int csz = this.cities.size();
        for (int ci = 0; ci < csz; ++ci) {
            cityScore += this.cities.get((int)ci).isTown ? 0.1 : 0.7;
        }
        return (int)(10.0 * (StrictMath.pow(cityScore, 1.5) - 0.3) * spl.costMult);
    }

    public int totalFleetCosts() {
        int c = 0;
        for (Fleet f : this.getFleets()) {
            c += f.maintenanceCost();
        }
        return c;
    }

    public int totalDefencesCost() {
        int cost = 0;
        for (City c : this.cities) {
            cost += c.defencesMaintenanceCost();
        }
        return cost;
    }

    public int totalSpiesCost() {
        return this.spies.size() * 5;
    }

    public int totalIncome(WorldMap wm) {
        int in = 0;
        for (City c : this.cities) {
            in += c.adjustedIncome(wm);
        }
        if (!this.playerControlled) {
            in = (int)((double)in * wm.difficulty.aiIncomeMultiplier);
        }
        return in;
    }

    public void tick(int ms, WorldMap map) {
        this.timeSinceRaided += ms;
        this.timeSinceSpiedUpon += ms;
        int msz = this.messages.size();
        for (int mi = 0; mi < msz; ++mi) {
            Message m = this.messages.get(mi);
            if (this.cities.contains(m.c)) continue;
            this.messages.remove(mi);
            --mi;
            --msz;
        }
        int csz = this.cities.size();
        for (int ci = 0; ci < csz; ++ci) {
            City c = this.cities.get(ci);
            c.tick(ms, this, map);
        }
        int fsz = this.fleets.size();
        for (int fi = 0; fi < fsz; ++fi) {
            Fleet f = this.fleets.get(fi);
            if (!f.tick(ms, this, map)) continue;
            this.fleets.remove(fi);
            --fi;
            --fsz;
            f.broadcastDestroyed(map);
        }
        int ssz = this.spies.size();
        for (int si = 0; si < ssz; ++si) {
            Spy s = this.spies.get(si);
            if (this.cities.contains(s.location)) {
                this.spies.remove(si);
                --si;
                --ssz;
                continue;
            }
            s.tick(ms, this, map);
        }
        this.moneyMs += ms;
        if (this.moneyMs >= 5000) {
            this.moneyMs -= 5000;
            this.money += this.incomeBalance(map);
            if (this.research != null) {
                this.researchPoints += this.researchOutput(this.researchSpeed, map);
                if (this.researchPoints >= this.research.tech.cost(this.bonuses())) {
                    for (Tech.Choice c : this.research.tech.choices) {
                        this.techs.remove(c);
                        this.bonuses.removeAll(c.bonuses);
                    }
                    this.bonuses.addAll(this.research.bonuses);
                    this.techs.add(this.research);
                    this.researchPoints = 0;
                    this.researchedTech = this.research;
                    this.research = null;
                }
            }
        }
        if (this.money < 0) {
            this.money = 0;
        }
        this.warConsiderDelay -= ms;
    }

    public void addShipAt(Airship ship, City location, WorldMap wm) {
        for (Fleet f : this.getFleets()) {
            if (f.location != location) continue;
            f.reserve.add(ship);
            location.layoutGarrison(f);
            return;
        }
        Fleet f = new Fleet(location, wm);
        f.reserve.add(ship);
        this.getFleets().add(f);
        location.layoutGarrison(f);
    }

    public boolean isAllResearchDone(WorldMap wm) {
        if (wm.techSpeed.speedMultiplier == 0.0) {
            return true;
        }
        ArrayList<Tech> allTechs = Loadable.all(Tech.class);
        int atsz = allTechs.size();
        block0: for (int ati = 0; ati < atsz; ++ati) {
            Tech at = allTechs.get(ati);
            int tsz = this.techs.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tech.Choice c = this.techs.get(ti);
                if (c.tech == at) continue block0;
            }
            return false;
        }
        return true;
    }

    private strictfp static class SimpleArms {
        public final Charge charge;
        public final Tincture chargeT;
        public final Tincture bgT;

        public SimpleArms(Charge charge, Tincture chargeT, Tincture bgT) {
            this.charge = charge;
            this.chargeT = chargeT;
            this.bgT = bgT;
        }
    }

    public strictfp static class Message {
        public MessageType type;
        public City c;
        public String text;

        public Message(MessageType type, City c, String text) {
            this.type = type;
            this.c = c;
            this.text = text;
        }

        public Message(JSONObject o, Empire e) {
            this.type = MessageType.valueOf(o.getString("type"));
            this.c = e.cities.get(o.getInt("city"));
            this.text = o.getString("text");
        }

        public JSONObject toJSON(Empire e) {
            return new JSONObject().put("type", this.type.name()).put("city", e.cities.indexOf(this.c)).put("text", this.text);
        }
    }

    public strictfp static enum MessageType {
        ENEMY_LANDSHIPS_CAUGHT,
        ENEMY_REMAINING_LANDSHIPS_DESTROYED,
        ENEMY_ABANDONED_LANDSHIPS;

    }
}

