/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.ChallengeEditShipIntent;
import com.zarkonnen.airships.ChallengeInfoFloat;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.DecalType;
import com.zarkonnen.airships.DesignFromStrategicIntent;
import com.zarkonnen.airships.EditInfoPanel;
import com.zarkonnen.airships.EditMode;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.ModuleCategory;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PaintArmourTool;
import com.zarkonnen.airships.PaintType;
import com.zarkonnen.airships.PlaceArmourTool;
import com.zarkonnen.airships.PlaceDecalTool;
import com.zarkonnen.airships.PlaceModuleTool;
import com.zarkonnen.airships.RefitFromStrategicIntent;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.SingleShipIntent;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.prefs.BackingStoreException;
import org.newdawn.slick.Image;

public strictfp class EditPalettePanel
implements UniScreen.InfoPanel {
    public static final Clr HOVER = new Clr(255, 255, 255, 30);
    public static final Img REMOVE = new Img("ui", 64, 256, 16, 16, false);
    public int ms;
    public ArmourType lastArmourType = ArmourType.ofName("MED_WOOD");
    public Airship lastShip = null;
    public TextField searchField = new TextField();
    public boolean searching = false;
    public boolean searchSelectionMade = false;
    public PaintType moduleAndDecalPaintSel = null;
    public int listTop;
    public int listBottom;
    public boolean showFlippedModules = false;
    public boolean showVerticallyFlippedModules = false;
    public boolean showFlippedDecals = false;
    public boolean showVerticallyFlippedDecals = false;
    public HashSet<ModuleCategory> prevOpenCategories = new HashSet();
    public HashSet<ModuleCategory> openCategories = new HashSet();
    public CoatOfArms coa;
    private final EnumMap<EditMode, ScrollBar> modeBars = new EnumMap(EditMode.class);

    public EditPalettePanel() {
        for (EditMode em : EditMode.values()) {
            this.modeBars.put(em, new ScrollBar());
        }
        this.searchField.help = Lang._t("Search", new Object[0]);
        String catNames = AirshipGame.PREFS.get("openModuleCategories", null);
        if (catNames == null) {
            this.openCategories.add(ModuleCategory.ofName("BASIC"));
        } else {
            for (String c : catNames.split("\n")) {
                if (!Loadable.hasOfName(ModuleCategory.class, c)) continue;
                this.openCategories.add(ModuleCategory.ofName(c));
            }
        }
        this.prevOpenCategories.addAll(this.openCategories);
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, final UniScreen us) {
        if (EditPalettePanel.REMOVE.machineImgCache != null) {
            ((Image)EditPalettePanel.REMOVE.machineImgCache).setFilter(9728);
        }
        if (us.hideUI) {
            return;
        }
        if (!(us.intent instanceof EditShipIntent)) {
            return;
        }
        String currentPostfix = Appearance.currentPostfix;
        if (!currentPostfix.equals("DAY")) {
            Appearance.switchSpritesheet("DAY");
        }
        final EditShipIntent esi = (EditShipIntent)us.intent;
        final Airship ship = ((SingleShipIntent)((Object)us.intent)).getShip(us);
        this.coa = esi.getArms(us);
        int x = MyDraw.PANEL_INSET;
        int y = us.panel(EditInfoPanel.class).myHeight + MyDraw.TOP_BAR_H + MyDraw.BUTTON_SPACING;
        int w = us.panel(EditInfoPanel.class).myWidth - MyDraw.PANEL_INSET - MyDraw.WINDOW_INSET;
        int buttonW = (w - MyDraw.BUTTON_SPACING) / 2;
        boolean rightColumn = false;
        ChallengeInfoFloat csi = us.findFloat(ChallengeInfoFloat.class);
        if (!(us.intent instanceof ChallengeEditShipIntent) || ((ChallengeEditShipIntent)us.intent).challenge.showEditModeSelectors) {
            for (final EditMode em : EditMode.values()) {
                d.toggle(x + (rightColumn ? buttonW + MyDraw.BUTTON_SPACING : 0), y, buttonW, em.getName(), em.getShortcut(), new InputRunnable(){

                    @Override
                    public void run(Input in) {
                        esi.mode = em;
                    }
                }, esi.mode == em, true);
                csi.editModeRects.get((Object)em).x = x + (rightColumn ? buttonW + MyDraw.BUTTON_SPACING : 0);
                csi.editModeRects.get((Object)em).y = y;
                csi.editModeRects.get((Object)em).w = buttonW;
                csi.editModeRects.get((Object)em).h = MyDraw.BUTTON_H;
                if (rightColumn) {
                    y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
                    rightColumn = false;
                    continue;
                }
                rightColumn = true;
            }
            if (rightColumn) {
                y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            }
        }
        final EditPalettePanel epp = this;
        if (!(us.intent instanceof ChallengeEditShipIntent)) {
            d.toggle(x, y, w, Lang._t("Search", new Object[0]), "ENTER", new InputRunnable(){

                @Override
                public void run(Input in) {
                    if (!EditPalettePanel.this.searchSelectionMade) {
                        esi.mode.selectFirst(us, epp, ship);
                    }
                    ((ScrollBar)((EditPalettePanel)EditPalettePanel.this).modeBars.get((Object)esi.mode)).offset = 0;
                    EditPalettePanel.this.searching = !EditPalettePanel.this.searching;
                    EditPalettePanel.this.searchField.setText("");
                    EditPalettePanel.this.searchSelectionMade = false;
                }
            }, this.searching, true);
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        if (this.searching) {
            this.searchField.render(x, y, w, d, sm, d.hs, cursor);
            y += MyDraw.textFieldH() + MyDraw.BUTTON_SPACING;
        }
        int h = sm.height - y - MyDraw.PANEL_INSET;
        final EditPalettePanel p = this;
        if (esi.mode.canFill) {
            h -= MyDraw.BUTTON_SPACING + MyDraw.BUTTON_H;
            d.button(x, sm.height - MyDraw.BUTTON_H - MyDraw.PANEL_INSET, w, Lang._t("Fill", new Object[0]), Keys.get("edit_fill", "I"), new Runnable(){

                @Override
                public void run() {
                    esi.mode.fill(us, p, EditPalettePanel.this.lastShip);
                    ship.updateWeight();
                }
            }, esi.mode.fillEnabled(us, this, ship));
        }
        if (esi.mode.hasRemove() && (!(us.intent instanceof ChallengeEditShipIntent) || esi.mode == EditMode.MODULES && !((ChallengeEditShipIntent)esi).challenge.editTypes.isEmpty())) {
            esi.mode.drawRemove(d, x, y, w, us, p);
            csi.removeButtonRect.x = x;
            csi.removeButtonRect.y = y;
            csi.removeButtonRect.w = w;
            csi.removeButtonRect.h = MyDraw.BUTTON_H;
            h -= MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        int bottomHeight = esi.mode.bottomHeight(d, w, us, this);
        this.listTop = y;
        this.listBottom = y + (h -= bottomHeight);
        if (us.intent instanceof ChallengeEditShipIntent) {
            ChallengeEditShipIntent cesi = (ChallengeEditShipIntent)us.intent;
            if (cesi.challenge.showEditModeSelectors || esi.mode == EditMode.MODULES && !cesi.challenge.editTypes.isEmpty()) {
                this.modeBars.get(esi.mode).draw(d, x, y, w, h, esi.mode.getList(us, this, ship), esi.mode);
            }
        } else {
            this.modeBars.get(esi.mode).draw(d, x, y, w, h, esi.mode.getList(us, this, ship), esi.mode);
        }
        esi.mode.drawBottom(d, x, y += h, w, us, p);
        if (!currentPostfix.equals(Appearance.currentPostfix)) {
            Appearance.switchSpritesheet(currentPostfix);
        }
    }

    public static ArmourType guessArmourType(Airship ship) {
        ArmourType best = ship.type.mobile ? ArmourType.ofName("MED_WOOD") : ArmourType.ofName("STONE_WALL");
        int bestCount = 0;
        for (ArmourType at : Loadable.all(ArmourType.class)) {
            if (at == ArmourType.ofName("NONE") || at.hidden) continue;
            int count = 0;
            for (Tile t : ship.tiles) {
                if (t.armour.type != at) continue;
                ++count;
            }
            if (count <= bestCount) continue;
            best = at;
            bestCount = count;
        }
        return best;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (!(us.intent instanceof EditShipIntent)) {
            return;
        }
        if (!this.openCategories.equals(this.prevOpenCategories)) {
            this.prevOpenCategories.clear();
            this.prevOpenCategories.addAll(this.openCategories);
            StringBuilder sb = new StringBuilder();
            for (ModuleCategory mc : this.openCategories) {
                sb.append(mc.name).append("\n");
            }
            AirshipGame.PREFS.put("openModuleCategories", sb.toString());
            try {
                AirshipGame.PREFS.flush();
            }
            catch (BackingStoreException i$) {
                // empty catch block
            }
        }
        this.ms += ms;
        EditShipIntent esi = (EditShipIntent)us.intent;
        Airship ship = esi.getShip(us);
        int x = MyDraw.PANEL_INSET;
        int y = us.panel(EditInfoPanel.class).myHeight + MyDraw.TOP_BAR_H + MyDraw.BUTTON_SPACING * 5 + MyDraw.BUTTON_H * 4;
        int w = us.panel(EditInfoPanel.class).myWidth - MyDraw.PANEL_INSET - MyDraw.WINDOW_INSET;
        int h = in.mode().height - y - MyDraw.PANEL_INSET;
        this.modeBars.get(esi.mode).tick(in, x, y, w, h);
        if (this.lastShip != ship) {
            this.lastShip = ship;
            if (this.lastShip != null) {
                this.lastArmourType = EditPalettePanel.guessArmourType(this.lastShip);
            }
        }
        if (!us.textInputOccurring()) {
            if (!(us.intent instanceof ChallengeEditShipIntent) || ((ChallengeEditShipIntent)us.intent).challenge.showEditModeSelectors) {
                for (EditMode em : EditMode.values()) {
                    if (!in.keyPressed(em.getShortcut())) continue;
                    esi.mode = em;
                }
            }
            if (in.keyPressed(Keys.get("edit_fill", "I")) && esi.mode.canFill && esi.mode.fillEnabled(us, this, ship)) {
                esi.mode.fill(us, this, ship);
                ship.updateWeight();
            }
            if (in.keyPressed(Keys.get("edit_remove", "K")) && esi.mode.hasRemove()) {
                esi.mode.doToggleRemove(us, this);
            }
        }
        if (this.searching) {
            this.searchField.input(in, null, in.cursor(), in.clicked(), ms);
            if (!this.searchField.getText().isEmpty()) {
                if (in.keyPressed("DOWN")) {
                    esi.mode.stepSelect(1, us, this, ship);
                    this.searchSelectionMade = true;
                }
                if (in.keyPressed("UP")) {
                    esi.mode.stepSelect(-1, us, this, ship);
                    this.searchSelectionMade = true;
                }
            }
        }
        if (!(us.intent instanceof ChallengeEditShipIntent) && (this.searching || !us.textInputOccurring()) && in.keyPressed("ENTER")) {
            if (!this.searchSelectionMade && !this.searchField.getText().isEmpty()) {
                esi.mode.selectFirst(us, this, ship);
            }
            this.modeBars.get((Object)esi.mode).offset = 0;
            this.searching = !this.searching;
            this.searchField.setText("");
            this.searchSelectionMade = false;
        }
        if (this.searching && in.keyPressed("ESCAPE")) {
            this.modeBars.get((Object)esi.mode).offset = 0;
            this.searching = !this.searching;
            this.searchField.setText("");
            this.searchSelectionMade = false;
        }
    }

    public ArmourType armSel(UniScreen us) {
        return us.tool instanceof PlaceArmourTool ? ((PlaceArmourTool)us.tool).at : null;
    }

    public DecalType decSel(UniScreen us) {
        return us.tool instanceof PlaceDecalTool ? ((PlaceDecalTool)us.tool).dt : null;
    }

    public ModuleType modSel(UniScreen us) {
        return us.tool instanceof PlaceModuleTool ? ((PlaceModuleTool)us.tool).mt : null;
    }

    public PaintType paintSel(UniScreen us) {
        return us.tool instanceof PaintArmourTool ? ((PaintArmourTool)us.tool).pt : null;
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return this.searching;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return this.searching;
    }

    public Empire owner(UniScreen us) {
        Empire owner;
        Empire empire = owner = us.city == null ? null : us.wm.owner(us.city);
        if (us.intent instanceof DesignFromStrategicIntent) {
            owner = ((DesignFromStrategicIntent)us.intent).ss.w.player;
        }
        if (us.intent instanceof RefitFromStrategicIntent) {
            owner = ((RefitFromStrategicIntent)us.intent).ss.w.player;
        }
        return owner;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        if (us.hideUI) {
            return false;
        }
        if (!(us.intent instanceof EditShipIntent)) {
            return false;
        }
        return cursor != null && cursor.x <= (double)us.panel(EditInfoPanel.class).myWidth;
    }
}

