/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AIQuality;
import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatSettingsIntent;
import com.zarkonnen.airships.ConfirmDialog;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MissionSequence;
import com.zarkonnen.airships.MissionsScreen;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.ModReloadProgressDialog;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.RestrictsShipPlacement;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.UniscreenModLoadUI;
import com.zarkonnen.airships.ZoomToFitButton;
import com.zarkonnen.catengine.Input;
import java.util.ArrayList;
import org.json.JSONObject;

public strictfp class EditMissionIntent
implements UniScreen.Intent,
RestrictsShipPlacement,
CombatSettingsIntent {
    public boolean first = true;
    public MissionSequence missionSequence;
    public MissionSequence.Mission mission;
    public ModReloadProgressDialog mrpd;
    public boolean justSaved = true;

    public EditMissionIntent(MissionSequence missionSequence, MissionSequence.Mission mission) {
        this.missionSequence = missionSequence;
        this.mission = mission;
    }

    public void loadMods(final UniScreen us, final JSONObject cachedCombat, final JSONObject[] cachedArms, final Runnable onFail) {
        for (String id : this.missionSequence.modIDs) {
            Mod m = Mod.getById(id);
            if (m != null) continue;
            us.g.showError(Lang._t("Unable_to_switch_to_mod_configuration_cannot_load_mods", new Object[0]));
            return;
        }
        Mod.overriddenEnabledModIds = new ArrayList<String>(this.missionSequence.modIDs);
        UniscreenModLoadUI usmlu = us.findFloat(UniscreenModLoadUI.class);
        us.clearComponents();
        us.floats.add(usmlu);
        us.combat = null;
        this.mrpd = new ModReloadProgressDialog(new Runnable(){

            @Override
            public void run() {
                try {
                    Combat reloadedCombat;
                    us.combat = reloadedCombat = new Combat(us.g, cachedCombat);
                    EditMissionIntent.this.mission.combat = reloadedCombat;
                    us.mySide = reloadedCombat.sides.get(EditMissionIntent.this.mission.playerSideIndex);
                    EditMissionIntent.this.mission.sideArms[0] = new CoatOfArms(cachedArms[0]);
                    EditMissionIntent.this.mission.sideArms[1] = new CoatOfArms(cachedArms[1]);
                    us.reloadComponents();
                }
                catch (Exception e) {
                    us.g.showError(Lang._t("Unable_to_switch_to_mod_configuration_content_relies_on_it", new Object[0]));
                    onFail.run();
                }
            }
        }, new Runnable(){

            @Override
            public void run() {
                us.g.showError(Lang._t("Unable_to_switch_to_mod_configuration_cannot_load_mods", new Object[0]));
                onFail.run();
            }
        });
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (this.first) {
            ZoomToFitButton.zoomOut(in, us);
            this.first = false;
        }
        if (this.mrpd != null) {
            ModReloadProgressDialog currentMrpd = this.mrpd;
            if (this.mrpd.tick(in) && this.mrpd == currentMrpd) {
                this.mrpd = null;
            }
        }
    }

    @Override
    public AIQuality getAIQuality() {
        return this.mission.enemyAIQuality;
    }

    @Override
    public void setAIQuality(AIQuality quality) {
        this.mission.enemyAIQuality = quality;
    }

    @Override
    public Rect2D placementLimits(int sideIndex, UniScreen us) {
        switch (sideIndex) {
            case 0: {
                return SingleCombatSetupIntent.LEFT_RECT;
            }
            case 1: {
                return SingleCombatSetupIntent.RIGHT_RECT;
            }
        }
        return null;
    }

    public void leave(UniScreen us) {
        if (this.justSaved) {
            EditMissionIntent.doLeave(us);
        } else {
            us.confirmDialog = new Dialog();
        }
    }

    private static void doLeave(UniScreen us) {
        us.g.s = new MissionsScreen(us.g);
    }

    public void justSaved() {
        this.justSaved = true;
    }

    public void modified() {
        this.justSaved = false;
    }

    @Override
    public boolean showOutside() {
        return false;
    }

    @Override
    public boolean showDecals() {
        return true;
    }

    @Override
    public boolean drawAsBlueprint() {
        return false;
    }

    @Override
    public boolean allowMultiSelect() {
        return false;
    }

    public strictfp static class Dialog
    implements ConfirmDialog {
        @Override
        public String text() {
            return Lang._t("Leave_without_saving", new Object[0]);
        }

        @Override
        public String okText() {
            return Lang._t("Leave", new Object[0]);
        }

        @Override
        public String cancelText() {
            return Lang._t("Cancel", new Object[0]);
        }

        @Override
        public void ok(UniScreen us) {
            us.confirmDialog = null;
            EditMissionIntent.doLeave(us);
            Analytics.missionAbandonedUnsaved();
        }

        @Override
        public void cancel(UniScreen us) {
            us.confirmDialog = null;
        }
    }
}

