/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Challenge;
import com.zarkonnen.airships.ChallengeEditShipIntent;
import com.zarkonnen.airships.ChallengeInfoFloat;
import com.zarkonnen.airships.EditFromDefencesIntent;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.OverlayChooserPanel;
import com.zarkonnen.airships.RefitFromDefencesIntent;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.SingleShipIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public strictfp class EditErrorsPanel
implements UniScreen.InfoPanel {
    public final Img FIXER = new Img("ui", 480, 416, 16, 16, false);
    public final Img FIXER_BG = new Img("ui", 496, 416, 16, 16, false);

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, UniScreen us) {
        ArrayList<String> errList;
        if (us.hideUI) {
            return;
        }
        if (!(us.intent instanceof EditShipIntent)) {
            return;
        }
        Airship ship = ((SingleShipIntent)((Object)us.intent)).getShip(us);
        if (us.intent instanceof EditFromDefencesIntent) {
            Empire owner = us.wm.owner(us.city);
            Airship original = us.intent instanceof RefitFromDefencesIntent ? ((RefitFromDefencesIntent)us.intent).original : null;
            errList = ShipEditorUtils.shipErrors(ship, true, true, owner.money, owner.bonuses(), original, us);
        } else if (us.intent instanceof ChallengeEditShipIntent) {
            Challenge challenge = ((ChallengeEditShipIntent)us.intent).challenge;
            errList = ShipEditorUtils.shipErrors(ship, challenge.budget != 0, false, challenge.budget, null, null, us);
        } else {
            errList = ShipEditorUtils.shipErrors(ship, false, false, 0, null, null, us);
        }
        ArrayList<String> warnList = ShipEditorUtils.shipWarnings(ship);
        int y = StrictMath.max(us.findFloat(ChallengeInfoFloat.class).maxY + MyDraw.UI_SPACING, us.panel(OverlayChooserPanel.class).bottom);
        int w = 0;
        for (String s : errList) {
            w = StrictMath.max(w, (int)d.textSize((String)s, (Fount)AGame.FOUNT).x);
        }
        for (String s : warnList) {
            w = StrictMath.max(w, (int)d.textSize((String)s, (Fount)AGame.FOUNT).x);
        }
        w = StrictMath.min(400, w);
        int x = sm.width - MyDraw.SIDE_CLEARANCE - w - MyDraw.BUTTON_SPACING - 16;
        for (String s : errList) {
            d.blit(this.FIXER_BG, new Clr(187, 66, 29), x, y);
            d.blit(this.FIXER, x, y);
            d.text(s, AGame.FOUNT, x + 16 + MyDraw.BUTTON_SPACING, y, w);
            y += StrictMath.max(16, (int)d.textSize((String)s, (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)w).height) + MyDraw.BUTTON_SPACING;
        }
        for (String s : warnList) {
            d.blit(this.FIXER, x, y);
            d.text(s, AGame.FOUNT, x + 16 + MyDraw.BUTTON_SPACING, y, w);
            y += StrictMath.max(16, (int)d.textSize((String)s, (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)w).height) + MyDraw.BUTTON_SPACING;
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

