/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.codedisaster.steamworks.SteamPublishedFileID;
import com.codedisaster.steamworks.SteamRemoteStorage;
import com.codedisaster.steamworks.SteamRemoteStorageCallback;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUGC;
import com.codedisaster.steamworks.SteamUGCCallback;
import com.codedisaster.steamworks.SteamUGCDetails;
import com.codedisaster.steamworks.SteamUGCHandle;
import com.codedisaster.steamworks.SteamUGCQuery;
import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.PublishedItemsManager;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.airships.ZipUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;

public strictfp class DownloadSteamSubsProcess
implements SteamRemoteStorageCallback,
SteamUGCCallback {
    private SteamResult failure;
    private boolean inited;
    private boolean startedFetchingPublisheds = false;
    private boolean waitingForPublisheds = true;
    private int publishedsPage = 1;
    private int numFetchedPublisheds = -1;
    private SteamPublishedFileID[] ids;
    private int steamSubIndex;
    private SteamUGCQuery suq = null;
    private SteamUGCDetails details = null;
    private boolean downloadNeeded = false;
    private boolean downloadQuerySent = false;
    private boolean downloadQueryResponded = false;
    private final HashSet<String> existingUGCBases = new HashSet();
    private boolean cleanedUp = false;

    public void onFileShareResult(SteamUGCHandle sugch, String string, SteamResult sr) {
    }

    public void onDownloadUGCResult(SteamUGCHandle sugch, SteamResult sr) {
        this.downloadQueryResponded = true;
        SteamBackend.remoteStorageCallback = null;
    }

    public void onPublishFileResult(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
    }

    public void onUpdatePublishedFileResult(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
    }

    public void onUGCQueryCompleted(SteamUGCQuery query, int numResultsReturned, int totalMatchingResults, boolean isCachedData, SteamResult result) {
        switch (result) {
            case OK: 
            case AdministratorOK: {
                break;
            }
            default: {
                System.err.println("Steam failure: " + result.name());
                this.failure = result;
            }
        }
        if (this.numFetchedPublisheds == -1) {
            this.numFetchedPublisheds = numResultsReturned;
        }
    }

    public void onSubscribeItem(SteamPublishedFileID spfid, SteamResult sr) {
    }

    public void onUnsubscribeItem(SteamPublishedFileID spfid, SteamResult sr) {
    }

    public void onRequestUGCDetails(SteamUGCDetails sugcd, SteamResult sr) {
    }

    public void onCreateItem(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
    }

    public void onSubmitItemUpdate(boolean bln, SteamResult sr) {
    }

    public void onDownloadItemResult(long l, SteamPublishedFileID spfid, SteamResult sr) {
    }

    public void onUserFavoriteItemsListChanged(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
    }

    public void onSetUserItemVote(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
    }

    public void onGetUserItemVote(SteamPublishedFileID spfid, boolean bln, boolean bln1, boolean bln2, SteamResult sr) {
    }

    private String fileName() {
        return this.details.getFileName().split("-")[0] + "-" + this.details.getOwnerID().getAccountID() + "-" + this.details.getTitle();
    }

    private boolean isMod() {
        return this.details.getFileName().startsWith("MOD-");
    }

    private boolean isMission() {
        return this.details.getFileName().startsWith("MISSIONSEQ-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDownloadNeeded() {
        File modDateCacheF = new File(new File(new File(AGame.getGameDirectory(), "steam"), "updateTimes"), this.fileName());
        if (!modDateCacheF.exists()) {
            return true;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(modDateCacheF), "UTF-8"));
            boolean bl = Integer.parseInt(br.readLine()) != this.details.getTimeUpdated();
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    private void doCleanup() {
        File ugcF = new File(new File(AGame.getGameDirectory(), "steam"), "ugc");
        File modDateCacheF = new File(new File(AGame.getGameDirectory(), "steam"), "updateTimes");
        File modsF = new File(new File(AGame.getGameDirectory(), "steam"), "mods");
        File[] fs = ugcF.listFiles();
        if (fs != null) {
            for (File f : fs) {
                if (this.existingUGCBases.contains(f.getName())) continue;
                AGame.deleteDir(f);
            }
        }
        if ((fs = modDateCacheF.listFiles()) != null) {
            for (File f : fs) {
                if (this.existingUGCBases.contains(f.getName())) continue;
                AGame.deleteDir(f);
            }
        }
        if (modsF.exists() && (fs = modsF.listFiles()) != null) {
            for (File f : fs) {
                if (this.existingUGCBases.contains(f.getName())) continue;
                AGame.deleteDir(f);
            }
        }
    }

    private void removeDownloads() {
        File ugcF = new File(new File(new File(AGame.getGameDirectory(), "steam"), "ugc"), this.fileName());
        File modDateCacheF = new File(new File(new File(AGame.getGameDirectory(), "steam"), "updateTimes"), this.fileName());
        File modF = new File(new File(new File(AGame.getGameDirectory(), "steam"), "mods"), this.fileName());
        ugcF.delete();
        modDateCacheF.delete();
        if (modF.exists()) {
            AGame.deleteDir(modF);
        }
    }

    private void startDownload() {
        SteamBackend.remoteStorageCallback = this;
        SteamBackend.storage.ugcDownload(this.details.getFileHandle(), 0);
    }

    private void doDownload() throws Exception {
        File ugcF = new File(new File(new File(AGame.getGameDirectory(), "steam"), "ugc"), this.fileName());
        File modDateCacheF = new File(new File(new File(AGame.getGameDirectory(), "steam"), "updateTimes"), this.fileName());
        ugcF.getParentFile().mkdirs();
        modDateCacheF.getParentFile().mkdirs();
        int chunk = 4096;
        ByteBuffer bb = ByteBuffer.allocateDirect(4096);
        byte[] array = new byte[4096];
        SteamUGCHandle h = this.details.getFileHandle();
        FileOutputStream fos = null;
        PrintWriter pw = null;
        try {
            int read;
            fos = new FileOutputStream(ugcF);
            int offset = 0;
            while ((read = SteamBackend.storage.ugcRead(h, bb, 4096, offset, SteamRemoteStorage.UGCReadAction.ContinueReading)) > 0) {
                offset += read;
                bb.rewind();
                bb.get(array);
                fos.write(array, 0, read);
            }
            fos.flush();
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(modDateCacheF), "UTF-8"));
            pw.println(this.details.getTimeUpdated());
        }
        catch (Exception e) {
            ugcF.delete();
            modDateCacheF.delete();
            throw e;
        }
        finally {
            bb.rewind();
            SteamBackend.storage.ugcRead(h, bb, 0, 0, SteamRemoteStorage.UGCReadAction.Close);
            try {
                fos.close();
            }
            catch (Exception exception) {}
            try {
                pw.close();
            }
            catch (Exception exception) {}
            if (!ugcF.exists() || FileUtils.sizeOf((File)ugcF) == 0L) {
                ugcF.delete();
                modDateCacheF.delete();
            }
        }
    }

    public void unzipMod() throws IOException {
        File ugcF = new File(new File(new File(AGame.getGameDirectory(), "steam"), "ugc"), this.fileName());
        File modDir = new File(new File(new File(AGame.getGameDirectory(), "steam"), "mods"), this.fileName());
        FileUtils.deleteDirectory((File)modDir);
        ZipUtils.unzip(new FileInputStream(ugcF), modDir);
    }

    public void unzipMission() throws IOException {
        File ugcF = new File(new File(new File(AGame.getGameDirectory(), "steam"), "ugc"), this.fileName());
        File missionDir = new File(new File(new File(AGame.getGameDirectory(), "steam"), "missions"), this.fileName());
        FileUtils.deleteDirectory((File)missionDir);
        ZipUtils.unzip(new FileInputStream(ugcF), missionDir);
    }

    public static File getEntryFile(File base, String path) {
        File f = base;
        for (String s : path.split("/")) {
            if (s.isEmpty()) continue;
            f = new File(f, s);
        }
        return f;
    }

    public Progress tick() {
        try {
            if (this.failure != null) {
                return new Progress(true, 1, 1, Lang._t("steam_workshop_unavailable", this.failure.name()));
            }
            if (!this.inited) {
                this.inited = true;
                return new Progress(false, 0, 20, Lang._t("Checking_published_items", new Object[0]));
            }
            if (!this.startedFetchingPublisheds) {
                this.startedFetchingPublisheds = true;
                this.suq = SteamBackend.ugc.createQueryUserUGCRequest((long)SteamBackend.getAccountID(), SteamUGC.UserUGCList.Published, SteamUGC.MatchingUGCType.UsableInGame, SteamUGC.UserUGCListSortOrder.CreationOrderAsc, 342560L, 342560L, this.publishedsPage);
                ++this.publishedsPage;
                SteamBackend.ugcCallback = this;
                SteamBackend.ugc.sendQueryUGCRequest(this.suq);
                return new Progress(false, 0, 20, Lang._t("Checking_published_items", new Object[0]));
            }
            if (this.waitingForPublisheds) {
                if (this.numFetchedPublisheds != -1) {
                    this.details = new SteamUGCDetails();
                    for (int i = 0; i < this.numFetchedPublisheds; ++i) {
                        SteamBackend.ugc.getQueryUGCResult(this.suq, i, this.details);
                        String typeKey = this.details.getFileName().split("-")[0];
                        PublishedItemsManager.Type type = null;
                        try {
                            type = PublishedItemsManager.Type.valueOf(typeKey);
                        }
                        catch (Exception e) {
                            System.out.println("Unknown type for " + this.details.getTitle() + " / " + this.details.getFileName());
                            System.err.println("Unknown type for " + this.details.getTitle() + " / " + this.details.getFileName());
                        }
                        if (type == null) continue;
                        PublishedItemsManager.put(type, this.details.getTitle(), this.details.getDescription(), new ArrayList<String>(), this.details.getTimeUpdated(), this.details.getPublishedFileID(), this.details.getFileName());
                    }
                    SteamBackend.ugc.releaseQueryUserUGCRequest(this.suq);
                    this.suq = null;
                    if (this.numFetchedPublisheds == 0) {
                        this.waitingForPublisheds = false;
                        return new Progress(false, 0, 20, Lang._t("Checking_Steam_subscriptions", new Object[0]));
                    }
                    this.startedFetchingPublisheds = false;
                    this.numFetchedPublisheds = -1;
                    return new Progress(false, 0, 20, Lang._t("Checking_published_items", new Object[0]));
                }
                return new Progress(false, 0, 20, Lang._t("Checking_published_items", new Object[0]));
            }
            if (this.ids == null) {
                int n = SteamBackend.ugc.getNumSubscribedItems();
                this.ids = new SteamPublishedFileID[n];
                SteamBackend.ugc.getSubscribedItems(this.ids);
                return new Progress(false, 1, this.ids.length * 2 + 2, Lang._t("Checking_Steam_subscription_x", 1, n));
            }
            if (this.steamSubIndex < this.ids.length) {
                if (this.downloadNeeded) {
                    if (!this.downloadQuerySent) {
                        this.startDownload();
                        this.downloadQuerySent = true;
                        this.downloadQueryResponded = false;
                        return new Progress(false, this.steamSubIndex * 2 + 2, this.ids.length * 2 + 2, Lang._t("Downloading_Steam_subscription_x", this.details.getTitle()));
                    }
                    if (!this.downloadQueryResponded) {
                        return new Progress(false, this.steamSubIndex * 2 + 2, this.ids.length * 2 + 2, Lang._t("Downloading_Steam_subscription_x", this.details.getTitle()));
                    }
                    try {
                        this.doDownload();
                        if (this.isMod()) {
                            this.unzipMod();
                        }
                        if (this.isMission()) {
                            this.unzipMission();
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Unable to download UGC " + this.details.getTitle());
                        e.printStackTrace();
                        this.removeDownloads();
                    }
                    this.details = null;
                    this.downloadNeeded = false;
                    this.downloadQuerySent = false;
                    this.downloadQueryResponded = false;
                    ++this.steamSubIndex;
                    return new Progress(false, this.steamSubIndex * 2 + 1, this.ids.length * 2 + 2, Lang._t("Checking_Steam_subscription_x", this.steamSubIndex + 1));
                }
                if (this.suq != null) {
                    this.details = new SteamUGCDetails();
                    if (SteamBackend.ugc.getQueryUGCResult(this.suq, 0, this.details)) {
                        SteamBackend.ugc.releaseQueryUserUGCRequest(this.suq);
                        this.suq = null;
                        this.existingUGCBases.add(this.fileName());
                        this.downloadNeeded = this.checkDownloadNeeded();
                        if (this.downloadNeeded) {
                            return new Progress(false, this.steamSubIndex * 2 + 2, this.ids.length * 2 + 2, Lang._t("Downloading_Steam_subscription_x", this.details.getTitle()));
                        }
                        ++this.steamSubIndex;
                        this.details = null;
                    }
                    return new Progress(false, this.steamSubIndex * 2 + 1, this.ids.length * 2 + 2, Lang._t("Checking_Steam_subscription_x", this.steamSubIndex + 1));
                }
                SteamPublishedFileID spfi = this.ids[this.steamSubIndex];
                this.suq = SteamBackend.ugc.createQueryUGCDetailsRequest(spfi);
                SteamBackend.ugc.sendQueryUGCRequest(this.suq);
                return new Progress(false, this.steamSubIndex * 2 + 1, this.ids.length * 2 + 2, Lang._t("Checking_Steam_subscription_x", this.steamSubIndex + 1));
            }
            if (!this.cleanedUp) {
                this.cleanedUp = true;
                this.doCleanup();
            }
            return new Progress(true, this.ids.length * 2 + 2, this.ids.length * 2 + 2, Lang._t("Done", new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            AirshipGame.instance.reportError("Steam subs load failed", e, null, false, true);
            return new Progress(true, 1, 1, Lang._t("mod_loading_failed", new Object[0]));
        }
    }

    public strictfp static class Progress {
        public final boolean done;
        public final int progress;
        public final int total;
        public final String desc;

        public Progress(boolean done, int progress, int total, String desc) {
            this.done = done;
            this.progress = progress;
            this.total = total;
            this.desc = desc;
        }
    }
}

