/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.EditMode;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.EditorOverlay;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PathingOverlay;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;

public strictfp class DisconnectionOverlay
implements UniScreen.ShipOverlay {
    private final PathingOverlay eot = new PathingOverlay();
    public boolean active = false;
    public static final Clr OVERLAY_C = new Clr(255, 0, 0, 63);

    @Override
    public void draw(MyDraw d, Airship ship, UniScreen us) {
        this.active = false;
        if (us.shipOverlay(EditorOverlay.class).active) {
            return;
        }
        if (us.hideUI) {
            return;
        }
        if (!(us.intent instanceof EditShipIntent) || ((EditShipIntent)us.intent).mode != EditMode.MODULES) {
            return;
        }
        ArrayList<ArrayList<Module>> chunks = ship.chunks(null);
        if (chunks.size() > 1) {
            int ci;
            ArrayList<Module> largest = null;
            int csz = chunks.size();
            for (ci = 0; ci < csz; ++ci) {
                ArrayList<Module> c = chunks.get(ci);
                if (largest != null && largest.size() >= c.size()) continue;
                largest = c;
            }
            for (ci = 0; ci < csz; ++ci) {
                ArrayList<Module> chunk = chunks.get(ci);
                if (chunk == largest) continue;
                int msz = chunk.size();
                for (int mi = 0; mi < msz; ++mi) {
                    Module m = chunk.get(mi);
                    d.rect(OVERLAY_C, ship.getIntX() + ship.gridXToWorldX(m.x, m.type.getW()) * 16, ship.getIntY() + m.y * 16, m.type.getW() * 16, m.type.getH() * 16);
                }
            }
            return;
        }
        chunks = ship.pathChunks(null);
        if (chunks.size() > 1) {
            double w;
            int ty;
            int tx;
            Tile t;
            int ti;
            this.active = true;
            int lineWidth = 2;
            switch (AirshipGame.instance.currentGUIScale) {
                case SMALL: {
                    lineWidth = 1;
                    break;
                }
                case MEDIUM: {
                    lineWidth = 2;
                    break;
                }
                case LARGE: {
                    lineWidth = 4;
                }
            }
            ArrayList<Module> largest = null;
            int csz = chunks.size();
            for (int ci = 0; ci < csz; ++ci) {
                ArrayList<Module> c = chunks.get(ci);
                if (largest != null && largest.size() >= c.size()) continue;
                largest = c;
            }
            int tsz = ship.tiles.size();
            for (ti = 0; ti < tsz; ++ti) {
                t = ship.tiles.get(ti);
                if (!t.canOccupy) continue;
                tx = ship.getIntX() + ship.gridXToWorldX(t.x, 1) * 16;
                ty = ship.getIntY() + t.y * 16;
                this.eot.draw(d, t, ship, tx, ty, us.zoom, 0, largest.contains(t.module) ? Clr.BLACK : Clr.RED);
                if (largest.contains(t.module) || t.module.type.getOccupableTileCount() >= 2) continue;
                w = 3.0 * (double)lineWidth / us.zoom;
                d.rect(Clr.RED, tx + 4, (double)(ty + 8) - w / 2.0, 8.0, w);
                d.rect(Clr.RED, (double)(tx + 8) - w / 2.0, ty + 4, w, 8.0);
            }
            for (ti = 0; ti < tsz; ++ti) {
                t = ship.tiles.get(ti);
                if (!t.canOccupy) continue;
                tx = ship.getIntX() + ship.gridXToWorldX(t.x, 1) * 16;
                ty = ship.getIntY() + t.y * 16;
                this.eot.draw(d, t, ship, tx, ty, us.zoom, 1, largest.contains(t.module) ? Clr.BLACK : Clr.RED);
                if (largest.contains(t.module) || t.module.type.getOccupableTileCount() >= 2) continue;
                w = 1.0 * (double)lineWidth / us.zoom;
                d.rect(Clr.WHITE, tx + 4, (double)(ty + 8) - w / 2.0, 8.0, w);
                d.rect(Clr.WHITE, (double)(tx + 8) - w / 2.0, ty + 4, w, 8.0);
            }
        }
    }

    @Override
    public boolean drawIfOffScreen() {
        return false;
    }
}

