/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.catengine.util.Pt;
import java.io.Serializable;

public strictfp final class Direction
implements Serializable {
    public static final Direction NORTH = new Direction(4.71238898038469);
    public static final Direction SOUTH = new Direction(1.5707963267948966);
    public static final Direction EAST = new Direction(0.0);
    public static final Direction WEST = new Direction(Math.PI);
    public static final Direction UP = NORTH;
    public static final Direction DOWN = SOUTH;
    public static final Direction RIGHT = EAST;
    public static final Direction LEFT = WEST;
    public final double radians;

    public double getDegrees() {
        return this.radians * 180.0 / Math.PI;
    }

    private Direction(double radians) {
        this.radians = Direction.normalizeRadians(radians);
    }

    public static double normalizeRadians(double radians) {
        while (radians < 0.0) {
            radians += Math.PI * 2;
        }
        while (radians >= Math.PI * 2) {
            radians -= Math.PI * 2;
        }
        return radians;
    }

    public static double distance(double radians1, double radians2) {
        if (radians1 < radians2) {
            return StrictMath.min(StrictMath.abs(radians2 - radians1), StrictMath.abs(radians1 + Math.PI * 2 - radians2));
        }
        return StrictMath.min(StrictMath.abs(radians1 - radians2), StrictMath.abs(radians2 + Math.PI * 2 - radians1));
    }

    public static Direction ofRadians(double radians) {
        return new Direction(radians);
    }

    public static Direction ofDegrees(double degrees) {
        return new Direction(degrees * Math.PI / 180.0);
    }

    public static Direction fromTo(Pt from, Pt to) {
        return new Direction(StrictMath.atan2(to.y - from.y, to.x - from.x));
    }

    public static Direction fromTo(double fromX, double fromY, double toX, double toY) {
        return new Direction(StrictMath.atan2(toY - fromY, toX - fromX));
    }

    public static double radiansFromTo(double fromX, double fromY, double toX, double toY) {
        return Direction.normalizeRadians(StrictMath.atan2(toY - fromY, toX - fromX));
    }

    public Pt by(double dist) {
        return new Pt(StrictMath.cos(this.radians) * dist, StrictMath.sin(this.radians) * dist);
    }

    public Pt fromBy(Pt from, double dist) {
        return new Pt(from.x + StrictMath.cos(this.radians) * dist, from.y + StrictMath.sin(this.radians) * dist);
    }

    public Direction plus(Direction d2) {
        return new Direction(this.radians + d2.radians);
    }

    public Direction minus(Direction d2) {
        return new Direction(this.radians - d2.radians);
    }

    public double minusInRadians(Direction d2) {
        return Direction.normalizeRadians(this.radians - d2.radians);
    }

    public Direction flipHorizontal() {
        return new Direction(Math.PI - this.radians);
    }

    public static double flipHorizontal(double radians) {
        return Direction.normalizeRadians(Math.PI - radians);
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.radians) ^ Double.doubleToLongBits(this.radians) >>> 32);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Direction)) {
            return false;
        }
        return ((Direction)obj).radians == this.radians;
    }

    public String toString() {
        return Double.toString(this.radians);
    }

    static void print(Pt p) {
        System.out.println(p.x + " / " + p.y);
    }
}

