/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AIQuality;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MonsterSetting;
import org.json.JSONObject;

public strictfp class DifficultyLevel
extends Loadable {
    public final AIQuality enemyAI;
    public final int playerIncome;
    public final int playerExtraMoney;
    public final int playerShipyardLevel;
    public final int playerFinalCash;
    public final int extraAIStartingTechs;
    public final double aiIncomeMultiplier;
    public final double aiProductionMultiplier;
    public final int aiExtraMoney;
    private final double monsterNestDensity;
    private final double monsterNestIncomeMult;
    public final double mergeUrgency;
    public final int attackInterval;
    public final int playerAttackInterval;
    public final boolean startingShip;
    public final int maxAIBonusConstructions;
    public final int minimalNestUpgradeTimeDivider;

    public double monsterNestDensity(MonsterSetting ms) {
        if (ms.useDifficultyLevelSetting) {
            return this.monsterNestDensity;
        }
        return ms.monsterNestDensity;
    }

    public double monsterNestIncomeMult(MonsterSetting ms) {
        if (ms.useDifficultyLevelSetting) {
            return this.monsterNestIncomeMult;
        }
        return ms.monsterNestIncomeMult;
    }

    public DifficultyLevel(JSONObject o) {
        super(o.getString("name"), o.optInt("sort", 0));
        this.enemyAI = AIQuality.valueOf(o.getString("enemyAI"));
        this.playerIncome = o.getInt("playerIncome");
        this.playerExtraMoney = o.getInt("playerExtraMoney");
        this.playerShipyardLevel = o.getInt("playerShipyardLevel");
        this.playerFinalCash = o.getInt("playerFinalCash");
        this.monsterNestDensity = o.getDouble("monsterNestDensity");
        this.monsterNestIncomeMult = o.getDouble("monsterNestIncomeMult");
        this.mergeUrgency = o.getDouble("mergeUrgency");
        this.extraAIStartingTechs = o.optInt("extraAIStartingTechs", 2);
        this.aiIncomeMultiplier = o.optDouble("aiIncomeMultiplier", 1.0);
        this.aiProductionMultiplier = o.optDouble("aiProductionMultiplier", 1.0);
        this.attackInterval = o.optInt("attackInterval", 40000);
        this.playerAttackInterval = o.optInt("playerAttackInterval", 30000);
        this.aiExtraMoney = o.optInt("aiExtraMoney", 0);
        this.startingShip = o.optBoolean("startingShip", true);
        this.maxAIBonusConstructions = o.optInt("maxAIBonusConstructions", 9);
        this.minimalNestUpgradeTimeDivider = o.optInt("minimalNestUpgradeTimeDivider", 4);
    }

    public String getName() {
        return Lang._t("difficulty_" + this.name, new Object[0]);
    }

    public static DifficultyLevel ofName(String name) {
        return Loadable.ofName(DifficultyLevel.class, name);
    }
}

