/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AnimationAppearance;
import com.zarkonnen.airships.BonusableValue;
import com.zarkonnen.airships.JSONData;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.SoundEffect;
import com.zarkonnen.airships.WeaponAppearance;
import com.zarkonnen.catengine.Img;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class CrewType
extends Loadable {
    public final boolean doesWork;
    public final boolean doesGuard;
    public final boolean canBoard;
    public final boolean hasHook;
    public final double supplyCost;
    public final double crewEffectiveness;
    public final int maxHP;
    public final int minWorkingHP;
    public final int penDmg;
    public final int blastDmg;
    public final int directDmg;
    public final int blastSplashRadius;
    public final Img shot;
    public final Particle.Emitter shotEmitter;
    public final WeaponAppearance.ShotExhaustEmitter exhaust;
    public final BonusableValue<Integer> weaponReload;
    public final int aimTime;
    public final boolean meleeAttack;
    public final double reloadSlowdown;
    public final double insideSpeed;
    public final int pickupMs;
    public final double pickupDmgMaxMalus;
    public final double pickupFireMult;
    public final double fireSpeedMult;
    public final double dmgWorstSpeedMalus;
    public final double goingUpSpeedMult;
    public final double carrySpeedMult;
    public final int repairTime;
    public final Img simpleLook;
    public final AnimationAppearance[] animLooks;
    public final double sickbayHealPMs;
    public final double fireHarmPMs;
    public final double hookSpeed;
    public final double winchSpeed;
    public final int hookRopeLength;
    public final double jumpStrength;
    public final double outsideSpeed;
    public final int assumedJumpDist;
    public final double hookRopeWidth;
    public final String shoutsKey;
    public final Img hookImg;
    public final SoundEffect deathSnd;
    public final SoundEffect coughSnd;
    public final SoundEffect hookLaunchSnd;
    public final SoundEffect hookHitSnd;
    public final SoundEffect attackSnd;
    public final ParticleType bloodParticle;
    public final ParticleType bloodParticleExternal;
    public final ParticleType attackParticle;
    public final double explosionSize;
    public final double missExplosionSize;
    public final double hitExplosionSize;
    public final int barrelX;
    public final int barrelY;
    public final double shotSpeed;
    public final double inaccuracy;
    public final double maxRange;
    public final int popOutDelayMin;
    public final int popOutDelayRange;
    public final boolean isMachine;
    public final boolean canWalk;
    public final boolean canFly;
    public final boolean crashesOnDeath;
    public final double airXTopSpeed;
    public final double airUpTopSpeed;
    public final double airDownTopSpeed;
    public final double airXMinSpeed;
    public final double airXAcceleration;
    public final double airUpAcceleration;
    public final double airDownAcceleration;
    public final double launchMinXSpeed;
    public final double launchMaxXSpeed;
    public final double launchMinYSpeed;
    public final double launchMaxYSpeed;
    public final double airOvershoot;
    public final int launchLength;
    public final SoundEffect launchSnd;
    public final boolean shootsShips;
    public final int shootTroopsRange;
    public final boolean interceptTroops;
    public final boolean bombs;
    public final boolean aimForCenter;
    public final int ammoCapacity;
    public final int rearmTime;
    public final int strafeOvershoot;
    public final int returnToRepairHP;
    public final int msPerHPRepaired;
    public final float[] recolorOriginalA;
    public final float[] recolorOriginalB;
    public final RecolorReplacement recolorReplacementA;
    public final RecolorReplacement recolorReplacementB;
    public final HashMap<String, ArrayList<String>> shouts = new HashMap();
    public static final float[] NO_COLOUR = new float[]{1.0f, 0.0f, 1.0f};
    public static ArrayList<CrewType> onlyWorkers = new ArrayList();
    public static ArrayList<CrewType> allWorkersByAbility = new ArrayList();
    public static ArrayList<CrewType> allGuardsByAbility = new ArrayList();
    public static ArrayList<CrewType> nonWorkerGuards = new ArrayList();
    public static ArrayList<CrewType> jumpers = new ArrayList();
    public static ArrayList<CrewType> grapplers = new ArrayList();
    public static ArrayList<CrewType> boarders = new ArrayList();

    public int totalDamage() {
        return this.penDmg + this.blastDmg + this.directDmg;
    }

    private void loadShouts() {
        if (this.shoutsKey != null && this.shouts.isEmpty()) {
            JSONObject o = JSONData.get("Shouts/" + this.shoutsKey);
            for (Object key : o.keySet()) {
                String k = (String)key;
                JSONArray a = o.getJSONArray(k);
                ArrayList<String> l = new ArrayList<String>(a.length());
                for (int i = 0; i < a.length(); ++i) {
                    l.add(a.getString(i));
                }
                this.shouts.put(k, l);
            }
        }
    }

    public CrewType(JSONObject o) {
        super(o.getString("name"));
        SoundEffect se;
        this.doesWork = o.optBoolean("doesWork", false);
        this.doesGuard = o.optBoolean("doesGuard", false);
        this.canBoard = o.optBoolean("canBoard", false);
        this.crewEffectiveness = o.optDouble("crewEffectiveness", 1.0);
        this.hasHook = o.optBoolean("hasHook", false);
        this.supplyCost = o.optDouble("supplyCost", 0.0);
        if (o.has("animLook")) {
            this.animLooks = new AnimationAppearance[]{AnimationAppearance.ofName(o.getString("animLook"))};
        } else {
            JSONArray lx = o.getJSONArray("animLooks");
            this.animLooks = new AnimationAppearance[lx.length()];
            for (int i = 0; i < this.animLooks.length; ++i) {
                this.animLooks[i] = AnimationAppearance.ofName(lx.getString(i));
            }
        }
        this.simpleLook = o.has("simpleLookImg") ? new Img(o.getJSONObject("simpleLookImg").getString("src"), o.getJSONObject("simpleLookImg").getInt("x"), o.getJSONObject("simpleLookImg").getInt("y"), o.getJSONObject("simpleLookImg").getInt("w"), o.getJSONObject("simpleLookImg").getInt("h"), o.getJSONObject("simpleLookImg").optBoolean("flipped", false)) : new Img(o.getJSONObject("simpleLook").getString("src"), o.getJSONObject("simpleLook").getInt("x") * 16, o.getJSONObject("simpleLook").getInt("y") * 16, 16, 16, false);
        this.maxHP = o.getInt("maxHP");
        this.minWorkingHP = o.getInt("minWorkingHP");
        this.isMachine = o.optBoolean("isMachine", false);
        double ceDiv = Math.max(0.25, this.crewEffectiveness);
        this.pickupMs = (int)(300.0 / ceDiv);
        this.insideSpeed = o.optDouble("insideSpeed", 1.0);
        this.reloadSlowdown = o.optDouble("reloadSlowdown", 0.5);
        this.pickupDmgMaxMalus = 3.0;
        this.pickupFireMult = 1.0 + 0.5 / ceDiv;
        this.fireSpeedMult = 1.0 - 0.3 / ceDiv;
        this.dmgWorstSpeedMalus = -0.3;
        this.goingUpSpeedMult = o.optDouble("goingUpSpeedMult", 1.0);
        this.carrySpeedMult = 1.0 - 0.2 / ceDiv;
        this.repairTime = (int)(4000.0 / ceDiv);
        if (o.has("shotDamageMin")) {
            this.penDmg = o.getInt("shotDamageMin") + o.optInt("shotDamageRange", 2) / 2;
            this.blastDmg = 0;
            this.directDmg = 0;
        } else {
            this.penDmg = o.optInt("penDmg", 0);
            this.blastDmg = o.optInt("blastDmg", 0);
            this.directDmg = o.optInt("directDmg", 0);
        }
        this.blastSplashRadius = o.optInt("blastSplashRadius", 0);
        this.weaponReload = BonusableValue.intFromJSONWithDivAndMinAndMax(o, "weaponReload", 1000, 1, 1, 100000);
        this.meleeAttack = o.optBoolean("meleeAttack", false);
        this.sickbayHealPMs = o.optDouble("sickbayHealPMs", 3.0E-5);
        this.fireHarmPMs = o.optDouble("fireHarmPMs", 5.0E-5);
        this.hookSpeed = o.optDouble("hookSpeed", 0.5);
        this.winchSpeed = o.optDouble("winchSpeed", 0.1);
        this.hookRopeLength = o.optInt("hookRopeLength", 260);
        this.jumpStrength = o.optDouble("jumpStrength", 0.15);
        this.outsideSpeed = o.optDouble("outsideSpeed", 0.035);
        this.assumedJumpDist = o.optInt("assumedJumpDist", 50);
        this.popOutDelayMin = o.optInt("popOutDelayMin", 0);
        this.popOutDelayRange = o.optInt("popOutDelayRange", 0);
        this.aimTime = o.optInt("aimTime", 500);
        this.explosionSize = o.optDouble("explosionSize", 0.0);
        this.shoutsKey = o.optString("shouts", null);
        this.loadShouts();
        if (o.has("hookImg")) {
            JSONObject hi = o.getJSONObject("hookImg");
            this.hookImg = new Img(hi.getString("src"), hi.getInt("x"), hi.getInt("y"), hi.getInt("w"), hi.getInt("h"), hi.optBoolean("flipped", false));
        } else {
            this.hookImg = null;
        }
        this.hookRopeWidth = o.optDouble("hookRopeWidth", 1.0);
        if (o.has("deathSnd")) {
            se = null;
            try {
                se = new SoundEffect(o.getString("deathSnd"), o.optInt("numDeathSnds", 1));
            }
            catch (Exception e) {
                se = new SoundEffect(o.getJSONObject("deathSnd"));
            }
            this.deathSnd = se;
        } else {
            this.deathSnd = null;
        }
        if (o.has("coughSnd")) {
            se = null;
            try {
                se = new SoundEffect(o.getString("coughSnd"), o.optInt("numCoughSnds", 1));
            }
            catch (Exception e) {
                se = new SoundEffect(o.getJSONObject("coughSnd"));
            }
            this.coughSnd = se;
        } else {
            this.coughSnd = null;
        }
        if (o.has("hookLaunchSnd")) {
            se = null;
            try {
                se = new SoundEffect(o.getString("hookLaunchSnd"), o.optInt("numHookLaunchSnds", 1));
            }
            catch (Exception e) {
                se = new SoundEffect(o.getJSONObject("hookLaunchSnd"));
            }
            this.hookLaunchSnd = se;
        } else {
            this.hookLaunchSnd = null;
        }
        if (o.has("hookHitSnd")) {
            se = null;
            try {
                se = new SoundEffect(o.getString("hookHitSnd"), o.optInt("numHookHitSnds", 1));
            }
            catch (Exception e) {
                se = new SoundEffect(o.getJSONObject("hookHitSnd"));
            }
            this.hookHitSnd = se;
        } else {
            this.hookHitSnd = null;
        }
        if (o.has("attackSnd")) {
            se = null;
            try {
                se = new SoundEffect(o.getString("attackSnd"), o.optInt("numAttackSnds", 1));
            }
            catch (Exception e) {
                se = new SoundEffect(o.getJSONObject("attackSnd"));
            }
            this.attackSnd = se;
        } else {
            this.attackSnd = null;
        }
        this.bloodParticle = o.has("bloodParticle") ? ParticleType.ofName(o.getString("bloodParticle")) : null;
        this.bloodParticleExternal = o.has("bloodParticleExternal") ? ParticleType.ofName(o.getString("bloodParticleExternal")) : null;
        this.attackParticle = o.has("attackParticle") ? ParticleType.ofName(o.getString("attackParticle")) : null;
        this.shootsShips = o.optBoolean("shootsShips", false);
        this.strafeOvershoot = o.optInt("strafeOvershoot", 128);
        if (o.has("recolorOriginalA")) {
            this.recolorOriginalA = new float[]{(float)o.getJSONObject("recolorOriginalA").getInt("r") / 255.0f, (float)o.getJSONObject("recolorOriginalA").getInt("g") / 255.0f, (float)o.getJSONObject("recolorOriginalA").getInt("b") / 255.0f};
            this.recolorReplacementA = RecolorReplacement.valueOf(o.getString("recolorReplacementA"));
        } else {
            this.recolorOriginalA = NO_COLOUR;
            this.recolorReplacementA = RecolorReplacement.COA_1;
        }
        if (o.has("recolorOriginalB")) {
            this.recolorOriginalB = new float[]{(float)o.getJSONObject("recolorOriginalB").getInt("r") / 255.0f, (float)o.getJSONObject("recolorOriginalB").getInt("g") / 255.0f, (float)o.getJSONObject("recolorOriginalB").getInt("b") / 255.0f};
            this.recolorReplacementB = RecolorReplacement.valueOf(o.getString("recolorReplacementB"));
        } else {
            this.recolorOriginalB = NO_COLOUR;
            this.recolorReplacementB = RecolorReplacement.COA_1;
        }
        if (o.has("shot")) {
            JSONObject so = o.getJSONObject("shot");
            this.shot = new Img(so.getString("src"), so.getInt("x"), so.getInt("y"), so.getInt("w"), so.getInt("h"), so.optBoolean("flipped"));
        } else {
            this.shot = null;
        }
        this.inaccuracy = o.optDouble("inaccuracy", 0.005);
        this.maxRange = o.optDouble("maxRange", 500.0);
        this.barrelX = o.optInt("barrelX", 18);
        this.barrelY = o.optInt("barrelY", 4);
        this.shotSpeed = o.optDouble("shotSpeed", 0.7);
        this.missExplosionSize = o.optDouble("missExplosionSize", 0.0);
        this.hitExplosionSize = o.optDouble("hitExplosionSize", 0.0);
        this.returnToRepairHP = o.optInt("returnToRepairHP", 0);
        this.msPerHPRepaired = o.optInt("msPerHPRepaired", 0);
        this.shootTroopsRange = o.optInt("shootTroopsRange", 0);
        this.interceptTroops = o.optBoolean("interceptTroops", false);
        this.canWalk = o.optBoolean("canWalk", true);
        this.canFly = o.optBoolean("canFly", false);
        if (o.has("shotEmitter")) {
            JSONObject em = o.getJSONObject("shotEmitter");
            SoundEffect ef = null;
            if (em.has("sound")) {
                try {
                    String sound = em.getString("sound");
                    ef = new SoundEffect(sound, em.optDouble("volume"));
                }
                catch (Exception e) {
                    ef = new SoundEffect(em.getJSONObject("sound"));
                }
            }
            this.shotEmitter = new Particle.Emitter(ParticleType.ofName(em.getString("type")), em.getDouble("emitProbability"), em.optInt("numParticles", 1), ef);
        } else {
            this.shotEmitter = null;
        }
        if (o.has("exhaust")) {
            JSONObject e = o.getJSONObject("exhaust");
            this.exhaust = new WeaponAppearance.ShotExhaustEmitter(ParticleType.ofName(e.getString("type")), e.getDouble("p"), e.getDouble("backOffset"), e.getDouble("angleRange"), e.getDouble("randomOffset"), e.getDouble("speedMin"), e.getDouble("speedMax"));
        } else {
            this.exhaust = null;
        }
        if (this.canFly) {
            this.crashesOnDeath = o.optBoolean("crashesOnDeath", false);
            this.bombs = o.optBoolean("bombs", false);
            this.airXTopSpeed = o.getDouble("airXTopSpeed");
            this.airUpTopSpeed = o.getDouble("airUpTopSpeed");
            this.airDownTopSpeed = o.getDouble("airDownTopSpeed");
            this.airXAcceleration = o.getDouble("airXAcceleration");
            this.airUpAcceleration = o.getDouble("airUpAcceleration");
            this.airDownAcceleration = o.getDouble("airDownAcceleration");
            this.launchMinXSpeed = o.getDouble("launchMinXSpeed");
            this.launchMaxXSpeed = o.getDouble("launchMaxXSpeed");
            this.launchMinYSpeed = o.getDouble("launchMinYSpeed");
            this.launchMaxYSpeed = o.getDouble("launchMaxYSpeed");
            this.airOvershoot = o.getDouble("airOvershoot");
            this.launchLength = o.optInt("launchLength", 0);
            this.airXMinSpeed = o.optDouble("airXMinSpeed", 0.0);
            this.aimForCenter = o.optBoolean("aimForCenter");
            this.ammoCapacity = o.optInt("ammoCapacity", 0);
            this.rearmTime = o.optInt("rearmTime", 0);
            if (o.has("launchSnd")) {
                se = null;
                try {
                    se = new SoundEffect(o.getString("launchSnd"), o.optInt("numLaunchSnds", 1));
                }
                catch (Exception e) {
                    se = new SoundEffect(o.getJSONObject("launchSnd"));
                }
                this.launchSnd = se;
            } else {
                this.launchSnd = null;
            }
        } else {
            this.crashesOnDeath = false;
            this.airXTopSpeed = 0.0;
            this.airUpTopSpeed = 0.0;
            this.airDownTopSpeed = 0.0;
            this.airXAcceleration = 0.0;
            this.airUpAcceleration = 0.0;
            this.airDownAcceleration = 0.0;
            this.launchMinXSpeed = 0.0;
            this.launchMaxXSpeed = 0.0;
            this.launchMinYSpeed = 0.0;
            this.launchMaxYSpeed = 0.0;
            this.airOvershoot = 0.0;
            this.launchSnd = null;
            this.launchLength = 0;
            this.airXMinSpeed = 0.0;
            this.bombs = false;
            this.aimForCenter = false;
            this.ammoCapacity = 0;
            this.rearmTime = 0;
        }
    }

    public String getName() {
        return Lang._t("crew_" + this.name.toUpperCase(Locale.ENGLISH), new Object[0]);
    }

    public String getPlural() {
        return Lang._t("crew_" + this.name.toUpperCase(Locale.ENGLISH) + "_plural", new Object[0]);
    }

    public static CrewType ofName(String name) {
        return Loadable.ofName(CrewType.class, name);
    }

    public static void postLoad() {
        onlyWorkers.clear();
        allWorkersByAbility.clear();
        allGuardsByAbility.clear();
        nonWorkerGuards.clear();
        jumpers.clear();
        grapplers.clear();
        boarders.clear();
        for (CrewType ct : Loadable.all(CrewType.class)) {
            if (ct.doesWork && !ct.canBoard && !ct.doesGuard) {
                onlyWorkers.add(ct);
            }
            if (ct.doesWork) {
                allWorkersByAbility.add(ct);
            }
            if (ct.doesGuard) {
                allGuardsByAbility.add(ct);
            }
            if (ct.doesGuard && !ct.doesWork) {
                nonWorkerGuards.add(ct);
            }
            if (ct.canBoard && !ct.hasHook) {
                jumpers.add(ct);
            }
            if (ct.canBoard && ct.hasHook) {
                grapplers.add(ct);
            }
            if (!ct.canBoard) continue;
            boarders.add(ct);
        }
        Collections.sort(allWorkersByAbility, new Comparator<CrewType>(){

            @Override
            public int compare(CrewType t, CrewType t1) {
                return Double.compare(t1.crewEffectiveness, t.crewEffectiveness);
            }
        });
        Collections.sort(allGuardsByAbility, new Comparator<CrewType>(){

            @Override
            public int compare(CrewType t, CrewType t1) {
                if (t.doesWork && !t1.doesWork) {
                    return 1;
                }
                if (!t.doesWork && t1.doesWork) {
                    return -1;
                }
                return Double.compare(t1.totalDamage(), t.totalDamage());
            }
        });
    }

    public strictfp static enum RecolorReplacement {
        COA_1(0),
        COA_2(1),
        COA_3(2),
        COA_COLOUR(3),
        COA_METAL(4);

        public final int armsColorIndex;

        private RecolorReplacement(int armsColorIndex) {
            this.armsColorIndex = armsColorIndex;
        }
    }
}

