/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import org.newdawn.slick.Graphics;

public strictfp class CrateDialog {
    public static final Img FLOOR = new Img("ui", 256, 0, 256, 256, false);
    public static final Img CRATE = new Img("crate", 0, 0, 220, 230, false);
    public static final Img LID = new Img("crate", 0, 0, 220, 20, false);
    public static final Img OPEN_CRATE = new Img("crate-nolid", 0, 0, 210, 210, false);
    public static final Img INSIDECRATE_SPIDERS = new Img("insidecrate-spiders", 0, 0, 200, 200, false);
    public static final Img INSIDECRATE = new Img("insidecrate", 0, 0, 200, 200, false);
    public static final Img LIGHT = new Img("light_big", 0, 0, 512, 512, false);
    public static final Clr SHADOW = new Clr(0, 0, 30);
    public static final Clr LIT = new Clr(245, 237, 181);
    public static final Img LIGHT_WEAK = new Img("light_big_weak", 0, 0, 512, 512, false);
    public static final Img[] SPIDERS = new Img[]{new Img("spider0", 0, 0, 500, 416, false), new Img("spider1", 0, 0, 309, 500, false), new Img("spider2", 0, 0, 500, 472, false)};
    ArrayList<Spider> spiders = new ArrayList();
    private boolean warningAccepted = false;
    public static final int VIBRATE = 600;
    private int vibrateTime = 0;
    public static final int POST_VIBRATE = 400;
    private int postVibratePause = 0;
    public static final int[] ROCK_DIRS = new int[]{1, 1, -1};
    private int numRocks = 0;
    private double rockAngle = 0.0;
    public static final double ROCK_FORCE = 7.0E-4;
    public static final double ROCK_RETURN_ACCEL = 5.0E-5;
    private double rockAngleSpeed = 0.0;
    public static final int TWEEN_ROCK = 300;
    private int betweenRockPause = 0;
    public static final int POSTROCK = 500;
    private int postRockPause = 0;
    double THUMP_FORCE = 1.5;
    double GRAVITY = 0.04;
    private boolean thumped = false;
    double thumpY = 0.0;
    double thumpYSpeed = 0.0;
    int POSTTHUMP = 500;
    private int postThumpPause = 0;
    double LID_X_FORCE = 1.0;
    double LID_Y_FORCE = -2.5;
    double LID_SPIN = 0.02;
    double lidX = 0.0;
    double lidY = 0.0;
    double lidXSpeed = 0.0;
    double lidYSpeed = 0.0;
    double lidAngle = 0.0;
    double LIDTIME = 1000.0;
    private int lidTime = 0;
    double tipAngle = 0.0;
    double tipAngleSpeed = 0.0;
    double TIPPING_POINT = 0.7853981633974483;
    double TIP_FORCE = 0.007;
    double TIP_ACCEL = 5.0E-6;
    int spiderTime = 0;
    int SPIDERTIME = 500;
    int time = 0;
    private final MainMenu mm;

    public CrateDialog(MainMenu mm) {
        this.mm = mm;
    }

    public void tick(Input in) {
        int ms = in.msDelta();
        this.time += ms;
        if (this.warningAccepted) {
            if (this.vibrateTime < 600) {
                if (this.vibrateTime == 0) {
                    in.play("scrabble", 1.5, 0.5 * AirshipGame.instance.volume, 0.0, 0.0);
                }
                this.vibrateTime += ms;
            } else if (this.postVibratePause < 400) {
                this.postVibratePause += ms;
            } else if (this.numRocks < ROCK_DIRS.length) {
                if (this.betweenRockPause > 0) {
                    this.betweenRockPause -= ms;
                } else {
                    if (this.rockAngleSpeed == 0.0 && this.rockAngle == 0.0) {
                        in.play("knock" + this.numRocks, 1.0, (0.6 + (double)this.numRocks * 0.2) * AirshipGame.instance.volume, 0.0, 0.0);
                        this.rockAngleSpeed += (double)(this.numRocks + 3) * 7.0E-4 * (double)ROCK_DIRS[this.numRocks];
                    } else {
                        this.rockAngleSpeed -= 5.0E-5 * (double)ms * (double)ROCK_DIRS[this.numRocks];
                    }
                    this.rockAngle += this.rockAngleSpeed * (double)ms;
                    if (this.rockAngle * (double)ROCK_DIRS[this.numRocks] < 0.0) {
                        this.rockAngleSpeed = 0.0;
                        this.rockAngle = 0.0;
                        ++this.numRocks;
                        this.betweenRockPause = 300;
                    }
                }
            } else if (this.postRockPause < 500) {
                this.betweenRockPause = 0;
                this.postRockPause += ms;
            } else if (!this.thumped) {
                this.betweenRockPause = 0;
                if (this.thumpYSpeed == 0.0) {
                    in.play("knock3", 1.0, 1.0 * AirshipGame.instance.volume, 0.0, 0.0);
                    this.thumpYSpeed = -this.THUMP_FORCE;
                }
                this.thumpYSpeed += (double)ms * this.GRAVITY;
                this.thumpY += this.thumpYSpeed * (double)ms;
                if (this.thumpY > 0.0) {
                    this.thumpY = 0.0;
                    this.thumpYSpeed = 0.0;
                    this.thumped = true;
                }
            } else if (this.postThumpPause < this.POSTTHUMP) {
                this.postThumpPause += ms;
            } else if ((double)this.lidTime < this.LIDTIME) {
                if (this.lidTime == 0) {
                    in.play("crateopen", 1.0, 1.0 * AirshipGame.instance.volume, 0.0, 0.0);
                    this.lidXSpeed = this.LID_X_FORCE;
                    this.lidYSpeed = this.LID_Y_FORCE;
                }
                this.lidTime += ms;
                this.lidYSpeed += (double)ms * this.GRAVITY / 3.0;
                this.lidX += (double)ms * this.lidXSpeed;
                boolean above = this.lidY < (double)CrateDialog.CRATE.srcHeight;
                this.lidY += (double)ms * this.lidYSpeed;
                if (above && this.lidY >= (double)CrateDialog.CRATE.srcHeight) {
                    in.play("metallicslam", 1.5, 0.5 * AirshipGame.instance.volume, 1.0, 0.0);
                }
                this.lidAngle += (double)ms * this.LID_SPIN;
            } else if (this.tipAngle < 1.5707963267948966) {
                if (this.tipAngle == 0.0) {
                    this.tipAngleSpeed = this.TIP_FORCE;
                    in.play("cratecreak1", 1.0, 0.3 * AirshipGame.instance.volume, 0.0, 0.0);
                }
                this.tipAngleSpeed += (double)ms * this.TIP_ACCEL * (double)(this.tipAngle > this.TIPPING_POINT ? 1 : -1);
                this.tipAngle += (double)ms * this.tipAngleSpeed;
                if (this.tipAngle > 1.5707963267948966) {
                    this.tipAngle = 1.5707963267948966;
                    this.tipAngleSpeed = 0.0;
                    in.play("knock4", 1.0, 1.0 * AirshipGame.instance.volume, 0.0, 0.0);
                    in.play("spiderfling", 1.0, 1.0 * AirshipGame.instance.volume, 0.0, 0.0);
                }
            } else if (this.spiderTime < this.SPIDERTIME) {
                for (Spider s : this.spiders) {
                    s.tick(ms);
                }
                this.spiderTime += ms;
            } else {
                this.mm.crateDialog = null;
                MainMenu.spidersReleased = true;
                AirshipGame.instance.saveSettings();
            }
        }
    }

    private int extraW() {
        switch (AirshipGame.instance.currentGUIScale) {
            case SMALL: {
                return 200;
            }
            case MEDIUM: {
                return 400;
            }
            case LARGE: {
                return 400;
            }
        }
        return 200;
    }

    private int extraH() {
        switch (AirshipGame.instance.currentGUIScale) {
            case SMALL: {
                return 100;
            }
            case MEDIUM: {
                return 200;
            }
            case LARGE: {
                return 200;
            }
        }
        return 100;
    }

    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.state.glowRects.clear();
        int w = Math.max(d.bw(Lang._t("lootbox_understand", new Object[0])), CrateDialog.CRATE.srcWidth + this.extraW() + MyDraw.PANEL_INSET * 2) + MyDraw.WINDOW_INSET * 2;
        int textH = (int)d.textSize((String)Lang._t((String)"lootbox_info", (Object[])new Object[0]), (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)(w - MyDraw.WINDOW_INSET * 2)).height;
        int h = this.extraH() + CrateDialog.CRATE.srcHeight + MyDraw.PANEL_INSET * 2 + MyDraw.WINDOW_INSET * 2;
        int hWithText = h + textH + MyDraw.BUTTON_H * 2 + MyDraw.BUTTON_SPACING + MyDraw.UI_SPACING * 2;
        if (!this.warningAccepted) {
            h = hWithText;
        }
        int x = sm.width / 2 - w / 2;
        int y = sm.height / 2 - hWithText / 2;
        d.drawShadowedWindow(x, y, w, h);
        x += MyDraw.WINDOW_INSET;
        y += MyDraw.WINDOW_INSET;
        w -= MyDraw.WINDOW_INSET * 2;
        Graphics g = (Graphics)d.frame().nativeRenderer();
        int panelH = this.extraH() + CrateDialog.CRATE.srcHeight + MyDraw.PANEL_INSET * 2;
        if (this.spiders.isEmpty()) {
            int xStart = sm.width / 2 - 60;
            int xRange = 120;
            int yStart = y + this.extraH() / 2 + 40;
            int yRange = 120;
            for (int i = 0; i < 40; ++i) {
                this.spiders.add(new Spider(xStart + AGame.ANIM_R.nextInt(xRange), yStart + AGame.ANIM_R.nextInt(yRange)));
            }
        }
        g.setClip(x + 1, y + 1, w - 2, panelH - 2);
        d.rect(new Clr(20, 20, 25), x, y, w, panelH);
        d.blit(FLOOR, x, y + panelH / 2 + 80, w, panelH / 2 - 80);
        int sw = CrateDialog.CRATE.srcWidth + 80;
        d.blit(LIGHT, SHADOW, sm.width / 2 - sw / 2 + 10, y + panelH / 2 + 80, sw, 40.0);
        double lightR = 120.0 + 20.0 * Math.sin((double)this.time * 4.0E-4);
        if (!this.warningAccepted) {
            d.blit(CRATE, x + w / 2 - CrateDialog.CRATE.srcWidth / 2, y + this.extraH() / 2);
            d.blit(LIGHT_WEAK, LIT, (double)(x + w / 2) - lightR, (double)(y + this.extraH() / 2 + CrateDialog.CRATE.srcHeight / 2) - lightR - 10.0, lightR * 2.0, lightR * 2.0);
        } else if (this.vibrateTime < 600) {
            d.blit(CRATE, x + w / 2 - CrateDialog.CRATE.srcWidth / 2 + AGame.ANIM_R.nextInt(4) - 2, y + this.extraH() / 2 - AGame.ANIM_R.nextInt(2));
            d.blit(LIGHT_WEAK, LIT, (double)(x + w / 2) - lightR, (double)(y + this.extraH() / 2 + CrateDialog.CRATE.srcHeight / 2) - lightR - 10.0, lightR * 2.0, lightR * 2.0);
        } else if (this.postVibratePause < 400 || this.betweenRockPause > 0) {
            d.blit(CRATE, x + w / 2 - CrateDialog.CRATE.srcWidth / 2, y + this.extraH() / 2);
            d.blit(LIGHT_WEAK, LIT, (double)(x + w / 2) - lightR, (double)(y + this.extraH() / 2 + CrateDialog.CRATE.srcHeight / 2) - lightR - 10.0, lightR * 2.0, lightR * 2.0);
        } else if (this.numRocks < ROCK_DIRS.length) {
            d.blit(CRATE, x + w / 2 - CrateDialog.CRATE.srcWidth / 2, (double)(y + this.extraH() / 2) - Math.sin(Math.abs(this.rockAngle)) * (double)CrateDialog.CRATE.srcWidth * 0.5, this.rockAngle);
            d.blit(LIGHT_WEAK, LIT, (double)(x + w / 2) - lightR, (double)(y + this.extraH() / 2 + CrateDialog.CRATE.srcHeight / 2) - lightR - 10.0, lightR * 2.0, lightR * 2.0);
        } else if (this.postRockPause < 500) {
            d.blit(CRATE, x + w / 2 - CrateDialog.CRATE.srcWidth / 2, y + this.extraH() / 2);
            d.blit(LIGHT_WEAK, LIT, (double)(x + w / 2) - lightR, (double)(y + this.extraH() / 2 + CrateDialog.CRATE.srcHeight / 2) - lightR - 10.0, lightR * 2.0, lightR * 2.0);
        } else if (!this.thumped) {
            d.blit(CRATE, x + w / 2 - CrateDialog.CRATE.srcWidth / 2, (double)(y + this.extraH() / 2) + this.thumpY);
            d.blit(LIGHT_WEAK, LIT, (double)(x + w / 2) - lightR, (double)(y + this.extraH() / 2 + CrateDialog.CRATE.srcHeight / 2) - lightR - 10.0 + this.thumpY, lightR * 2.0, lightR * 2.0);
        } else if (this.postThumpPause < this.POSTTHUMP) {
            d.blit(CRATE, x + w / 2 - CrateDialog.CRATE.srcWidth / 2, y + this.extraH() / 2);
            d.blit(LIGHT_WEAK, LIT, (double)(x + w / 2) - lightR, (double)(y + this.extraH() / 2 + CrateDialog.CRATE.srcHeight / 2) - lightR - 10.0, lightR * 2.0, lightR * 2.0);
        } else if ((double)this.lidTime < this.LIDTIME) {
            d.blit(OPEN_CRATE, x + w / 2 - CrateDialog.OPEN_CRATE.srcWidth / 2, y + this.extraH() / 2 + CrateDialog.CRATE.srcHeight - CrateDialog.OPEN_CRATE.srcHeight);
            d.blit(LID, (double)(x + w / 2 - CrateDialog.LID.srcWidth / 2) + this.lidX, (double)(y + this.extraH() / 2) + this.lidY, this.lidAngle);
            d.blit(LIGHT_WEAK, LIT, (double)(x + w / 2) - lightR, (double)(y + this.extraH() / 2 + CrateDialog.CRATE.srcHeight / 2) - lightR - 10.0, lightR * 2.0, lightR * 2.0);
        } else if (this.tipAngle < 1.5707963267948966) {
            int sideH = (int)((double)CrateDialog.OPEN_CRATE.srcHeight * Math.sin(1.5707963267948966 - this.tipAngle));
            int topH = (int)((double)CrateDialog.INSIDECRATE.srcHeight * Math.sin(this.tipAngle));
            int baseY = y + this.extraH() / 2 + CrateDialog.CRATE.srcHeight;
            d.blit(OPEN_CRATE, x + w / 2 - CrateDialog.OPEN_CRATE.srcWidth / 2, baseY - sideH, CrateDialog.OPEN_CRATE.srcWidth, sideH);
            d.blit(this.tipAngle > 0.7853981633974483 ? INSIDECRATE_SPIDERS : INSIDECRATE, x + w / 2 - CrateDialog.INSIDECRATE.srcWidth / 2, baseY - sideH - topH, CrateDialog.INSIDECRATE.srcWidth, topH);
            d.blit(LIGHT_WEAK, LIT, (double)(x + w / 2) - lightR, (double)(baseY - sideH / 2) - (lightR + 10.0) * Math.sin(1.5707963267948966 - this.tipAngle), lightR * 2.0, lightR * 2.0 * Math.sin(1.5707963267948966 - this.tipAngle));
        } else {
            int baseY = y + this.extraH() / 2 + CrateDialog.CRATE.srcHeight;
            d.blit(INSIDECRATE_SPIDERS, x + w / 2 - CrateDialog.INSIDECRATE.srcWidth / 2, baseY - CrateDialog.INSIDECRATE.srcHeight);
        }
        g.clearClip();
        d.drawPanelBorder(x, y, w, panelH);
        if (this.spiderTime > 0) {
            for (Spider s : this.spiders) {
                if (s.lifespan < this.spiderTime) continue;
                g.translate((float)s.x, (float)s.y);
                g.scale((float)s.scale, (float)s.scale);
                d.blit(SPIDERS[s.type], -CrateDialog.SPIDERS[s.type].srcWidth / 2, -CrateDialog.SPIDERS[s.type].srcHeight / 2, s.angle);
                g.resetTransform();
            }
        }
        if (!this.warningAccepted) {
            d.text(Lang._t("lootbox_info", new Object[0]), AGame.FOUNT, x, y += panelH + MyDraw.UI_SPACING, w);
            d.button(x, y += textH + MyDraw.UI_SPACING, w, Lang._t("lootbox_understand", new Object[0]), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    CrateDialog.this.warningAccepted = true;
                }
            }, true);
            d.button(x, y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, w, Lang._t("Cancel", new Object[0]), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    ((CrateDialog)CrateDialog.this).mm.crateDialog = null;
                }
            }, true);
        }
    }

    strictfp static class Spider {
        int type = AGame.ANIM_R.nextInt(SPIDERS.length);
        double x;
        double y;
        double dx;
        double dy;
        double angle;
        double scale;
        int lifespan;

        public Spider(double x, double y) {
            this.x = x;
            this.y = y;
            this.angle = AGame.ANIM_R.nextDouble() * 2.0 * Math.PI;
            double mvAngle = AGame.ANIM_R.nextDouble() * 2.0 * Math.PI;
            double mvMagnitude = AGame.ANIM_R.nextDouble() * 3.0;
            this.dx = Math.cos(mvAngle) * mvMagnitude;
            this.dy = Math.sin(mvAngle) * mvMagnitude;
            this.scale = 0.03 + AGame.ANIM_R.nextDouble() * 0.03;
            this.lifespan = 200 + AGame.ANIM_R.nextInt(300);
        }

        public void tick(int ms) {
            this.x += this.dx * (double)ms;
            this.y += this.dy * (double)ms;
            this.scale += 0.002 * (double)ms;
        }
    }
}

