/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.Charge;
import com.zarkonnen.airships.DifficultyLevel;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.Tech;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class ConstructionStrategy
extends Loadable {
    public ArrayList<ArrayList<String>> shipNames = new ArrayList();
    public ArrayList<ArrayList<String>> landshipNames = new ArrayList();
    public ArrayList<ArrayList<String>> buildingNames = new ArrayList();
    public ArrayList<Tech.Choice> techs = new ArrayList();
    private final ArrayList<ArrayList<Airship>> ships = new ArrayList();
    private final ArrayList<ArrayList<Airship>> landships = new ArrayList();
    private final ArrayList<ArrayList<Airship>> buildings = new ArrayList();
    public final ArrayList<ArrayList<String>> shipUpgradeSequences = new ArrayList();
    public final ArrayList<ArrayList<String>> landshipUpgradeSequences = new ArrayList();
    public final ArrayList<ArrayList<String>> buildingUpgradeSequences = new ArrayList();
    public HashSet<Charge> charges = new HashSet();
    public Charge requiredCharge;
    public final DifficultyLevel minDifficultyLevel;

    public static ArrayList<ConstructionStrategy> forCharge(Charge c, DifficultyLevel d) {
        ArrayList<ConstructionStrategy> l = new ArrayList<ConstructionStrategy>();
        for (ConstructionStrategy s : Loadable.all(ConstructionStrategy.class)) {
            if (s.requiredCharge != c) continue;
            if (s.charges.contains(c) && (s.minDifficultyLevel == null || s.minDifficultyLevel.sort <= d.sort)) {
                l.add(s);
                continue;
            }
            if (s.requiredCharge != c || s.minDifficultyLevel != null && s.minDifficultyLevel.sort > d.sort) continue;
            l.add(s);
        }
        if (l.isEmpty()) {
            for (ConstructionStrategy s : Loadable.all(ConstructionStrategy.class)) {
                if (s.requiredCharge != null || s.minDifficultyLevel != null && s.minDifficultyLevel.sort > d.sort) continue;
                l.add(s);
            }
        }
        return l;
    }

    private void loadTier(JSONObject o, String name, ArrayList<ArrayList<String>> names) {
        JSONArray a = o.getJSONArray(name);
        for (int i = 0; i < a.length(); ++i) {
            ArrayList<String> tier = new ArrayList<String>();
            JSONArray a2 = a.getJSONArray(i);
            for (int j = 0; j < a2.length(); ++j) {
                tier.add(a2.getString(j));
            }
            names.add(tier);
        }
    }

    public ConstructionStrategy(JSONObject o) {
        super(o.getString("name"));
        int i;
        JSONArray a;
        this.loadTier(o, "shipTiers", this.shipNames);
        this.loadTier(o, "landshipTiers", this.landshipNames);
        this.loadTier(o, "buildingTiers", this.buildingNames);
        this.loadTier(o, "shipUpgradeSequences", this.shipUpgradeSequences);
        this.loadTier(o, "landshipUpgradeSequences", this.landshipUpgradeSequences);
        this.loadTier(o, "buildingUpgradeSequences", this.buildingUpgradeSequences);
        if (o.has("techs")) {
            a = o.getJSONArray("techs");
            for (i = 0; i < a.length(); ++i) {
                Tech.Choice c = Tech.choiceOfName(a.getString(i));
                if (c == null) continue;
                this.techs.add(c);
            }
        }
        if (o.has("charges")) {
            a = o.getJSONArray("charges");
            for (i = 0; i < a.length(); ++i) {
                if (!Loadable.hasOfName(Charge.class, a.getString(i))) continue;
                this.charges.add(Charge.ofName(a.getString(i)));
            }
        }
        if (o.has("requiredCharge")) {
            this.requiredCharge = Charge.ofName(o.getString("requiredCharge"));
        }
        this.minDifficultyLevel = o.has("minDifficultyLevel") ? DifficultyLevel.ofName(o.getString("minDifficultyLevel")) : null;
    }

    public ArrayList<Airship> getBestAvailableDesignTier(ShipType t, BonusSet bonuses) {
        ArrayList<ArrayList<Airship>> designs = this.getDesigns(t);
        ArrayList<Airship> chosenShips = new ArrayList<Airship>();
        int dsz = designs.size();
        for (int di = 0; di < dsz; ++di) {
            Airship s;
            int ti;
            ArrayList<Airship> tier = designs.get(di);
            int tsz = tier.size();
            boolean found = false;
            for (ti = 0; ti < tsz; ++ti) {
                s = tier.get(ti);
                if (!s.isBuildable(bonuses)) continue;
                found = true;
                break;
            }
            if (!found || !tier.containsAll(chosenShips)) continue;
            chosenShips.clear();
            for (ti = 0; ti < tsz; ++ti) {
                s = tier.get(ti);
                if (!s.isBuildable(bonuses)) continue;
                chosenShips.add(s);
            }
        }
        ArrayList<Bonus> l = bonuses.list();
        int lsz = l.size();
        for (int li = 0; li < lsz; ++li) {
            ArrayList<Airship> specials = l.get(li).getEnabledSpecialConstructions();
            int ssz = specials.size();
            for (int si = 0; si < ssz; ++si) {
                if (specials.get((int)si).type != t) continue;
                chosenShips.add(specials.get(si));
            }
        }
        return chosenShips;
    }

    public ArrayList<ArrayList<Airship>> getDesigns(ShipType t) {
        switch (t) {
            case LANDSHIP: {
                this.loadDesigns(t, this.landshipNames, this.landships);
                return this.landships;
            }
            case BUILDING: {
                this.loadDesigns(t, this.buildingNames, this.buildings);
                return this.buildings;
            }
            case AIRSHIP: {
                this.loadDesigns(t, this.shipNames, this.ships);
                return this.ships;
            }
        }
        return this.ships;
    }

    private void loadDesigns(ShipType st, ArrayList<ArrayList<String>> names, ArrayList<ArrayList<Airship>> designs) {
        if (designs.isEmpty()) {
            for (ArrayList<String> tierNames : names) {
                ArrayList<Airship> tier = new ArrayList<Airship>();
                designs.add(tier);
                for (String cname : tierNames) {
                    try {
                        tier.add(this.getShip(st, cname));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("BAD " + cname);
                    }
                }
            }
        }
    }

    public final Airship getShip(ShipType st, String name) {
        ArrayList<Mod> ms = Mod.getEnabledMods();
        Collections.reverse(ms);
        for (Mod m : ms) {
            File shipF = new File(new File(m.dir, st.dirName), name + ".json");
            if (!shipF.exists()) continue;
            try {
                Airship s = new Airship(new JSONObject(FileUtils.readFileToString((File)shipF, (String)"UTF-8")));
                s.designName = name;
                return s;
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot load construction " + name + " from mod " + m.getName() + ".", e);
            }
        }
        File shipF = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), st.dirName), name + ".json");
        try {
            Airship s = new Airship(new JSONObject(FileUtils.readFileToString((File)shipF, (String)"UTF-8")));
            s.designName = name;
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot load construction " + name + ".", e);
        }
    }

    public static ConstructionStrategy ofName(String name) {
        return Loadable.ofName(ConstructionStrategy.class, name);
    }
}

