/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.DateSorter;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.ModuleCategory;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.NameSorter;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.UnknownDirectoryException;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public strictfp class ConstructionBackend
implements FileScreen.Backend {
    public ShipHelperWidget shw;
    private final ShipType st;
    private final File normalF;
    private final File ugcF;
    private final String prefix;
    public ArrayList<FileScreen.Sorter> sorters = new ArrayList();
    public ArrayList<FileScreen.SettableFilter> filters = new ArrayList();
    private BonusSet filterBonuses;

    public ConstructionBackend(ShipType st, ShipHelperWidget shw) {
        this.shw = shw;
        this.st = st;
        this.normalF = new File(AGame.getGameDirectory(), st.dirName);
        this.ugcF = new File(new File(AGame.getGameDirectory(), "steam"), "ugc");
        this.prefix = st.name() + "-";
        this.sorters.add(new NameSorter(this));
        this.sorters.add(new DateSorter(this));
        if (shw != null) {
            shw.backend = this;
            this.sorters.add(new CostSorter());
            this.updateFilters();
        }
    }

    @Override
    public String saveSuffix() {
        return ".json";
    }

    @Override
    public boolean canCreateDirs() {
        return true;
    }

    private boolean hasJSONFile(File dir) {
        File[] fs = dir.listFiles();
        if (fs != null) {
            for (File f : fs) {
                if (f.getName().startsWith(".") || !f.getName().endsWith(".json")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasFileWithPrefix(File dir) {
        File[] fs = dir.listFiles();
        if (fs != null) {
            for (File f : fs) {
                if (!f.getName().startsWith(this.prefix)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDirectory(List<String> path) {
        if (path.isEmpty()) {
            return true;
        }
        if (path.size() == 1 && path.get(0).contains(":")) {
            return true;
        }
        File f = this.getFile(path);
        return f != null && f.isDirectory();
    }

    @Override
    public File getFile(List<String> path) {
        File f;
        if (path == null) {
            return null;
        }
        if (path.isEmpty()) {
            return this.normalF;
        }
        if (path.get(0).equals("Steam:")) {
            f = this.ugcF;
        } else if (path.get(0).endsWith(":")) {
            String modID = path.get(0).substring(0, path.get(0).length() - 1);
            Mod inMod = null;
            for (Mod m : Mod.getEnabledMods()) {
                if (!m.id.equals(modID)) continue;
                inMod = m;
                break;
            }
            if (inMod == null) {
                return null;
            }
            f = new File(inMod.dir, "player" + this.st.dirName);
        } else {
            f = new File(this.normalF, path.get(0));
        }
        for (int i = 1; i < path.size(); ++i) {
            f = new File(f, path.get(i));
        }
        return f;
    }

    @Override
    public File getRawFile(List<String> path) {
        return this.getFile(path);
    }

    @Override
    public List<String> list(List<String> dirPath) {
        File[] fs;
        ArrayList<String> l = new ArrayList<String>();
        File listDir = this.normalF;
        if (dirPath.isEmpty()) {
            if (this.hasFileWithPrefix(this.ugcF)) {
                l.add("Steam:");
            }
            for (Mod m : Mod.getEnabledMods()) {
                if (!this.hasJSONFile(new File(m.dir, "player" + this.st.dirName))) continue;
                l.add(m.id + ":");
            }
        } else {
            if (dirPath.get(0).equals("Steam:")) {
                l.add("..");
                listDir = this.ugcF;
                if (dirPath.size() > 1) {
                    throw new UnknownDirectoryException(dirPath);
                }
                File[] fs2 = listDir.listFiles();
                if (fs2 != null) {
                    for (File f : fs2) {
                        if (!f.getName().startsWith(this.prefix)) continue;
                        l.add("Steam:/" + f.getName());
                    }
                }
                return l;
            }
            if (dirPath.get(0).endsWith(":")) {
                l.add("..");
                String modID = dirPath.get(0).substring(0, dirPath.get(0).length() - 1);
                Mod inMod = null;
                for (Mod m : Mod.getEnabledMods()) {
                    if (!m.id.equals(modID)) continue;
                    inMod = m;
                    break;
                }
                if (inMod == null) {
                    throw new UnknownDirectoryException(dirPath);
                }
                listDir = new File(inMod.dir, "player" + this.st.dirName);
            } else {
                l.add("..");
                listDir = new File(this.normalF, dirPath.get(0));
            }
        }
        for (int i = 1; i < dirPath.size(); ++i) {
            listDir = new File(listDir, dirPath.get(i));
        }
        if (!listDir.exists()) {
            throw new UnknownDirectoryException(dirPath);
        }
        String namePrefix = FileScreen.joinPath(dirPath);
        if (!namePrefix.isEmpty()) {
            namePrefix = namePrefix + "/";
        }
        if ((fs = listDir.listFiles()) != null) {
            for (File f : fs) {
                if (f.getName().startsWith(".") || !f.isDirectory() || f.getName().endsWith(".json")) continue;
                l.add(namePrefix + f.getName());
            }
            for (File f : fs) {
                if (f.getName().startsWith(".") || f.isDirectory() || !f.getName().endsWith(".json")) continue;
                l.add(namePrefix + f.getName());
            }
        }
        return l;
    }

    @Override
    public boolean isValidName(String name) {
        return !name.isEmpty() && AGame.makeFileSafe(name).equals(name);
    }

    @Override
    public boolean isLocked(List<String> path) {
        return !path.isEmpty() && path.get(0).contains(":");
    }

    @Override
    public void delete(List<String> path) {
        if (this.isLocked(path)) {
            return;
        }
        File f = this.getFile(path);
        if (f == null || !f.exists()) {
            return;
        }
        AGame.deleteDir(f);
    }

    @Override
    public ArrayList<FileScreen.Sorter> sorters() {
        return this.sorters;
    }

    private void updateFilters() {
        if (this.shw == null) {
            this.filters.clear();
            return;
        }
        if (this.filterBonuses == null || !this.filterBonuses.equals(this.shw.bonuses)) {
            this.filterBonuses = this.shw.bonuses.clone();
            this.filters.clear();
            HashSet<ModuleType> alreadyAdded = new HashSet<ModuleType>();
            for (ModuleCategory cat : Loadable.all(ModuleCategory.class)) {
                for (ModuleType mt : cat.getContents()) {
                    if (mt.hidden() || !mt.availableFor(this.st) || alreadyAdded.contains(mt) || mt.getRequired() != null && !this.shw.bonuses.contains[mt.getRequired().ordinal()] || mt.isFlipped()) continue;
                    this.filters.add(new ModuleTypeFilter(mt));
                    alreadyAdded.add(mt);
                }
            }
            for (ArmourType at : Loadable.all(ArmourType.class)) {
                if (at.name.equals("NONE") || at.hidden || at.required != null && !this.shw.bonuses.contains[at.required.ordinal()]) continue;
                this.filters.add(new ArmourTypeFilter(at));
            }
        }
    }

    @Override
    public ArrayList<FileScreen.SettableFilter> filters() {
        this.updateFilters();
        return this.filters;
    }

    strictfp class ArmourTypeFilter
    implements FileScreen.SettableFilter {
        final ArmourType type;

        public ArmourTypeFilter(ArmourType type) {
            this.type = type;
        }

        @Override
        public String getNameKey() {
            return "armour_" + this.type.name;
        }

        @Override
        public FileScreen.FilterCheckResult check(String name) {
            ShipHelperWidget.ShipInfo si = ConstructionBackend.this.shw.getInfo(name);
            if (si == null) {
                return FileScreen.FilterCheckResult.UNKNOWN;
            }
            if (!si.loadable) {
                return FileScreen.FilterCheckResult.NO;
            }
            return si.armourTypes.contains(this.type) ? FileScreen.FilterCheckResult.YES : FileScreen.FilterCheckResult.NO;
        }
    }

    strictfp class ModuleTypeFilter
    implements FileScreen.SettableFilter {
        final ModuleType type;

        public ModuleTypeFilter(ModuleType type) {
            this.type = type;
        }

        @Override
        public String getNameKey() {
            return "mod_" + this.type.name;
        }

        @Override
        public FileScreen.FilterCheckResult check(String name) {
            ShipHelperWidget.ShipInfo si = ConstructionBackend.this.shw.getInfo(name);
            if (si == null) {
                return FileScreen.FilterCheckResult.UNKNOWN;
            }
            if (!si.loadable) {
                return FileScreen.FilterCheckResult.NO;
            }
            return si.moduleTypes.contains(this.type) || si.moduleTypes.contains(this.type.getFlippedIfAvailable()) ? FileScreen.FilterCheckResult.YES : FileScreen.FilterCheckResult.NO;
        }
    }

    strictfp class CostSorter
    implements FileScreen.Sorter {
        int oldShwCacheSize = 0;

        CostSorter() {
        }

        @Override
        public String getNameKey() {
            return "Cost";
        }

        @Override
        public Comparator<String> ascending() {
            return new Asc();
        }

        @Override
        public Comparator<String> descending() {
            return new Desc();
        }

        @Override
        public boolean popUpdateNeeded() {
            int newCacheSize = ConstructionBackend.this.shw.cacheSize();
            int oldCacheSize = this.oldShwCacheSize;
            this.oldShwCacheSize = newCacheSize;
            return newCacheSize != oldCacheSize;
        }

        private strictfp class Desc
        implements Comparator<String> {
            private Desc() {
            }

            private int getCost(String name) {
                ShipHelperWidget.ShipInfo si = ConstructionBackend.this.shw.getInfo(name);
                return si == null || !si.loadable ? -1 : si.cost;
            }

            @Override
            public int compare(String o1, String o2) {
                int c1 = this.getCost(o1);
                int c2 = this.getCost(o2);
                if (c1 != -1) {
                    if (c2 != -1) {
                        return c2 - c1;
                    }
                    return -1;
                }
                if (c2 != -1) {
                    return 1;
                }
                return 0;
            }
        }

        private strictfp class Asc
        implements Comparator<String> {
            private Asc() {
            }

            private int getCost(String name) {
                ShipHelperWidget.ShipInfo si = ConstructionBackend.this.shw.getInfo(name);
                return si == null || !si.loadable ? -1 : si.cost;
            }

            @Override
            public int compare(String o1, String o2) {
                int c1 = this.getCost(o1);
                int c2 = this.getCost(o2);
                if (c1 != -1) {
                    if (c2 != -1) {
                        return c1 - c2;
                    }
                    return -1;
                }
                if (c2 != -1) {
                    return 1;
                }
                return 0;
            }
        }
    }
}

