/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.CampaignCombatIntent;
import com.zarkonnen.airships.ChallengeCombatIntent;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.CombatSpeed;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.MissionCombatIntent;
import com.zarkonnen.airships.MultiplayerCampaignCombatIntent;
import com.zarkonnen.airships.MultiplayerCombatIntent;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.SingleCombatIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;

public strictfp class CombatSpeedButton
extends UniScreen.Button {
    public final CombatSpeed sp;
    private final Img indicator = new Img("ui", 208, 512, 16, 16, false);

    public CombatSpeedButton(CombatSpeed sp) {
        this.sp = sp;
    }

    private boolean isMultiplayer(UniScreen us) {
        return us.intent instanceof MultiplayerCampaignCombatIntent || us.intent instanceof MultiplayerCombatIntent;
    }

    @Override
    public boolean visible(UniScreen us) {
        if (this.isMultiplayer(us) && !this.sp.isMPCapable()) {
            return false;
        }
        if (us.intent instanceof MultiplayerCampaignCombatIntent) {
            return !((MultiplayerCampaignCombatIntent)us.intent).spectate;
        }
        return (us.intent instanceof SingleCombatIntent || us.intent instanceof CampaignCombatIntent || us.intent instanceof MissionCombatIntent || us.intent instanceof MultiplayerCombatIntent || us.intent instanceof MultiplayerCampaignCombatIntent) && !(us.intent instanceof ChallengeCombatIntent);
    }

    @Override
    public void renderExtra(UniScreen us, MyDraw d, int x, int y, int w, int h) {
        if (us.combat == null || us.combat.speedVoters == null) {
            return;
        }
        if (us.combat.speed == this.sp) {
            d.blit(this.indicator, MyDraw.TITLE, x + w / 2 - this.indicator.srcWidth / 2, MyDraw.TOP_BAR_H);
        } else if (us.combat.speedVoters.containsValue((Object)this.sp)) {
            d.blit(this.indicator, MyDraw.WIN_SHADOW, x + w / 2 - this.indicator.srcWidth / 2, MyDraw.TOP_BAR_H);
        }
    }

    @Override
    public boolean isToggle() {
        return true;
    }

    @Override
    public boolean selected(UniScreen us) {
        if (us.combat.speedVoters == null) {
            return us.combat.speed == this.sp;
        }
        return us.combat.speedVoters.containsKey(us.g.playerID()) && us.combat.speedVoters.get(us.g.playerID()) == this.sp;
    }

    @Override
    public Img icon(UniScreen us) {
        return this.sp.icon;
    }

    @Override
    public String text(UniScreen us) {
        return "";
    }

    @Override
    public void click(Input in, UniScreen us) {
        if (us.combat.speed != CombatSpeed.STOP) {
            ((CombatIntent)us.intent).prevSpeed = us.combat.speed;
        }
        if (this.isMultiplayer(us)) {
            us.combat.giveCommand(Client.msg("setCombatSpeed").put("speed", this.sp.name()).put("voterID", us.g.playerID()));
        } else {
            us.combat.speed = this.sp;
        }
    }

    @Override
    public String hotkey(UniScreen us) {
        if (this.isMultiplayer(us)) {
            return null;
        }
        if (this.sp == CombatSpeed.STOP && us.combat.speed != CombatSpeed.STOP) {
            return Keys.get("combat_pause", "SPACE");
        }
        if (this.sp == ((CombatIntent)us.intent).prevSpeed && us.combat.speed == CombatSpeed.STOP) {
            return Keys.get("combat_pause", "SPACE");
        }
        return null;
    }
}

