/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.CampaignCombatIntent;
import com.zarkonnen.airships.CampaignCombatSetupIntent;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MultiplayerCampaignCombatIntent;
import com.zarkonnen.airships.MultiplayerCampaignCombatSetupIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;

public strictfp class CombatReserveButton
extends UniScreen.ShipButton {
    public int reserveTimeout = 0;
    public static final int RESERVE_INTERVAL = 5000;

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        this.reserveTimeout -= ms;
    }

    @Override
    public boolean visible(Airship ship, Combat.Side side, UniScreen us) {
        if (!(us.intent instanceof CampaignCombatIntent) && !(us.intent instanceof CampaignCombatSetupIntent) && !(us.intent instanceof MultiplayerCampaignCombatIntent) && !(us.intent instanceof MultiplayerCampaignCombatSetupIntent) || us.mySide != side) {
            return false;
        }
        if (!ship.type.mobile) {
            return false;
        }
        if (us.intent instanceof CampaignCombatIntent || us.intent instanceof MultiplayerCampaignCombatIntent) {
            if (us.mySide.ships.size() < 2) {
                return false;
            }
            if (us.combat.sides.indexOf(side) == 0) {
                return this.reserveTimeout <= 0 && ship.getX() <= -3100.0;
            }
            return this.reserveTimeout <= 0 && ship.getX() + ship.getBBWidth() >= 3100.0;
        }
        return true;
    }

    @Override
    public String text(Airship ship, Combat.Side side, UniScreen us) {
        return Lang._t("Reserve_noun", new Object[0]);
    }

    @Override
    public void click(Input in, Airship ship, Combat.Side side, UniScreen us) {
        this.reserveTimeout = 5000;
        if (us.intent instanceof MultiplayerCampaignCombatIntent || us.intent instanceof MultiplayerCampaignCombatSetupIntent) {
            us.combat.giveCommand(Client.msg("reserveShip").put("side", us.combat.sides.indexOf(us.mySide)).put("ship", ship.networkID));
        } else {
            side.ships.remove(ship);
            side.reserve.add(ship);
        }
    }
}

