/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.CombatAchievement;
import com.zarkonnen.airships.CombatSpeed;
import com.zarkonnen.airships.GenericProgress;
import com.zarkonnen.airships.InitCombatProcess;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.PerfReport;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.util.ArrayList;

public strictfp abstract class CombatIntent
implements UniScreen.Intent {
    public static final int TICK_LENGTH = 16;
    public CombatSpeed prevSpeed = CombatSpeed.NORMAL;
    public int time = 0;
    public int accumulatedTime = 0;
    public ArrayList<CombatAchievement> achievements;
    public PerfReport perfRep;
    public InitCombatProcess initCombatProcess;

    public boolean isBlocked() {
        return false;
    }

    public boolean spectate() {
        return false;
    }

    public boolean runInitProcess(UniScreen us) {
        if (this.initCombatProcess != null) {
            GenericProgress p = this.initCombatProcess.tick();
            if (!p.done) {
                us.genericProgress = p;
            } else {
                this.initCombatProcess = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (this.runInitProcess(us)) {
            return;
        }
        if (this.isBlocked()) {
            return;
        }
        if (this.achievements == null) {
            this.achievements = CombatAchievement.get();
        }
        if (this.achievements != null && us.mySide != null) {
            for (CombatAchievement a : this.achievements) {
                a.tick(us.combat, us.mySide);
            }
        }
        if (this.perfRep == null) {
            this.perfRep = new PerfReport(us.combat, in.mode());
        }
        this.combatTick(in, ms, us);
    }

    public void combatTick(Input in, int ms, UniScreen us) {
        for (int iter = 0; iter < us.combat.speed.mult; ++iter) {
            this.time += ms / us.combat.speed.div;
            this.accumulatedTime += ms / us.combat.speed.div;
            while (this.accumulatedTime >= 16 / us.combat.speed.div) {
                us.combat.tick(16 / us.combat.speed.div, us.mySide, us.getTimeOfDay().effect.lightning, us.combat.speed.mult);
                this.accumulatedTime -= 16 / us.combat.speed.div;
            }
        }
        if (us.combat.connectionLost()) {
            us.g.s = new MainMenu(us.g, MainMenu.Submenu.MULTIPLAYER);
        }
    }

    public void leave(UniScreen us) {
        us.g.reportPerformance(this.perfRep);
        this.doLeave(us);
    }

    public abstract void doLeave(UniScreen var1);

    @Override
    public boolean drawAsBlueprint() {
        return false;
    }

    @Override
    public boolean allowMultiSelect() {
        return true;
    }
}

