/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Achievement;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.ShipType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public strictfp abstract class CombatAchievement {
    public abstract void tick(Combat var1, Combat.Side var2);

    public static ArrayList<CombatAchievement> get() {
        ArrayList<CombatAchievement> l = new ArrayList<CombatAchievement>();
        l.add(new DestroyByRamming());
        l.add(new ForceDown());
        l.add(new RockLanding());
        l.add(new Capture());
        l.add(new EvadeBoarders());
        l.add(new Broadside());
        return l;
    }

    public strictfp static class Broadside
    extends CombatAchievement {
        public LinkedList<Integer> heavyCannonTimes = new LinkedList();
        public boolean running = !Achievement.isAchieved(Achievement.BROADSIDE);

        @Override
        public void tick(Combat c, Combat.Side mySide) {
            if (!this.running) {
                return;
            }
            int time = c.time;
            Iterator it = this.heavyCannonTimes.iterator();
            while (it.hasNext()) {
                if (time - (Integer)it.next() <= 512) continue;
                it.remove();
            }
            for (Airship ship : mySide.ships) {
                for (Module m : ship.modules) {
                    if (m.type != ModuleType.ofName("HV_CANNON") && m.type != ModuleType.ofName("FLIPPED_HV_CANNON") || !m.fired) continue;
                    this.heavyCannonTimes.add(time);
                }
            }
            if (this.heavyCannonTimes.size() >= 10) {
                Achievement.achieve(Achievement.BROADSIDE);
                this.running = false;
            }
        }
    }

    public strictfp static class EvadeBoarders
    extends CombatAchievement {
        public boolean running = !Achievement.isAchieved(Achievement.EVADE_BOARDERS);

        @Override
        public void tick(Combat c, Combat.Side mySide) {
            if (!this.running) {
                return;
            }
            Combat.Side enemy = c.otherSide(mySide);
            for (Crewman cm : enemy.troops) {
                if (cm.attachedTo != null || !cm.type.canBoard || cm.type.hasHook || cm.ultimateBoardTarget == null || !(cm.dy > 0.75)) continue;
                Achievement.achieve(Achievement.EVADE_BOARDERS);
                this.running = false;
                return;
            }
        }
    }

    public strictfp static class Capture
    extends CombatAchievement {
        public boolean running = !Achievement.isAchieved(Achievement.BOARDING);

        @Override
        public void tick(Combat c, Combat.Side mySide) {
            if (!this.running) {
                return;
            }
            for (Airship as : mySide.ships) {
                if (as.type != ShipType.AIRSHIP || !as.captured) continue;
                Achievement.achieve(Achievement.BOARDING);
                this.running = false;
                return;
            }
        }
    }

    public strictfp static class RockLanding
    extends CombatAchievement {
        public boolean running = !Achievement.isAchieved(Achievement.LAND_ROCK);

        @Override
        public void tick(Combat c, Combat.Side mySide) {
            if (!this.running) {
                return;
            }
            for (Airship as : mySide.ships) {
                if (as.type != ShipType.AIRSHIP || as.msSinceOnGround >= 64 || !as.collidedWithFloatingRock || as.msSuspendiumOff <= 1024) continue;
                Achievement.achieve(Achievement.LAND_ROCK);
                this.running = false;
                return;
            }
        }
    }

    public strictfp static class ForceDown
    extends CombatAchievement {
        public HashMap<Airship, Integer> collidedTimes = new HashMap();
        public boolean running = !Achievement.isAchieved(Achievement.FORCE_DOWN);

        @Override
        public void tick(Combat c, Combat.Side mySide) {
            if (!this.running) {
                return;
            }
            int time = c.time;
            Combat.Side enemy = c.otherSide(mySide);
            for (Airship enemyShip : enemy.ships) {
                if (enemyShip.type == ShipType.AIRSHIP) {
                    for (Airship collider : enemyShip.justCollidedWith) {
                        if (collider.type != ShipType.AIRSHIP || !mySide.ships.contains(collider) || !(collider.moveTo.y > collider.getY()) || !(collider.getY() + collider.getBBHeight() / 2.0 < enemyShip.getY())) continue;
                        this.collidedTimes.put(enemyShip, time);
                    }
                }
                enemyShip.justCollidedWith.clear();
                if (enemyShip.msSinceOnGround > 64 || !this.collidedTimes.containsKey(enemyShip) || time - this.collidedTimes.get(enemyShip) >= 256) continue;
                Achievement.achieve(Achievement.FORCE_DOWN);
                this.running = false;
                return;
            }
        }
    }

    public strictfp static class DestroyByRamming
    extends CombatAchievement {
        public static final int RAM_TO_DESTROY_MS = 256;
        public HashMap<Airship, Integer> rammedTimes = new HashMap();
        public boolean running = !Achievement.isAchieved(Achievement.RAMMING);

        @Override
        public void tick(Combat c, Combat.Side mySide) {
            if (!this.running) {
                return;
            }
            int time = c.time;
            Combat.Side enemy = c.otherSide(mySide);
            for (Airship airship : enemy.ships) {
                if (airship.type == ShipType.AIRSHIP) {
                    for (Airship rammer : airship.justRammedBy) {
                        if (rammer.type != ShipType.AIRSHIP || !mySide.ships.contains(rammer)) continue;
                        this.rammedTimes.put(airship, time);
                    }
                }
                airship.justRammedBy.clear();
            }
            for (Map.Entry entry : this.rammedTimes.entrySet()) {
                if (time - (Integer)entry.getValue() > 256 || enemy.ships.contains(entry.getKey()) || mySide.ships.contains(entry.getKey()) || enemy.reserve.contains(entry.getKey()) || mySide.reserve.contains(entry.getKey())) continue;
                Achievement.achieve(Achievement.RAMMING);
                this.running = false;
                return;
            }
        }
    }
}

