/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AIQuality;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Blast;
import com.zarkonnen.airships.BodyPathing;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.ChatMsg;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.CoatEditor;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.CombatBackgroundFlavor;
import com.zarkonnen.airships.CombatSound;
import com.zarkonnen.airships.CombatSpeed;
import com.zarkonnen.airships.Compression;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.ExceptionalCombatEvent;
import com.zarkonnen.airships.FireMode;
import com.zarkonnen.airships.Fragment;
import com.zarkonnen.airships.GenericChatMsg;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.HeraldicStyle;
import com.zarkonnen.airships.JSONAble;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Leg;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MiscCombatSound;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.Physics;
import com.zarkonnen.airships.PlayerInfo;
import com.zarkonnen.airships.Recording;
import com.zarkonnen.airships.Server;
import com.zarkonnen.airships.ShipList;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.Shot;
import com.zarkonnen.airships.SimplePref;
import com.zarkonnen.airships.SoundEffect;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.Trail;
import com.zarkonnen.airships.TroopPhysics;
import com.zarkonnen.airships.Wheel;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Utils;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class Combat
implements JSONAble,
ShipList {
    public static final int OUTER_ZONE_W = 400;
    public static final int COMBAT_AREA_W = 6400;
    public static final int COMBAT_AREA_H = 1600;
    public static final int EXCLUSION_ZONE_W = 200;
    public static final int RESERVE_ZONE_W = 100;
    public static final boolean RECORD_ENTIRE_COMBAT_STATE = false;
    public static final int MS_PER_RAID_SUCCESS = 50000;
    public static final int MAX_FRAGMENTS = 160;
    public static final int INITIAL_FRAG_LIFE_CUTOFF = 200000;
    public static final int HASH_EVERY = 1024;
    public static final int TICK_LENGTH = 16;
    public static final boolean DEBUG_SYNC = true;
    public static final int HISTORY_KEEP = 8000;
    public static final int INITIAL_QUEUE_SIZE = 5;
    public CombatBackgroundFlavor backgroundFlavor = CombatBackgroundFlavor.ofName("sea");
    public ArrayList<Side> sides = new ArrayList();
    public LinkedList<Shot> shots = new LinkedList();
    public LinkedList<Particle> particles = new LinkedList();
    public LinkedList<Fragment> fragments = new LinkedList();
    public ArrayList<LandFormation> landFormations = new ArrayList();
    public Random r = new Random();
    private boolean desyncConfirmed = false;
    private Client mpClient;
    private Server mpServer;
    private CampaignWorld campaignWorld;
    public long randomSeed;
    private HashMap<Side, PlayerInfo> sideToPlayer = new HashMap();
    private HashMap<PlayerInfo, Side> playerToSide = new HashMap();
    private HashMap<Integer, PlayerInfo> idToPlayer = new HashMap();
    private LinkedList<JSONObject> frameQueue = new LinkedList();
    private JSONObject baseState;
    private ArrayList<JSONObject> networkFrameHistory = new ArrayList();
    private HashMap<Integer, Integer> hashHistory = new HashMap(1000);
    private int ticksSinceLastFrame = 0;
    private boolean runSimAnyway = false;
    private int netTick = 0;
    public int simTick = 0;
    public transient ArrayList<GenericChatMsg> chatMessages = new ArrayList();
    private boolean initialQueueFilled = false;
    private CombatOutcome currentCombatOutcome = null;
    private int finishedCountdown = 8000;
    public boolean combatFinished = false;
    public transient int boringTicks = 0;
    private final AirshipGame g;
    public transient int time;
    public transient int pointsLimit;
    public transient Pt lightningPt;
    public transient int lightningAmt;
    public static final int LIGHTNING_P = 10000;
    public static final int LIGHTING_AMT = 90;
    public int msSinceShotFired = -10000;
    public transient boolean resetMoveTos = true;
    public transient ArrayList<String> musicChoice = null;
    public boolean hasInaccuracyMult = true;
    public boolean instantCommandRegeneration = false;
    public boolean isRaid = false;
    public int lootAmount = 0;
    public int maxLootAmount = 0;
    public int startCountdown = 0;
    public transient ArrayList<Blast> blasts = new ArrayList();
    public TimeOfDay timeOfDay;
    public transient boolean slowMotion = false;
    public transient CombatSpeed speed = CombatSpeed.NORMAL;
    public transient HashMap<Integer, CombatSpeed> speedVoters;
    public transient boolean hasHadFractionalSpeed = false;
    public Physics physics;
    public transient BodyPathing bodyPathing = new BodyPathing();
    public transient ArrayList<ExceptionalCombatEvent> exceptionalCombatEvents = new ArrayList();
    public ArrayList<CombatSound> sounds = new ArrayList();
    public ArrayList<Trail> trails = new ArrayList();
    public Recording recording = new Recording();
    public long frameMID;
    public JSONArray commandsExecutedInThisFrame = new JSONArray();
    public Recording playback = null;
    public int playbackIndex = 0;
    public transient HashSet plinkedArmoursAndModules = new HashSet();
    private static final MessageDigest MD5;
    public static final HashMap<String, CommandExecutor> EXECS;
    static boolean reportedDupe;
    private int localMsAccum = 0;
    private Side lastViewingSide;

    public void play(SoundEffect effect, double x, double y, double xSpeed, double ySpeed, boolean onViewingSide) {
        if (effect == null) {
            return;
        }
        this.sounds.add(new CombatSound(effect, x, y, xSpeed, ySpeed, 1.0, onViewingSide, null));
    }

    public void loop(String key, SoundEffect effect, double x, double y, double xSpeed, double ySpeed, boolean onViewingSide) {
        if (effect == null) {
            return;
        }
        this.sounds.add(new CombatSound(effect, x, y, xSpeed, ySpeed, 1.0, onViewingSide, key));
    }

    public void saveRecording() throws IOException {
        if (this.recording != null && this.recording.initialCombat != null) {
            this.recording.header.numTicks = this.recording.tickCommands.size();
            File dir = new File(AGame.getGameDirectory(), "recordings");
            dir.mkdirs();
            File f = new File(dir, System.currentTimeMillis() + ".json");
            FileUtils.write((File)f, (CharSequence)(this.recording.header.toJSON().toString() + "\n" + Compression.compressToString(this.recording.toJSON().toString())));
            ++MainMenu.newRecordings;
        }
    }

    public boolean waitingForNetworkMessages() {
        return this.isSingleMultiplayer() && this.initialQueueFilled && this.frameQueue.isEmpty();
    }

    public boolean connectionLost() {
        return this.mpClient != null && (this.mpClient.isDisconnected() || this.mpClient.connectionFailed());
    }

    private Utils.Pair<Long, JSONArray> getTickCommands(int serverTickMult) {
        if (this.mpClient != null) {
            JSONObject msg = this.g.pollMessage();
            if (msg != null && msg.getString("type").equals("frame")) {
                this.frameQueue.add(msg);
                this.networkFrameHistory.add(msg);
            }
            if (this.frameQueue.size() >= 5) {
                this.initialQueueFilled = true;
            }
            if (this.initialQueueFilled && this.isTimeMoving()) {
                if (this.netTick == 0) {
                    this.baseState = this.toJSON();
                }
                if (this.time != 0 && this.time % 1024 == 0 && !this.desyncConfirmed) {
                    int hash = this.cheapHash();
                    this.hashHistory.remove(this.time - 8000);
                    this.hashHistory.put(this.time, hash);
                    this.g.sendMessage(Client.msg("checksum").put("time", this.time).put("hash", hash));
                }
                ++this.ticksSinceLastFrame;
                ++this.netTick;
                if (this.ticksSinceLastFrame == 64 * serverTickMult / 16) {
                    this.startCountdown = StrictMath.max(0, this.startCountdown - 64);
                    this.ticksSinceLastFrame = 0;
                    JSONObject fr = this.frameQueue.pollFirst();
                    this.runSimAnyway = true;
                    return new Utils.Pair((Object)fr.optLong("###", -1L), (Object)fr.getJSONArray("messages"));
                }
            }
        } else if (this.playback != null && this.playbackIndex < this.playback.tickCommands.size()) {
            return this.playback.tickCommands.get(this.playbackIndex++);
        }
        return new Utils.Pair((Object)-1L, (Object)new JSONArray());
    }

    public boolean isTimeMoving() {
        return this.mpClient == null || this.initialQueueFilled && !this.frameQueue.isEmpty();
    }

    private long runTickCommands(int serverTickMult) {
        Utils.Pair<Long, JSONArray> e = this.getTickCommands(serverTickMult);
        JSONArray cs = (JSONArray)e.b;
        for (int i = 0; i < cs.length(); ++i) {
            this.execCommand(cs.getJSONObject(i));
        }
        return (Long)e.a;
    }

    public void giveCommand(JSONObject cmd) {
        if (this.mpClient != null || this.campaignWorld != null && this.campaignWorld.isMultiplayer()) {
            this.g.sendMessage(cmd);
        } else {
            this.execCommand(cmd);
        }
    }

    public void execCommand(JSONObject cmd) {
        if (!EXECS.containsKey(cmd.getString("type"))) {
            this.g.reportError("Unknown command: " + cmd.getString("type"), null, cmd.toString(), false, true);
            return;
        }
        if (this.recording != null) {
            this.commandsExecutedInThisFrame.put(cmd);
        }
        EXECS.get(cmd.getString("type")).run(cmd, this);
    }

    public GridBody getGridBody(JSONObject msg, String prefix) {
        int index;
        if (msg.has(prefix + "Ship")) {
            return this.getShip(msg.getJSONObject(prefix + "Ship"));
        }
        if (msg.has(prefix + "LF") && (index = msg.getInt(prefix + "LF")) >= 0 && index < this.landFormations.size()) {
            return this.landFormations.get(index);
        }
        return null;
    }

    public Airship getShip(JSONObject id) {
        if (id.has("netID")) {
            for (Side s : this.sides) {
                for (Airship ship : s.ships) {
                    if (!ship.networkID.equals(id.getString("netID"))) continue;
                    return ship;
                }
            }
        }
        if (id.has("side")) {
            System.err.println("old-style ship ID used!");
            int sideIndex = id.getInt("side");
            int shipIndex = id.getInt("ship");
            if (sideIndex < this.sides.size() && shipIndex < this.sides.get((int)sideIndex).ships.size()) {
                return this.sides.get((int)sideIndex).ships.get(shipIndex);
            }
        }
        return null;
    }

    public JSONObject getShipID(Airship ship) {
        if (ship.networkID.equals("[no network ID]")) {
            this.g.reportError("Ship has no network ID!", null, this.toString(), false, true);
        }
        return new JSONObject().put("netID", ship.networkID);
    }

    public boolean isFinished() {
        return this.combatFinished;
    }

    public boolean isBoring() {
        return this.boringTicks > 1000;
    }

    public void pruneTrappedShips(int sideIndex) {
        Iterator<Airship> it = this.sides.get((int)sideIndex).ships.iterator();
        while (it.hasNext()) {
            Airship sh = it.next();
            if (!sh.trapped()) continue;
            it.remove();
        }
    }

    public void pruneUselessShips() {
        for (Side s : this.sides) {
            Iterator<Airship> it = s.ships.iterator();
            while (it.hasNext()) {
                if (!it.next().useless()) continue;
                it.remove();
            }
        }
    }

    public void repairShips() {
        for (Side s : this.sides) {
            for (Airship ship : s.ships) {
                ship.repair();
            }
        }
    }

    public Side otherSide(Side side) {
        for (Side s : this.sides) {
            if (s == side) continue;
            return s;
        }
        return null;
    }

    @Override
    public int size() {
        int sz = 0;
        int ssz = this.sides.size();
        for (int si = 0; si < ssz; ++si) {
            sz += this.sides.get((int)si).ships.size();
        }
        return sz;
    }

    @Override
    public Airship get(int index) {
        int sideI = 0;
        while (index >= this.sides.get((int)sideI).ships.size()) {
            index -= this.sides.get((int)sideI).ships.size();
            ++sideI;
        }
        return this.sides.get((int)sideI).ships.get(index);
    }

    public void doSplashDmg(double x, double y, int blastDmg, int blastSplashRadius, Shot optionalSourceShot, Airship inside, Side immuneCrewSide) {
        int sisz = this.sides.size();
        for (int sii = 0; sii < sisz; ++sii) {
            Side side = this.sides.get(sii);
            int ssz = side.ships.size();
            for (int si = 0; si < ssz; ++si) {
                Airship ship = side.ships.get(si);
                ship.splashHit(this, x, y, blastDmg, blastSplashRadius, side == this.lastViewingSide, optionalSourceShot, ship == inside);
            }
            if (side == immuneCrewSide) continue;
            int tsz = side.troops.size();
            for (int ti = 0; ti < tsz; ++ti) {
                double d;
                int actualDamage;
                double ty;
                Crewman t = side.troops.get(ti);
                double tx = t.getX() + t.getBBWidth() / 2.0;
                double dSq = (x - tx) * (x - tx) + (y - (ty = t.getY() + t.getBBHeight() / 2.0)) * (y - ty);
                if (!(dSq < (double)(blastSplashRadius * blastSplashRadius)) || (actualDamage = (int)((double)blastDmg * ((double)blastSplashRadius - (d = StrictMath.sqrt(dSq))) / (double)blastSplashRadius)) == 0) continue;
                t.hurt(optionalSourceShot, actualDamage, this, side == this.lastViewingSide);
            }
        }
    }

    public double getInaccuracyMultiplier() {
        if (!this.hasInaccuracyMult) {
            return 1.0;
        }
        if (this.time < 3000) {
            return 2.0;
        }
        if (this.time < 6000) {
            return 1.5;
        }
        if (this.time < 9000) {
            return 1.2;
        }
        if (this.time > 240000) {
            return 0.3;
        }
        if (this.time > 120000) {
            return 0.7;
        }
        return 1.0;
    }

    private CombatOutcome outcome() {
        boolean[] nonLosers = new boolean[this.sides.size()];
        int numNonLosers = 0;
        for (int i = 0; i < nonLosers.length; ++i) {
            if (this.lost(this.sides.get(i))) continue;
            nonLosers[i] = true;
            ++numNonLosers;
        }
        return new CombatOutcome(nonLosers, numNonLosers <= 1);
    }

    public Side sideOf(Airship ship) {
        int ssz = this.sides.size();
        for (int si = 0; si < ssz; ++si) {
            Side side = this.sides.get(si);
            if (!side.ships.contains(ship) && !side.reserve.contains(ship)) continue;
            return side;
        }
        return null;
    }

    public boolean won(Side s) {
        if (s.lost()) {
            return false;
        }
        for (Side side : this.sides) {
            if (side == s || side.lost()) continue;
            return false;
        }
        return true;
    }

    public boolean lost(Side s) {
        return s.lost();
    }

    public Side getSideForID(int id) {
        return this.playerToSide.isEmpty() ? this.sides.get(id) : this.playerToSide.get(this.idToPlayer.get(id));
    }

    public int getIDForSide(Side side) {
        return this.sideToPlayer.isEmpty() ? this.sides.indexOf(side) : this.sideToPlayer.get((Object)side).id;
    }

    public void setRandomSeed(long seed) {
        this.randomSeed = seed;
        this.r = new Random(seed);
    }

    public Combat(AirshipGame g, Client client, Server server, long seed, ArrayList<PlayerInfo> pis, int pointsLimit, TimeOfDay timeOfDay, int techTier, boolean instantCommandRegeneration) {
        this.mpClient = client;
        this.mpServer = server;
        this.randomSeed = seed;
        this.r = new Random(seed);
        this.pointsLimit = pointsLimit;
        this.g = g;
        this.timeOfDay = timeOfDay;
        this.instantCommandRegeneration = instantCommandRegeneration;
        this.idToPlayer = new HashMap();
        for (PlayerInfo pi : pis) {
            this.idToPlayer.put(pi.id, pi);
            Side s = new Side(pi.name, false, Tech.getBonusesForTier(techTier));
            s.arms = pi.getArms();
            s.ships = pi.fleet;
            this.sides.add(s);
            this.sideToPlayer.put(s, pi);
            this.playerToSide.put(pi, s);
        }
        for (int i = 0; i < 4; ++i) {
            this.frameQueue.add(new JSONObject().put("messages", new JSONArray()).put("time", -1));
        }
    }

    public boolean isSingleMultiplayer() {
        return this.mpClient != null;
    }

    public boolean canAbandonShip(Airship ship) {
        if (!(ship.type.onGround || ship.lastGrounded != null && ship.msSinceOnGround <= 100)) {
            return false;
        }
        Side s = this.sideOf(ship);
        if (s == null) {
            return false;
        }
        for (Airship as : s.ships) {
            if (as == ship || !as.inCombat(this)) continue;
            return true;
        }
        return false;
    }

    public Combat(AirshipGame g, TimeOfDay timeOfDay) {
        Side you = new Side("You_player", true, Tech.getStandardBonuses());
        you.arms = CoatEditor.getMyStrategicArms();
        this.sides.add(you);
        this.sides.add(new Side("Enemy_player", true, Tech.getStandardBonuses()));
        this.g = g;
        this.timeOfDay = timeOfDay;
        this.randomSeed = AGame.ANIM_R.nextLong();
        this.r = new Random(this.randomSeed);
    }

    public Combat(AirshipGame g, TimeOfDay timeOfDay, Random r, CampaignWorld cw) {
        Side you = new Side("You_player", true, Tech.getStandardBonuses());
        you.arms = CoatEditor.getMyStrategicArms();
        this.sides.add(you);
        this.sides.add(new Side("Enemy_player", true, Tech.getStandardBonuses()));
        this.g = g;
        this.timeOfDay = timeOfDay;
        this.randomSeed = AGame.getSeed(r);
        this.r = r;
        this.campaignWorld = cw;
        this.instantCommandRegeneration = cw.map.strategicRapidCommands;
    }

    private void finish() {
        if (this.mpClient != null && this.mpClient == this.g.lanClient) {
            this.g.lanClient.close();
            this.g.lanClient = null;
        }
        if (this.mpServer != null) {
            this.mpServer.close();
            this.g.lanServer = null;
        }
    }

    private void checkSidesForDupes() {
        for (Side s : this.sides) {
            int si2;
            int count;
            Airship ship;
            int si;
            int ssz = s.ships.size();
            int rsz = s.reserve.size();
            for (si = 0; si < ssz; ++si) {
                ship = s.ships.get(si);
                count = 0;
                for (si2 = 0; si2 < ssz; ++si2) {
                    if (s.ships.get(si2) != ship) continue;
                    ++count;
                }
                for (si2 = 0; si2 < rsz; ++si2) {
                    if (s.reserve.get(si2) != ship) continue;
                    ++count;
                }
                if (count <= 1) continue;
                if (!reportedDupe) {
                    AirshipGame.instance.reportError("Duplicate in combat ships", null, null, false, true);
                    reportedDupe = true;
                }
                while (s.reserve.contains(ship)) {
                    s.reserve.remove(ship);
                }
                while (s.ships.contains(ship)) {
                    s.ships.remove(ship);
                }
                s.ships.add(ship);
            }
            ssz = s.ships.size();
            rsz = s.reserve.size();
            for (si = 0; si < rsz; ++si) {
                ship = s.reserve.get(si);
                count = 0;
                for (si2 = 0; si2 < ssz; ++si2) {
                    if (s.ships.get(si2) != ship) continue;
                    ++count;
                }
                for (si2 = 0; si2 < rsz; ++si2) {
                    if (s.reserve.get(si2) != ship) continue;
                    ++count;
                }
                if (count <= 1) continue;
                if (!reportedDupe) {
                    AirshipGame.instance.reportError("Duplicate in combat reserve", null, null, false, true);
                    reportedDupe = true;
                }
                while (s.reserve.contains(ship)) {
                    s.reserve.remove(ship);
                }
                while (s.ships.contains(ship)) {
                    s.ships.remove(ship);
                }
                s.reserve.add(ship);
            }
        }
    }

    public int cheapHash() {
        int h = 7;
        for (Side side : this.sides) {
            int ssz = side.ships.size();
            for (int si = 0; si < ssz; ++si) {
                h = h * 47 + side.ships.get(si).cheapHash();
            }
            int tsz = side.troops.size();
            for (int ti = 0; ti < tsz; ++ti) {
                h = h * 43 + side.troops.get(ti).cheapHash();
            }
        }
        for (Shot shot : this.shots) {
            h = h * 37 + new Double(shot.sX).hashCode();
            h = h * 37 + new Double(shot.sY).hashCode();
            h = h * 37 + new Double(shot.tX).hashCode();
            h = h * 37 + new Double(shot.tY).hashCode();
            h = h * 37 + shot.time;
        }
        for (LandFormation landFormation : this.landFormations) {
            h = h * 31 + new Double(landFormation.getX()).hashCode();
            h = h * 31 + new Double(landFormation.getY()).hashCode();
            h = h * 31 + new Double(landFormation.getxSpeed()).hashCode();
            h = h * 31 + new Double(landFormation.getySpeed()).hashCode();
            h = h * 31 + new Double(landFormation.getBBWidth()).hashCode();
            h = h * 31 + new Double(landFormation.getBBHeight()).hashCode();
        }
        return h;
    }

    public void repairAllShips() {
        for (Side side : this.sides) {
            for (Airship s : side.ships) {
                s.repair();
            }
            for (Airship s : side.reserve) {
                s.repair();
            }
        }
    }

    public void tick(int ms, Side viewingSide, boolean lightning, int serverTickMult) {
        if (this.recording != null && this.recording.initialCombat == null) {
            this.recording.initialCombat = this.toJSON();
            JSONArray mods = new JSONArray();
            for (Mod m : Mod.getEnabledMods()) {
                mods.put(new JSONObject().put("id", m.id).put("name", m.getName()));
            }
            this.recording.initialCombat.put("mods", mods);
            this.recording.header.extractSideInfo(this);
        }
        if (this.slowMotion || this.speed.div != 1) {
            this.hasHadFractionalSpeed = true;
        }
        this.lastViewingSide = viewingSide;
        if (this.slowMotion && !this.isSingleMultiplayer()) {
            ms /= 4;
        }
        if (this.isSingleMultiplayer()) {
            int fqsz = this.frameQueue.size();
            if (fqsz < 3) {
                ms /= 2;
            } else if (fqsz == 3) {
                ms = ms * 3 / 4;
            } else if (fqsz > 15) {
                ms *= 2;
            } else if (fqsz > 7) {
                ms = ms * 3 / 2;
            }
            this.localMsAccum += ms;
            if (this.localMsAccum >= 16) {
                this.localMsAccum -= 16;
                this.doTick(16, viewingSide, lightning, serverTickMult);
            }
            if (this.localMsAccum >= 16) {
                this.localMsAccum -= 16;
                this.doTick(16, viewingSide, lightning, serverTickMult);
            }
        } else {
            this.doTick(ms, viewingSide, lightning, serverTickMult);
        }
    }

    private void doTick(int ms, Side viewingSide, boolean lightning, int serverTickMult) {
        this.checkSidesForDupes();
        if (this.combatFinished) {
            return;
        }
        if (this.connectionLost()) {
            this.finish();
            return;
        }
        this.frameMID = this.runTickCommands(serverTickMult);
        if (!this.isTimeMoving() && !this.runSimAnyway || this.startCountdown > 0) {
            return;
        }
        this.doGenericTick(ms, viewingSide, lightning);
    }

    public void doGenericTick(int ms, Side viewingSide, boolean lightning) {
        Iterator<Blast> it = this.blasts.iterator();
        while (it.hasNext()) {
            if (!it.next().tick(ms)) continue;
            it.remove();
        }
        for (Side s : this.sides) {
            s.aiTick();
        }
        if (this.recording != null) {
            this.recording.tickCommands.add((Utils.Pair<Long, JSONArray>)new Utils.Pair((Object)this.frameMID, (Object)this.commandsExecutedInThisFrame));
            this.commandsExecutedInThisFrame = new JSONArray();
        }
        CombatOutcome co = this.outcome();
        if (co.done) {
            if (!co.equals(this.currentCombatOutcome)) {
                this.finishedCountdown = 5000;
            }
            this.currentCombatOutcome = co;
            this.finishedCountdown -= ms;
            if (this.finishedCountdown <= 0) {
                this.combatFinished = true;
                this.finish();
                return;
            }
        } else {
            this.finishedCountdown = 8000;
        }
        this.runSimAnyway = false;
        double wind = this.timeOfDay.effect.wind;
        if (this.recording != null && this.time % 1600 == 0 && !this.hasHadFractionalSpeed) {
            this.recording.tickHashes.put(this.time, this.cheapHash());
        }
        ++this.simTick;
        ++this.boringTicks;
        this.time += ms;
        this.msSinceShotFired += ms;
        if (this.physics == null) {
            this.physics = new Physics();
            this.physics.gravity = 0.001;
            for (LandFormation lf : this.landFormations) {
                this.physics.bodies.add(lf);
            }
        }
        for (Side s : this.sides) {
            for (Airship a : s.ships) {
                if (!a.removeMe() && !this.physics.bodies.contains(a)) {
                    this.physics.bodies.add(a);
                    for (Module m : a.modules) {
                        for (Leg l : m.legs) {
                            this.physics.bodies.add(l.foot);
                        }
                        for (Wheel w : m.wheels) {
                            this.physics.bodies.add(w.body);
                        }
                    }
                    if (this.resetMoveTos) {
                        a.moveTo = new Pt(a.getX(), a.getY());
                    }
                }
                int msz = a.modules.size();
                for (int mi = 0; mi < msz; ++mi) {
                    Module m = a.modules.get(mi);
                    if (m.type.createsExceptionalCombatEventAfterMs() != 0 && m.type.createsExceptionalCombatEventAfterMs() > this.time - ms && m.type.createsExceptionalCombatEventAfterMs() <= this.time) {
                        this.exceptionalCombatEvents.add(new ExceptionalCombatEvent("enemyHas " + m.type.name, this.otherSide(s), a.getX() + (double)(a.gridXToWorldX(m.x, m.type.getW()) * 16) + (double)(m.type.getW() * 16 / 2), a.getY() + (double)(m.y * 16) + (double)(m.type.getH() * 16 / 2), null, a));
                    }
                    int lsz = m.legs.size();
                    for (int li = 0; li < lsz; ++li) {
                        Leg l = m.legs.get(li);
                        if (m.hp <= 0) {
                            this.physics.bodies.remove(l.foot);
                            continue;
                        }
                        if (this.physics.bodies.contains(l.foot)) continue;
                        this.physics.bodies.add(l.foot);
                    }
                }
            }
            for (Airship a : s.reserve) {
                this.physics.bodies.remove(a);
                for (Module m : a.modules) {
                    for (Leg l : m.legs) {
                        this.physics.bodies.remove(l.foot);
                    }
                    for (Wheel w : m.wheels) {
                        this.physics.bodies.remove(w.body);
                    }
                }
            }
        }
        for (Side s : this.sides) {
            if (!s.originalComposition.isEmpty()) continue;
            s.originalComposition.addAll(s.ships);
            s.originalComposition.addAll(s.reserve);
            for (Airship a : s.ships) {
                for (Module m : a.modules) {
                    if (m.type.getReload(a.currentBonuses) <= 0) continue;
                    m.shootAccumulator = m.type.getReload(a.currentBonuses) / 2 + this.r.nextInt(m.type.getReload(a.currentBonuses)) / 2;
                }
            }
        }
        if (this.time >= 6000 && this.time - ms < 6000) {
            if (this.sides.get(0).getCost() > 4 * this.sides.get(1).getCost()) {
                this.exceptionalCombatEvents.add(new ExceptionalCombatEvent("mySideMuchStronger", this.sides.get(0), 0.0, 212.0, null, null));
                this.exceptionalCombatEvents.add(new ExceptionalCombatEvent("mySideMuchWeaker", this.sides.get(1), 0.0, 212.0, null, null));
            } else if (this.sides.get(1).getCost() > 4 * this.sides.get(0).getCost()) {
                this.exceptionalCombatEvents.add(new ExceptionalCombatEvent("mySideMuchStronger", this.sides.get(1), 0.0, 212.0, null, null));
                this.exceptionalCombatEvents.add(new ExceptionalCombatEvent("mySideMuchWeaker", this.sides.get(0), 0.0, 212.0, null, null));
            }
        }
        if (this.isRaid) {
            if (this.lost(this.sides.get(1))) {
                this.lootAmount = this.maxLootAmount;
            } else {
                this.lootAmount = 0;
                int amt = this.time / 50000;
                for (int vic = 1; amt >= vic && this.lootAmount < this.maxLootAmount; amt -= vic, ++vic) {
                    ++this.lootAmount;
                }
            }
        }
        this.physics.tick(ms, this);
        TroopPhysics.tick(ms, this, viewingSide);
        for (Side s : this.sides) {
            for (Airship ship : s.ships) {
                ship.precalcAIValues(this);
            }
        }
        for (Side s : this.sides) {
            boolean won = this.won(s);
            boolean lost = this.lost(s);
            s.checkForCombatEvents(this.otherSide(s), this, won, lost, this.physics);
            s.tick(ms, this, won, this.physics, s == viewingSide);
        }
        Iterator it2 = this.particles.iterator();
        while (it2.hasNext()) {
            if (!((Particle)it2.next()).tick(ms, wind, this)) continue;
            it2.remove();
        }
        it2 = this.fragments.iterator();
        while (it2.hasNext()) {
            if (!((Fragment)it2.next()).tick(ms, this)) continue;
            it2.remove();
        }
        int fragCutoff = 200000;
        while (this.fragments.size() > 160) {
            int i = 0;
            Iterator it3 = this.fragments.iterator();
            while (it3.hasNext()) {
                if (((Fragment)it3.next()).age <= fragCutoff || i++ % 4 != 0) continue;
                it3.remove();
            }
            fragCutoff /= 2;
        }
        ArrayList<LandFormation> newLandFormations = new ArrayList<LandFormation>();
        Iterator<Object> it4 = this.landFormations.iterator();
        while (it4.hasNext()) {
            LandFormation lf = it4.next();
            if (lf.tick(ms, this)) {
                it4.remove();
                continue;
            }
            ArrayList<LandFormation> nlfs = lf.splitIntoChunksIfNeeded();
            if (nlfs == null) continue;
            newLandFormations.addAll(nlfs);
        }
        for (LandFormation lf : newLandFormations) {
            this.landFormations.add(lf);
            this.physics.bodies.add(lf);
        }
        it4 = this.shots.iterator();
        while (it4.hasNext()) {
            Shot s = (Shot)((Object)it4.next());
            if (!s.tick(ms, this, this.sideOf(s.target) != viewingSide)) continue;
            it4.remove();
        }
        it4 = this.trails.iterator();
        while (it4.hasNext()) {
            if (!((Trail)it4.next()).tick(ms)) continue;
            it4.remove();
        }
        boolean snow = this.timeOfDay.effect.snow;
        for (LandFormation lf : this.landFormations) {
            for (int gy = 0; gy < lf.grid.length; ++gy) {
                for (int gx = 0; gx < lf.grid[gy].length; ++gx) {
                    int i;
                    double py;
                    double px;
                    Particle.Emitter em;
                    if (!lf.edge[gy][gx]) continue;
                    LandBlockType lbt = lf.grid[gy][gx];
                    if (lbt.particleEmitter != null && !snow) {
                        em = lbt.particleEmitter;
                        if (AGame.ANIM_R.nextDouble() < em.emitProbability * (double)ms) {
                            px = lf.getX() + (double)(gx * 16) + 8.0;
                            py = lf.getY() + (double)(gy * 16) + 8.0;
                            for (i = 0; i < em.numParticles; ++i) {
                                this.particles.add(new Particle(em.t, px, py));
                            }
                            if (em.soundEffect != null) {
                                this.play(em.soundEffect, px, py, lf.getxSpeed(), lf.getySpeed(), false);
                            }
                        }
                    }
                    if (lbt.snowParticleEmitter == null || !snow) continue;
                    em = lbt.snowParticleEmitter;
                    if (!(AGame.ANIM_R.nextDouble() < em.emitProbability * (double)ms)) continue;
                    px = lf.getX() + (double)(gx * 16) + 8.0;
                    py = lf.getY() + (double)(gy * 16) + 8.0;
                    for (i = 0; i < em.numParticles; ++i) {
                        this.particles.add(new Particle(em.t, px, py));
                    }
                    if (em.soundEffect == null) continue;
                    this.play(em.soundEffect, px, py, lf.getxSpeed(), lf.getySpeed(), false);
                }
            }
        }
        for (Side side : this.sides) {
            for (Airship ship : side.ships) {
                for (Module m : ship.getModules()) {
                    ArrayList<ModuleType.ModuleParticleEmitter> ems2 = m.getDamagedOrDestroyedEmitters();
                    if (ems2 != null) {
                        int ems2s = ems2.size();
                        for (int emi = 0; emi < ems2s; ++emi) {
                            int x;
                            ModuleType.ModuleParticleEmitter em = ems2.get(emi);
                            if (em.inside && ship.showingOutside) continue;
                            int n = x = ship.flipped ? ship.getWidth() - m.x : m.x;
                            if (!(AGame.ANIM_R.nextDouble() < em.emitProbability * (double)ms)) continue;
                            double px = (double)(x * 16 + ship.getIntX()) + (double)(ship.flipped ? -1 : 1) * em.x * 16.0;
                            double py = (double)(m.y * 16 + ship.getIntY()) + em.y * 16.0;
                            for (int i = 0; i < em.numParticles; ++i) {
                                this.particles.add(new Particle(em.t, px, py));
                            }
                            if (em.soundEffect == null) continue;
                            this.play(em.soundEffect, px, py, ship.getxSpeed(), ship.getySpeed(), side == viewingSide);
                        }
                    }
                    if (!m.running()) continue;
                    ArrayList<ModuleType.ModuleParticleEmitter> ems = m.getEmitters();
                    int emss = ems.size();
                    for (int emi = 0; emi < emss; ++emi) {
                        int x;
                        ModuleType.ModuleParticleEmitter em = ems.get(emi);
                        if (em.inside && ship.showingOutside) continue;
                        int n = x = ship.flipped ? ship.getWidth() - m.x : m.x;
                        if (!(AGame.ANIM_R.nextDouble() < em.emitProbability * (double)ms)) continue;
                        double px = (double)(x * 16 + ship.getIntX()) + (double)(ship.flipped ? -1 : 1) * em.x * 16.0;
                        double py = (double)(m.y * 16 + ship.getIntY()) + em.y * 16.0;
                        for (int i = 0; i < em.numParticles; ++i) {
                            this.particles.add(new Particle(em.t, px, py));
                        }
                        if (em.soundEffect == null) continue;
                        this.play(em.soundEffect, px, py, ship.getxSpeed(), ship.getySpeed(), side == viewingSide);
                    }
                    if (m.type.getReload(ship.currentBonuses) <= 0 || !m.fired || SimplePref.REDUCED_FLASHING.get() || !m.type.muzzleFlash(ship.currentBonuses)) continue;
                    int totalDmg = m.type.getBlastDmg(ship.currentBonuses) + m.type.getPenDmg(ship.currentBonuses) + m.type.getDirectDmg(ship.currentBonuses);
                    double scale = (double)totalDmg / 20.0;
                    Pt mz = m.currentMuzzle(totalDmg > 20 ? 1.5 : 1.1);
                    int parts = StrictMath.min(3, totalDmg / 30 + (AGame.ANIM_R.nextInt(20) == 0 ? 1 : 0));
                    for (int i = 0; i < parts; ++i) {
                        this.particles.add(new Particle(ParticleType.ofName("smoke"), mz.x, mz.y));
                    }
                    ParticleType pt = totalDmg > 20 ? ParticleType.ofName("muzzle") : ParticleType.ofName("muzzle_small");
                    this.particles.add(new Particle(pt, mz.x, mz.y));
                    if (pt != ParticleType.ofName("muzzle")) continue;
                    double phase = AGame.ANIM_R.nextDouble() * Math.PI * 2.0;
                    for (int i = 0; i < 6; ++i) {
                        this.particles.add(new Particle(ParticleType.ofName("muzzle_chunk"), mz.x, mz.y, StrictMath.cos(m.weaponAngle + 1.5707963267948966) * StrictMath.sin(Math.PI * 2 * (double)i / 6.0 + phase) + AGame.ANIM_R.nextDouble() * 0.1 - 0.05, StrictMath.sin(m.weaponAngle + 1.5707963267948966) * StrictMath.sin(Math.PI * 2 * (double)i / 6.0 + phase) + AGame.ANIM_R.nextDouble() * 0.1 - 0.05, scale));
                        int n = 4;
                        this.particles.add(new Particle(ParticleType.ofName("muzzle_chunk"), mz.x, mz.y, StrictMath.cos(m.weaponAngle) * (double)n, StrictMath.sin(m.weaponAngle) * (double)n, scale * 3.0 / (double)n));
                    }
                }
            }
        }
        for (Side side : this.sides) {
            ArrayList<Airship> ships = new ArrayList<Airship>(side.ships);
            for (Airship ship : ships) {
                if (!ship.shouldSwitchSides()) continue;
                this.exceptionalCombatEvents.add(new ExceptionalCombatEvent("enemyShipCaptured", this.otherSide(side), ship.getX() + ship.getBBWidth() / 2.0, ship.getY() + ship.getBBHeight() / 2.0, null, ship));
                this.exceptionalCombatEvents.add(new ExceptionalCombatEvent("myShipCaptured", side, ship.getX() + ship.getBBWidth() / 2.0, ship.getY() + ship.getBBHeight() / 2.0, null, ship));
                ship.switchSides();
                side.ships.remove(ship);
                this.otherSide((Side)side).ships.add(ship);
                if (this.otherSide((Side)side).usingAI) {
                    ship.ai = new TacticalAI(ship, this, this.otherSide(side), side);
                    ship.ai.doesSurrender = false;
                    continue;
                }
                ship.ai = null;
            }
        }
        if (lightning) {
            this.lightningAmt -= ms;
            if (this.lightningAmt <= 0 && this.r.nextInt(10000) == 0) {
                ArrayList<Airship> victims = new ArrayList<Airship>();
                for (Side s : this.sides) {
                    victims.addAll(s.ships);
                }
                int xPos = this.r.nextInt(6400) - 3200;
                Airship victim = null;
                double bestDist = 0.0;
                for (Airship ship : victims) {
                    double sx = ship.getX() + ship.getBBWidth() / 2.0;
                    double sy = ship.getY() + ship.getBBHeight() / 2.0;
                    double ly = -1988.0;
                    double d = (sx - (double)xPos) * (sx - (double)xPos) + (sy - ly) * (sy - ly);
                    if (victim != null && !(d < bestDist)) continue;
                    victim = ship;
                    bestDist = d;
                }
                if (victim != null) {
                    int vx = this.r.nextInt(victim.getWidth());
                    int vy = 0;
                    while (victim.tileAt(vx, vy) == null) {
                        ++vy;
                    }
                    this.lightningPt = new Pt(victim.getX() + (double)(vx * 16) + 8.0, victim.getY() + (double)(vy * 16) + 8.0);
                    this.lightningAmt = 90;
                    Tile t = victim.tileAt(vx, vy);
                    t.armour.hp = StrictMath.max(0, t.armour.hp - 20);
                    t.module.hp -= 30;
                    if (!SimplePref.REDUCED_FLASHING.get()) {
                        for (double ly = this.lightningPt.y; ly > -1988.0; ly -= (double)(20 + AGame.ANIM_R.nextInt(20))) {
                            this.particles.add(new Particle(ParticleType.ofName("lightning_flash"), this.lightningPt.x, ly));
                        }
                    }
                    t.module.fire += 12;
                    for (int dy = -1; dy < 2; ++dy) {
                        for (int dx = -1; dx < 2; ++dx) {
                            Tile t2;
                            if (dx == 0 && dy == 0 || (t2 = victim.tileAt(vx + dx, vy + dy)) == null) continue;
                            t2.armour.hp = StrictMath.max(0, t2.armour.hp - 20);
                            t2.module.hp -= 30;
                            t.module.fire += 6;
                        }
                    }
                    this.play(MiscCombatSound.LIGHTNING, this.lightningPt.x, this.lightningPt.y, 0.0, 0.0, false);
                }
            }
        }
    }

    public Combat(AirshipGame g, JSONObject o) {
        int i;
        if (o.has("backgroundFlavor")) {
            this.backgroundFlavor = CombatBackgroundFlavor.ofName(o.getString("backgroundFlavor").toLowerCase(Locale.ENGLISH));
        }
        if (o.has("currentCombatOutcome")) {
            this.currentCombatOutcome = new CombatOutcome(o.getJSONObject("currentCombatOutcome"));
        }
        this.hasInaccuracyMult = o.optBoolean("hasInaccuracyMult", true);
        this.finishedCountdown = o.optInt("finishedCountdown", 0);
        this.combatFinished = o.optBoolean("combatFinished", false);
        this.isRaid = o.optBoolean("isRaid", false);
        this.lootAmount = o.optInt("lootAmount", 0);
        this.maxLootAmount = o.optInt("maxLootAmount", 0);
        this.randomSeed = o.optLong("randomSeed", AGame.ANIM_R.nextLong());
        this.instantCommandRegeneration = o.optBoolean("instantCommandRegeneration", false);
        this.r = new Random(this.randomSeed);
        JSONArray a = o.getJSONArray("sides");
        for (i = 0; i < a.length(); ++i) {
            this.sides.add(new Side(a.getJSONObject(i)));
        }
        a = o.getJSONArray("shots");
        for (i = 0; i < a.length(); ++i) {
            this.shots.add(new Shot(a.getJSONObject(i), this));
        }
        this.timeOfDay = TimeOfDay.ofName(o.optString("timeOfDay", "DAY"));
        HashMap[] mappingRef = new HashMap[]{LandBlockType.getMapping(o)};
        a = o.getJSONArray("landFormations");
        for (int i2 = a.length() - 1; i2 >= 0; --i2) {
            this.landFormations.add(0, new LandFormation(a.getJSONObject(i2), mappingRef));
        }
        this.physics = new Physics();
        this.physics.gravity = 0.001;
        for (LandFormation lf : this.landFormations) {
            this.physics.bodies.add(lf);
        }
        for (Side s : this.sides) {
            for (Airship ship : s.ships) {
                if (!ship.removeMe()) {
                    this.physics.bodies.add(ship);
                    for (Module m : ship.modules) {
                        for (Leg l : m.legs) {
                            this.physics.bodies.add(l.foot);
                        }
                        for (Wheel w : m.wheels) {
                            this.physics.bodies.add(w.body);
                        }
                    }
                }
                for (Module m : ship.modules) {
                    for (Leg l : m.legs) {
                        if (m.hp <= 0) {
                            this.physics.bodies.remove(l.foot);
                            continue;
                        }
                        if (this.physics.bodies.contains(l.foot)) continue;
                        this.physics.bodies.add(l.foot);
                    }
                }
            }
        }
        a = o.getJSONArray("sides");
        for (int i3 = 0; i3 < a.length(); ++i3) {
            this.sides.get(i3).finish(a.getJSONObject(i3), this);
        }
        this.g = g;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.put("netVersion", 101301);
        o.put("time", this.time);
        o.put("timeOfDay", this.timeOfDay.name);
        o.put("finishedCountdown", this.finishedCountdown);
        o.put("combatFinished", this.combatFinished);
        o.put("isRaid", this.isRaid);
        o.put("lootAmount", this.lootAmount);
        o.put("maxLootAmount", this.maxLootAmount);
        o.put("randomSeed", this.randomSeed);
        o.put("hasInaccuracyMult", this.hasInaccuracyMult);
        o.put("instantCommandRegeneration", this.instantCommandRegeneration);
        if (this.currentCombatOutcome != null) {
            o.put("currentCombatOutcome", this.currentCombatOutcome.toJSON());
        }
        JSONArray a = new JSONArray();
        o.put("sides", a);
        for (Side side : this.sides) {
            a.put(side.toJSON(this));
        }
        a = new JSONArray();
        o.put("shots", a);
        for (Shot shot : this.shots) {
            a.put(shot.toJSON(this));
        }
        a = new JSONArray();
        o.put("landFormations", a);
        for (LandFormation landFormation : this.landFormations) {
            a.put(landFormation.toJSON());
        }
        LandBlockType.writeMapping(o);
        return o;
    }

    public boolean canPlace(Airship ship, List<Airship> others, int x, int y, int spacing) {
        int w = ship.getWidth() * 16;
        int h = ship.getHeight() * 16;
        if (x + w > 3200 || x < -3200) {
            return false;
        }
        int ceiling = 512 - ship.serviceCeiling();
        if (!ship.type.onGround && y < ceiling) {
            return false;
        }
        for (Airship s2 : others) {
            int x2 = s2.getIntX();
            int y2 = s2.getIntY();
            int w2 = s2.getWidth() * 16;
            int h2 = s2.getHeight() * 16;
            if (x2 + w2 + spacing <= x || x + w + spacing <= x2 || y2 + h2 + spacing <= y || y + h + spacing <= y2) continue;
            return false;
        }
        double ox = ship.getX();
        double oy = ship.getY();
        ship.setX(x);
        ship.setY(y);
        for (LandFormation lf : this.landFormations) {
            if (!ship.overlapsWith(lf, false)) continue;
            ship.setX(ox);
            ship.setY(oy);
            return false;
        }
        ship.setX(ox);
        ship.setY(oy);
        return true;
    }

    public void initWheelsLegsTentaclesAndBarrels() {
        for (Side side : this.sides) {
            for (Airship s : side.ships) {
                s.initWheelsLegsAndTentacles(null, this.landFormations, this);
                s.resetWeaponBarrels();
            }
        }
    }

    public Combat clone(AirshipGame g) {
        return new Combat(g, this.toJSON());
    }

    static {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        MD5 = md;
        EXECS = new HashMap();
        EXECS.put("ping", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
            }
        });
        EXECS.put("globalChat", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
            }
        });
        EXECS.put("createGame", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
            }
        });
        EXECS.put("surrender", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                c.sides.get((int)cmd.getInt((String)"side")).surrendered = true;
            }
        });
        EXECS.put("checksum", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                int hash = cmd.getInt("hash");
                int time = cmd.getInt("time");
                if (!c.desyncConfirmed && c.hashHistory.containsKey(time) && !((Integer)c.hashHistory.get(time)).equals(hash)) {
                    String info = "New checksum error at #" + time + "\n" + c.hashHistory.get(time) + " vs " + hash;
                    if (c.recording != null) {
                        c.recording.header.placeName = info;
                        info = c.recording.header.toJSON().toString() + "\n" + Compression.compressToString(c.recording.toJSON().toString());
                    }
                    c.desyncConfirmed = true;
                    c.g.reportError(Lang._t("network_diverge_warning", new Object[0]), null, info, false);
                }
            }
        });
        EXECS.put("focusOnShooting", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.focusOnShooting = true;
                ship.focusOnRepair = false;
                ship.focusOnFirefighting = false;
                ship.focusOnMoving = false;
                ship.commandGiven();
            }
        });
        EXECS.put("focusOnFirefighting", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.focusOnShooting = false;
                ship.focusOnRepair = false;
                ship.focusOnFirefighting = true;
                ship.focusOnMoving = false;
                ship.commandGiven();
            }
        });
        EXECS.put("focusOnRepair", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.focusOnShooting = false;
                ship.focusOnRepair = true;
                ship.focusOnFirefighting = false;
                ship.focusOnMoving = false;
                ship.commandGiven();
            }
        });
        EXECS.put("focusOnMoving", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.focusOnShooting = false;
                ship.focusOnRepair = false;
                ship.focusOnFirefighting = false;
                ship.focusOnMoving = true;
                ship.commandGiven();
            }
        });
        EXECS.put("fireMode", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.fireMode = FireMode.valueOf(cmd.getString("value"));
                ship.fireOrderSpoken = false;
                ship.commandGiven();
            }
        });
        EXECS.put("ground", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.groundShip();
                ship.commandGiven();
            }
        });
        EXECS.put("abandon", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.abandonShip(c);
                ship.commandGiven();
            }
        });
        EXECS.put("moveTo", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.moveTo = new Pt(cmd.getDouble("x"), cmd.getDouble("y"));
                ship.flipTo = cmd.getBoolean("flipTo");
                ship.ramming = false;
                ship.grounding = false;
                ship.sitting = false;
                ship.moveMode = Airship.MoveMode.valueOf(cmd.optString("moveMode", Airship.MoveMode.DEFAULT.name()));
                ship.commandGiven();
            }
        });
        EXECS.put("ram", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.moveTo = new Pt(cmd.getDouble("x"), cmd.getDouble("y"));
                ship.flipTo = cmd.getBoolean("flipTo");
                ship.ramming = true;
                ship.grounding = false;
                ship.ramOrderSpoken = false;
                ship.sitting = false;
                ship.moveMode = Airship.MoveMode.valueOf(cmd.optString("moveMode", Airship.MoveMode.DEFAULT.name()));
                ship.commandGiven();
            }
        });
        EXECS.put("fireAt", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                if (c.getShip(cmd.getJSONObject("target")) == null) {
                    return;
                }
                ship.fireAt = c.getShip(cmd.getJSONObject("target"));
                ship.commandGiven();
            }
        });
        EXECS.put("board", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                Airship target = c.getShip(cmd.getJSONObject("target"));
                if (target == null || !target.canBeBoarded()) {
                    return;
                }
                ship.board = target;
                ship.commandGiven();
            }
        });
        EXECS.put("tetherAt", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                if (c.getShip(cmd.getJSONObject("target")) == null) {
                    return;
                }
                ship.tetherAt = c.getShip(cmd.getJSONObject("target"));
                ship.commandGiven();
            }
        });
        EXECS.put("cutOwnTethers", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.tetherAt = null;
                for (Module m : ship.modules) {
                    m.tether = null;
                }
                ship.commandGiven();
            }
        });
        EXECS.put("chat", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                PlayerInfo pi = (PlayerInfo)c.idToPlayer.get(cmd.getInt("id"));
                if (pi != null) {
                    c.chatMessages.add(new ChatMsg(pi, cmd.getString("text"), DateTime.now()));
                }
            }
        });
        EXECS.put("moveTroops", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Side side = c.sides.get(cmd.getInt("side"));
                GridBody source = c.getGridBody(cmd, "source");
                GridBody target = c.getGridBody(cmd, "target");
                if (source == null || target == null) {
                    return;
                }
                boolean shouted = false;
                for (Crewman cm : side.troops) {
                    if (cm.attachedTo != source) continue;
                    cm.ultimateBoardTarget = target;
                    cm.proximateBoardTarget = null;
                    cm.hookLaunched = false;
                    cm.walkToGR = null;
                    cm.walkToTargetGR = null;
                    if (shouted) continue;
                    cm.doShout(cm.pickShout("troopMove"));
                    shouted = true;
                }
            }
        });
        EXECS.put("setCombatSpeed", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                CombatSpeed cs = CombatSpeed.valueOf(cmd.getString("speed"));
                if (cs.isMPCapable()) {
                    if (c.speedVoters != null) {
                        c.speedVoters.put(cmd.getInt("voterID"), cs);
                        c.speed = CombatSpeed.VERY_FAST;
                        for (CombatSpeed csv : c.speedVoters.values()) {
                            if (csv.mult >= c.speed.mult) continue;
                            c.speed = csv;
                        }
                    } else {
                        c.speed = cs;
                    }
                }
            }
        });
        EXECS.put("placeShip", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Side side = c.sides.get(cmd.getInt("side"));
                Airship ship = side.getShip(cmd.getString("ship"));
                if (ship != null) {
                    if (side.reserve.contains(ship)) {
                        side.reserve.remove(ship);
                        side.ships.add(ship);
                    }
                    ship.setX(cmd.getDouble("x"));
                    ship.setY(cmd.getDouble("y"));
                    ship.moveTo = new Pt(ship.getX(), ship.getY());
                    ship.setFlipped(cmd.getBoolean("flipped"), c);
                    ship.flipTo = cmd.getBoolean("flipped");
                    ship.lastPlaced = new Pt(ship.getX(), ship.getY());
                    ship.lastPlacedFlipped = ship.flipped;
                    ship.resetWeaponBarrels();
                    ship.resetTentaclesForFlipped();
                }
            }
        });
        EXECS.put("reserveShip", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Side side = c.sides.get(cmd.getInt("side"));
                Airship ship = side.getShip(cmd.getString("ship"));
                if (ship != null && side.ships.contains(ship)) {
                    side.ships.remove(ship);
                    side.reserve.add(ship);
                }
            }
        });
        reportedDupe = false;
    }

    public strictfp static class Side {
        private String name;
        private boolean nameIsTranslationKey;
        public CoatOfArms arms = CoatOfArms.getRandom(AGame.ANIM_R, HeraldicStyle.ofName("city"));
        public ArrayList<Airship> ships = new ArrayList();
        public ArrayList<Airship> reserve = new ArrayList();
        public ArrayList<Crewman> troops = new ArrayList();
        public transient ArrayList<Airship> originalComposition = new ArrayList();
        public BonusSet bonuses = Tech.getStandardBonuses();
        public boolean surrendered = false;
        public boolean fledInSetup = false;
        public boolean usingAI = false;
        public AIQuality aiQuality = AIQuality.NORMAL;
        public transient boolean biggestShipDeclared = false;
        public transient HashSet<CrewType> outsideCrewWeaponFiredVsShip = new HashSet();
        public transient HashSet<CrewType> outsideCrewWeaponFiredVsCrew = new HashSet();
        public transient HashSet<CrewType> outsideCrewCrashing = new HashSet();
        public int smartCMIndex = 0;

        public boolean lost() {
            if (this.surrendered) {
                return true;
            }
            int ssz = this.ships.size();
            for (int si = 0; si < ssz; ++si) {
                Airship ship = this.ships.get(si);
                if (ship.outOfCombatMs >= 2000) continue;
                return false;
            }
            return true;
        }

        public Side(String name, boolean nameIsTranslationKey, BonusSet bonuses) {
            this.name = name;
            this.nameIsTranslationKey = nameIsTranslationKey;
            this.bonuses = bonuses;
        }

        public void aiTick() {
            for (Airship s : new ArrayList<Airship>(this.ships)) {
                if (s.ai == null) continue;
                s.ai.tick();
            }
        }

        public void tick(int ms, Combat c, boolean won, Physics ph, boolean onViewingSide) {
            boolean lost = this.lost();
            for (Airship s : new ArrayList<Airship>(this.ships)) {
                if (!s.tick(ms, c, won, lost, onViewingSide)) continue;
                this.ships.remove(s);
                ph.bodies.remove(s);
            }
            ++this.smartCMIndex;
            if (this.smartCMIndex > 10000) {
                this.smartCMIndex = 0;
            }
            int tsz = this.troops.size();
            for (int i = 0; i < tsz; ++i) {
                this.troops.get((int)i).isSmart = this.smartCMIndex % tsz == i;
            }
            for (Crewman cm : new ArrayList<Crewman>(this.troops)) {
                if (!cm.outsideTick(ms, c, this, onViewingSide)) continue;
                this.troops.remove(cm);
            }
            if (!this.biggestShipDeclared) {
                ArrayList<Airship> s2 = new ArrayList<Airship>();
                for (Airship s : this.ships) {
                    if (!s.type.mobile) continue;
                    s2.add(s);
                }
                Collections.sort(s2, new Comparator<Airship>(){

                    @Override
                    public int compare(Airship t, Airship t1) {
                        return t1.getCost() - t.getCost();
                    }
                });
                if (s2.size() > 2 && ((Airship)s2.get(0)).getCost() > 2 * ((Airship)s2.get(1)).getCost()) {
                    ((Airship)s2.get((int)0)).biggestInFleet = true;
                }
                this.biggestShipDeclared = true;
            }
        }

        public Side(JSONObject o) {
            int i;
            this.name = o.getString("name");
            this.nameIsTranslationKey = o.optBoolean("nameIsTranslationKey", false);
            this.surrendered = o.getBoolean("surrendered");
            this.fledInSetup = o.optBoolean("fledInSetup", false);
            this.arms = new CoatOfArms(o.getJSONObject("arms"));
            this.smartCMIndex = o.optInt("smartCMIndex", 0);
            JSONArray a = o.getJSONArray("ships");
            for (i = 0; i < a.length(); ++i) {
                this.ships.add(new Airship(a.getJSONObject(i)));
            }
            a = o.optJSONArray("reserve");
            if (a != null) {
                for (i = 0; i < a.length(); ++i) {
                    this.reserve.add(new Airship(a.getJSONObject(i)));
                }
            }
            this.usingAI = o.optBoolean("usingAI", false);
            this.aiQuality = o.has("aiQuality") ? AIQuality.valueOf(o.getString("aiQuality")) : AIQuality.NORMAL;
            a = o.optJSONArray("troops");
            if (a != null) {
                for (i = 0; i < a.length(); ++i) {
                    this.troops.add(new Crewman(a.getJSONObject(i), null, null));
                }
            }
            if (o.has("bonuses")) {
                this.bonuses = new BonusSet();
                a = o.getJSONArray("bonuses");
                for (i = 0; i < a.length(); ++i) {
                    this.bonuses.add(Bonus.ofNameOrNone(a.getString(i)));
                }
            }
        }

        public void finish(JSONObject o, Combat c) {
            int i;
            JSONArray a = o.getJSONArray("ships");
            for (i = 0; i < a.length(); ++i) {
                this.ships.get(i).finish(a.getJSONObject(i), c);
            }
            a = o.optJSONArray("reserve");
            if (a != null) {
                for (i = 0; i < a.length(); ++i) {
                    this.reserve.get(i).finish(a.getJSONObject(i), c);
                }
            }
            if ((a = o.optJSONArray("troops")) != null) {
                for (i = 0; i < a.length(); ++i) {
                    this.troops.get(i).finishLoading(a.getJSONObject(i), c);
                }
            }
        }

        public JSONObject toJSON(Combat c) {
            JSONObject o = new JSONObject().put("name", this.name).put("nameIsTranslationKey", this.nameIsTranslationKey).put("surrendered", this.surrendered).put("fledInSetup", this.fledInSetup).put("usingAI", this.usingAI).put("aiQuality", this.aiQuality.name()).put("hasLost", false).put("smartCMIndex", this.smartCMIndex).put("arms", this.arms.toJSON());
            JSONArray a = new JSONArray();
            o.put("ships", a);
            for (Airship s : this.ships) {
                a.put(s.toJSON(c));
            }
            a = new JSONArray();
            o.put("reserve", a);
            for (Airship s : this.reserve) {
                a.put(s.toJSON(c));
            }
            a = new JSONArray();
            o.put("troops", a);
            for (Crewman cm : this.troops) {
                a.put(cm.toJSON(c));
            }
            a = new JSONArray();
            o.put("bonuses", a);
            for (Bonus b : this.bonuses.list()) {
                a.put(b.name());
            }
            return o;
        }

        public Airship getShip(String networkID) {
            for (Airship s : this.ships) {
                if (!s.networkID.equals(networkID)) continue;
                return s;
            }
            for (Airship s : this.reserve) {
                if (!s.networkID.equals(networkID)) continue;
                return s;
            }
            return null;
        }

        public int getCost() {
            int c = 0;
            int al = this.ships.size();
            for (int ai = 0; ai < al; ++ai) {
                c += this.ships.get(ai).getCost();
            }
            return c;
        }

        public int getCachedDanger() {
            int d = 0;
            int al = this.ships.size();
            for (int ai = 0; ai < al; ++ai) {
                d = (int)((double)d + this.ships.get((int)ai).dangerCache);
            }
            return d;
        }

        public void layoutShips(Combat c, boolean flipped) {
            int y;
            int x;
            this.ships.addAll(this.reserve);
            this.reserve.clear();
            for (Airship s : this.ships) {
                if (!s.type.mobile) continue;
                s.setX(-10000.0);
                s.setY(-10000.0);
            }
            ArrayList<Airship> prePlaced = new ArrayList<Airship>();
            block1: for (Airship s : this.ships) {
                if (s.lastPlaced == null) continue;
                x = (int)s.lastPlaced.x;
                y = (int)s.lastPlaced.y;
                if (flipped && x < 100 || !flipped && x > -100) continue;
                if (s.type.onGround) {
                    y = c.landFormations.get(0).getVerticalPosition(s, x, s.lastPlacedFlipped, false) - (int)s.groundOffset();
                    for (Airship s2 : this.ships) {
                        if (s == s2 || !s2.type.onGround || !((double)x + s.getBBWidth() >= s2.getX()) || !(s2.getX() + s2.getBBWidth() >= (double)x)) continue;
                        continue block1;
                    }
                }
                if (!c.canPlace(s, this.ships, x, y, 1)) continue;
                s.setX(x);
                s.setY(y);
                s.setFlipped(s.lastPlacedFlipped, c);
                s.initWheelsLegsAndTentacles(null, c.landFormations, c);
                prePlaced.add(s);
            }
            Iterator<Airship> it = this.ships.iterator();
            block3: while (it.hasNext()) {
                Airship s;
                s = it.next();
                if (prePlaced.contains(s) || !s.type.mobile) continue;
                s.setFlipped(flipped, c);
                s.flipTo = flipped;
                if (s.type.onGround) {
                    int n = x = flipped ? 100 : -100 - s.getWidth() * 16;
                    while (flipped ? x < 2800 : x > -2800) {
                        block16: {
                            if (s.type.onGround) {
                                y = c.landFormations.get(0).getVerticalPosition(s, x, flipped, false) - (int)s.groundOffset();
                                for (Airship s2 : this.ships) {
                                    if (s == s2 || !s2.type.onGround || !((double)x + s.getBBWidth() >= s2.getX()) || !(s2.getX() + s2.getBBWidth() >= (double)x)) continue;
                                    break block16;
                                }
                                if (c.canPlace(s, this.ships, x, y, 20)) {
                                    if (s.lastPlaced == null) {
                                        s.lastPlaced = new Pt((double)x, (double)y);
                                        s.lastPlacedFlipped = s.flipped;
                                    }
                                    s.setX(x);
                                    s.setY(y);
                                    s.initWheelsLegsAndTentacles(null, c.landFormations, c);
                                    continue block3;
                                }
                            }
                        }
                        x += flipped ? 80 : -80;
                    }
                } else {
                    for (int y2 = -1088; y2 < 512; y2 += 40) {
                        int x2;
                        int n = x2 = flipped ? 100 : -100 - s.getWidth() * 16;
                        while (flipped ? x2 < 2800 : x2 > -2800) {
                            if (c.canPlace(s, this.ships, x2, y2, 20)) {
                                if (s.lastPlaced == null) {
                                    s.lastPlaced = new Pt((double)x2, (double)y2);
                                    s.lastPlacedFlipped = s.flipped;
                                }
                                s.setX(x2);
                                s.setY(y2);
                                s.initWheelsLegsAndTentacles(null, c.landFormations, c);
                                continue block3;
                            }
                            x2 += flipped ? 80 : -80;
                        }
                    }
                }
                this.reserve.add(s);
                it.remove();
            }
        }

        private void checkForCombatEvents(Side otherSide, Combat c, boolean won, boolean lost, Physics physics) {
            int i;
            int nEnemiesLookingIntoSun;
            if (won) {
                c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("victory", this, 0.0, 212.0, null, null));
            }
            if (lost) {
                c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("defeat", this, 0.0, 212.0, null, null));
            }
            if (c.timeOfDay.effect.fog & c.time > 2000) {
                int nMyShipsAboveFog = 0;
                int nMyShips = 0;
                for (int i2 = 0; i2 < this.ships.size(); ++i2) {
                    Airship s = this.ships.get(i2);
                    if (s.type != ShipType.AIRSHIP) continue;
                    ++nMyShips;
                    if (!(s.getY() + s.getBBHeight() * 0.75 < 112.0)) continue;
                    ++nMyShipsAboveFog;
                }
                int nEnemiesBelowFog = 0;
                for (int i3 = 0; i3 < otherSide.ships.size(); ++i3) {
                    Airship s = otherSide.ships.get(i3);
                    if (!(s.getY() > 112.0)) continue;
                    ++nEnemiesBelowFog;
                }
                if (nMyShipsAboveFog > nMyShips / 2 && nEnemiesBelowFog > otherSide.ships.size() / 2) {
                    c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("enemyBelowFog", this, 0.0, 312.0, null, null));
                }
            }
            if (c.timeOfDay.effect.shootToLeftJitterMult > 1.0 && c.time > 3000) {
                nEnemiesLookingIntoSun = 0;
                for (i = 0; i < otherSide.ships.size(); ++i) {
                    Airship s = otherSide.ships.get(i);
                    if (s.type == ShipType.BUILDING || !s.flipped) continue;
                    ++nEnemiesLookingIntoSun;
                }
                if (nEnemiesLookingIntoSun > otherSide.ships.size() / 2) {
                    c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("enemyLookingIntoSun", this, 0.0, 112.0, null, null));
                }
            }
            if (c.timeOfDay.effect.shootToRightJitterMult > 1.0 && c.time > 3000) {
                nEnemiesLookingIntoSun = 0;
                for (i = 0; i < otherSide.ships.size(); ++i) {
                    Airship s = otherSide.ships.get(i);
                    if (s.type == ShipType.BUILDING || s.flipped) continue;
                    ++nEnemiesLookingIntoSun;
                }
                if (nEnemiesLookingIntoSun > otherSide.ships.size() / 2) {
                    c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("enemyLookingIntoSun", this, 0.0, 112.0, null, null));
                }
            }
        }

        public String getName() {
            return this.nameIsTranslationKey ? Lang._t(this.name, new Object[0]) : this.name;
        }

        public void setName(String name, boolean nameIsTranslationKey) {
            this.name = name;
            this.nameIsTranslationKey = nameIsTranslationKey;
        }
    }

    private strictfp static final class CombatOutcome {
        boolean[] sideNotLost;
        boolean done;

        public CombatOutcome(boolean[] sideNotLost, boolean done) {
            this.sideNotLost = sideNotLost;
            this.done = done;
        }

        public CombatOutcome(JSONObject o) {
            this.done = o.getBoolean("done");
            JSONArray a = o.getJSONArray("sideNotLost");
            this.sideNotLost = new boolean[a.length()];
            for (int i = 0; i < a.length(); ++i) {
                this.sideNotLost[i] = a.getBoolean(i);
            }
        }

        public JSONObject toJSON() {
            JSONObject o = new JSONObject().put("done", this.done);
            JSONArray a = new JSONArray();
            for (boolean b : this.sideNotLost) {
                a.put(b);
            }
            o.put("sideNotLost", a);
            return o;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CombatOutcome)) {
                return false;
            }
            CombatOutcome co2 = (CombatOutcome)o;
            if (this.done != co2.done || this.sideNotLost.length != co2.sideNotLost.length) {
                return false;
            }
            for (int i = 0; i < this.sideNotLost.length; ++i) {
                if (this.sideNotLost[i] == co2.sideNotLost[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int c = this.done ? 1 : 0;
            int n = 2;
            for (boolean snl : this.sideNotLost) {
                if (snl) {
                    c += n;
                }
                n *= 2;
            }
            return c;
        }
    }

    private static interface CommandExecutor {
        public void run(JSONObject var1, Combat var2);
    }
}

