/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Achievement;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.Charge;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.GameSetupScreen;
import com.zarkonnen.airships.HeraldicStyle;
import com.zarkonnen.airships.IntegrationBackend;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MissionSequence;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.airships.StrategicLobbyScreen;
import com.zarkonnen.airships.Tincture;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import org.json.JSONObject;

public strictfp class CoatEditor
implements Screen {
    public static final Clr BG = Clr.fromHex((String)"7b421b").mix(0.3, Clr.BLACK);
    public CoatOfArms coa = CoatOfArms.getRandom(AGame.ANIM_R, HeraldicStyle.ofName("player"));
    public AirshipGame g;
    public GameSetupScreen gss;
    public StrategicLobbyScreen sls;
    public boolean editRegisteredCOA;
    public boolean waitingForRegistration;
    public HashSet<CoatOfArms> checking = new HashSet();
    public HashMap<CoatOfArms, Boolean> free = new HashMap();
    public MissionSequence.Mission mission;
    public int armsIndex;
    public UniScreen prevUS;
    public final ScrollBar layoutScrollBar = new ScrollBar();
    public final IntRect layoutScrollBarR = new IntRect();
    public final ScrollBar[] chargeScrollBars = new ScrollBar[]{new ScrollBar(), new ScrollBar(), new ScrollBar(), new ScrollBar()};
    public final IntRect[] chargeScrollBarRs = new IntRect[]{new IntRect(), new IntRect(), new IntRect(), new IntRect()};
    public final boolean[] chargeScrollBarsScrollTo = new boolean[]{true, true, true, true};
    public boolean layoutScrollBarScrollTo = true;
    public CoatOfArms.TinctureSlot hoverSlot = null;
    private static JSONObject randomlyAssignedSessionStrategicArms;
    private final LayoutAdapter layoutAdapter = new LayoutAdapter();
    private final ChargeAdapter[] chargeAdapters = new ChargeAdapter[]{new ChargeAdapter(0), new ChargeAdapter(1), new ChargeAdapter(2), new ChargeAdapter(3)};
    private final Comparator<Charge> chargeSorter = new Comparator<Charge>(){

        @Override
        public int compare(Charge t, Charge t1) {
            if (t.bonus == Bonus.ofName("NO_BONUS") && t.tech == null && (t1.bonus != Bonus.ofName("NO_BONUS") || t1.tech != null)) {
                return 1;
            }
            if (t1.bonus == Bonus.ofName("NO_BONUS") && t1.tech == null && (t.bonus != Bonus.ofName("NO_BONUS") || t.tech != null)) {
                return -1;
            }
            return t.getPlural().compareTo(t1.getPlural());
        }
    };
    public static int COLOR_SWATCH_SIZE;
    public static int SMALL_COLOR_SWATCH_SIZE;
    public static int MEDIUM_COLOR_SWATCH_SIZE;
    public static int LARGE_COLOR_SWATCH_SIZE;

    public CoatEditor(AirshipGame g, boolean editRegisteredCOA) {
        this.g = g;
        this.editRegisteredCOA = editRegisteredCOA;
        this.coa = (editRegisteredCOA ? g.getBestCOA() : CoatEditor.getMyStrategicArms()).copy();
    }

    public CoatEditor(AirshipGame g, GameSetupScreen gss) {
        this.g = g;
        this.gss = gss;
        this.coa = gss.empireCOA;
    }

    public CoatEditor(AirshipGame g, StrategicLobbyScreen sls) {
        this.g = g;
        this.sls = sls;
        this.coa = new CoatOfArms(sls.armsJSON);
    }

    public CoatEditor(AirshipGame g, MissionSequence.Mission mission, int armsIndex, UniScreen us) {
        this.g = g;
        this.mission = mission;
        this.armsIndex = armsIndex;
        this.coa = mission.sideArms[armsIndex];
        this.prevUS = us;
    }

    public static CoatOfArms getMyStrategicArms() {
        try {
            return new CoatOfArms(new JSONObject(AirshipGame.PREFS.get("strategicCoatOfArms", "")));
        }
        catch (Exception e) {
            if (randomlyAssignedSessionStrategicArms == null) {
                randomlyAssignedSessionStrategicArms = CoatOfArms.getRandom(AGame.ANIM_R, HeraldicStyle.ofName("player")).toJSON();
            }
            try {
                return new CoatOfArms(randomlyAssignedSessionStrategicArms);
            }
            catch (Exception e2) {
                randomlyAssignedSessionStrategicArms = CoatOfArms.getRandom(AGame.ANIM_R, HeraldicStyle.ofName("player")).toJSON();
                return new CoatOfArms(randomlyAssignedSessionStrategicArms);
            }
        }
    }

    private void save() {
        try {
            AirshipGame.PREFS.put(this.editRegisteredCOA ? "strategicCoatOfArms" : "coatOfArms", this.coa.toJSON().toString());
            AirshipGame.PREFS.flush();
        }
        catch (Exception e) {
            this.g.reportError(Lang._t("Unable_to_store_prefs", new Object[0]), e, null, false);
        }
    }

    private void vary() {
        if (this.coa.layout.charges == 0) {
            this.coa = CoatOfArms.getRandom(AGame.ANIM_R, HeraldicStyle.ofName("player"));
            return;
        }
        switch (AGame.ANIM_R.nextInt(3)) {
            case 0: {
                int ci = AGame.ANIM_R.nextInt(this.coa.layout.charges);
                this.coa.setCharge(HeraldicStyle.ofName((String)"player").charges.get(AGame.ANIM_R.nextInt(HeraldicStyle.ofName((String)"player").charges.size())), ci);
                this.chargeScrollBarsScrollTo[ci] = true;
                break;
            }
            case 1: {
                this.coa.setTincture(Tincture.values().get(AGame.ANIM_R.nextInt(Tincture.values().size())), CoatOfArms.TinctureSlot.tinctureOf(AGame.ANIM_R.nextInt(this.coa.layout.tinctures)));
                break;
            }
            case 2: {
                this.coa.setTincture(Tincture.values().get(AGame.ANIM_R.nextInt(Tincture.values().size())), CoatOfArms.TinctureSlot.chargeTOf(AGame.ANIM_R.nextInt(this.coa.layout.charges)));
                break;
            }
            case 3: {
                this.coa.setLayout(HeraldicStyle.ofName((String)"player").layouts.get(AGame.ANIM_R.nextInt(HeraldicStyle.ofName((String)"player").layouts.size())));
                this.layoutScrollBarScrollTo = true;
                for (int i = 0; i < this.coa.layout.charges; ++i) {
                    this.chargeScrollBarsScrollTo[i] = true;
                }
                break;
            }
        }
    }

    private void quit() {
        if (this.sls != null) {
            this.sls.armsJSON = this.coa.toJSON();
            this.g.s = this.sls;
            this.sls.sendEmpireNameAndArmsUpdate();
        } else if (this.mission != null) {
            this.mission.sideArms[this.armsIndex] = this.coa;
            this.mission.combat.sides.get((int)this.armsIndex).arms = this.coa;
            this.g.s = this.prevUS;
        } else if (this.gss == null) {
            this.save();
            this.g.s = new MainMenu(this.g, MainMenu.Submenu.MAIN);
        } else {
            this.gss.empireCOA = this.coa;
            this.gss.empireNameField.reset();
            this.g.s = this.gss;
        }
    }

    private void registerCOA() {
        this.waitingForRegistration = true;
        if (SteamBackend.isEnabled()) {
            this.g.integration.backend.steamSetArms("" + SteamBackend.getUserID(), this.coa, new SteamArmsCB());
        } else {
            this.g.integration.backend.setArms(this.g.integration.username, this.g.integration.password, this.coa, new SACB());
        }
    }

    private Status coaTakenStatus() {
        if (this.coa.equals(this.g.integration.getRegisteredCOAIfAvailable())) {
            return Status.YOURS;
        }
        if (this.waitingForRegistration) {
            return Status.REGISTERING;
        }
        if (this.free.containsKey(this.coa)) {
            return this.free.get(this.coa) != false ? Status.FREE : Status.TAKEN;
        }
        if (this.checking.contains(this.coa)) {
            return Status.CHECKING;
        }
        this.checking.add(this.coa.copy());
        this.g.integration.backend.checkArmsAvailable(this.coa, new CAAC(this.coa.copy()));
        return Status.CHECKING;
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.waitingForRegistration) {
            return;
        }
        ScreenMode sm = in.mode();
        int armsSize = (sm.height - 320) / 32 * 32;
        int armsWinSize = armsSize + MyDraw.WINDOW_INSET * 2;
        this.layoutScrollBar.tick(in, this.layoutScrollBarR.x, this.layoutScrollBarR.y, this.layoutScrollBarR.w, this.layoutScrollBarR.h);
        for (int i = 0; i < this.coa.layout.charges; ++i) {
            this.chargeScrollBars[i].tick(in, this.chargeScrollBarRs[i].x, this.chargeScrollBarRs[i].y, this.chargeScrollBarRs[i].w, this.chargeScrollBarRs[i].h);
        }
        if (this.editRegisteredCOA && this.coaTakenStatus().canRegister && in.keyPressed(Keys.get("register_arms", "R"))) {
            this.registerCOA();
            drawState.hasClicked();
            return;
        }
        if (in.keyPressed(Keys.get("leave", "L")) || in.keyPressed("ESCAPE")) {
            drawState.hasClicked();
            this.quit();
            return;
        }
        if (in.keyPressed(Keys.get("random_arms", "A"))) {
            this.coa = CoatOfArms.getRandom(AGame.ANIM_R, HeraldicStyle.ofName("player"));
            drawState.hasClicked();
        }
        if (in.keyPressed(Keys.get("variation_arms", "V"))) {
            this.vary();
            drawState.hasClicked();
        }
    }

    public int colorPickerH() {
        return COLOR_SWATCH_SIZE + MyDraw.PANEL_INSET * 2;
    }

    public void renderColorPicker(final MyDraw d, int x, int y, int w, Pt cursor, final CoatOfArms.TinctureSlot slot) {
        int h = this.colorPickerH();
        d.drawPanel(x, y, w, h);
        x += MyDraw.PANEL_INSET;
        y += MyDraw.PANEL_INSET;
        for (final Tincture t : Tincture.values()) {
            int sx = x + t.ordinal() * (COLOR_SWATCH_SIZE + MyDraw.BUTTON_SPACING);
            int sy = y;
            int ssz = COLOR_SWATCH_SIZE;
            if (this.coa.getTincture(slot) == t) {
                sx -= MyDraw.BUTTON_SPACING / 2;
                sy -= MyDraw.BUTTON_SPACING / 2;
                ssz += MyDraw.BUTTON_SPACING;
            }
            d.rect(t.tint, sx, sy, ssz, ssz);
            d.hook(sx, sy, ssz, ssz, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    if (d.state.canClick() && !CoatEditor.this.waitingForRegistration) {
                        CoatEditor.this.coa.setTincture(t, slot);
                    }
                }
            });
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        int bw;
        d.hook(0.0, 0.0, sm.width, sm.height, new Hook(new Hook.Type[]{Hook.Type.HOVER}){

            public void run(Input in, Pt p, Hook.Type type) {
                CoatEditor.this.hoverSlot = null;
            }
        });
        d.drawBG(MyDraw.SCREEN_BG, sm);
        int armsSize = (sm.height - 320) / 32 * 32;
        int armsWinSize = armsSize + MyDraw.WINDOW_INSET * 2;
        int x = sm.width / 2 - armsWinSize / 2;
        int y = sm.height / 2 - armsWinSize / 2;
        d.drawWindow(x, y, armsWinSize, armsWinSize);
        this.coa.draw(d, x + MyDraw.WINDOW_INSET, y + MyDraw.WINDOW_INSET, armsSize, this.hoverSlot);
        d.text(this.editRegisteredCOA || this.mission != null ? this.coa.blazon() + "\n" + Lang._t(this.editRegisteredCOA ? "no_reg_coa_effect" : "no_coa_effect", new Object[0]) : this.coa.blazon() + "\n" + this.coa.getBonusOrTechDesc(), AGame.BIG_FOUNT, x, y + armsWinSize + MyDraw.UI_SPACING - 4, armsWinSize);
        x = MyDraw.SIDE_CLEARANCE;
        y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        int w = (sm.width - armsWinSize) / 2 - MyDraw.UI_SPACING * 2;
        int h = sm.height - y - MyDraw.SIDE_CLEARANCE;
        int layoutH = h - (this.colorPickerH() + MyDraw.SCROLL_EL_SPACING) * this.coa.layout.tinctures;
        if (this.layoutScrollBarScrollTo) {
            this.layoutScrollBar.scrollTo(false, d, x, y, w, layoutH, HeraldicStyle.ofName((String)"player").layouts, this.layoutAdapter, this.coa.layout);
            this.layoutScrollBarScrollTo = false;
        }
        this.layoutScrollBar.draw(d, x, y, w, layoutH, HeraldicStyle.ofName((String)"player").layouts, this.layoutAdapter);
        this.layoutScrollBarR.x = x;
        this.layoutScrollBarR.y = y;
        this.layoutScrollBarR.w = w;
        this.layoutScrollBarR.h = layoutH;
        int leftY = y + layoutH + MyDraw.SCROLL_EL_SPACING;
        for (int i = 0; i < this.coa.layout.tinctures; ++i) {
            final int index = i;
            d.hook(x, leftY, w, this.colorPickerH(), new Hook(new Hook.Type[]{Hook.Type.HOVER}){

                public void run(Input in, Pt p, Hook.Type type) {
                    CoatEditor.this.hoverSlot = CoatOfArms.TinctureSlot.values()[index];
                }
            });
            this.renderColorPicker(d, x, leftY, w, cursor, CoatOfArms.TinctureSlot.tinctureOf(i));
            leftY += this.colorPickerH() + MyDraw.SCROLL_EL_SPACING;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(HeraldicStyle.ofName((String)"player").charges);
        Collections.sort(l, this.chargeSorter);
        if (this.g.isIntegrated() && this.g.integration.specialCharge != null) {
            l.add(0, this.g.integration.specialCharge);
        }
        int chargeSegmentH = this.coa.layout.charges == 0 ? 0 : (h - MyDraw.UI_SPACING * (this.coa.layout.charges - 1)) / this.coa.layout.charges;
        int rightY = y;
        int rightX = sm.width - w - MyDraw.SIDE_CLEARANCE;
        for (int i = 0; i < this.coa.layout.charges; ++i) {
            final int index = i;
            d.hook(rightX, rightY, w, chargeSegmentH, new Hook(new Hook.Type[]{Hook.Type.HOVER}){

                public void run(Input in, Pt p, Hook.Type type) {
                    CoatEditor.this.hoverSlot = CoatOfArms.TinctureSlot.values()[index + 4];
                }
            });
            int scrollBarH = chargeSegmentH - this.colorPickerH() - MyDraw.SCROLL_EL_SPACING;
            if (this.chargeScrollBarsScrollTo[i]) {
                this.chargeScrollBars[i].scrollTo(false, d, rightX, rightY, w, scrollBarH, l, this.chargeAdapters[i], this.coa.charge[i]);
                this.chargeScrollBarsScrollTo[i] = false;
            }
            this.chargeScrollBars[i].draw(d, rightX, rightY, w, scrollBarH, l, this.chargeAdapters[i]);
            this.chargeScrollBarRs[i].x = rightX;
            this.chargeScrollBarRs[i].y = rightY;
            this.chargeScrollBarRs[i].w = w;
            this.chargeScrollBarRs[i].h = scrollBarH;
            this.renderColorPicker(d, rightX, rightY += scrollBarH + MyDraw.SCROLL_EL_SPACING, w, cursor, CoatOfArms.TinctureSlot.chargeTOf(i));
            rightY += this.colorPickerH() + MyDraw.UI_SPACING;
        }
        d.drawTopBar(sm);
        x = sm.width - MyDraw.SIDE_CLEARANCE;
        if (this.editRegisteredCOA) {
            bw = d.bw(Lang._t("Register", new Object[0]));
            d.text(Lang._t("coa_status_" + this.coaTakenStatus().name(), new Object[0]), AGame.BIG_FOUNT, MyDraw.SIDE_CLEARANCE, MyDraw.SIDE_CLEARANCE + 2);
            d.button(x - bw, MyDraw.TOP_BAR_INSET, bw, Lang._t("Register", new Object[0]), Keys.get("register_arms", "R"), new Runnable(){

                @Override
                public void run() {
                    CoatEditor.this.registerCOA();
                }
            }, this.coaTakenStatus().canRegister && !this.waitingForRegistration);
            x -= bw + MyDraw.BUTTON_SPACING;
            bw = d.bw(Lang._t("Leave", new Object[0]));
            d.button(x - bw, MyDraw.TOP_BAR_INSET, bw, Lang._t("Leave", new Object[0]), Keys.get("leave", "L"), new Runnable(){

                @Override
                public void run() {
                    CoatEditor.this.quit();
                }
            }, !this.waitingForRegistration);
            x -= bw + MyDraw.BUTTON_SPACING;
        } else {
            bw = d.bw(Lang._t("Leave", new Object[0]));
            d.button(x - bw, MyDraw.TOP_BAR_INSET, bw, Lang._t("Leave", new Object[0]), Keys.get("leave", "L"), new Runnable(){

                @Override
                public void run() {
                    CoatEditor.this.quit();
                }
            });
            x -= bw + MyDraw.BUTTON_SPACING;
        }
        bw = d.bw(Lang._t("Random", new Object[0]));
        d.button(x - bw, MyDraw.TOP_BAR_INSET, bw, Lang._t("Random", new Object[0]), Keys.get("random_arms", "A"), new Runnable(){

            @Override
            public void run() {
                CoatEditor.this.coa = CoatOfArms.getRandom(AGame.ANIM_R, HeraldicStyle.ofName("player"));
                for (int i = 0; i < CoatEditor.this.chargeScrollBarsScrollTo.length; ++i) {
                    CoatEditor.this.chargeScrollBarsScrollTo[i] = true;
                }
                CoatEditor.this.layoutScrollBarScrollTo = true;
            }
        }, !this.waitingForRegistration);
        x -= bw + MyDraw.BUTTON_SPACING;
        bw = d.bw(Lang._t("Variation", new Object[0]));
        d.button(x - bw, MyDraw.TOP_BAR_INSET, bw, Lang._t("Variation", new Object[0]), Keys.get("variation_arms", "V"), new Runnable(){

            @Override
            public void run() {
                CoatEditor.this.vary();
            }
        }, !this.waitingForRegistration);
        x -= bw + MyDraw.BUTTON_SPACING;
    }

    @Override
    public ArrayList<String> music() {
        return AGame.MENU_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return "DAY";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    static {
        COLOR_SWATCH_SIZE = 16;
        SMALL_COLOR_SWATCH_SIZE = 16;
        MEDIUM_COLOR_SWATCH_SIZE = 24;
        LARGE_COLOR_SWATCH_SIZE = 32;
    }

    private strictfp class ChargeAdapter
    implements ScrollBar.ScrollElementAdapter<Object> {
        public final int chargeIndex;

        public ChargeAdapter(int chargeIndex) {
            this.chargeIndex = chargeIndex;
        }

        @Override
        public int getHeight(Object ch, MyDraw d, int availableWidth) {
            String txt = null;
            if (ch instanceof String) {
                txt = ((String)ch).split("_")[0];
            } else {
                Charge c = (Charge)ch;
                txt = c.getName() + "\n" + c.getBonusOrTechDesc();
            }
            return StrictMath.max(16, (int)d.textSize((String)txt, (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)(availableWidth - 16 - MyDraw.SCROLL_EL_SPACING)).height) + MyDraw.SCROLL_EL_SPACING;
        }

        @Override
        public void draw(Object ch, final MyDraw d, int x, int y, int width) {
            int height = this.getHeight(ch, d, width);
            int textW = width - 16 - MyDraw.SCROLL_EL_SPACING;
            if (ch instanceof String) {
                final String specialCharge = (String)ch;
                d.drawSpecialCharge(specialCharge, Clr.WHITE, x, y, 16.0, 16.0);
                String txt = specialCharge.split("_")[0];
                if (CoatEditor.this.coa.charge[this.chargeIndex] == null && specialCharge.equals(CoatEditor.this.coa.specialCharge[this.chargeIndex])) {
                    d.text(MyDraw.SELECTED_C + txt, AGame.FOUNT, x + 16 + MyDraw.SCROLL_EL_SPACING, y, textW);
                } else {
                    d.text(txt, AGame.FOUNT, x + 16 + MyDraw.SCROLL_EL_SPACING, y, textW);
                    d.hook(x, y, width, height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                        public void run(Input in, Pt p, Hook.Type type) {
                            if (d.state.canClick() && !CoatEditor.this.waitingForRegistration) {
                                CoatEditor.this.coa.setSpecialCharge(specialCharge, ChargeAdapter.this.chargeIndex);
                            }
                        }
                    });
                }
            } else {
                final Charge c = (Charge)ch;
                c.app.draw(d, x, y, 0, false);
                String txt = c.getName() + "\n" + c.getBonusOrTechDesc();
                if (CoatEditor.this.coa.charge[this.chargeIndex] == c) {
                    d.text(MyDraw.SELECTED_C + txt, AGame.FOUNT, x + 16 + MyDraw.SCROLL_EL_SPACING, y, textW);
                } else {
                    d.text(txt, AGame.FOUNT, x + 16 + MyDraw.SCROLL_EL_SPACING, y, textW);
                    d.hook(x, y, width, height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                        public void run(Input in, Pt p, Hook.Type type) {
                            if (d.state.canClick() && !CoatEditor.this.waitingForRegistration) {
                                CoatEditor.this.coa.setCharge(c, ChargeAdapter.this.chargeIndex);
                            }
                        }
                    });
                }
            }
        }
    }

    private strictfp class LayoutAdapter
    implements ScrollBar.ScrollElementAdapter<CoatOfArms.Layout> {
        private LayoutAdapter() {
        }

        @Override
        public int getHeight(CoatOfArms.Layout l, MyDraw d, int availableWidth) {
            return 16 + MyDraw.SCROLL_EL_SPACING;
        }

        @Override
        public void draw(final CoatOfArms.Layout l, final MyDraw d, int x, int y, int width) {
            l.drawLayout(d, x, y);
            if (CoatEditor.this.coa.layout == l) {
                d.text(MyDraw.SELECTED_C + l.getName(), AGame.FOUNT, x + 16 + MyDraw.SCROLL_EL_SPACING, y);
            } else {
                d.text(l.getName(), AGame.FOUNT, x + 16 + MyDraw.SCROLL_EL_SPACING, y);
                d.hook(x, y, width, 16 + MyDraw.SCROLL_EL_SPACING, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        if (d.state.canClick() && !CoatEditor.this.waitingForRegistration) {
                            CoatEditor.this.coa.setLayout(l);
                        }
                    }
                });
            }
        }
    }

    strictfp class CAAC
    implements IntegrationBackend.Receiver<IntegrationBackend.CheckArmsAvailableCallback> {
        private final CoatOfArms coa;

        public CAAC(CoatOfArms coa) {
            this.coa = coa;
        }

        @Override
        public void receive(IntegrationBackend.CheckArmsAvailableCallback callback) {
            if (callback.success) {
                CoatEditor.this.free.put(this.coa, callback.available);
            }
        }
    }

    private strictfp static enum Status {
        FREE(true),
        TAKEN(false),
        CHECKING(false),
        YOURS(true),
        REGISTERING(false);

        public final boolean canRegister;

        private Status(boolean canRegister) {
            this.canRegister = canRegister;
        }
    }

    strictfp class SteamArmsCB
    implements IntegrationBackend.Receiver<IntegrationBackend.SteamSetArmsCallback> {
        SteamArmsCB() {
        }

        @Override
        public void receive(IntegrationBackend.SteamSetArmsCallback callback) {
            if (callback.success) {
                CoatEditor.this.g.integration.setRegisteredCOA(CoatEditor.this.coa.copy());
                Achievement.achieve(Achievement.COA);
                CoatEditor.this.quit();
            } else {
                CoatEditor.this.waitingForRegistration = false;
                CoatEditor.this.g.error = Lang._t("Unable_to_register_COA", new Object[0]) + "\n" + callback.errorMessage;
            }
        }
    }

    strictfp class SACB
    implements IntegrationBackend.Receiver<IntegrationBackend.SetArmsCallback> {
        SACB() {
        }

        @Override
        public void receive(IntegrationBackend.SetArmsCallback callback) {
            if (callback.success) {
                CoatEditor.this.g.integration.setRegisteredCOA(CoatEditor.this.coa.copy());
                Achievement.achieve(Achievement.COA);
                CoatEditor.this.quit();
            } else {
                CoatEditor.this.waitingForRegistration = false;
                CoatEditor.this.g.error = "Unable to register your coat of arms. There may be a network problem.\n" + callback.errorMessage;
            }
        }
    }

    public strictfp static class IntRect {
        public int x;
        public int y;
        public int w;
        public int h;

        public boolean contains(Pt p) {
            return p.x >= (double)this.x && p.y >= (double)this.y && p.x <= (double)(this.x + this.w) && p.y <= (double)(this.y + this.h);
        }
    }
}

