/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Tech;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public strictfp class Charge
extends Loadable {
    public final Appearance app;
    public final Appearance leftApp;
    public final Appearance rightApp;
    public final Appearance unlitApp;
    public final Appearance unlitLeftApp;
    public final Appearance unlitRightApp;
    public final Bonus bonus;
    public final Tech.Choice tech;
    public static List<Charge> withBonus = new ArrayList<Charge>();

    public Charge(JSONObject o) {
        super(o.getString("name"));
        this.app = new Appearance(o.getJSONObject("appearance"));
        this.unlitApp = new Appearance(o.getJSONObject("unlitAppearance"));
        this.bonus = Bonus.ofName(o.getString("bonus"));
        this.leftApp = this.app.leftSide();
        this.rightApp = this.app.rightSide();
        this.unlitLeftApp = this.unlitApp.leftSide();
        this.unlitRightApp = this.unlitApp.rightSide();
        if (o.has("tech")) {
            Tech t = Tech.ofName(o.getString("tech"));
            this.tech = t.choices.size() > 1 ? t.getChoice(o.getString("techChoice")) : t.choices.get(0);
        } else {
            this.tech = null;
        }
    }

    public String getName() {
        return Lang._t(this.name + "_singular", new Object[0]);
    }

    public String getPlural() {
        return Lang._t(this.name + "_plural", new Object[0]);
    }

    public String getBonusOrTechDesc() {
        ArrayList<Tech.Choice> prereqs;
        StringBuilder sb = new StringBuilder();
        if (this.tech == null) {
            return this.bonus.getDesc();
        }
        if (this.bonus != Bonus.ofName("NO_BONUS")) {
            sb.append(this.bonus.getDesc()).append(", ");
        }
        if (!(prereqs = this.tech.getAllPrerequisitesIncludingThis()).isEmpty()) {
            sb.append(Lang._t("Technology_one_of_", new Object[0]));
        }
        for (Tech.Choice c : prereqs) {
            sb.append(Lang._t("tech_" + c.name, new Object[0]));
            if (c == prereqs.get(prereqs.size() - 1)) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static Charge ofName(String name) {
        return Loadable.ofName(Charge.class, name);
    }

    public static void postLoad() {
        withBonus.clear();
        for (Charge c : Loadable.all(Charge.class)) {
            if (c.bonus == Bonus.ofName("NO_BONUS")) continue;
            withBonus.add(c);
        }
    }
}

