/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AIQuality;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.Challenge;
import com.zarkonnen.airships.ChallengeCombatIntent;
import com.zarkonnen.airships.ChallengeEditShipIntent;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatSpeed;
import com.zarkonnen.airships.ConfirmDialog;
import com.zarkonnen.airships.ConstructionBackend;
import com.zarkonnen.airships.EditInfoPanel;
import com.zarkonnen.airships.EditMode;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.LandscapeType;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.PriceInlineInfo;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.TutorialMessage;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.ZoomToFitButton;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Rect;
import com.zarkonnen.catengine.util.ScreenMode;
import com.zarkonnen.catengine.util.Utils;
import java.io.File;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileSystemUtils;
import org.apache.commons.io.FileUtils;

public strictfp class ChallengeInfoFloat
implements UniScreen.InfoPanel {
    public int minX;
    public int maxX;
    public int maxY;
    public Rectangle budgetRect = new Rectangle();
    public Rectangle crewInfoRect = new Rectangle();
    public Rectangle serviceCeilingRect = new Rectangle();
    public Rectangle speedRect = new Rectangle();
    public Rectangle coalRect = new Rectangle();
    public Rectangle ammoRect = new Rectangle();
    public Rectangle waterRect = new Rectangle();
    public Rectangle repairSuppliesRect = new Rectangle();
    public Rectangle moveButtonRect = new Rectangle();
    public Rectangle boardButtonRect = new Rectangle();
    public Rectangle removeButtonRect = new Rectangle();
    public EnumMap<EditMode, Rectangle> editModeRects = new EnumMap(EditMode.class);
    public TutorialMessage msg;
    private int pulseTime = 0;
    private final Img instructor = new Img("instructor", 0, 0, 150, 150, false);

    public ChallengeInfoFloat() {
        for (EditMode em : EditMode.values()) {
            this.editModeRects.put(em, new Rectangle());
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        this.pulseTime += ms;
        if (us.intent instanceof ChallengeCombatIntent) {
            ChallengeCombatIntent cci = (ChallengeCombatIntent)us.intent;
            Challenge c = cci.challenge;
            if (in.keyPressed("ENTER")) {
                if (us.combat.sides.get(1).lost()) {
                    Analytics.tutorialVictory(c.ordinal(), us.combat.time);
                    ChallengeInfoFloat.startNextOrFinish(us.g, c);
                    return;
                }
                if (us.combat.sides.get(0).lost()) {
                    Analytics.tutorialDefeat(c.ordinal(), us.combat.time);
                    c.reset(true);
                    UniScreen us2 = new UniScreen(us.g, new ChallengeEditShipIntent(c, true));
                    us2.standaloneEditShip = cci.playerDesign.clone();
                    us.g.s = us2;
                    return;
                }
                TutorialMessage tm = this.getText(cci, us);
                if (tm == null) {
                    return;
                }
                if (tm.buttons.contains("OK")) {
                    c.combatButtonPressed("OK");
                    return;
                }
                if (tm.buttons.contains("Next")) {
                    c.combatButtonPressed("Next");
                    return;
                }
            }
        }
        if (us.intent instanceof ChallengeEditShipIntent) {
            Challenge c = ((ChallengeEditShipIntent)us.intent).challenge;
            TutorialMessage tm = this.getText((ChallengeEditShipIntent)us.intent, us);
            if (in.keyPressed("ENTER")) {
                if (tm.buttons.contains("Start")) {
                    if (this.startEnabled(us)) {
                        this.start(in, us);
                    }
                    return;
                }
                if (tm.buttons.contains("OK")) {
                    c.editorButtonPressed("OK");
                    return;
                }
                if (tm.buttons.contains("Next")) {
                    Analytics.report("challengeNextMessage");
                    c.editorButtonPressed("Next");
                    return;
                }
            }
        }
    }

    public void highlight(MyDraw d, Rectangle r) {
        int intensity = (int)(150.0 + Math.cos((double)this.pulseTime * 0.008) * 100.0);
        Clr c = new Clr(255, 255, 255, intensity);
        d.rect(c, r.x - 6, r.y - 6, r.w + 12, 4.0);
        d.rect(c, r.x - 6, r.y + r.h + 2, r.w + 12, 4.0);
        d.rect(c, r.x - 6, r.y - 2, 4.0, r.h + 4);
        d.rect(c, r.x + r.w + 2, r.y - 2, 4.0, r.h + 4);
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, final UniScreen us) {
        this.msg = null;
        int x = MyDraw.SIDE_CLEARANCE;
        if (us.intent instanceof ChallengeCombatIntent) {
            this.msg = this.getText((ChallengeCombatIntent)us.intent, us);
        }
        if (us.intent instanceof ChallengeEditShipIntent) {
            x = us.panel(EditInfoPanel.class).myWidth + MyDraw.UI_SPACING;
            ChallengeEditShipIntent cesi = (ChallengeEditShipIntent)us.intent;
            this.msg = this.getText(cesi, us);
        }
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        int w = 0;
        if (this.msg != null) {
            d.drawShadowedWindow(x, y, 140 + 2 * MyDraw.WINDOW_INSET, 140 + 2 * MyDraw.WINDOW_INSET);
            d.blit(this.instructor, x + MyDraw.WINDOW_INSET - 5, y + MyDraw.WINDOW_INSET - 5);
            this.minX = x += 140 + 2 * MyDraw.WINDOW_INSET + MyDraw.UI_SPACING;
            w = Math.min(AGame.FOUNT.displayWidth * 25 + 400 + MyDraw.WINDOW_INSET * 2, sm.width - x - MyDraw.SIDE_CLEARANCE);
            Rect textSize = d.textSize(Lang._t(this.msg.text, new Object[0]), AGame.FOUNT, x, y, w - MyDraw.WINDOW_INSET * 2);
            d.drawShadowedWindow(x, y, w, (int)textSize.height + MyDraw.WINDOW_INSET * 2);
            d.text(Lang._t(this.msg.text, new Object[0]), AGame.FOUNT, x + MyDraw.WINDOW_INSET, y + MyDraw.WINDOW_INSET, w - MyDraw.WINDOW_INSET * 2);
            y += (int)textSize.height + MyDraw.WINDOW_INSET * 2 + MyDraw.UI_SPACING;
            if (this.msg.highlightBoardButton) {
                this.highlight(d, this.boardButtonRect);
            }
            if (this.msg.highlightBudget) {
                this.highlight(d, this.budgetRect);
            }
            if (this.msg.highlightCrewInfo) {
                this.highlight(d, this.crewInfoRect);
            }
            if (this.msg.highlightMoveButton) {
                this.highlight(d, this.moveButtonRect);
            }
            if (this.msg.highlightEditMode != null) {
                this.highlight(d, this.editModeRects.get(this.msg.highlightEditMode));
            }
            if (this.msg.highlightRemoveButton) {
                this.highlight(d, this.removeButtonRect);
            }
            if (this.msg.highlightServiceCeiling) {
                this.highlight(d, this.serviceCeilingRect);
            }
            if (this.msg.highlightSpeed) {
                this.highlight(d, this.speedRect);
            }
            if (this.msg.highlightCoal) {
                this.highlight(d, this.coalRect);
            }
            if (this.msg.highlightAmmo) {
                this.highlight(d, this.ammoRect);
            }
            if (this.msg.highlightWater) {
                this.highlight(d, this.waterRect);
            }
            if (this.msg.highlightRepairSupplies) {
                this.highlight(d, this.repairSuppliesRect);
            }
        } else {
            this.minX = x;
        }
        if (us.intent instanceof ChallengeCombatIntent) {
            final ChallengeCombatIntent cci = (ChallengeCombatIntent)us.intent;
            final Challenge c = cci.challenge;
            if (us.combat.sides.get(1).lost()) {
                int bw = d.bw(Lang._t("OK", new Object[0]), "ENTER");
                d.button(x, y, bw, Lang._t("OK", new Object[0]), "ENTER", new Runnable(){

                    @Override
                    public void run() {
                        Analytics.tutorialVictory(c.ordinal(), us.combat.time);
                        ChallengeInfoFloat.startNextOrFinish(us.g, c);
                    }
                });
                x += bw + MyDraw.BUTTON_SPACING;
                if (c.saveSuccessfulDesign) {
                    d.button(x, y, d.bw(Lang._t("Save_Design", new Object[0])), Lang._t("Save_Design", new Object[0]), new Runnable(){

                        @Override
                        public void run() {
                            ShipHelperWidget shw = ShipHelperWidget.get(cci.playerDesign.type, us.g.getBestCOA(), Tech.getStandardBonuses(), null, 0);
                            ConstructionBackend cbe = ShipEditorUtils.shipsList(cci.playerDesign.type, shw);
                            us.g.s = new FileScreen(cbe, new SaveShipMission(us.g, us, cci.playerDesign, c, cbe), shw, new PriceInlineInfo(shw, null), ShipType.AIRSHIP.name());
                        }
                    });
                }
                return;
            }
            if (us.combat.sides.get(0).lost()) {
                d.button(x, y, d.bw(Lang._t("Try_Again", new Object[0]), "ENTER"), Lang._t("Try_Again", new Object[0]), "ENTER", new Runnable(){

                    @Override
                    public void run() {
                        Analytics.tutorialDefeat(c.ordinal(), us.combat.time);
                        c.reset(true);
                        UniScreen us2 = new UniScreen(us.g, new ChallengeEditShipIntent(c, true));
                        us2.standaloneEditShip = cci.playerDesign.clone();
                        us.g.s = us2;
                    }
                });
                return;
            }
        }
        if (this.msg == null) {
            return;
        }
        for (final String b : this.msg.buttons) {
            Challenge c;
            ChallengeCombatIntent cci;
            int bx = x;
            if (b.equals("Start")) {
                bx = this.minX + w - d.bw(Lang._t(b, new Object[0]), "ENTER");
            } else if (b.equals("Next")) {
                bx = this.minX + w - d.bw(Lang._t(b, new Object[0]));
            } else {
                x += d.bw(Lang._t(b, new Object[0])) + MyDraw.BUTTON_SPACING;
            }
            if (b.equals("Start")) {
                d.goldbutton(bx, y, d.bw(Lang._t("Start", new Object[0]), "ENTER"), Lang._t("Start", new Object[0]), "ENTER", new InputRunnable(){

                    @Override
                    public void run(Input in) {
                        Analytics.report("challengeStart");
                        ChallengeInfoFloat.this.start(in, us);
                    }
                }, this.startEnabled(us));
                continue;
            }
            if (b.equals("Try_Again") && us.intent instanceof ChallengeCombatIntent) {
                cci = (ChallengeCombatIntent)us.intent;
                c = cci.challenge;
                d.button(bx, y, d.bw(Lang._t("Try_Again", new Object[0])), Lang._t("Try_Again", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        ChallengeInfoFloat.this.showRestartDialog(us, c, cci);
                    }
                });
                continue;
            }
            if (us.intent instanceof ChallengeCombatIntent) {
                cci = (ChallengeCombatIntent)us.intent;
                c = cci.challenge;
                d.button(bx, y, d.bw(Lang._t(b, new Object[0])), Lang._t(b, new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        c.combatButtonPressed(b);
                    }
                });
                continue;
            }
            if (!(us.intent instanceof ChallengeEditShipIntent)) continue;
            ChallengeEditShipIntent cesi = (ChallengeEditShipIntent)us.intent;
            c = cesi.challenge;
            d.button(bx, y, d.bw(Lang._t(b, new Object[0])), Lang._t(b, new Object[0]), new Runnable(){

                @Override
                public void run() {
                    c.editorButtonPressed(b);
                }
            });
        }
        this.maxY = y += MyDraw.BUTTON_H;
        this.maxX = x + w;
    }

    private void showRestartDialog(UniScreen us, final Challenge c, final ChallengeCombatIntent cci) {
        us.confirmDialog = new ConfirmDialog(){

            @Override
            public String text() {
                return Lang._t("restart_tutorial_confirm", new Object[0]);
            }

            @Override
            public String okText() {
                return Lang._t("OK", new Object[0]);
            }

            @Override
            public String cancelText() {
                return Lang._t("Cancel", new Object[0]);
            }

            @Override
            public void ok(UniScreen us) {
                Analytics.tutorialRestart(c.ordinal(), us.combat.time);
                UniScreen us2 = new UniScreen(us.g, new ChallengeEditShipIntent(c, true));
                us2.standaloneEditShip = cci.playerDesign.clone();
                us.g.s = us2;
            }

            @Override
            public void cancel(UniScreen us) {
                us.confirmDialog = null;
            }
        };
    }

    static void startNextOrFinish(AirshipGame g, Challenge c) {
        if (c == Challenge.values()[Challenge.values().length - 1]) {
            g.s = new MainMenu(g, MainMenu.Submenu.AIRSHIP_ACADEMY);
        } else {
            c = Challenge.values()[c.ordinal() + 1];
            UniScreen us = new UniScreen(g, new ChallengeEditShipIntent(c, false));
            us.standaloneEditShip = ((Airship)c.ships[0].b).clone();
            g.s = us;
        }
    }

    private TutorialMessage getText(ChallengeCombatIntent cci, UniScreen us) {
        Challenge c = cci.challenge;
        if (us.combat.sides.get(0).lost()) {
            us.combat.speed = CombatSpeed.STOP;
            return new TutorialMessage(c.name() + "_defeatOutro", new String[0]);
        }
        if (us.combat.sides.get(1).lost()) {
            us.combat.speed = CombatSpeed.STOP;
            c.complete();
            return new TutorialMessage(c.name() + "_victoryOutro", new String[0]);
        }
        TutorialMessage tm = c.getCombatMessage(us);
        us.combat.speed = tm != null ? (tm.pauseCombat ? CombatSpeed.STOP : CombatSpeed.NORMAL) : CombatSpeed.NORMAL;
        return tm;
    }

    private TutorialMessage getText(ChallengeEditShipIntent cesi, UniScreen us) {
        Challenge c = cesi.challenge;
        return c.getEditorMessage(us);
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }

    public boolean startEnabled(UniScreen us) {
        Challenge c = ((ChallengeEditShipIntent)us.intent).challenge;
        return c.checkEditShipReady(us.standaloneEditShip) && ShipEditorUtils.shipErrors(us.standaloneEditShip, c.budget != 0, false, c.budget, Tech.getStandardBonuses(), null, us).isEmpty();
    }

    public void start(Input in, UniScreen us) {
        us.tool = UniScreen.NAVIGATE;
        Challenge c = ((ChallengeEditShipIntent)us.intent).challenge;
        us.combat = new Combat(us.g, TimeOfDay.ofName("DAY"));
        us.combat.hasInaccuracyMult = false;
        us.combat.sides.get((int)0).ships.add(us.standaloneEditShip);
        us.intent = new ChallengeCombatIntent(c, us.standaloneEditShip.clone());
        Utils.Pair<LandFormation, List<LandFormation>> lfs = LandFormation.generate(new Random(c.combatSeed), false, LandscapeType.ofName("GRASSLAND"));
        us.combat.landFormations.add((LandFormation)lfs.a);
        if (c.addRocks) {
            us.combat.landFormations.addAll((Collection)lfs.b);
        }
        if (c == Challenge.UPARMOUR) {
            LandFormation f = new LandFormation(-100.0, 0.0, 7, 20, LandscapeType.ofName("GRASSLAND"));
            f.generateLowFloater(new Random(1234L), LandscapeType.ofName("GRASSLAND"));
            f.setY(512 - f.availableServiceCeiling());
            us.combat.landFormations.add(f);
            f = new LandFormation(-940.0, 0.0, 7, 20, LandscapeType.ofName("GRASSLAND"));
            f.generateLowFloater(new Random(88120L), LandscapeType.ofName("GRASSLAND"));
            f.setY(512 - f.availableServiceCeiling());
            us.combat.landFormations.add(f);
        }
        us.standaloneEditShip.setX(((Pt)c.ships[0].a).x);
        us.standaloneEditShip.setY(((Pt)c.ships[0].a).y);
        if (us.standaloneEditShip.type.onGround) {
            us.standaloneEditShip.setY(PlaceShipTool.getPlacement((Airship)us.standaloneEditShip, (double)us.standaloneEditShip.getX(), (double)us.standaloneEditShip.getY(), (boolean)us.standaloneEditShip.flipped, (LandFormation)us.combat.landFormations.get((int)0), null, (boolean)false, (int)-1).y);
        }
        us.standaloneEditShip.repair();
        us.standaloneEditShip.networkID = "me.1";
        us.standaloneEditShip = null;
        for (int myShipIndex = 1; myShipIndex < c.ships.length; ++myShipIndex) {
            Airship ship = ((Airship)c.ships[myShipIndex].b).clone();
            us.combat.sides.get((int)0).ships.add(ship);
            ship.setX(((Pt)c.ships[myShipIndex].a).x);
            ship.setY(((Pt)c.ships[myShipIndex].a).y);
            if (ship.type.onGround) {
                ship.setY(PlaceShipTool.getPlacement((Airship)ship, (double)ship.getX(), (double)ship.getY(), (boolean)ship.flipped, (LandFormation)us.combat.landFormations.get((int)0), null, (boolean)false, (int)-1).y);
            }
            ship.networkID = "me." + (myShipIndex + 1);
        }
        int i = 1;
        for (Utils.Pair<Pt, Airship> en : c.enemies) {
            Airship sh = ((Airship)en.b).clone();
            sh.setX(((Pt)en.a).x);
            sh.setY(((Pt)en.a).y);
            if (sh.type.onGround) {
                sh.setY(PlaceShipTool.getPlacement((Airship)sh, (double)sh.getX(), (double)sh.getY(), (boolean)sh.flipped, (LandFormation)us.combat.landFormations.get((int)0), null, (boolean)false, (int)-1).y);
            }
            sh.repair();
            us.combat.sides.get((int)1).ships.add(sh);
            sh.ai = new TacticalAI(sh, us.combat, us.combat.sides.get(1), us.combat.sides.get(0));
            sh.ai.quality = AIQuality.STUPID;
            sh.ai.doesSurrender = false;
            sh.networkID = "enemy." + i++;
        }
        us.mySide = us.combat.sides.get(0);
        ZoomToFitButton.zoomToFit(in, us, 1.0);
        us.combat.tick(16, us.combat.sides.get(0), false, 1);
        us.combat.speed = CombatSpeed.STOP;
    }

    private strictfp static class SaveShipMission
    implements FileScreen.Mission {
        private final AirshipGame g;
        private final UniScreen us;
        private final Airship ship;
        private final Challenge challenge;
        private final ConstructionBackend backend;

        public SaveShipMission(AirshipGame g, UniScreen us, Airship ship, Challenge challenge, ConstructionBackend backend) {
            this.g = g;
            this.us = us;
            this.ship = ship;
            this.challenge = challenge;
            this.backend = backend;
        }

        @Override
        public FileScreen.Mode mode() {
            return FileScreen.Mode.SAVE;
        }

        @Override
        public String text() {
            return Lang._t("Save_", new Object[0]);
        }

        @Override
        public String fileSelectionText() {
            return Lang._t("Save", new Object[0]);
        }

        @Override
        public String initialInput() {
            return AGame.makeFileSafe(this.ship.getName());
        }

        @Override
        public void fileSelected(String path) {
            this.g.s = this.us;
            File f = this.backend.getFile(FileScreen.splitPath(path));
            try {
                this.ship.setName(FileScreen.getDefaultDisplayName(path, this.backend));
                FileUtils.write((File)f, (CharSequence)this.ship.toJSON(null).toString(4), (String)"UTF-8");
                ChallengeInfoFloat.startNextOrFinish(this.g, this.challenge);
            }
            catch (Exception e) {
                long space = -1L;
                try {
                    space = FileSystemUtils.freeSpaceKb((String)this.backend.getFile(FileScreen.splitPath(path)).getAbsolutePath(), (long)3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (space != -1L && space < 10240L) {
                    this.g.showError(Lang._t("Insufficient_space_on_disk", new Object[0]));
                }
                this.g.reportError(Lang._t("Unable_to_save_ship_or_building", new Object[0]), e, null, false);
            }
        }

        @Override
        public void cancelled() {
            this.g.s = this.us;
        }
    }

    public strictfp static class Rectangle {
        int x;
        int y;
        int w;
        int h;
    }
}

