/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.ChallengeEditShipIntent;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.EditMode;
import com.zarkonnen.airships.EditPalettePanel;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleCategory;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MoveCommandTool;
import com.zarkonnen.airships.TutorialMessage;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Utils;
import java.io.File;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public enum Challenge {
    TOWER(false, 0, false, new String[0], 888L, false, new Utils.Pair[]{new Utils.Pair((Object)new Pt(-400.0, 200.0), (Object)"HMS Lion")}, new Utils.Pair[]{new Utils.Pair((Object)new Pt(200.0, 0.0), (Object)"Small Tower")}, false){
        private boolean hasScrolledWithDrag;
        private boolean hasScrolledWithArrows;
        private int editorMessageIndex = 0;
        private int combatMessageIndex = 0;

        @Override
        public TutorialMessage getCombatMessage(UniScreen us) {
            if (us.hasScrolledWithDrag && !this.hasScrolledWithDrag) {
                this.report("hasScrolledWithDrag");
                this.hasScrolledWithDrag = true;
            }
            if (us.hasScrolledWithArrows && !this.hasScrolledWithArrows) {
                this.report("hasScrolledWithArrows");
                this.hasScrolledWithArrows = true;
            }
            if (this.combatMessageIndex == 0) {
                return new TutorialMessage("TOWER_combatIntro", "OK");
            }
            return null;
        }

        @Override
        public TutorialMessage getEditorMessage(UniScreen us) {
            if (!us.standaloneEditShip.isPathingFullyConnected()) {
                return new TutorialMessage("c_moduleUnreachable", new String[0]);
            }
            switch (this.editorMessageIndex) {
                case 0: {
                    return new TutorialMessage("TOWER_editorIntro", "Next");
                }
                case 1: {
                    return new TutorialMessage("TOWER_editorIntro2", "Prev", "Next");
                }
                case 2: {
                    return new TutorialMessage("TOWER_SUSPENDIUM_CHAMBER", "Prev", "Next").highlightModule(ModuleType.ofName("SUSPENDIUM_CHAMBER")).highlightServiceCeiling();
                }
                case 3: {
                    return new TutorialMessage("TOWER_PROPELLER", "Prev", "Next").highlightModule(ModuleType.ofName("PROPELLER")).highlightSpeed();
                }
                case 4: {
                    return new TutorialMessage("TOWER_COAL_STORE", "Prev", "Next").highlightModule(ModuleType.ofName("COAL_STORE")).highlightCoal();
                }
                case 5: {
                    return new TutorialMessage("TOWER_CANNON", "Prev", "Next").highlightModule(ModuleType.ofName("CANNON"));
                }
                case 6: {
                    return new TutorialMessage("TOWER_AMMO", "Prev", "Next").highlightModule(ModuleType.ofName("AMMO")).highlightAmmo();
                }
                case 7: {
                    return new TutorialMessage("TOWER_QUARTERS", "Prev", "Next").highlightModule(ModuleType.ofName("QUARTERS")).highlightCrewInfo();
                }
                case 8: {
                    return new TutorialMessage("TOWER_editorOutro", "Prev", "Start");
                }
            }
            return null;
        }

        @Override
        public void reset(boolean retry) {
            this.editorMessageIndex = 0;
            this.combatMessageIndex = 0;
        }

        @Override
        public void combatButtonPressed(String name) {
            if (name.equals("OK")) {
                ++this.combatMessageIndex;
            }
        }

        @Override
        public void editorButtonPressed(String name) {
            if (name.equals("Next")) {
                ++this.editorMessageIndex;
            }
            if (name.equals("Prev")) {
                --this.editorMessageIndex;
            }
        }
    }
    ,
    ADD_GUNS(false, 0, false, new String[]{"CANNON"}, 4488L, false, new Utils.Pair[]{new Utils.Pair((Object)new Pt(-200.0, 0.0), (Object)"HMS Bear")}, new Utils.Pair[]{new Utils.Pair((Object)new Pt(100.0, 0.0), (Object)"Small Tower")}, false){
        private boolean cannonPlacementSuccess;
        private boolean cannonPlacementMistake;
        private boolean cannonPlacementMistakeCorrected;
        private boolean moveSelected;
        private boolean goDownReminded;
        private int editorMessageIndex = 0;
        private int combatMessageIndex = 0;
        private boolean inited = false;

        @Override
        public TutorialMessage getCombatMessage(UniScreen us) {
            if (!this.inited) {
                us.panel(EditPalettePanel.class).openCategories.clear();
                us.panel(EditPalettePanel.class).openCategories.add(ModuleCategory.ofName("BASIC"));
                this.inited = true;
            }
            if (this.combatMessageIndex == 0) {
                return new TutorialMessage("ADD_GUNS_combatIntro", "OK").highlightMoveButton().highlightMoveTo(new Pt(-200.0, 300.0), false);
            }
            Combat c = us.combat;
            if (!this.moveSelected && us.tool instanceof MoveCommandTool) {
                this.report("moveSelected");
                this.moveSelected = true;
            }
            if (!c.sides.get((int)0).ships.isEmpty() && c.sides.get((int)0).ships.get(0).getY() < 200.0) {
                if (c.time < 20000) {
                    return new TutorialMessage("ADD_GUNS_combatIntro", new String[0]).dontPauseCombat().highlightMoveButton();
                }
                if (!this.goDownReminded) {
                    this.report("goDownReminded");
                    this.goDownReminded = true;
                }
                return new TutorialMessage("ADD_GUNS_goDown", new String[0]).dontPauseCombat();
            }
            return null;
        }

        @Override
        public TutorialMessage getEditorMessage(UniScreen us) {
            if (!us.standaloneEditShip.isFullyConnected()) {
                if (!this.cannonPlacementMistake) {
                    this.report("cannonPlacementMistake");
                    this.cannonPlacementMistake = true;
                }
                return new TutorialMessage("ADD_GUNS_cannonDisconnect", new String[0]).highlightRemoveButton();
            }
            if (!us.standaloneEditShip.isPathingFullyConnected()) {
                if (!this.cannonPlacementMistake) {
                    this.report("cannonPlacementMistake");
                    this.cannonPlacementMistake = true;
                }
                return new TutorialMessage("ADD_GUNS_cannonUnreachable", new String[0]).highlightRemoveButton();
            }
            if (this.cannonPlacementMistake && !this.cannonPlacementMistakeCorrected) {
                this.report("cannonPlacementMistakeCorrected");
                this.cannonPlacementMistakeCorrected = true;
            }
            if (!this.cannonPlacementSuccess && us.standaloneEditShip.hasModuleTypeAny(ModuleType.ofName("CANNON"))) {
                this.report("cannonPlacementSuccess");
                this.cannonPlacementSuccess = true;
            }
            if (!us.standaloneEditShip.isPathingFullyConnected()) {
                return new TutorialMessage("c_moduleUnreachable", new String[0]).highlightRemoveButton();
            }
            switch (this.editorMessageIndex) {
                case 0: {
                    return new TutorialMessage("ADD_GUNS_editorIntro", "Next");
                }
                case 1: {
                    return new TutorialMessage("ADD_GUNS_FIRE_POINT", "Prev", "Next").highlightModule(ModuleType.ofName("FIRE_POINT")).highlightWater();
                }
                case 2: {
                    return new TutorialMessage("ADD_GUNS_editorOutro", "Prev", "Start");
                }
            }
            return null;
        }

        @Override
        public boolean checkEditShipReady(Airship ship) {
            for (Module m : ship.modules) {
                if (m.type != ModuleType.ofName("CANNON")) continue;
                return true;
            }
            return false;
        }

        @Override
        public void reset(boolean retry) {
            this.cannonPlacementSuccess = false;
            this.cannonPlacementMistake = false;
            this.cannonPlacementMistakeCorrected = false;
            this.moveSelected = false;
            this.goDownReminded = false;
            this.editorMessageIndex = 0;
            this.combatMessageIndex = 0;
            this.inited = false;
        }

        @Override
        public void combatButtonPressed(String name) {
            if (name.equals("OK")) {
                ++this.combatMessageIndex;
            }
        }

        @Override
        public void editorButtonPressed(String name) {
            if (name.equals("Next")) {
                ++this.editorMessageIndex;
            }
            if (name.equals("Prev")) {
                --this.editorMessageIndex;
            }
        }
    }
    ,
    FIRING_ARCS(false, 0, false, new String[0], 138L, false, new Utils.Pair[]{new Utils.Pair((Object)new Pt(-250.0, 200.0), (Object)"HMS Leopard")}, new Utils.Pair[]{new Utils.Pair((Object)new Pt(150.0, 0.0), (Object)"Radiant Fortress")}, false){
        private boolean collisionMessage;
        private boolean flipMessage;
        private boolean arcsMessage;
        private boolean correctPositioning;
        private boolean firingArcGoodPosition;
        private int editorMessageIndex = 0;
        private int combatMessageIndex = 0;
        private int firingArcProblemStart = 0;

        @Override
        public TutorialMessage getCombatMessage(UniScreen us) {
            if (this.combatMessageIndex == 0) {
                return new TutorialMessage("FIRING_ARCS_combatIntro", "OK").highlightMoveButton().highlightMoveTo(new Pt(400.0, 280.0), true);
            }
            Combat c = us.combat;
            if (c.time < 3000) {
                for (Airship b : c.sides.get((int)1).ships) {
                    for (Module m : b.modules) {
                        m.shootAccumulator = 0;
                    }
                }
            }
            if (c.sides.get((int)0).ships.isEmpty() || c.sides.get((int)1).ships.isEmpty()) {
                return null;
            }
            Airship me = c.sides.get((int)0).ships.get(0);
            Airship en = c.sides.get((int)1).ships.get(0);
            if (!this.correctPositioning && me.getX() > en.getX() + 60.0 && me.flipped) {
                boolean oneCannonWithValidTarget = false;
                for (Module m : me.modules) {
                    if (m.type != ModuleType.ofName("CANNON") || m.noValidTarget) continue;
                    oneCannonWithValidTarget = true;
                }
                if (oneCannonWithValidTarget) {
                    this.report("correctPositioning");
                    this.correctPositioning = true;
                }
            }
            if (me.hasBraked > 0 && me.canFly()) {
                if (!this.collisionMessage) {
                    this.report("collisionMessage");
                    this.collisionMessage = true;
                }
                return new TutorialMessage("FIRING_ARCS_collision", new String[0]).dontPauseCombat();
            }
            if (me.getX() > en.getX() + 60.0 && c.time > 5000 && !me.flipped && !me.flipTo) {
                if (!this.flipMessage) {
                    this.report("flipMessage");
                    this.flipMessage = true;
                }
                return new TutorialMessage("FIRING_ARCS_flip", new String[0]).dontPauseCombat();
            }
            if (c.time > 20000 || me.getX() > en.getX() + 80.0) {
                boolean hasFiringArcProblem = false;
                for (Module m : me.modules) {
                    if (m.type != ModuleType.ofName("CANNON") || !m.noValidTarget) continue;
                    hasFiringArcProblem = true;
                    break;
                }
                if (hasFiringArcProblem) {
                    if (this.firingArcProblemStart == 0) {
                        this.firingArcProblemStart = c.time;
                    } else if (c.time - this.firingArcProblemStart > 3500) {
                        if (!this.arcsMessage) {
                            this.report("arcsMessage");
                            this.arcsMessage = true;
                        }
                        return new TutorialMessage("FIRING_ARCS_arcs", new String[0]).dontPauseCombat();
                    }
                } else {
                    this.firingArcProblemStart = 0;
                }
                if (me.getX() > en.getX() + 80.0) {
                    if (!this.firingArcGoodPosition) {
                        this.report("firingArcGoodPosition");
                        this.firingArcGoodPosition = true;
                    }
                    return new TutorialMessage("FIRING_ARCS_goodPosition", new String[0]).dontPauseCombat();
                }
            }
            return new TutorialMessage("FIRING_ARCS_combatIntro", new String[0]).dontPauseCombat().highlightMoveButton();
        }

        @Override
        public TutorialMessage getEditorMessage(UniScreen us) {
            switch (this.editorMessageIndex) {
                case 0: {
                    return new TutorialMessage("FIRING_ARCS_editorIntro", "Next");
                }
                case 1: {
                    return new TutorialMessage("FIRING_ARCS_REPAIR_BAY", "Prev", "Next").highlightModule(ModuleType.ofName("REPAIR_BAY")).highlightRepairSupplies();
                }
                case 2: {
                    return new TutorialMessage("FIRING_ARCS_editorOutro", "Prev", "Start");
                }
            }
            return null;
        }

        @Override
        public void reset(boolean retry) {
            this.collisionMessage = false;
            this.flipMessage = false;
            this.arcsMessage = false;
            this.correctPositioning = false;
            this.firingArcGoodPosition = false;
            this.editorMessageIndex = 0;
            this.combatMessageIndex = 0;
            this.firingArcProblemStart = 0;
        }

        @Override
        public void combatButtonPressed(String name) {
            if (name.equals("OK")) {
                ++this.combatMessageIndex;
            }
        }

        @Override
        public void editorButtonPressed(String name) {
            if (name.equals("Next")) {
                ++this.editorMessageIndex;
            }
            if (name.equals("Prev")) {
                --this.editorMessageIndex;
            }
        }
    }
    ,
    UPARMOUR(false, 0, true, new String[0], 93193L, true, new Utils.Pair[]{new Utils.Pair((Object)new Pt(-1440.0, 120.0), (Object)"HMS Tiger")}, new Utils.Pair[]{new Utils.Pair((Object)new Pt(300.0, 0.0), (Object)"Grey Pillar")}, false){
        private boolean closeEnough;
        private boolean closerYetMessage;
        private int editorMessageIndex = 0;
        private int combatMessageIndex = 0;

        @Override
        public TutorialMessage getCombatMessage(UniScreen us) {
            if (this.combatMessageIndex == 0) {
                return new TutorialMessage("UPARMOUR_combatIntro", "OK").highlightMoveTo(new Pt(0.0, 300.0), false);
            }
            Combat c = us.combat;
            if (!this.closeEnough && !c.sides.get((int)0).ships.isEmpty() && c.sides.get((int)0).ships.get(0).getX() >= -150.0) {
                this.report("closeEnough");
                this.closeEnough = true;
            }
            if (c.time > 15000 && !c.sides.get((int)0).ships.isEmpty() && c.sides.get((int)0).ships.get(0).getX() < -150.0) {
                if (!this.closerYetMessage) {
                    this.report("closerYetMessage");
                    this.closerYetMessage = true;
                }
                return new TutorialMessage("UPARMOUR_closer_yet", new String[0]).highlightMoveTo(new Pt(0.0, 300.0), false).dontPauseCombat();
            }
            if (!this.closeEnough) {
                return new TutorialMessage("UPARMOUR_combatIntro", new String[0]).highlightMoveTo(new Pt(0.0, 300.0), false).dontPauseCombat();
            }
            if (!c.sides.get((int)0).ships.isEmpty() && c.sides.get((int)0).ships.get(0).getX() >= -150.0) {
                return new TutorialMessage("FIRING_ARCS_goodPosition", new String[0]).dontPauseCombat();
            }
            return null;
        }

        @Override
        public boolean checkEditShipReady(Airship ship) {
            return !EditPalettePanel.guessArmourType((Airship)ship).name.equals("LT_WOOD");
        }

        @Override
        public TutorialMessage getEditorMessage(UniScreen us) {
            ChallengeEditShipIntent esi = (ChallengeEditShipIntent)us.intent;
            if (esi.mode == EditMode.ARMOUR) {
                return new TutorialMessage("UPARMOUR_editorOutro", "Start");
            }
            return new TutorialMessage("UPARMOUR_editorIntro", new String[0]).highlightEditMode(EditMode.ARMOUR);
        }

        @Override
        public void reset(boolean retry) {
            this.closeEnough = false;
            this.closerYetMessage = false;
            this.editorMessageIndex = 0;
            this.combatMessageIndex = 0;
        }

        @Override
        public void combatButtonPressed(String name) {
            if (name.equals("OK")) {
                ++this.combatMessageIndex;
            }
        }

        @Override
        public void editorButtonPressed(String name) {
            if (name.equals("Next")) {
                ++this.editorMessageIndex;
            }
            if (name.equals("Prev")) {
                --this.editorMessageIndex;
            }
        }
    }
    ,
    CHOOSE_YOUR_WEAPON(false, 900, true, new String[]{"CANNON", "RIFLE", "GRENADES"}, 191L, false, new Utils.Pair[]{new Utils.Pair((Object)new Pt(-200.0, 100.0), (Object)"HMS Porcupine")}, new Utils.Pair[]{new Utils.Pair((Object)new Pt(200.0, 0.0), (Object)"Intruder")}, false){
        private int editorMessageIndex = 0;
        private int combatMessageIndex = 0;

        @Override
        public TutorialMessage getCombatMessage(UniScreen us) {
            if (this.combatMessageIndex == 0) {
                return new TutorialMessage("CHOOSE_YOUR_WEAPON_combatIntro", "OK");
            }
            Combat c = us.combat;
            if (c.time > 20000 && !c.sides.get((int)0).ships.isEmpty()) {
                for (Module m : c.sides.get((int)0).ships.get((int)0).modules) {
                    if (!m.type.isWeapon() || !m.noValidTarget) continue;
                    return new TutorialMessage("CHOOSE_YOUR_WEAPON_arcs", new String[0]).dontPauseCombat();
                }
            }
            return new TutorialMessage("CHOOSE_YOUR_WEAPON_combatIntro", new String[0]).dontPauseCombat();
        }

        @Override
        public boolean checkEditShipReady(Airship ship) {
            for (Module m : ship.modules) {
                if (!m.type.isWeapon()) continue;
                return true;
            }
            return false;
        }

        @Override
        public TutorialMessage getEditorMessage(UniScreen us) {
            switch (this.editorMessageIndex) {
                case 0: {
                    return new TutorialMessage("CHOOSE_YOUR_WEAPON_editorIntro", "Next");
                }
                case 1: {
                    return new TutorialMessage("CHOOSE_YOUR_WEAPON_editorOutro", "Prev", "Start").highlightBudget();
                }
            }
            return null;
        }

        @Override
        public void reset(boolean retry) {
            this.editorMessageIndex = 0;
            this.combatMessageIndex = 0;
        }

        @Override
        public void combatButtonPressed(String name) {
            if (name.equals("OK")) {
                ++this.combatMessageIndex;
            }
        }

        @Override
        public void editorButtonPressed(String name) {
            if (name.equals("Next")) {
                ++this.editorMessageIndex;
            }
            if (name.equals("Prev")) {
                --this.editorMessageIndex;
            }
        }
    }
    ,
    LANDSHIP(false, 850, true, new String[]{"CANNON", "RIFLE", "GRENADES", "FLAK_CANNON", "DORSAL_TURRET"}, 8888L, false, new Utils.Pair[]{new Utils.Pair((Object)new Pt(-200.0, 100.0), (Object)"HMS Lancer")}, new Utils.Pair[]{new Utils.Pair((Object)new Pt(200.0, 0.0), (Object)"Raider")}, false){
        private int editorMessageIndex = 0;
        private int combatMessageIndex = 0;

        @Override
        public TutorialMessage getCombatMessage(UniScreen us) {
            if (this.combatMessageIndex == 0) {
                return new TutorialMessage("LANDSHIP_combatIntro", "OK");
            }
            return null;
        }

        @Override
        public boolean checkEditShipReady(Airship ship) {
            for (Module m : ship.modules) {
                if (!m.type.isWeapon()) continue;
                return true;
            }
            return false;
        }

        @Override
        public TutorialMessage getEditorMessage(UniScreen us) {
            switch (this.editorMessageIndex) {
                case 0: {
                    return new TutorialMessage("LANDSHIP_editorIntro", "Next");
                }
                case 1: {
                    return new TutorialMessage("LANDSHIP_SMALL_TRACKS", "Prev", "Next").highlightModule(ModuleType.ofName("SMALL_TRACKS"));
                }
                case 2: {
                    return new TutorialMessage("LANDSHIP_editorOutro", "Prev", "Start");
                }
            }
            return null;
        }

        @Override
        public void reset(boolean retry) {
            this.editorMessageIndex = 0;
            this.combatMessageIndex = 0;
        }

        @Override
        public void combatButtonPressed(String name) {
            if (name.equals("OK")) {
                ++this.combatMessageIndex;
            }
        }

        @Override
        public void editorButtonPressed(String name) {
            if (name.equals("Next")) {
                ++this.editorMessageIndex;
            }
            if (name.equals("Prev")) {
                --this.editorMessageIndex;
            }
        }
    }
    ,
    MULTISHIP(false, 0, false, new String[0], 7738L, false, new Utils.Pair[]{new Utils.Pair((Object)new Pt(-600.0, 150.0), (Object)"HMS Leopard"), new Utils.Pair((Object)new Pt(-200.0, 200.0), (Object)"HMS Leopard"), new Utils.Pair((Object)new Pt(-400.0, 100.0), (Object)"HMS Leopard")}, new Utils.Pair[]{new Utils.Pair((Object)new Pt(150.0, 100.0), (Object)"Wastrel"), new Utils.Pair((Object)new Pt(350.0, 200.0), (Object)"Attacker")}, false){
        private int editorMessageIndex = 0;
        private int combatMessageIndex = 0;

        @Override
        public TutorialMessage getCombatMessage(UniScreen us) {
            if (this.combatMessageIndex == 0) {
                return new TutorialMessage("MULTISHIP_combatIntro", "OK");
            }
            return new TutorialMessage("MULTISHIP_combatIntro", new String[0]).dontPauseCombat();
        }

        @Override
        public TutorialMessage getEditorMessage(UniScreen us) {
            switch (this.editorMessageIndex) {
                case 0: {
                    return new TutorialMessage("MULTISHIP_editorIntro", "Next");
                }
                case 1: {
                    return new TutorialMessage("MULTISHIP_editorOutro", "Prev", "Start");
                }
            }
            return null;
        }

        @Override
        public void reset(boolean retry) {
            this.editorMessageIndex = 0;
            this.combatMessageIndex = 0;
        }

        @Override
        public void combatButtonPressed(String name) {
            if (name.equals("OK")) {
                ++this.combatMessageIndex;
            }
        }

        @Override
        public void editorButtonPressed(String name) {
            if (name.equals("Next")) {
                ++this.editorMessageIndex;
            }
            if (name.equals("Prev")) {
                --this.editorMessageIndex;
            }
        }
    }
    ,
    DESIGN(false, 1600, true, new String[]{"AMMO", "BRIDGE", "FLAK_CANNON", "DORSAL_TURRET", "CANNON", "FLIPPED_CANNON", "RIFLE", "FLIPPED_RIFLE", "COAL_STORE", "CORRIDOR", "FIRE_POINT", "GRENADES", "FLIPPED_GRENADES", "HATCH", "PROPELLER", "FLIPPED_PROPELLER", "QUARTERS", "REPAIR_BAY", "SUSPENDIUM_CHAMBER"}, 433L, false, new Utils.Pair[]{new Utils.Pair((Object)new Pt(-300.0, 100.0), (Object)"HMS Dragon")}, new Utils.Pair[]{new Utils.Pair((Object)new Pt(150.0, 100.0), (Object)"Wastrel"), new Utils.Pair((Object)new Pt(350.0, 200.0), (Object)"Attacker")}, true){
        private int editorMessageIndex = 0;
        private int combatMessageIndex = 0;

        @Override
        public TutorialMessage getCombatMessage(UniScreen us) {
            if (this.combatMessageIndex == 0) {
                return new TutorialMessage("DESIGN_combatIntro", "OK");
            }
            return null;
        }

        @Override
        public TutorialMessage getEditorMessage(UniScreen us) {
            if (!us.standaloneEditShip.isPathingFullyConnected()) {
                return new TutorialMessage("c_moduleUnreachable2", new String[0]);
            }
            int nWeapons = 0;
            for (Module m : us.standaloneEditShip.modules) {
                if (!m.type.isWeapon()) continue;
                ++nWeapons;
            }
            if (nWeapons > 0 && nWeapons < 4) {
                return new TutorialMessage("DESIGN_moreGuns", new String[0]);
            }
            switch (this.editorMessageIndex) {
                case 0: {
                    return new TutorialMessage("DESIGN_editorIntro", "Start");
                }
            }
            return null;
        }

        @Override
        public boolean checkEditShipReady(Airship ship) {
            for (Module m : ship.modules) {
                if (!m.type.isWeapon()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void reset(boolean retry) {
            this.editorMessageIndex = 0;
            this.combatMessageIndex = 0;
        }

        @Override
        public void combatButtonPressed(String name) {
            if (name.equals("OK")) {
                ++this.combatMessageIndex;
            }
        }

        @Override
        public void editorButtonPressed(String name) {
            if (name.equals("Next")) {
                ++this.editorMessageIndex;
            }
            if (name.equals("Prev")) {
                --this.editorMessageIndex;
            }
        }
    }
    ,
    BOARDING(true, 750, true, new String[]{"BRIDGE", "BARRACKS", "COAL_STORE", "CORRIDOR", "FIRE_POINT", "HATCH", "PROPELLER", "QUARTERS", "REPAIR_BAY", "SUSPENDIUM_CHAMBER"}, 19L, false, new Utils.Pair[]{new Utils.Pair((Object)new Pt(-200.0, 100.0), (Object)"HMS Tesseract")}, new Utils.Pair[]{new Utils.Pair((Object)new Pt(150.0, 100.0), (Object)"Intruder")}, true){
        private int editorMessageIndex = 0;
        private int combatMessageIndex = 0;
        private boolean inited = false;
        private boolean boardCommandGiven = false;

        @Override
        public TutorialMessage getCombatMessage(UniScreen us) {
            if (us.combat.time < 3000) {
                for (Airship b : us.combat.sides.get((int)1).ships) {
                    for (Module m : b.modules) {
                        m.shootAccumulator = 0;
                    }
                }
            }
            if (this.combatMessageIndex == 0) {
                return new TutorialMessage("BOARDING_combatIntro", "OK").highlightBoardButton();
            }
            if (us.combat.sides.get((int)0).ships.isEmpty() || us.combat.sides.get((int)1).ships.isEmpty()) {
                return null;
            }
            Airship me = us.combat.sides.get((int)0).ships.get(0);
            Airship you = us.combat.sides.get((int)1).ships.get(0);
            if (me.board == you) {
                this.boardCommandGiven = true;
            }
            if (!this.boardCommandGiven) {
                return new TutorialMessage("BOARDING_combatIntro", new String[0]).dontPauseCombat();
            }
            if (this.boardCommandGiven && me.readyForCommand()) {
                return new TutorialMessage("BOARDING_nowMove", new String[0]).dontPauseCombat().highlightMoveButton();
            }
            return null;
        }

        @Override
        public boolean checkEditShipReady(Airship ship) {
            for (Module m : ship.modules) {
                if (m.type != ModuleType.ofName("BARRACKS")) continue;
                return true;
            }
            return false;
        }

        @Override
        public TutorialMessage getEditorMessage(UniScreen us) {
            if (!this.inited) {
                us.panel(EditPalettePanel.class).openCategories.clear();
                us.panel(EditPalettePanel.class).openCategories.add(ModuleCategory.ofName("BASIC"));
                us.panel(EditPalettePanel.class).openCategories.add(ModuleCategory.ofName("TROOPS"));
                this.inited = true;
            }
            if (!us.standaloneEditShip.isPathingFullyConnected()) {
                return new TutorialMessage("c_moduleUnreachable2", new String[0]);
            }
            switch (this.editorMessageIndex) {
                case 0: {
                    return new TutorialMessage("BOARDING_editorIntro", "Next");
                }
                case 1: {
                    return new TutorialMessage("BOARDING_editorOutro", "Prev", "Start");
                }
            }
            return null;
        }

        @Override
        public void reset(boolean retry) {
            this.editorMessageIndex = 0;
            this.combatMessageIndex = 0;
            this.inited = false;
            this.boardCommandGiven = false;
        }

        @Override
        public void combatButtonPressed(String name) {
            if (name.equals("OK")) {
                ++this.combatMessageIndex;
            }
        }

        @Override
        public void editorButtonPressed(String name) {
            if (name.equals("Next")) {
                ++this.editorMessageIndex;
            }
            if (name.equals("Prev")) {
                --this.editorMessageIndex;
            }
        }
    }
    ,
    FINAL_TEST(true, 2000, true, new String[]{"AMMO", "BRIDGE", "FLAK_CANNON", "DORSAL_TURRET", "BARRACKS", "CANNON", "RIFLE", "GRENADES", "FLIPPED_CANNON", "FLIPPED_RIFLE", "FLIPPED_GRENADES", "SMALL_KEEL", "LARGE_KEEL", "CROWS_NEST", "COAL_STORE", "CORRIDOR", "FIRE_POINT", "HATCH", "PROPELLER", "QUARTERS", "REPAIR_BAY", "SUSPENDIUM_CHAMBER"}, 90L, false, new Utils.Pair[]{new Utils.Pair((Object)new Pt(-400.0, 100.0), (Object)"HMS Phalanx")}, new Utils.Pair[]{new Utils.Pair((Object)new Pt(150.0, 100.0), (Object)"Invader")}, true){
        private int editorMessageIndex = 0;
        private int combatMessageIndex = 0;

        @Override
        public TutorialMessage getCombatMessage(UniScreen us) {
            if (this.combatMessageIndex == 0) {
                return new TutorialMessage("FINAL_TEST_combatIntro", "OK");
            }
            return null;
        }

        @Override
        public TutorialMessage getEditorMessage(UniScreen us) {
            if (!us.standaloneEditShip.isPathingFullyConnected()) {
                return new TutorialMessage("c_moduleUnreachable2", new String[0]);
            }
            switch (this.editorMessageIndex) {
                case 0: {
                    return new TutorialMessage("FINAL_TEST_editorIntro", "Start");
                }
            }
            return null;
        }

        @Override
        public void reset(boolean retry) {
            this.editorMessageIndex = 0;
            this.combatMessageIndex = 0;
        }

        @Override
        public void combatButtonPressed(String name) {
            if (name.equals("OK")) {
                ++this.combatMessageIndex;
            }
        }

        @Override
        public void editorButtonPressed(String name) {
            if (name.equals("Next")) {
                ++this.editorMessageIndex;
            }
            if (name.equals("Prev")) {
                --this.editorMessageIndex;
            }
        }
    };

    public boolean boardEnabled;
    public boolean hasEditorIntro2;
    public int budget;
    public boolean showEditModeSelectors;
    public HashSet<ModuleType> editTypes = new HashSet();
    public long combatSeed;
    public boolean addRocks;
    public Utils.Pair<Pt, Airship>[] ships;
    public Utils.Pair<Pt, Airship>[] enemies;
    public boolean saveSuccessfulDesign;
    private boolean completed;
    private boolean completedLoaded;
    private final Utils.Pair<Pt, String>[] shipNames;
    private final Utils.Pair<Pt, String>[] enemyNames;
    private final String[] editTypeNames;

    public static void updateTypes() {
        if (Mod.getEnabledMods().isEmpty()) {
            for (Challenge c : Challenge.values()) {
                c.update();
            }
        }
    }

    public boolean isCompleted() {
        this.loadCompleted();
        return this.completed;
    }

    public void complete() {
        if (!this.completed) {
            this.completed = true;
            AirshipGame.PREFS.putBoolean("challenge_" + this.name(), this.completed);
        }
    }

    private void loadCompleted() {
        if (!this.completedLoaded) {
            this.completed = AirshipGame.PREFS.getBoolean("challenge_" + this.name(), false);
            this.completedLoaded = true;
        }
    }

    public abstract TutorialMessage getCombatMessage(UniScreen var1);

    public abstract TutorialMessage getEditorMessage(UniScreen var1);

    public abstract void reset(boolean var1);

    public abstract void combatButtonPressed(String var1);

    public abstract void editorButtonPressed(String var1);

    public boolean checkEditShipReady(Airship ship) {
        return true;
    }

    private Challenge(boolean boardEnabled, int budget, boolean showEditModeSelectors, String[] editTypeNames, long combatSeed, boolean addRocks, Utils.Pair<Pt, String>[] ships, Utils.Pair<Pt, String>[] enemies, boolean saveSuccessfulDesign) {
        this.boardEnabled = boardEnabled;
        this.budget = budget;
        this.showEditModeSelectors = showEditModeSelectors;
        this.editTypeNames = editTypeNames;
        this.combatSeed = combatSeed;
        this.addRocks = addRocks;
        this.shipNames = ships;
        this.enemyNames = enemies;
        this.saveSuccessfulDesign = saveSuccessfulDesign;
    }

    private void update() {
        File f;
        int i;
        this.enemies = new Utils.Pair[this.enemyNames.length];
        this.ships = new Utils.Pair[this.shipNames.length];
        for (i = 0; i < this.shipNames.length; ++i) {
            Utils.Pair<Pt, String> sh = this.shipNames[i];
            try {
                f = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "challengeShips"), (String)sh.b + ".json");
                Airship ship = new Airship(new JSONObject(FileUtils.readFileToString((File)f, (String)"UTF-8")));
                ship.repair();
                this.ships[i] = new Utils.Pair(sh.a, (Object)ship);
                continue;
            }
            catch (Exception e) {
                AirshipGame.instance.reportError("Unable to load challenge ship.", e, null, true);
            }
        }
        for (i = 0; i < this.enemyNames.length; ++i) {
            Utils.Pair<Pt, String> en = this.enemyNames[i];
            try {
                f = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "challengeShips"), (String)en.b + ".json");
                Airship eSh = new Airship(new JSONObject(FileUtils.readFileToString((File)f, (String)"UTF-8")));
                eSh.repair();
                this.enemies[i] = new Utils.Pair(en.a, (Object)eSh);
                continue;
            }
            catch (Exception e) {
                AirshipGame.instance.reportError("Unable to load challenge ship.", e, null, true);
            }
        }
        this.editTypes.clear();
        for (String n : this.editTypeNames) {
            this.editTypes.add(ModuleType.ofName(n));
        }
    }

    public void report(String type) {
        Analytics.report(type, this);
    }
}

