/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp abstract class BonusableValue<T> {
    public abstract T get(BonusSet var1);

    public List<BonusSet> getBonusesIfAvailable() {
        return Collections.emptyList();
    }

    public static <T> BonusableValue<T> of(T value) {
        return new NoBonus(value);
    }

    public static <F, T> Derive<ArrayList<F>, ArrayList<T>> list(Derive<F, T> inner) {
        return new DeriveList<F, T>(inner);
    }

    public static <F, T> BonusableValue<T> derive(BonusableValue<F> from, Derive<F, T> d) {
        if (from == null) {
            throw new NullPointerException("from");
        }
        if (d == null) {
            throw new NullPointerException("d");
        }
        if (from instanceof NoBonus) {
            return new NoBonus(d.derive(from.get(BonusSet.empty())));
        }
        if (from instanceof ObjectVariantBonus) {
            ObjectVariantBonus ovb = (ObjectVariantBonus)from;
            ArrayList<T> deriveds = new ArrayList<T>();
            for (Object f : ovb.objects) {
                deriveds.add(d.derive(f));
            }
            return new ObjectVariantBonus<T>(d.derive(ovb.base), ovb.bs, ovb.bonusOrdinals, deriveds);
        }
        if (from instanceof SingleBonus) {
            SingleBonus sb = (SingleBonus)from;
            return new SingleBonus(d.derive(sb.get(BonusSet.empty())), sb.bonus, d.derive(sb.bonused));
        }
        return new RuntimeDerivingBonus<F, T>(from, d);
    }

    public static <T> BonusableValue<T> objectFromJSONRequired(JSONObject o, String key, FromJSON<T> fj) {
        if (o.has(key)) {
            if (o.getJSONObject(key).has("base")) {
                return BonusableValue.objectFromJSON(o.getJSONObject(key), fj);
            }
            return BonusableValue.of(fj.construct(o.getJSONObject(key), BonusSet.empty()));
        }
        throw new RuntimeException("Missing " + key + ".");
    }

    public static <T> BonusableValue<ArrayList<T>> listFromJSON(JSONObject o, String key, ArrayList<T> def, FromJSON<T> fj) {
        return BonusableValue.listFromJSON(o, key, def, fj, false);
    }

    public static <T> BonusableValue<ArrayList<T>> listFromJSONRequired(JSONObject o, String key, FromJSON<T> fj) {
        return BonusableValue.listFromJSON(o, key, null, fj, true);
    }

    private static <T> BonusableValue<ArrayList<T>> listFromJSON(JSONObject o, String key, ArrayList<T> def, FromJSON<T> fj, boolean required) {
        if (o.has(key)) {
            try {
                JSONObject o2 = o.getJSONObject(key);
                ArrayList<T> base = BonusableValue.listFromJSON(o2.getJSONArray("base"), fj, BonusSet.empty());
                if (o2.has("cases")) {
                    JSONArray cases = o.getJSONArray("cases");
                    ArrayList<BonusSet> sets = new ArrayList<BonusSet>();
                    ArrayList<ArrayList<T>> objects = new ArrayList<ArrayList<T>>();
                    for (int i = 0; i < cases.length(); ++i) {
                        JSONObject caze = cases.getJSONObject(i);
                        BonusSet bs = BonusableValue.set(caze.getJSONArray("bonuses"));
                        sets.add(bs);
                        objects.add(BonusableValue.listFromJSON(caze.getJSONArray("value"), fj, bs));
                    }
                    return new SetBonus<ArrayList<T>>(base, sets, objects);
                }
                ArrayList<Integer> bl = new ArrayList<Integer>();
                ArrayList<ArrayList<T>> tl = new ArrayList<ArrayList<T>>();
                BonusSet bs = new BonusSet();
                for (Bonus b : Bonus.values()) {
                    if (!o.has(b.name())) continue;
                    bl.add(b.ordinal());
                    tl.add(BonusableValue.listFromJSON(o.getJSONArray(b.name()), fj, new BonusSet(b)));
                    bs.add(b);
                }
                return new ObjectVariantBonus<ArrayList<T>>(base, bs, bl, tl);
            }
            catch (Exception e) {
                JSONArray a = o.getJSONArray(key);
                return BonusableValue.of(BonusableValue.listFromJSON(a, fj, BonusSet.empty()));
            }
        }
        if (required) {
            throw new RuntimeException("Missing " + key + ".");
        }
        return BonusableValue.of(def);
    }

    public static <T> ArrayList<T> listFromJSON(JSONArray a, FromJSON<T> fj, BonusSet b) {
        ArrayList<T> l = new ArrayList<T>();
        for (int i = 0; i < a.length(); ++i) {
            l.add(fj.construct(a.getJSONObject(i), b));
        }
        return l;
    }

    public static <T> BonusableValue<T> objectFromJSON(JSONObject o, String key, T def, FromJSON<T> fj) {
        if (o.has(key)) {
            if (o.getJSONObject(key).has("base")) {
                return BonusableValue.objectFromJSON(o.getJSONObject(key), fj);
            }
            return BonusableValue.of(fj.construct(o.getJSONObject(key), BonusSet.empty()));
        }
        return BonusableValue.of(def);
    }

    private static BonusSet set(JSONArray a) {
        BonusSet bs = new BonusSet();
        for (int i = 0; i < a.length(); ++i) {
            bs.add(Bonus.ofName(a.getString(i)));
        }
        return bs;
    }

    public static <T> BonusableValue<T> objectFromJSON(JSONObject o, FromJSON<T> fj) {
        T base = fj.construct(o.getJSONObject("base"), BonusSet.empty());
        if (o.has("cases")) {
            JSONArray cases = o.getJSONArray("cases");
            ArrayList<BonusSet> sets = new ArrayList<BonusSet>();
            ArrayList<T> objects = new ArrayList<T>();
            for (int i = 0; i < cases.length(); ++i) {
                JSONObject caze = cases.getJSONObject(i);
                BonusSet bs = BonusableValue.set(caze.getJSONArray("bonuses"));
                sets.add(bs);
                objects.add(fj.construct(caze.getJSONObject("value"), bs));
            }
            return new SetBonus<T>(base, sets, objects);
        }
        ArrayList<Integer> bl = new ArrayList<Integer>();
        ArrayList<T> tl = new ArrayList<T>();
        BonusSet bs = new BonusSet();
        for (Bonus b : Bonus.values()) {
            if (!o.has(b.name())) continue;
            bl.add(b.ordinal());
            tl.add(fj.construct(o.getJSONObject(b.name()), new BonusSet(b)));
            bs.add(b);
        }
        return new ObjectVariantBonus<T>(base, bs, bl, tl);
    }

    public static <T extends Loadable> BonusableValue<T> loadableFromJSON(JSONObject o, String key, T def, Class<T> clazz) {
        if (o.has(key)) {
            try {
                return BonusableValue.of(Loadable.ofName(clazz, o.getString(key)));
            }
            catch (Exception e) {
                return BonusableValue.loadableFromJSON(o.getJSONObject(key), clazz);
            }
        }
        return BonusableValue.of(def);
    }

    public static <T extends Loadable> BonusableValue<T> loadableFromJSON(JSONObject o, Class<T> clazz) {
        T base = Loadable.ofName(clazz, o.getString("base"));
        if (o.has("cases")) {
            JSONArray cases = o.getJSONArray("cases");
            ArrayList<BonusSet> sets = new ArrayList<BonusSet>();
            ArrayList<T> objects = new ArrayList<T>();
            for (int i = 0; i < cases.length(); ++i) {
                JSONObject caze = cases.getJSONObject(i);
                BonusSet bs = BonusableValue.set(caze.getJSONArray("bonuses"));
                sets.add(bs);
                objects.add(Loadable.ofName(clazz, caze.getString("value")));
            }
            return new SetBonus<T>(base, sets, objects);
        }
        ArrayList<Integer> bl = new ArrayList<Integer>();
        ArrayList<T> tl = new ArrayList<T>();
        BonusSet bs = new BonusSet();
        for (Bonus b : Bonus.values()) {
            if (!o.has(b.name())) continue;
            bl.add(b.ordinal());
            tl.add(Loadable.ofName(clazz, o.getString(b.name())));
            bs.add(b);
        }
        return new ObjectVariantBonus<T>(base, bs, bl, tl);
    }

    public static BonusableValue<Integer> intFromJSON(JSONObject o, String key, int def) {
        return BonusableValue.intFromJSONWithDivAndMinAndMax(o, key, def, 1, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static BonusableValue<Integer> intFromJSONWithDivAndMinAndMax(JSONObject o, String key, int def, int div, int min, int max) {
        if (o.has(key)) {
            if (o.get(key) instanceof Number) {
                return new NoBonus<Integer>(StrictMath.min(max, StrictMath.max(min, o.getInt(key) / div)));
            }
            if (o.get(key) instanceof JSONObject) {
                return BonusableValue.intFromJSON(o.getJSONObject(key), div, min, max);
            }
        }
        return new NoBonus<Integer>(def);
    }

    public static BonusableValue<Integer> intFromJSON(JSONObject o, int div, int min, int max) {
        if (o.has("deltas")) {
            JSONObject deltas = o.getJSONObject("deltas");
            ArrayList<Bonus> bonuses = new ArrayList<Bonus>();
            ArrayList<Integer> bDeltas = new ArrayList<Integer>();
            for (Bonus b : Bonus.values()) {
                if (!deltas.has(b.name())) continue;
                bonuses.add(b);
                bDeltas.add(deltas.getInt(b.name()) / div);
            }
            int[] ordinals = new int[bonuses.size()];
            int[] bonusDeltas = new int[bonuses.size()];
            for (int i = 0; i < ordinals.length; ++i) {
                ordinals[i] = ((Bonus)bonuses.get(i)).ordinal();
                bonusDeltas[i] = (Integer)bDeltas.get(i);
            }
            return new IntDeltaBonus(o.getInt("base") / div, ordinals, bonusDeltas, min, max);
        }
        if (o.has("cases")) {
            int base = Math.max(min, Math.min(max, o.getInt("base") / div));
            JSONArray cases = o.getJSONArray("cases");
            ArrayList<BonusSet> sets = new ArrayList<BonusSet>();
            ArrayList<Integer> objects = new ArrayList<Integer>();
            for (int i = 0; i < cases.length(); ++i) {
                JSONObject caze = cases.getJSONObject(i);
                BonusSet bs = BonusableValue.set(caze.getJSONArray("bonuses"));
                sets.add(bs);
                objects.add(Math.max(min, Math.min(max, caze.getInt("value") / div)));
            }
            return new SetBonus<Integer>(base, sets, objects);
        }
        for (Bonus b : Bonus.values()) {
            if (!o.has(b.name())) continue;
            return new SingleBonus<Integer>(StrictMath.min(max, StrictMath.max(min, o.getInt("base") / div)), b, StrictMath.min(max, StrictMath.max(min, o.getInt(b.name()) / div)));
        }
        return new NoBonus<Integer>(StrictMath.min(max, StrictMath.max(min, o.getInt("base") / div)));
    }

    public static BonusableValue<Double> doubleFromJSON(JSONObject o, String key, double def) {
        if (o.has(key)) {
            if (o.get(key) instanceof Number) {
                return new NoBonus<Double>(o.getDouble(key));
            }
            if (o.get(key) instanceof JSONObject) {
                return BonusableValue.doubleFromJSON(o.getJSONObject(key));
            }
        }
        return new NoBonus<Double>(def);
    }

    public static BonusableValue<Double> doubleFromJSON(JSONObject o) {
        if (o.has("deltas")) {
            JSONObject deltas = o.getJSONObject("deltas");
            ArrayList<Bonus> bonuses = new ArrayList<Bonus>();
            ArrayList<Double> bDeltas = new ArrayList<Double>();
            for (Bonus b : Bonus.values()) {
                if (!deltas.has(b.name())) continue;
                bonuses.add(b);
                bDeltas.add(deltas.getDouble(b.name()));
            }
            int[] ordinals = new int[bonuses.size()];
            double[] bonusDeltas = new double[bonuses.size()];
            for (int i = 0; i < ordinals.length; ++i) {
                ordinals[i] = ((Bonus)bonuses.get(i)).ordinal();
                bonusDeltas[i] = (Double)bDeltas.get(i);
            }
            return new DoubleDeltaBonus(o.getDouble("base"), ordinals, bonusDeltas);
        }
        if (o.has("cases")) {
            double base = o.getDouble("base");
            JSONArray cases = o.getJSONArray("cases");
            ArrayList<BonusSet> sets = new ArrayList<BonusSet>();
            ArrayList<Double> objects = new ArrayList<Double>();
            for (int i = 0; i < cases.length(); ++i) {
                JSONObject caze = cases.getJSONObject(i);
                BonusSet bs = BonusableValue.set(caze.getJSONArray("bonuses"));
                sets.add(bs);
                objects.add(caze.getDouble("value"));
            }
            return new SetBonus<Double>(base, sets, objects);
        }
        for (Bonus b : Bonus.values()) {
            if (!o.has(b.name())) continue;
            return new SingleBonus<Double>(o.getDouble("base"), b, o.getDouble(b.name()));
        }
        return new NoBonus<Double>(o.getDouble("base"));
    }

    public static BonusableValue<Boolean> booleanFromJSON(JSONObject o, String key, boolean def) {
        if (o.has(key)) {
            if (o.get(key) instanceof Boolean) {
                return new NoBonus<Boolean>(o.getBoolean(key));
            }
            if (o.get(key) instanceof JSONObject) {
                return BonusableValue.booleanFromJSON(o.getJSONObject(key));
            }
        }
        return new NoBonus<Boolean>(def);
    }

    public static BonusableValue<Boolean> booleanFromJSON(JSONObject o) {
        for (Bonus b : Bonus.values()) {
            if (!o.has(b.name())) continue;
            return new SingleBonus<Boolean>(o.getBoolean("base"), b, o.getBoolean(b.name()));
        }
        return new NoBonus<Boolean>(o.getBoolean("base"));
    }

    public strictfp static class ClrFromJSON
    implements FromJSON<Clr> {
        @Override
        public Clr construct(JSONObject co, BonusSet b) {
            return new Clr(co.getInt("r"), co.getInt("g"), co.getInt("b"), co.optInt("a", 255));
        }
    }

    public static interface FromJSON<T> {
        public T construct(JSONObject var1, BonusSet var2);
    }

    private strictfp static final class SetBonus<T>
    extends BonusableValue<T> {
        private final T base;
        private final ArrayList<BonusSet> sets;
        private final ArrayList<T> objects;

        public SetBonus(T base, ArrayList<BonusSet> sets, ArrayList<T> objects) {
            this.base = base;
            this.sets = sets;
            this.objects = objects;
        }

        @Override
        public T get(BonusSet bonuses) {
            for (int i = 0; i < this.sets.size(); ++i) {
                if (!bonuses.containsAll(this.sets.get(i))) continue;
                return this.objects.get(i);
            }
            return this.base;
        }

        @Override
        public List<BonusSet> getBonusesIfAvailable() {
            return this.sets;
        }
    }

    private strictfp static final class ObjectVariantBonus<T>
    extends BonusableValue<T> {
        private final ArrayList<Integer> bonusOrdinals;
        private final ArrayList<T> objects;
        private final T base;
        private final BonusSet bs;

        public ObjectVariantBonus(T base, BonusSet bs, ArrayList<Integer> bonusOrdinals, ArrayList<T> objects) {
            this.base = base;
            this.bonusOrdinals = bonusOrdinals;
            this.objects = objects;
            this.bs = bs;
        }

        @Override
        public T get(BonusSet bonuses) {
            for (int i = 0; i < this.bonusOrdinals.size(); ++i) {
                if (!bonuses.contains[this.bonusOrdinals.get(i)]) continue;
                return this.objects.get(i);
            }
            return this.base;
        }

        @Override
        public List<BonusSet> getBonusesIfAvailable() {
            ArrayList<BonusSet> list = new ArrayList<BonusSet>();
            for (Bonus b : this.bs.list()) {
                list.add(new BonusSet(b));
            }
            return list;
        }
    }

    private strictfp static final class RuntimeDerivingBonus<F, T>
    extends BonusableValue<T> {
        private final BonusableValue<F> wrapped;
        private final Derive<F, T> d;

        public RuntimeDerivingBonus(BonusableValue<F> wrapped, Derive<F, T> d) {
            this.wrapped = wrapped;
            this.d = d;
        }

        @Override
        public T get(BonusSet bonuses) {
            return this.d.derive(this.wrapped.get(bonuses));
        }

        @Override
        public List<BonusSet> getBonusesIfAvailable() {
            return this.wrapped.getBonusesIfAvailable();
        }
    }

    private strictfp static class DeriveList<F, T>
    implements Derive<ArrayList<F>, ArrayList<T>> {
        private final Derive<F, T> inner;

        public DeriveList(Derive<F, T> inner) {
            this.inner = inner;
        }

        @Override
        public ArrayList<T> derive(ArrayList<F> from) {
            ArrayList<T> tl = new ArrayList<T>();
            for (F f : from) {
                tl.add(this.inner.derive(f));
            }
            return tl;
        }
    }

    public static interface Derive<F, T> {
        public T derive(F var1);
    }

    private strictfp static final class DoubleDeltaBonus
    extends BonusableValue<Double> {
        private final double base;
        private final int[] bonusOrdinals;
        private final double[] bonusDeltas;

        @Override
        public Double get(BonusSet bonuses) {
            double value = this.base;
            for (int i = 0; i < this.bonusOrdinals.length; ++i) {
                if (!bonuses.contains[this.bonusOrdinals[i]]) continue;
                value += this.bonusDeltas[i];
            }
            return value;
        }

        private DoubleDeltaBonus(double base, int[] bonusOrdinals, double[] bonusDeltas) {
            this.base = base;
            this.bonusOrdinals = bonusOrdinals;
            this.bonusDeltas = bonusDeltas;
        }
    }

    private strictfp static final class IntDeltaBonus
    extends BonusableValue<Integer> {
        private final int base;
        private final int min;
        private final int max;
        private final int[] bonusOrdinals;
        private final int[] bonusDeltas;

        @Override
        public Integer get(BonusSet bonuses) {
            int value = this.base;
            for (int i = 0; i < this.bonusOrdinals.length; ++i) {
                if (!bonuses.contains[this.bonusOrdinals[i]]) continue;
                value += this.bonusDeltas[i];
            }
            return StrictMath.min(this.max, StrictMath.max(this.min, value));
        }

        private IntDeltaBonus(int base, int[] bonusOrdinals, int[] bonusDeltas, int min, int max) {
            this.base = base;
            this.min = min;
            this.max = max;
            this.bonusOrdinals = bonusOrdinals;
            this.bonusDeltas = bonusDeltas;
        }
    }

    private strictfp static final class SingleBonus<T>
    extends BonusableValue<T> {
        private final T base;
        private final T bonused;
        private final Bonus bonus;

        @Override
        public T get(BonusSet bonuses) {
            return bonuses.contains[this.bonus.ordinal()] ? this.bonused : this.base;
        }

        private SingleBonus(T base, Bonus bonus, T bonused) {
            this.base = base;
            this.bonused = bonused;
            this.bonus = bonus;
        }

        @Override
        public List<BonusSet> getBonusesIfAvailable() {
            return Collections.singletonList(new BonusSet(this.bonus));
        }
    }

    private strictfp static final class NoBonus<T>
    extends BonusableValue<T> {
        private final T value;

        private NoBonus(T value) {
            this.value = value;
        }

        @Override
        public T get(BonusSet bonuses) {
            return this.value;
        }
    }
}

