/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.Loadable;
import java.util.ArrayList;

public strictfp class BonusSet {
    private static BonusSet EMPTY = new BonusSet();
    public final boolean[] contains = new boolean[Loadable.all(Bonus.class).size()];

    public static void resetCount() {
        EMPTY = null;
    }

    public static BonusSet empty() {
        if (EMPTY == null) {
            EMPTY = new BonusSet();
        }
        return EMPTY;
    }

    public BonusSet() {
    }

    public BonusSet(Bonus ... boni) {
        for (int i = 0; i < boni.length; ++i) {
            this.contains[boni[i].ordinal()] = true;
        }
    }

    public ArrayList<Bonus> list() {
        ArrayList<Bonus> l = new ArrayList<Bonus>();
        for (Bonus b : Loadable.all(Bonus.class)) {
            if (!this.contains[b.ordinal()]) continue;
            l.add(b);
        }
        return l;
    }

    public boolean containsAll(BonusSet set) {
        for (int i = 0; i < this.contains.length; ++i) {
            if (this.contains[i] || !set.contains[i]) continue;
            return false;
        }
        return true;
    }

    public void add(Bonus b) {
        this.contains[b.ordinal()] = true;
    }

    public void clear() {
        for (int i = 0; i < this.contains.length; ++i) {
            this.contains[i] = false;
        }
    }

    public void addAll(BonusSet bs2) {
        for (int i = 0; i < this.contains.length; ++i) {
            int n = i;
            this.contains[n] = this.contains[n] | bs2.contains[i];
        }
    }

    public void removeAll(BonusSet bs2) {
        for (int i = 0; i < this.contains.length; ++i) {
            if (!bs2.contains[i]) continue;
            this.contains[i] = false;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof BonusSet)) {
            return false;
        }
        BonusSet s2 = (BonusSet)o;
        for (int i = 0; i < this.contains.length; ++i) {
            if (this.contains[i] == s2.contains[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int code = 0;
        for (int i = 0; i < this.contains.length; ++i) {
            if (this.contains[i]) {
                code += i;
            }
            code *= 37;
        }
        return code;
    }

    public BonusSet clone() {
        BonusSet s2 = new BonusSet();
        System.arraycopy(this.contains, 0, s2.contains, 0, this.contains.length);
        return s2;
    }
}

