/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.FileNameComparator;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Mod;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.json.JSONException;
import org.json.JSONObject;

public strictfp class Bonus
extends Loadable {
    private int ordinal = -1;
    private final ArrayList<Airship> enabledSpecialConstructions = new ArrayList();
    public final boolean standard;
    public static BonusSet standardSet = new BonusSet();

    public Bonus(JSONObject o) {
        super(o.getString("name"));
        this.standard = o.optBoolean("standard", false);
        BonusSet.resetCount();
    }

    public static void postLoad2() {
        standardSet = new BonusSet();
        for (Bonus b : Loadable.all(Bonus.class)) {
            if (b.standard) {
                standardSet.add(b);
            }
            b.enabledSpecialConstructions.clear();
            HashMap<String, Airship> byFileName = new HashMap<String, Airship>();
            File dir = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "bonusConstructions"), b.name());
            File[] fs = dir.listFiles();
            if (fs != null) {
                Arrays.sort(fs, new FileNameComparator());
                for (File f : fs) {
                    if (f.getName().startsWith(".") || !f.getName().endsWith(".json")) continue;
                    try {
                        Airship s = new Airship(new JSONObject(FileUtils.readFileToString((File)f, (String)"UTF-8")));
                        s.isBonusConstruction = true;
                        byFileName.put(f.getName(), s);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
            for (Mod m : Mod.getEnabledMods()) {
                dir = new File(new File(m.dir, "bonusConstructions"), b.name());
                fs = dir.listFiles();
                if (fs == null) continue;
                Arrays.sort(fs, new FileNameComparator());
                for (File f : fs) {
                    if (f.getName().startsWith(".") || !f.getName().endsWith(".json")) continue;
                    try {
                        Airship s = new Airship(new JSONObject(FileUtils.readFileToString((File)f, (String)"UTF-8")));
                        s.isBonusConstruction = true;
                        byFileName.put(f.getName(), s);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
            ArrayList keys = new ArrayList(byFileName.keySet());
            Collections.sort(keys);
            for (String k : keys) {
                b.enabledSpecialConstructions.add((Airship)byFileName.get(k));
            }
        }
    }

    public ArrayList<Airship> getEnabledSpecialConstructions() {
        return this.enabledSpecialConstructions;
    }

    public String name() {
        return this.name;
    }

    public int ordinal() {
        if (this.ordinal == -1) {
            this.ordinal = Loadable.all(Bonus.class).indexOf(this);
        }
        return this.ordinal;
    }

    public static ArrayList<Bonus> values() {
        return Loadable.all(Bonus.class);
    }

    public static Bonus ofName(String name) {
        return Loadable.ofName(Bonus.class, name);
    }

    public static Bonus ofNameOrNone(String name) {
        if (Loadable.hasOfName(Bonus.class, name)) {
            return Bonus.ofName(name);
        }
        return Bonus.ofName("NO_BONUS");
    }

    public static Bonus ofNameOrNull(String name) {
        if (Loadable.hasOfName(Bonus.class, name)) {
            return Bonus.ofName(name);
        }
        return null;
    }

    public String getName() {
        return Lang._t("bonus_" + this.name, new Object[0]);
    }

    public String getDesc() {
        return Lang._tWithFallback("bonus_" + this.name + "_desc", "bonus_" + this.name, new Object[0]);
    }
}

