/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.LandFormation;
import java.util.ArrayList;
import java.util.LinkedList;

public strictfp class BodyPathing {
    public static final int NO_LINK = Integer.MAX_VALUE;
    public static final int CANNOT_HOOK = -1;
    public int[][] jumpMatrix;
    public int[][] hookMatrix;
    private int[] distFlood;
    private int lastUpdated = -1;

    public void update(Combat c) {
        if (c.physics == null) {
            return;
        }
        if (this.jumpMatrix == null || this.jumpMatrix.length != c.physics.bodies.size()) {
            this.jumpMatrix = new int[c.physics.bodies.size()][c.physics.bodies.size()];
            this.hookMatrix = new int[c.physics.bodies.size()][c.physics.bodies.size()];
            this.distFlood = new int[c.physics.bodies.size()];
            this.lastUpdated = c.time - 1;
        }
        if (c.time == this.lastUpdated) {
            return;
        }
        this.lastUpdated = c.time;
        for (int fromIndex = 0; fromIndex < this.jumpMatrix.length; ++fromIndex) {
            int toIndex;
            Body fromBody = c.physics.bodies.get(fromIndex);
            if (!(fromBody instanceof GridBody)) {
                for (toIndex = 0; toIndex < this.jumpMatrix.length; ++toIndex) {
                    this.jumpMatrix[fromIndex][toIndex] = Integer.MAX_VALUE;
                    this.hookMatrix[fromIndex][toIndex] = Integer.MAX_VALUE;
                }
                continue;
            }
            for (toIndex = 0; toIndex < this.jumpMatrix.length; ++toIndex) {
                if (toIndex == fromIndex) {
                    this.jumpMatrix[fromIndex][toIndex] = Integer.MAX_VALUE;
                    this.hookMatrix[fromIndex][toIndex] = Integer.MAX_VALUE;
                    continue;
                }
                Body toBody = c.physics.bodies.get(toIndex);
                if (toBody instanceof GridBody) {
                    this.jumpMatrix[fromIndex][toIndex] = this.jumpPathValue((GridBody)fromBody, (GridBody)toBody);
                    this.hookMatrix[fromIndex][toIndex] = this.hookPathValue((GridBody)fromBody, (GridBody)toBody);
                    continue;
                }
                this.jumpMatrix[fromIndex][toIndex] = Integer.MAX_VALUE;
                this.hookMatrix[fromIndex][toIndex] = Integer.MAX_VALUE;
            }
        }
    }

    public int jumpPathValue(GridBody from, GridBody to) {
        double yDelta;
        double xDist = to.getX() > from.getX() + from.getBBWidth() ? to.getX() - from.getX() - from.getBBWidth() : (from.getX() > to.getX() + to.getBBWidth() ? from.getX() - to.getX() - to.getBBWidth() : 0.0);
        double toY = to.getY();
        if (to instanceof LandFormation && to.isImmobile()) {
            LandFormation ground = (LandFormation)to;
            toY = ground.getY() + ground.getBBHeight();
            for (double wx = from.getX(); wx < from.getX() + from.getBBWidth(); wx += 16.0) {
                toY = StrictMath.min(toY, ground.yBoundaryAt(wx));
            }
        }
        if (from instanceof Airship && ((Airship)from).lastGrounded == to && ((Airship)from).msSinceOnGround < 100) {
            return 1;
        }
        if (to instanceof Airship && ((Airship)to).lastGrounded == from && ((Airship)to).msSinceOnGround < 100) {
            return 1;
        }
        double d = toY > from.getY() + from.getBBHeight() ? toY - from.getY() - from.getBBHeight() : (yDelta = from.getY() > toY + to.getBBHeight() ? toY + to.getBBHeight() - from.getY() : 0.0);
        if (yDelta >= 0.0 && yDelta < 120.0) {
            return (int)xDist;
        }
        return Integer.MAX_VALUE;
    }

    public int hookPathValue(GridBody from, GridBody to) {
        if (to.isImmobile()) {
            return Integer.MAX_VALUE;
        }
        double xDist = to.getX() > from.getX() + from.getBBWidth() ? to.getX() - from.getX() - from.getBBWidth() : (from.getX() > to.getX() + to.getBBWidth() ? from.getX() - to.getX() - to.getBBWidth() : 0.0);
        double toY = to.getY();
        double yDelta = toY > from.getY() + from.getBBHeight() ? toY - from.getY() - from.getBBHeight() : (from.getY() > toY + to.getBBHeight() ? toY + to.getBBHeight() - from.getY() : 0.0);
        return (int)(xDist + StrictMath.abs(yDelta) - 16.0);
    }

    public boolean connected(GridBody src, GridBody trg, int jumpDist, int hookDist, Combat c) {
        this.update(c);
        int trgIndex = c.physics.bodies.indexOf(trg);
        if (trgIndex == -1) {
            return false;
        }
        int srcIndex = c.physics.bodies.indexOf(src);
        if (srcIndex == -1) {
            return false;
        }
        return this.jumpMatrix[srcIndex][trgIndex] <= jumpDist || this.hookMatrix[srcIndex][trgIndex] <= hookDist;
    }

    public GridBody getNextInPath(GridBody src, GridBody trg, int jumpDist, int hookDist, Combat c) {
        this.update(c);
        for (int i = 0; i < this.distFlood.length; ++i) {
            this.distFlood[i] = Integer.MAX_VALUE;
        }
        int trgIndex = c.physics.bodies.indexOf(trg);
        if (trgIndex == -1) {
            return null;
        }
        int srcIndex = c.physics.bodies.indexOf(src);
        if (srcIndex == -1) {
            return null;
        }
        this.distFlood[trgIndex] = 0;
        LinkedList<Integer> q = new LinkedList<Integer>();
        q.add(trgIndex);
        while (this.distFlood[srcIndex] == Integer.MAX_VALUE && !q.isEmpty()) {
            int to = (Integer)q.pollFirst();
            for (int from = 0; from < this.jumpMatrix.length; ++from) {
                if (this.jumpMatrix[from][to] > jumpDist && this.hookMatrix[from][to] > hookDist || this.distFlood[from] <= this.distFlood[to] + 1) continue;
                this.distFlood[from] = this.distFlood[to] + 1;
                q.add(from);
            }
        }
        if (this.distFlood[srcIndex] != Integer.MAX_VALUE) {
            for (int nextHopCandidate = 0; nextHopCandidate < this.jumpMatrix[srcIndex].length; ++nextHopCandidate) {
                if (this.distFlood[nextHopCandidate] >= this.distFlood[srcIndex] || this.jumpMatrix[srcIndex][nextHopCandidate] > jumpDist && this.hookMatrix[srcIndex][nextHopCandidate] > hookDist) continue;
                return (GridBody)c.physics.bodies.get(nextHopCandidate);
            }
        }
        return null;
    }

    public ArrayList<GridBody> getPath(GridBody src, GridBody trg, int jumpDist, int hookDist, Combat c) {
        this.update(c);
        for (int i = 0; i < this.distFlood.length; ++i) {
            this.distFlood[i] = Integer.MAX_VALUE;
        }
        int trgIndex = c.physics.bodies.indexOf(trg);
        if (trgIndex == -1) {
            return null;
        }
        int srcIndex = c.physics.bodies.indexOf(src);
        if (srcIndex == -1) {
            return null;
        }
        this.distFlood[trgIndex] = 0;
        LinkedList<Integer> q = new LinkedList<Integer>();
        q.add(trgIndex);
        while (this.distFlood[srcIndex] == Integer.MAX_VALUE && !q.isEmpty()) {
            int to = (Integer)q.pollFirst();
            for (int from = 0; from < this.jumpMatrix.length; ++from) {
                if (this.jumpMatrix[from][to] > jumpDist && this.hookMatrix[from][to] > hookDist || this.distFlood[from] <= this.distFlood[to] + 1) continue;
                this.distFlood[from] = this.distFlood[to] + 1;
                q.add(from);
            }
        }
        if (this.distFlood[srcIndex] != Integer.MAX_VALUE) {
            ArrayList<GridBody> l = new ArrayList<GridBody>();
            int pathI = srcIndex;
            block3: while (pathI != trgIndex) {
                for (int nextHopCandidate = 0; nextHopCandidate < this.jumpMatrix[pathI].length; ++nextHopCandidate) {
                    if (this.distFlood[nextHopCandidate] >= this.distFlood[pathI] || this.jumpMatrix[pathI][nextHopCandidate] > jumpDist && this.hookMatrix[pathI][nextHopCandidate] > hookDist) continue;
                    l.add((GridBody)c.physics.bodies.get(nextHopCandidate));
                    pathI = nextHopCandidate;
                    continue block3;
                }
            }
            return l;
        }
        return null;
    }
}

