/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public strictfp class BoardingStatusChrome
implements UniScreen.ShipChrome {
    public static Clr BOARDING_FRIENDLY = Clr.fromHex((String)"6e9511");
    public static Clr BOARDING_ENEMY = Clr.fromHex((String)"bb421d");
    public static Clr BOARDING_FRIENDLY_OUTLINE = Clr.fromHex((String)"e7e0a9");
    public static Clr BOARDING_ENEMY_OUTLINE = Clr.fromHex((String)"e7e0a9");
    public static Img BOARDER_ICON = new Img("ui", 416, 432, 16, 16, false);
    public static Img BOARDER_ICON_OUTLINE = new Img("ui", 368, 432, 16, 16, false);
    public static Img DEFENDER_ICON = new Img("ui", 384, 432, 16, 16, false);
    public static Img DEFENDER_ICON_OUTLINE = new Img("ui", 400, 432, 16, 16, false);

    private static double cx(Crewman c, Airship ship, int x, UniScreen us) {
        double tx = ship.gridXToWorldX(c.currentTile.x, 1) * 16 + 8;
        Tile t2 = c.movingTowards;
        if (t2 != null) {
            tx = ship.flipped ? (tx -= (double)(t2.x - c.currentTile.x) * 1.0 * (double)c.msSinceMoved / (double)c.currentTile.getMoveDelay() * c.speed(t2) * 16.0) : (tx += (double)(t2.x - c.currentTile.x) * 1.0 * (double)c.msSinceMoved / (double)c.currentTile.getMoveDelay() * c.speed(t2) * 16.0);
        }
        return (double)x + tx * us.zoom - 8.0;
    }

    private static double cy(Crewman c, Airship ship, int y, UniScreen us) {
        double ty = c.currentTile.y * 16;
        Tile t2 = c.movingTowards;
        if (t2 != null) {
            ty += (double)(t2.y - c.currentTile.y) * 1.0 * (double)c.msSinceMoved / (double)c.currentTile.getMoveDelay() * c.speed(t2) * 16.0;
        }
        return (double)y + ty * us.zoom;
    }

    @Override
    public void draw(MyDraw d, Pt cursor, Airship ship, Combat.Side side, int x, int y, int w, int h, ScreenMode sm, UniScreen us) {
        if (us.hideUI) {
            return;
        }
        if (side == us.mySide) {
            if (ship.isBeingBoarded()) {
                d.heavilyBorderedText(Lang._t("BOARDED", new Object[0]), AGame.BIG_FOUNT, AGame.BIG_FOUNT_OUTLINE, BOARDING_ENEMY, Clr.WHITE, x + w / 2 - (int)d.textSize((String)Lang._t((String)"BOARDED", (Object[])new Object[0]), (Fount)AGame.BIG_FOUNT_OUTLINE).x / 2, y - 20, 1000);
                if (Rect2D.intersects(x, y + h, w, MyDraw.BUTTON_SPACING + MyDraw.BUTTON_H, 0.0, 0.0, sm.width, sm.height)) {
                    int myTroops = 0;
                    for (int ci = 0; ci < ship.crew.size(); ++ci) {
                        Crewman c = ship.crew.get(ci);
                        if (!c.type.canBoard && !c.type.doesGuard || !c.active()) continue;
                        myTroops += c.hp;
                        d.blit(DEFENDER_ICON_OUTLINE, BOARDING_FRIENDLY_OUTLINE, BoardingStatusChrome.cx(c, ship, x, us), BoardingStatusChrome.cy(c, ship, y, us) - 16.0);
                        d.blit(DEFENDER_ICON, BOARDING_FRIENDLY, BoardingStatusChrome.cx(c, ship, x, us), BoardingStatusChrome.cy(c, ship, y, us) - 16.0);
                    }
                    int enemyTroops = 0;
                    for (int bi = 0; bi < ship.boarders.size(); ++bi) {
                        Crewman b = ship.boarders.get(bi);
                        if (!b.active()) continue;
                        enemyTroops += b.hp;
                        d.blit(BOARDER_ICON_OUTLINE, BOARDING_ENEMY_OUTLINE, BoardingStatusChrome.cx(b, ship, x, us), BoardingStatusChrome.cy(b, ship, y, us) - 16.0);
                        d.blit(BOARDER_ICON, BOARDING_ENEMY, BoardingStatusChrome.cx(b, ship, x, us), BoardingStatusChrome.cy(b, ship, y, us) - 16.0);
                    }
                    int totalTroops = myTroops + enemyTroops;
                    int bh = MyDraw.BUTTON_H;
                    d.drawPanel(x, y + h + MyDraw.BUTTON_SPACING, w, bh);
                    bh -= MyDraw.PANEL_INSET * 2;
                    x += MyDraw.PANEL_INSET;
                    y += MyDraw.PANEL_INSET;
                    int myW = (w -= MyDraw.PANEL_INSET * 2) * myTroops / totalTroops;
                    int enW = w * enemyTroops / totalTroops;
                    if (myW + enW < w) {
                        ++myW;
                    }
                    d.rect(BOARDING_ENEMY, x, y + h + MyDraw.BUTTON_SPACING, enW, bh);
                    d.rect(BOARDING_FRIENDLY, x + enW, y + h + MyDraw.BUTTON_SPACING, myW, bh);
                }
                y -= AGame.BIG_FOUNT.height + MyDraw.BUTTON_SPACING;
            }
            if (ship.captured) {
                d.heavilyBorderedText(Lang._t("CAPTURED", new Object[0]), AGame.BIG_FOUNT, AGame.BIG_FOUNT_OUTLINE, BOARDING_FRIENDLY, Clr.WHITE, x + w / 2 - (int)d.textSize((String)Lang._t((String)"CAPTURED", (Object[])new Object[0]), (Fount)AGame.BIG_FOUNT_OUTLINE).x / 2, y - 20, 1000);
            }
        } else {
            if (ship.isBeingBoarded()) {
                d.heavilyBorderedText(Lang._t("BOARDING", new Object[0]), AGame.BIG_FOUNT, AGame.BIG_FOUNT_OUTLINE, BOARDING_ENEMY, Clr.WHITE, x + w / 2 - (int)d.textSize((String)Lang._t((String)"BOARDING", (Object[])new Object[0]), (Fount)AGame.BIG_FOUNT_OUTLINE).x / 2, y - 20, 1000);
                if (Rect2D.intersects(x, y + h, w, MyDraw.BUTTON_SPACING + MyDraw.BUTTON_H, 0.0, 0.0, sm.width, sm.height)) {
                    int enemyTroops = 0;
                    for (int ci = 0; ci < ship.crew.size(); ++ci) {
                        Crewman c = ship.crew.get(ci);
                        if (!c.type.canBoard && !c.type.doesGuard || !c.active()) continue;
                        enemyTroops += c.hp;
                        d.blit(DEFENDER_ICON_OUTLINE, BOARDING_ENEMY_OUTLINE, BoardingStatusChrome.cx(c, ship, x, us), BoardingStatusChrome.cy(c, ship, y, us) - 16.0);
                        d.blit(DEFENDER_ICON, BOARDING_ENEMY, BoardingStatusChrome.cx(c, ship, x, us), BoardingStatusChrome.cy(c, ship, y, us) - 16.0);
                    }
                    int myTroops = 0;
                    for (int bi = 0; bi < ship.boarders.size(); ++bi) {
                        Crewman b = ship.boarders.get(bi);
                        if (!b.active()) continue;
                        myTroops += b.hp;
                        d.blit(BOARDER_ICON_OUTLINE, BOARDING_FRIENDLY_OUTLINE, BoardingStatusChrome.cx(b, ship, x, us), BoardingStatusChrome.cy(b, ship, y, us) - 16.0);
                        d.blit(BOARDER_ICON, BOARDING_FRIENDLY, BoardingStatusChrome.cx(b, ship, x, us), BoardingStatusChrome.cy(b, ship, y, us) - 16.0);
                    }
                    int totalTroops = myTroops + enemyTroops;
                    int bh = MyDraw.BUTTON_H;
                    d.drawPanel(x, y + h + MyDraw.BUTTON_SPACING, w, bh);
                    bh -= MyDraw.PANEL_INSET * 2;
                    x += MyDraw.PANEL_INSET;
                    y += MyDraw.PANEL_INSET;
                    int myW = (w -= MyDraw.PANEL_INSET * 2) * myTroops / totalTroops;
                    int enW = w * enemyTroops / totalTroops;
                    if (myW + enW < w) {
                        ++myW;
                    }
                    d.rect(BOARDING_FRIENDLY, x, y + h + MyDraw.BUTTON_SPACING, myW, bh);
                    d.rect(BOARDING_ENEMY, x + myW, y + h + MyDraw.BUTTON_SPACING, enW, bh);
                }
                y -= AGame.BIG_FOUNT.height + MyDraw.BUTTON_SPACING;
            }
            if (ship.captured) {
                d.heavilyBorderedText(Lang._t("CAPTURED", new Object[0]), AGame.BIG_FOUNT, AGame.BIG_FOUNT_OUTLINE, BOARDING_ENEMY, Clr.WHITE, x + w / 2 - (int)d.textSize((String)Lang._t((String)"CAPTURED", (Object[])new Object[0]), (Fount)AGame.BIG_FOUNT_OUTLINE).x / 2, y - 20, 1000);
            }
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public boolean textInputOccurring(UniScreen us) {
        return false;
    }
}

