/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.CommandButtonsPanel;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.SelectionVisualLayer;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public strictfp class BoardCommandTool
extends UniScreen.Tool {
    public boolean transfer;

    public BoardCommandTool(boolean transfer) {
        this.transfer = transfer;
    }

    @Override
    public String getLabel() {
        return Lang._t(this.transfer ? "Transfer_crew_" : "Board_ship_", new Object[0]);
    }

    private List<Airship> ships(UniScreen us) {
        if (us.selectedShip != null) {
            if (us.selectedShip.readyForCommand() && this.transfer ? us.combat.canAbandonShip(us.selectedShip) : BoardCommandTool.canBoard(us.selectedShip, us.mySide)) {
                return Collections.singletonList(us.selectedShip);
            }
            return Collections.emptyList();
        }
        ArrayList<Airship> ships = new ArrayList<Airship>();
        for (Airship s : us.selectedShips) {
            if (!(s.readyForCommand() && this.transfer ? us.combat.canAbandonShip(s) : BoardCommandTool.canBoard(s, us.mySide))) continue;
            ships.add(s);
        }
        return ships;
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        double y;
        if (us.combat == null || us.selectedShip == null && us.selectedShips.isEmpty()) {
            return;
        }
        double x = us.screenToWorldX(cursor.x);
        Airship hs = this.hoverShip(us, x, y = us.screenToWorldY(cursor.y));
        if (hs != null) {
            d.state.setCursor("FULL_TARGET_BOARD", null);
            d.scale(us.zoom, us.zoom);
            d.shift(us.adjScrollX, us.adjScrollY);
            SelectionVisualLayer.drawGridBodyOutline(d, us.zoom, hs, SelectionVisualLayer.TROOPS_BOARD, SelectionVisualLayer.TROOPS_BOARD2);
            d.resetTransforms();
        } else {
            d.state.setCursor("EMPTY_TARGET_BOARD", null);
        }
        List<Airship> ships = this.ships(us);
        d.scale(us.zoom, us.zoom);
        d.shift(us.adjScrollX, us.adjScrollY);
        double w = 2.0 / us.zoom;
        for (Airship s : ships) {
            for (CrewType ct : CrewType.boarders) {
                if (!s.hasCrewType(ct)) continue;
                if (ct.hasHook) {
                    d.rect(SelectionVisualLayer.TROOPS_BOARD, s.getX() - (double)ct.hookRopeLength, s.getY(), w, s.getBBHeight());
                    d.rect(SelectionVisualLayer.TROOPS_BOARD, s.getX() + s.getBBWidth() + (double)ct.hookRopeLength - w, s.getY(), w, s.getBBHeight());
                    continue;
                }
                d.rect(SelectionVisualLayer.TROOPS_BOARD, s.getX() - (double)ct.assumedJumpDist, s.getY(), w, s.getBBHeight());
                d.rect(SelectionVisualLayer.TROOPS_BOARD, s.getX() + s.getBBWidth() + (double)ct.assumedJumpDist - w, s.getY(), w, s.getBBHeight());
            }
        }
        d.resetTransforms();
    }

    public Airship hoverShip(UniScreen us, double x, double y) {
        Combat.Side side = this.transfer ? us.mySide : us.combat.otherSide(us.mySide);
        List<Airship> ships = this.ships(us);
        for (Airship as : side.ships) {
            if (ships.contains(as) || !Rect2D.contains(as.getX(), as.getY(), as.getBBWidth(), as.getBBHeight(), x, y) || !as.canBeBoarded()) continue;
            return as;
        }
        return null;
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        double y;
        CommandButtonsPanel cbp = us.panel(CommandButtonsPanel.class);
        if (us.intent instanceof CombatIntent && click.x > (double)cbp.panelX && click.x < (double)(cbp.panelX + cbp.panelW) && click.y > (double)(sm.height - cbp.panelH)) {
            return false;
        }
        double x = us.screenToWorldX(click.x);
        Airship hs = this.hoverShip(us, x, y = us.screenToWorldY(click.y));
        if (hs != null) {
            List<Airship> ships = this.ships(us);
            for (Airship s : ships) {
                us.combat.giveCommand(Client.msg("board").put("id", us.combat.getShipID(s)).put("target", us.combat.getShipID(hs)));
            }
            us.tool = UniScreen.NAVIGATE;
        }
        return true;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        us.tool = UniScreen.NAVIGATE;
        return true;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (in.keyPressed("ESCAPE")) {
            us.tool = UniScreen.NAVIGATE;
        }
    }

    public static boolean canBoard(Airship ship, Combat.Side side) {
        if (ship.hasCrewTypeAny(CrewType.boarders)) {
            return true;
        }
        int tsz = side.troops.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Crewman cm = side.troops.get(ti);
            if (cm.attachedTo != ship) continue;
            return true;
        }
        return false;
    }
}

