/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.BackgroundFloatieType;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MyDraw;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;

public strictfp class BackgroundFloatie {
    public double x;
    public double y;
    public boolean flipped;
    public int time;
    public BackgroundFloatieType type;

    public BackgroundFloatie(BackgroundFloatieType type, boolean side) {
        this.type = type;
        this.y = 412 - AGame.ANIM_R.nextInt(1000);
        this.time = AGame.ANIM_R.nextInt(type.yPeriod);
        this.flipped = AGame.ANIM_R.nextBoolean();
        this.x = side ? (this.flipped ? 3210.0 : -3280.0) : (double)(AGame.ANIM_R.nextInt(6400) - 3200);
    }

    public void tick(int ms) {
        this.time += ms;
        this.x += this.flipped ? -this.type.xSpeed * (double)ms : this.type.xSpeed * (double)ms;
        if (this.x < -3300.0 || this.x > 3300.0) {
            int roll = AGame.ANIM_R.nextInt(BackgroundFloatie.totalWeightsMoving());
            for (BackgroundFloatieType t : Loadable.all(BackgroundFloatieType.class)) {
                if (t.xSpeed == 0.0 || (roll -= t.weight) > 0) continue;
                this.type = t;
                break;
            }
            this.y = 412 - AGame.ANIM_R.nextInt(1000);
            this.flipped = AGame.ANIM_R.nextBoolean();
            this.x = this.flipped ? 3210.0 : -3280.0;
        }
    }

    public void draw(MyDraw d, Image[] light, float strength, Color ambient, float ambientSaturation) {
        this.type.app.draw(d, this.x, this.y + StrictMath.sin((double)this.time * 1.0 / (double)this.type.yPeriod) * this.type.yAmplitude, this.time, this.flipped, light, strength, ambient, ambientSaturation);
    }

    public static int totalWeights() {
        int n = 0;
        for (BackgroundFloatieType t : Loadable.all(BackgroundFloatieType.class)) {
            n += t.weight;
        }
        return n;
    }

    public static int totalWeightsMoving() {
        int n = 0;
        for (BackgroundFloatieType t : Loadable.all(BackgroundFloatieType.class)) {
            if (t.xSpeed == 0.0) continue;
            n += t.weight;
        }
        return n;
    }
}

