/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Backdrop;
import com.zarkonnen.airships.BackdropType;
import com.zarkonnen.airships.BirdsVisualLayer;
import com.zarkonnen.airships.CombatBackgroundFlavor;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;
import java.util.HashSet;

public strictfp class BackdropVisualLayer
implements UniScreen.VisualLayer {
    public CombatBackgroundFlavor cbf;
    public final ArrayList<BackdropInstance> backdrops = new ArrayList();
    public int time;
    private final HashSet<SpritesheetBundle> additionalSSBs = new HashSet();

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (this.cbf == null) {
            this.cbf = BirdsVisualLayer.getCBF(us);
        }
        if (!us.isTimeMoving()) {
            return;
        }
        this.time += ms;
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (us.intent.drawAsBlueprint()) {
            return;
        }
        boolean snow = us.getTimeOfDay().effect.snow;
        if (this.cbf != null && this.backdrops.isEmpty()) {
            Appearance app;
            for (int x = -3200; x < 3200; x += app.width() * 16) {
                BackdropType bdt = this.cbf.backdrops.get(AGame.ANIM_R.nextInt(this.cbf.backdrops.size()));
                ArrayList<Backdrop> bds = snow ? bdt.snowyBackdrops : bdt.backdrops;
                app = bds.get((int)AGame.ANIM_R.nextInt((int)bds.size())).app;
                this.backdrops.add(new BackdropInstance(app, x += AGame.ANIM_R.nextInt(100) + 15, AGame.ANIM_R.nextBoolean()));
            }
        }
        TimeOfDay tod = us.getTimeOfDay();
        this.additionalSSBs.clear();
        SpritesheetBundle ssb = SpritesheetBundle.ofName("landscape");
        Appearance.lockShader(ssb, d, us.lightingMap, tod.lightStrength, tod.backdropAmbient, tod.backdropAmbientSaturation);
        int bsz = this.backdrops.size();
        for (int bi = 0; bi < bsz; ++bi) {
            BackdropInstance b = this.backdrops.get(bi);
            if (b.app.spritesheetBundle != ssb) {
                if (this.additionalSSBs == null) continue;
                this.additionalSSBs.add(b.app.spritesheetBundle);
                continue;
            }
            if ((double)b.x > cropX + cropW || (double)(b.x + b.app.width() * 16) < cropX || (double)(512 - b.app.height() * 16) > cropY + cropH) continue;
            b.app.draw(d, b.x, 512 - b.app.height() * 16, this.time, null, b.flipped, us.lightingMap, tod.lightStrength, tod.backdropAmbient, tod.backdropAmbientSaturation);
        }
        Appearance.unlockShader(us.lightingMap != null);
        for (SpritesheetBundle ssb2 : this.additionalSSBs) {
            Appearance.lockShader(ssb2, d, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation);
            for (int bi = 0; bi < bsz; ++bi) {
                BackdropInstance b = this.backdrops.get(bi);
                if (b.app.spritesheetBundle != ssb2 || (double)b.x > cropX + cropW || (double)(b.x + b.app.width() * 16) < cropX || (double)(512 - b.app.height() * 16) > cropY + cropH) continue;
                b.app.draw(d, b.x, 512 - b.app.height() * 16, this.time, null, b.flipped, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation);
            }
            Appearance.unlockShader(us.lightingMap != null);
        }
        int tint = 100 + (int)StrictMath.min(100.0, 50.0 / us.zoom);
        Clr bgt = new Clr(tint, tint, tint);
        LandBlockType lbt = us.landscapeType().grass;
        int extra = -16;
        LandFormation ground = null;
        if (us.setupGround != null) {
            ground = us.setupGround;
        } else if (us.city != null) {
            ground = us.city.ground;
        } else if (us.combat != null) {
            ground = us.combat.landFormations.get(0);
        }
        if (us.tool instanceof PlaceShipTool && ((PlaceShipTool)us.tool).landscapedGround != null) {
            ground = ((PlaceShipTool)us.tool).landscapedGround;
        }
        for (int y = 0; y < 8; ++y) {
            int worldY = y * 16 + 512 + extra;
            if ((double)worldY < cropY - 32.0 || (double)worldY > cropY + cropH) continue;
            int groundY = ground == null ? 0 : StrictMath.max(0, (int)((double)worldY - ground.getY()) / 16);
            for (int x = 0; x < 400; ++x) {
                int worldX = x * 16 - 3200;
                if ((double)worldX < cropX - 16.0 || (double)worldX > cropX + cropW || ground != null && ground.grid[groundY][x].opaque) continue;
                lbt.app.draw(d, worldX, worldY, x * 109 + y * 1934, bgt, false, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation);
            }
            lbt = LandBlockType.ofName("SOIL");
            extra = 0;
        }
        Appearance.unlockShader(us.lightingMap != null);
        d.rect(us.getTimeOfDay().deepSoilTint, -3200.0, 640.0, 6400.0, 6400.0);
    }

    public strictfp static class BackdropInstance {
        Appearance app;
        int x;
        boolean flipped;

        public BackdropInstance(Appearance app, int x, boolean flipped) {
            this.app = app;
            this.x = x;
            this.flipped = flipped;
        }
    }
}

