/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.BonusableValue;
import com.zarkonnen.airships.HasName;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.SoundEffect;
import com.zarkonnen.airships.Tech;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONObject;

public strictfp class ArmourType
extends Loadable
implements HasName {
    public final BonusableValue<Appearance> windowApp;
    public final BonusableValue<ArrayList<Appearance>> damagedApps;
    public final Bonus required;
    public final String placeSound;
    public final double placePitch;
    public final BonusableValue<Integer> cost;
    public final BonusableValue<Integer> hp;
    public final BonusableValue<Integer> weight;
    public final BonusableValue<Integer> lift;
    public final BonusableValue<Integer> blastDmgAbsorb;
    public final BonusableValue<Integer> penDmgAbsorb;
    public final boolean hidden;
    public final BonusableValue<SoundEffect> brokenSound;
    public final BonusableValue<SoundEffect> largeHitSound;
    public final BonusableValue<SoundEffect> smallHitSound;
    public final BonusableValue<ArrayList<ModuleType.FragmentImg>[][]> fragments;

    public int getCost(BonusSet bonuses) {
        return this.cost.get(bonuses);
    }

    public int getHP(BonusSet bonuses) {
        return this.hp.get(bonuses);
    }

    public int getWeight(BonusSet bonuses) {
        return this.weight.get(bonuses);
    }

    public int getLift(BonusSet bonuses) {
        return this.lift.get(bonuses);
    }

    public int getBlastDmgAbsorb(BonusSet bonuses) {
        return this.blastDmgAbsorb.get(bonuses);
    }

    public int getPenDmgAbsorb(BonusSet bonuses) {
        return this.penDmgAbsorb.get(bonuses);
    }

    public static ArmourType ofName(String name) {
        return Loadable.ofName(ArmourType.class, name);
    }

    public ArmourType(JSONObject o) {
        super(o.getString("name"), o.optInt("sort", 0));
        this.windowApp = BonusableValue.objectFromJSON(o, "windowApp", null, new Appearance.FromJSON());
        this.damagedApps = BonusableValue.listFromJSONRequired(o, "damagedApps", new Appearance.FromJSON());
        this.required = o.has("required") ? Bonus.ofNameOrNull(o.getString("required")) : null;
        this.placeSound = o.optString("placeSound", null);
        this.placePitch = o.optDouble("placePitch", 1.0);
        this.cost = BonusableValue.intFromJSON(o, "cost", 0);
        this.hp = BonusableValue.intFromJSON(o, "hp", 1);
        this.weight = BonusableValue.intFromJSON(o, "weight", 0);
        this.blastDmgAbsorb = BonusableValue.intFromJSON(o, "blastDmgAbsorb", 0);
        this.penDmgAbsorb = BonusableValue.intFromJSON(o, "penDmgAbsorb", 0);
        this.hidden = o.optBoolean("hidden", false);
        this.brokenSound = BonusableValue.objectFromJSON(o, "brokenSound", null, new SoundEffect.FromJSON(false));
        this.largeHitSound = BonusableValue.objectFromJSON(o, "largeHitSound", null, new SoundEffect.FromJSON(false));
        this.smallHitSound = BonusableValue.objectFromJSON(o, "smallHitSound", null, new SoundEffect.FromJSON(false));
        this.lift = BonusableValue.intFromJSON(o, "lift", 0);
        this.fragments = BonusableValue.derive(this.damagedApps, new BonusableValue.Derive<ArrayList<Appearance>, ArrayList<ModuleType.FragmentImg>[][]>(){

            @Override
            public ArrayList<ModuleType.FragmentImg>[][] derive(ArrayList<Appearance> from) {
                return new ArrayList[5][5];
            }
        });
    }

    public String getDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append(Lang._t("armour_" + this.name, new Object[0]).toUpperCase(Locale.ENGLISH));
        if (this.required != null && this.required != Bonus.ofName("NO_BONUS")) {
            Tech.Choice providingTech = Tech.findProvider(this.required);
            if (providingTech != null) {
                sb.append("\n").append(Lang._t("Requires_tech", Lang._t("tech_" + providingTech.name, new Object[0]), providingTech.tech.tier + 1));
            } else {
                sb.append("\n").append(Lang._t("Requires_bonus_x", this.required.getName()));
            }
        }
        sb.append("\n\n").append(Lang._t("armour_" + this.name + "_desc", new Object[0]));
        return sb.toString();
    }

    public List<BonusSet> getAppBonuses() {
        return this.damagedApps.getBonusesIfAvailable();
    }

    @Override
    public String getName() {
        return Lang._t("armour_" + this.name, new Object[0]);
    }

    public String getDescription(BonusSet bonuses) {
        StringBuilder sb = new StringBuilder(this.getDesc());
        sb.append("\n");
        sb.append("\n").append(Lang._t("HP_x", this.getHP(bonuses)));
        sb.append("\n").append(Lang._t("Weight_x", this.getWeight(bonuses)));
        if (this.getLift(bonuses) > 0) {
            sb.append("\n").append(Lang._t("Lift_x", this.getLift(bonuses)));
        }
        if (this.getBlastDmgAbsorb(bonuses) > 0) {
            sb.append("\n").append(Lang._t("Absorbs_x_blast_damage", this.getBlastDmgAbsorb(bonuses)));
        }
        if (this.getPenDmgAbsorb(bonuses) > 0) {
            sb.append("\n").append(Lang._t("Absorbs_x_penetration_damage", this.getPenDmgAbsorb(bonuses)));
        }
        return sb.toString();
    }
}

