/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.LandscapeType;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.TimeOfDay;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public strictfp class Arena {
    public static BufferedImage drawCombat(Combat c) {
        BufferedImage img = new BufferedImage(6400, 3200, 1);
        Graphics2D g = img.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        g.translate(3200, 512);
        Color baseColor = Color.GREEN;
        for (Combat.Side s : c.sides) {
            int i = 0;
            for (Airship ship : s.ships) {
                g.setColor(new Color(StrictMath.min(255, baseColor.getRed() + i * 10), StrictMath.min(255, baseColor.getGreen() + i * 10), StrictMath.min(255, baseColor.getBlue() + i * 3)));
                ++i;
                for (Tile t : ship.tiles) {
                    int tx = ship.getIntX() + ship.gridXToWorldX(t.x, 1) * 16;
                    int ty = ship.getIntY() + t.y * 16;
                    g.fillRect(tx, ty, 16, 16);
                }
                g.setColor(Color.BLACK);
                g.drawString(ship.getName(), (int)(ship.getX() + ship.getBBWidth() / 2.0), (int)(ship.getY() + ship.getBBHeight() / 2.0));
            }
            baseColor = Color.RED;
        }
        g.setColor(Color.DARK_GRAY);
        for (LandFormation lf : c.landFormations) {
            for (int gy = 0; gy < lf.grid.length; ++gy) {
                for (int gx = 0; gx < lf.grid[0].length; ++gx) {
                    g.fillRect((int)lf.getX() + gx * 16, (int)lf.getY() + gy * 16, 16, 16);
                }
            }
        }
        return img;
    }

    public static void main(String[] args) {
        ArrayList<Airship> designs = new ArrayList<Airship>();
        for (String n : new String[]{"landships", "ships"}) {
            File shipsDir = new File(AGame.getGameDirectory(), n);
            for (File f : shipsDir.listFiles()) {
                if (f.getName().startsWith(".") || !f.getName().endsWith(".json")) continue;
                try {
                    designs.add(new Airship(new JSONObject(FileUtils.readFileToString((File)f, (String)"UTF-8"))));
                }
                catch (Exception e) {
                    System.out.println(f.getName() + " is not loadable.");
                }
            }
        }
        int[] wins = new int[designs.size()];
        for (Airship da : designs) {
            if (da.getCost() > 300) continue;
            for (Airship db : designs) {
                if (db.getCost() > 300) continue;
                boolean bwins = Arena.fight(da, db);
                System.out.println(da.getName() + " vs " + db.getName() + ": " + (bwins ? db.getName() : da.getName()) + " wins");
                int n = designs.indexOf(bwins ? db : da);
                wins[n] = wins[n] + 1;
                Airship tmp = db;
                db = da;
                da = tmp;
                bwins = Arena.fight(da, db);
                System.out.println(da.getName() + " vs " + db.getName() + ": " + (bwins ? db.getName() : da.getName()) + " wins");
                int n2 = designs.indexOf(bwins ? db : da);
                wins[n2] = wins[n2] + 1;
            }
        }
        for (Airship d : designs) {
            System.out.println(wins[designs.indexOf(d)] + " wins for " + d.getName());
        }
    }

    static boolean within15percent(double d) {
        return d <= 1.15 && d >= 0.8695652173913044;
    }

    public static boolean fight(Airship designA, Airship designB) {
        int numA = 1;
        int numB = 1;
        while (numA < 12 && numB < 12 && !Arena.within15percent(1.0 * (double)numA * (double)designA.getCost() / (double)numB / (double)designB.getCost())) {
            if (numA * designA.getCost() > numB * designB.getCost()) {
                ++numB;
                continue;
            }
            ++numA;
        }
        System.out.println(numA + " " + designA.getName() + " (" + numA * designA.getCost() + ") vs " + numB + " " + designB.getName() + " (" + numB * designB.getCost() + ")");
        Random r = new Random();
        int bWins = 0;
        for (int round = 0; round < 1; ++round) {
            int ticks;
            Airship ship;
            int i;
            Combat c = new Combat(null, TimeOfDay.ofName("DAY"));
            long seed = -167288957399612368L;
            c.setRandomSeed(seed);
            for (i = 0; i < numA; ++i) {
                ship = designA.clone();
                if (ship.type.onGround) {
                    ship.setX(-1600.0 - (double)i * (ship.getBBWidth() + 20.0));
                    ship.setY(512.0 - ship.getBBHeight() - 50.0);
                } else {
                    ship.setX(-1600.0 - (double)(i / 3) * (ship.getBBWidth() + 20.0));
                    ship.setY(512.0 - (double)ship.serviceCeiling() * 0.95 + (double)(i % 3) * (ship.getBBHeight() + 20.0));
                }
                ship.ai = new TacticalAI(ship, c, c.sides.get(0), c.sides.get(1));
                ship.flipped = false;
                ship.flipTo = false;
                ship.repair();
                c.sides.get((int)0).ships.add(ship);
            }
            for (i = 0; i < numB; ++i) {
                ship = designB.clone();
                if (ship.type.onGround) {
                    ship.setX(1600.0 + (double)i * (ship.getBBWidth() + 20.0));
                    ship.setY(512.0 - ship.getBBHeight() - 50.0);
                } else {
                    ship.setX(1600.0 + (double)(i / 3) * (ship.getBBWidth() + 20.0));
                    ship.setY(512.0 - (double)ship.serviceCeiling() * 0.95 + (double)(i % 3) * (ship.getBBHeight() + 20.0));
                }
                ship.ai = new TacticalAI(ship, c, c.sides.get(1), c.sides.get(0));
                ship.flipped = true;
                ship.flipTo = true;
                ship.repair();
                c.sides.get((int)1).ships.add(ship);
            }
            LandFormation ground = new LandFormation(-3200.0, 512.0, 400, 2, LandscapeType.ofName("GRASSLAND"));
            for (int y = 0; y < ground.grid.length; ++y) {
                for (int x = 0; x < ground.grid[0].length; ++x) {
                    ground.grid[y][x] = LandBlockType.ofName("BEDROCK");
                }
            }
            ground.crop();
            ground.immobile = true;
            c.landFormations.add(ground);
            try {
                for (ticks = 0; ticks < 10000 && !c.isFinished(); ++ticks) {
                    if (ticks % 100 == 0) {
                        BufferedImage cimg = Arena.drawCombat(c);
                        ImageIO.write((RenderedImage)cimg, "PNG", new File("/home/zar/Desktop/setups/" + designA.getName() + " vs " + designB.getName() + " " + ticks + ".png"));
                    }
                    c.tick(16, c.sides.get(0), false, 1);
                    c.sounds.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(designA.getName() + " vs " + designB.getName() + " tick " + ticks + " with seed " + seed);
                Runtime.getRuntime().exit(0);
            }
            if (!c.won(c.sides.get(1))) continue;
            ++bWins;
        }
        return bWins > 1;
    }
}

