/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.AnimationAppearance;
import com.zarkonnen.airships.AnimationBundle;
import com.zarkonnen.airships.AnimationType;
import com.zarkonnen.airships.BodyPlan;
import com.zarkonnen.airships.CrewAnimator;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.ModReloadProgressDialog;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.Arrays;
import org.newdawn.slick.Color;

public strictfp class AnimationViewer
implements Screen {
    public final AirshipGame g;
    public ScrollBar animationAppChooser = new ScrollBar();
    public ScrollBar animationTypeChooser = new ScrollBar();
    public ScrollBar loadErrorView = new ScrollBar();
    public AnimationAppearance currentAppearance = null;
    public AnimationType currentType = AnimationType.STANDING;
    public int time = 0;
    public int reAnimateTime = 0;
    public ModReloadProgressDialog mrpd = null;
    private final ErrorAdapter ea = new ErrorAdapter();
    private final AnimationAppearanceAdapter aaa = new AnimationAppearanceAdapter();
    private final AnimationTypeAdapter ata = new AnimationTypeAdapter();

    public AnimationViewer(AirshipGame g) {
        this.g = g;
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.mrpd != null) {
            ModReloadProgressDialog myMrpd = this.mrpd;
            if (this.mrpd.tick(in) && myMrpd == this.mrpd) {
                this.mrpd = null;
            }
            return;
        }
        if (in.keyPressed("ESCAPE")) {
            this.g.s = new MainMenu(this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
        }
        if (this.currentAppearance != null && this.currentAppearance.bundle != null) {
            AnimationBundle.Animation an = this.currentAppearance.bundle.animations.get((Object)this.currentType);
            if (an != null && an.length != 0) {
                if (this.reAnimateTime <= 0) {
                    this.time += ms;
                    if (this.time > an.length) {
                        this.time = an.length;
                        this.reAnimateTime = 2000;
                    }
                } else {
                    this.reAnimateTime -= ms;
                    if (this.reAnimateTime <= 1000) {
                        this.time = 0;
                    }
                }
            } else {
                this.time += ms;
            }
        } else {
            this.time += ms;
        }
        ScreenMode sm = in.mode();
        int x = MyDraw.SIDE_CLEARANCE;
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        int totalH = sm.height - y - MyDraw.SIDE_CLEARANCE;
        int scrollBarH = (totalH - MyDraw.UI_SPACING * 2) / 3;
        int scrollBarW = (sm.width - MyDraw.SIDE_CLEARANCE * 2 - MyDraw.UI_SPACING) / 2;
        this.loadErrorView.tick(in, x, y, scrollBarW, scrollBarH);
        this.animationAppChooser.tick(in, x, y += scrollBarH + MyDraw.UI_SPACING, scrollBarW, scrollBarH);
        this.animationTypeChooser.tick(in, x, y += scrollBarH + MyDraw.UI_SPACING, scrollBarW, scrollBarH);
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawBG(MyDraw.SCREEN_BG, sm);
        d.rect(Clr.fromHex((String)"7b421b").mix(0.9, Clr.BLACK), 0.0, 0.0, sm.width, sm.height);
        d.drawTopBar(sm);
        if (this.mrpd != null) {
            this.mrpd.render(d, sm, hs, cursor);
            return;
        }
        int bw = d.bw("Quit");
        int x = sm.width - MyDraw.SIDE_CLEARANCE - bw;
        d.button(x, MyDraw.TOP_BAR_INSET, bw, "Quit", new Runnable(){

            @Override
            public void run() {
                AnimationViewer.this.g.s = new MainMenu(AnimationViewer.this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
            }
        });
        bw = d.bw("Reload");
        d.button(x -= bw + MyDraw.UI_SPACING, MyDraw.TOP_BAR_INSET, bw, "Reload", new InputRunnable(){

            @Override
            public void run(Input in) {
                final String appName = AnimationViewer.this.currentAppearance == null ? null : AnimationViewer.this.currentAppearance.name;
                AnimationViewer.this.mrpd = new ModReloadProgressDialog(new Runnable(){

                    @Override
                    public void run() {
                        if (appName != null) {
                            for (AnimationAppearance app : Loadable.all(AnimationAppearance.class)) {
                                if (!app.name.equals(appName)) continue;
                                AnimationViewer.this.currentAppearance = app;
                            }
                        }
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        AnimationViewer.this.g.s = new MainMenu(AnimationViewer.this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
                        AnimationViewer.this.g.showError("Reload failed!");
                    }
                });
            }
        });
        x = MyDraw.SIDE_CLEARANCE;
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        int totalH = sm.height - y - MyDraw.SIDE_CLEARANCE;
        int scrollBarH = (totalH - MyDraw.UI_SPACING * 2) / 3;
        int scrollBarW = (sm.width - MyDraw.SIDE_CLEARANCE * 2 - MyDraw.UI_SPACING) / 2;
        ArrayList<String> errs = new ArrayList<String>();
        errs.addAll(Loadable.getErrors(BodyPlan.class));
        errs.addAll(Loadable.getErrors(AnimationBundle.class));
        errs.addAll(Loadable.getErrors(AnimationAppearance.class));
        if (errs.isEmpty()) {
            errs.add("All data files loaded successfully.");
        }
        this.loadErrorView.draw(d, x, y, scrollBarW, scrollBarH, errs, this.ea);
        this.animationAppChooser.draw(d, x, y += scrollBarH + MyDraw.UI_SPACING, scrollBarW, scrollBarH, Loadable.all(AnimationAppearance.class), this.aaa);
        ArrayList<AnimationType> ats = new ArrayList<AnimationType>(Arrays.asList(AnimationType.values()));
        this.animationTypeChooser.draw(d, x, y += scrollBarH + MyDraw.UI_SPACING, scrollBarW, scrollBarH, ats, this.ata);
        if (this.currentAppearance != null && (this.currentAppearance.bundle != null && this.currentAppearance.bundle.animations.containsKey((Object)this.currentType) || this.currentAppearance.frameAnimations != null && this.currentAppearance.frameAnimations.containsKey((Object)this.currentType))) {
            CrewAnimator.draw(d, x + scrollBarW + MyDraw.UI_SPACING, MyDraw.TOP_BAR_H + MyDraw.UI_SPACING, null, this.currentType, this.currentAppearance, this.time, 0, null, null, 1.0f, Color.white, 1.0f, Clr.WHITE, null, null, null);
            d.shift(x + scrollBarW + MyDraw.UI_SPACING + 200, MyDraw.TOP_BAR_H + MyDraw.UI_SPACING + 200);
            d.scale(5.5, 5.5);
            CrewAnimator.draw(d, 0.0, 0.0, null, this.currentType, this.currentAppearance, this.time, 0, null, null, 1.0f, Color.white, 1.0f, Clr.WHITE, null, null, null);
            d.resetTransforms();
        }
    }

    @Override
    public ArrayList<String> music() {
        return AGame.NO_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return "";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    public strictfp class AnimationTypeAdapter
    implements ScrollBar.ScrollElementAdapter<AnimationType> {
        @Override
        public int getHeight(AnimationType t, MyDraw d, int availableWidth) {
            return AGame.FOUNT.height + MyDraw.SCROLL_EL_SPACING;
        }

        @Override
        public void draw(final AnimationType t, MyDraw d, int x, int y, int width) {
            if (t == AnimationViewer.this.currentType) {
                d.text(MyDraw.SELECTED_C + t.name(), AGame.FOUNT, x, y);
            } else {
                d.text(t.name(), AGame.FOUNT, x, y);
            }
            d.hook(x, y, width, AGame.FOUNT.height + MyDraw.SCROLL_EL_SPACING, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    AnimationViewer.this.currentType = t;
                }
            });
        }
    }

    public strictfp class AnimationAppearanceAdapter
    implements ScrollBar.ScrollElementAdapter<AnimationAppearance> {
        @Override
        public int getHeight(AnimationAppearance t, MyDraw d, int availableWidth) {
            return AGame.FOUNT.height + MyDraw.SCROLL_EL_SPACING;
        }

        @Override
        public void draw(final AnimationAppearance t, MyDraw d, int x, int y, int width) {
            if (t == AnimationViewer.this.currentAppearance) {
                d.text(MyDraw.SELECTED_C + t.name, AGame.FOUNT, x, y);
            } else {
                d.text(t.name, AGame.FOUNT, x, y);
            }
            d.hook(x, y, width, AGame.FOUNT.height + MyDraw.SCROLL_EL_SPACING, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    AnimationViewer.this.currentAppearance = t;
                }
            });
        }
    }

    public strictfp class ErrorAdapter
    implements ScrollBar.ScrollElementAdapter<String> {
        @Override
        public int getHeight(String t, MyDraw d, int availableWidth) {
            return (int)d.textSize((String)t, (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)availableWidth).height + MyDraw.SCROLL_EL_SPACING;
        }

        @Override
        public void draw(String t, MyDraw d, int x, int y, int width) {
            d.text(t, AGame.FOUNT, x, y, width, 10000, 0, false);
        }
    }
}

