/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AnimationType;
import com.zarkonnen.airships.BodyPlan;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Side;
import java.util.EnumMap;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class AnimationBundle
extends Loadable {
    public final double width;
    public final double height;
    public final BodyPlan bodyPlan;
    public final EnumMap<AnimationType, Animation> animations;

    public AnimationBundle(JSONObject o) {
        super(o.getString("name"));
        this.bodyPlan = BodyPlan.ofName(o.getString("bodyPlan"));
        this.width = o.getDouble("width");
        this.height = o.getDouble("height");
        this.animations = new EnumMap(AnimationType.class);
        JSONArray a = o.getJSONArray("animations");
        for (int i = 0; i < a.length(); ++i) {
            this.animations.put(AnimationType.valueOf(a.getJSONObject(i).getString("type")), new Animation(a.getJSONObject(i), this.bodyPlan));
        }
    }

    public static AnimationBundle ofName(String name) {
        return Loadable.ofName(AnimationBundle.class, name);
    }

    public strictfp static class Animation {
        public static final int LOOPING = 0;
        public final int length;
        public final Side side;
        public final BodyPlan bodyPlan;
        public final Part[] parts;

        public Animation(JSONObject o, BodyPlan bodyPlan) {
            this.length = o.optInt("length", 0);
            this.side = Side.valueOf(o.getString("side"));
            this.bodyPlan = bodyPlan;
            this.parts = new Part[bodyPlan.partNames.get((Object)this.side).size()];
            JSONArray a = o.getJSONArray("parts");
            for (int i = 0; i < a.length(); ++i) {
                JSONObject p = a.getJSONObject(i);
                this.parts[bodyPlan.getIndex((Side)this.side, (String)p.getString((String)"name"))] = new Part(p);
            }
        }

        public strictfp static class Part {
            public final double x;
            public final double y;
            public final double rotationOffset;
            public final double rotationPeriod;
            public final double rotationWidth;
            public final double rotationHeight;
            public final double waveOffset;
            public final double wavePeriod;
            public final double waveStartAngle;
            public final double waveEndAngle;
            public final boolean holdsResource;

            public Part(JSONObject o) {
                this.x = o.getDouble("x");
                this.y = o.getDouble("y");
                this.rotationOffset = o.optDouble("cOff", 0.0);
                this.rotationPeriod = o.optDouble("cPeriod", 1000.0);
                this.rotationWidth = o.optDouble("cW", 0.0);
                this.rotationHeight = o.optDouble("cH", 0.0);
                this.waveOffset = o.optDouble("wOff", 0.0);
                this.wavePeriod = o.optDouble("wPeriod", 1000.0);
                this.waveStartAngle = o.optDouble("wStart", 0.0);
                this.waveEndAngle = o.optDouble("wEnd", 0.0);
                this.holdsResource = o.optBoolean("holdsResource", false);
            }
        }
    }
}

