/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Achievement;
import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.ChannelInfo;
import com.zarkonnen.airships.ChatMsg;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.CoatEditor;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.CombatSoundEffects;
import com.zarkonnen.airships.CompressAndArmour;
import com.zarkonnen.airships.GUIScale;
import com.zarkonnen.airships.Integration;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.LaunchSettings;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.LoadingScreen;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MetaLobbyOverlay;
import com.zarkonnen.airships.MetaLobbyScreen;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.MultiplayerCombatIntent;
import com.zarkonnen.airships.MultiplayerSetupIntent;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PerfReport;
import com.zarkonnen.airships.PlaybackIntent;
import com.zarkonnen.airships.PlayerInfo;
import com.zarkonnen.airships.ResChooserScreen;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.Server;
import com.zarkonnen.airships.SimplePref;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.airships.TextAdapter;
import com.zarkonnen.airships.UIGlowRect;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.WebIntegrationBackend;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.ExceptionHandler;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Frame;
import com.zarkonnen.catengine.Game;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.MusicCallback;
import com.zarkonnen.catengine.SlickEngine;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Rect;
import com.zarkonnen.catengine.util.ScreenMode;
import com.zarkonnen.catengine.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.prefs.Preferences;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.JSONArray;
import org.json.JSONObject;
import org.lwjgl.input.Mouse;

public strictfp class AirshipGame
implements Game,
ExceptionHandler,
SlickEngine.ReportHandler {
    public Screen s = new ResChooserScreen(this);
    public boolean showFrameCosts = false;
    private final Hooks hs = new Hooks();
    private final MyDraw.State drawState = new MyDraw.State();
    private boolean first = true;
    public boolean exit = false;
    public int delayExitForFlush = 0;
    public int delayExitForNetwork = 0;
    public Pt cursor = new Pt(0.0, 0.0);
    public static final Preferences PREFS = Preferences.userNodeForPackage(AirshipGame.class);
    public static final Clr ERR_BG_TINT = new Clr(0, 0, 0, 63);
    public String error = null;
    public int backgroundPlayTimeLeft = 0;
    public String helpText = null;
    public Runnable hideHelpRunnable = null;
    public ScrollBar helpTextScroll = new ScrollBar();
    public Integration integration = null;
    public boolean checkedMPServer = false;
    public String chosenMultiplayerServer = null;
    public LinkedList<Integer> frameCosts = new LinkedList();
    int time;
    public long dataChecksum = 0L;
    public long expectedDataChecksum = 0L;
    public long msPlayed = 0L;
    public String currentMusic = null;
    public int fading = 0;
    public ArrayList<String> currentMusicOptions = new ArrayList();
    public int lastMs = 0;
    public boolean hasRendered = false;
    public Pt lastCursorPt;
    public boolean mouseMoved = false;
    byte[] emergencyReserve = new byte[100000];
    public boolean phoneHomeAsked = true;
    public boolean phoneHomeWithErrors = true;
    public double volume = 0.5;
    public double musicVolume = 0.5;
    public static int scrollSpeed = 12;
    public static int zoomSpeed = 3;
    public static int mouseWheelZoomSpeed = 3;
    public boolean prevUserFirstTimev5 = false;
    public static boolean multiplayerChatOverlay = false;
    public static MetaLobbyOverlay metaLobbyOverlay = null;
    public boolean mpChatOverlayActive = false;
    public int msSinceIntegration = 0;
    public boolean firstLaunch = false;
    public String wmSize = "MEDIUM";
    public String difficulty = "EASY";
    public String seaLevelSettingName = "MIXED";
    public String monsterityName = "DEFAULT";
    public String techSpeedName = "NORMAL";
    public int startingTechTier = 0;
    public boolean strategicHelp;
    public boolean strategicRapidCommands;
    public boolean swallowExceptions = false;
    public boolean disableAllModsOnStartup = false;
    public GUIScale guiScaleOverride = null;
    public GUIScale currentGUIScale = GUIScale.SMALL;
    public String overlayServer;
    public Client client;
    public Client lanClient;
    public Server lanServer;
    public final ArrayList<ChatMsg> chat = new ArrayList();
    public final HashMap<Integer, PlayerInfo> players = new HashMap();
    public final ArrayList<ChannelInfo> channels = new ArrayList();
    public boolean helloSent = false;
    public boolean idReceived = false;
    public boolean channelsLoaded = false;
    public int myID = 0;
    public String myName;
    public JSONObject myArmsJSON;
    public int lanID = 0;
    public String lanName;
    public JSONObject lanArmsJSON;
    private final LinkedList<JSONObject> preProcessedMessages = new LinkedList();
    static AirshipGame instance;
    public HashMap<String, String> helps = new HashMap();
    public HashSet<String> seenErrorMessages = new HashSet();
    public static final int LOW_MEMORY_TRIGGER_MB = 50;
    public static final int MS_AT_LOW_MEMORY_THRESHOLD = 3000;
    private int msAtLowMemory = 0;
    private boolean doCheckMemory;
    private static final int TT_Y_OFFSET = 18;

    public boolean hasCorrectChecksum() {
        return this.dataChecksum == this.expectedDataChecksum;
    }

    public void disconnectClient() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
            this.players.clear();
            this.channels.clear();
            this.idReceived = false;
            this.helloSent = false;
            this.chat.clear();
        }
    }

    public boolean isConnected() {
        return this.lanClient != null ? this.lanClient.isConnectedRaw() : this.client != null && this.client.isConnectedRaw();
    }

    public int playerID() {
        if (this.lanClient != null) {
            return this.lanID;
        }
        return this.myID;
    }

    public String playerName() {
        if (this.lanClient != null) {
            return this.lanName;
        }
        this.setMyNameAndArms();
        return this.myName;
    }

    public JSONObject playerArms() {
        if (this.lanClient != null) {
            return this.lanArmsJSON;
        }
        this.setMyNameAndArms();
        return this.myArmsJSON;
    }

    public JSONObject pollMessage() {
        if (this.lanClient != null) {
            return this.lanClient.pollMessageRaw();
        }
        return this.preProcessedMessages.pollFirst();
    }

    public void sendMessage(JSONObject msg) {
        if (this.lanClient != null) {
            this.lanClient.sendMessageRaw(msg);
        } else if (this.client != null) {
            this.client.sendMessageRaw(msg);
        } else {
            this.reportError(Lang._t("Unable_to_send_no_active_network_connection", new Object[0]), null, null, false);
        }
    }

    public boolean sendMessageWithSizeCheck(JSONObject msg) {
        if (this.lanClient != null) {
            return this.lanClient.sendMessageRawWithSizeCheck(msg);
        }
        if (this.client != null) {
            return this.client.sendMessageRawWithSizeCheck(msg);
        }
        this.reportError(Lang._t("Unable_to_send_no_active_network_connection", new Object[0]), null, null, false);
        return true;
    }

    private boolean processClient() {
        if (this.client == null) {
            return false;
        }
        JSONObject msg = this.client.pollMessageRaw();
        if (!this.helloSent && this.idReceived) {
            this.setMyNameAndArms();
            this.client.sendMessageRaw(Client.msg("hello").put("info", new JSONObject().put("name", this.myName).put("id", this.myID).put("arms", this.myArmsJSON)));
            this.helloSent = true;
        }
        if (msg != null) {
            if (msg.getString("type").equals("serverReject")) {
                this.showError(Lang._t("server_rejected_" + msg.getString("reason"), new Object[0]));
                this.disconnectClient();
                this.s = new MainMenu(this, MainMenu.Submenu.MAIN);
                return false;
            }
            if (msg.get("type").equals("assignID")) {
                this.myID = msg.getInt("playerID");
                this.idReceived = true;
            }
            if (msg.get("type").equals("addPlayer")) {
                this.processAddPlayer(msg);
            }
            if (msg.get("type").equals("removePlayer")) {
                this.processRemovePlayer(msg);
            }
            if (msg.get("type").equals("channelList")) {
                this.processChannelList(msg);
            }
            if (msg.getString("type").equals("frame")) {
                this.processChatFrame(msg);
            }
            this.preProcessedMessages.add(msg);
            return true;
        }
        return false;
    }

    private void processChannelList(JSONObject msg) {
        JSONArray l = msg.getJSONArray("channels");
        this.channels.clear();
        for (int i = 0; i < l.length(); ++i) {
            JSONObject o = l.getJSONObject(i);
            int id = o.getInt("id");
            if (id == 0 || o.getInt("players") <= 0) continue;
            this.channels.add(new ChannelInfo(id, o.getJSONObject("info"), o.getInt("players"), o.optBoolean("sealed", false)));
        }
    }

    private void processAddPlayer(JSONObject msg) {
        JSONObject info = msg.getJSONObject("info");
        if (!this.players.containsKey(info.getInt("id"))) {
            PlayerInfo pi = new PlayerInfo(info.getInt("id"), info.getString("name"));
            pi.armsJSON = info.getJSONObject("arms");
            this.players.put(info.getInt("id"), pi);
            this.chat.add(new ChatMsg(pi, Lang._t("xxx_JOINED_xxx", pi.name), DateTime.now()));
        }
    }

    private void processRemovePlayer(JSONObject msg) {
        int id = msg.getInt("id");
        if (this.players.containsKey(id)) {
            this.chat.add(new ChatMsg(this.players.get(id), Lang._t("xxx_LEFT_xxx", this.players.get((Object)Integer.valueOf((int)id)).name), DateTime.now()));
        }
        this.players.remove(id);
    }

    private void processChatFrame(JSONObject msg) {
        JSONArray frameMessages = msg.getJSONArray("messages");
        for (int i = 0; i < frameMessages.length(); ++i) {
            PlayerInfo pi;
            JSONObject fm = frameMessages.getJSONObject(i);
            if (fm.getString("type").equals("createGame") && (pi = this.players.get(fm.getInt("id"))) != null) {
                this.chat.add(new ChatMsg(pi, Lang._t("xxx_NEW_GAME_xxx", pi.name, fm.getString("name")), DateTime.now()));
            }
            if (!fm.getString("type").equals("globalChat")) continue;
            pi = this.players.get(fm.getInt("id"));
            if (pi != null) {
                this.chat.add(new ChatMsg(pi, pi.name + ": " + fm.getString("text"), new DateTime(fm.getLong("t"), DateTimeZone.UTC)));
                continue;
            }
            if (!fm.has("historyInfo") || !fm.getJSONObject("historyInfo").has("name") || !fm.getJSONObject("historyInfo").has("arms")) continue;
            JSONObject info = fm.getJSONObject("historyInfo");
            pi = new PlayerInfo(info.getInt("id"), info.getString("name"));
            pi.armsJSON = info.getJSONObject("arms");
            this.chat.add(new ChatMsg(pi, pi.name + ": " + fm.getString("text"), new DateTime(fm.getLong("t"), DateTimeZone.UTC)));
        }
    }

    static void report(String text) {
        instance.reportError(text, null, null, false, true);
    }

    public void initIntegration() {
        if (this.integration == null) {
            this.integration = new Integration(new WebIntegrationBackend("https://airships.zarkonnen.com/api/", "https://airships.zarkonnen.com/static/media/", "https://airships.zarkonnen.com", "https://airships.zarkonnen.com/multiplayer_calendar"));
        }
    }

    public final void loadSettings() {
        try {
            this.firstLaunch = PREFS.getDouble("volume", 666.0) > 111.0;
            Analytics.pseudonym = PREFS.get("pseudonym", "?");
            this.prevUserFirstTimev5 = PREFS.getDouble("volume", -100.0) > -1.0 && !PREFS.getBoolean("usedv5", false);
            this.phoneHomeAsked = true;
            this.phoneHomeWithErrors = PREFS.getBoolean("phoneHomeWithErrors", true);
            this.volume = PREFS.getDouble("volume", 1.0);
            this.strategicHelp = PREFS.getBoolean("strategicHelp", true);
            this.strategicRapidCommands = PREFS.getBoolean("strategicRapidCommands", false);
            this.musicVolume = PREFS.getDouble("musicVolume", 0.5);
            scrollSpeed = PREFS.getInt("scrollSpeed", 12);
            zoomSpeed = PREFS.getInt("zoomSpeed", 3);
            mouseWheelZoomSpeed = PREFS.getInt("mouseWheelZoomSpeed", 3);
            String lang = PREFS.get("language", "-----");
            if (!lang.equals("-----")) {
                Lang.setCurrentLocale(Locale.forLanguageTag(lang));
            }
            Appearance.useSimpleGraphics = PREFS.getBoolean("useSimpleGraphics", false);
            Appearance.useLighting = PREFS.getBoolean("useLighting", true);
            for (SimplePref sp : SimplePref.values()) {
                sp.load();
            }
            this.wmSize = PREFS.get("wmSize", "MEDIUM");
            this.difficulty = PREFS.get("difficulty", "EASY");
            this.seaLevelSettingName = PREFS.get("seaLevelSettingName", "MIXED");
            this.monsterityName = PREFS.get("monsterityName", "DEFAULT");
            this.techSpeedName = PREFS.get("techSpeedName", "NORMAL");
            this.startingTechTier = PREFS.getInt("startingTechTier", 0);
            this.chosenMultiplayerServer = PREFS.get("chosenMultiplayerServer", "");
            if (this.chosenMultiplayerServer.isEmpty()) {
                this.chosenMultiplayerServer = null;
            }
            AirshipGame.setMultiplayerChatOverlay(PREFS.getBoolean("multiplayerChatOverlay", false));
            String gui = PREFS.get("guiScale", "AUTO");
            this.guiScaleOverride = gui.equals("AUTO") ? null : GUIScale.valueOf(gui);
            MainMenu.spidersReleased = PREFS.getBoolean("spidersReleased", false);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reportError("Unable to load settings.", e, null, false);
        }
        if (Analytics.pseudonym.equals("?")) {
            Analytics.pseudonym = AGame.ANIM_R.nextLong() + "" + System.currentTimeMillis();
            try {
                PREFS.put("pseudonym", Analytics.pseudonym);
                PREFS.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void saveSettings() {
        try {
            PREFS.putBoolean("phoneHomeAsked", this.phoneHomeAsked);
            PREFS.putBoolean("phoneHomeWithErrors", this.phoneHomeWithErrors);
            PREFS.putDouble("volume", this.volume);
            PREFS.putBoolean("strategicHelp", this.strategicHelp);
            PREFS.putBoolean("strategicRapidCommands", this.strategicRapidCommands);
            PREFS.putDouble("musicVolume", this.musicVolume);
            PREFS.putInt("scrollSpeed", scrollSpeed);
            PREFS.putInt("zoomSpeed", zoomSpeed);
            PREFS.putInt("mouseWheelZoomSpeed", mouseWheelZoomSpeed);
            PREFS.putBoolean("usedv5", true);
            PREFS.put("language", Lang.currentLocale.toLanguageTag());
            PREFS.putBoolean("useSimpleGraphics", Appearance.useSimpleGraphics);
            PREFS.putBoolean("useLighting", Appearance.useLighting);
            PREFS.put("wmSize", this.wmSize);
            PREFS.put("difficulty", this.difficulty);
            PREFS.put("chosenMultiplayerServer", this.chosenMultiplayerServer == null ? "" : this.chosenMultiplayerServer);
            PREFS.put("seaLevelSettingName", this.seaLevelSettingName);
            PREFS.put("monsterityName", this.monsterityName);
            PREFS.put("techSpeedName", this.techSpeedName);
            PREFS.putInt("startingTechTier", this.startingTechTier);
            for (SimplePref sp : SimplePref.values()) {
                sp.save();
            }
            PREFS.putBoolean("multiplayerChatOverlay", multiplayerChatOverlay);
            PREFS.put("guiScale", this.guiScaleOverride == null ? "AUTO" : this.guiScaleOverride.name());
            PREFS.putBoolean("spidersReleased", MainMenu.spidersReleased);
            PREFS.flush();
        }
        catch (Exception e) {
            this.reportError("Unable to save settings.", e, null, false);
        }
    }

    public static void setMultiplayerChatOverlay(boolean mco) {
        multiplayerChatOverlay = mco;
    }

    public AirshipGame() {
        this.loadSettings();
        instance = this;
        System.err.println("Init AirshipGame");
    }

    public boolean isIntegrated() {
        return this.integration != null;
    }

    public CoatOfArms getBestCOA() {
        if (this.integration != null && this.integration.getRegisteredCOAIfAvailable() != null) {
            return this.integration.getRegisteredCOAIfAvailable();
        }
        return CoatEditor.getMyStrategicArms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showHelp(String name, Runnable hideHelpRunnable) {
        String key = name + "_" + Lang.currentLocale.toLanguageTag();
        if (!this.helps.containsKey(key)) {
            BufferedReader r = null;
            try {
                File introF = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "lang"), Lang.currentLocale.toLanguageTag() + "_" + name + "_help.txt");
                r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(introF), "UTF-8"));
                String l = null;
                StringBuilder sb = new StringBuilder();
                while ((l = r.readLine()) != null) {
                    sb.append(l).append("\n");
                }
                this.helps.put(key, sb.toString());
            }
            catch (Exception e) {
                BufferedReader r2 = null;
                try {
                    File introF = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "lang"), "en_" + name + "_help.txt");
                    r2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(introF), "UTF-8"));
                    String l = null;
                    StringBuilder sb = new StringBuilder();
                    while ((l = r2.readLine()) != null) {
                        sb.append(l).append("\n");
                    }
                }
                catch (Exception e2) {
                    this.helps.put(key, "No help available!");
                }
                finally {
                    try {
                        r2.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
        }
        this.helpText = this.helps.get(key);
        this.hideHelpRunnable = hideHelpRunnable;
        this.helpTextScroll.offset = 0;
    }

    public void reportPerformance(PerfReport pr) {
        if (pr == null) {
            return;
        }
        if (this.phoneHomeWithErrors && pr.hasBadPerformance()) {
            this.integration.sendFeedback(pr.toString());
        }
    }

    public void showError(String error) {
        this.error = error;
    }

    public void reportError(String message, Exception e, String detail, boolean fatal) {
        this.reportError(message, e, detail, fatal, false);
    }

    public void reportError(String message, Exception e, String detail, boolean fatal, boolean silent) {
        String origMsg = message;
        try {
            if (message == null) {
                message = e != null ? e.toString() : "";
            } else if (e != null) {
                message = e.toString() + " " + message;
            }
        }
        catch (Exception e2) {
            message = "";
        }
        catch (OutOfMemoryError oome) {
            this.emergencyReserve = null;
            Runtime.getRuntime().gc();
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (e != null) {
                e.printStackTrace(pw);
                pw.flush();
                message = message + "\n\nStack Trace:\n" + sw.toString();
            } else {
                new Throwable().printStackTrace(pw);
                pw.flush();
                message = message + "\n\nStack:\n" + sw.toString();
            }
        }
        catch (Exception sw) {
        }
        catch (OutOfMemoryError oome) {
            this.emergencyReserve = null;
            Runtime.getRuntime().gc();
        }
        if (this.seenErrorMessages.contains(message)) {
            return;
        }
        this.seenErrorMessages.add(message);
        try {
            message = message + "\n\ngamedir " + AGame.getGameDirectory().getAbsolutePath() + "\n";
            message = message + "static " + AGame.getStaticGameDirectory().getAbsolutePath();
        }
        catch (Exception oome) {
        }
        catch (OutOfMemoryError oome) {
            this.emergencyReserve = null;
            Runtime.getRuntime().gc();
        }
        try {
            message = message + "\nsimplegraphics " + Appearance.useSimpleGraphics + " lighting " + Appearance.useLighting;
            message = message + "\nmemory free " + Runtime.getRuntime().freeMemory() + ", total " + Runtime.getRuntime().totalMemory() + ", max " + Runtime.getRuntime().maxMemory();
            if (detail != null) {
                message = message + "\n\nDetail:\n" + CompressAndArmour.compressAndArmour(detail);
            }
        }
        catch (OutOfMemoryError oome) {
            this.emergencyReserve = null;
            Runtime.getRuntime().gc();
        }
        try {
            if (this.s instanceof UniScreen) {
                UniScreen us = (UniScreen)this.s;
                message = message + "\n\nIntent: " + us.intent.getClass().getSimpleName();
                if (us.combat != null) {
                    message = message + "\n\nCombat:\n" + CompressAndArmour.compressAndArmour(us.combat.toJSON().toString());
                }
                if (us.standaloneEditShip != null) {
                    message = message + "\n\nShip:\n" + CompressAndArmour.compressAndArmour(us.standaloneEditShip.toJSON(null).toString());
                }
            }
            if (this.s instanceof StrategicScreen) {
                StrategicScreen ss = (StrategicScreen)this.s;
                message = message + "\n\nWorld:\n" + CompressAndArmour.compressAndArmour(ss.w.toJSON().toString());
            }
        }
        catch (Exception ss) {
        }
        catch (OutOfMemoryError oome) {
            this.emergencyReserve = null;
            Runtime.getRuntime().gc();
        }
        try {
            System.err.println(message);
            System.err.flush();
        }
        catch (Exception oome) {
        }
        catch (OutOfMemoryError oome) {
            this.emergencyReserve = null;
            Runtime.getRuntime().gc();
        }
        if (this.phoneHomeWithErrors && this.isIntegrated() && !this.integration.backend.getMultiplayerServers().isEmpty()) {
            try {
                this.integration.sendFeedback(message);
                if (!silent) {
                    if (origMsg != null) {
                        this.showError(origMsg + " " + Lang._t("error_log_sending", new Object[0]));
                    } else {
                        this.showError(Lang._t("unknown_error_log_sending", new Object[0]));
                    }
                    if (fatal) {
                        this.s = new MainMenu(this, MainMenu.Submenu.MAIN);
                    }
                }
                return;
            }
            catch (Exception oome) {
            }
            catch (OutOfMemoryError oome) {
                this.emergencyReserve = null;
                Runtime.getRuntime().gc();
                this.integration.sendFeedback(origMsg);
            }
        }
        String logPath = AGame.getLogFile().getAbsolutePath();
        if (!silent) {
            if (origMsg != null) {
                this.showError(origMsg + " " + Lang._t("please_send_error_log", logPath, "david.stark@zarkonnen.com"));
            } else {
                this.showError(Lang._t("unknown_error_please_send_error_log", logPath, "david.stark@zarkonnen.com"));
            }
            if (fatal) {
                this.s = new MainMenu(this, MainMenu.Submenu.MAIN);
            }
        }
    }

    public void manageMusic(Input in) {
        if (this.musicVolume == 0.0) {
            in.stopMusic();
            return;
        }
        ArrayList<String> options = this.s.music();
        if (options == null) {
            options = this.currentMusicOptions;
        } else {
            this.currentMusicOptions = options;
        }
        if (this.fading > 0) {
            this.fading -= in.msDelta();
            if (this.fading <= 0) {
                this.currentMusic = null;
            }
        } else {
            if (this.currentMusic != null && options.isEmpty()) {
                this.fading = 2100;
                in.fadeOutMusic(2000);
                return;
            }
            if (this.currentMusic != null && !options.contains(this.currentMusic)) {
                this.fading = 2100;
                in.fadeOutMusic(2000);
                return;
            }
            if (this.currentMusic == null && !options.isEmpty()) {
                this.currentMusic = options.get(AGame.ANIM_R.nextInt(options.size()));
                this.fading = 0;
                in.playMusic(this.currentMusic, this.musicVolume, null, new MusicCallback(){

                    public void run(String music, double volume) {
                        if (AirshipGame.this.fading <= 0) {
                            AirshipGame.this.currentMusic = null;
                        }
                    }
                });
            }
        }
    }

    public void doLowMemoryCheck() {
        Runtime.getRuntime().gc();
        this.msAtLowMemory = 0;
        this.doCheckMemory = true;
    }

    public void memoryWarningTick(int ms) {
        if (this.doCheckMemory) {
            int mbLeft = (int)(Runtime.getRuntime().freeMemory() / 1000000L);
            int mbClaimed = (int)(Runtime.getRuntime().totalMemory() / 1000000L);
            int mbTotalAvailable = (int)(Runtime.getRuntime().maxMemory() / 1000000L);
            if (mbLeft <= 50 && mbClaimed + 50 >= mbTotalAvailable) {
                if (this.msAtLowMemory < 1000 && this.msAtLowMemory + ms >= 1000) {
                    Runtime.getRuntime().gc();
                }
                this.msAtLowMemory += ms;
            } else {
                System.err.println("Memory check: " + mbLeft);
                this.msAtLowMemory = 0;
                this.doCheckMemory = false;
            }
        }
    }

    public boolean lowMemory() {
        return this.msAtLowMemory >= 3000;
    }

    public void setMyNameAndArms() {
        if (this.myName == null) {
            this.myName = SteamBackend.isEnabled() ? SteamBackend.getSteamNickDisplayName() : (this.integration.username != null && this.integration.username.length() > 0 ? this.integration.username : System.getProperty("user.name", "Airships Player " + AGame.ANIM_R.nextInt(10000)));
            this.myArmsJSON = this.getBestCOA().toJSON();
        }
    }

    public void input(Input in) {
        this.time += in.msDelta();
        if (!this.hasRendered && AGame.TICK_RENDER_LOCK) {
            return;
        }
        this.hasRendered = false;
        try {
            Pt cs;
            GUIScale newGUIScale;
            if (this.first) {
                in.setMode(new ScreenMode(800, 600, false));
                Mod.resetLoadBases((SlickEngine.MyInput)in);
                this.first = false;
            }
            if (this.integration != null) {
                this.msSinceIntegration += in.msDelta();
            }
            this.memoryWarningTick(in.msDelta());
            while (this.processClient()) {
            }
            CombatSoundEffects.alwaysTick(this, in);
            GUIScale gUIScale = newGUIScale = this.guiScaleOverride == null ? GUIScale.best(in.mode()) : this.guiScaleOverride;
            if (newGUIScale != this.currentGUIScale) {
                newGUIScale.activate();
            }
            this.currentGUIScale = newGUIScale;
            if (this.s instanceof MainMenu && this.chosenMultiplayerServer != null && !this.checkedMPServer && !this.integration.backend.getMultiplayerServers().isEmpty()) {
                boolean serverFound = false;
                for (Utils.Pair<String, String> server : this.integration.backend.getMultiplayerServers()) {
                    if (!((String)server.b).equals(this.chosenMultiplayerServer)) continue;
                    serverFound = true;
                }
                if (!serverFound) {
                    this.chosenMultiplayerServer = null;
                }
                this.checkedMPServer = true;
            }
            if (this.s instanceof MainMenu && this.overlayServer != null && !this.overlayServer.equals(this.chosenMultiplayerServer)) {
                if (this.client != null) {
                    this.client.close();
                    this.client = null;
                }
                metaLobbyOverlay = null;
            }
            if (this.checkedMPServer && this.canShowMPChatOverlay() && metaLobbyOverlay == null && multiplayerChatOverlay && this.integration != null && !this.integration.backend.getMultiplayerServers().isEmpty() && this.chosenMultiplayerServer != null && (this.msSinceIntegration >= 10000 || this.integration.getRegisteredCOAIfAvailable() != null) && (!SteamBackend.isEnabled() || SteamBackend.hasRealNickname())) {
                if (this.client == null) {
                    this.overlayServer = this.chosenMultiplayerServer;
                    this.setMyNameAndArms();
                    this.client = new Client(this.chosenMultiplayerServer, this);
                    this.client.tick();
                }
                metaLobbyOverlay = new MetaLobbyOverlay(this);
            }
            if (!multiplayerChatOverlay && metaLobbyOverlay != null) {
                metaLobbyOverlay = null;
            }
            if (!this.canShowMPChatOverlay()) {
                this.mpChatOverlayActive = false;
            }
            if (this.client != null && this.client.isMessageTooLarge()) {
                this.showError(Lang._t("generic_message_too_large", new Object[0]));
                this.client.clearMessageTooLarge();
            }
            if (this.lanClient != null && this.lanClient.isMessageTooLarge()) {
                this.showError(Lang._t("generic_message_too_large", new Object[0]));
                this.lanClient.clearMessageTooLarge();
            }
            this.mouseMoved = (cs = in.cursor()) != null && !cs.equals((Object)this.lastCursorPt);
            this.lastCursorPt = cs;
            this.manageMusic(in);
            this.backgroundPlayTimeLeft -= in.msDelta();
            if (in.isCursorVisible() != (SimplePref.SYSTEM_CURSOR.get() || LaunchSettings.forceSystemCursor)) {
                in.setCursorVisible(SimplePref.SYSTEM_CURSOR.get() || LaunchSettings.forceSystemCursor);
            }
            this.cursor = in.cursor();
            this.drawState.tick(in.msDelta(), this.cursor);
            if (this.delayExitForFlush > 0) {
                this.delayExitForFlush -= in.msDelta();
            }
            if (this.delayExitForNetwork > 0) {
                this.delayExitForNetwork -= in.msDelta();
            }
            if (this.error == null) {
                long start;
                this.hs.hit(in);
                if (this.exit && this.delayExitForFlush <= 0 && this.delayExitForNetwork <= 0) {
                    in.quit();
                    System.exit(0);
                    return;
                }
                long l = start = this.showFrameCosts ? System.nanoTime() : 0L;
                if (this.helpText != null) {
                    ScreenMode sm = in.mode();
                    this.helpTextScroll.tick(in, 0, 0, sm.width, sm.height);
                    if (in.keyPressed("ESCAPE")) {
                        this.helpText = null;
                        if (this.hideHelpRunnable != null) {
                            this.hideHelpRunnable.run();
                        }
                        this.hideHelpRunnable = null;
                    }
                } else if (multiplayerChatOverlay && this.canShowMPChatOverlay() && metaLobbyOverlay != null) {
                    if (!this.mpChatOverlayActive || this.s instanceof UniScreen && ((UniScreen)this.s).intent instanceof MultiplayerCombatIntent) {
                        Pt clk = in.clicked();
                        if (clk != null && in.clickButton() > 3) {
                            clk = null;
                        }
                        this.s.input(in, this.drawState, this.cursor, clk, in.msDelta());
                    }
                    if (metaLobbyOverlay != null) {
                        metaLobbyOverlay.input(in, this.drawState, this.cursor, in.clicked(), in.msDelta());
                    }
                } else {
                    Pt clk = in.clicked();
                    if (clk != null && in.clickButton() > 3) {
                        clk = null;
                    }
                    this.s.input(in, this.drawState, this.cursor, clk, in.msDelta());
                }
                if (this.showFrameCosts) {
                    this.frameCosts.add((int)((System.nanoTime() - start) / 100000L));
                    if (this.frameCosts.size() > 300) {
                        this.frameCosts.pollFirst();
                    }
                }
                if (this.exit && this.delayExitForFlush <= 0 && this.delayExitForNetwork <= 0) {
                    in.quit();
                    System.exit(0);
                }
            } else if (in.clicked() != null) {
                this.error = null;
                this.drawState.hasClicked();
            }
            this.hs.list.clear();
            if (this.integration != null) {
                this.integration.tick();
            }
            this.lastMs = in.msDelta();
            SteamBackend.tick();
            Achievement.tick(in.msDelta());
            Analytics.tick(in.msDelta());
            this.msPlayed += (long)in.msDelta();
            if (this.msPlayed > 300000L) {
                this.msPlayed -= 300000L;
                try {
                    PREFS.putInt("M_PLAYED", PREFS.getInt("M_PLAYED", 0) + 5);
                    PREFS.flush();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.flush();
            Exception e = t instanceof Exception ? (Exception)t : new RuntimeException(t);
            this.reportError(null, e, null, true);
        }
    }

    public boolean showReviewQuestion() {
        return PREFS.getInt("M_PLAYED", 0) >= 360 && PREFS.getInt("M_PLAYED", 0) < 1800 && SteamBackend.isEnabled() && new Date().getDate() % 5 == 0;
    }

    private boolean canShowMPChatOverlay() {
        if (this.s instanceof MetaLobbyScreen) {
            return false;
        }
        if (this.s instanceof UniScreen) {
            UniScreen us = (UniScreen)this.s;
            if (us.intent instanceof MultiplayerSetupIntent) {
                return false;
            }
        }
        if (this.s instanceof LoadingScreen) {
            return false;
        }
        return !(this.s instanceof ResChooserScreen);
    }

    public void render(Frame f) {
        this.hasRendered = true;
        try {
            int w;
            if (this.first) {
                return;
            }
            if (Loadable.map.containsKey(SpritesheetBundle.class)) {
                if (this.s.alwaysUseAppearancePostfix() || Appearance.useSimpleGraphics || !Appearance.canUseLighting || !Appearance.useLighting || Appearance.shaderLoadFailed) {
                    Appearance.switchSpritesheet(this.s.appearancePostfix());
                } else {
                    Appearance.switchSpritesheet("");
                }
            }
            this.drawState.resetCursor();
            this.s.render(new MyDraw(f, this.hs, this.drawState, this.integration), f.mode(), this.hs, this.cursor);
            MyDraw d = new MyDraw(f, this.hs, this.drawState, this.integration);
            ScreenMode sm = f.mode();
            if (this.exit) {
                d.drawBG(MyDraw.SCREEN_BG, sm);
                Pt sz = d.textSize(Lang._t("Exiting", new Object[0]), AGame.BIGGER_FOUNT);
                d.text(Lang._t("Exiting", new Object[0]), AGame.BIGGER_FOUNT, sm.width / 2 - (int)sz.x / 2, sm.height / 3);
                if (this.time / 500 % 2 == 0) {
                    d.blit(new Img("ui", 192, 368, 16, 16, false), sm.width / 2 - 8, sm.height / 3 - 16 - MyDraw.UI_SPACING);
                }
            } else {
                if (multiplayerChatOverlay && this.canShowMPChatOverlay() && metaLobbyOverlay != null) {
                    if (this.mpChatOverlayActive) {
                        this.drawState.glowRects.clear();
                        this.hs.list.clear();
                        d.rect(ERR_BG_TINT, 0.0, 0.0, sm.width, sm.height);
                    }
                    metaLobbyOverlay.render(d, sm, this.hs, this.cursor);
                }
                if (this.cursor != null && this.drawState.cursorText != null && this.drawState.cursorAppearance != null) {
                    d.text(this.drawState.cursorText, AGame.FOUNT, this.cursor.x + (double)this.drawState.cursorAppearance.dx(this.currentGUIScale), this.cursor.y + (double)this.drawState.cursorAppearance.dy(this.currentGUIScale) + 18.0);
                }
                if (this.drawState.ticksSinceMouseMoved > 20 && !this.drawState.tooltipText.isEmpty() && this.cursor != null && this.drawState.cursorAppearance != null) {
                    int ttY;
                    int ttw = AGame.FOUNT.displayWidth * 20 + 150;
                    Rect sz = d.textSize(this.drawState.tooltipText, AGame.FOUNT, 0.0, 0.0, ttw);
                    int ttH = (int)sz.height;
                    int ttW = (int)sz.width;
                    int ttX = (int)this.cursor.x + this.drawState.cursorAppearance.dx(this.currentGUIScale) + 16;
                    if (ttX + ttW + MyDraw.PANEL_INSET * 2 + 16 >= sm.width) {
                        ttX = sm.width - (ttW + MyDraw.PANEL_INSET * 2 + 16);
                    }
                    if (this.drawState.maxTooltipX != -1) {
                        ttX = StrictMath.min(ttX, this.drawState.maxTooltipX - ttW);
                    }
                    if ((ttY = (int)this.cursor.y + this.drawState.cursorAppearance.dy(this.currentGUIScale) + 18) + ttH + MyDraw.PANEL_INSET * 2 + 16 >= sm.height) {
                        ttY = sm.height - (ttH + MyDraw.PANEL_INSET * 2 + 16);
                    }
                    d.drawShadowedPanel(ttX, ttY, ttW + MyDraw.PANEL_INSET * 2, ttH + MyDraw.PANEL_INSET * 2);
                    d.text(this.drawState.tooltipText, AGame.FOUNT, ttX + MyDraw.PANEL_INSET, ttY + MyDraw.PANEL_INSET, ttw);
                }
                if (this.helpText != null) {
                    int w2 = sm.width / 2;
                    int x = sm.width / 2 - w2 / 2;
                    int y = MyDraw.SIDE_CLEARANCE;
                    int h = sm.height - MyDraw.SIDE_CLEARANCE * 2;
                    d.drawShadowedWindow(x, y, w2, h);
                    int scrollH = (h -= MyDraw.WINDOW_INSET * 2) - MyDraw.BUTTON_H - MyDraw.UI_SPACING;
                    this.drawState.glowRects.clear();
                    this.hs.list.clear();
                    this.helpTextScroll.draw(d, x += MyDraw.WINDOW_INSET, y += MyDraw.WINDOW_INSET, w2 -= MyDraw.WINDOW_INSET * 2, scrollH, Collections.singletonList(this.helpText), new TextAdapter());
                    d.button(x, y + scrollH + MyDraw.UI_SPACING, d.bw(Lang._t("OK", new Object[0])), Lang._t("OK", new Object[0]), new Runnable(){

                        @Override
                        public void run() {
                            AirshipGame.this.helpText = null;
                            if (AirshipGame.this.hideHelpRunnable != null) {
                                AirshipGame.this.hideHelpRunnable.run();
                            }
                            AirshipGame.this.hideHelpRunnable = null;
                        }
                    });
                }
                if (!SteamBackend.isEnabled() && Achievement.getRecentAchievement() != null) {
                    Achievement rec = Achievement.getRecentAchievement();
                    String txt = "Achievement unlocked:\n" + rec.displayName + "\n" + rec.desc;
                    Pt sz = d.textSize(txt, AGame.FOUNT);
                    w = 79 + (int)sz.x;
                    int h2 = 74;
                    d.drawPanel(sm.width - w, sm.height - h2, w, h2);
                    d.blit(rec.logo, sm.width - w + 5, sm.height - h2 + 5);
                    d.text(txt, AGame.FOUNT, sm.width - w + 5 + 64 + 5, sm.height - h2 + 5);
                }
            }
            if (this.error != null) {
                d.rect(ERR_BG_TINT, 0.0, 0.0, sm.width, sm.height);
                int w3 = StrictMath.max(400, sm.width / 2);
                int h = (int)d.textSize((String)this.error, (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)(w3 - MyDraw.WINDOW_INSET * 2)).height + MyDraw.WINDOW_INSET * 2;
                int x = sm.width / 2 - w3 / 2;
                int y = sm.height / 2 - h / 2;
                try {
                    d.drawShadowedWindow(x, y, w3, h);
                    x += MyDraw.WINDOW_INSET;
                    y += MyDraw.WINDOW_INSET;
                    w3 -= MyDraw.WINDOW_INSET * 2;
                    h -= MyDraw.WINDOW_INSET * 2;
                }
                catch (Exception h2) {
                    // empty catch block
                }
                d.text(this.error, AGame.FOUNT, x, y, w3);
            }
            if (this.showFrameCosts) {
                this.drawFrameCosts(d, f.mode());
            }
            this.updateUIGlowRects(this.lastMs, this.drawState);
            if (MyDraw.UI_GLOW_COLOR.a > 0) {
                for (UIGlowRect r : this.drawState.glowRects.values()) {
                    if (r.hoverMs <= 0) continue;
                    Clr c = new Clr(MyDraw.UI_GLOW_COLOR.r, MyDraw.UI_GLOW_COLOR.g, MyDraw.UI_GLOW_COLOR.b, StrictMath.min(255, MyDraw.UI_GLOW_COLOR.a * r.hoverMs / 255));
                    d.rect(c, r.x, r.y, r.w, r.h);
                }
            }
            if ((!(this.s instanceof LoadingScreen) || this.s instanceof UniScreen && ((UniScreen)this.s).intent instanceof PlaybackIntent && ((PlaybackIntent)((UniScreen)this.s).intent).takeGifUntil != -1) && this.drawState.cursorAppearance != null && !SimplePref.SYSTEM_CURSOR.get() && !LaunchSettings.forceSystemCursor) {
                this.drawState.cursorAppearance.draw(d, this.cursor.x, this.cursor.y, this.currentGUIScale);
            }
            if (AGame.debugCursor()) {
                d.rect(Clr.BLACK, 0.0, 0.0, 100.0, AGame.FOUNT.height * 5);
                d.text("x1 " + f.cursor().x + "\ny1 " + f.cursor().y + "\nx2 " + Mouse.getX() + "\ny2 " + Mouse.getY(), AGame.FOUNT, 10.0, 10.0);
            }
            if (this.lowMemory()) {
                int mbLeft = (int)(Runtime.getRuntime().freeMemory() / 1000000L);
                String lms = Lang._t("low_memory_warning", new Object[0]);
                lms = lms + " (" + mbLeft + "/" + Runtime.getRuntime().totalMemory() / 1000000L + "/" + Runtime.getRuntime().maxMemory() / 1000000L + ")";
                Rect r = d.textSize(lms, AGame.FOUNT, 0.0, 0.0, sm.width - MyDraw.SIDE_CLEARANCE * 2);
                w = (int)r.width;
                int h = (int)r.height;
                d.drawPanel(sm.width / 2 - w / 2 - MyDraw.PANEL_INSET, sm.height - h - MyDraw.PANEL_INSET * 2, w + MyDraw.PANEL_INSET * 2, h + MyDraw.PANEL_INSET * 4);
                d.text(MyDraw.ERROR_C + lms, AGame.FOUNT, sm.width / 2 - w / 2, sm.height - h - MyDraw.PANEL_INSET);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.flush();
            Exception e = t instanceof Exception ? (Exception)t : new RuntimeException(t);
            this.reportError(null, e, null, true);
        }
    }

    public void drawFrameCosts(Draw d, ScreenMode sm) {
        int x = sm.width - 305;
        d.rect(Clr.WHITE, (double)x, 200.0, 300.0, 1.0);
        Iterator i$ = this.frameCosts.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            d.rect(Clr.WHITE, (double)x, (double)(360 - i), 1.0, (double)i);
            ++x;
        }
    }

    public void handle(Exception e, boolean fatal) {
        if (!this.swallowExceptions) {
            this.reportError(null, e, null, fatal);
        }
    }

    public void updateUIGlowRects(int ms, MyDraw.State s) {
        Iterator<UIGlowRect> it = s.glowRects.values().iterator();
        while (it.hasNext()) {
            UIGlowRect r = it.next();
            if (!r.confirmed) {
                it.remove();
                continue;
            }
            r.confirmed = false;
            if (Rect.contains((double)r.x, (double)r.y, (double)r.w, (double)r.h, (Pt)this.cursor)) {
                r.hoverMs = StrictMath.min(512, r.hoverMs + ms * 2);
                continue;
            }
            r.hoverMs = StrictMath.max(0, r.hoverMs - ms);
        }
    }

    public int outQueueSize() {
        if (this.lanClient != null) {
            return this.lanClient.outQueueSize();
        }
        if (this.client != null) {
            return this.client.outQueueSize();
        }
        return 0;
    }

    public int inQueueSize() {
        if (this.lanClient != null) {
            return this.lanClient.inQueueSize();
        }
        if (this.client != null) {
            return this.client.inQueueSize();
        }
        return 0;
    }

    public void tickClients() {
        if (this.lanClient != null) {
            this.lanClient.tick();
        }
        if (this.client != null) {
            this.client.tick();
        }
        while (this.processClient()) {
        }
    }

    public boolean isReconnecting() {
        if (this.lanClient != null) {
            return this.lanClient.isReconnecting();
        }
        if (this.client != null) {
            return this.client.isReconnecting();
        }
        return false;
    }

    public long ping() {
        if (this.lanClient != null) {
            return this.lanClient.smoothedRecentPing();
        }
        if (this.client != null) {
            return this.client.smoothedRecentPing();
        }
        return 0L;
    }

    public void report(String s, Throwable t) {
        this.reportError(s, new RuntimeException(t), null, false, true);
    }
}

