/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Arc;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Decal;
import com.zarkonnen.airships.DecalType;
import com.zarkonnen.airships.Direction;
import com.zarkonnen.airships.EditPalettePanel;
import com.zarkonnen.airships.ExceptionalCombatEvent;
import com.zarkonnen.airships.FireMode;
import com.zarkonnen.airships.Foot;
import com.zarkonnen.airships.Fragment;
import com.zarkonnen.airships.GameSetting;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.GridLocation;
import com.zarkonnen.airships.GridRef;
import com.zarkonnen.airships.Job;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Leg;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MiscCombatSound;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.PhysicsRect;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.airships.RotatingColoringShader;
import com.zarkonnen.airships.RotatingShader;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipLayers;
import com.zarkonnen.airships.ShipList;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.Shot;
import com.zarkonnen.airships.Spring;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.TileMask;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.WeaponAppearance;
import com.zarkonnen.airships.WheelBody;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;

public strictfp class Airship
extends GridBody
implements Comparator<Job>,
Cloneable {
    public static final Clr ARMOUR_BACK = new Clr(90, 90, 90);
    public static final Clr INSIDE = new Clr(70, 70, 70);
    public static final Clr LIT_EDGE = new Clr(255, 255, 255, 30);
    public static final Clr DARK_EDGE = new Clr(0, 0, 0, 70);
    public static final Clr HP_BG = new Clr(40, 40, 40, 128);
    public static final Clr COAL_FG = new Clr(200, 200, 200);
    public static final Clr COAL_REAL_FG = new Clr(20, 20, 20);
    public static final Clr WATER_FG = new Clr(112, 155, 204);
    public static final Clr REPAIR_FG = new Clr(200, 184, 79);
    public static final Clr AMMO_FG = new Clr(187, 66, 29);
    public static final double SPEED_TO_PX_PER_MS = 0.05;
    public static final double DROP_SPEED_PER_MS = 0.1;
    public static final double DRIFT_DOWN_SPEED_PER_MS = 0.4;
    public static final double FALL_SPEED_PER_MS = 0.75;
    public static final int MS_UNTIL_FULL_SPEED = 1500;
    public transient Combat CURRENT_COMBAT_DELETEME = null;
    public String networkID = "[no network ID]";
    public int chunkSubIDCounter = 1;
    public String designName;
    public boolean focusOnShooting = true;
    public boolean focusOnRepair = false;
    public boolean focusOnFirefighting = false;
    public boolean focusOnMoving = false;
    public MoveMode moveMode = MoveMode.DEFAULT;
    public Pt moveTo = new Pt(0.0, 0.0);
    public boolean flipTo = false;
    public boolean ramming = false;
    public boolean grounding = false;
    public boolean sitting = false;
    public int flipMs = 0;
    public int unableToFlipMs = 0;
    public Airship fireAt;
    public Airship board;
    public Airship tetherAt;
    public FireMode fireMode = FireMode.NORMAL;
    public int outOfCombatMs = 0;
    public Tile boardExitTargetCache = null;
    public boolean isBonusConstruction;
    private int canDoPathingIndex = 0;
    private int boarderCanDoPathingIndex = 0;
    public int commandPoints = 0;
    public static final int ASSIGN_JOBS_EVERY = 300;
    public int assignJobsMs = 300;
    public static final int[][] ADJ = new int[][]{{-1, 0}, {0, -1}, {1, 0}, {0, 1}};
    private String name;
    public ArrayList<Module> modules = new ArrayList();
    public ArrayList<Tile> tiles = new ArrayList();
    public ArrayList<Crewman> crew = new ArrayList();
    public ArrayList<Crewman> boarders = new ArrayList();
    public ArrayList<Decal> decals = new ArrayList();
    private int w;
    private int h;
    public boolean captured = false;
    public int msSinceLastXMove = 0;
    public boolean flipped = false;
    public int braking = 0;
    public int hasBraked = 0;
    public transient boolean showingOutside = false;
    public transient int weight = 0;
    public transient boolean cachedGroundOffsetCalculated = false;
    public transient double cachedGroundOffset;
    public int timeMovingInSameXDirection = 0;
    public boolean movingLeft = false;
    public int popOutCooldown = 0;
    private Airship originalDesign;
    public Pt lastPlaced;
    public boolean lastPlacedFlipped;
    private transient double prevDx = 0.0;
    private transient double prevDy = 0.0;
    public transient double mechStress;
    public transient int fallingTime = 0;
    public transient double explosionAmount = 0.0;
    public transient double moduleLossAmount = 0.0;
    public transient boolean biggestInFleet = false;
    public transient boolean reportFootingLoss = false;
    public transient boolean footingLossReported = false;
    public transient double flagFlipAccum;
    public transient double smoothedXSpeed;
    public transient double smoothedYSpeed;
    public transient boolean hasHadSpringFriction = false;
    private int originalAmmoCapacity = -1;
    private int originalCoalCapacity = -1;
    private int originalWaterCapacity = -1;
    private int originalRepairCapacity = -1;
    private int originalAllQuartered = -1;
    public transient HashSet<ModuleType> fixers = new HashSet();
    public int msSinceOnGround;
    public LandFormation lastGrounded;
    public boolean enginesRunning;
    public boolean suspendiumRunning;
    public ShipType type;
    public BonusSet constructionBonuses = new BonusSet();
    public BonusSet currentBonuses = new BonusSet();
    public HashMap<Tile, HashMap<Module, ArrayList<Tile>>> paths = new HashMap();
    private HashMap<Tile, HashMap<Tile, ArrayList<Tile>>> tilePaths = new HashMap();
    private int crashSize = 0;
    private transient int crashCooldown = 0;
    private transient Tile[][] tileGrid = null;
    public transient TacticalAI ai;
    public transient boolean aiTmpCanMove;
    public transient int aiTmpAvailableLift;
    public transient boolean fireOrderSpoken;
    public transient boolean ramOrderSpoken;
    public transient boolean wasReadyForCommand = true;
    public transient int msUntilNextSailFlap = 0;
    public transient ArrayList<Airship> justRammedBy = new ArrayList();
    public transient ArrayList<Airship> justCollidedWith = new ArrayList();
    public transient boolean collidedWithFloatingRock;
    public transient int msSuspendiumOff;
    private static boolean reportBadDouble = true;
    static String nt = "[bb421d]" + Lang._t("No_target_available", new Object[0]);
    public static Color FIRE_ARC_ARC = new Color(255, 255, 255, 120);
    public static Color FIRE_ARC_LINE = new Color(255, 255, 255, 180);
    public static Color FIRE_ARC_DISABLED_ARC = new Color(187, 66, 29, 120);
    public static Color FIRE_ARC_DISABLED_LINE = new Color(187, 66, 29);
    private final transient HashSet<SpritesheetBundle> additionalSSBs = new HashSet();
    private final transient HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs = new HashSet();
    public static final Clr DOOR_FREE = new Clr(180, 255, 180);
    public static final Clr DOOR_PRESENT = Clr.fromHex((String)"4d370d");
    public static final Clr DISCONNECTED = new Clr(200, 30, 30, 90);
    private transient ArrayList<ModuleType> accuracyBonusTypes;
    public transient double dangerCache = 0.0;
    public transient double legBalanceFactor = 1.0;

    public boolean containsModule(Module m) {
        if (m == null) {
            return false;
        }
        Tile t = this.tileAt(m.x, m.y);
        return t != null && t.module == m;
    }

    public boolean containsTile(Tile t) {
        return t != null && t == this.tileAt(t.x, t.y);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = AGame.makeFileSafe(name);
    }

    public void updateOriginalDesign() {
        this.originalDesign = null;
        this.originalDesign = this.clone();
    }

    public Airship getOriginalDesign() {
        return this.originalDesign;
    }

    public double getCachedGroundOffset() {
        if (!this.cachedGroundOffsetCalculated) {
            this.cachedGroundOffset = this.groundOffset();
            this.cachedGroundOffsetCalculated = true;
        }
        return this.cachedGroundOffset;
    }

    public void setFlipped(boolean fl2, Combat c) {
        if (fl2 != this.flipped) {
            this.flipped = fl2;
            for (Module m : this.modules) {
                m.weaponAngle = Direction.flipHorizontal(m.weaponAngle);
                m.setTentaclesFlipped(fl2);
            }
            for (Particle p : this.stuckParticles) {
                p.x = this.getBBWidth() - p.x;
            }
            if (c != null) {
                ArrayList<LandFormation> floaters = new ArrayList<LandFormation>(c.landFormations);
                floaters.remove(0);
                for (Module m : this.modules) {
                    m.resetLegs(c.landFormations.get(0), floaters);
                }
                for (Combat.Side s : c.sides) {
                    for (Crewman cm : s.troops) {
                        if (cm.attachedTo != this) continue;
                        cm.setX(this.getX() + (this.getBBWidth() - (cm.getX() - this.getX())));
                    }
                }
            }
        }
        this.flipped = fl2;
    }

    private double cleanDouble(String name, double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            if (reportBadDouble) {
                reportBadDouble = false;
                AirshipGame.instance.reportError("Bad double value for " + name + " in ship", null, null, false, true);
            }
            return 0.0;
        }
        return d;
    }

    public JSONObject toJSON(Combat combat) {
        JSONObject o = new JSONObject().put("name", AGame.makeFileSafe(this.getName())).put("type", this.type.name()).put("x", this.cleanDouble("x", this.getX())).put("y", this.cleanDouble("y", this.getY())).put("w", this.w).put("h", this.h).put("flipped", this.flipped).put("xSpeed", this.cleanDouble("xSpeed", this.getxSpeed())).put("ySpeed", this.cleanDouble("ySpeed", this.getySpeed())).put("assignJobsMs", this.assignJobsMs).put("commandPoints", this.commandPoints).put("focusOnShooting", this.focusOnShooting).put("focusOnFirefighting", this.focusOnFirefighting).put("focusOnRepair", this.focusOnRepair).put("focusOnMoving", this.focusOnMoving).put("fireMode", this.fireMode.name()).put("flipTo", this.flipTo).put("flipMs", this.flipMs).put("unableToFlipMs", this.unableToFlipMs).put("msSinceOnGround", this.msSinceOnGround).put("captured", this.captured).put("networkID", this.networkID).put("chunkSubIDCounter", this.chunkSubIDCounter).put("sitting", this.sitting).put("grounding", this.grounding).put("msSinceLastXMove", this.msSinceLastXMove).put("braking", this.braking).put("hasBraked", this.hasBraked).put("timeMovingInSameXDirection", this.timeMovingInSameXDirection).put("movingLeft", this.movingLeft).put("enginesRunning", this.enginesRunning).put("suspendiumRunning", this.suspendiumRunning).put("outOfCombatMs", this.outOfCombatMs).put("boardExitTargetCache", this.tiles.indexOf(this.boardExitTargetCache)).put("popOutCooldown", this.popOutCooldown).put("canDoPathingIndex", this.canDoPathingIndex).put("boarderCanDoPathingIndex", this.boarderCanDoPathingIndex).put("originalAmmoCapacity", this.originalAmmoCapacity).put("originalCoalCapacity", this.originalCoalCapacity).put("originalWaterCapacity", this.originalWaterCapacity).put("originalRepairCapacity", this.originalRepairCapacity).put("originalAllQuartered", this.originalAllQuartered).put("isBonusConstruction", this.isBonusConstruction);
        ArrayList<Mod> usedMods = this.getUsedMods();
        JSONArray uma = new JSONArray();
        o.put("usedMods", uma);
        for (Mod m : usedMods) {
            uma.put(new JSONObject().put("id", m.id).put("en", m.getIdeallyEnglishName()));
        }
        if (this.lastPlaced != null) {
            o.put("lastPlacedX", this.lastPlaced.x);
            o.put("lastPlacedY", this.lastPlaced.y);
            o.put("lastPlacedFlipped", this.lastPlacedFlipped);
        }
        if (this.designName != null) {
            o.put("designName", this.designName);
        }
        if (this.moveTo != null) {
            o.put("moveToX", this.moveTo.x).put("moveToY", this.moveTo.y).put("ramming", this.ramming);
            o.put("moveMode", this.moveMode.name());
        }
        if (this.originalDesign != null) {
            o.put("originalDesign", this.originalDesign.toJSON(null));
        }
        if (combat != null && this.jumpPointCache != null && this.jumpPointCacheTarget != null) {
            o.put("jumpPointCacheX", this.jumpPointCache.gridX);
            o.put("jumpPointCacheY", this.jumpPointCache.gridY);
            if (combat.landFormations.contains(this.jumpPointCacheTarget)) {
                o.put("jumpPointCacheTargetLF", combat.landFormations.indexOf(this.jumpPointCacheTarget));
            } else {
                for (Combat.Side s : combat.sides) {
                    if (!s.ships.contains(this.jumpPointCacheTarget)) continue;
                    o.put("jumpPointCacheTargetSide", combat.sides.indexOf(s));
                    o.put("jumpPointCacheTargetShip", s.ships.indexOf(this.jumpPointCacheTarget));
                }
            }
        }
        if (combat != null && this.fallPointCache != null && this.fallPointCacheTarget != null) {
            o.put("fallPointCacheX", this.fallPointCache.gridX);
            o.put("fallPointCacheY", this.fallPointCache.gridY);
            if (combat.landFormations.contains(this.fallPointCacheTarget)) {
                o.put("fallPointCacheTargetLF", combat.landFormations.indexOf(this.fallPointCacheTarget));
            } else {
                for (Combat.Side s : combat.sides) {
                    if (!s.ships.contains(this.fallPointCacheTarget)) continue;
                    o.put("fallPointCacheTargetSide", combat.sides.indexOf(s));
                    o.put("fallPointCacheTargetShip", s.ships.indexOf(this.fallPointCacheTarget));
                }
            }
        }
        if (combat != null && this.fireAt != null) {
            int fireAtSideIndex = -1;
            int fireAtShipIndex = -1;
            for (Combat.Side side : combat.sides) {
                for (Airship ship : side.ships) {
                    if (ship != this.fireAt) continue;
                    fireAtSideIndex = combat.sides.indexOf(side);
                    fireAtShipIndex = side.ships.indexOf(ship);
                }
            }
            if (fireAtShipIndex != -1) {
                o.put("fireAtSideIndex", fireAtSideIndex).put("fireAtShipIndex", fireAtShipIndex);
            }
        }
        if (combat != null && this.board != null) {
            int boardSideIndex = -1;
            int boardShipIndex = -1;
            for (Combat.Side side : combat.sides) {
                for (Airship ship : side.ships) {
                    if (ship != this.board) continue;
                    boardSideIndex = combat.sides.indexOf(side);
                    boardShipIndex = side.ships.indexOf(ship);
                }
            }
            if (boardShipIndex != -1) {
                o.put("boardSideIndex", boardSideIndex).put("boardShipIndex", boardShipIndex);
            }
        }
        if (combat != null && this.tetherAt != null) {
            int tetherAtSideIndex = -1;
            int tetherAtShipIndex = -1;
            for (Combat.Side side : combat.sides) {
                for (Airship ship : side.ships) {
                    if (ship != this.tetherAt) continue;
                    tetherAtSideIndex = combat.sides.indexOf(side);
                    tetherAtShipIndex = side.ships.indexOf(ship);
                }
            }
            if (tetherAtShipIndex != -1) {
                o.put("tetherAtSideIndex", tetherAtSideIndex).put("tetherAtShipIndex", tetherAtShipIndex);
            }
        }
        if (combat != null && this.lastGrounded != null && combat.landFormations.contains(this.lastGrounded)) {
            o.put("lastGrounded", combat.landFormations.indexOf(this.lastGrounded));
        }
        JSONArray a = new JSONArray();
        o.put("modules", a);
        for (Module m : this.modules) {
            a.put(m.toJSON(combat));
        }
        a = new JSONArray();
        o.put("tiles", a);
        for (Tile t : this.tiles) {
            a.put(t.toJSON());
        }
        a = new JSONArray();
        o.put("crew", a);
        for (Crewman c : this.crew) {
            a.put(c.toJSON(combat));
        }
        a = new JSONArray();
        o.put("boarders", a);
        for (Crewman c : this.boarders) {
            a.put(c.toJSON(combat));
        }
        a = new JSONArray();
        o.put("decals", a);
        for (Decal d : this.decals) {
            a.put(d.toJSON());
        }
        a = new JSONArray();
        o.put("carrying", a);
        a = new JSONArray();
        o.put("constructionBonuses", a);
        for (Bonus b : this.constructionBonuses.list()) {
            a.put(b.name());
        }
        a = new JSONArray();
        o.put("currentBonuses", a);
        for (Bonus b : this.currentBonuses.list()) {
            a.put(b.name());
        }
        return o;
    }

    public Airship(JSONObject o) {
        int i;
        JSONArray a;
        this.name = o.getString("name");
        this.designName = o.optString("designName", null);
        this.networkID = o.optString("networkID", "[no network ID]");
        this.chunkSubIDCounter = o.optInt("chunkSubIDCounter", 1);
        this.type = ShipType.valueOf(o.optString("type", ShipType.AIRSHIP.name()));
        this.setX(o.getDouble("x"));
        this.setY(o.getDouble("y"));
        this.w = o.getInt("w");
        this.h = o.getInt("h");
        this.flipped = o.getBoolean("flipped");
        this.setxSpeed(o.optDouble("xSpeed", 0.0));
        this.setySpeed(o.optDouble("ySpeed", 0.0));
        this.assignJobsMs = o.optInt("assignJobsMs", 300);
        this.commandPoints = o.optInt("commandPoints", 0);
        this.focusOnShooting = o.optBoolean("focusOnShooting", false);
        this.focusOnFirefighting = o.optBoolean("focusOnFirefighting", false);
        this.focusOnRepair = o.optBoolean("focusOnRepair", false);
        this.focusOnMoving = o.optBoolean("focusOnMoving", false);
        this.fireMode = FireMode.valueOf(o.optString("fireMode", FireMode.NORMAL.name()));
        this.flipTo = o.optBoolean("flipTo", o.getBoolean("flipped"));
        this.flipMs = o.optInt("flipMs", 0);
        this.unableToFlipMs = o.optInt("unableToFlipMs", 0);
        this.msSinceOnGround = o.optInt("msSinceOnGround", 10000);
        this.captured = o.optBoolean("captured", false);
        this.sitting = o.optBoolean("sitting", false);
        this.grounding = o.optBoolean("grounding", false);
        this.msSinceLastXMove = o.optInt("msSinceLastXMove", 0);
        this.braking = o.optInt("braking", 0);
        this.hasBraked = o.optInt("hasBraked", 0);
        this.timeMovingInSameXDirection = o.optInt("timeMovingInSameXDirection", 0);
        this.movingLeft = o.optBoolean("movingLeft", false);
        this.enginesRunning = o.optBoolean("enginesRunning", false);
        this.suspendiumRunning = o.optBoolean("suspendiumRunning", false);
        this.outOfCombatMs = o.optInt("outOfCombatMs", 0);
        this.popOutCooldown = o.optInt("popOutCooldown", 0);
        this.canDoPathingIndex = o.optInt("canDoPathingIndex", 0);
        this.boarderCanDoPathingIndex = o.optInt("boarderCanDoPathingIndex", 0);
        this.originalAmmoCapacity = o.optInt("originalAmmoCapacity", -1);
        this.originalCoalCapacity = o.optInt("originalCoalCapacity", -1);
        this.originalWaterCapacity = o.optInt("originalWaterCapacity", -1);
        this.originalRepairCapacity = o.optInt("originalRepairCapacity", -1);
        this.originalAllQuartered = o.optInt("originalAllQuartered", -1);
        this.isBonusConstruction = o.optBoolean("isBonusConstruction", false);
        if (o.has("originalDesign")) {
            this.originalDesign = new Airship(o.getJSONObject("originalDesign"));
        }
        if (o.has("moveToX")) {
            this.moveTo = new Pt(o.getDouble("moveToX"), o.getDouble("moveToY"));
            this.moveMode = MoveMode.valueOf(o.optString("moveMode", MoveMode.DEFAULT.name()));
        }
        if (o.has("lastPlacedX")) {
            this.lastPlaced = new Pt(o.getDouble("lastPlacedX"), o.getDouble("lastPlacedY"));
            this.lastPlacedFlipped = o.getBoolean("lastPlacedFlipped");
        }
        this.ramming = o.optBoolean("ramming", false);
        if (o.has("constructionBonuses")) {
            a = o.getJSONArray("constructionBonuses");
            for (i = 0; i < a.length(); ++i) {
                if (!Loadable.hasOfName(Bonus.class, a.getString(i))) continue;
                this.constructionBonuses.add(Bonus.ofNameOrNone(a.getString(i)));
            }
        }
        if (o.has("currentBonuses")) {
            a = o.getJSONArray("currentBonuses");
            for (i = 0; i < a.length(); ++i) {
                if (!Loadable.hasOfName(Bonus.class, a.getString(i))) continue;
                this.currentBonuses.add(Bonus.ofNameOrNone(a.getString(i)));
            }
        }
        a = o.getJSONArray("modules");
        for (i = 0; i < a.length(); ++i) {
            this.modules.add(new Module(a.getJSONObject(i), this));
        }
        a = o.getJSONArray("tiles");
        for (i = 0; i < a.length(); ++i) {
            this.tiles.add(new Tile(a.getJSONObject(i), this));
        }
        a = o.getJSONArray("crew");
        for (i = 0; i < a.length(); ++i) {
            this.crew.add(new Crewman(a.getJSONObject(i), this, null));
        }
        if (o.has("boarders")) {
            a = o.getJSONArray("boarders");
            for (i = 0; i < a.length(); ++i) {
                this.boarders.add(new Crewman(a.getJSONObject(i), null, this));
            }
        }
        if (o.has("decals")) {
            a = o.getJSONArray("decals");
            for (i = 0; i < a.length(); ++i) {
                this.decals.add(new Decal(a.getJSONObject(i)));
            }
        }
        if (o.optInt("boardExitTargetCache", -1) != -1) {
            this.boardExitTargetCache = this.tiles.get(o.getInt("boardExitTargetCache"));
        }
        this.checkAndRepairTilesAndCrew();
        this.layout();
        this.recalcHPs();
    }

    public void finish(JSONObject o, Combat combat) {
        int i;
        JSONArray a = o.getJSONArray("modules");
        for (i = 0; i < a.length(); ++i) {
            this.modules.get(i).finish(a.getJSONObject(i), combat);
        }
        if (o.has("fireAtSideIndex")) {
            this.fireAt = combat.sides.get((int)o.getInt((String)"fireAtSideIndex")).ships.get(o.getInt("fireAtShipIndex"));
        }
        if (o.has("boardSideIndex")) {
            this.board = combat.sides.get((int)o.getInt((String)"boardSideIndex")).ships.get(o.getInt("boardShipIndex"));
        }
        if (o.has("tetherAtSideIndex") && o.has("tetherAtShipIndex")) {
            this.tetherAt = combat.sides.get((int)o.getInt((String)"tetherAtSideIndex")).ships.get(o.getInt("tetherAtShipIndex"));
        }
        a = o.getJSONArray("crew");
        for (i = 0; i < a.length(); ++i) {
            this.crew.get(i).finishLoading(a.getJSONObject(i), combat);
        }
        if (o.has("boarders")) {
            a = o.getJSONArray("boarders");
            for (i = 0; i < a.length(); ++i) {
                this.boarders.get(i).finishLoading(a.getJSONObject(i), combat);
            }
        }
        if (o.has("lastGrounded")) {
            this.lastGrounded = combat.landFormations.get(o.getInt("lastGrounded"));
        }
        if (o.has("jumpPointCacheTargetLF")) {
            this.jumpPointCacheTarget = combat.landFormations.get(o.getInt("jumpPointCacheTargetLF"));
            this.jumpPointCache = new GridRef(o.getInt("jumpPointCacheX"), o.getInt("jumpPointCacheY"), this);
        }
        if (o.has("jumpPointCacheTargetSide")) {
            this.jumpPointCacheTarget = combat.sides.get((int)o.getInt((String)"jumpPointCacheTargetSide")).ships.get(o.getInt("jumpPointCacheTargetShip"));
            this.jumpPointCache = new GridRef(o.getInt("jumpPointCacheX"), o.getInt("jumpPointCacheY"), this);
        }
        if (o.has("fallPointCacheTargetLF")) {
            this.fallPointCacheTarget = combat.landFormations.get(o.getInt("fallPointCacheTargetLF"));
            this.fallPointCache = new GridRef(o.getInt("fallPointCacheX"), o.getInt("fallPointCacheY"), this);
        }
        if (o.has("fallPointCacheTargetSide")) {
            this.fallPointCacheTarget = combat.sides.get((int)o.getInt((String)"fallPointCacheTargetSide")).ships.get(o.getInt("fallPointCacheTargetShip"));
            this.fallPointCache = new GridRef(o.getInt("fallPointCacheX"), o.getInt("fallPointCacheY"), this);
        }
    }

    public static String getRandomName(ShipType type, Locale l, Random r) {
        switch (type) {
            case BUILDING: {
                return AGame.getBuildingName(l, r);
            }
        }
        return AGame.getShipName(l, r);
    }

    public Airship(ShipType type, Locale l, Random r) {
        this.type = type;
        this.name = Airship.getRandomName(type, l, r);
    }

    public Airship(ShipType type) {
        this.type = type;
        this.name = "?";
    }

    public int gridXToWorldX(int xVal, int spriteW) {
        return this.flipped ? this.w - xVal - spriteW : xVal;
    }

    public int gridXToWorldX(int xVal, int spriteW, boolean fl) {
        return fl ? this.w - xVal - spriteW : xVal;
    }

    public void drawOutline(Draw d, double x, double y, boolean oFlipped, Clr c) {
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            d.rect(c, x + (double)(this.gridXToWorldX(t.x, 1, oFlipped) * 16), y + (double)(t.y * 16), 16.0, 16.0);
        }
    }

    public void drawFireArcs(Draw d, double scrollX, double scrollY, double zoom, boolean showValids) {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!m.type.isWeapon() || !showValids && (!m.noValidTarget || m.type.getTetherSpec(this.currentBonuses) != null && m.ship.tetherAt == null) || m.hp <= 0) continue;
            this.drawFireArc(m, d, scrollX, scrollY, zoom, showValids || !m.noValidTarget);
            if (showValids || !m.noValidTarget) continue;
            Pt mz = m.fireFrom();
            int mX = (int)((mz.x + scrollX) * zoom);
            int mY = (int)((mz.y + scrollY) * zoom);
            int xOffset = 10;
            d.text(nt, AGame.FOUNT, (double)(mX + xOffset), (double)(mY - 5));
        }
    }

    public void drawFireArc(Module m, Draw d, double scrollX, double scrollY, double zoom, boolean enabled) {
        Pt mz = m.fireFrom();
        double mX = (mz.x + scrollX) * zoom;
        double mY = (mz.y + scrollY) * zoom;
        mz = new Pt(mX, mY);
        Arc arc = m.type.getFireArc(this.currentBonuses);
        if (this.flipped) {
            arc = arc.flipHorizontal();
        }
        Graphics g = (Graphics)d.frame().nativeRenderer();
        if (m.type.getMaxUpRange(this.currentBonuses) > 0 && m.type.getMaxXRange(this.currentBonuses) > 0) {
            if (m.type.isFlipped()) {
                double upRange = (double)m.type.getMaxUpRange(this.currentBonuses) * zoom;
                double xRange = (double)m.type.getMaxXRange(this.currentBonuses) * zoom;
                double backAmt = -upRange / StrictMath.tan(arc.from.radians);
                Pt intersect = new Pt(mz.x + (this.flipped ? backAmt : -backAmt), mz.y - upRange);
                g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                g.drawLine((float)mX, (float)mY, (float)intersect.x, (float)intersect.y);
                Pt end = (this.flipped ? arc.to : arc.from).fromBy(mz, 60.0);
                g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
                end = (this.flipped ? arc.to : arc.from).fromBy(mz, 80.0);
                g.setColor(enabled ? FIRE_ARC_ARC : FIRE_ARC_DISABLED_ARC);
                g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
                g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                g.drawLine((float)intersect.x, (float)(mY - upRange), (float)(mX + (this.flipped ? xRange : -xRange)), (float)(mY - upRange));
                g.drawLine((float)(mX + (this.flipped ? xRange : -xRange)), (float)(mY - upRange), (float)(mX + (this.flipped ? xRange : -xRange)), (float)(mY + 60.0));
                g.setColor(enabled ? FIRE_ARC_ARC : FIRE_ARC_DISABLED_ARC);
                g.drawLine((float)(mX + (this.flipped ? xRange : -xRange)), (float)(mY - upRange), (float)(mX + (this.flipped ? xRange : -xRange)), (float)(mY + 80.0));
            } else {
                double upRange = (double)m.type.getMaxUpRange(this.currentBonuses) * zoom;
                double xRange = (double)m.type.getMaxXRange(this.currentBonuses) * zoom;
                double backAmt = upRange / StrictMath.tan(arc.from.radians);
                Pt intersect = new Pt(mz.x + (this.flipped ? backAmt : -backAmt), mz.y - upRange);
                g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                g.drawLine((float)mX, (float)mY, (float)intersect.x, (float)intersect.y);
                Pt end = (this.flipped ? arc.from : arc.to).fromBy(mz, 60.0);
                g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
                end = (this.flipped ? arc.from : arc.to).fromBy(mz, 80.0);
                g.setColor(enabled ? FIRE_ARC_ARC : FIRE_ARC_DISABLED_ARC);
                g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
                g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                g.drawLine((float)intersect.x, (float)(mY - upRange), (float)(mX + (this.flipped ? -xRange : xRange)), (float)(mY - upRange));
                g.drawLine((float)(mX + (this.flipped ? -xRange : xRange)), (float)(mY - upRange), (float)(mX + (this.flipped ? -xRange : xRange)), (float)(mY + 60.0));
                g.setColor(enabled ? FIRE_ARC_ARC : FIRE_ARC_DISABLED_ARC);
                g.drawLine((float)(mX + (this.flipped ? -xRange : xRange)), (float)(mY - upRange), (float)(mX + (this.flipped ? -xRange : xRange)), (float)(mY + 80.0));
            }
        } else if (m.type.getMaxUpRange(this.currentBonuses) > 0) {
            if (m.type.getMaxUpRange(this.currentBonuses) > 200) {
                g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                double minX = mz.x;
                double maxX = mz.x;
                Pt start = arc.from.fromBy(mz, 180.0);
                minX = StrictMath.min(minX, start.x);
                maxX = StrictMath.max(maxX, start.x);
                g.drawLine((float)mX, (float)mY, (float)start.x, (float)start.y);
                Pt end = arc.to.fromBy(mz, 180.0);
                minX = StrictMath.min(minX, end.x);
                maxX = StrictMath.max(maxX, end.x);
                g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
                g.setColor(enabled ? FIRE_ARC_ARC : FIRE_ARC_DISABLED_ARC);
                start = arc.from.fromBy(mz, 200.0);
                g.drawLine((float)mX, (float)mY, (float)start.x, (float)start.y);
                end = arc.to.fromBy(mz, 200.0);
                g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
                g.drawArc((float)(mX - 90.0), (float)(mY - 90.0), 180.0f, 180.0f, (float)arc.from.getDegrees(), (float)arc.to.getDegrees());
                if (m.type.getMaxRange(this.currentBonuses) > 0) {
                    double maxRange = (double)m.type.getMaxRange(this.currentBonuses) * zoom;
                    g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                    g.drawArc((float)(mX - maxRange), (float)(mY - maxRange), (float)maxRange * 2.0f, (float)maxRange * 2.0f, (float)arc.from.getDegrees(), (float)arc.to.getDegrees());
                }
                g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                g.drawLine((float)minX, (float)(mz.y - (double)m.type.getMaxUpRange(this.currentBonuses) * zoom), (float)maxX, (float)(mz.y - (double)m.type.getMaxUpRange(this.currentBonuses) * zoom));
            } else if (m.type.isFlipped()) {
                double upRange = (double)m.type.getMaxUpRange(this.currentBonuses) * zoom;
                double xRange = upRange + 100.0 * zoom;
                double backAmt = -upRange / StrictMath.tan(arc.from.radians);
                Pt intersect = new Pt(mz.x + (this.flipped ? backAmt : -backAmt), mz.y - upRange);
                g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                g.drawLine((float)mX, (float)mY, (float)intersect.x, (float)intersect.y);
                Pt end = (this.flipped ? arc.to : arc.from).fromBy(mz, 60.0);
                g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
                end = (this.flipped ? arc.to : arc.from).fromBy(mz, 80.0);
                g.setColor(enabled ? FIRE_ARC_ARC : FIRE_ARC_DISABLED_ARC);
                g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
                g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                g.drawLine((float)intersect.x, (float)(mY - upRange), (float)(mX + (this.flipped ? xRange : -xRange)), (float)(mY - upRange));
            } else {
                double upRange = (double)m.type.getMaxUpRange(this.currentBonuses) * zoom;
                double xRange = upRange + 100.0 * zoom;
                double backAmt = upRange / StrictMath.tan(arc.from.radians);
                Pt intersect = new Pt(mz.x + (this.flipped ? backAmt : -backAmt), mz.y - upRange);
                g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                g.drawLine((float)mX, (float)mY, (float)intersect.x, (float)intersect.y);
                Pt end = (this.flipped ? arc.from : arc.to).fromBy(mz, 60.0);
                g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
                end = (this.flipped ? arc.from : arc.to).fromBy(mz, 80.0);
                g.setColor(enabled ? FIRE_ARC_ARC : FIRE_ARC_DISABLED_ARC);
                g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
                g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                g.drawLine((float)intersect.x, (float)(mY - upRange), (float)(mX + (this.flipped ? -xRange : xRange)), (float)(mY - upRange));
            }
        } else if (m.type.getMaxXRange(this.currentBonuses) > 0) {
            double xRange = (double)m.type.getMaxXRange(this.currentBonuses) * zoom;
            if (this.flipped ^ m.type.isFlipped()) {
                xRange = -xRange;
            }
            g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
            double yStart = -90.0;
            double yEnd = 90.0;
            boolean useYStart = false;
            boolean useYEnd = false;
            if (arc.from.radians != 1.5707963267948966 && arc.from.radians != 4.71238898038469) {
                yStart = StrictMath.tan(arc.from.radians) * xRange;
                useYStart = true;
            }
            if (arc.to.radians != 1.5707963267948966 && arc.to.radians != 4.71238898038469) {
                yEnd = StrictMath.tan(arc.to.radians) * xRange;
                useYEnd = true;
            }
            g.drawLine((float)(mX + xRange), (float)(mY + yStart), (float)(mX + xRange), (float)(mY + yEnd));
            Pt start = useYStart ? new Pt(mz.x + xRange, mz.y + yStart) : arc.from.fromBy(mz, 180.0);
            g.drawLine((float)mX, (float)mY, (float)start.x, (float)start.y);
            Pt end = useYEnd ? new Pt(mz.x + xRange, mz.y + yEnd) : arc.to.fromBy(mz, 180.0);
            g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
            g.setColor(enabled ? FIRE_ARC_ARC : FIRE_ARC_DISABLED_ARC);
            start = arc.from.fromBy(mz, 200.0);
            if (!useYStart) {
                g.drawLine((float)mX, (float)mY, (float)start.x, (float)start.y);
            }
            end = arc.to.fromBy(mz, 200.0);
            if (!useYEnd) {
                g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
            }
            g.drawArc((float)(mX - 90.0), (float)(mY - 90.0), 180.0f, 180.0f, (float)arc.from.getDegrees(), (float)arc.to.getDegrees());
        } else if (m.type.getMinXRange(this.currentBonuses) > 0) {
            boolean doFlip = this.flipped ^ m.type.isFlipped();
            double xRange = (double)m.type.getMinXRange(this.currentBonuses) * zoom;
            double flipMult = doFlip ? -1.0 : 1.0;
            double rangeStartX = mX + xRange * flipMult;
            double rangeStartYFrom = mY + StrictMath.tan(arc.from.radians) * xRange * flipMult;
            double rangeStartYTo = mY + StrictMath.tan(arc.to.radians) * xRange * flipMult;
            double rangeExtendX = mX + (xRange + 90.0) * flipMult;
            double rangeExtendYFrom = mY + StrictMath.tan(arc.from.radians) * (xRange + 90.0) * flipMult;
            double rangeExtendYTo = mY + StrictMath.tan(arc.to.radians) * (xRange + 90.0) * flipMult;
            double rangeExtend2X = mX + (xRange + 110.0) * flipMult;
            double rangeExtend2YFrom = mY + StrictMath.tan(arc.from.radians) * (xRange + 110.0) * flipMult;
            double rangeExtend2YTo = mY + StrictMath.tan(arc.to.radians) * (xRange + 110.0) * flipMult;
            g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
            g.drawLine((float)rangeStartX, (float)rangeStartYFrom, (float)rangeExtendX, (float)rangeExtendYFrom);
            g.drawLine((float)rangeStartX, (float)rangeStartYTo, (float)rangeExtendX, (float)rangeExtendYTo);
            g.drawLine((float)rangeStartX, (float)rangeStartYFrom, (float)rangeStartX, (float)rangeStartYTo);
            g.setColor(enabled ? FIRE_ARC_ARC : FIRE_ARC_DISABLED_ARC);
            g.drawLine((float)rangeStartX, (float)rangeStartYFrom, (float)rangeExtend2X, (float)rangeExtend2YFrom);
            g.drawLine((float)rangeStartX, (float)rangeStartYTo, (float)rangeExtend2X, (float)rangeExtend2YTo);
            g.drawLine((float)mX, (float)mY, (float)rangeStartX, (float)(rangeStartYFrom / 2.0 + rangeStartYTo / 2.0));
        } else {
            g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
            Pt start = arc.from.fromBy(mz, 180.0);
            g.drawLine((float)mX, (float)mY, (float)start.x, (float)start.y);
            Pt end = arc.to.fromBy(mz, 180.0);
            g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
            g.setColor(enabled ? FIRE_ARC_ARC : FIRE_ARC_DISABLED_ARC);
            start = arc.from.fromBy(mz, 200.0);
            g.drawLine((float)mX, (float)mY, (float)start.x, (float)start.y);
            end = arc.to.fromBy(mz, 200.0);
            g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
            g.drawArc((float)(mX - 90.0), (float)(mY - 90.0), 180.0f, 180.0f, (float)arc.from.getDegrees(), (float)arc.to.getDegrees());
            if (m.type.getMaxRange(this.currentBonuses) > 0) {
                double maxRange = (double)m.type.getMaxRange(this.currentBonuses) * zoom;
                g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                g.drawArc((float)(mX - maxRange), (float)(mY - maxRange), (float)maxRange * 2.0f, (float)maxRange * 2.0f, (float)arc.from.getDegrees(), (float)arc.to.getDegrees());
            }
        }
    }

    public void drawAsBlueprint(MyDraw d, double x, double y, int ms, boolean outside, float intensity) {
        if (outside) {
            int tsz = this.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tile t = this.tiles.get(ti);
                if (t.armour.type == ArmourType.ofName("NONE")) continue;
                t.armour.getApp().drawAsBlueprint(d, x + (double)(this.gridXToWorldX(t.x, 1) * 16), y + (double)(t.y * 16), 16.0, 16.0, ms, this.flipped, intensity);
            }
        } else {
            int msz = this.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Pt offset;
                Img barrel;
                Module m = this.modules.get(mi);
                m.type.drawAsBlueprint(d, x + (double)(this.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, this.flipped, m.variant, this.currentBonuses, intensity);
                WeaponAppearance wa = m.type.weaponAppearance(this.currentBonuses);
                if (wa == null || Appearance.useSimpleGraphics) continue;
                Img img = barrel = this.flipped ? wa.flippedbarrel : wa.barrel;
                if (wa.barrelAnimation != null) {
                    barrel = this.flipped ? wa.flippedBarrelAnimation.frames.get(0) : wa.barrelAnimation.frames.get(0);
                }
                Pt pt = offset = this.flipped ? wa.flippedBarrelOffset : wa.barrelOffset;
                if (barrel == null || m.hp <= 0) continue;
                Appearance.drawAsBlueprint(barrel, d, x + (double)(this.gridXToWorldX(m.x, m.type.getW()) * 16) + offset.x, y + (double)(m.y * 16) + offset.y, barrel.srcWidth, barrel.srcHeight, this.flipped != m.type.isFlipped(), intensity);
            }
        }
    }

    public void draw(MyDraw d, double x, double y, int ms, boolean outside, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientTint) {
        for (UniScreen.ShipLayer l : ShipLayers.ALL) {
            this.additionalSSBs.clear();
            this.additionalSSBPairs.clear();
            SpritesheetBundle baseSSB = l.getBaseSSB();
            SpritesheetBundle baseSSB2 = l.getBaseSSB2();
            if (baseSSB2 == null) {
                l.lockShader(baseSSB, null, d, 1.0, light, lightStrength, ambient, ambientSaturation);
                l.draw(this, null, 0, d, outside, 1.0, x, y, ms, displayStatusIcons, showDecals, coa, coa, showHPBarsAndDoors, light, lightStrength, ambient, ambientSaturation, ambientTint, baseSSB, this.additionalSSBs, null, null);
                l.unlockShader(light, 1.0);
                for (SpritesheetBundle spritesheetBundle : this.additionalSSBs) {
                    l.lockShader(spritesheetBundle, null, d, 1.0, light, lightStrength, ambient, ambientSaturation);
                    l.draw(this, null, 0, d, outside, 1.0, x, y, ms, displayStatusIcons, showDecals, coa, coa, showHPBarsAndDoors, light, lightStrength, ambient, ambientSaturation, ambientTint, spritesheetBundle, null, null, null);
                    l.unlockShader(light, 1.0);
                }
            } else {
                l.lockShader(baseSSB, baseSSB2, d, 1.0, light, lightStrength, ambient, ambientSaturation);
                l.draw(this, null, 0, d, outside, 1.0, x, y, ms, displayStatusIcons, showDecals, coa, coa, showHPBarsAndDoors, light, lightStrength, ambient, ambientSaturation, ambientTint, baseSSB, null, baseSSB2, this.additionalSSBPairs);
                l.unlockShader(light, 1.0);
                for (Utils.Pair pair : this.additionalSSBPairs) {
                    l.lockShader((SpritesheetBundle)pair.a, (SpritesheetBundle)pair.b, d, 1.0, light, lightStrength, ambient, ambientSaturation);
                    l.draw(this, null, 0, d, outside, 1.0, x, y, ms, displayStatusIcons, showDecals, coa, coa, showHPBarsAndDoors, light, lightStrength, ambient, ambientSaturation, ambientTint, (SpritesheetBundle)pair.a, null, (SpritesheetBundle)pair.b, null);
                    l.unlockShader(light, 1.0);
                }
            }
            if (RotatingShader.shaderLocked) {
                AirshipGame.instance.reportError("Rotating shader still locked after " + l.getClass().getSimpleName(), null, null, false, true);
                RotatingShader.unlockShader();
            }
            Appearance.unlockBevelledShader(light != null);
            Appearance.unlockShader(light != null);
            Appearance.unlockSubShader(light != null);
            RotatingShader.unlockShader();
            RotatingColoringShader.unlockShader();
        }
    }

    public boolean hasInaccessibleModules() {
        return this.pathChunks(null).size() > 1 || this.chunks(null).size() > 1;
    }

    public void hookModuleTooltips(MyDraw d, double x, double y, double zoom) {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            final Module m = this.modules.get(mi);
            d.tooltip((x + (double)(this.gridXToWorldX(m.x, m.type.getW()) * 16)) * zoom, (y + (double)(m.y * 16)) * zoom, (double)(m.type.getW() * 16) * zoom, (double)(m.type.getH() * 16) * zoom, new MyDraw.Tooltip(){

                @Override
                public String get() {
                    return m.type.getDescription(Airship.this.currentBonuses);
                }
            });
        }
    }

    public int getCost() {
        int c = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            c += m.type.getCost(this.constructionBonuses);
        }
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            c += t.armour.type.getCost(this.constructionBonuses);
        }
        return (int)((double)c * this.type.costMult);
    }

    public int getRefitCostFrom(Airship from) {
        int o;
        int m;
        HashMap<ModuleType, Integer> myMCount = new HashMap<ModuleType, Integer>();
        for (ModuleType mt : Loadable.all(ModuleType.class)) {
            myMCount.put(mt, 0);
        }
        for (Module m2 : this.modules) {
            myMCount.put(m2.type, (Integer)myMCount.get(m2.type) + 1);
        }
        HashMap<ArmourType, Integer> myACount = new HashMap<ArmourType, Integer>();
        for (ArmourType at : Loadable.all(ArmourType.class)) {
            myACount.put(at, 0);
        }
        for (Tile t : this.tiles) {
            myACount.put(t.armour.type, (Integer)myACount.get(t.armour.type) + 1);
        }
        HashMap<ModuleType, Integer> oMCount = new HashMap<ModuleType, Integer>();
        for (ModuleType mt : Loadable.all(ModuleType.class)) {
            oMCount.put(mt, 0);
        }
        for (Module m3 : from.modules) {
            oMCount.put(m3.type, (Integer)oMCount.get(m3.type) + 1);
        }
        HashMap<ArmourType, Integer> oACount = new HashMap<ArmourType, Integer>();
        for (ArmourType at : Loadable.all(ArmourType.class)) {
            oACount.put(at, 0);
        }
        for (Tile t : from.tiles) {
            oACount.put(t.armour.type, (Integer)oACount.get(t.armour.type) + 1);
        }
        int cost = 1;
        for (ModuleType mt : Loadable.all(ModuleType.class)) {
            m = (Integer)myMCount.get(mt);
            if (m > (o = ((Integer)oMCount.get(mt)).intValue())) {
                cost += (m - o) * mt.getCost(this.constructionBonuses);
                continue;
            }
            cost += (m - o) * mt.getCost(this.constructionBonuses) / 4;
        }
        for (ArmourType at : Loadable.all(ArmourType.class)) {
            m = (Integer)myACount.get(at);
            if (m > (o = ((Integer)oACount.get(at)).intValue())) {
                cost += (m - o) * at.getCost(this.constructionBonuses);
                continue;
            }
            cost += (m - o) * at.getCost(this.constructionBonuses) / 4;
        }
        return (int)((double)cost * this.type.costMult);
    }

    public int getRequiredCrew() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getCrew(this.currentBonuses);
        }
        return n;
    }

    public int getRequiredGuards() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getFixedGuards(this.currentBonuses);
        }
        return n;
    }

    public boolean hasCrewType(CrewType ct) {
        int csz = this.crew.size();
        for (int i = 0; i < csz; ++i) {
            if (this.crew.get((int)i).type != ct) continue;
            return true;
        }
        return false;
    }

    public boolean hasCrewTypeAny(Collection<CrewType> cts) {
        int csz = this.crew.size();
        for (int i = 0; i < csz; ++i) {
            if (!cts.contains(this.crew.get((int)i).type)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCrewQuartersAny(Collection<CrewType> cts) {
        int msz = this.modules.size();
        for (int i = 0; i < msz; ++i) {
            if (!cts.contains(this.modules.get((int)i).type.getQuartersType(this.currentBonuses))) continue;
            return true;
        }
        return false;
    }

    public boolean canFly() {
        return !this.type.onGround;
    }

    public ArrayList<CrewType> getBoarderTypes() {
        ArrayList<CrewType> cts = new ArrayList<CrewType>();
        int csz = this.crew.size();
        for (int i = 0; i < csz; ++i) {
            Crewman cm = this.crew.get(i);
            if (!cm.type.canBoard || cts.contains(cm.type)) continue;
            cts.add(cm.type);
        }
        return cts;
    }

    public boolean canBeBoarded() {
        boolean hasInteriorSpaces = false;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.type.getPreventsBoarding()) {
                return false;
            }
            hasInteriorSpaces = hasInteriorSpaces || m.type.getOccupableTileCount() > 0;
        }
        return hasInteriorSpaces;
    }

    public boolean preventsSurrender() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!m.type.getPreventsSurrender()) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveCrew() {
        int csz = this.crew.size();
        for (int i = 0; i < csz; ++i) {
            if (!this.crew.get(i).active()) continue;
            return true;
        }
        int msz = this.modules.size();
        for (int i = 0; i < msz; ++i) {
            if (!this.modules.get((int)i).type.getCountsAsActiveCrew()) continue;
            return true;
        }
        return false;
    }

    public boolean inCombat(Combat c) {
        return this.hasActiveCrew() && (this.canShoot() || this.canMove() && this.canGenerateCommands() || this.hasActiveFlyers(c) || this.hasActiveBoarders(c));
    }

    public boolean hasFlyers() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.type.getQuartersType(this.currentBonuses) == null || !m.type.getQuartersType((BonusSet)this.currentBonuses).canFly) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveFlyers(Combat c) {
        if (!this.hasFlyers()) {
            return false;
        }
        int csz = this.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = this.crew.get(ci);
            if (!cm.alive() || !cm.type.canFly) continue;
            return true;
        }
        Combat.Side s = c.sideOf(this);
        if (s == null) {
            return false;
        }
        int tsz = s.troops.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Crewman t = s.troops.get(ti);
            if (!t.alive() || !t.type.canFly) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveBoarders(Combat c) {
        boolean hasBoarders = false;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.type.getQuartersType(this.currentBonuses) == null || !m.type.getQuartersType((BonusSet)this.currentBonuses).canBoard) continue;
            hasBoarders = true;
            break;
        }
        if (!hasBoarders) {
            return false;
        }
        int csz = this.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = this.crew.get(ci);
            if (!cm.alive() || !cm.type.canBoard) continue;
            return true;
        }
        Combat.Side s = c.sideOf(this);
        if (s == null) {
            return false;
        }
        s = c.otherSide(s);
        int ssz = s.ships.size();
        for (int si = 0; si < ssz; ++si) {
            Airship ship = s.ships.get(si);
            int bsz = ship.boarders.size();
            for (int bi = 0; bi < bsz; ++bi) {
                if (!ship.boarders.get(bi).active()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasModuleTypeAny(ModuleType ... mts) {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            for (int mti = 0; mti < mts.length; ++mti) {
                if (m.type != mts[mti]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasModuleTypeAny(Collection<ModuleType> mts) {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!mts.contains(m.type)) continue;
            return true;
        }
        return false;
    }

    public boolean isBeingBoarded() {
        int bsz = this.boarders.size();
        for (int bi = 0; bi < bsz; ++bi) {
            if (!this.boarders.get(bi).active()) continue;
            return true;
        }
        return false;
    }

    public int getRecommendedCrew() {
        int n = 2;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getRecommendedCrew(this.currentBonuses);
        }
        return n;
    }

    public int getQuartered(CrewType ct) {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.type.getQuartersType(this.currentBonuses) != ct) continue;
            n += m.type.getQuarters(this.currentBonuses);
        }
        return n;
    }

    public int getQuartered(Collection<CrewType> cts) {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!cts.contains(m.type.getQuartersType(this.currentBonuses))) continue;
            n += m.type.getQuarters(this.currentBonuses);
        }
        return n;
    }

    public int getAllQuartered() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getQuarters(this.currentBonuses);
        }
        return n;
    }

    public void updateWeight() {
        this.weight = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            this.weight += m.type.getWeight(this.currentBonuses);
        }
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            this.weight += t.armour.type.getWeight(this.constructionBonuses);
        }
    }

    public int getWeight() {
        return this.weight;
    }

    public int maintenanceCost() {
        int c = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            c += m.type.maintenanceCost(this.currentBonuses);
        }
        return (c = (int)((double)c * this.type.maintenanceMult)) == 0 ? 1 : c;
    }

    public int getSupplyProvided() {
        int s = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            s += m.type.getSupplyProvided(this.currentBonuses);
        }
        return s;
    }

    public int getSupplyRequired() {
        int s = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            s += m.type.getSupplyRequired(this.currentBonuses);
        }
        return s;
    }

    public int getLift() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getLift(this.constructionBonuses);
        }
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            if (t.armour == null) continue;
            n += t.armour.type.getLift(this.constructionBonuses);
        }
        return n;
    }

    public int getAmmoCapacity() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getAmmo(this.currentBonuses);
        }
        return n;
    }

    public int getCoalCapacity() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getCoal(this.currentBonuses);
        }
        return n;
    }

    public boolean requiresCoal() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.type.getCoalReload(this.currentBonuses) <= 0) continue;
            return true;
        }
        return false;
    }

    public int getWaterCapacity() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getWater(this.currentBonuses);
        }
        return n;
    }

    public int getRepairCapacity() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getRepair(this.currentBonuses);
        }
        return n;
    }

    public int getTotalResource(Resource r) {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.getResource(r);
        }
        return n;
    }

    public int getTotalResourceCapacity(Resource r) {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getResourceCapacity(r, this.currentBonuses);
        }
        return n;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public void groundShip() {
        this.moveTo = new Pt((double)this.getIntX(), 1124.0);
        this.grounding = true;
        this.ramming = false;
    }

    public boolean abandonShip(Combat c) {
        if (!c.canAbandonShip(this)) {
            return false;
        }
        this.sitting = true;
        this.legBalanceFactor = 0.0;
        LandFormation lf = this.lastGrounded == null || this.msSinceOnGround > 99 ? c.landFormations.get(0) : this.lastGrounded;
        int btGridXStart = StrictMath.max(0, (int)StrictMath.floor((this.getX() - lf.getX()) / 16.0) - 4);
        int btGridXRange = StrictMath.max(1, StrictMath.min(lf.getGridWidth() - btGridXStart, this.w + 8));
        for (Crewman cm : this.crew) {
            if (cm.job != null && cm.job.isCaptain()) {
                cm.doShout(cm.pickShout("abandonShip"));
            }
            cm.abandonJob("abandonShip");
            cm.ultimateBoardTarget = lf;
            cm.proximateBoardTarget = null;
            int btGridX = btGridXStart + c.r.nextInt(btGridXRange);
            int btGridY = lf.firstSolidBlockYAt(btGridX);
            cm.walkToGR = new GridRef(btGridX, btGridY, lf);
        }
        return true;
    }

    public int getIntX() {
        return (int)this.getX();
    }

    public int getIntY() {
        return (int)this.getY();
    }

    public boolean grounded() {
        return this.msSinceOnGround < 100 && this.moveTo.y + (double)(this.getHeight() * 16) > 1024.0;
    }

    public boolean useless() {
        return this.uselessReason() != null;
    }

    public boolean trapped() {
        if (this.type.mobile && !this.type.onGround && this.availableServiceCeiling() <= 0) {
            return true;
        }
        return this.type.mobile && this.availableSpeed() <= 0.0;
    }

    public String uselessReason() {
        if (this.getRequiredCrew() > 0) {
            if (this.getQuartered(CrewType.onlyWorkers) == 0) {
                return Lang._t("No_crew_quarters", new Object[0]);
            }
            if (this.crew.isEmpty()) {
                return Lang._t("No_crew", new Object[0]);
            }
        }
        if (this.type.mobile && this.getSpeed() == 0.0) {
            return Lang._t("Immobile", new Object[0]);
        }
        if (!this.type.onGround && this.serviceCeiling() <= 0) {
            return Lang._t("Grounded", new Object[0]);
        }
        return null;
    }

    public String harmlessReason() {
        if (this.isArmedOrHasTroops()) {
            if (!this.canShoot() && !this.canMove()) {
                return Lang._t("No_Ammo", new Object[0]);
            }
            return null;
        }
        if (!this.canMove()) {
            return Lang._t("Disarmed", new Object[0]);
        }
        return null;
    }

    public double getStructuralStressHPMultiplier() {
        int stress = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            stress += m.type.getStructuralStressAmount(this.currentBonuses);
        }
        return 1.0 - StrictMath.max(0.0, StrictMath.min(GameSetting.maxStructuralStressHPPenalty, (double)(stress - GameSetting.minStructuralStress) * 1.0 / (double)GameSetting.structuralStressPerHPPenalty));
    }

    public int getBonusHPPerTile() {
        int sz = 0;
        int bonus = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            sz += m.type.getW() * m.type.getH();
            bonus += m.hp > 0 ? m.type.getShipHPBonus(this.currentBonuses) : 0;
        }
        return sz == 0 ? 0 : bonus / sz;
    }

    public double getInaccuracyMultiplier() {
        double reduction = 0.0;
        if (this.accuracyBonusTypes == null) {
            this.accuracyBonusTypes = new ArrayList();
            for (ModuleType mt : Loadable.all(ModuleType.class)) {
                if (!(mt.getAccuracyBonus(this.currentBonuses) > 0.0)) continue;
                this.accuracyBonusTypes.add(mt);
            }
        }
        block1: for (int ti = 0; ti < this.accuracyBonusTypes.size(); ++ti) {
            ModuleType mt;
            mt = this.accuracyBonusTypes.get(ti);
            if (!(mt.getAccuracyBonus(this.currentBonuses) > 0.0)) continue;
            int msz = this.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = this.modules.get(mi);
                if (m.type != mt) continue;
                reduction += mt.getAccuracyBonus(this.currentBonuses);
                continue block1;
            }
        }
        return StrictMath.max(0.1, 1.0 - reduction) * this.type.jitterMult;
    }

    public void precalcAIValues(Combat c) {
        this.aiTmpCanMove = this.canMove();
        this.aiTmpAvailableLift = this.availableLift();
        this.dangerCache = this.danger(c);
    }

    public int getCrewCount() {
        int n = 0;
        int csz = this.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = this.crew.get(ci);
            if (cm.hp <= 0) continue;
            ++n;
        }
        return n;
    }

    public int getActiveCrewCount() {
        int n = 0;
        int csz = this.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = this.crew.get(ci);
            if (!cm.active()) continue;
            ++n;
        }
        return n;
    }

    public void resetTentaclesForFlipped() {
        for (Module m : this.modules) {
            m.resetTentacles();
        }
    }

    public void initWheelsLegsAndTentacles(LandFormation ground, ArrayList<LandFormation> floaters, ShipList ships) {
        for (Module m : this.modules) {
            m.initWheels(ground, floaters, ships, true);
            m.resetLegs(ground, floaters);
            m.resetTentacles();
        }
    }

    @Override
    public int getGridWidth() {
        return this.w;
    }

    @Override
    public int getGridHeight() {
        return this.h;
    }

    @Override
    public boolean solidAt(int x, int y) {
        return this.tileAt(this.gridXToWorldX(x, 1), y) != null;
    }

    @Override
    public boolean enterableAt(int x, int y) {
        Tile t = this.tileAt(this.gridXToWorldX(x, 1), y);
        return t != null && t.enterable();
    }

    @Override
    public double yBoundaryAt(double worldX) {
        int gridX = this.gridXToWorldX((int)StrictMath.floor((worldX - this.getX()) / 16.0), 1);
        if (gridX < 0 || gridX >= this.w) {
            return this.getY();
        }
        for (int gy = 0; gy < this.h; ++gy) {
            if (this.tileAt(gridX, gy) == null) continue;
            return this.getY() + (double)(gy * 16);
        }
        return this.getY();
    }

    @Override
    public int firstSolidBlockYAt(int gx) {
        if (gx < 0 || gx >= this.w) {
            return -1;
        }
        for (int gy = 0; gy < this.h; ++gy) {
            if (this.tileAt(gx, gy) == null) continue;
            return gy;
        }
        return -1;
    }

    @Override
    public ArrayList<GridLocation> reachable(int x, int y) {
        Tile t = this.tileAt(this.gridXToWorldX(x, 1), y);
        return t == null ? null : t.reachable;
    }

    @Override
    public void clearReachable(int x, int y) {
        Tile t = this.tileAt(this.gridXToWorldX(x, 1), y);
        if (t != null) {
            t.reachable.clear();
        }
    }

    @Override
    public boolean concaveAt(int x, int y) {
        Tile t = this.tileAt(this.gridXToWorldX(x, 1), y);
        if (t == null) {
            return false;
        }
        return !t.adjacent[0][0] && t.adjacent[1][0] && t.adjacent[0][1] || !t.adjacent[0][1] && t.adjacent[0][0] && t.adjacent[0][2] || !t.adjacent[0][2] && t.adjacent[0][1] && t.adjacent[1][2] || !t.adjacent[1][2] && t.adjacent[0][2] && t.adjacent[2][2] || !t.adjacent[2][2] && t.adjacent[1][2] && t.adjacent[2][1] || !t.adjacent[2][1] && t.adjacent[2][2] && t.adjacent[2][0] || !t.adjacent[2][0] && t.adjacent[2][1] && t.adjacent[1][0] || !t.adjacent[1][0] && t.adjacent[2][0] && t.adjacent[0][0];
    }

    @Override
    public GridLocation locationAt(int x, int y) {
        return this.tileAt(this.gridXToWorldX(x, 1), y);
    }

    @Override
    public boolean isAtSpeed() {
        return this.type.mobile;
    }

    private Tile unassignedPathingTile() {
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            if (!t.canOccupy || t.pathCostTmp != 0) continue;
            return t;
        }
        return null;
    }

    public boolean isPathingFullyConnected() {
        return this.pathChunks(null).size() < 2;
    }

    public ArrayList<ArrayList<Module>> pathChunks(Module ignore) {
        Tile unassignedTile;
        ArrayList<ArrayList<Module>> chunks = new ArrayList<ArrayList<Module>>();
        for (Tile t : this.tiles) {
            t.pathCostTmp = t.module == ignore ? -1 : 0;
        }
        int chunkID = 0;
        while ((unassignedTile = this.unassignedPathingTile()) != null) {
            LinkedList<Tile> tileQ = new LinkedList<Tile>();
            ArrayList<Module> chunk = new ArrayList<Module>();
            unassignedTile.pathCostTmp = ++chunkID;
            tileQ.add(unassignedTile);
            while (!tileQ.isEmpty()) {
                Tile t = (Tile)tileQ.pollFirst();
                if (!chunk.contains(t.module)) {
                    chunk.add(t.module);
                }
                for (int[] adj : ADJ) {
                    Tile t2;
                    if (adj[0] == -1 && adj[1] == 0 && t.x == t.module.x) {
                        if (!t.module.type.getLeftDoors()[t.y - t.module.y]) {
                            continue;
                        }
                    } else if (adj[0] != 1 || adj[1] != 0 || t.x != t.module.x + t.module.type.getW() - 1 ? adj[0] == 0 && adj[1] == -1 && t.y == t.module.y && !t.module.type.getUpDoors()[t.x - t.module.x] : !t.module.type.getRightDoors()[t.y - t.module.y]) continue;
                    if ((t2 = this.tileAt(t.x + adj[0], t.y + adj[1])) == null || !t2.canOccupy || t2.pathCostTmp != 0 || t2.module != t.module && (adj[0] == -1 && adj[1] == 0 ? !t2.module.type.getRightDoors()[t2.y - t2.module.y] : (adj[0] == 1 && adj[1] == 0 ? !t2.module.type.getLeftDoors()[t2.y - t2.module.y] : adj[0] == 0 && adj[1] == 1 && !t2.module.type.getUpDoors()[t2.x - t2.module.x]))) continue;
                    t2.pathCostTmp = chunkID;
                    tileQ.add(t2);
                }
            }
            chunks.add(new ArrayList(chunk));
        }
        return chunks;
    }

    public boolean isFullyConnected() {
        return this.chunks(null).size() < 2;
    }

    private Tile unassignedTile() {
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            if (t.pathCostTmp != 0) continue;
            return t;
        }
        return null;
    }

    public ArrayList<ArrayList<Module>> chunks(Module ignore) {
        Tile unassignedTile;
        ArrayList<ArrayList<Module>> chunks = new ArrayList<ArrayList<Module>>();
        for (Tile t : this.tiles) {
            t.pathCostTmp = t.module == ignore ? -1 : 0;
        }
        int chunkID = 0;
        while ((unassignedTile = this.unassignedTile()) != null) {
            LinkedList<Tile> tileQ = new LinkedList<Tile>();
            ArrayList<Module> chunk = new ArrayList<Module>();
            unassignedTile.pathCostTmp = ++chunkID;
            tileQ.add(unassignedTile);
            while (!tileQ.isEmpty()) {
                Tile t = (Tile)tileQ.pollFirst();
                if (!chunk.contains(t.module)) {
                    chunk.add(t.module);
                }
                for (int[] adj : ADJ) {
                    Tile t2 = this.tileAt(t.x + adj[0], t.y + adj[1]);
                    if (t2 == null || t2.pathCostTmp != 0) continue;
                    t2.pathCostTmp = chunkID;
                    tileQ.add(t2);
                }
            }
            chunks.add(new ArrayList(chunk));
        }
        return chunks;
    }

    private void sanityCheck() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.ship != this) {
                System.err.println("Module on wrong ship.");
            }
            for (int ty = m.y; ty < m.y + m.type.getH(); ++ty) {
                for (int tx = m.x; tx < m.x + m.type.getW(); ++tx) {
                    if (this.tileAt(tx, ty) != null) continue;
                    System.err.println("Module " + m.type.getName() + " not fully covered with tiles.");
                }
            }
        }
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            if (!this.modules.contains(t.module)) {
                System.err.println("Tile's module " + t.module.type.getName() + " is not in ship.");
            }
            if (t.x >= t.module.x && t.y >= t.module.y && t.x < t.module.x + t.module.type.getW() && t.y < t.module.y + t.module.type.getH()) continue;
            System.err.println("Tile not on top of its module " + t.module.type.getName() + ".");
        }
        int csz = this.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = this.crew.get(ci);
            if (cm.ship != this) {
                System.err.println("Crewman on wrong ship.");
            }
            if (!this.tiles.contains(cm.currentTile)) {
                System.err.println("Crewman's tile (" + cm.currentTile.module.type.getName() + ") is not in ship.");
            }
            if (this.modules.contains(cm.currentTile.module)) continue;
            System.err.println("Crewman's module " + cm.currentTile.module.type.getName() + " is not in ship.");
        }
    }

    private void splitIfNeeded(Combat combat, boolean onViewingSide) {
        this.regenerateTileGrid();
        ArrayList<ArrayList<Module>> chunks = this.chunks(null);
        for (ArrayList<Module> ch : chunks) {
            for (Module module : ch) {
                if (!this.modules.contains(module)) {
                    System.err.println(module.type.name + " not in ship");
                }
                boolean found = false;
                for (Tile t : this.tiles) {
                    if (t.module != module) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(module.type.name + " not covered!");
            }
        }
        for (ArrayList<Module> c1 : chunks) {
            for (ArrayList arrayList : chunks) {
                if (c1 == arrayList) continue;
                for (Module m : arrayList) {
                    if (!c1.contains(m)) continue;
                    System.err.println("CHUNK OVERLAP OF " + m.type.getName());
                }
            }
        }
        if (chunks.size() < 2) {
            return;
        }
        Iterator<ArrayList<Module>> it = chunks.iterator();
        while (it.hasNext()) {
            ArrayList<Module> ms = it.next();
            if (ms.size() != 1) continue;
            this.destroyModule(ms.get(0), combat, true, onViewingSide);
            this.moduleLossAmount += 1.0;
            it.remove();
        }
        if (chunks.size() < 2) {
            return;
        }
        ArrayList remainingShip = null;
        int mostW = 0;
        for (ArrayList arrayList : chunks) {
            int weight = 0;
            for (Module m : arrayList) {
                if (m.hp <= -m.type.getHp(this.currentBonuses) / 2) continue;
                weight += m.type.getWeight(this.currentBonuses);
            }
            if (remainingShip != null && mostW >= weight) continue;
            remainingShip = arrayList;
            mostW = weight;
        }
        Combat.Side mySide = this.mySide(combat);
        for (ArrayList<Module> chunk : chunks) {
            if (chunk == remainingShip) continue;
            Airship cs = new Airship(this.type);
            cs.setName("Fragment of " + this.getName());
            cs.networkID = this.networkID + "." + this.chunkSubIDCounter;
            ++this.chunkSubIDCounter;
            cs.setX(this.getIntX());
            cs.setY(this.getIntY());
            cs.w = this.w;
            cs.h = this.h;
            cs.setxSpeed(this.getxSpeed());
            cs.setySpeed(this.getySpeed());
            cs.flipped = this.flipped;
            cs.moduleLossAmount = this.moduleLossAmount;
            cs.fallingTime = this.fallingTime;
            cs.explosionAmount = this.explosionAmount;
            cs.originalAllQuartered = this.originalAllQuartered;
            cs.originalAmmoCapacity = this.originalAmmoCapacity;
            cs.originalCoalCapacity = this.originalCoalCapacity;
            cs.originalRepairCapacity = this.originalRepairCapacity;
            cs.originalWaterCapacity = this.originalWaterCapacity;
            if (remainingShip != null) {
                cs.moduleLossAmount += (double)remainingShip.size();
                this.moduleLossAmount += (double)chunk.size();
            }
            for (Module m : chunk) {
                cs.modules.add(m);
                m.ship = cs;
                boolean addedTileForModule = false;
                for (Tile t : new ArrayList<Tile>(this.tiles)) {
                    if (t.module != m) continue;
                    cs.tiles.add(t);
                    this.tiles.remove(t);
                    t.setShip(cs);
                    addedTileForModule = true;
                }
                for (Crewman cm : new ArrayList<Crewman>(this.crew)) {
                    if (cm.currentTile.module != m) continue;
                    cs.crew.add(cm);
                    cm.ship = cs;
                    this.crew.remove(cm);
                }
                for (Crewman cm : new ArrayList<Crewman>(this.boarders)) {
                    if (cm.currentTile.module != m) continue;
                    cs.boarders.add(cm);
                    cm.ship = cs;
                    this.boarders.remove(cm);
                }
                this.modules.remove(m);
            }
            for (Particle p : this.stuckParticles) {
                Particle p2 = new Particle(p.type, p.x - this.getX() + cs.getX(), p.y - this.getY() + cs.getY(), p.dx, p.dy);
                p2.life = p.life;
                p2.lifespan = p.lifespan;
                cs.stuckParticles.add(p2);
            }
            mySide.ships.add(cs);
            cs.sanityCheck();
            cs.layout();
            cs.recalcHPs();
            cs.assignJobs();
            cs.sanityCheck();
            cs.removeUnstuckParticles();
        }
        this.layout();
        this.paths.clear();
        this.tilePaths.clear();
        this.recalcHPs();
        this.assignJobs();
        this.crashSize = 2;
        this.sanityCheck();
        this.removeUnstuckParticles();
    }

    private Combat.Side mySide(Combat combat) {
        int ssz = combat.sides.size();
        for (int si = 0; si < ssz; ++si) {
            Combat.Side s = combat.sides.get(si);
            if (!s.ships.contains(this)) continue;
            return s;
        }
        return null;
    }

    public void destroyModule(Module m, Combat combat, boolean violently, boolean onViewingSide) {
        if (violently && m.type.destructionSound(this.currentBonuses) == null) {
            this.crashSize = 3;
        }
        if (m.type.destructionSound(this.currentBonuses) != null && !m.type.playDestructionSoundAtStartOfDestruction()) {
            double mCx = this.getX() + (double)this.gridXToWorldX(m.x, m.type.getW()) + (double)(m.type.getW() * 16 / 2);
            double mCy = this.getY() + (double)(m.y * 16) + (double)(m.type.getH() * 16 / 2);
            combat.play(m.type.destructionSound(this.currentBonuses), mCx, mCy, this.getxSpeed(), this.getySpeed(), onViewingSide);
        }
        m.dealDestructionDamage();
        m.throwFragments(combat, false);
        this.modules.remove(m);
        Iterator<Tile> tit = this.tiles.iterator();
        while (tit.hasNext()) {
            if (tit.next().module != m) continue;
            tit.remove();
        }
        Iterator<Crewman> cit = this.crew.iterator();
        while (cit.hasNext()) {
            Crewman cm = cit.next();
            if ((cm.beingCarried() || cm.currentTile.module != m) && (cm.carrier() == null || cm.carrier().currentTile.module != m)) continue;
            cit.remove();
        }
        Iterator<Crewman> bit = this.boarders.iterator();
        while (bit.hasNext()) {
            Crewman b = bit.next();
            if ((b.beingCarried() || b.currentTile.module != m) && (b.carrier() == null || b.carrier().currentTile.module != m)) continue;
            bit.remove();
        }
        this.removeUnstuckParticles();
    }

    public void moveTimeForwardForFunctioningInEditorModules(int ms) {
        boolean hasCoal = this.getCoalCapacity() > 0;
        boolean hasAmmo = this.getAmmoCapacity() > 0;
        for (Module m : this.modules) {
            if (m.type.getCrew(this.currentBonuses) > 0) {
                boolean pseudoCrewed = false;
                for (Crewman cm : this.crew) {
                    if (cm.currentTile.module != m) continue;
                    pseudoCrewed = true;
                    break;
                }
                if (!pseudoCrewed) continue;
            }
            if (m.type.isWeapon() && !hasAmmo || m.type.getCoalReload(this.currentBonuses) > 0 && !hasCoal) continue;
            m.time += ms;
        }
    }

    public boolean canFlipSafely(Combat combat) {
        boolean originalFlipped = this.flipped;
        this.flipped = !this.flipped;
        ArrayList<Body> bodies = combat.physics.bodies;
        int bsz = bodies.size();
        for (int bi = 0; bi < bsz; ++bi) {
            Body b = bodies.get(bi);
            if (b == this || b instanceof WheelBody && ((WheelBody)b).ship == this || b instanceof Foot && ((Foot)b).ship == this || !Rect2D.intersects(this.getX(), this.getY(), this.getBBWidth(), this.getBBHeight(), b.getX(), b.getY(), b.getBBWidth(), b.getBBHeight()) || !this.collidesWith(b, true)) continue;
            this.flipped = originalFlipped;
            return false;
        }
        this.flipped = originalFlipped;
        return true;
    }

    private void creak(int ms, Combat combat, boolean onViewingSide) {
        boolean doesCreak = false;
        int msz = this.modules.size();
        for (int i = 0; i < msz; ++i) {
            if (!this.modules.get((int)i).type.doesCreak()) continue;
            doesCreak = true;
            break;
        }
        if (!doesCreak) {
            return;
        }
        double mult = this.type.onGround ? 0.3 : 1.5;
        this.mechStress += (this.prevDx - this.getxSpeed()) * (this.prevDx - this.getxSpeed()) * StrictMath.abs(this.prevDx - this.getxSpeed()) * 10000.0 * (double)this.getWeight() * mult;
        this.prevDx = this.getxSpeed();
        double msDelta = 0.0;
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.hp > 0 && m.fire <= 0) continue;
            msDelta += (double)ms * 0.003;
        }
        this.mechStress += StrictMath.min((double)ms * 0.25, msDelta);
        if ((double)(AGame.ANIM_R.nextInt(2000) + 100) < this.mechStress) {
            combat.play(MiscCombatSound.CREAK, this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, this.getxSpeed(), this.getySpeed(), onViewingSide);
            this.mechStress = 0.0;
        }
    }

    public boolean tick(int ms, Combat combat, boolean won, boolean lost, boolean onViewingSide) {
        double futureYXAngle;
        int msz;
        boolean inCombat = this.inCombat(combat);
        this.hasHadSpringFriction = false;
        this.CURRENT_COMBAT_DELETEME = combat;
        this.outOfCombatMs = inCombat ? 0 : (this.outOfCombatMs += ms);
        double smoothSpeedMixFactor = 0.95;
        this.smoothedXSpeed = this.smoothedXSpeed * smoothSpeedMixFactor + this.getxSpeed() * (1.0 - smoothSpeedMixFactor);
        this.smoothedYSpeed = this.smoothedYSpeed * smoothSpeedMixFactor + this.getySpeed() * (1.0 - smoothSpeedMixFactor);
        if (!this.name.contains("Fragment")) {
            if (this.explosionAmount > 700.0) {
                combat.exceptionalCombatEvents.add(new ExceptionalCombatEvent("manyExplosionsMyShip", combat.sideOf(this), this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, null, this));
                combat.exceptionalCombatEvents.add(new ExceptionalCombatEvent("manyExplosionsEnemyShip", combat.otherSide(combat.sideOf(this)), this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, null, this));
                this.explosionAmount = 0.0;
            }
            if (this.moduleLossAmount > 8.0 && this.biggestInFleet && !inCombat) {
                combat.exceptionalCombatEvents.add(new ExceptionalCombatEvent("myFlagshipDestroyed", combat.sideOf(this), this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, null, this));
                combat.exceptionalCombatEvents.add(new ExceptionalCombatEvent("enemyFlagshipDestroyed", combat.otherSide(combat.sideOf(this)), this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, null, this));
                this.moduleLossAmount = 0.0;
            }
            if (this.moduleLossAmount > 16.0 && this.explosionAmount > 300.0 && !this.biggestInFleet && !inCombat) {
                combat.exceptionalCombatEvents.add(new ExceptionalCombatEvent("myShipDestroyedSpectacularly", combat.sideOf(this), this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, null, this));
                combat.exceptionalCombatEvents.add(new ExceptionalCombatEvent("enemyShipDestroyedSpectacularly", combat.otherSide(combat.sideOf(this)), this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, null, this));
                this.moduleLossAmount = 0.0;
            }
            if (!this.type.onGround && this.commandPointsGenerated() > 0 && this.getTotalResource(Resource.COAL) <= this.getCoalCapacity() / 12 && this.availableServiceCeilingNoFuel() <= 0 && this.availableServiceCeiling() > 0) {
                combat.exceptionalCombatEvents.add(new ExceptionalCombatEvent("imminentShipCrashNoFuel", combat.sideOf(this), this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, null, this));
            }
        }
        this.explosionAmount *= StrictMath.pow(0.9996, ms);
        this.moduleLossAmount *= StrictMath.pow(0.9996, ms);
        this.popOutCooldown -= ms;
        if (this.boarders.size() > 7) {
            int active = 0;
            int bsz = this.boarders.size();
            for (int bi = 0; bi < bsz; ++bi) {
                if (!this.boarders.get(bi).active()) continue;
                ++active;
            }
            if ((double)active < (double)bsz * 0.6) {
                combat.exceptionalCombatEvents.add(new ExceptionalCombatEvent("toughFighting", combat.otherSide(combat.sideOf(this)), this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, null, this));
            }
        }
        this.creak(ms, combat, onViewingSide);
        if (StrictMath.abs(this.getxSpeed()) > 0.001) {
            this.msSinceLastXMove = 0;
            if (this.getxSpeed() > 0.0) {
                this.timeMovingInSameXDirection = this.movingLeft ? 0 : (this.timeMovingInSameXDirection += ms);
                this.movingLeft = false;
            } else {
                this.timeMovingInSameXDirection = !this.movingLeft ? 0 : (this.timeMovingInSameXDirection += ms);
                this.movingLeft = true;
            }
        } else {
            this.msSinceLastXMove += ms;
        }
        this.updateBalancingOnLegs(ms);
        if (this.board != null && combat != null) {
            boolean friendly = combat.sideOf(this) == combat.sideOf(this.board);
            int csz = this.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman cm = this.crew.get(ci);
                if (!friendly && (!cm.type.canBoard || cm.job instanceof Module.FixedGuardJob)) continue;
                cm.abandonJob("off to board");
                cm.ultimateBoardTarget = this.board;
                cm.proximateBoardTarget = null;
            }
            Combat.Side mySide = combat.sideOf(this);
            csz = mySide.troops.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman cm = mySide.troops.get(ci);
                if (cm.attachedTo != this) continue;
                cm.ultimateBoardTarget = this.board;
                cm.proximateBoardTarget = null;
            }
            this.board = null;
        }
        this.msSinceOnGround += ms;
        boolean removed = false;
        ArrayList<Module> removeables = new ArrayList<Module>(this.modules);
        Collections.sort(removeables, new YCmp());
        int rmsz = removeables.size();
        boolean destroyEntire = false;
        for (int rmi = 0; rmi < rmsz; ++rmi) {
            Module m = removeables.get(rmi);
            if (m.hp > m.type.getDestroyedHP(this.currentBonuses) || !this.isAtEdge(m)) continue;
            if (m.type.getDestructionLength(this.currentBonuses) != 0) {
                if (m.destructionTime == 0) {
                    m.animOffset = -m.time;
                    if (m.type.destructionSound(this.currentBonuses) != null && m.type.playDestructionSoundAtStartOfDestruction()) {
                        double mCx = this.getX() + (double)this.gridXToWorldX(m.x, m.type.getW()) + (double)(m.type.getW() * 16 / 2);
                        double mCy = this.getY() + (double)(m.y * 16) + (double)(m.type.getH() * 16 / 2);
                        combat.play(m.type.destructionSound(this.currentBonuses), mCx, mCy, this.getxSpeed(), this.getySpeed(), onViewingSide);
                    }
                }
                m.destructionTime += ms;
                if (m.destructionTime < m.type.getDestructionLength(this.currentBonuses)) continue;
                removed = true;
                this.destroyModule(m, combat, true, onViewingSide);
                this.moduleLossAmount += (double)(m.type.getW() * m.type.getH());
                if (!m.type.getDestroyEntireShipOnDestruction()) continue;
                destroyEntire = true;
                continue;
            }
            m.hp -= ms;
            if (!m.type.getInstantlyDestroyed() && m.hp > m.type.getHp(this.currentBonuses) * -16) continue;
            removed = true;
            this.destroyModule(m, combat, true, onViewingSide);
            this.moduleLossAmount += (double)(m.type.getW() * m.type.getH());
            if (!m.type.getDestroyEntireShipOnDestruction()) continue;
            destroyEntire = true;
        }
        if (destroyEntire) {
            msz = this.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = this.modules.get(mi);
                m.hp = StrictMath.min(0, m.hp);
            }
        }
        if (removed) {
            this.recalcHPs();
            this.splitIfNeeded(combat, onViewingSide);
            this.layout();
            this.paths.clear();
            this.tilePaths.clear();
            return this.modules.isEmpty();
        }
        if (this.modules.isEmpty()) {
            return true;
        }
        this.commandPoints = combat != null && combat.instantCommandRegeneration ? this.commandPointsRequired() : StrictMath.max(0, StrictMath.min(this.commandPointsRequired(), this.commandPoints + this.commandPointsGenerated() * ms));
        msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            m.tick(ms, combat, onViewingSide);
        }
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            this.tiles.get(ti).tick(combat, ms, this);
        }
        this.assignJobsMs += ms;
        if (this.assignJobsMs >= 300) {
            this.assignJobsMs -= 300;
            this.assignJobs();
        }
        int csz = this.crew.size();
        Combat.Side shipSide = combat.sideOf(this);
        ArrayList<Crewman> cr = new ArrayList<Crewman>(this.crew);
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = cr.get(ci);
            cm.tick(ms, combat, shipSide, won, lost, onViewingSide, ci == this.canDoPathingIndex);
        }
        this.canDoPathingIndex = csz == 0 ? 0 : (this.canDoPathingIndex + 1) % csz;
        int bsz = this.boarders.size();
        cr = new ArrayList<Crewman>(this.boarders);
        for (int bi = 0; bi < bsz; ++bi) {
            Crewman cm = cr.get(bi);
            cm.tick(ms, combat, shipSide, won, lost, !onViewingSide, bi == this.boarderCanDoPathingIndex);
        }
        this.boarderCanDoPathingIndex = bsz == 0 ? 0 : (this.boarderCanDoPathingIndex + 1) % bsz;
        this.braking -= ms;
        this.hasBraked -= ms;
        int futureTest = this.type.onGround ? 80 : 500;
        double d = futureYXAngle = this.type.onGround ? -1.0 : 0.0;
        if (this.braking <= 0 && this.moveTo != null && (StrictMath.abs(this.moveTo.x - this.getX()) > 5.0 || StrictMath.abs(this.moveTo.y - this.getY()) > 5.0)) {
            boolean brake = false;
            ArrayList<Body> bs = combat.physics.bodies;
            int bodsz = bs.size();
            for (int bi = 0; bi < bodsz; ++bi) {
                Body b = bs.get(bi);
                if (b == this || b instanceof LandFormation && this.grounding || b instanceof Foot && ((Foot)b).ship == this || b instanceof WheelBody && ((WheelBody)b).ship == this) continue;
                double box = b.getX();
                double boy = b.getY();
                b.setX(b.getX() + b.getxSpeed() * (double)futureTest);
                b.setY(b.getY() + b.getySpeed() * (double)futureTest);
                if (!Rect2D.intersects(this.getX(), this.getY(), this.getBBWidth(), this.getBBHeight(), b.getX(), b.getY(), b.getBBWidth(), b.getBBHeight()) || !this.collidesWith(b, true)) {
                    double ox = this.getX();
                    double oy = this.getY();
                    this.setX(this.getX() + this.getxSpeed() * (double)futureTest);
                    this.setY(this.getY() + this.getySpeed() * (double)futureTest + StrictMath.abs(this.getxSpeed() * (double)futureTest) * futureYXAngle);
                    if (this.type.onGround && b instanceof LandFormation) {
                        this.setY((double)((LandFormation)b).getVerticalPosition(this, (int)this.getX(), this.flipped, true) - this.groundOffset());
                    }
                    if (Rect2D.intersects(this.getX(), this.getY(), this.getBBWidth(), this.getBBHeight(), b.getX(), b.getY(), b.getBBWidth(), b.getBBHeight()) && this.collidesWith(b, true)) {
                        double speedDeltaSquared = (this.getxSpeed() - b.getxSpeed()) * (this.getxSpeed() - b.getxSpeed()) + (this.getySpeed() - b.getySpeed()) * (this.getySpeed() - b.getySpeed());
                        double collisionForce = speedDeltaSquared * (double)(this.getCollisionMass() + b.getCollisionMass());
                        if (collisionForce > 100.0) {
                            brake = true;
                        }
                        if (collisionForce > 1000.0) {
                            if (this.fallingTime > 1500 && b instanceof LandFormation && ((LandFormation)b).immobile) {
                                combat.exceptionalCombatEvents.add(new ExceptionalCombatEvent("aboutToCrash", shipSide, this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, null, this));
                            } else if (this.ramming) {
                                combat.exceptionalCombatEvents.add(new ExceptionalCombatEvent("aboutToRam", shipSide, this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, null, this));
                            } else {
                                combat.exceptionalCombatEvents.add(new ExceptionalCombatEvent("aboutToCollide", shipSide, this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, null, this));
                            }
                        }
                    }
                    this.setX(ox);
                    this.setY(oy);
                }
                b.setX(box);
                b.setY(boy);
                if (brake) break;
            }
            if (this.type == ShipType.LANDSHIP && !this.ramming) {
                boolean hasLegs = false;
                msz = this.modules.size();
                for (int mi = 0; mi < msz; ++mi) {
                    if (this.modules.get((int)mi).legs.size() <= 2) continue;
                    hasLegs = true;
                    break;
                }
                int ssz = shipSide.ships.size();
                for (int si = 0; si < ssz; ++si) {
                    Airship other = shipSide.ships.get(si);
                    if (other == this || !other.type.onGround) continue;
                    boolean otherHasLegs = false;
                    msz = other.modules.size();
                    for (int mi = 0; mi < msz; ++mi) {
                        if (other.modules.get((int)mi).legs.size() <= 2) continue;
                        otherHasLegs = true;
                        break;
                    }
                    if (!hasLegs && !otherHasLegs) continue;
                    double myX = this.getX() + this.getxSpeed() * (double)futureTest;
                    double myY = (double)combat.landFormations.get(0).getVerticalPosition(this, (int)this.getX(), this.flipped, true) - this.groundOffset();
                    double myW = this.getBBWidth();
                    double myH = this.getBBHeight();
                    double ow = other.getBBWidth();
                    double oh = other.getBBHeight();
                    if (hasLegs && !Rect2D.intersects(this.getX() - myW / 2.0, this.getY(), myW * 2.0, myH + myW / 4.0, other.getX(), other.getX(), ow, oh) && Rect2D.intersects(myX - myW / 2.0, myY, myW * 2.0, myH + myW / 4.0, other.getX(), other.getY(), ow, oh)) {
                        brake = true;
                        break;
                    }
                    if (!otherHasLegs || Rect2D.intersects(this.getX(), this.getY(), myW, myH, other.getX() - ow / 2.0, other.getY(), ow * 2.0, oh + ow / 4.0) || !Rect2D.intersects(myX, myY, myW, myH, other.getX() - ow / 2.0, other.getY(), ow * 2.0, oh + ow / 4.0)) continue;
                    brake = true;
                    break;
                }
            }
            if (brake && !this.ramming) {
                this.moveTo = new Pt(this.getX(), this.getY());
                this.flipTo = this.flipped;
                this.commandPoints = StrictMath.min(this.commandPointsRequired(), this.commandPoints + this.commandPointsRequired() / 2);
                this.braking = 500;
                this.hasBraked = 8000;
            }
        }
        if (this.moveTo != null) {
            boolean doFlip;
            boolean needToFlip;
            boolean moveDirection = this.moveTo.x < this.getX();
            boolean bl = needToFlip = this.flipTo != this.flipped;
            boolean flipAtEnd = this.moveMode.override ? this.moveMode.flipAtEnd : moveDirection == this.flipped;
            boolean nearEnd = StrictMath.abs(this.moveTo.x - this.getX()) < 80.0;
            boolean bl2 = doFlip = needToFlip && (!flipAtEnd || nearEnd);
            if (doFlip) {
                if (this.availableTurningCost() > 0 && this.canFlipSafely(combat)) {
                    this.enginesRunning = true;
                    this.flipMs += ms;
                    if (this.flipMs >= this.availableTurningCost()) {
                        this.setFlipped(this.flipTo, combat);
                        this.flipMs = 0;
                    }
                } else {
                    this.unableToFlipMs += ms;
                    if (this.unableToFlipMs >= 3000) {
                        this.flipTo = this.flipped;
                        this.unableToFlipMs = 0;
                    }
                }
                this.setyForce(this.getyForce() - StrictMath.max(0.0, StrictMath.min(this.availableSuspendiumForce(), this.suspendiumForceForY(this.moveTo.y, false, 0.0, 0.0) + this.lastExertedYForce)));
            } else {
                double ef = this.grounded() && !this.type.onGround ? 0.0 : this.engineForceForX(this.moveTo.x);
                this.setxForce(this.getxForce() + ef);
                this.enginesRunning = ef != 0.0;
                double adjF = ef * (StrictMath.abs(this.moveTo.y - this.getY()) + 10.0) / (StrictMath.abs(this.moveTo.x - this.getX()) + 10.0) * 1.8;
                double adjS = StrictMath.abs(this.getxSpeed()) * (StrictMath.abs(this.moveTo.y - this.getY()) + 10.0) / (StrictMath.abs(this.moveTo.x - this.getX()) + 10.0) * 1.1;
                this.setyForce(this.getyForce() - StrictMath.max(0.0, StrictMath.min(this.availableSuspendiumForce(), this.suspendiumForceForY(this.moveTo.y, ef != 0.0, StrictMath.abs(adjF), adjS) + this.lastExertedYForce)));
            }
        } else {
            this.enginesRunning = false;
            this.setyForce(this.getyForce() - this.availableSuspendiumForce());
        }
        boolean bl = this.suspendiumRunning = !this.grounded();
        this.msSuspendiumOff = this.suspendiumRunning ? 0 : (this.msSuspendiumOff += ms);
        this.crashCooldown -= ms;
        if (this.crashCooldown < 0) {
            this.crashCooldown = 0;
        }
        if (this.crashSize == 3) {
            if (this.crashCooldown == 0) {
                combat.play(MiscCombatSound.LARGE_CRASH, this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, this.getxSpeed(), this.getySpeed(), onViewingSide);
                this.crashCooldown = 3000 + AGame.ANIM_R.nextInt(2500);
            } else {
                --this.crashSize;
            }
        }
        if (this.crashSize == 2) {
            if (this.crashCooldown < 800) {
                combat.play(MiscCombatSound.MEDIUM_CRASH, this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, this.getxSpeed(), this.getySpeed(), onViewingSide);
                this.crashCooldown = 2000 + AGame.ANIM_R.nextInt(2000);
            } else {
                --this.crashSize;
            }
        }
        if (this.crashSize == 1 && this.crashCooldown < 1200) {
            combat.play(MiscCombatSound.SMALL_CRASH, this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, this.getxSpeed(), this.getySpeed(), onViewingSide);
            this.crashCooldown = 1500 + AGame.ANIM_R.nextInt(1000);
        }
        this.crashSize = 0;
        this.fallingTime = this.getxSpeed() > 0.3 ? (this.fallingTime += ms) : 0;
        this.updateWeight();
        return false;
    }

    @Override
    public boolean removeMe() {
        return this.modules.isEmpty();
    }

    @Override
    public double elasticity() {
        return 0.5;
    }

    private double getAerodynamicHeight() {
        int msz = this.modules.size();
        double extraHeight = 0.0;
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            ArrayList<Leg.Spec> ls = m.type.getLegSpecs();
            if (ls.isEmpty()) continue;
            extraHeight = StrictMath.max(extraHeight, (ls.get((int)0).upperLimbLength + ls.get((int)0).lowerLimbLength) / 16.0 / 2.0);
        }
        double adh = 0.0;
        block1: for (int ty = 0; ty < this.h; ++ty) {
            for (int tx = 0; tx < this.w; ++tx) {
                Tile t = this.tileAt(tx, ty);
                if (t == null || !t.module.type.producesHorizontalDrag()) continue;
                adh += 1.0;
                continue block1;
            }
        }
        return adh + extraHeight;
    }

    private double extraVerticalAirFriction() {
        int msz = this.modules.size();
        double f = 0.0;
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            f = StrictMath.max(f, m.type.getExtraVerticalAirFriction());
        }
        return f;
    }

    @Override
    public double horizontalAirFriction() {
        return 0.001 + this.getAerodynamicHeight() * 1.0 / (double)this.getWidth() * 0.0035;
    }

    @Override
    public double verticalAirFriction() {
        return 0.001 + (double)this.getWidth() * 1.0 / this.getAerodynamicHeight() * 0.0035 + this.extraVerticalAirFriction();
    }

    @Override
    public int getCollisionMass() {
        return StrictMath.max(this.getWeight(), 10);
    }

    @Override
    public int getMass() {
        return StrictMath.max(this.getWeight(), 10);
    }

    @Override
    public boolean isImmobile() {
        return false;
    }

    @Override
    public double getBBWidth() {
        return this.getWidth() * 16;
    }

    @Override
    public double getBBHeight() {
        return this.getHeight() * 16;
    }

    @Override
    public boolean collidesWith(PhysicsRect b2) {
        if (b2 instanceof Foot && (((Foot)b2).ship == this || !((Foot)b2).isDown)) {
            return false;
        }
        if (b2 instanceof WheelBody) {
            if (((WheelBody)b2).ship == this) {
                return false;
            }
            return this.overlapsWith((WheelBody)b2);
        }
        if (b2 instanceof Airship) {
            return this.overlapsWith((Airship)b2);
        }
        if (b2 instanceof LandFormation) {
            return this.overlapsWith((LandFormation)b2, false);
        }
        if (b2 instanceof Crewman) {
            return this.overlapsWith((Crewman)b2);
        }
        return this.overlapsWith(b2);
    }

    public boolean collidesWith(PhysicsRect b2, boolean ignoreSoftThings) {
        if (b2 instanceof Airship) {
            return this.overlapsWith((Airship)b2);
        }
        if (b2 instanceof LandFormation) {
            return this.overlapsWith((LandFormation)b2, ignoreSoftThings);
        }
        return this.overlapsWith(b2);
    }

    @Override
    public void doCollision(Body b2, double hitEnergy, Combat combat, boolean atSpeed) {
        ArrayList<OverlappingTile> overlaps = b2 instanceof WheelBody ? this.overlaps((WheelBody)b2) : (b2 instanceof Airship ? this.overlaps((Airship)b2) : (b2 instanceof LandFormation ? this.overlaps((LandFormation)b2) : this.overlaps(b2)));
        if (overlaps.isEmpty()) {
            return;
        }
        if (b2 instanceof Foot && combat.sideOf(this) == combat.sideOf(((Foot)b2).ship)) {
            hitEnergy /= 4.0;
        }
        this.collideWith(overlaps, hitEnergy, combat, b2 instanceof LandFormation ? (LandFormation)b2 : null, b2 instanceof Airship ? (Airship)b2 : null, b2 instanceof LandFormation && !b2.isImmobile());
    }

    public boolean overlapsWith(WheelBody b2) {
        int tileW = this.getWidth();
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            double ty;
            Tile t = this.tiles.get(ti);
            double tx = this.getX() + (double)((this.flipped ? tileW - t.x - 1 : t.x) * 16);
            if (!b2.intersectsWithRect(tx, ty = this.getY() + (double)(t.y * 16), 16.0, 16.0) || t.module.type.getTileMasks(this.currentBonuses)[t.y - t.module.y][t.x - t.module.x] != TileMask.FULL) continue;
            return true;
        }
        return false;
    }

    public boolean overlapsWith(LandFormation b2, boolean ignoreSoftThings) {
        int tileW = this.getWidth();
        double lfx = b2.getX();
        double lfy = b2.getY();
        int lfgw = b2.grid[0].length;
        int lfgh = b2.grid.length;
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            TileMask tm = t.module.type.getTileMasks(this.currentBonuses)[t.y - t.module.y][t.x - t.module.x];
            if (tm == TileMask.EMPTY) continue;
            double tx = this.getX() + (double)((this.flipped ? tileW - t.x - 1 : t.x) * 16);
            double ty = this.getY() + (double)(t.y * 16);
            int lfgx = (int)StrictMath.floor((tx - lfx) / 16.0);
            int lfgy = (int)StrictMath.floor((ty - lfy) / 16.0);
            int blockX = (int)lfx + lfgx * 16;
            int blockY = (int)lfy + lfgy * 16;
            if (lfgy >= 0 && lfgy < lfgh && lfgx >= 0 && lfgx < lfgw && (ignoreSoftThings ? b2.grid[lfgy][lfgx].damageMultiplier > 0.4 : b2.grid[lfgy][lfgx].solid) && tm.intersectsBlock((int)tx, (int)ty, this.flipped, blockX, blockY)) {
                return true;
            }
            if (lfgy + 1 >= 0 && lfgy + 1 < lfgh && lfgx + 1 >= 0 && lfgx + 1 < lfgw && (ignoreSoftThings ? b2.grid[lfgy + 1][lfgx + 1].damageMultiplier > 0.4 : b2.grid[lfgy + 1][lfgx + 1].solid) && tm.intersectsBlock((int)tx, (int)ty, this.flipped, blockX + 16, blockY + 16)) {
                return true;
            }
            if (lfgy + 1 >= 0 && lfgy + 1 < lfgh && lfgx >= 0 && lfgx < lfgw && (ignoreSoftThings ? b2.grid[lfgy + 1][lfgx].damageMultiplier > 0.4 : b2.grid[lfgy + 1][lfgx].solid) && tm.intersectsBlock((int)tx, (int)ty, this.flipped, blockX, blockY + 16)) {
                return true;
            }
            if (lfgy < 0 || lfgy >= lfgh || lfgx + 1 < 0 || lfgx + 1 >= lfgw || !(ignoreSoftThings ? b2.grid[lfgy][lfgx + 1].damageMultiplier > 0.4 : b2.grid[lfgy][lfgx + 1].solid) || !tm.intersectsBlock((int)tx, (int)ty, this.flipped, blockX + 16, blockY)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<OverlappingTile> overlaps(WheelBody b2) {
        ArrayList<OverlappingTile> overlaps = new ArrayList<OverlappingTile>();
        int tileW = this.getWidth();
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            double ty;
            Tile t = this.tiles.get(ti);
            double tx = this.getX() + (double)((this.flipped ? tileW - t.x - 1 : t.x) * 16);
            if (!b2.intersectsWithRect(tx, ty = this.getY() + (double)(t.y * 16), 16.0, 16.0) || t.module.type.getTileMasks(this.currentBonuses)[t.y - t.module.y][t.x - t.module.x] != TileMask.FULL) continue;
            overlaps.add(new OverlappingTile(t, 0.3));
        }
        return overlaps;
    }

    public ArrayList<OverlappingTile> overlaps(LandFormation b2) {
        ArrayList<OverlappingTile> overlaps = new ArrayList<OverlappingTile>();
        int tileW = this.getWidth();
        double lfx = b2.getX();
        double lfy = b2.getY();
        int lfgw = b2.grid[0].length;
        int lfgh = b2.grid.length;
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            TileMask tm = t.module.type.getTileMasks(this.currentBonuses)[t.y - t.module.y][t.x - t.module.x];
            if (tm == TileMask.EMPTY) continue;
            double tx = this.getX() + (double)((this.flipped ? tileW - t.x - 1 : t.x) * 16);
            double ty = this.getY() + (double)(t.y * 16);
            int lfgx = (int)StrictMath.floor((tx - lfx) / 16.0);
            int lfgy = (int)StrictMath.floor((ty - lfy) / 16.0);
            int blockX = (int)lfx + lfgx * 16;
            int blockY = (int)lfy + lfgy * 16;
            double damageMultiplier = 0.0;
            if (lfgy >= 0 && lfgy < lfgh && lfgx >= 0 && lfgx < lfgw && b2.grid[lfgy][lfgx].solid && tm.intersectsBlock((int)tx, (int)ty, this.flipped, blockX, blockY)) {
                damageMultiplier = StrictMath.max(damageMultiplier, b2.grid[lfgy][lfgx].damageMultiplier);
            }
            if (lfgy + 1 >= 0 && lfgy + 1 < lfgh && lfgx + 1 >= 0 && lfgx + 1 < lfgw && b2.grid[lfgy + 1][lfgx + 1].solid && tm.intersectsBlock((int)tx, (int)ty, this.flipped, blockX + 16, blockY + 16)) {
                damageMultiplier = StrictMath.max(damageMultiplier, b2.grid[lfgy + 1][lfgx + 1].damageMultiplier);
            }
            if (lfgy + 1 >= 0 && lfgy + 1 < lfgh && lfgx >= 0 && lfgx < lfgw && b2.grid[lfgy + 1][lfgx].solid && tm.intersectsBlock((int)tx, (int)ty, this.flipped, blockX, blockY + 16)) {
                damageMultiplier = StrictMath.max(damageMultiplier, b2.grid[lfgy + 1][lfgx].damageMultiplier);
            }
            if (lfgy >= 0 && lfgy < lfgh && lfgx + 1 >= 0 && lfgx + 1 < lfgw && b2.grid[lfgy][lfgx + 1].solid && tm.intersectsBlock((int)tx, (int)ty, this.flipped, blockX + 16, blockY)) {
                damageMultiplier = StrictMath.max(damageMultiplier, b2.grid[lfgy][lfgx + 1].damageMultiplier);
            }
            if (!(damageMultiplier > 0.0)) continue;
            overlaps.add(new OverlappingTile(t, damageMultiplier));
        }
        return overlaps;
    }

    public boolean overlapsWith(Airship b) {
        int tileW = this.getWidth();
        int bTileW = b.getWidth();
        double bx = b.getX();
        double by = b.getY();
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            int t2Y;
            int t2X;
            TileMask tm2;
            double ty;
            int bty;
            Tile t = this.tiles.get(ti);
            TileMask tm = t.module.type.getTileMasks(this.currentBonuses)[t.y - t.module.y][t.x - t.module.x];
            if (tm == TileMask.EMPTY) continue;
            double tx = this.flipped ? this.getX() + (double)((tileW - t.x - 1) * 16) : this.getX() + (double)(t.x * 16);
            int btx = b.flipped ? bTileW - 2 - (int)StrictMath.floor((tx - bx) / 16.0) : (int)StrictMath.floor((tx - bx) / 16.0);
            Tile t2 = b.tileAt(btx, bty = (int)StrictMath.floor(((ty = this.getY() + (double)(t.y * 16)) - by) / 16.0));
            if (t2 != null && tm.intersects((int)tx, (int)ty, this.flipped, tm2 = t2.module.type.getTileMasks(this.currentBonuses)[t2.y - t2.module.y][t2.x - t2.module.x], t2X = (int)bx + b.gridXToWorldX(t2.x, 1) * 16, t2Y = (int)by + t2.y * 16, b.flipped)) {
                return true;
            }
            t2 = b.tileAt(btx + 1, bty + 1);
            if (t2 != null && tm.intersects((int)tx, (int)ty, this.flipped, tm2 = t2.module.type.getTileMasks(this.currentBonuses)[t2.y - t2.module.y][t2.x - t2.module.x], t2X = (int)bx + b.gridXToWorldX(t2.x, 1) * 16, t2Y = (int)by + t2.y * 16, b.flipped)) {
                return true;
            }
            t2 = b.tileAt(btx + 1, bty);
            if (t2 != null && tm.intersects((int)tx, (int)ty, this.flipped, tm2 = t2.module.type.getTileMasks(this.currentBonuses)[t2.y - t2.module.y][t2.x - t2.module.x], t2X = (int)bx + b.gridXToWorldX(t2.x, 1) * 16, t2Y = (int)by + t2.y * 16, b.flipped)) {
                return true;
            }
            t2 = b.tileAt(btx, bty + 1);
            if (t2 == null || !tm.intersects((int)tx, (int)ty, this.flipped, tm2 = t2.module.type.getTileMasks(this.currentBonuses)[t2.y - t2.module.y][t2.x - t2.module.x], t2X = (int)bx + b.gridXToWorldX(t2.x, 1) * 16, t2Y = (int)by + t2.y * 16, b.flipped)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<OverlappingTile> overlaps(Airship b) {
        ArrayList<OverlappingTile> overlaps = new ArrayList<OverlappingTile>();
        int tileW = this.getWidth();
        int bTileW = b.getWidth();
        double bx = b.getX();
        double by = b.getY();
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            int t2Y;
            int t2X;
            TileMask tm2;
            Tile t = this.tiles.get(ti);
            TileMask tm = t.module.type.getTileMasks(this.currentBonuses)[t.y - t.module.y][t.x - t.module.x];
            if (tm == TileMask.EMPTY) continue;
            double tx = this.flipped ? this.getX() + (double)((tileW - t.x - 1) * 16) : this.getX() + (double)(t.x * 16);
            double ty = this.getY() + (double)(t.y * 16);
            int btx = b.flipped ? bTileW - 2 - (int)StrictMath.floor((tx - bx) / 16.0) : (int)StrictMath.floor((tx - bx) / 16.0);
            int bty = (int)StrictMath.floor((ty - by) / 16.0);
            int nTiles = 0;
            double dmgMult = 0.0;
            Tile t2 = b.tileAt(btx, bty);
            if (t2 != null && tm.intersects((int)tx, (int)ty, this.flipped, tm2 = t2.module.type.getTileMasks(b.currentBonuses)[t2.y - t2.module.y][t2.x - t2.module.x], t2X = (int)bx + b.gridXToWorldX(t2.x, 1) * 16, t2Y = (int)by + t2.y * 16, b.flipped)) {
                ++nTiles;
                dmgMult += t2.module.type.getHardness(b.currentBonuses);
            }
            if ((t2 = b.tileAt(btx + 1, bty)) != null && tm.intersects((int)tx, (int)ty, this.flipped, tm2 = t2.module.type.getTileMasks(b.currentBonuses)[t2.y - t2.module.y][t2.x - t2.module.x], t2X = (int)bx + b.gridXToWorldX(t2.x, 1) * 16, t2Y = (int)by + t2.y * 16, b.flipped)) {
                ++nTiles;
                dmgMult += t2.module.type.getHardness(b.currentBonuses);
            }
            if ((t2 = b.tileAt(btx, bty + 1)) != null && tm.intersects((int)tx, (int)ty, this.flipped, tm2 = t2.module.type.getTileMasks(b.currentBonuses)[t2.y - t2.module.y][t2.x - t2.module.x], t2X = (int)bx + b.gridXToWorldX(t2.x, 1) * 16, t2Y = (int)by + t2.y * 16, b.flipped)) {
                ++nTiles;
                dmgMult += t2.module.type.getHardness(b.currentBonuses);
            }
            if ((t2 = b.tileAt(btx + 1, bty + 1)) != null && tm.intersects((int)tx, (int)ty, this.flipped, tm2 = t2.module.type.getTileMasks(b.currentBonuses)[t2.y - t2.module.y][t2.x - t2.module.x], t2X = (int)bx + b.gridXToWorldX(t2.x, 1) * 16, t2Y = (int)by + t2.y * 16, b.flipped)) {
                ++nTiles;
                dmgMult += t2.module.type.getHardness(b.currentBonuses);
            }
            if (nTiles <= 0) continue;
            overlaps.add(new OverlappingTile(t, dmgMult / (double)nTiles * t.module.type.getCollisionDamageReceivedMult(this.currentBonuses)));
        }
        return overlaps;
    }

    public boolean overlapsWith(PhysicsRect b2) {
        int top = (int)StrictMath.floor((b2.getY() - this.getY()) / 16.0);
        int bottom = (int)StrictMath.floor((b2.getY() + b2.getBBHeight() - this.getY()) / 16.0);
        int left = (int)StrictMath.floor((b2.getX() - this.getX()) / 16.0);
        int right = (int)StrictMath.floor((b2.getX() + b2.getBBWidth() - this.getX()) / 16.0);
        if (top < 0 && left < 0 && bottom >= this.h && right >= this.w) {
            return true;
        }
        int ot = top;
        int ob = bottom;
        int ol = left;
        int or = right;
        top = StrictMath.max(StrictMath.min(ob, 0), top);
        bottom = StrictMath.min(StrictMath.max(ot, this.h - 1), bottom);
        left = StrictMath.max(StrictMath.min(or, 0), left);
        right = StrictMath.min(StrictMath.max(ol, this.w - 1), right);
        for (int xx = left; xx <= right; ++xx) {
            TileMask bottomTileMask;
            TileMask topTileMask;
            int gx = this.gridXToWorldX(xx, 1);
            Tile topTile = this.tileAt(gx, top);
            if (topTile != null && (topTileMask = topTile.module.type.getTileMasks(this.currentBonuses)[topTile.y - topTile.module.y][topTile.x - topTile.module.x]).intersectsRect((int)this.getX() + xx * 16, (int)this.getY() + top * 16, this.flipped, (int)b2.getX(), (int)b2.getY(), (int)b2.getBBWidth(), (int)b2.getBBHeight())) {
                return true;
            }
            Tile bottomTile = this.tileAt(gx, bottom);
            if (bottomTile == null || !(bottomTileMask = bottomTile.module.type.getTileMasks(this.currentBonuses)[bottomTile.y - bottomTile.module.y][bottomTile.x - bottomTile.module.x]).intersectsRect((int)this.getX() + xx * 16, (int)this.getY() + bottom * 16, this.flipped, (int)b2.getX(), (int)b2.getY(), (int)b2.getBBWidth(), (int)b2.getBBHeight())) continue;
            return true;
        }
        int leftG = this.gridXToWorldX(left, 1);
        int rightG = this.gridXToWorldX(right, 1);
        for (int yy = top; yy <= bottom; ++yy) {
            TileMask rightTileMask;
            TileMask leftTileMask;
            Tile leftTile = this.tileAt(leftG, yy);
            if (leftTile != null && (leftTileMask = leftTile.module.type.getTileMasks(this.currentBonuses)[leftTile.y - leftTile.module.y][leftTile.x - leftTile.module.x]).intersectsRect((int)this.getX() + left * 16, (int)this.getY() + yy * 16, this.flipped, (int)b2.getX(), (int)b2.getY(), (int)b2.getBBWidth(), (int)b2.getBBHeight())) {
                return true;
            }
            Tile rightTile = this.tileAt(rightG, yy);
            if (rightTile == null || !(rightTileMask = rightTile.module.type.getTileMasks(this.currentBonuses)[rightTile.y - rightTile.module.y][rightTile.x - rightTile.module.x]).intersectsRect((int)this.getX() + right * 16, (int)this.getY() + yy * 16, this.flipped, (int)b2.getX(), (int)b2.getY(), (int)b2.getBBWidth(), (int)b2.getBBHeight())) continue;
            return true;
        }
        return false;
    }

    public boolean overlapsWith(Crewman b2) {
        int top = (int)StrictMath.floor((b2.getY() - this.getY()) / 16.0);
        int bottom = (int)StrictMath.floor((b2.getY() + b2.getBBHeight() - this.getY()) / 16.0);
        int left = (int)StrictMath.floor((b2.getX() - this.getX()) / 16.0);
        int right = (int)StrictMath.floor((b2.getX() + b2.getBBWidth() - this.getX()) / 16.0);
        if (top < 0 && left < 0 && bottom >= this.h && right >= this.w) {
            return true;
        }
        int ot = top;
        int ob = bottom;
        int ol = left;
        int or = right;
        top = StrictMath.max(StrictMath.min(ob, 0), top);
        bottom = StrictMath.min(StrictMath.max(ot, this.h - 1), bottom);
        left = StrictMath.max(StrictMath.min(or, 0), left);
        right = StrictMath.min(StrictMath.max(ol, this.w - 1), right);
        for (int xx = left; xx <= right; ++xx) {
            TileMask bottomTileMask;
            TileMask topTileMask;
            int gx = this.gridXToWorldX(xx, 1);
            Tile topTile = this.tileAt(gx, top);
            if (topTile != null && (topTileMask = topTile.module.type.getTileMasks(this.currentBonuses)[topTile.y - topTile.module.y][topTile.x - topTile.module.x]) != TileMask.EMPTY) {
                return true;
            }
            Tile bottomTile = this.tileAt(gx, bottom);
            if (bottomTile == null || (bottomTileMask = bottomTile.module.type.getTileMasks(this.currentBonuses)[bottomTile.y - bottomTile.module.y][bottomTile.x - bottomTile.module.x]) == TileMask.EMPTY) continue;
            return true;
        }
        int leftG = this.gridXToWorldX(left, 1);
        int rightG = this.gridXToWorldX(right, 1);
        for (int yy = top; yy <= bottom; ++yy) {
            TileMask rightTileMask;
            TileMask leftTileMask;
            Tile leftTile = this.tileAt(leftG, yy);
            if (leftTile != null && (leftTileMask = leftTile.module.type.getTileMasks(this.currentBonuses)[leftTile.y - leftTile.module.y][leftTile.x - leftTile.module.x]) != TileMask.EMPTY) {
                return true;
            }
            Tile rightTile = this.tileAt(rightG, yy);
            if (rightTile == null || (rightTileMask = rightTile.module.type.getTileMasks(this.currentBonuses)[rightTile.y - rightTile.module.y][rightTile.x - rightTile.module.x]) == TileMask.EMPTY) continue;
            return true;
        }
        return false;
    }

    public ArrayList<OverlappingTile> overlaps(Body b2) {
        ArrayList<OverlappingTile> overlaps = new ArrayList<OverlappingTile>();
        int tileW = this.getWidth();
        int bx = (int)b2.getX();
        int by = (int)b2.getY();
        int bw = (int)b2.getBBWidth();
        int bh = (int)b2.getBBHeight();
        if (this.flipped) {
            int tsz = this.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                double ty;
                double tx;
                Tile t = this.tiles.get(ti);
                TileMask tm = t.module.type.getTileMasks(this.currentBonuses)[t.y - t.module.y][t.x - t.module.x];
                if (tm == TileMask.EMPTY || !tm.intersectsRect((int)(tx = this.getX() + (double)((tileW - t.x - 1) * 16)), (int)(ty = this.getY() + (double)(t.y * 16)), this.flipped, bx, by, bw, bh)) continue;
                overlaps.add(new OverlappingTile(t, 1.0));
            }
        } else {
            int tsz = this.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                double ty;
                double tx;
                Tile t = this.tiles.get(ti);
                TileMask tm = t.module.type.getTileMasks(this.currentBonuses)[t.y - t.module.y][t.x - t.module.x];
                if (tm == TileMask.EMPTY || !tm.intersectsRect((int)(tx = this.getX() + (double)(t.x * 16)), (int)(ty = this.getY() + (double)(t.y * 16)), this.flipped, bx, by, bw, bh)) continue;
                overlaps.add(new OverlappingTile(t, 1.0));
            }
        }
        return overlaps;
    }

    private void collideWith(ArrayList<OverlappingTile> overlaps, double hitEnergy, Combat combat, LandFormation withLF, Airship withShip, boolean groundIsFloatingRock) {
        if (overlaps.isEmpty()) {
            return;
        }
        int dmg = (int)(hitEnergy / (double)overlaps.size());
        if (withLF != null) {
            this.msSinceOnGround = 0;
            this.lastGrounded = withLF;
            this.collidedWithFloatingRock = groundIsFloatingRock;
        }
        int n = dmg > 20 ? 2 : (this.crashSize = dmg > 10 ? 1 : this.crashSize);
        if (this.crashSize == 2 && withShip != null) {
            this.justRammedBy.add(withShip);
        }
        if (withShip != null) {
            this.justCollidedWith.add(withShip);
        }
        if (dmg > 0) {
            int osz = overlaps.size();
            for (int ti = 0; ti < osz; ++ti) {
                OverlappingTile ot = overlaps.get(ti);
                Tile t = ot.tile;
                int aDmg = StrictMath.max(0, (int)((double)dmg * ot.dmgMultiplier));
                if (!this.type.mobile && this.type.onGround || t.armour.hp == t.armour.getMaxHP()) {
                    aDmg -= t.armour.type.getBlastDmgAbsorb(this.constructionBonuses) + t.armour.type.getPenDmgAbsorb(this.constructionBonuses) + t.module.getShellPenAbsorb() + t.module.getShellBlastAbsorb() + 3;
                }
                if (aDmg <= 0) continue;
                t.module.hp -= aDmg;
                if (t.module.hp <= -t.module.type.getHp(this.currentBonuses) / 2) {
                    t.module.hp = t.module.type.getHp(this.currentBonuses) * -16 - 1;
                }
                int prevHP = t.armour.hp;
                t.armour.hp = StrictMath.max(0, t.armour.hp - dmg / 4);
                for (ModuleType.FragmentImg fragI : t.armour.getFragments(prevHP, t.armour.hp)) {
                    double speed = AGame.rnd(0.1, 0.25, 0.2, 0.4, 0.8) * 0.3;
                    double angle = AGame.ANIM_R.nextDouble() * 2.0 * Math.PI;
                    double dx = speed * StrictMath.cos(angle);
                    double dy = speed * StrictMath.sin(angle) - 0.3 * speed;
                    combat.fragments.add(new Fragment(fragI.ssb, fragI.img, (double)(this.getIntX() + this.gridXToWorldX(t.x, 1) * 16 + fragI.dx), (double)(this.getIntY() + t.y * 16 + fragI.dy), dx, dy, 0.0, AGame.ANIM_R.nextDouble() * 0.02 - 0.01, 500 + AGame.ANIM_R.nextInt(1200), 4));
                }
                if (withLF == null || t.y != this.h - 1 || dmg <= 3 || AGame.ANIM_R.nextInt(3) != 0) continue;
                combat.particles.add(new Particle(ParticleType.ofName("dust"), this.getIntX() + this.gridXToWorldX(t.x, 1) * 16 + 8, this.getIntY() + t.y * 16 + 8));
            }
        }
    }

    private boolean isValidDecalLocation(DecalType type, int x, int y) {
        for (int dy = 0; dy < type.h; ++dy) {
            for (int dx = 0; dx < type.w; ++dx) {
                Tile t = this.tileAt(x + dx, y + dy);
                if (t != null) continue;
                return false;
            }
        }
        return true;
    }

    private void clearInvalidDecals() {
        Iterator<Decal> it = this.decals.iterator();
        while (it.hasNext()) {
            Decal d = it.next();
            if (this.isValidDecalLocation(d.type, d.x, d.y)) continue;
            it.remove();
        }
    }

    public boolean canAddDecal(DecalType type, int x, int y, int layer, Collection<Decal> ignore) {
        if (!this.isValidDecalLocation(type, x, y)) {
            return false;
        }
        for (Decal d : this.decals) {
            if (ignore.contains(d) || d.layer != layer || x >= d.x + d.type.w || d.x >= x + type.w || y >= d.y + d.type.h || d.y >= y + type.h) continue;
            return false;
        }
        return true;
    }

    public Decal addDecal(DecalType type, int x, int y, int layer) {
        Decal d = new Decal(type, x, y, layer);
        this.decals.add(d);
        return d;
    }

    public DecalType removeDecalAt(int x, int y) {
        for (Decal d : this.decals) {
            if (d.x > x || d.y > y || d.x + d.type.w <= x || d.y + d.type.h <= y) continue;
            this.decals.remove(d);
            return d.type;
        }
        return null;
    }

    public Module moduleThatObstructsFront(ModuleType type, int placeX, int placeY, Collection<Module> ignore) {
        Module best = null;
        int checkX = placeX + type.getW();
        for (int moduleSpaceY = 0; moduleSpaceY < type.getH(); ++moduleSpaceY) {
            if (!type.isFrontOnly()[moduleSpaceY]) continue;
            int checkY = placeY + moduleSpaceY;
            for (Module m : this.modules) {
                if (ignore.contains(m) || m.x < checkX || m.y > checkY || m.y + m.type.getH() <= checkY || best != null && m.x >= best.x && (m.x != best.x || m.y >= best.y)) continue;
                best = m;
            }
        }
        return best;
    }

    public Module moduleWhoseFrontIsObstructed(ModuleType type, int placeX, int placeY, Collection<Module> ignore) {
        Module best = null;
        for (Module m : this.modules) {
            if (ignore.contains(m)) continue;
            int checkX = m.x + m.type.getW();
            for (int moduleSpaceY = 0; moduleSpaceY < m.type.getH(); ++moduleSpaceY) {
                if (!m.type.isFrontOnly()[moduleSpaceY]) continue;
                int checkY = m.y + moduleSpaceY;
                if (placeX < checkX || placeY > checkY || placeY + type.getH() <= checkY || best != null && m.x <= best.x && (m.x != best.x || m.y >= best.y)) continue;
                best = m;
            }
        }
        return best;
    }

    public Module moduleThatObstructsBack(ModuleType type, int placeX, int placeY, Collection<Module> ignore) {
        Module best = null;
        int checkX = placeX;
        for (int moduleSpaceY = 0; moduleSpaceY < type.getH(); ++moduleSpaceY) {
            if (!type.isBackOnly()[moduleSpaceY]) continue;
            int checkY = placeY + moduleSpaceY;
            for (Module m : this.modules) {
                if (ignore.contains(m) || m.x >= checkX || m.y > checkY || m.y + m.type.getH() <= checkY || best != null && m.x <= best.x && (m.x != best.x || m.y >= best.y)) continue;
                best = m;
            }
        }
        return best;
    }

    public Module moduleWhoseBackIsObstructed(ModuleType type, int placeX, int placeY, Collection<Module> ignore) {
        Module best = null;
        for (Module m : this.modules) {
            if (ignore.contains(m)) continue;
            int checkX = m.x;
            for (int moduleSpaceY = 0; moduleSpaceY < m.type.getH(); ++moduleSpaceY) {
                if (!m.type.isBackOnly()[moduleSpaceY]) continue;
                int checkY = m.y + moduleSpaceY;
                if (placeX >= checkX || placeY > checkY || placeY + type.getH() <= checkY || best != null && m.x >= best.x && (m.x != best.x || m.y >= best.y)) continue;
                best = m;
            }
        }
        return best;
    }

    public Module moduleThatObstructsBottom(ModuleType type, int placeX, int placeY, Collection<Module> ignore) {
        Module best = null;
        int checkY = placeY + type.getH();
        for (int moduleSpaceX = 0; moduleSpaceX < type.getW(); ++moduleSpaceX) {
            if (!type.isBottomOnly()[moduleSpaceX]) continue;
            int checkX = placeX + moduleSpaceX;
            for (Module m : this.modules) {
                if (ignore.contains(m) || m.y < checkY || m.x > checkX || m.x + m.type.getW() <= checkX || best != null && m.y >= best.y && (m.y != best.y || m.x >= best.x)) continue;
                best = m;
            }
        }
        return best;
    }

    public Module moduleWhoseBottomIsObstructed(ModuleType type, int placeX, int placeY, Collection<Module> ignore) {
        Module best = null;
        for (Module m : this.modules) {
            if (ignore.contains(m)) continue;
            int checkY = m.y + m.type.getH();
            for (int moduleSpaceX = 0; moduleSpaceX < m.type.getW(); ++moduleSpaceX) {
                if (!m.type.isBottomOnly()[moduleSpaceX]) continue;
                int checkX = m.x + moduleSpaceX;
                if (placeY < checkY || placeX > checkX || placeX + type.getW() <= checkX || best != null && m.y <= best.y && (m.y != best.y || m.x >= best.x)) continue;
                best = m;
            }
        }
        return best;
    }

    public Module moduleThatObstructsTop(ModuleType type, int placeX, int placeY, Collection<Module> ignore) {
        Module best = null;
        int checkY = placeY;
        for (int moduleSpaceX = 0; moduleSpaceX < type.getW(); ++moduleSpaceX) {
            if (!type.isTopOnly()[moduleSpaceX]) continue;
            int checkX = placeX + moduleSpaceX;
            for (Module m : this.modules) {
                if (ignore.contains(m) || m.y >= checkY || m.x > checkX || m.x + m.type.getW() <= checkX || best != null && m.y <= best.y && (m.y != best.y || m.x >= best.x)) continue;
                best = m;
            }
        }
        return best;
    }

    public Module moduleWhoseTopIsObstructed(ModuleType type, int placeX, int placeY, Collection<Module> ignore) {
        Module best = null;
        for (Module m : this.modules) {
            if (ignore.contains(m)) continue;
            int checkY = m.y;
            for (int moduleSpaceX = 0; moduleSpaceX < m.type.getW(); ++moduleSpaceX) {
                if (!m.type.isTopOnly()[moduleSpaceX]) continue;
                int checkX = m.x + moduleSpaceX;
                if (placeY >= checkY || placeX > checkX || placeX + type.getW() <= checkX || best != null && m.y >= best.y && (m.y != best.y || m.x >= best.x)) continue;
                best = m;
            }
        }
        return best;
    }

    public boolean noModuleOverlapsOrObstructions(ModuleType type, int x, int y, boolean checkObstructions) {
        return this.noModuleOverlapsOrObstructions(type, x, y, checkObstructions, Collections.EMPTY_LIST);
    }

    public boolean noModuleOverlapsOrObstructions(ModuleType type, int x, int y, boolean checkObstructions, Collection<Module> ignore) {
        if (this.modules.isEmpty()) {
            return true;
        }
        for (Module m : this.modules) {
            if (ignore.contains(m)) continue;
            int aLeftEdge = x;
            int aRightEdge = x + type.getW();
            int aTopEdge = y;
            int aBottomEdge = y + type.getH();
            int bLeftEdge = m.x;
            int bRightEdge = m.x + m.type.getW();
            int bTopEdge = m.y;
            int bBottomEdge = m.y + m.type.getH();
            if (aRightEdge <= bLeftEdge || aLeftEdge >= bRightEdge || aBottomEdge <= bTopEdge || aTopEdge >= bBottomEdge) continue;
            return false;
        }
        if (checkObstructions) {
            return this.moduleThatObstructsFront(type, x, y, ignore) == null && this.moduleWhoseFrontIsObstructed(type, x, y, ignore) == null && this.moduleThatObstructsBack(type, x, y, ignore) == null && this.moduleWhoseBackIsObstructed(type, x, y, ignore) == null && this.moduleThatObstructsBottom(type, x, y, ignore) == null && this.moduleWhoseBottomIsObstructed(type, x, y, ignore) == null && this.moduleThatObstructsTop(type, x, y, ignore) == null && this.moduleWhoseTopIsObstructed(type, x, y, ignore) == null;
        }
        return true;
    }

    public boolean canAddModule(ModuleType type, int x, int y) {
        if (this.modules.isEmpty()) {
            return true;
        }
        if (!this.noModuleOverlapsOrObstructions(type, x, y, true)) {
            return false;
        }
        boolean borders = false;
        boolean passableTile = false;
        block0: for (Module m : this.modules) {
            if (m.x + m.type.getW() > x && m.x < x + type.getW() && (m.y + m.type.getH() == y || m.y == y + type.getH())) {
                borders = true;
            }
            if (m.y + m.type.getH() > y && m.y < y + type.getH() && (m.x + m.type.getW() == x || m.x == x + type.getW())) {
                borders = true;
            }
            if (type.isOccupable() && this.isOccupable()) {
                for (int ady = 0; ady < type.getH(); ++ady) {
                    for (int adx = 0; adx < type.getW(); ++adx) {
                        if (!type.canOccupy(adx, ady)) continue;
                        for (int bdy = 0; bdy < m.type.getH(); ++bdy) {
                            for (int bdx = 0; bdx < m.type.getW(); ++bdx) {
                                if (!m.type.canOccupy(bdx, bdy)) continue;
                                for (int[] adj : ADJ) {
                                    if (x + adx + adj[0] != m.x + bdx || y + ady + adj[1] != m.y + bdy) continue;
                                    passableTile = true;
                                    continue block0;
                                }
                            }
                        }
                    }
                }
                continue;
            }
            passableTile = true;
        }
        if (passableTile && type.isOccupable() && this.isOccupable()) {
            Tile toTheLeft;
            passableTile = false;
            boolean[] leftDoors = type.getLeftDoors();
            for (int i = 0; !(i >= leftDoors.length || leftDoors[i] && (toTheLeft = this.tileAt(x - 1, y + i)) != null && (passableTile = toTheLeft.module.type.getRightDoors()[i - toTheLeft.module.y + y])); ++i) {
            }
            if (!passableTile) {
                Tile toTheRight;
                boolean[] rightDoors = type.getRightDoors();
                for (int i = 0; !(i >= rightDoors.length || rightDoors[i] && (toTheRight = this.tileAt(x + type.getW(), y + i)) != null && (passableTile = toTheRight.module.type.getLeftDoors()[i - toTheRight.module.y + y])); ++i) {
                }
            }
            if (!passableTile) {
                boolean[] upDoors = type.getUpDoors();
                for (int i = 0; i < upDoors.length; ++i) {
                    if (!upDoors[i]) continue;
                    Tile up = this.tileAt(x + i, y - 1);
                    boolean bl = passableTile = up != null;
                    if (passableTile) break;
                }
            }
            if (!passableTile) {
                Tile down;
                for (int i = 0; !(i >= type.getW() || (down = this.tileAt(x + i, y + type.getH())) != null && (passableTile = down.module.type.getUpDoors()[i - down.module.x + x])); ++i) {
                }
            }
        }
        return borders && passableTile;
    }

    public Module addModule(ModuleType type, int x, int y, ArmourType at) {
        if (type.isExternal()) {
            at = ArmourType.ofName("NONE");
        }
        if (type.getArmourType() != null) {
            at = type.getArmourType();
        }
        Module m = new Module(this, type, x, y);
        this.modules.add(m);
        m.hp = 1;
        for (int dy = 0; dy < type.getH(); ++dy) {
            for (int dx = 0; dx < type.getW(); ++dx) {
                Tile t = new Tile(this, m, x + dx, y + dy);
                if (t.isMaskedEmpty()) {
                    t.armour.setType(ArmourType.ofName("NONE"));
                } else {
                    t.armour.setType(at);
                }
                this.tiles.add(t);
            }
        }
        this.layout();
        this.resetCrew();
        this.paths.clear();
        this.tilePaths.clear();
        this.repair();
        return m;
    }

    public Module quickAddModule(ModuleType type, int x, int y) {
        ArmourType at = ArmourType.ofName("NONE");
        Module m = new Module(this, type, x, y);
        this.modules.add(m);
        m.hp = 1;
        for (int dy = 0; dy < type.getH(); ++dy) {
            for (int dx = 0; dx < type.getW(); ++dx) {
                Tile t = new Tile(this, m, x + dx, y + dy);
                t.armour.setType(at);
                this.tiles.add(t);
            }
        }
        this.layout();
        return m;
    }

    public boolean isOccupable() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!m.type.isOccupable()) continue;
            return true;
        }
        return false;
    }

    public void resetWeaponBarrels() {
        for (Module m : this.modules) {
            m.resetWeaponBarrels();
        }
    }

    public void repair() {
        this.paths.clear();
        this.tilePaths.clear();
        this.recalcHPs();
        for (Tile t : this.tiles) {
            t.armour.repair();
        }
        for (Module m : this.modules) {
            m.repairFully();
        }
        for (Decal d : this.decals) {
            d.enabled = true;
        }
        this.fireAt = null;
        this.board = null;
        this.assignJobsMs = 300;
        this.moveTo = new Pt(0.0, 0.0);
        this.flipTo = this.flipped;
        this.moveMode = MoveMode.DEFAULT;
        this.sitting = false;
        this.focusOnFirefighting = false;
        this.focusOnRepair = false;
        this.focusOnShooting = true;
        this.msSinceOnGround = 10000;
        this.hasBraked = 0;
        this.braking = 0;
        this.setxSpeed(0.0);
        this.setySpeed(0.0);
        this.setxForce(0.0);
        this.setyForce(0.0);
        this.flipMs = 0;
        this.unableToFlipMs = 0;
        this.captured = false;
        this.resetCrew();
        this.assignJobs();
        this.commandPoints = this.commandPointsRequired();
        this.chunkSubIDCounter = 1;
        this.stuckParticles.clear();
        this.grounding = false;
        this.msSinceLastXMove = 0;
        this.timeMovingInSameXDirection = 0;
        this.movingLeft = false;
        this.lastGrounded = null;
        this.enginesRunning = false;
        this.suspendiumRunning = false;
        this.fallingTime = 0;
        this.explosionAmount = 0.0;
        this.moduleLossAmount = 0.0;
        this.biggestInFleet = false;
        this.outOfCombatMs = 0;
        this.popOutCooldown = 0;
        this.calcOriginalAdjacency();
        this.updateWeight();
        this.originalAmmoCapacity = this.getAmmoCapacity();
        this.originalCoalCapacity = this.getCoalCapacity();
        this.originalWaterCapacity = this.getWaterCapacity();
        this.originalRepairCapacity = this.getRepairCapacity();
        this.originalAllQuartered = this.getAllQuartered();
        this.fixers.clear();
        for (ModuleType mt : Loadable.all(ModuleType.class)) {
            if (!ShipEditorUtils.isModuleAFixer(this, mt, this.constructionBonuses)) continue;
            this.fixers.add(mt);
        }
    }

    public boolean canRemoveModuleAt(int x, int y) {
        if (this.modules.size() == 1) {
            return true;
        }
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.x > x || m.y > y || m.x + m.type.getW() <= x || m.y + m.type.getH() <= y) continue;
            return this.isAtEdge(m) && this.canRemoveCleanly(m);
        }
        return true;
    }

    private boolean isAtEdge(Module m) {
        for (int tx = m.x; tx < m.x + m.type.getW(); ++tx) {
            if (this.tileAt(tx, m.y - 1) != null && this.tileAt(tx, m.y + m.type.getH()) != null) continue;
            return true;
        }
        for (int ty = m.y; ty < m.y + m.type.getH(); ++ty) {
            if (this.tileAt(m.x - 1, ty) != null && this.tileAt(m.x + m.type.getW(), ty) != null) continue;
            return true;
        }
        return false;
    }

    private boolean canRemoveCleanly(Module m) {
        return this.pathChunks(m).size() == 1;
    }

    public Module removeModuleAt(int x, int y) {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.x > x || m.y > y || m.x + m.type.getW() <= x || m.y + m.type.getH() <= y) continue;
            this.removeModule(m);
            this.repair();
            this.layout();
            return m;
        }
        return null;
    }

    public ModuleType moduleTypeAt(int x, int y) {
        Module m = this.moduleAt(x, y);
        return m == null ? null : m.type;
    }

    public Module moduleAt(int x, int y) {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.x > x || m.y > y || m.x + m.type.getW() <= x || m.y + m.type.getH() <= y) continue;
            return m;
        }
        return null;
    }

    public Decal decalAt(int x, int y) {
        int dsz = this.decals.size();
        for (int mi = 0; mi < dsz; ++mi) {
            Decal d = this.decals.get(mi);
            if (d.x > x || d.y > y || d.x + d.type.w <= x || d.y + d.type.h <= y) continue;
            return d;
        }
        return null;
    }

    public void clear() {
        this.modules.clear();
        this.tiles.clear();
        this.crew.clear();
        this.boarders.clear();
        this.decals.clear();
        this.layout();
        this.resetCrew();
        this.paths.clear();
        this.tilePaths.clear();
        this.assignJobs();
        this.recalcHPs();
    }

    public void quickRemoveModule(Module m) {
        this.modules.remove(m);
        Iterator<Tile> it = this.tiles.iterator();
        while (it.hasNext()) {
            if (it.next().module != m) continue;
            it.remove();
        }
        this.layout();
    }

    public void removeModule(Module m) {
        this.modules.remove(m);
        Iterator<Tile> it = this.tiles.iterator();
        while (it.hasNext()) {
            if (it.next().module != m) continue;
            it.remove();
        }
        this.layout();
        this.resetCrew();
        this.paths.clear();
        this.tilePaths.clear();
        this.assignJobs();
        this.recalcHPs();
    }

    private void recalcHPs() {
        int bonusHPPerTile = this.getBonusHPPerTile();
        double structuralStressHPMultiplier = this.getStructuralStressHPMultiplier();
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            m.calcMaxHP(bonusHPPerTile, structuralStressHPMultiplier);
        }
    }

    public void layout() {
        double oldX = this.getX();
        double oldY = this.getY();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            minX = StrictMath.min(minX, m.x);
            minY = StrictMath.min(minY, m.y);
            maxX = StrictMath.max(maxX, m.x + m.type.getW());
            maxY = StrictMath.max(maxY, m.y + m.type.getH());
        }
        int xShift = -minX;
        int yShift = -minY;
        int flippedXShift = this.w - maxX;
        this.w = maxX - minX;
        this.h = maxY - minY;
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            m.x += xShift;
            m.y += yShift;
        }
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            t.x += xShift;
            t.y += yShift;
        }
        int dsz = this.decals.size();
        for (int di = 0; di < dsz; ++di) {
            Decal d = this.decals.get(di);
            d.x += xShift;
            d.y += yShift;
        }
        if (this.flipped) {
            this.setX(this.getX() + (double)(flippedXShift * 16));
        } else {
            this.setX(this.getX() - (double)(xShift * 16));
        }
        this.setY(this.getY() - (double)(yShift * 16));
        for (Particle p : this.stuckParticles) {
            p.x = p.x + oldX - this.getX();
            p.y = p.y + oldY - this.getY();
        }
        this.regenerateTileGrid();
        this.calcAdjacency();
        this.clearInvalidDecals();
        this.removeUnstuckParticles();
        this.updateWeight();
    }

    private void checkAndRepairTilesAndCrew() {
        ArrayList<Tile> tiles2 = new ArrayList<Tile>(this.tiles);
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            for (int my = 0; my < m.type.getH(); ++my) {
                for (int mx = 0; mx < m.type.getW(); ++mx) {
                    Tile t;
                    int ty = m.y + my;
                    int tx = m.x + mx;
                    int tsz = tiles2.size();
                    boolean found = false;
                    for (int ti = 0; ti < tsz; ++ti) {
                        t = tiles2.get(ti);
                        if (t.x != tx || t.y != ty) continue;
                        if (t.module != m) {
                            System.err.println(this.getName() + ": tile has wrong module");
                            t.module = m;
                        }
                        tiles2.remove(ti);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    System.err.println(this.getName() + ": missing tile for module");
                    ArmourType at = EditPalettePanel.guessArmourType(this);
                    if (m.type.isExternal()) {
                        at = ArmourType.ofName("NONE");
                    }
                    if (m.type.getArmourType() != null) {
                        at = m.type.getArmourType();
                    }
                    t = new Tile(this, m, tx, ty);
                    t.armour.setType(at);
                    this.tiles.add(t);
                }
            }
        }
        if (!tiles2.isEmpty()) {
            System.err.println(this.getName() + ": found " + tiles2.size() + " orphaned tiles.");
            int numExpectedTiles = 0;
            for (Module m : this.modules) {
                numExpectedTiles += m.type.getW() * m.type.getH();
            }
            System.err.println(this.getName() + ": num expected tiles " + numExpectedTiles + " num tiles " + this.tiles.size());
            for (Tile t : tiles2) {
                System.err.println(t.x + " " + t.y + " " + t.module.type.name);
            }
            this.tiles.removeAll(tiles2);
        }
        block6: for (int i = 0; i < 2; ++i) {
            ArrayList<Crewman> cs = i == 0 ? this.crew : this.boarders;
            int csz = cs.size();
            for (int ci = 0; ci < csz; ++ci) {
                Tile t;
                int ti;
                Crewman c = cs.get(ci);
                if (this.tiles.contains(c.currentTile)) continue;
                System.err.println(this.getName() + ": orphaned crewman on " + c.currentTile.x + " " + c.currentTile.y + " " + c.currentTile.module.type.name);
                int tsz = tiles2.size();
                boolean found = false;
                for (ti = 0; ti < tsz; ++ti) {
                    t = this.tiles.get(ti);
                    if (t.x != c.currentTile.x || t.y != c.currentTile.y) continue;
                    System.err.println(this.getName() + ": relocated to correct tile");
                    c.currentTile = t;
                    if (c.injuredCarried != null) {
                        c.injuredCarried.currentTile = t;
                    }
                    found = true;
                    c.abandonJob("orphaned");
                    break;
                }
                if (!found) {
                    for (ti = 0; ti < tsz; ++ti) {
                        t = this.tiles.get(ti);
                        if (!t.canOccupy) continue;
                        System.err.println(this.getName() + ": relocated to safe tile " + t.x + " " + t.y + " " + t.module.type.name);
                        c.currentTile = t;
                        if (c.injuredCarried != null) {
                            c.injuredCarried.currentTile = t;
                        }
                        found = true;
                        c.abandonJob("orphaned");
                        break;
                    }
                }
                if (found) continue;
                System.err.println(this.getName() + ": all crew deleted due to no safe tiles");
                cs.clear();
                continue block6;
            }
        }
    }

    private void regenerateTileGrid() {
        if (this.tileGrid == null || this.tileGrid.length != this.h || this.tileGrid[0].length != this.w) {
            this.tileGrid = new Tile[this.h][this.w];
        } else {
            for (int y = 0; y < this.tileGrid.length; ++y) {
                Arrays.fill(this.tileGrid[y], null);
            }
        }
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t;
            this.tileGrid[t.y][t.x] = t = this.tiles.get(ti);
        }
    }

    private void calcAdjacency() {
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t1 = this.tiles.get(ti);
            for (int dy = -1; dy < 2; ++dy) {
                for (int dx = -1; dx < 2; ++dx) {
                    t1.adjacent[dy + 1][dx + 1] = this.tileAt(t1.x + dx, t1.y + dy) != null;
                }
            }
        }
        this.calcConcavePoints();
    }

    private void calcOriginalAdjacency() {
        if (!this.isPathingFullyConnected()) {
            return;
        }
        boolean hasDoor = false;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            if (!this.modules.get((int)mi).type.isHatch(this.currentBonuses)) continue;
            hasDoor = true;
            break;
        }
        if (!hasDoor) {
            return;
        }
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t1 = this.tiles.get(ti);
            for (int dy = -1; dy < 2; ++dy) {
                for (int dx = -1; dx < 2; ++dx) {
                    boolean adj = false;
                    for (int ti2 = 0; ti2 < tsz; ++ti2) {
                        Tile t2 = this.tiles.get(ti2);
                        if (!t2.canOccupy || t2.x != t1.x + dx || t2.y != t1.y + dy) continue;
                        adj = true;
                        break;
                    }
                    t1.hadAdjacentOccupableTile[dy + 1][dx + 1] = adj;
                }
            }
        }
    }

    private void resetCrew() {
        boolean allFull;
        this.canDoPathingIndex = 0;
        this.boarderCanDoPathingIndex = 0;
        this.crew.clear();
        this.boarders.clear();
        HashMap<CrewType, Integer> crewRemaining = new HashMap<CrewType, Integer>();
        for (CrewType ct : Loadable.all(CrewType.class)) {
            crewRemaining.put(ct, this.getQuartered(ct));
        }
        for (Module m : this.modules) {
            m.numCrewTmp = 0;
            m.numGuardsTmp = 0;
        }
        block2: for (CrewType ct : CrewType.allWorkersByAbility) {
            while ((Integer)crewRemaining.get(ct) > 0) {
                allFull = true;
                for (Module m : this.modules) {
                    if (m.type.getCrew(this.currentBonuses) <= m.numCrewTmp) continue;
                    ++m.numCrewTmp;
                    allFull = false;
                    this.crew.add(new Crewman(this, this.getMostEmptyTile(m), ct));
                    crewRemaining.put(ct, (Integer)crewRemaining.get(ct) - 1);
                    if ((Integer)crewRemaining.get(ct) != 0) continue;
                    continue block2;
                }
                if (!allFull) continue;
                break block2;
            }
        }
        block5: for (CrewType ct : CrewType.allGuardsByAbility) {
            while ((Integer)crewRemaining.get(ct) > 0) {
                allFull = true;
                for (Module m : this.modules) {
                    if (m.type.getRecommendedGuards(this.currentBonuses) <= m.numGuardsTmp) continue;
                    ++m.numGuardsTmp;
                    allFull = false;
                    this.crew.add(new Crewman(this, this.getMostEmptyTile(m), ct));
                    crewRemaining.put(ct, (Integer)crewRemaining.get(ct) - 1);
                    if ((Integer)crewRemaining.get(ct) != 0) continue;
                    continue block5;
                }
                if (!allFull) continue;
                break block5;
            }
        }
        block8: for (CrewType ct : CrewType.nonWorkerGuards) {
            while ((Integer)crewRemaining.get(ct) > 0) {
                allFull = true;
                for (Module m : this.modules) {
                    if (m.type.getQuartersType(this.currentBonuses) != ct) continue;
                    ++m.numCrewTmp;
                    allFull = false;
                    this.crew.add(new Crewman(this, this.getMostEmptyTile(m), ct));
                    crewRemaining.put(ct, (Integer)crewRemaining.get(ct) - 1);
                    if ((Integer)crewRemaining.get(ct) != 0) continue;
                    continue block8;
                }
                if (!allFull) continue;
                break block8;
            }
        }
        block11: for (CrewType ct : CrewType.allWorkersByAbility) {
            while ((Integer)crewRemaining.get(ct) > 0) {
                allFull = true;
                for (Module m : this.modules) {
                    if (m.type.getCrew(this.currentBonuses) + m.type.getOptionalCrew(this.currentBonuses) <= m.numCrewTmp) continue;
                    ++m.numCrewTmp;
                    allFull = false;
                    this.crew.add(new Crewman(this, this.getMostEmptyTile(m), ct));
                    crewRemaining.put(ct, (Integer)crewRemaining.get(ct) - 1);
                    if ((Integer)crewRemaining.get(ct) != 0) continue;
                    continue block11;
                }
                if (!allFull) continue;
                break block11;
            }
        }
        block14: for (CrewType ct : Loadable.all(CrewType.class)) {
            while ((Integer)crewRemaining.get(ct) > 0) {
                for (Module m : this.modules) {
                    if (m.type.getQuartersType(this.currentBonuses) != ct) continue;
                    ++m.numCrewTmp;
                    this.crew.add(new Crewman(this, this.getFixedQuartersTile(m, (Integer)crewRemaining.get(ct)), ct));
                    crewRemaining.put(ct, (Integer)crewRemaining.get(ct) - 1);
                    if ((Integer)crewRemaining.get(ct) != 0) continue;
                    continue block14;
                }
            }
        }
    }

    public boolean hasPath(Tile src, Tile target) {
        return this.tilePaths.containsKey(src) && this.tilePaths.get(src).containsKey(target);
    }

    public ArrayList<Tile> getPath(Tile src, Tile target) {
        if (!this.tilePaths.containsKey(src) || !this.tilePaths.get(src).containsKey(target)) {
            this.calcTilePathsForTarget(target);
        }
        return this.tilePaths.containsKey(src) ? this.tilePaths.get(src).get(target) : null;
    }

    public boolean hasPath(Tile src, Module target) {
        return this.paths.containsKey(src) && this.paths.get(src).containsKey(target);
    }

    public ArrayList<Tile> getPath(Tile src, Module target) {
        if (!this.paths.containsKey(src) || !this.paths.get(src).containsKey(target)) {
            this.calcPathsForTarget(target);
        }
        return this.paths.containsKey(src) ? this.paths.get(src).get(target) : null;
    }

    private void calcTilePathsForTarget(Tile target) {
        if (!target.canOccupy) {
            return;
        }
        LinkedList<Tile> tileQ = new LinkedList<Tile>();
        HashSet<Tile> tileQSet = new HashSet<Tile>();
        for (Tile t : this.tiles) {
            t.pathCostTmp = 0x1FFFFFFF;
        }
        target.pathCostTmp = 0;
        tileQ.add(target);
        tileQSet.add(target);
        while (!tileQ.isEmpty()) {
            Tile t = (Tile)tileQ.pollFirst();
            tileQSet.remove(t);
            for (int[] adj : ADJ) {
                Tile t2;
                if (adj[0] == -1 && adj[1] == 0 && t.x == t.module.x) {
                    if (!t.module.type.getLeftDoors()[t.y - t.module.y]) {
                        continue;
                    }
                } else if (adj[0] != 1 || adj[1] != 0 || t.x != t.module.x + t.module.type.getW() - 1 ? adj[0] == 0 && adj[1] == -1 && t.y == t.module.y && !t.module.type.getUpDoors()[t.x - t.module.x] : !t.module.type.getRightDoors()[t.y - t.module.y]) continue;
                if ((t2 = this.tileAt(t.x + adj[0], t.y + adj[1])) == null || !t2.canOccupy || t2.pathCostTmp <= t.pathCostTmp + t2.getMoveDelay() || t2.module != t.module && (adj[0] == -1 && adj[1] == 0 ? !t2.module.type.getRightDoors()[t2.y - t2.module.y] : (adj[0] == 1 && adj[1] == 0 ? !t2.module.type.getLeftDoors()[t2.y - t2.module.y] : adj[0] == 0 && adj[1] == 1 && !t2.module.type.getUpDoors()[t2.x - t2.module.x]))) continue;
                t2.pathCostTmp = t.pathCostTmp + t2.getMoveDelay();
                if (tileQSet.contains(t2)) continue;
                tileQ.add(t2);
                tileQSet.add(t2);
            }
        }
        for (Tile source : this.tiles) {
            if (!source.canOccupy) continue;
            ArrayList<Tile> path = new ArrayList<Tile>();
            Tile t = source;
            while (t.pathCostTmp > 0) {
                Tile best = null;
                int lowest = t.pathCostTmp;
                for (int[] adj : ADJ) {
                    Tile t2;
                    if (adj[0] == -1 && adj[1] == 0 && t.x == t.module.x) {
                        if (!t.module.type.getLeftDoors()[t.y - t.module.y]) {
                            continue;
                        }
                    } else if (adj[0] != 1 || adj[1] != 0 || t.x != t.module.x + t.module.type.getW() - 1 ? adj[0] == 0 && adj[1] == -1 && t.y == t.module.y && !t.module.type.getUpDoors()[t.x - t.module.x] : !t.module.type.getRightDoors()[t.y - t.module.y]) continue;
                    if ((t2 = this.tileAt(t.x + adj[0], t.y + adj[1])) == null || !t2.canOccupy || t2.pathCostTmp >= lowest || t2.module != source.module && (adj[0] == -1 && adj[1] == 0 ? !t2.module.type.getRightDoors()[t2.y - t2.module.y] : (adj[0] == 1 && adj[1] == 0 ? !t2.module.type.getLeftDoors()[t2.y - t2.module.y] : adj[0] == 0 && adj[1] == 1 && !t2.module.type.getUpDoors()[t2.x - t2.module.x]))) continue;
                    best = t2;
                    lowest = t2.pathCostTmp;
                }
                if (best == null) {
                    path = null;
                    break;
                }
                t = best;
                path.add(best);
            }
            if (!this.tilePaths.containsKey(source)) {
                this.tilePaths.put(source, new HashMap());
            }
            this.tilePaths.get(source).put(target, path);
        }
    }

    private void calcPathsForTarget(Module target) {
        LinkedList<Tile> tileQ = new LinkedList<Tile>();
        HashSet<Tile> tileQSet = new HashSet<Tile>();
        for (Tile t : this.tiles) {
            if (t.module == target && t.canOccupy) {
                t.pathCostTmp = 0;
                tileQ.add(t);
                tileQSet.add(t);
                continue;
            }
            t.pathCostTmp = 0x1FFFFFFF;
        }
        while (!tileQ.isEmpty()) {
            Tile t = (Tile)tileQ.pollFirst();
            tileQSet.remove(t);
            for (int[] adj : ADJ) {
                Tile t2;
                if (adj[0] == -1 && adj[1] == 0 && t.x == t.module.x) {
                    if (!t.module.type.getLeftDoors()[t.y - t.module.y]) {
                        continue;
                    }
                } else if (adj[0] != 1 || adj[1] != 0 || t.x != t.module.x + t.module.type.getW() - 1 ? adj[0] == 0 && adj[1] == -1 && t.y == t.module.y && !t.module.type.getUpDoors()[t.x - t.module.x] : !t.module.type.getRightDoors()[t.y - t.module.y]) continue;
                if ((t2 = this.tileAt(t.x + adj[0], t.y + adj[1])) == null || !t2.canOccupy || t2.pathCostTmp <= t.pathCostTmp + t2.getMoveDelay() || t2.module != t.module && (adj[0] == -1 && adj[1] == 0 ? !t2.module.type.getRightDoors()[t2.y - t2.module.y] : (adj[0] == 1 && adj[1] == 0 ? !t2.module.type.getLeftDoors()[t2.y - t2.module.y] : adj[0] == 0 && adj[1] == 1 && !t2.module.type.getUpDoors()[t2.x - t2.module.x]))) continue;
                t2.pathCostTmp = t.pathCostTmp + t2.getMoveDelay();
                if (tileQSet.contains(t2)) continue;
                tileQ.add(t2);
                tileQSet.add(t2);
            }
        }
        for (Tile source : this.tiles) {
            if (!source.canOccupy) continue;
            ArrayList<Tile> path = new ArrayList<Tile>();
            Tile t = source;
            while (t.pathCostTmp > 0) {
                Tile best = null;
                int lowest = t.pathCostTmp;
                for (int[] adj : ADJ) {
                    Tile t2;
                    if (adj[0] == -1 && adj[1] == 0 && t.x == t.module.x) {
                        if (!t.module.type.getLeftDoors()[t.y - t.module.y]) {
                            continue;
                        }
                    } else if (adj[0] != 1 || adj[1] != 0 || t.x != t.module.x + t.module.type.getW() - 1 ? adj[0] == 0 && adj[1] == -1 && t.y == t.module.y && !t.module.type.getUpDoors()[t.x - t.module.x] : !t.module.type.getRightDoors()[t.y - t.module.y]) continue;
                    if ((t2 = this.tileAt(t.x + adj[0], t.y + adj[1])) == null || !t2.canOccupy || t2.pathCostTmp >= lowest || t2.module != t.module && (adj[0] == -1 && adj[1] == 0 ? !t2.module.type.getRightDoors()[t2.y - t2.module.y] : (adj[0] == 1 && adj[1] == 0 ? !t2.module.type.getLeftDoors()[t2.y - t2.module.y] : adj[0] == 0 && adj[1] == 1 && !t2.module.type.getUpDoors()[t2.x - t2.module.x]))) continue;
                    best = t2;
                    lowest = t2.pathCostTmp;
                }
                if (best == null) {
                    path = null;
                    break;
                }
                t = best;
                path.add(best);
            }
            if (!this.paths.containsKey(source)) {
                this.paths.put(source, new HashMap());
            }
            this.paths.get(source).put(target, path);
        }
    }

    public boolean shouldSwitchSides() {
        int msz = this.modules.size();
        int bsz = this.boarders.size();
        int csz = this.crew.size();
        if (bsz == 0) {
            return false;
        }
        boolean hasCrewInCommandCenter = false;
        boolean hasBoarderInCommandCenter = false;
        block0: for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.hp <= 0 || m.type.getCommand(this.currentBonuses) <= 0) continue;
            if (!hasCrewInCommandCenter) {
                for (int ci = 0; ci < csz; ++ci) {
                    Crewman c = this.crew.get(ci);
                    if (c.currentTile.module != m || !c.type.doesWork || !c.active()) continue;
                    hasCrewInCommandCenter = true;
                    break;
                }
            }
            if (hasBoarderInCommandCenter) continue;
            for (int bi = 0; bi < bsz; ++bi) {
                Crewman b = this.boarders.get(bi);
                if (b.currentTile.module != m || !b.type.doesWork || !b.active()) continue;
                hasBoarderInCommandCenter = true;
                continue block0;
            }
        }
        if (hasBoarderInCommandCenter && !hasCrewInCommandCenter) {
            return true;
        }
        if (hasCrewInCommandCenter) {
            return false;
        }
        for (int i = 0; i < csz; ++i) {
            if (!this.crew.get((int)i).type.doesGuard && !this.crew.get((int)i).type.canBoard || !this.crew.get(i).active()) continue;
            return false;
        }
        for (int bi = 0; bi < bsz; ++bi) {
            Crewman b = this.boarders.get(bi);
            if (!b.type.doesWork || !b.active()) continue;
            return true;
        }
        return false;
    }

    public void switchSides() {
        ArrayList<Crewman> oldBoarders = new ArrayList<Crewman>();
        int csz = this.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman c = this.crew.get(ci);
            c.abandonJob("switching sides");
            if (c.type.canBoard || c.type.doesGuard) {
                oldBoarders.add(c);
                c.ship = null;
                c.boardingShip = this;
                continue;
            }
            c.occupied = !c.occupied;
        }
        int bsz = this.boarders.size();
        for (int bi = 0; bi < bsz; ++bi) {
            Crewman b = this.boarders.get(bi);
            b.abandonJob("switching sides (boarder)");
            b.ship = this;
            b.boardingShip = null;
        }
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            this.modules.get((int)mi).prevTargetShip = null;
        }
        this.crew.removeAll(oldBoarders);
        this.crew.addAll(this.boarders);
        this.boarders.clear();
        this.boarders.addAll(oldBoarders);
        this.captured = !this.captured;
        this.assignJobs();
    }

    private void assignJobs() {
        int csz = this.crew.size();
        ArrayList<Job> jobs = new ArrayList<Job>();
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            ArrayList<Job> mjobs = m.jobs();
            int jsz = mjobs.size();
            block1: for (int ji = 0; ji < jsz; ++ji) {
                Job j = mjobs.get(ji);
                if (!j.active()) continue;
                for (int ci = 0; ci < csz; ++ci) {
                    Crewman c = this.crew.get(ci);
                    if (c.job == j) continue block1;
                }
                jobs.add(j);
            }
        }
        Collections.sort(jobs, this);
        int jsz = jobs.size();
        for (int ji = 0; ji < jsz; ++ji) {
            Job job = (Job)jobs.get(ji);
            ArrayList<Module> targetModules = new ArrayList<Module>();
            if (job.resource() == null) {
                targetModules.add(job.module());
            } else {
                for (int mi = 0; mi < msz; ++mi) {
                    Module m = this.modules.get(mi);
                    if (m.getResource(job.resource()) <= 0) continue;
                    targetModules.add(m);
                }
            }
            ArrayList<Crewman> targetCrew = new ArrayList<Crewman>();
            if (job.resource() == Resource.INJURED || job.resource() == Resource.DEAD) {
                for (int ci = 0; ci < csz; ++ci) {
                    Crewman c = this.crew.get(ci);
                    if (!c.needsRescue(job.resource() == Resource.DEAD)) continue;
                    targetCrew.add(c);
                }
            }
            if (targetModules.isEmpty() && targetCrew.isEmpty()) continue;
            Crewman best = null;
            Crewman targetCM = null;
            int leastdist = 0;
            for (int attempt = 0; attempt < 2; ++attempt) {
                for (int ci = 0; ci < csz; ++ci) {
                    boolean suitable;
                    Crewman c = this.crew.get(ci);
                    if (!c.active()) continue;
                    int d = Integer.MAX_VALUE;
                    boolean bl = c.ultimateBoardTarget == null && job.requiredType(c.type) && (!c.occupied || !job.requiredUnoccupied()) && (attempt == 0 ? c.job == null : c.job != null && c.job.priority() < job.priority() * 0.7) ? true : (suitable = false);
                    if (!suitable) continue;
                    int tmsz = targetModules.size();
                    for (int tmi = 0; tmi < tmsz; ++tmi) {
                        ArrayList<Tile> modulePath;
                        Module m = (Module)targetModules.get(tmi);
                        ArrayList<Tile> path = this.getPath(c.currentTile, m);
                        if (path == null || (modulePath = this.getPath(path.isEmpty() ? c.currentTile : path.get(path.size() - 1), job.module())) == null) continue;
                        d = StrictMath.min(d, path.size() + modulePath.size());
                    }
                    int tcsz = targetCrew.size();
                    for (int tci = 0; tci < tcsz; ++tci) {
                        int myD;
                        ArrayList<Tile> pathFrom;
                        Crewman tc = (Crewman)targetCrew.get(tci);
                        ArrayList<Tile> pathTo = this.getPath(c.currentTile, tc.currentTile);
                        if (pathTo == null || (pathFrom = this.getPath(tc.currentTile, job.module())) == null || (myD = pathTo.size() + pathFrom.size()) >= d) continue;
                        d = myD;
                        targetCM = tc;
                    }
                    if (d == Integer.MAX_VALUE) continue;
                    int dMult = 2 + (c.job == null ? 0 : (int)c.job.priority());
                    d = (int)(((double)d + 0.5) * 10.0 * (double)dMult * (double)c.type.maxHP / (double)c.hp / c.type.crewEffectiveness);
                    if (best != null && d >= leastdist) continue;
                    best = c;
                    leastdist = d;
                }
            }
            if (best == null) continue;
            best.abandonJob("as - assigning job " + job.getClass().getSimpleName());
            best.job = job;
            best.headingFor = targetCM;
        }
    }

    public Tile getFixedQuartersTile(Module m, int n) {
        ArrayList<Utils.Pair<Integer, Integer>> hps = m.type.getHangarPositions();
        if (hps.isEmpty()) {
            return this.getMostEmptyTile(m);
        }
        Utils.Pair<Integer, Integer> offset = hps.get(n % hps.size());
        Tile t = this.tileAt(m.x + (Integer)offset.a, m.y + (Integer)offset.b);
        if (t != null && t.module == m) {
            return t;
        }
        return this.getMostEmptyTile(m);
    }

    public Tile getMostEmptyTile(Module m) {
        Tile t = null;
        int minOccupancy = 0;
        for (int dy = m.type.getH() - 1; dy >= 0; --dy) {
            for (int dx = 0; dx < m.type.getW(); ++dx) {
                Tile t2 = this.tileAt(m.x + dx, m.y + dy);
                if (t2 == null) {
                    throw new RuntimeException("The shape of the " + m.type.getName() + " module has changed since this ship was created. It is no longer valid.");
                }
                if (!t2.canOccupy) continue;
                int occupancy = 0;
                for (Crewman c : this.crew) {
                    occupancy += c.currentTile == t2 ? 1 : 0;
                }
                if (t != null && occupancy >= minOccupancy) continue;
                t = t2;
                minOccupancy = occupancy;
            }
        }
        if (t == null) {
            throw new RuntimeException("Unable to correctly place crew members.");
        }
        return t;
    }

    public Tile tileAt(int x, int y) {
        if (this.tileGrid == null) {
            for (Tile t : this.tiles) {
                if (t.x != x || t.y != y) continue;
                return t;
            }
            return null;
        }
        if (x < 0 || y < 0 || x >= this.w || y >= this.h) {
            return null;
        }
        return this.tileGrid[y][x];
    }

    public Tile hit(Shot shot, Combat c, boolean onViewingSide) {
        int tileY;
        int tileX = (int)((this.flipped ? (double)(this.getWidth() * 16) - (shot.tX - (double)this.getIntX()) : shot.tX - (double)this.getIntX()) / 16.0);
        Tile t = this.tileAt(tileX, tileY = (int)((shot.tY - (double)this.getIntY()) / 16.0));
        if (t != null && !t.isMaskedEmpty()) {
            t.hit(shot, c, onViewingSide);
            return t;
        }
        return null;
    }

    public void splashHit(Combat c, double centerX, double centerY, int blast, int blastSplashRadius, boolean onViewingSide, Shot optionalSourceShot, boolean inside) {
        int rSq = blastSplashRadius * blastSplashRadius;
        for (double yy = (double)(-blastSplashRadius); yy < (double)blastSplashRadius; yy += 16.0) {
            for (double xx = (double)(-blastSplashRadius); xx < (double)blastSplashRadius; xx += 16.0) {
                double d;
                int actualDamage;
                int tileY;
                int tileX;
                Tile t;
                double dSq = xx * xx + yy * yy;
                if (dSq > (double)rSq || (t = this.tileAt(tileX = (int)((this.flipped ? (double)(this.getWidth() * 16) - (xx + centerX - (double)this.getIntX()) : xx + centerX - (double)this.getIntX()) / 16.0), tileY = (int)((yy + centerY - (double)this.getIntY()) / 16.0))) == null || (actualDamage = (int)((double)blast * ((double)blastSplashRadius - (d = StrictMath.sqrt(dSq))) / (double)blastSplashRadius)) == 0) continue;
                t.splashHit(c, onViewingSide, actualDamage, optionalSourceShot, inside);
            }
        }
    }

    public ArrayList<Module> getModules() {
        return this.modules;
    }

    @Override
    public int compare(Job j1, Job j2) {
        return Double.compare(j2.priority(), j1.priority());
    }

    public ArrayList<Crewman> getCrew() {
        return this.crew;
    }

    public double danger(Combat c) {
        double danger;
        if (!this.inCombat(c)) {
            return 0.0;
        }
        double d = danger = this.canMove() ? (double)this.getWeight() * this.getSpeed() * 0.7 : 0.0;
        if (this.hasActiveFlyers(c)) {
            danger += (double)this.modules.size() * 0.1;
        }
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.hp > 0 && m.type.isWeapon()) {
                danger += (double)((m.type.getPenDmg(this.currentBonuses) + m.type.getBlastDmg(this.currentBonuses) * (m.type.getBlastSplashRadius(this.currentBonuses) > 0 ? 3 : 1) + m.type.getDirectDmg(this.currentBonuses)) * 1000 / m.type.getReload(this.currentBonuses));
            }
            if (m.hp <= 0 || m.type.getQuartersType(this.currentBonuses) == null || !m.type.getQuartersType((BonusSet)this.currentBonuses).canBoard) continue;
            CrewType qt = m.type.getQuartersType(this.currentBonuses);
            danger += (double)(qt.totalDamage() * 1000 * m.type.getQuarters(this.currentBonuses) / qt.weaponReload.get(this.currentBonuses));
        }
        return danger;
    }

    public void commandGiven() {
        this.commandPoints = 0;
        this.wasReadyForCommand = false;
    }

    public boolean readyForCommand() {
        return this.commandPoints >= this.commandPointsRequired() && this.commandPointsGenerated() > 0;
    }

    public int commandPointsRequired() {
        int cps = 700 + this.crew.size() * 50;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            cps += m.type.getW() * m.type.getH() * 5;
        }
        return cps * 16;
    }

    public int commandPointsGenerated() {
        int cp = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.type.getCommand(this.currentBonuses) <= 0 || !m.running()) continue;
            cp = (int)((double)cp + (double)m.type.getCommand(this.currentBonuses) * m.staffProportion());
        }
        int cps = (int)StrictMath.ceil(StrictMath.log((double)cp * 1.5) * 4.0);
        return StrictMath.max(0, cps);
    }

    public boolean canGenerateCommands() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.hp <= 0 || m.type.getCommand(this.currentBonuses) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean canFirefight() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.getResource(Resource.WATER) <= 0 || m.hp <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean canRepair() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.getResource(Resource.REPAIR) <= 0 || m.hp <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean canMove() {
        Module m;
        int mi;
        boolean propel = false;
        int msz = this.modules.size();
        if (!this.type.onGround && this.availableServiceCeiling() <= 0) {
            return false;
        }
        for (mi = 0; mi < msz; ++mi) {
            m = this.modules.get(mi);
            if (!(m.type.getPropulsion(this.currentBonuses) > 0.0) || m.hp <= 0) continue;
            propel = true;
            if (m.type.getCoalReload(this.currentBonuses) != 0) continue;
            return true;
        }
        for (mi = 0; mi < msz; ++mi) {
            m = this.modules.get(mi);
            if (m.getResource(Resource.COAL) <= 0 || m.hp <= 0) continue;
            return propel;
        }
        return false;
    }

    public boolean isArmedCountingDamagedWeapons() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!m.type.isWeapon()) continue;
            return true;
        }
        return false;
    }

    public boolean hasRam() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!m.type.isRam()) continue;
            return true;
        }
        return false;
    }

    public boolean isArmedOrHasTroops() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.type.isWeapon() && m.hp > 0) {
                return true;
            }
            if (m.type.getQuartersType(this.currentBonuses) != null && (m.type.getQuartersType((BonusSet)this.currentBonuses).canBoard || m.type.getQuartersType((BonusSet)this.currentBonuses).canFly)) {
                return true;
            }
            if (m.hp <= 0 || m.tentacles.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean requiresAmmo() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!m.type.isWeapon() || m.hp <= 0 || m.type.getClip(this.currentBonuses) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean canShoot() {
        boolean hasCoal = this.getTotalResource(Resource.COAL) > 0;
        boolean hasAmmo = this.getTotalResource(Resource.AMMO) > 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!m.type.isWeapon() || m.hp <= 0 || m.type.getCoalReload(this.currentBonuses) != 0 && !hasCoal && m.msUntilCoal <= 0 || m.type.getClip(this.currentBonuses) != 0 && !hasAmmo && m.ammoLeft <= 0) continue;
            return true;
        }
        return false;
    }

    public int availableLift() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!m.type.hasLift() || !m.canRun()) continue;
            n += m.type.getLift(this.constructionBonuses);
        }
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            if (t.armour == null || t.armour.hp <= 0) continue;
            n += t.armour.type.getLift(this.constructionBonuses);
        }
        return n;
    }

    public int availableLiftNoFuel() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.type.getCoalReload(this.currentBonuses) != 0 || !m.type.hasLift() || m.hp <= 0) continue;
            n += m.type.getLift(this.constructionBonuses);
        }
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            if (t.armour == null || t.armour.hp <= 0) continue;
            n += t.armour.type.getLift(this.constructionBonuses);
        }
        return n;
    }

    public double availableSuspendiumForce() {
        double distanceFromFloor = StrictMath.pow(StrictMath.max(1.0, 512.0 - this.getY()), 1.5) / 30.0;
        return (double)(this.availableLift() * 400 * 2) / (400.0 + distanceFromFloor) * 0.001;
    }

    public double engineForceForX(double tx) {
        int startSlowingDown;
        int n = startSlowingDown = this.type.onGround ? 10 : (int)StrictMath.min(1200.0, 10.0 + 210.0 / this.getSpeed() * (StrictMath.abs(this.getxSpeed()) + 0.01) / this.getSpeed());
        if (this.type.onGround && StrictMath.abs(tx - this.getX()) < 12.0) {
            return 0.0;
        }
        if (StrictMath.abs(this.getX() - tx) > this.availableSpeed() * (double)startSlowingDown) {
            if (tx > this.getX()) {
                return this.availablePropulsion();
            }
            return -this.availablePropulsion();
        }
        double simX = this.getX();
        double speedEpsilon = 0.001;
        double simXSpeed = this.getxSpeed();
        int ms = 64;
        int ticks = 0;
        double horizontalAirFriction = this.horizontalAirFriction();
        while (StrictMath.abs(simXSpeed) > speedEpsilon && ticks++ < 100) {
            double airSlowdownX = simXSpeed * simXSpeed * horizontalAirFriction * (double)ms;
            if (simXSpeed > 0.0) {
                simXSpeed = Math.max(0.0, simXSpeed - airSlowdownX);
            }
            if (simXSpeed < 0.0) {
                simXSpeed = Math.min(0.0, simXSpeed + airSlowdownX);
            }
            simX += simXSpeed * (double)ms;
        }
        double posEpsilon = 3.0;
        if (StrictMath.abs(simX - tx) < posEpsilon) {
            return 0.0;
        }
        if (tx > simX) {
            return this.availablePropulsion();
        }
        return -this.availablePropulsion();
    }

    public double suspendiumForceForY(double ty, boolean hasPreferredDelta, double preferredDelta, double maxSpeed) {
        double f = StrictMath.abs(this.getySpeed()) < StrictMath.max(maxSpeed, 0.15) ? (ty > this.getY() ? (hasPreferredDelta ? StrictMath.max(0.0, (double)this.getMass() * 0.001 - preferredDelta) : (double)this.getMass() * 0.001 * 0.88) : (hasPreferredDelta ? (double)this.getMass() * 0.001 + preferredDelta : (double)this.getMass() * 0.001 / 0.88)) : (double)this.getMass() * 0.001;
        return StrictMath.min(this.availableSuspendiumForce(), f);
    }

    public int availableServiceCeiling() {
        if (this.getMass() == 0) {
            return 0;
        }
        return (int)StrictMath.pow(StrictMath.max(1.0, (double)(this.availableLift() * 400 * 2 / this.getMass() - 400) * 30.0), 0.6666666666666666);
    }

    public int availableServiceCeilingNoFuel() {
        if (this.getMass() == 0) {
            return 0;
        }
        return (int)StrictMath.pow(StrictMath.max(1.0, (double)(this.availableLiftNoFuel() * 400 * 2 / this.getMass() - 400) * 30.0), 0.6666666666666666);
    }

    public int realServiceCeiling() {
        return this.serviceCeiling() - this.getHeight() * 16;
    }

    public int serviceCeiling() {
        if (this.getMass() == 0) {
            return 0;
        }
        return (int)StrictMath.pow(Math.max(1.0, (double)(this.getLift() * 400 * 2 / this.getMass() - 400) * 30.0), 0.6666666666666666);
    }

    public int turningCost() {
        int as = (int)StrictMath.ceil(this.getSpeed());
        if (as == 0) {
            return 0;
        }
        return 5 + this.w * 15 + 500 / as + this.getWeight() / 10;
    }

    public int availableTurningCost() {
        int as = (int)StrictMath.ceil(this.availableSpeed());
        if (as == 0) {
            return 0;
        }
        return 5 + this.w * 15 + 500 / as + this.getWeight() / 10;
    }

    public double getPropulsion() {
        double prop = 0.0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            prop += m.type.getPropulsion(this.currentBonuses);
        }
        return prop;
    }

    public double availablePropulsion() {
        double prop = 0.0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            int li;
            Module m = this.modules.get(mi);
            if (!m.canRun()) continue;
            double p = m.type.getPropulsion(this.currentBonuses);
            if (!m.legs.isEmpty()) {
                int downLegs = 0;
                for (li = 0; li < m.legs.size(); ++li) {
                    if (!m.legs.get((int)li).foot.isDown) continue;
                    ++downLegs;
                }
                if (downLegs == 0) {
                    p = 0.0;
                } else if (downLegs < m.legs.size() - 1) {
                    p /= 2.0;
                }
            }
            if (!m.wheels.isEmpty()) {
                int downWheels = 0;
                for (li = 0; li < m.wheels.size(); ++li) {
                    if (!m.wheels.get((int)li).onGround) continue;
                    ++downWheels;
                }
                if (downWheels == 0) {
                    p = 0.0;
                } else if (downWheels < m.wheels.size() / 2) {
                    p /= 2.0;
                }
            }
            prop += p;
        }
        return prop;
    }

    public double getSpeed() {
        return StrictMath.sqrt(this.getPropulsion() / (double)this.getMass() / this.horizontalAirFriction());
    }

    public double getMainMapSpeed() {
        return this.getSpeed() / (double)(this.type.onGround ? 3 : 1);
    }

    public double availableSpeed() {
        return StrictMath.sqrt(this.availablePropulsion() / (double)this.getMass() / this.horizontalAirFriction());
    }

    public boolean isBuildable(BonusSet boni) {
        for (Module m : this.modules) {
            if (m.type.getRequired() == null || boni.contains[m.type.getRequired().ordinal()]) continue;
            return false;
        }
        for (Tile t : this.tiles) {
            if (t.armour.type.required == null || boni.contains[t.armour.type.required.ordinal()]) continue;
            return false;
        }
        return true;
    }

    public BonusSet getRequiredBonuses() {
        BonusSet boni = new BonusSet();
        for (Module m : this.modules) {
            if (m.type.getRequired() == null) continue;
            boni.add(m.type.getRequired());
        }
        for (Tile t : this.tiles) {
            if (t.armour.type.required == null || boni.contains[t.armour.type.required.ordinal()]) continue;
            boni.add(t.armour.type.required);
        }
        return boni;
    }

    public double groundOffset() {
        double totalSpringConstant = 0.0;
        int springLength = 0;
        for (Module m : this.modules) {
            for (Spring spring : m.type.getSprings()) {
                totalSpringConstant += spring.k;
                springLength = spring.baseLength;
            }
            for (Leg.Spec spec : m.type.getLegSpecs()) {
                totalSpringConstant += spec.spring.k;
                springLength = spec.spring.baseLength;
            }
        }
        if (totalSpringConstant == 0.0) {
            return 0.0;
        }
        return StrictMath.max(0.0, (double)springLength - (double)this.getMass() * 0.001 / totalSpringConstant) * 0.75;
    }

    public int maxCarryWeight() {
        double maxUpwardsForce = 0.0;
        for (Module m : this.modules) {
            if (m.type.getLegSpecs().size() > 1) {
                double legForce = 0.0;
                for (Leg.Spec ls : m.type.getLegSpecs()) {
                    legForce += ls.spring.getMaxForce();
                }
                maxUpwardsForce += (legForce *= ((double)m.type.getLegSpecs().size() - 1.0) / (double)m.type.getLegSpecs().size() * 0.75);
            }
            for (Spring spr : m.type.getSprings()) {
                maxUpwardsForce += spr.getMaxForce();
            }
        }
        return (int)(maxUpwardsForce / 0.001 * 0.6);
    }

    public int optimalCarryWeight() {
        return (int)((double)this.maxCarryWeight() * 0.85);
    }

    public void updateBalancingOnLegs(int ms) {
        double lowestHipRelativeX = 100000.0;
        double highestHipRelativeX = -100000.0;
        double legHeightAccumulator = 0.0;
        int numLegs = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            int lsz = m.legs.size();
            for (int li = 0; li < lsz; ++li) {
                Leg l = m.legs.get(li);
                if (!l.isDown) continue;
                ++numLegs;
                legHeightAccumulator += l.spec.upperLimbLength + l.spec.lowerLimbLength + l.spec.footHeight;
                double hipRelativeX = l.footX() - l.hipX();
                lowestHipRelativeX = StrictMath.min(lowestHipRelativeX, hipRelativeX);
                highestHipRelativeX = StrictMath.max(highestHipRelativeX, hipRelativeX);
            }
        }
        if (numLegs == 0) {
            this.legBalanceFactor *= StrictMath.pow(0.999, ms);
            return;
        }
        if (lowestHipRelativeX <= 0.0 && highestHipRelativeX >= 0.0) {
            this.legBalanceFactor = 1.0;
        } else {
            double bestBalance = StrictMath.min(StrictMath.abs(lowestHipRelativeX), StrictMath.abs(highestHipRelativeX));
            double legHeight = legHeightAccumulator / (double)numLegs;
            this.legBalanceFactor = StrictMath.max(0.0, 1.0 - bestBalance / legHeight);
        }
    }

    @Override
    public boolean canParticleStick(double px, double py) {
        if (!Rect2D.contains(this.getX(), this.getY(), this.getBBWidth(), this.getBBHeight(), px, py)) {
            return false;
        }
        int gx = (int)StrictMath.floor((px - this.getX()) / 16.0);
        int gy = (int)StrictMath.floor((py - this.getY()) / 16.0);
        Tile t = this.tileAt(this.gridXToWorldX(gx, 1), gy);
        return t != null && t.module.type.canParticlesStick();
    }

    public ArrayList<Mod> getUsedMods() {
        ArrayList<Mod> mods = new ArrayList<Mod>();
        for (Module m : this.modules) {
            if (m.type.sourceMod == null || mods.contains(m.type.sourceMod)) continue;
            mods.add(m.type.sourceMod);
        }
        for (Tile t : this.tiles) {
            if (t.armour.type.sourceMod == null || mods.contains(t.armour.type.sourceMod)) continue;
            mods.add(t.armour.type.sourceMod);
        }
        for (Decal d : this.decals) {
            if (d.type.sourceMod == null || mods.contains(d.type.sourceMod)) continue;
            mods.add(d.type.sourceMod);
        }
        return mods;
    }

    public Airship clone() {
        return new Airship(this.toJSON(null));
    }

    public int cheapHash() {
        int h = 7;
        h = h * 31 + new Double(this.getX()).hashCode();
        h = h * 31 + new Double(this.getY()).hashCode();
        h = h * 31 + new Double(this.getxSpeed()).hashCode();
        h = h * 31 + new Double(this.getySpeed()).hashCode();
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            h = h * 37 + this.tiles.get(ti).cheapHash();
        }
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            h = h * 41 + this.modules.get(mi).cheapHash();
        }
        int csz = this.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            h = h * 29 + this.crew.get(ci).cheapHash();
        }
        int bsz = this.boarders.size();
        for (int bi = 0; bi < bsz; ++bi) {
            h = h * 43 + this.boarders.get(bi).cheapHash();
        }
        return h;
    }

    public int getOriginalAmmoCapacity() {
        return this.originalAmmoCapacity == -1 ? this.getAmmoCapacity() : this.originalAmmoCapacity;
    }

    public int getOriginalCoalCapacity() {
        return this.originalCoalCapacity == -1 ? this.getCoalCapacity() : this.originalCoalCapacity;
    }

    public int getOriginalWaterCapacity() {
        return this.originalWaterCapacity == -1 ? this.getWaterCapacity() : this.originalWaterCapacity;
    }

    public int getOriginalRepairCapacity() {
        return this.originalRepairCapacity == -1 ? this.getRepairCapacity() : this.originalRepairCapacity;
    }

    public int getOriginalAllQuartered() {
        return this.originalAllQuartered == -1 ? this.getAllQuartered() : this.originalAllQuartered;
    }

    public strictfp class OverlappingTile {
        public final Tile tile;
        public double dmgMultiplier;

        public OverlappingTile(Tile tile, double dmgMultiplier) {
            this.tile = tile;
            this.dmgMultiplier = dmgMultiplier;
        }
    }

    private strictfp static final class YCmp
    implements Comparator<Module> {
        private YCmp() {
        }

        @Override
        public int compare(Module t, Module t1) {
            return t1.y * 10000 - t.y * 10000 + t1.x - t.x;
        }
    }

    public strictfp static enum MoveMode {
        DEFAULT(false, false),
        FLIP_THEN_MOVE(true, false),
        MOVE_THEN_FLIP(true, true);

        public final boolean override;
        public final boolean flipAtEnd;

        private MoveMode(boolean override, boolean flipAtEnd) {
            this.override = override;
            this.flipAtEnd = flipAtEnd;
        }
    }
}

