/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AddConstructionButton;
import com.zarkonnen.airships.AffordableFilter;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.ConstructionBackend;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MultiplayerSetupIntent;
import com.zarkonnen.airships.PriceInlineInfo;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;

public strictfp class AddMultiplayerConstructionButton
extends UniScreen.Button {
    public final ShipType type;

    public AddMultiplayerConstructionButton(ShipType type) {
        this.type = type;
    }

    @Override
    public boolean visible(UniScreen us) {
        if (!(us.intent instanceof MultiplayerSetupIntent)) {
            return false;
        }
        MultiplayerSetupIntent mpsi = (MultiplayerSetupIntent)us.intent;
        return mpsi.shipTypes.contains((Object)this.type);
    }

    @Override
    public boolean enabled(UniScreen us) {
        return !((MultiplayerSetupIntent)us.intent).readySent && us.tool == UniScreen.NAVIGATE && (!((MultiplayerSetupIntent)us.intent).oneShipOnly || us.setupFleet.size() < 1);
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Add_" + this.type.name(), new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        MultiplayerSetupIntent msi = (MultiplayerSetupIntent)us.intent;
        BonusSet bonuses = msi.techTier == 100000 ? Tech.getStandardBonuses() : Tech.getBonusesForTier(msi.techTier);
        ShipHelperWidget shw = ShipHelperWidget.get(this.type, us.g.getBestCOA(), bonuses, null, 0);
        boolean flipped = ((MultiplayerSetupIntent)us.intent).flipped ^ !this.type.mobile;
        ConstructionBackend cbe = ShipEditorUtils.shipsList(this.type, shw);
        FileScreen fs = new FileScreen(cbe, new AddConstructionButton.AddMission(us.g, us, flipped, null, ((MultiplayerSetupIntent)us.intent).flipped ? 1 : 0, this.type, cbe), shw, new PriceInlineInfo(shw, null), this.type.name());
        fs.enabledFilter = new AffordableFilter(msi.remainingBudget(us), shw, null);
        us.g.s = fs;
    }
}

