/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.EditMissionIntent;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MonsterBackend;
import com.zarkonnen.airships.MonsterHelperWidget;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public strictfp class AddMonsterButton
extends UniScreen.Button {
    @Override
    public boolean visible(UniScreen us) {
        return us.intent instanceof EditMissionIntent;
    }

    @Override
    public String text(UniScreen us) {
        if (us.tool instanceof PlaceShipTool) {
            return Lang._t("Cancel", new Object[0]);
        }
        return Lang._t("Add_monster", new Object[0]);
    }

    @Override
    public boolean gold(UniScreen us) {
        if (!(us.intent instanceof EditMissionIntent)) {
            return false;
        }
        return us.combat.sides.get((int)0).ships.isEmpty() || us.combat.sides.get((int)1).ships.isEmpty();
    }

    @Override
    public void click(Input in, UniScreen us) {
        if (us.tool instanceof PlaceShipTool) {
            us.tool = UniScreen.NAVIGATE;
        } else {
            MonsterBackend mbe = new MonsterBackend();
            FileScreen fs = new FileScreen(mbe, new AddMission(us.g, us, mbe), new MonsterHelperWidget(mbe), new FileScreen.NoInfo(mbe), "monsters");
            us.g.s = fs;
        }
    }

    public strictfp static class AddMission
    implements FileScreen.Mission {
        private final AirshipGame g;
        private final UniScreen us;
        private final MonsterBackend backend;

        public AddMission(AirshipGame g, UniScreen us, MonsterBackend backend) {
            this.g = g;
            this.us = us;
            this.backend = backend;
        }

        @Override
        public FileScreen.Mode mode() {
            return FileScreen.Mode.OPEN;
        }

        @Override
        public String text() {
            return Lang._t("Add_monster", new Object[0]);
        }

        @Override
        public String fileSelectionText() {
            return Lang._t("Add", new Object[0]);
        }

        @Override
        public String initialInput() {
            return "";
        }

        @Override
        public void fileSelected(String path) {
            File f = this.backend.getFile(FileScreen.splitPath(path));
            if (f != null && f.exists()) {
                try {
                    Airship s = new Airship(new JSONObject(FileUtils.readFileToString((File)f, (String)"UTF-8")));
                    s.repair();
                    PlaceShipTool pst = new PlaceShipTool(s, null, -1, false);
                    pst.multiPlace = true;
                    this.us.tool = pst;
                }
                catch (Exception e) {
                    this.g.showError(Lang._t("Unable_to_load_monster", new Object[0]));
                    e.printStackTrace();
                }
            }
            this.g.s = this.us;
        }

        @Override
        public void cancelled() {
            this.g.s = this.us;
        }
    }
}

